/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.cellular;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.dmasystems.AbstractDmaSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterfererResultCollector;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.ofdma.DownlinkOfdmaMobile;
import org.seamcat.ofdma.DownlinkOfdmaSystem;
import org.seamcat.simulation.cellular.CellularVictimSystemSimulation;
import org.seamcat.simulation.cellular.OFDMADownLinkVictim;
import org.seamcat.simulation.result.VectorDefImpl;

public class OFDMADownLinkVictimSystemSimulation
extends CellularVictimSystemSimulation {
    public static VectorDef FREQUENCY_ALL = OFDMADownLinkVictimSystemSimulation.iv("Frequency (all)", "MHz");
    public static VectorDef FREQUENCY = OFDMADownLinkVictimSystemSimulation.iv("Frequency (ref. cell)", "MHz");
    public static VectorDef BIT_RATE_ACHIEVED_ALL = OFDMADownLinkVictimSystemSimulation.iv("Bitrate achieved (all)", "kbps");
    public static VectorDef BIT_RATE_ACHIEVED = OFDMADownLinkVictimSystemSimulation.iv("Bitrate achieved (ref. cell)", "kbps");
    public static VectorDef RECEIVED_POWER_ALL = OFDMADownLinkVictimSystemSimulation.iv("Received power (all)", "dBm");
    public static VectorDef RECEIVED_POWER = OFDMADownLinkVictimSystemSimulation.iv("Received power (ref. cell)", "dBm");
    public static VectorDef SINR_ACHIEVED_ALL = OFDMADownLinkVictimSystemSimulation.iv("SINR achieved (all)", "dB");
    public static VectorDef SINR_ACHIEVED = OFDMADownLinkVictimSystemSimulation.iv("SINR achieved (ref. cell)", "dB");
    public static VectorDef PATH_LOSS_ALL = OFDMADownLinkVictimSystemSimulation.iv("Path loss (all)", "dB");
    public static VectorDef PATH_LOSS = OFDMADownLinkVictimSystemSimulation.iv("Path loss (ref. cell)", "dB");
    public static VectorDef EFFECTIVE_PATH_LOSS_ALL = OFDMADownLinkVictimSystemSimulation.iv("Effective path loss (all)", "dB");
    public static VectorDef EFFECTIVE_PATH_LOSS = OFDMADownLinkVictimSystemSimulation.iv("Effective path loss (ref. cell)", "dB");
    public static VectorDef INTERFERENCE_POWER_ALL = OFDMADownLinkVictimSystemSimulation.iv("Interference power (all)", "dBm");
    public static VectorDef INTERFERENCE_POWER = OFDMADownLinkVictimSystemSimulation.iv("Interference power (ref. cell)", "dBm");
    public static VectorDef CURRENT_TRANSMIT_POWER_ALL = OFDMADownLinkVictimSystemSimulation.iv("Current transmit power (all)", "dBm");
    public static VectorDef CURRENT_TRANSMIT_POWER = OFDMADownLinkVictimSystemSimulation.iv("Current transmit power (ref. cell)", "dBm");
    public static VectorDef BASE_STATION_BIT_RATE_ALL = OFDMADownLinkVictimSystemSimulation.iv("Base station bit rate (all)", "dBm");
    public static VectorDef BASE_STATION_BIT_RATE = OFDMADownLinkVictimSystemSimulation.iv("Base station bit rate (ref. cell)", "dBm");
    public static VectorDef INTER_SYSTEM_INTERFERENCE_ALL = OFDMADownLinkVictimSystemSimulation.iv("Inter system interference (all)", "dBm");
    public static VectorDef INTER_SYSTEM_INTERFERENCE = OFDMADownLinkVictimSystemSimulation.iv("Inter system interference (ref. cell)", "dBm");

    private static VectorDef iv(String name, String unit) {
        return Factory.results().intermediateValue(name, unit);
    }

    public OFDMADownLinkVictimSystemSimulation(Scenario scenario, AbstractDmaSystem dmaSystem) {
        super(scenario, dmaSystem);
    }

    @Override
    public AbstractDmaSystem getVictim() {
        AbstractDmaSystem victim = (AbstractDmaSystem)victimSystem.get();
        if (victim == null) {
            victim = new DownlinkOfdmaSystem(this.dmaSystem);
            victimSystem.set(victim);
        }
        return victim;
    }

    @Override
    public void simulate(VictimResultCollector collector) {
        super.simulate(collector);
        DownlinkOfdmaSystem system = (DownlinkOfdmaSystem)this.getVictim();
        double _averageAchievedBitrate = system.calculateAverageAchievedBitrate();
        this.add(collector, avgAchievedBitRateSystem, "kbps", _averageAchievedBitrate);
        collector.add(initialVictimOutage, system.getReferenceCellMeasurement());
        for (DownlinkOfdmaMobile mobile : system.getAllActiveUsers()) {
            collector.add(new OFDMADownLinkVictim(mobile));
        }
        LinkedHashMap<VectorDef, List<Double>> vectors = new LinkedHashMap<VectorDef, List<Double>>();
        List<AbstractDmaBaseStation> allBaseStations = system.getAllBaseStations();
        for (AbstractDmaBaseStation abstractDmaBaseStation : allBaseStations) {
            for (AbstractDmaLink link : abstractDmaBaseStation.getOldTypeActiveConnections()) {
                this.handle(vectors, false, link);
            }
        }
        for (AbstractDmaLink abstractDmaLink : system.getReferenceCell().getOldTypeActiveConnections()) {
            this.handle(vectors, true, abstractDmaLink);
        }
        for (Map.Entry entry : vectors.entrySet()) {
            collector.add((VectorDef)entry.getKey(), (List)entry.getValue());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Average achieved bit rate (initial): " + _averageAchievedBitrate + " kbps");
            LOG.debug("Initial Victim Capacity = " + system.getNumberOfActiveServedMobilesInReferenceCell() + " users in reference cell");
            LOG.debug("Initial Victim Outage = " + collector.get(initialVictimOutage) + "% in reference cell");
        }
    }

    @Override
    public void simulateWithInterference(EventResult eventResult, VictimResultCollector vCollector, List<InterfererResultCollector> iCollector) {
        DownlinkOfdmaSystem system = (DownlinkOfdmaSystem)this.getVictim();
        double bitrateSum = 0.0;
        double bitrateRefCellSum = 0.0;
        double sinrSum = 0.0;
        double sinrRefCellSum = 0.0;
        int refcellCount = 0;
        int size = vCollector.getVictims().size();
        for (Victim victim : vCollector.getVictims()) {
            OFDMADownLinkVictim vi = (OFDMADownLinkVictim)victim;
            double sinr = vi.calculateInterferedSINRWatt();
            double bitrate = vi.calculateAchievedBitrate(system, Mathematics.linear2dB(sinr));
            bitrateSum += bitrate;
            if (vi.isConnectedToReferenceCell()) {
                sinrRefCellSum += sinr;
                ++refcellCount;
                bitrateRefCellSum += bitrate;
            }
            sinrSum += sinr;
        }
        double averageAchievedBitrate = bitrateSum / (double)system.getNumberOfBaseStations();
        this.add(vCollector, avgInterferedBitRateSystem, "kbps", averageAchievedBitrate);
        double avg = size == 0 ? 0.0 : sinrSum / (double)size;
        vCollector.add((VectorDef)new VectorDefImpl(sinrVictimSystem, "dB", false), Mathematics.linear2dB(avg));
        double avgSINRRefcell = refcellCount == 0 ? 0.0 : sinrRefCellSum / (double)refcellCount;
        vCollector.add((VectorDef)new VectorDefImpl(sinrRefCell, "dB", false), Mathematics.linear2dB(avgSINRRefcell));
        double refCellBitrate = bitrateRefCellSum;
        this.add(vCollector, "Interfered Bitrate, ref. cell", "kbps", refCellBitrate);
    }

    @Override
    public List<Victim> getResultingVictims(VictimResultCollector vCollector) {
        ArrayList<Victim> relevantVictims = new ArrayList<Victim>();
        for (Victim victim : vCollector.getVictims()) {
            if (!((OFDMADownLinkVictim)victim).isConnectedToReferenceCell()) continue;
            relevantVictims.add(victim);
        }
        return relevantVictims;
    }
}

