/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.coverageradius;

import org.apache.log4j.Logger;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.coverageradius.CoverageRadiusPlugin;
import org.seamcat.model.plugin.coverageradius.NoiseLimitedInput;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.propagation.Stats;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.simulation.generic.GenericSystemPlugin;

public class NoiseLimitedCoverageRadius
implements CoverageRadiusPlugin<NoiseLimitedInput> {
    private static final Logger LOG = Logger.getLogger(NoiseLimitedCoverageRadius.class);

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, NoiseLimitedInput input, Validator validator) {
    }

    @Override
    public double evaluate(SystemPlugin plugin, RadioSystem system, NoiseLimitedInput input) {
        double rLogR;
        double rL;
        double rRmax;
        GenericSystemPlugin pl = (GenericSystemPlugin)plugin;
        PropagationModel propagationModel = system.getPropagationModel();
        double rFadingStdDev = input.fadingStdDev();
        double rAvailability = input.availability() / 100.0;
        double rRefAntHeightVr = input.rxAntennaHeight();
        double rRefAntHeightWt = input.txAntennaHeight();
        double rFrequencyVr = input.frequency();
        double rSens = pl.getSensitivity();
        double rPeakGainVr = system.getReceiver().getAntennaGain().peakGain();
        double rPeakGainWt = system.getTransmitter().getAntennaGain().peakGain();
        double rMaxDist = input.maxDistance() * 1000.0;
        double rMinDist = input.minDistance() * 1000.0;
        if (rMinDist == 0.0) {
            rMinDist = 1.0;
        }
        if (rMaxDist == 0.0) {
            rMaxDist = 1.0;
        }
        double rRefPower = input.txPower();
        double rFadingLoss = -Stats.qi(rAvailability) * rFadingStdDev;
        double rR = 0.0;
        double rDR = 0.0;
        int i = 0;
        double rR1 = rMinDist;
        double rR2 = rMaxDist;
        double rLogR1 = Math.log10(rR1);
        double rLogR2 = Math.log10(rR2);
        LinkResult result = Factory.results().linkResult(system, rFrequencyVr);
        result.setTxRxDistance(rR1 / 1000.0);
        result.txAntenna().setHeight(rRefAntHeightWt);
        result.rxAntenna().setHeight(rRefAntHeightVr);
        double rL1 = rRefPower + rPeakGainWt + rPeakGainVr - rSens - rFadingLoss - propagationModel.evaluate(result, false);
        result.setTxRxDistance(rR2 / 1000.0);
        double rL2 = rRefPower + rPeakGainWt + rPeakGainVr - rSens - rFadingLoss - propagationModel.evaluate(result, false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("R1 = MinDist = " + rMinDist);
            LOG.debug("R2 = MaxDist = " + rMaxDist);
            LOG.debug("L1 = rRefPower + rPeakGainWt + rPeakGainVr - rSens - rFadingLoss - " + propagationModel.getClass() + ".medianLoss(rFrequencyVr,rR1 / KMTOM, rRefAntHeightWt, rRefAntHeightVr, rPeakGainWt, rPeakGainVr) -> " + rL1 + " = " + rRefPower + " + " + rPeakGainWt + " + " + rPeakGainVr + " - " + rSens + " - " + rFadingLoss + " - " + propagationModel.getClass() + ".medianLoss(" + rFrequencyVr + "," + rR1 / 1000.0 + "," + rRefAntHeightWt + "," + rRefAntHeightVr + ")");
            LOG.debug("L2 = rRefPower + rPeakGainWt + rPeakGainVr - rSens - rFadingLoss - " + propagationModel.getClass() + ".medianLoss(rFrequencyVr,rR2 / KMTOM, rRefAntHeightWt, rRefAntHeightVr, rPeakGainWt, rPeakGainVr) -> " + rL2 + " = " + rRefPower + " + " + rPeakGainWt + " + " + rPeakGainVr + " - " + rSens + " - " + rFadingLoss + " - " + propagationModel.getClass() + ".medianLoss(" + rFrequencyVr + "," + rR2 / 1000.0 + "," + rRefAntHeightWt + "," + rRefAntHeightVr + ")");
        }
        if (rL1 * rL2 >= 0.0) {
            rRmax = rMaxDist / 1000.0;
        } else if (rL1 > 0.0) {
            rL = rL1;
            rL1 = rL2;
            rL2 = rL;
            rLogR = rLogR1;
            rLogR1 = rLogR2;
            rLogR2 = rLogR;
            rR = rR1;
            rR1 = rR2;
            rR2 = rR;
        }
        for (i = 0; i < 1000; ++i) {
            rLogR = rLogR1 + (rLogR2 - rLogR1) * rL1 / (rL1 - rL2);
            rR = Math.pow(10.0, rLogR);
            result.setTxRxDistance(rR / 1000.0);
            rL = rRefPower + rPeakGainWt + rPeakGainVr - rSens - rFadingLoss - propagationModel.evaluate(result, false);
            if (rL < 0.0) {
                rDR = rL1 - rL;
                rL1 = rL;
                rR1 = rR;
                rLogR1 = rLogR;
            } else {
                rDR = rL2 - rL;
                rL2 = rL;
                rR2 = rR;
                rLogR2 = rLogR;
            }
            if (Math.abs(rDR) < 0.1 || rL == 0.0) break;
        }
        rRmax = rR / 1000.0;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Transceiver name: " + system.toString());
            LOG.debug("FadingStdDev = " + rFadingStdDev);
            LOG.debug("Availability = " + rAvailability);
            LOG.debug("RefAntHeightWt = " + rRefAntHeightWt);
            LOG.debug("RefAntHeightVr = " + rRefAntHeightVr);
            LOG.debug("FrequencyVr = " + rFrequencyVr);
            LOG.debug("Sensitivity = " + rSens);
            LOG.debug("PeakGainVr = " + rPeakGainVr);
            LOG.debug("PeakGainWt = " + rPeakGainWt);
            LOG.debug("MaxDist = " + rMaxDist);
            LOG.debug("MinDist = " + rMinDist);
            LOG.debug("RefPower = " + rRefPower);
            LOG.debug("FadingLoss = -Stats.qi(Availability) * FadingStdDev = " + rFadingLoss + " = " + -Stats.qi(rAvailability) + " * " + rFadingStdDev);
            LOG.debug("Coverage Radius (Noise Limited) = " + rRmax);
        }
        return rRmax;
    }

    @Override
    public Description description() {
        return new DescriptionImpl("Noise Limited", "The coverage of the transmitter is limited only by propagation losses and other elements of link budget, with received signal operating at the very sensitivity limit.");
    }
}

