/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.coverageradius;

import org.apache.log4j.Logger;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.plugin.coverageradius.CoverageRadiusPlugin;
import org.seamcat.model.plugin.coverageradius.TrafficLimitedInput;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.simulation.generic.GenericSystemPlugin;

public class TrafficLimitedNetworkCoverageRadius
implements CoverageRadiusPlugin<TrafficLimitedInput> {
    private static final Logger LOG = Logger.getLogger(TrafficLimitedNetworkCoverageRadius.class);

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, TrafficLimitedInput input, Validator validator) {
    }

    @Override
    public double evaluate(SystemPlugin plugin, RadioSystem system, TrafficLimitedInput input) {
        double densityTx = ((GenericSystemPlugin)plugin).getTransmitterDensity().getDensityTx();
        double rRmax = Math.sqrt((double)(input.numberOfChannels() * input.numberOfUsers()) / (Math.PI * densityTx * (double)input.frequencyCluster()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Transceiver name: " + system.toString());
            LOG.debug("Density = " + densityTx);
            LOG.debug("NumberOfChannels = " + input.numberOfChannels());
            LOG.debug("Number of users per channel = " + input.numberOfUsers());
            LOG.debug("Frequency cluster = " + input.frequencyCluster());
            LOG.debug("Coverage Radius (Traffic Limited) = " + rRmax);
        }
        return rRmax;
    }

    @Override
    public Description description() {
        return new DescriptionImpl("Traffic Limited", "The coverage radius is derived from the traffic parameters of the transmitter, i.e. the maximum number of active transmitter per km2 (density), as defined in \u201cTransmitter Density and Traffic\u201d the number of frequency channels that a radio system provides, the number of MS per frequency channel provided by a radio system and the size of a group of frequency channels (frequency cluster).");
    }
}

