/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.generic;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.distributions.ConstantDistributionImpl;
import org.seamcat.model.distributions.DiscreteUniformDistributionImpl;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.distributions.StairDistributionImpl;
import org.seamcat.model.distributions.UniformDistribution;
import org.seamcat.model.distributions.UniformDistributionImpl;
import org.seamcat.model.distributions.UserDefinedDistributionImpl;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.Direction;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.InterfererResultCollector;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.MultiValueDef;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.model.types.Transmitter;
import org.seamcat.model.types.result.BarChartValue;
import org.seamcat.simulation.generic.EIRPFrequencyValue;
import org.seamcat.simulation.generic.GenericSystemPlugin;
import org.seamcat.simulation.generic.GenericSystemSimulation;
import org.seamcat.simulation.generic.SensingLink;
import org.seamcat.simulation.result.SensingLinkResult;
import org.seamcat.simulation.result.VectorDefImpl;

public class CognitiveRadio {
    public static final UniqueValueDef NORMALIZED_EIRP_INBLOCK = Factory.results().function("Normalized EIRP in-block limit", "", "");
    public static final MultiValueDef SENSING_LINK = Factory.results().multi("Sensing link", "km", "km");
    private static Logger LOG = Logger.getLogger(CognitiveRadio.class);
    private final List<InterferenceLink> crLinks;
    private final UniformDistribution random;
    private Scenario scenario;
    private RadioSystem victimSystem;
    private GenericSystemPlugin plugin;
    private double[] rsRSSFrequency;
    public static String CRV_SRSS = "sRSS";
    public static String CRV_WSD_F = "WSD frequency";
    public static String CRV_WSD_EIRP = "WSD EIRP";
    public static String CRV_VIC_FREQ = "Victim frequency";
    private static MultiValueDef CRV_AVG_EIRP = Factory.results().multi("Average EIRP per event x active WSDs (for each frequency)", "Frequency (MHz)", "dBm");
    private static MultiValueDef CRV_AVG_ACT = Factory.results().multi("Average Active WSD per event (for each frequency)", "Frequency (MHz)", "Number of active WSDs");

    public CognitiveRadio(Scenario scenario, RadioSystem victimSystem) {
        this.scenario = scenario;
        this.plugin = (GenericSystemPlugin)scenario.getVictim().getSystemPlugin();
        this.victimSystem = victimSystem;
        this.initChannels();
        this.random = Factory.distributionFactory().getUniformDistribution(0.0, 1.0);
        this.crLinks = this.getCRLinks(scenario);
    }

    public void cognitiveRadio(EventResult result, VictimResultCollector vCollector, List<InterfererResultCollector> iCollector) {
        boolean[] rsRSSavailableChannel = new boolean[this.rsRSSFrequency.length];
        double[] rsRSSValue = new double[this.rsRSSFrequency.length];
        int crCount = 0;
        for (InterferenceLink iLink : this.crLinks) {
            for (InterferenceLinkResult linkResult : result.getInterferenceLinkResult(iLink)) {
                EIRPFrequencyValue selectedWSD;
                boolean sensingFailure;
                GenericSystemPlugin plugin = (GenericSystemPlugin)iLink.getInterferer().getSystemPlugin();
                Transmitter gt = iLink.getInterferer().getSystem().getTransmitter();
                SensingLink sensingLink = plugin.getSensingLink();
                InterfererResultCollector systemResult = result.getInterferingSystemResult(iLink);
                SensingLinkResult sLink = new SensingLinkResult();
                systemResult.add(SENSING_LINK, sLink);
                sLink.setFrequency(linkResult.getFrequency());
                sLink.txAntenna().setPosition(linkResult.getInterferingSystemLink().txAntenna().getPosition());
                sLink.txAntenna().setHeight(linkResult.getInterferingSystemLink().txAntenna().getHeight());
                sLink.rxAntenna().setPosition(linkResult.getVictimSystemLink().txAntenna().getPosition());
                sLink.rxAntenna().setHeight(linkResult.getVictimSystemLink().txAntenna().getHeight());
                sLink.assignLocalEnvironment(gt.getLocalEnvironments(), Direction.To_TX);
                sLink.assignLocalEnvironment(iLink.getVictim().getSystem().getTransmitter().getLocalEnvironments(), Direction.To_RX);
                CognitiveRadio.sensingTrial(sLink, linkResult);
                Function detectionThreshold = sensingLink.getDetectionThreshold();
                int availableChannels = this.rsRSSFrequency.length;
                LinkResult victimLink = linkResult.getVictimSystemLink();
                LOG.debug(String.format("There are %d potential WSD channels", this.rsRSSFrequency.length));
                double vrFreq = victimLink.getFrequency();
                boolean modePropagationVariation = true;
                double pathLoss = 0.0;
                double itFreq = 0.0;
                for (int x = 0; x < this.rsRSSFrequency.length; ++x) {
                    double dFreq;
                    double detectionThresholdEval;
                    double sRSS;
                    itFreq = this.rsRSSFrequency[x];
                    if (modePropagationVariation) {
                        pathLoss = CognitiveRadio.calculatePathLoss(sLink, sensingLink, itFreq);
                    }
                    boolean bl = rsRSSavailableChannel[x] = (sRSS = CognitiveRadio.getSRSS(sLink, iLink, (MaskFunction)vCollector.getFunction(Transmitter.NORMALIZED_EMISSION_MASK), victimLink, itFreq, pathLoss)) < (detectionThresholdEval = detectionThreshold.evaluate(dFreq = itFreq - vrFreq));
                    if (!rsRSSavailableChannel[x]) {
                        --availableChannels;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Evaluating sRSS<detectionThreshold for frequency %f MHz = (%f<%f) ", itFreq, sRSS, detectionThresholdEval));
                        LOG.debug(String.format("sRSS < detectionThreshold = %s", Boolean.toString(rsRSSavailableChannel[x]).toUpperCase()));
                    }
                    rsRSSValue[x] = sRSS;
                    modePropagationVariation = false;
                }
                LOG.debug(String.format("There are %d available WSD channels", availableChannels));
                boolean bl = sensingFailure = this.random.trial() * 100.0 < sensingLink.getProbabilityOfFailure();
                if (LOG.isDebugEnabled()) {
                    double failureProb = sensingLink.getProbabilityOfFailure();
                    LOG.debug(String.format("Sensing failure feature is %s", failureProb > 0.0 ? "ENABLED" : "DISABLED"));
                    if (failureProb > 0.0) {
                        LOG.debug(String.format("Sensing failure probability is %f pct", failureProb));
                    }
                }
                boolean isActive = false;
                if (sensingFailure) {
                    itFreq = this.rsRSSFrequency[0];
                    pathLoss = CognitiveRadio.calculatePathLoss(sLink, sensingLink, itFreq);
                    selectedWSD = new EIRPFrequencyValue(vrFreq, linkResult.getInterferingSystemLink().getTxPower() + iLink.getInterferer().getSystem().getTransmitter().getAntennaGain().peakGain(), CognitiveRadio.getSRSS(sLink, iLink, (MaskFunction)vCollector.getFunction(Transmitter.NORMALIZED_EMISSION_MASK), victimLink, vrFreq, pathLoss));
                    isActive = true;
                    LOG.debug("Sensing failure detected. Using max power and frequency of victim");
                } else if (availableChannels == this.rsRSSFrequency.length) {
                    int selectedFreqIndex = (int)(this.random.trial() * (double)this.rsRSSFrequency.length);
                    selectedWSD = new EIRPFrequencyValue(this.rsRSSFrequency[selectedFreqIndex], linkResult.getInterferingSystemLink().getTxPower() + iLink.getInterferer().getSystem().getTransmitter().getAntennaGain().peakGain(), rsRSSValue[selectedFreqIndex]);
                    isActive = true;
                } else if (availableChannels > 0) {
                    EIRPFrequencyValue[] availableChannelEIRP = new EIRPFrequencyValue[availableChannels];
                    MaskFunction eIRPInBlock = null;
                    for (InterfererResultCollector collector : iCollector) {
                        if (collector.getLink() != iLink) continue;
                        eIRPInBlock = (MaskFunction)collector.getFunction(NORMALIZED_EIRP_INBLOCK);
                    }
                    int availableChannelIndex = 0;
                    for (int x = 0; x < this.rsRSSFrequency.length; ++x) {
                        if (!rsRSSavailableChannel[x]) continue;
                        availableChannelEIRP[availableChannelIndex] = new EIRPFrequencyValue(this.rsRSSFrequency[x], Double.MAX_VALUE, rsRSSValue[x]);
                        for (int y = 0; y < this.rsRSSFrequency.length; ++y) {
                            if (rsRSSavailableChannel[y]) continue;
                            double freqOffset = this.rsRSSFrequency[x] - this.rsRSSFrequency[y];
                            double eirp = eIRPInBlock.evaluate(freqOffset);
                            availableChannelEIRP[availableChannelIndex].setEirp(Math.min(eirp += 10.0 * Math.log10(this.victimSystem.getReceiver().getBandwidth()), availableChannelEIRP[availableChannelIndex].getEirp()));
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(String.format("Min EIRP for %f MHz is %f dBm", availableChannelEIRP[availableChannelIndex].getFrequency(), availableChannelEIRP[availableChannelIndex].getEirp()));
                        }
                        ++availableChannelIndex;
                    }
                    EIRPFrequencyValue[] bestEIRPFreq = Mathematics.sortBest(availableChannelEIRP);
                    selectedWSD = bestEIRPFreq.length > 1 ? bestEIRPFreq[(int)(this.random.trial() * (double)bestEIRPFreq.length)] : bestEIRPFreq[0];
                    selectedWSD.setEirp(Math.min(selectedWSD.getEirp(), linkResult.getInterferingSystemLink().getTxPower() + iLink.getInterferer().getSystem().getTransmitter().getAntennaGain().peakGain()));
                    isActive = true;
                } else {
                    int x;
                    double sRSS;
                    block23: {
                        sRSS = Double.NaN;
                        double victimBW = iLink.getVictim().getSystem().getReceiver().getBandwidth() / 2.0;
                        for (x = 0; x < this.rsRSSFrequency.length; ++x) {
                            double freq = this.rsRSSFrequency[x];
                            if (!(vrFreq > freq - victimBW) || !(vrFreq < freq + victimBW)) {
                                continue;
                            }
                            break block23;
                        }
                        throw new RuntimeException("Could not find WSD channel for victim frequency");
                    }
                    sRSS = rsRSSValue[x];
                    selectedWSD = new EIRPFrequencyValue(vrFreq, -1000.0, sRSS);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Selected EIRP is %f dBm and freq is %f", selectedWSD.getEirp(), selectedWSD.getFrequency()));
                }
                double sensitivity = plugin.getSensitivity();
                if (result.getVictimResult().get(GenericSystemPlugin.DRSS) > sensitivity && isActive) {
                    vCollector.add(CRV_AVG_EIRP, new BarChartValue("" + selectedWSD.getFrequency(), selectedWSD.getEirp()));
                    for (double freq : this.rsRSSFrequency) {
                        vCollector.add(CRV_AVG_ACT, new BarChartValue("" + freq, Mathematics.equals(freq, selectedWSD.getFrequency(), 0.001) ? 1.0 : 0.0));
                    }
                }
                String name = "WSD " + crCount;
                vCollector.add((VectorDef)new VectorDefImpl(CRV_SRSS, name, "dBm", false), selectedWSD.getsRSS());
                vCollector.add((VectorDef)new VectorDefImpl(CRV_WSD_F, name, "MHz", false), selectedWSD.getFrequency());
                vCollector.add((VectorDef)new VectorDefImpl(CRV_WSD_EIRP, name, "dBm", false), selectedWSD.getEirp());
                vCollector.add((VectorDef)new VectorDefImpl(CRV_VIC_FREQ, name, "MHz", false), vrFreq);
                sLink.setTxRxPathLoss(pathLoss);
                linkResult.getInterferingSystemLink().setTxPower(selectedWSD.getEirp() - gt.getAntennaGain().peakGain());
                linkResult.getInterferingSystemLink().setFrequency(selectedWSD.getFrequency());
                ++crCount;
            }
        }
    }

    private List<InterferenceLink> getCRLinks(Scenario scenario) {
        ArrayList<InterferenceLink> result = new ArrayList<InterferenceLink>();
        for (InterferenceLink link : scenario.getInterferenceLinks()) {
            GenericSystemPlugin pl;
            if (!(link.getInterferer().getSystemPlugin() instanceof GenericSystemPlugin) || !(pl = (GenericSystemPlugin)link.getInterferer().getSystemPlugin()).isInterfererCognitiveRadio()) continue;
            result.add(link);
        }
        return result;
    }

    private void initChannels() {
        Distribution frequencyDist = this.scenario.getVictim().getFrequency();
        ArrayList<Object> frequencies = new ArrayList<Object>();
        if (frequencyDist instanceof UserDefinedDistributionImpl || frequencyDist instanceof UniformDistributionImpl || frequencyDist instanceof ConstantDistributionImpl || frequencyDist instanceof DiscreteUniformDistributionImpl) {
            BigDecimal bandwidth;
            Bounds bounds = frequencyDist.getBounds();
            Object frequency = new BigDecimal(bounds.getMin());
            double max = bounds.getMax();
            if (frequencyDist instanceof DiscreteUniformDistributionImpl) {
                bandwidth = new BigDecimal(((DiscreteUniformDistributionImpl)frequencyDist).getStep());
                frequency = ((BigDecimal)frequency).add(bandwidth.divide(new BigDecimal(2)));
            } else {
                bandwidth = new BigDecimal(this.victimSystem.getReceiver().getBandwidth());
            }
            do {
                frequencies.add(frequency);
            } while (((BigDecimal)(frequency = ((BigDecimal)frequency).add(bandwidth))).doubleValue() <= max);
        } else if (frequencyDist instanceof StairDistributionImpl) {
            DiscreteFunction cdf = (DiscreteFunction)((StairDistributionImpl)frequencyDist).getCdf();
            for (Point2D p : cdf.points()) {
                frequencies.add(new BigDecimal(p.getX()));
            }
        } else {
            throw new IllegalStateException("Unsupported frequency distribution in victimlink (for cognitive radio interferers): " + (frequencyDist != null ? frequencyDist.getClass().getName() : "null"));
        }
        this.rsRSSFrequency = new double[frequencies.size()];
        int stop = frequencies.size();
        for (int x = 0; x < stop; ++x) {
            this.rsRSSFrequency[x] = ((BigDecimal)frequencies.get(x)).doubleValue();
        }
    }

    private static double calculatePathLoss(LinkResult sensingLinkResult, SensingLink sensingLink, double rFreq) {
        PropagationModel propagationModel = sensingLink.getPropagationModel();
        sensingLinkResult.setFrequency(rFreq);
        return propagationModel.evaluate(sensingLinkResult);
    }

    private static double getSRSS(LinkResult sensingResult, InterferenceLink il, MaskFunction wtUnwantedEmission, LinkResult link, double wsdFreq, double pathLoss) {
        double wtPower = CognitiveRadio.powerCalculation(il, wtUnwantedEmission, link, wsdFreq);
        double sRSS = wtPower + sensingResult.txAntenna().getGain() - pathLoss + sensingResult.rxAntenna().getGain();
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Calculating sRSS %f + %f -%f + %f = %f", wtPower, sensingResult.txAntenna().getGain(), pathLoss, sensingResult.rxAntenna().getGain(), sRSS));
        }
        return sRSS;
    }

    private static double powerCalculation(InterferenceLink il, MaskFunction wtUnwantedEmission, LinkResult link, double wsdFreq) {
        double rWtPower = link.getTxPower();
        double rWtUnwantedEmissionRel = CognitiveRadio.wtUnwantedEmissions(wtUnwantedEmission, link, il, wsdFreq);
        double wtUnwantedEmissionAbs = rWtPower + rWtUnwantedEmissionRel;
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Victim Link Transmitter Tx Power trial = %f", rWtPower));
            LOG.debug(String.format("Absolute Unwanted Emission at WT = wtPower + RelUnwanted + wtPower Gain = %f", wtUnwantedEmissionAbs));
        }
        if (il.getVictim().getSystem().getTransmitter().isUsingEmissionsFloor()) {
            double rWtUnwantedReference = CognitiveRadio.wtUnwantedReference(link, il, wsdFreq);
            wtUnwantedEmissionAbs = Math.max(wtUnwantedEmissionAbs, rWtUnwantedReference);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using unwanted emission floor at the Wt");
                LOG.debug(String.format("Wt Absolute Unwanted Emission = MAX(Abs Unwanted, Ref Unwanted) = %f", wtUnwantedEmissionAbs));
            }
        }
        return wtUnwantedEmissionAbs;
    }

    private static double wtUnwantedReference(LinkResult link, InterferenceLink il, double rFreqIt) {
        double rFreqWt = link.getFrequency();
        GenericSystemPlugin plugin = (GenericSystemPlugin)il.getInterferer().getSystemPlugin();
        double rItBandwidth = plugin.getSensingLink().getBandwidth() / 1000.0;
        MaskFunction unWantedReference = il.getVictim().getSystem().getTransmitter().getEmissionsFloor();
        double rResult = unWantedReference.integrate(rFreqIt - rFreqWt, rItBandwidth);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Victim Link Transmitter Frequency = " + rFreqWt);
            LOG.debug("It Receiver Frequency = " + rFreqIt);
            LOG.debug("It Receiver Bandwith = " + rItBandwidth);
            LOG.debug(String.format("Reference Unwanted Emission = .integrate((ItFreq - WtFreq), ItBandwith) = %f dBc", rResult));
        }
        return rResult;
    }

    private static double wtUnwantedEmissions(MaskFunction wtUnwantedEmission, LinkResult link, InterferenceLink il, double rFreqIt) {
        double rFreqWt = link.getFrequency();
        GenericSystemPlugin plugin = (GenericSystemPlugin)il.getInterferer().getSystemPlugin();
        double rItBandwidth = plugin.getSensingLink().getBandwidth() / 1000.0;
        double rResult = wtUnwantedEmission.integrate(rFreqIt - rFreqWt, rItBandwidth);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Victim Link Transmitter Frequency = %f", rFreqWt));
            LOG.debug(String.format("It Receiver Frequency = %f", rFreqIt));
            LOG.debug(String.format("It Receiver Bandwith = %f", rItBandwidth));
            LOG.debug(String.format("Relative Unwanted Emission = .integrate((ItFreq - WtFreq), ItBandwith) = %f dBc", rResult));
        }
        return rResult;
    }

    private static void wtItPathAntGains(LinkResult sensingLink, InterferenceLinkResult result) {
        Transmitter it = result.getInterferenceLink().getInterferer().getSystem().getTransmitter();
        double originalILFrequency = result.getFrequency();
        result.setFrequency(sensingLink.getFrequency());
        double itWtAntennaGain = it.getAntennaGain().evaluate(result, sensingLink.rxAntenna());
        Transmitter vt = result.getInterferenceLink().getVictim().getSystem().getTransmitter();
        double wtItAntennaGain = vt.getAntennaGain().evaluate(result, sensingLink.txAntenna());
        result.setFrequency(originalILFrequency);
        sensingLink.rxAntenna().setGain(itWtAntennaGain);
        sensingLink.txAntenna().setGain(wtItAntennaGain);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sensing Link ILT->VLT Antenna Gain = " + itWtAntennaGain);
            LOG.debug("Sensing Link VLT->ILT Antenna Gain = " + wtItAntennaGain);
        }
    }

    private static void sLPathAntAziElev(LinkResult sensing, InterferenceLinkResult result) {
        double itAntHeight = result.getInterferingSystemLink().txAntenna().getHeight();
        sensing.rxAntenna().setHeight(itAntHeight);
        double wtAntHeight = result.getVictimSystemLink().txAntenna().getHeight();
        sensing.txAntenna().setHeight(wtAntHeight);
        double rILangle = result.getInterferingSystemLink().getTxRxAngle() - 180.0;
        double rILAzi = result.getInterferingSystemLink().txAntenna().getAzimuth();
        double rVLangle = result.getVictimSystemLink().getTxRxAngle();
        double rVLAzi = result.getVictimSystemLink().txAntenna().getAzimuth();
        double rItWtangle = Mathematics.calculateKartesianAngle(result.getVictimSystemLink().txAntenna().getPosition(), result.getInterferingSystemLink().txAntenna().getPosition());
        double itWtAzimuth = GenericSystemSimulation.calculateItVictimAzimuth(rILangle, rILAzi, rItWtangle, "ILT -> VLT");
        itWtAzimuth = Mathematics.convertAngleToConfineToHorizontalDefinedRange(itWtAzimuth);
        double itWtElevation = GenericSystemSimulation.calculateElevationWithTilt(result.getVictimSystemLink().txAntenna(), result.getInterferingSystemLink().txAntenna(), "VLR ->VLT");
        itWtElevation = GenericSystemSimulation.convertAngleToConfineToVerticalDefinedRange(itWtElevation);
        double wtItAzimuth = GenericSystemSimulation.calculateItVictimAzimuth(rVLangle, rVLAzi, rItWtangle, "VLT -> ILT");
        wtItAzimuth = Mathematics.convertAngleToConfineToHorizontalDefinedRange(wtItAzimuth);
        double wtItElevation = GenericSystemSimulation.calculateElevationWithTilt(result.getInterferingSystemLink().txAntenna(), result.getVictimSystemLink().txAntenna(), "VLR ->VLT");
        wtItElevation = GenericSystemSimulation.convertAngleToConfineToVerticalDefinedRange(wtItElevation);
        sensing.rxAntenna().setAzimuth(itWtAzimuth);
        sensing.rxAntenna().setElevation(itWtElevation);
        sensing.txAntenna().setAzimuth(wtItAzimuth);
        sensing.txAntenna().setElevation(wtItElevation);
        sensing.rxAntenna().setElevationCompensation(result.getInterferingSystemLink().txAntenna().getElevationCompensation());
        sensing.txAntenna().setElevationCompensation(result.getVictimSystemLink().txAntenna().getElevationCompensation());
        sensing.rxAntenna().setTilt(result.getInterferingSystemLink().txAntenna().getTilt());
        sensing.txAntenna().setTilt(result.getVictimSystemLink().txAntenna().getTilt());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sensing Link ILT->VLT azimuth = " + itWtAzimuth);
            LOG.debug("Sensing Link ILT->VLT elevation = " + itWtElevation);
            LOG.debug("Sensing Link VLT->ILT azimuth = " + wtItAzimuth);
            LOG.debug("Sensing Link VLT->ILT elevation = " + wtItElevation);
        }
    }

    private static void wt2itPath(LinkResult sensingLink, InterferenceLinkResult result) {
        double wtItDistance = Mathematics.distance(result.getVictimSystemLink().txAntenna().getPosition(), result.getInterferingSystemLink().txAntenna().getPosition());
        sensingLink.setTxRxDistance(wtItDistance);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sensing Link ILT->VLT distance = " + wtItDistance);
        }
    }

    private static void sensingTrial(LinkResult sensingLink, InterferenceLinkResult result) {
        CognitiveRadio.wt2itPath(sensingLink, result);
        CognitiveRadio.sLPathAntAziElev(sensingLink, result);
        CognitiveRadio.wtItPathAntGains(sensingLink, result);
    }

    public static boolean isActive(List<InterferenceLink> links) {
        int crCount = 0;
        for (InterferenceLink link : links) {
            GenericSystemPlugin pl;
            if (!(link.getInterferer().getSystemPlugin() instanceof GenericSystemPlugin) || !(pl = (GenericSystemPlugin)link.getInterferer().getSystemPlugin()).isInterfererCognitiveRadio()) continue;
            ++crCount;
        }
        return crCount > 0;
    }
}

