/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.generic;

import java.util.Locale;
import java.util.ResourceBundle;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.distributions.GaussianDistribution;
import org.seamcat.model.distributions.LimitedGaussianDistribution;
import org.seamcat.model.distributions.LimitedRayleighDistribution;
import org.seamcat.model.distributions.RayleighDistribution;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.scenariocheck.InterferingLinkCheck;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.types.Receiver;
import org.seamcat.model.types.Transmitter;
import org.seamcat.presentation.systems.generic.InterferenceCriteriaCalculator;
import org.seamcat.simulation.generic.CognitiveRadio;
import org.seamcat.simulation.generic.GenericSystemPlugin;
import org.seamcat.simulation.generic.RelativeLocation;
import org.seamcat.simulation.generic.SensingLink;

public class GenericSystemConsistencyCheck {
    private final Scenario scenario;
    private final Validator validator;
    private final RadioSystem system;
    private final GenericSystemPlugin plugin;
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);

    public GenericSystemConsistencyCheck(Scenario scenario, Validator validator, RadioSystem system, GenericSystemPlugin plugin) {
        this.scenario = scenario;
        this.validator = validator;
        this.system = system;
        this.plugin = plugin;
    }

    public void victimConsistencyCheck() {
        Bounds bounds = this.scenario.getVictim().getFrequency().getBounds();
        double rFreqVrMin = bounds.getMin();
        double rFreqVrMax = bounds.getMax();
        double victimFreqRange = rFreqVrMax - rFreqVrMin;
        Receiver vr = this.system.getReceiver();
        this.checkDeltasAndPaths();
        boolean isUsingCognitiveRadio = CognitiveRadio.isActive(this.scenario.getInterferenceLinks());
        String bandwidthWarning = "<HtMl><p style = 'color:maroon; font-weight:bold;'>These parameters are used for the averaging of the mask values and should be aligned to obtain correct results.</p>";
        Function blockingMask = vr.getBlockingMask().getFunction();
        if (this.plugin.getBlockingAttenuationMode() == GenericSystemPlugin.BlockingAttenuationMode.MODE_SENSITIVITY) {
            if (blockingMask.evaluateMin() >= 0.0) {
                this.validator.error("Using the Blocking mode SENSITIVITY requires on the Blocking mask absolute values in dBm" + bandwidthWarning);
            }
        } else if (!(!(blockingMask.evaluateMax() <= 0.0) || blockingMask.isConstant() && Mathematics.equals(0.0, blockingMask.getConstant(), 1.0E-5))) {
            this.validator.error("Using the Blocking mode 'User defined' or 'Protection ratio' requires positive values on the Blocking mask" + bandwidthWarning);
        }
        if (!blockingMask.isConstant() && this.checkPseudoConstant(blockingMask)) {
            double att = blockingMask.evaluate(0.0);
            double bw = 0.0;
            for (double f = 0.0; f < blockingMask.getBounds().getMax(); f += 0.001) {
                if (!(Math.abs(att - blockingMask.evaluate(f)) > 3.0)) continue;
                bw = f;
                break;
            }
            if (2.0 * bw / vr.getBandwidth() > 1.4 || 2.0 * bw / vr.getBandwidth() < 0.7) {
                this.validator.error("The 3-dB-bandwidth of the Blocking mask (" + Math.rint(2.0 * bw * 1000.0) / 1000.0 + " MHz) conflicts with the VLR bandwidth set to " + vr.getBandwidth() + " MHz" + bandwidthWarning);
            }
        }
        if (vr.isIntermodulationRejectionOption()) {
            this.checkIntermodulation(vr);
        }
        if (!InterferenceCriteriaCalculator.isConsistent(this.plugin.getProtectionRatio(), this.plugin.getExtendedProtectionRatio(), this.plugin.getNoiseAugmentation(), this.plugin.getInterferenceToNoiseRatio())) {
            this.validator.error("The interference criteria is not consistent.<br>Use the interference criteria calculator to find a consistent setup.<br>Note that these values are used in the blocking calculation for Protection <br> ratio and Sensitivity mode. You may disregard this warning if you are not<br> intending to use one of these two modes. However, it is highly recommended<br> to keep the values consistent, in particular if you intend to use a criterion<br> different from C/I for the interference calculation. Criteria not in line <br> with the noise floor and the sensitivity might cause physically incorrect results.");
        }
        if (vr.isUsingOverloading()) {
            if (this.plugin.getBlockingAttenuationMode() == GenericSystemPlugin.BlockingAttenuationMode.USER_DEFINED) {
                this.validator.error("The Blocking attenuation mode in user defined and overloading feature have been selected,<br> therefore the Blocking response and the receiver filter of the overloading are the same element.<br>Please make sure that they are not accounted twice.");
            }
            if (isUsingCognitiveRadio) {
                String message;
                double max;
                double min;
                DiscreteFunction func;
                Function function = vr.getOverloadingMask();
                if (!function.isConstant()) {
                    func = (DiscreteFunction)function;
                    min = func.getBounds().getMin();
                    max = func.getBounds().getMax();
                    if (!func.isConstant() && (max < victimFreqRange || Math.abs(min) < victimFreqRange)) {
                        message = String.format("Victim Receiver: Overloading mask does not cover the full frequency offset range: -%s to +%s", InterferingLinkCheck.fAndU(victimFreqRange), InterferingLinkCheck.fAndU(victimFreqRange));
                        this.validator.error(message);
                    }
                }
                if (!(function = vr.getReceiverFilter()).isConstant()) {
                    func = (DiscreteFunction)function;
                    min = func.getBounds().getMin();
                    max = func.getBounds().getMax();
                    if (!func.isConstant() && (max < victimFreqRange || Math.abs(min) < victimFreqRange)) {
                        message = String.format("Victim Receiver: Receiver filter function does not cover the full frequency offset range: -%s to +%s", InterferingLinkCheck.fAndU(victimFreqRange), InterferingLinkCheck.fAndU(victimFreqRange));
                        this.validator.error(message);
                    }
                }
            }
        }
    }

    private void checkDeltasAndPaths() {
        RelativeLocation location = this.plugin.getLocation();
        this.checkDist(location.getDeltaX(), "delta x");
        this.checkDist(location.getDeltaY(), "delta y");
        this.checkDist(location.getPathAzimuth(), "path azimuth");
        this.checkDist(location.getPathDistanceFactor(), "path distance factor");
    }

    private void checkDist(Distribution distribution, String variable) {
        if (distribution instanceof GaussianDistribution && !(distribution instanceof LimitedGaussianDistribution)) {
            GenericSystemConsistencyCheck.error(this.validator, "Gaussian distribution", variable);
            return;
        }
        if (distribution instanceof RayleighDistribution && !(distribution instanceof LimitedRayleighDistribution)) {
            GenericSystemConsistencyCheck.error(this.validator, "Rayleigh distribution", variable);
        }
    }

    public static void error(Validator validator, String dist, String variable) {
        validator.error(String.format(STRINGLIST.getString("PATHS_POSSIBLE_INVALID_DISTRIBUTION"), dist, variable));
    }

    private void checkIntermodulation(Receiver vr) {
        Function function = vr.getIntermodulationRejection();
        if (Mathematics.equals(function.evaluate(vr.getBandwidth() / 2.0), 0.0, 1.0E-5) || Mathematics.equals(function.evaluate(-vr.getBandwidth() / 2.0), 0.0, 1.0E-5)) {
            this.validator.error("<HtMl><b>Intermodulation rejection</b> An intermodulation rejection of 0 dB will cause unexpected results.");
        }
        if (this.plugin.getIntermodulationRejectionMode() == GenericSystemPlugin.IntermodulationRejectionMode.RELATIVE_ATTENUATION && function.evaluate(0.0) < 0.0) {
            this.validator.error("<HtMl><b>Intermodulation rejection</b> Negative values are applicable only to the Intermodulation rejection mode 'Absolute power (dBm)'.");
        }
        if (this.plugin.getIntermodulationRejectionMode() == GenericSystemPlugin.IntermodulationRejectionMode.ABSOLUTE_POWER && function.evaluate(0.0) > 0.0) {
            this.validator.error("<HtMl><b>Intermodulation rejection</b> Positive values are applicable only to the Intermodulation rejection mode 'Relative attenuation (dB)'.");
        }
    }

    public void interfererConsistencyCheck(RadioSystem victim) {
        Receiver vlr = victim.getReceiver();
        Transmitter it = this.system.getTransmitter();
        Bounds bounds = this.scenario.getVictim().getFrequency().getBounds();
        double rFreqVrMin = bounds.getMin();
        double rFreqVrMax = bounds.getMax();
        double victimFreqRange = rFreqVrMax - rFreqVrMin;
        this.checkDeltasAndPaths();
        if (this.plugin.isInterfererCognitiveRadio()) {
            SensingLink sensingLink = this.plugin.getSensingLink();
            MaskFunction eirp = sensingLink.getEIRPInBlockMask();
            Bounds eirpBounds = eirp.getBounds();
            String name = this.plugin.getUI().description().name();
            if (!eirp.isConstant() && (eirpBounds.getMax() < victimFreqRange || Math.abs(eirpBounds.getMin()) < victimFreqRange)) {
                this.validator.error(String.format("Interferer <%s>: EIRP max inblock limit function does not cover the full frequency range of the victimlink: -%s to +%s", name, InterferingLinkCheck.fAndU(victimFreqRange), InterferingLinkCheck.fAndU(victimFreqRange)));
            }
            Function detectionThreshold = sensingLink.getDetectionThreshold();
            double detectionThresholdMin = detectionThreshold.getBounds().getMin();
            double detectionThresholdMax = detectionThreshold.getBounds().getMax();
            if (!detectionThreshold.isConstant() && (detectionThresholdMax < victimFreqRange || Math.abs(detectionThresholdMin) < victimFreqRange)) {
                this.validator.error(String.format("Interferer <%s>: CR detection threshold function does not cover the full frequency offset range: -%s to +%s", name, InterferingLinkCheck.fAndU(victimFreqRange), InterferingLinkCheck.fAndU(victimFreqRange)));
            }
            double bandwidthRange = victimFreqRange + vlr.getBandwidth() / 2.0;
            MaskFunction emissionsMask = it.getEmissionsMask().getEmissionMask();
            Bounds emissionsMaskBounds = emissionsMask.getBounds();
            double emissionsMaskMin = emissionsMaskBounds.getMin();
            double emissionsMaskMax = emissionsMaskBounds.getMax();
            if (!emissionsMask.isConstant() && (emissionsMaskMax < bandwidthRange || Math.abs(emissionsMaskMin) < bandwidthRange)) {
                this.validator.error(String.format("Interferer <%s>: Unwanted emissions mask function does not cover the full frequency offset range: -%s to +%s", name, InterferingLinkCheck.fAndU(bandwidthRange), InterferingLinkCheck.fAndU(bandwidthRange)));
            }
            if (it.isUsingEmissionsFloor()) {
                MaskFunction emissionsFloor = it.getEmissionsFloor();
                Bounds emissionsFloorBounds = emissionsFloor.getBounds();
                double emissionsFloorMin = emissionsFloorBounds.getMin();
                double emissionsFloorMax = emissionsFloorBounds.getMax();
                if (!emissionsFloor.isConstant() && (emissionsFloorMax < bandwidthRange || Math.abs(emissionsFloorMin) < bandwidthRange)) {
                    this.validator.error(String.format("Interferer <%s>: Unwanted emissions floor function does not cover the full frequency offset range: -%s to +%s", name, InterferingLinkCheck.fAndU(bandwidthRange), InterferingLinkCheck.fAndU(bandwidthRange)));
                }
            }
        }
    }

    private boolean checkPseudoConstant(Function blockingMask) {
        return !Mathematics.equals(blockingMask.evaluate(0.0), blockingMask.evaluate(blockingMask.getBounds().getMax()), 0.1);
    }
}

