/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.generic;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.seamcat.events.VectorValues;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.correlation.ActiveTransmitters;
import org.seamcat.model.correlation.Closest;
import org.seamcat.model.correlation.Correlated;
import org.seamcat.model.correlation.ILRAtCenter;
import org.seamcat.model.correlation.NoneMode;
import org.seamcat.model.correlation.UniformDensity;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.VectorSpace;
import org.seamcat.model.generic.EmissionCharacteristics;
import org.seamcat.model.generic.InterferenceCriteria;
import org.seamcat.model.generic.PathLossCorrelationUI;
import org.seamcat.model.generic.RXAntennaPointingUI;
import org.seamcat.model.generic.ReceptionCharacteristics;
import org.seamcat.model.generic.TXAntennaPointingUI;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.geometry.Polygon2D;
import org.seamcat.model.geometry.PolygonUtil;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.eventprocessing.PostProcessingUI;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Context;
import org.seamcat.model.plugin.system.CorrelationMode;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.plugin.system.SectorProperty;
import org.seamcat.model.plugin.system.SimulationInstance;
import org.seamcat.model.plugin.system.Space;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.plugin.system.SystemSpaces;
import org.seamcat.model.plugin.system.TransceiverSettings;
import org.seamcat.model.plugin.system.optional.AsVictimPostProcessingTab;
import org.seamcat.model.plugin.system.optional.CorrelationDefinitions;
import org.seamcat.model.plugin.system.optional.CustomCorrelationDefinitions;
import org.seamcat.model.plugin.system.optional.TransceiverConsistencyCheck;
import org.seamcat.model.plugin.system.optional.TransceiverSettingsImpl;
import org.seamcat.model.simulation.consistency.ConsistencyError;
import org.seamcat.model.simulation.consistency.PluginValidator;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.systems.generic.SystemModelGeneric;
import org.seamcat.model.systems.generic.TransmitterReceiverPathModel;
import org.seamcat.model.types.CorrelationSetting;
import org.seamcat.model.types.CoverageRadius;
import org.seamcat.model.types.Receiver;
import org.seamcat.model.types.Transmitter;
import org.seamcat.model.types.result.DoubleResultType;
import org.seamcat.model.types.result.FunctionResultType;
import org.seamcat.model.types.result.Results;
import org.seamcat.presentation.WarningColors;
import org.seamcat.simulation.calculator.InterferenceCalculator;
import org.seamcat.simulation.generic.AntennaPointing;
import org.seamcat.simulation.generic.ClosestMode;
import org.seamcat.simulation.generic.CognitiveRadio;
import org.seamcat.simulation.generic.GenericCorrelationSettings;
import org.seamcat.simulation.generic.GenericSystemConsistencyCheck;
import org.seamcat.simulation.generic.GenericSystemSimulation;
import org.seamcat.simulation.generic.RelativeLocation;
import org.seamcat.simulation.generic.SensingLink;
import org.seamcat.simulation.generic.TransmitterDensityAndTraffic;
import org.seamcat.simulation.generic.UniformMode;
import org.seamcat.simulation.generic.ice.Criteria;
import org.seamcat.simulation.generic.ice.ICCompatibilityCalculator;
import org.seamcat.simulation.generic.ice.InterferenceCalculationCustomUI;

public class GenericSystemPlugin
implements SystemPlugin<SystemModelGeneric>,
CorrelationDefinitions,
CustomCorrelationDefinitions,
AsVictimPostProcessingTab,
TransceiverConsistencyCheck {
    private static Logger LOG = Logger.getLogger(GenericSystemPlugin.class);
    public static final UniqueValueDef COVERAGE_RADIUS = Factory.results().single("Coverage radius", "km");
    public static final UniqueValueDef PATH_AZIMUTH = Factory.results().single("Path azimuth", "Degree");
    public static final UniqueValueDef PATH_DISTANCE_FACTOR = Factory.results().single("Path distance factor", "");
    public static final UniqueValueDef RX_NOISE_FLOOR = Factory.results().single("Rx noise floor", "dBm");
    public static final VectorDef DRSS = Factory.results().value("dRSS", "dBm");
    private Scenario scenario;
    private RadioSystem system;
    private SystemModelGeneric ui;
    private Double covRadius;
    private SensingLink sensing;
    private AntennaPointing txPointing;
    private AntennaPointing rxPointing;
    private EmissionCharacteristics ec;
    private ReceptionCharacteristics rc;
    private InterferenceCriteria ic;
    private RelativeLocation location;
    private CoverageRadius coverageRadiusSettings;
    private boolean useUserDefinedDRSS;
    private Distribution userDefinedDRSS;
    private TransmitterDensityAndTraffic txDensity;
    public static NumberFormat nf = new DecimalFormat("0.00");

    private void createSystemFromUI() {
        Bounds bounds;
        this.ec = this.ui.transmitter().emissionCharacteristics();
        this.sensing = new SensingLink(this.ec.detectionThreshold(), this.ec.probabilityOfFailure(), this.ec.receptionBandwidth(), this.ec.eirpMax(), this.ec.propagationModel());
        try {
            bounds = InterferenceCalculator.calculateBounds(this.ec.emissionMask().getEmissionMask(), this.ui.receiver().receptionCharacteristics().reception_bandwith());
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Prepare simulation: Error calculating the bounds of the emission mask. " + e.getMessage());
        }
        double bandwidth = Math.rint((bounds.getMax() - bounds.getMin()) * 1000000.0) / 1000000.0;
        double offset = bandwidth / 2.0 - bounds.getMax();
        offset = Math.rint(offset * 1000000.0) / 1000000.0;
        TXAntennaPointingUI txPoint = this.ui.transmitter().antennaPointing();
        Transmitter transmitter = new Transmitter(this.ec.emissionMask(), this.ec.emissionFloor().getValue(), this.ec.emissionFloor().isRelevant(), bandwidth, bounds, Factory.results().convert(this.ui.path().localEnvironments().transmitterEnvironments()), this.ui.transmitter().antennaGain(), txPoint.antennaHeight(), offset, this.ec.powerControl());
        this.txPointing = new AntennaPointing(txPoint.azimuth(), txPoint.elevation(), txPoint.antennaPointingAzimuth(), txPoint.antennaPointingElevation());
        RXAntennaPointingUI rxPoint = this.ui.receiver().antennaPointing();
        this.rc = this.ui.receiver().receptionCharacteristics();
        this.ic = this.ui.receiver().interferenceCriteria();
        Function pseudoBlockingMask = GenericSystemPlugin.getPseudoBlockingMask(this.rc, this.ic);
        Receiver receiver = new Receiver(this.rc.blockingMask(), this.rc.reception_bandwith() / 1000.0, Factory.results().convert(this.ui.path().localEnvironments().receiverEnvironments()), this.ui.receiver().antennaGain(), rxPoint.antennaHeight(), pseudoBlockingMask, this.rc.use_receiver_overloading(), this.rc.overloading_mask(), this.rc.intermodulation_rejection().isRelevant(), this.rc.intermodulation_rejection().getValue().getFunction(), GenericSystemPlugin.intermodulationThreshold(this.rc, this.ic), this.rc.receiver_filter());
        this.rxPointing = new AntennaPointing(rxPoint.azimuth(), rxPoint.elevation(), rxPoint.antennaPointingAzimuth(), rxPoint.antennaPointingElevation());
        TransmitterReceiverPathModel model = this.ui.path();
        this.system = new RadioSystem(receiver, transmitter, this.ui.path().propagationModel());
        this.location = new RelativeLocation(model.relativeLocation());
        this.coverageRadiusSettings = model.coverageRadius();
        this.useUserDefinedDRSS = model.drss().drss().isRelevant();
        this.userDefinedDRSS = model.drss().drss().getValue();
        this.txDensity = new TransmitterDensityAndTraffic(model.transmitterDensity());
    }

    @Override
    public void prepareSimulation(Scenario scenario) {
        this.scenario = scenario;
        this.createSystemFromUI();
        this.covRadius = 0.0;
        if (!this.getLocation().useCorrelatedDistance()) {
            this.covRadius = this.getCoverageRadius().evaluate(this, this.system);
        }
    }

    private static double intermodulationThreshold(ReceptionCharacteristics rc, InterferenceCriteria ic) {
        return -3.0 * rc.sensitivity() - 3.0 * (ic.noise_augmentation() - ic.interference_to_noise_ratio());
    }

    private static Function getPseudoBlockingMask(ReceptionCharacteristics rc, InterferenceCriteria ic) {
        double offset = 0.0;
        if (rc.blockingAttenuationMode() == BlockingAttenuationMode.MODE_SENSITIVITY) {
            offset = ic.extended_protection_ratio() - rc.sensitivity() - ic.interference_to_noise_ratio();
        } else if (rc.blockingAttenuationMode() == BlockingAttenuationMode.PROTECTION_RATIO) {
            offset = ic.extended_protection_ratio() + ic.noise_augmentation() - ic.interference_to_noise_ratio();
        }
        return rc.blockingMask().getFunction().offset(offset);
    }

    @Override
    public void setUI(SystemModelGeneric ui) {
        this.ui = ui;
    }

    @Override
    public SystemModelGeneric getUI() {
        return this.ui;
    }

    @Override
    public RadioSystem getSystem(Context context) {
        return this.system;
    }

    @Override
    public void preSimulation(Context context, Results pre) {
        pre.getSingleValueTypes().add(new DoubleResultType(COVERAGE_RADIUS, this.covRadius));
        if (!context.isVictim()) {
            CorrelationSetting correlation;
            if (this.isInterfererCognitiveRadio()) {
                pre.getFunctionResultTypes().add(new FunctionResultType(CognitiveRadio.NORMALIZED_EIRP_INBLOCK, this.getSensingLink().getEIRPInBlockMask().normalize()));
            }
            if ((correlation = context.getInterferenceLink().getCorrelationSettings()).getCorrelationMode() == UniformMode.MODE) {
                double rRsimu = this.itSimulationRadius(correlation.getCorrelationConfiguration(ActiveTransmitters.class).activeTx());
                pre.getSingleValueTypes().add(new DoubleResultType(UniformDensity.SIMULATION_RADIUS, rRsimu));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Generating %d events", this.scenario.numberOfEvents()));
            LOG.debug("Position of Victim Receiver is " + (this.getLocation().useCorrelatedDistance() ? "fixed" : "dynamic"));
        }
    }

    @Override
    public void postSimulation(Context context, Results results) {
        if (context.isVictim()) {
            ICCompatibilityCalculator calculator = new ICCompatibilityCalculator(this.scenario, results);
            for (Criteria criteria : Criteria.values()) {
                this.calculateAndAppend(results, calculator, criteria, false, false);
                if (calculator.hasOverloading()) {
                    this.calculateAndAppend(results, calculator, criteria, true, false);
                }
                if (calculator.hasIntermodulation()) {
                    this.calculateAndAppend(results, calculator, criteria, false, true);
                }
                if (!calculator.hasOverloading() || !calculator.hasIntermodulation()) continue;
                this.calculateAndAppend(results, calculator, criteria, true, true);
            }
        }
    }

    private void calculateAndAppend(Results results, ICCompatibilityCalculator calculator, Criteria criteria, boolean over, boolean inter) {
        LinkedList<String> names = new LinkedList<String>();
        if (over) {
            names.add("overloading");
        }
        if (inter) {
            names.add("intermodulation");
        }
        String group = "Interference Compatibility Calculations";
        names.addFirst("unwanted");
        double value = calculator.compatibility(criteria, true, false, over, inter);
        results.getSingleValueTypes().add(new DoubleResultType(Factory.results().singleGroup(group, (Object)((Object)criteria) + " " + names, "%"), value));
        names.removeFirst();
        names.addFirst("blocking");
        value = calculator.compatibility(criteria, false, true, over, inter);
        results.getSingleValueTypes().add(new DoubleResultType(Factory.results().singleGroup(group, (Object)((Object)criteria) + " " + names, "%"), value));
        names.addFirst("unwanted");
        value = calculator.compatibility(criteria, true, true, over, inter);
        results.getSingleValueTypes().add(new DoubleResultType(Factory.results().singleGroup(group, (Object)((Object)criteria) + " " + names, "%"), value));
        names.removeFirst();
        names.removeFirst();
        if (over || inter) {
            value = calculator.compatibility(criteria, false, false, over, inter);
            results.getSingleValueTypes().add(new DoubleResultType(Factory.results().singleGroup(group, (Object)((Object)criteria) + " " + names, "%"), value));
        }
    }

    private double itSimulationRadius(int nbActive) {
        double rDensActive = GenericSystemPlugin.itDensityActive(this.txDensity);
        return Math.sqrt((double)nbActive / (Math.PI * rDensActive));
    }

    public static double itDensityActive(TransmitterDensityAndTraffic density) {
        double rActivity = density.getActivity().evaluate(density.getHourOfDay());
        return density.getDensityTx() * density.getProbabilityOfTransmission() * rActivity;
    }

    @Override
    public SimulationInstance simulationInstance(Context context, SystemSpaces systemSpaces) {
        return new GenericSystemSimulation(this.system, this, this.scenario);
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Scenario scenario, Validator validator) {
        ArrayList<ConsistencyError> errors = new ArrayList<ConsistencyError>();
        CoverageRadius cr = this.getCoverageRadius();
        PluginValidator.plugin(context, errors, cr, this.ui.description().name() + "->Coverage radius" + cr.description().name() + "->");
        if (context.getOrigin() == Origin.INTERFERENCE_LINK) {
            if (this.isInterfererCognitiveRadio()) {
                SensingLink sensingLink = this.getSensingLink();
                PluginValidator.plugin(context.setContextObject(sensingLink), errors, sensingLink.getPropagationModel(), "InterferenceLink->Sensing Link");
                for (ConsistencyError error : errors) {
                    validator.error(error.message());
                }
            }
            if (context.getInterferenceLink().getCorrelationSettings().getCorrelationConfiguration(PathLossCorrelationUI.class).usePathLossCorrelation() && context.getInterferenceLink().getPropagationModel().isVariationSelected()) {
                validator.error("On the interfering link both the path loss correlation and the variations of the propagation model are selected. <br>This conflicts with the path loss correlation concept.<p " + (Object)((Object)WarningColors.ACCURARY_WARNING) + ">It is recommended to de-select 'Variations' on the interfering link propagation model " + context.getInterferenceLink().getPropagationModel().toString() + "</p>");
            }
            new GenericSystemConsistencyCheck(scenario, validator, this.system, this).interfererConsistencyCheck(context.getInterferenceLink().getVictim().getSystem());
        }
        if (context.getOrigin() == Origin.SYSTEM) {
            new GenericSystemConsistencyCheck(scenario, validator, this.system, this).victimConsistencyCheck();
        }
    }

    @Override
    public List<Class<? extends PostProcessingUI>> tabs() {
        ArrayList<Class<? extends PostProcessingUI>> list = new ArrayList<Class<? extends PostProcessingUI>>();
        list.add(InterferenceCalculationCustomUI.class);
        return list;
    }

    @Override
    public List<String> getVictimCorrelationPoints() {
        return Arrays.asList("VLR", "VLT");
    }

    @Override
    public Point2D getVictimPosition(VictimResultCollector collector, String relativeTo) {
        LinkResult victim = collector.getVictims().get(0).getLinkResult();
        if (relativeTo.equals("VLR")) {
            return victim.rxAntenna().getPosition();
        }
        return victim.txAntenna().getPosition();
    }

    @Override
    public List<String> getInterfererTargetPointNames() {
        return Arrays.asList("ILT", "ILR");
    }

    @Override
    public List<CorrelationMode> getCorrelationModes() {
        ArrayList<CorrelationMode> modes = new ArrayList<CorrelationMode>();
        modes.add(NoneMode.MODE);
        modes.add(UniformMode.MODE);
        modes.add(ClosestMode.MODE);
        modes.add(Correlated.MODE);
        return modes;
    }

    @Override
    public boolean allowCoLocation() {
        return true;
    }

    @Override
    public Map<Class, String> extraInputForMode(CorrelationMode mode) {
        LinkedHashMap<Class, String> inputs = new LinkedHashMap<Class, String>();
        if (mode == UniformMode.MODE) {
            inputs.put(UniformDensity.class, "Mode 'Uniform density' Configuration");
            inputs.put(ActiveTransmitters.class, "Active Transmitters");
            inputs.put(ILRAtCenter.class, "ILR at center");
        } else if (mode == ClosestMode.MODE) {
            inputs.put(Closest.class, "Mode 'Closest interferer' Configuration");
            inputs.put(ILRAtCenter.class, "ILR at center");
        } else if (mode == NoneMode.MODE) {
            inputs.put(ActiveTransmitters.class, "Active Transmitters");
            inputs.put(ILRAtCenter.class, "ILR at center");
        }
        return inputs;
    }

    public static VectorValues calculate(double[] vector) {
        if (vector == null) {
            return null;
        }
        double median = Mathematics.getMedian(vector, vector.length, true);
        double mean = Mathematics.getAverage(vector, vector.length, true);
        double stdDev = Mathematics.getStdDev(vector, mean, vector.length, true);
        return new VectorValues(nf.format(mean) + " dBm", nf.format(median) + " dBm", nf.format(stdDev) + " dB");
    }

    private Bounds getCoverage() {
        Distribution pathDistanceFactor;
        Bounds coverage = new Bounds(this.covRadius, this.covRadius, true);
        RelativeLocation location = this.getLocation();
        if (!location.useCorrelatedDistance() && (pathDistanceFactor = location.getPathDistanceFactor()).getBounds().isBounded()) {
            coverage = new Bounds(this.covRadius * pathDistanceFactor.getBounds().getMin(), this.covRadius * pathDistanceFactor.getBounds().getMax(), true);
        }
        return coverage;
    }

    @Override
    public Bounds getSystemCoverage() {
        RelativeLocation location = this.getLocation();
        double max = GenericSystemPlugin.distance(location.getDeltaX(), location.getDeltaY());
        Bounds systemBounds = new Bounds(0.0, max, true);
        if (!location.useCorrelatedDistance()) {
            systemBounds = systemBounds.add(this.getCoverage());
        }
        return systemBounds;
    }

    @Override
    public VectorSpace getInterferenceLinkSystemCoverage(boolean victim, ConsistencyCheckContext context) {
        RelativeLocation location = this.getLocation();
        VectorSpace delta = new VectorSpace(location.getDeltaX().getBounds(), location.getDeltaY().getBounds());
        GenericCorrelationSettings settings = new GenericCorrelationSettings(context.getInterferenceLink().getCorrelationSettings());
        if (victim) {
            if (context.getContextObject() instanceof SensingLink) {
                if (settings.isRelativeTo("VLR")) {
                    return delta.negate().addCircle(this.getCoverage());
                }
            } else if (settings.isRelativeTo("VLT")) {
                return delta.addCircle(this.getCoverage());
            }
        } else if (settings.isTarget("ILR")) {
            if (settings.isILRCenter()) {
                return VectorSpace.ZERO;
            }
            return delta.addCircle(this.getCoverage());
        }
        return VectorSpace.ZERO;
    }

    public static double distance(Distribution deltaX, Distribution deltaY) {
        double dx = Math.max(Math.abs(deltaX.getBounds().getMin()), Math.abs(deltaX.getBounds().getMax()));
        double dy = Math.max(Math.abs(deltaY.getBounds().getMin()), Math.abs(deltaY.getBounds().getMax()));
        return Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    public TransceiverSettings getRxSettings(ConsistencyCheckContext context) {
        if (context.getContextObject() instanceof SensingLink) {
            Transmitter transmitter = this.system.getTransmitter();
            return new TransceiverSettingsImpl(transmitter.getHeight().getBounds(), transmitter.getLocalEnvironments());
        }
        Receiver receiver = this.system.getReceiver();
        return new TransceiverSettingsImpl(receiver.getHeight().getBounds(), receiver.getLocalEnvironments());
    }

    @Override
    public TransceiverSettings getTxSettings(ConsistencyCheckContext context) {
        Transmitter transmitter = this.system.getTransmitter();
        if (context.getContextObject() instanceof SensingLink) {
            transmitter = context.getInterferenceLink().getVictim().getSystem().getTransmitter();
        }
        return new TransceiverSettingsImpl(transmitter.getHeight().getBounds(), transmitter.getLocalEnvironments());
    }

    public SensingLink getSensingLink() {
        return this.sensing;
    }

    public AntennaPointing getTxPointing() {
        return this.txPointing;
    }

    public AntennaPointing getRxPointing() {
        return this.rxPointing;
    }

    public boolean isInterfererCognitiveRadio() {
        return this.ec.cognitiveRadio();
    }

    public double getPowerControlStepSize() {
        return this.ec.stepSize();
    }

    public double getPowerControlMinThreshold() {
        return this.ec.minThreshold();
    }

    public double getPowerControlDynamicRange() {
        return this.ec.dynamicRange();
    }

    public Distribution getPower() {
        return this.ec.power();
    }

    public double getExtendedProtectionRatio() {
        return this.ic.extended_protection_ratio();
    }

    public double getInterferenceToNoiseRatio() {
        return this.ic.interference_to_noise_ratio();
    }

    public double getNoiseAugmentation() {
        return this.ic.noise_augmentation();
    }

    public double getProtectionRatio() {
        return this.ic.protection_ratio();
    }

    public double getSensitivity() {
        return this.rc.sensitivity();
    }

    public BlockingAttenuationMode getBlockingAttenuationMode() {
        return this.rc.blockingAttenuationMode();
    }

    public IntermodulationRejectionMode getIntermodulationRejectionMode() {
        return this.rc.intermodulationRejectionMode();
    }

    public Distribution getNoiseFloor() {
        return this.rc.noiseFloor();
    }

    public boolean isUsingPowerControlThreshold() {
        return this.rc.receivePower().isRelevant();
    }

    public double getPowerControlThreshold() {
        return this.rc.receivePower().getValue();
    }

    public RelativeLocation getLocation() {
        return this.location;
    }

    public CoverageRadius getCoverageRadius() {
        return this.coverageRadiusSettings;
    }

    public TransmitterDensityAndTraffic getTransmitterDensity() {
        return this.txDensity;
    }

    public boolean isUseUserDefinedDRSS() {
        return this.useUserDefinedDRSS;
    }

    public Distribution getUserDefinedDRSS() {
        return this.userDefinedDRSS;
    }

    @Override
    public SystemSpaces generateSystemSpaces(SystemSpaces enclosing) {
        ArrayList<Space> spaces = new ArrayList<Space>();
        spaces.add(new Space(new Polygon2D(Point2D.ORIGIN), false, new SectorProperty[0]));
        double coverageRadius = 0.0;
        if (this.covRadius == null) {
            if (!this.ui.path().relativeLocation().useCorrelatedDistance()) {
                this.createSystemFromUI();
                coverageRadius = this.ui.path().coverageRadius().evaluate(this, this.system);
            }
        } else {
            coverageRadius = this.covRadius;
        }
        spaces.add(new Space(this.getRxShape(coverageRadius), true, new SectorProperty[0]));
        return new SystemSpaces(spaces);
    }

    private Polygon2D getRxShape(double coverageRadius) {
        RelativeLocation rl = new RelativeLocation(this.ui.path().relativeLocation());
        Bounds xBounds = rl.getDeltaX().getBounds();
        Bounds yBounds = rl.getDeltaY().getBounds();
        if (rl.useCorrelatedDistance()) {
            ArrayList<Point2D> edges = new ArrayList<Point2D>();
            if (xBounds.getMin() == xBounds.getMax() && yBounds.getMin() == yBounds.getMax()) {
                return new Polygon2D(new Point2D(xBounds.getMin(), yBounds.getMin()));
            }
            if (xBounds.getMin() == xBounds.getMax()) {
                edges.add(new Point2D(xBounds.getMin(), yBounds.getMin()));
                edges.add(new Point2D(xBounds.getMin(), yBounds.getMax()));
            } else if (yBounds.getMin() == yBounds.getMax()) {
                edges.add(new Point2D(xBounds.getMin(), yBounds.getMin()));
                edges.add(new Point2D(xBounds.getMax(), yBounds.getMin()));
            } else {
                edges.add(new Point2D(xBounds.getMin(), yBounds.getMin()));
                edges.add(new Point2D(xBounds.getMax(), yBounds.getMin()));
                edges.add(new Point2D(xBounds.getMax(), yBounds.getMax()));
                edges.add(new Point2D(xBounds.getMin(), yBounds.getMax()));
            }
            return new Polygon2D(edges);
        }
        Bounds distance = rl.getPathDistanceFactor().getBounds();
        Bounds validAngles = rl.getPathAzimuth().getBounds();
        if (rl.usePolygon()) {
            double turnTrial = rl.turnCCW().trial();
            return PolygonUtil.add(xBounds, yBounds, PolygonUtil.convertCircle(coverageRadius * distance.getMax(), turnTrial, rl.shape().getEdgeCount(), validAngles));
        }
        double radius = coverageRadius * distance.getMax();
        return PolygonUtil.add(xBounds, yBounds, PolygonUtil.convertCircle(radius, 0.0, 16, validAngles));
    }

    public static enum IntermodulationRejectionMode {
        RELATIVE_ATTENUATION("Relative attenuation (dB)"),
        ABSOLUTE_POWER("Absolute power (dBm)");

        private final String name;

        private IntermodulationRejectionMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum BlockingAttenuationMode {
        USER_DEFINED("User Defined"),
        PROTECTION_RATIO("Protection Ratio"),
        MODE_SENSITIVITY("Sensitivity");

        private final String name;

        private BlockingAttenuationMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

