/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.generic;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Function;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.Receiver;
import org.seamcat.simulation.generic.GenericSystemPlugin;
import org.seamcat.simulation.result.VectorDefImpl;

public class Intermodulation {
    private static Logger LOG = Logger.getLogger(Intermodulation.class);
    public static final String INTERMOD = "iRSS Intermodulation";
    public static final VectorDef INTERMOD_SUMMATION = Factory.results().value("iRSS Intermodulation Summation", "dBm");
    public static final UniqueValueDef IRSS = Factory.results().single("iRSS", "dBm");
    public static final String VR_INTERMOD = "victim intermodulation response";
    private final Scenario scenario;
    private final RadioSystem victimSystem;
    private final GenericSystemPlugin plugin;
    private Function intermodulationMask = null;

    public Intermodulation(Scenario scenario) {
        this.scenario = scenario;
        this.victimSystem = scenario.getVictim().getSystem();
        this.plugin = (GenericSystemPlugin)scenario.getVictim().getSystemPlugin();
    }

    public void collect(EventResult result) {
        this.intermodulationMask = result.getVictimResult().getPreSimulationResults().findFunction(Receiver.INTERMODULATION_REJECTION);
        List<InterferenceLinkResult> flattenedResult = this.countInterferenceLinkResults(result);
        int numberOfInterferingSystems = flattenedResult.size();
        if (numberOfInterferingSystems > 1) {
            LOG.debug("Calculation of iRSS - Intermodulation values");
            VictimResultCollector vColl = result.getVictimResult();
            double rSumI = 0.0;
            for (int m = 0; m < numberOfInterferingSystems; ++m) {
                for (int k = 0; k < numberOfInterferingSystems; ++k) {
                    if (m == k) continue;
                    double value = this.iRSSLinkBudgetInterMod(flattenedResult.get(m), flattenedResult.get(k), m, k) + (Double)flattenedResult.get(m).getVictimSystemLink().getValue(GenericSystemPlugin.RX_NOISE_FLOOR);
                    String name = INTERMOD + this.prettyPrefix(m, k);
                    rSumI += Math.pow(10.0, value / 10.0);
                    vColl.add((VectorDef)new VectorDefImpl(INTERMOD, name, "dBm", false), value);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug(name + " = " + value);
                    LOG.debug("rSumI = " + rSumI);
                }
            }
            vColl.add(INTERMOD_SUMMATION, 10.0 * Math.log10(rSumI));
        }
    }

    private String prettyPrefix(int m, int k) {
        return " " + (m + 1) + " / " + (k + 1);
    }

    private List<InterferenceLinkResult> countInterferenceLinkResults(EventResult result) {
        ArrayList<InterferenceLinkResult> flattenedResult = new ArrayList<InterferenceLinkResult>();
        for (InterferenceLink link : this.scenario.getInterferenceLinks()) {
            for (InterferenceLinkResult linkResult : result.getInterferenceLinkResult(link)) {
                if (!(linkResult.getInterferenceLink().getVictim().getSystemPlugin() instanceof GenericSystemPlugin) || !(linkResult.getInterferenceLink().getInterferer().getSystemPlugin() instanceof GenericSystemPlugin)) continue;
                flattenedResult.add(linkResult);
            }
        }
        return flattenedResult;
    }

    private double iRSSLinkBudgetInterMod(InterferenceLinkResult res1, InterferenceLinkResult res2, int index1, int index2) {
        double riRSSValue1 = this.getIRSS(res1);
        res1.setValue(IRSS, riRSSValue1);
        double riRSSValue2 = this.getIRSS(res2);
        res2.setValue(IRSS, riRSSValue2);
        double rFreqVr = res1.getVictimSystemLink().getFrequency();
        double rFreq1 = res1.getInterferingSystemLink().getFrequency();
        double rFreq2 = res2.getInterferingSystemLink().getFrequency();
        double rFreq0 = 2.0 * rFreq1 - rFreq2;
        double rIntermodResponse = this.vrInterModResponse(rFreq0 - rFreqVr);
        res1.getVictimSystemLink().setValue(Factory.results().single(VR_INTERMOD + this.prettyPrefix(index1, index2), "dBm"), rIntermodResponse);
        double intermodulationProduct = 2.0 * riRSSValue1 + riRSSValue2 - 3.0 * rIntermodResponse + this.victimSystem.getReceiver().intermodulationThreshold();
        if (Math.abs(rFreq2 - rFreqVr) < Math.abs(rFreq1 - rFreqVr)) {
            intermodulationProduct = 2.0 * riRSSValue2 + riRSSValue1 - 3.0 * rIntermodResponse + this.victimSystem.getReceiver().intermodulationThreshold();
        }
        if (intermodulationProduct + 13.0 > Math.max(riRSSValue1, riRSSValue2)) {
            intermodulationProduct = Math.max(riRSSValue1, riRSSValue2) - 13.0;
        }
        if (Mathematics.equals(rIntermodResponse, -1000.0, 1.0E-5)) {
            return -1000.0;
        }
        if (Math.abs(rFreqVr - rFreq0) <= this.victimSystem.getReceiver().getBandwidth() / 2.0) {
            return intermodulationProduct;
        }
        return intermodulationProduct - res1.getBlockingAttenuation();
    }

    private double getIRSS(InterferenceLinkResult link) {
        double iRSS = link.getInterferingSystemLink().getTxPower() - link.getEffectiveTxRxPathLoss();
        if (link.getInterferenceLink().getInterferer().getSystem().getTransmitter().isUsingPowerControl()) {
            double rItPowerControl1 = (Double)link.getInterferingSystemLink().getValue(SystemPlugin.TX_POWER_CONTROL_GAIN);
            iRSS += rItPowerControl1;
        }
        return iRSS;
    }

    private double vrInterModResponse(double rFreq0) {
        Function imodFunc = this.victimSystem.getReceiver().getIntermodulationRejection();
        double intermodulationResponse = this.intermodulationMask == null ? imodFunc.evaluate(rFreq0) : this.intermodulationMask.evaluate(rFreq0);
        if (!Mathematics.equals(intermodulationResponse, 0.0, 1.0E-5)) {
            if (this.plugin.getIntermodulationRejectionMode() == GenericSystemPlugin.IntermodulationRejectionMode.RELATIVE_ATTENUATION) {
                return intermodulationResponse;
            }
            return intermodulationResponse - this.plugin.getSensitivity() - this.plugin.getNoiseAugmentation();
        }
        return -1000.0;
    }
}

