/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.generic;

import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.generic.RelativeLocationUI;
import org.seamcat.model.geometry.Point2D;

public class RelativeLocation {
    private RelativeLocationUI ui;

    public RelativeLocation(RelativeLocationUI ui) {
        this.ui = ui;
    }

    public boolean useCorrelatedDistance() {
        return this.ui.useCorrelatedDistance();
    }

    public Point2D getDeltaPosition() {
        return new Point2D(this.ui.deltaX().trial(), this.ui.deltaY().trial());
    }

    public Distribution getDeltaX() {
        return this.ui.deltaX();
    }

    public Distribution getDeltaY() {
        return this.ui.deltaY();
    }

    public Distribution getPathAzimuth() {
        return this.ui.pathAzimuth();
    }

    public Distribution getPathDistanceFactor() {
        return this.ui.pathDistanceFactor();
    }

    public boolean usePolygon() {
        return this.ui.usePolygon();
    }

    public Shape shape() {
        return this.ui.shape();
    }

    public Distribution turnCCW() {
        return this.ui.turnCCW();
    }

    public static enum Shape {
        Octagon("Octagon", 8),
        Heptagon("Heptagon", 7),
        Hexagon("Hexagon", 6),
        Pentagon("Pentagon", 5),
        Square("Square", 4),
        Triangle("Triangle", 3);

        private final String name;
        private final int edges;

        private Shape(String name, int edges) {
            this.name = name;
            this.edges = edges;
        }

        public String toString() {
            return this.name();
        }

        public int getEdgeCount() {
            return this.edges;
        }
    }
}

