/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.generic.ice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.seamcat.model.Scenario;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Function;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.SimulationResult;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.types.result.VectorResultType;
import org.seamcat.simulation.generic.GenericSystemPlugin;
import org.seamcat.simulation.generic.Intermodulation;
import org.seamcat.simulation.generic.Overloading;
import org.seamcat.simulation.generic.ice.Compatibility;
import org.seamcat.simulation.generic.ice.Criteria;
import org.seamcat.simulation.generic.ice.ICResult;

public class ICCalculator {
    private Results results;
    private boolean filterSensitivity;
    private Scenario scenario;
    private GenericSystemPlugin plugin;
    private double[] unwanted;
    private double[] blocking;
    private double[] drss;
    private double[] overloading;
    private double[] intermodulation;
    private List<VectorResultType> allUnwanted;
    private List<VectorResultType> allBlocking;
    private int size;
    private ICResult input;
    private ICResult prototype;

    public ICCalculator(Scenario scenario, SimulationResult result, ICResult input, boolean filterSensitivity) {
        this.plugin = (GenericSystemPlugin)scenario.getVictim().getSystemPlugin();
        this.scenario = scenario;
        this.size = scenario.numberOfEvents();
        this.input = input;
        this.prototype = Factory.prototype(ICResult.class, input);
        this.results = result.getVictimResults();
        this.filterSensitivity = filterSensitivity;
        List<VectorResultType> vectors = this.results.getVectorResultTypes();
        if (input.unwanted()) {
            this.unwanted = vectors.get(0).getValue().asArray();
        }
        if (input.blocking()) {
            this.blocking = vectors.get(1).getValue().asArray();
        }
        this.drss = vectors.get(2).getValue().asArray();
        if (input.overloading()) {
            this.overloading = this.results.findVector(Overloading.OVERL).getValue().asArray();
        }
        if (input.intermodulation()) {
            this.intermodulation = this.results.findVector(Intermodulation.INTERMOD_SUMMATION).getValue().asArray();
        }
    }

    public ICResult calculate() {
        if (this.input.compatibility() == Compatibility.Compatibility) {
            this.iceCompatibility();
        } else {
            this.iceTranslation();
        }
        return Factory.build(this.prototype);
    }

    private double[] cfcCompositeIRSSVector() {
        ArrayList<double[]> iRssVectors = new ArrayList<double[]>();
        double[] pResult = new double[this.size];
        if (this.input.unwanted()) {
            iRssVectors.add(this.unwanted);
        }
        if (this.input.blocking()) {
            iRssVectors.add(this.blocking);
        }
        if (this.input.intermodulation()) {
            iRssVectors.add(this.intermodulation);
        }
        for (int j = 0; j < this.size; ++j) {
            double rSum = 0.0;
            for (double[] iRssVector : iRssVectors) {
                rSum += Mathematics.dB2Linear(iRssVector[j]);
            }
            pResult[j] = Mathematics.linear2dB(rSum);
        }
        return pResult;
    }

    private double[] cfcCompositeIRSSVectorDerivation(double ref) {
        Function pBlockingResponse = this.scenario.getVictim().getSystem().getReceiver().getBlockingMask().getFunction();
        Function pIntermod = this.scenario.getVictim().getSystem().getReceiver().getIntermodulationRejection();
        double[] pResult = new double[this.size];
        for (int j = 0; j < this.size; ++j) {
            double rSum = 0.0;
            switch (this.input.translation()) {
                case 0: {
                    double rRefInit = pIntermod.evaluate(0.0);
                    if (this.input.intermodulation()) {
                        List<VectorResultType> intermodGroup = this.results.findGroup("iRSS Intermodulation");
                        for (VectorResultType vector : intermodGroup) {
                            double riRSS = vector.getValue().asArray()[j];
                            double rValue = riRSS - 3.0 * (ref - rRefInit);
                            rSum += Mathematics.dB2Linear(rValue);
                        }
                    }
                    if (this.input.unwanted()) {
                        rSum += Mathematics.dB2Linear(this.unwanted[j]);
                    }
                    if (!this.input.blocking()) break;
                    rSum += Mathematics.dB2Linear(this.blocking[j]);
                    break;
                }
                case 1: {
                    double rRefInit = pBlockingResponse.evaluate(0.0);
                    if (this.input.blocking()) {
                        for (VectorResultType vectorResultType : this.allBlocking) {
                            double riRSS = vectorResultType.getValue().asArray()[j];
                            double rValue = riRSS - (ref - rRefInit);
                            rSum += Mathematics.dB2Linear(rValue);
                        }
                    }
                    if (this.input.unwanted()) {
                        rSum += Mathematics.dB2Linear(this.unwanted[j]);
                    }
                    if (!this.input.intermodulation()) break;
                    rSum += Mathematics.dB2Linear(this.intermodulation[j]);
                    break;
                }
                default: {
                    GenericSystemPlugin genericInterferer = null;
                    int genericSystemInterferingLinkIndex = this.input.translation() - 2;
                    int genericInterferers = 0;
                    for (InterferenceLink link : this.scenario.getInterferenceLinks()) {
                        if (!(link.getInterferer().getSystemPlugin() instanceof GenericSystemPlugin)) continue;
                        if (genericInterferers == genericSystemInterferingLinkIndex) {
                            genericInterferer = (GenericSystemPlugin)link.getInterferer().getSystemPlugin();
                        }
                        ++genericInterferers;
                    }
                    double d = genericInterferer.getPower().trial();
                    rSum = 0.0;
                    if (this.input.unwanted()) {
                        rSum += this.power(this.allUnwanted, j, ref, d);
                    }
                    if (this.input.blocking()) {
                        rSum += this.power(this.allBlocking, j, ref, d);
                    }
                    if (!this.input.intermodulation()) break;
                    rSum += Mathematics.dB2Linear(this.intermodulation[j]);
                }
            }
            pResult[j] = Mathematics.linear2dB(rSum);
        }
        return pResult;
    }

    private double power(List<VectorResultType> group, int j, double ref, double rRefInit) {
        double riRSS = group.get(0).getValue().asArray()[j];
        double rSum = Mathematics.dB2Linear(riRSS + ref - rRefInit);
        for (int i = 1; i < group.size(); ++i) {
            rSum += Mathematics.dB2Linear(group.get(i).getValue().asArray()[j]);
        }
        return rSum;
    }

    private double[] cfcCritVector(double[] iRSSComp, double[] NoiseFloor) {
        double[] pResult = new double[this.size];
        Criteria c = this.input.criteria();
        for (int i = 0; i < this.size; ++i) {
            if (c == Criteria.CI) {
                pResult[i] = this.drss[i] - iRSSComp[i];
                continue;
            }
            if (c == Criteria.CNI) {
                pResult[i] = Mathematics.linear2dB(Mathematics.dB2Linear(this.drss[i]) / (Mathematics.dB2Linear(iRSSComp[i]) + Mathematics.dB2Linear(NoiseFloor[i])));
                continue;
            }
            if (c == Criteria.NIN) {
                double rC = Mathematics.dB2Linear(NoiseFloor[i]);
                pResult[i] = Mathematics.linear2dB((rC + Mathematics.dB2Linear(iRSSComp[i])) / rC);
                continue;
            }
            pResult[i] = iRSSComp[i] - NoiseFloor[i];
        }
        return pResult;
    }

    private void iceCompatibility() {
        double rSensVr = this.plugin.getSensitivity();
        double[] noiseFloor = new double[this.size];
        Distribution pNoiseFloor = this.plugin.getNoiseFloor();
        for (int i = 0; i < this.size; ++i) {
            noiseFloor[i] = pNoiseFloor.trial();
        }
        double rProbD = 0.0;
        int rProbN = 0;
        double[] iRSSVectorComposite = this.cfcCompositeIRSSVector();
        double[] critVector = this.cfcCritVector(iRSSVectorComposite, noiseFloor);
        ArrayList<Double> filteredValues = new ArrayList<Double>();
        ArrayList<String> types = new ArrayList<String>();
        if (this.input.unwanted()) {
            types.add("unwanted");
        }
        if (this.input.blocking()) {
            types.add("blocking");
        }
        if (this.input.overloading()) {
            types.add("overloading");
        }
        if (this.input.intermodulation()) {
            types.add("intermodulation");
        }
        String vectorName = (Object)((Object)this.input.criteria()) + " " + ((Object)types).toString();
        for (int i = 0; i < this.size; ++i) {
            boolean bResultTest = true;
            double rdRSSTrial = this.drss[i];
            if (this.filterSensitivity && !(rdRSSTrial > rSensVr)) continue;
            double rCrit = critVector[i];
            filteredValues.add(rCrit);
            rProbD += 1.0;
            if (this.input.overloading() && this.overloading[i] >= 0.0) {
                bResultTest = false;
            }
            if (bResultTest && (this.input.unwanted() || this.input.blocking() || this.input.intermodulation())) {
                bResultTest = this.testProbComplete(rdRSSTrial, rCrit);
            }
            if (!bResultTest) continue;
            ++rProbN;
        }
        Factory.when(this.prototype.compositeVector()).thenReturn(new VectorResultType(Factory.results().group("Interference Calculations", vectorName, "dB"), filteredValues));
        this.results.getVectorResultTypes().add(new VectorResultType(Factory.results().group("Interference Calculations", vectorName, "dB"), filteredValues));
        double probResult = rProbD == 0.0 ? 0.0 : 1.0 - (double)rProbN / rProbD;
        Factory.when(this.prototype.probabilityResult()).thenReturn(probResult);
        Factory.when(this.prototype.drssLargerThanSensitivityResult()).thenReturn(rProbD);
    }

    private void iceTranslation() {
        double rProbD = 0.0;
        double rSensVr = this.plugin.getSensitivity();
        int iRefNbr = this.input.points();
        double rRefStep = (this.input.max() - this.input.min()) / (double)iRefNbr;
        double[] rProduct = new double[iRefNbr + 1];
        double rRef = this.input.min();
        Distribution pNoiseFloor = this.plugin.getNoiseFloor();
        this.allUnwanted = this.results.findGroup("iRSS Unwanted");
        if (this.allUnwanted.isEmpty()) {
            this.allUnwanted = Collections.singletonList(new VectorResultType(Factory.results().value("", ""), this.unwanted));
        }
        this.allBlocking = this.results.findGroup("iRSS Blocking");
        if (this.allBlocking.isEmpty()) {
            this.allBlocking = Collections.singletonList(new VectorResultType(Factory.results().value("", ""), this.blocking));
        }
        int j = 0;
        while (j < iRefNbr) {
            int i;
            rProbD = 0.0;
            double[] iRSSVectorComposite = this.cfcCompositeIRSSVectorDerivation(rRef);
            double[] noiseFloor = new double[this.size];
            for (i = 0; i < this.size; ++i) {
                noiseFloor[i] = pNoiseFloor.trial();
            }
            double[] critVector = this.cfcCritVector(iRSSVectorComposite, noiseFloor);
            for (i = 0; i < this.size; ++i) {
                double rCrit;
                boolean bResultTest;
                double rdRSSTrial = this.drss[i];
                if (rdRSSTrial > rSensVr) {
                    rProbD += 1.0;
                }
                if (!(bResultTest = this.testProbComplete(rdRSSTrial, rCrit = critVector[i]))) continue;
                int n = j;
                rProduct[n] = rProduct[n] + 1.0;
            }
            rProduct[j] = rProbD == 0.0 ? 0.0 : rProduct[j] / rProbD;
            ++j;
            rRef += rRefStep;
        }
        rRef = this.input.min();
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (int j2 = 0; j2 < iRefNbr; ++j2) {
            points.add(new Point2D(rRef, 1.0 - rProduct[j2]));
            rRef += rRefStep;
        }
        Function function = Factory.functionFactory().discreteFunction(points);
        Factory.when(this.prototype.translationResult()).thenReturn(function);
    }

    private boolean testProbComplete(double dRSS, double crit) {
        double rSens = this.plugin.getSensitivity();
        double rCI = this.plugin.getProtectionRatio();
        double rCNI = this.plugin.getExtendedProtectionRatio();
        double rINI = this.plugin.getNoiseAugmentation();
        double rIN = this.plugin.getInterferenceToNoiseRatio();
        switch (this.input.criteria()) {
            case CI: {
                return crit > rCI && dRSS > rSens;
            }
            case CNI: {
                return crit > rCNI && dRSS > rSens;
            }
            case NIN: {
                return crit < rINI && dRSS > rSens;
            }
            case IN: {
                return crit < rIN && dRSS > rSens;
            }
        }
        return false;
    }
}

