/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.generic.ice;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.seamcat.model.Scenario;
import org.seamcat.presentation.menu.ToolBar;
import org.seamcat.simulation.generic.ice.ICResult;
import org.seamcat.simulation.generic.ice.ICResultDetailPanel;
import org.seamcat.simulation.generic.ice.ICResultListElement;

public class ICResultPanel
extends JPanel {
    private final JButton delete;
    private JPanel detail = new JPanel(new BorderLayout());
    private JList list = new JList();
    private DefaultListModel model = new DefaultListModel();
    private List<ICResult> results;
    private JToolBar toolBar = new JToolBar();
    private Scenario scenario;
    private boolean muted = false;
    private JPanel empty = new JPanel(new BorderLayout());

    public ICResultPanel(Scenario scenario, final List<ICResult> results) {
        super(new BorderLayout());
        this.scenario = scenario;
        this.list.setSelectionMode(0);
        JLabel label = new JLabel("<html><p>There are currently no interference calculations</p><p>Use input panel below to enter preferred settings and press 'Calculate' to generate results</p></html>");
        this.empty.add((Component)label, "North");
        this.delete = ToolBar.button("SEAMCAT_ICON_DELETE_TRASH", "TOOLBAR_INTERFERING_LINKS_DELETE_TOOLTIP");
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ICResultPanel.this.muted = true;
                ICResultListElement element = (ICResultListElement)ICResultPanel.this.list.getSelectedValue();
                int idx = ICResultPanel.this.list.getSelectedIndex();
                ICResultPanel.this.model.removeElement(element);
                results.remove(idx);
                ICResultPanel.this.list.revalidate();
                ICResultPanel.this.list.repaint();
                if (ICResultPanel.this.model.size() == 0) {
                    ICResultPanel.this.empty();
                } else {
                    idx = idx < ICResultPanel.this.model.size() ? idx : idx - 1;
                    ICResultPanel.this.list.setSelectedIndex(idx);
                }
                ICResultPanel.this.muted = false;
            }
        });
        this.toolBar.setFocusable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setFloatable(false);
        this.toolBar.add(this.delete);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.list);
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.toolBar, "North");
        leftPanel.add((Component)jScrollPane, "Center");
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.add(leftPanel);
        splitPane.add(this.detail);
        splitPane.setDividerLocation(200);
        this.add((Component)splitPane, "Center");
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!ICResultPanel.this.muted && !e.getValueIsAdjusting()) {
                    ICResultPanel.this.setDetail((ICResultListElement)ICResultPanel.this.list.getSelectedValue());
                }
            }
        });
        this.results = results;
        this.setModel();
    }

    private void setModel() {
        for (ICResult result : this.results) {
            this.model.addElement(new ICResultListElement(this.scenario, result));
        }
        this.list.setModel(this.model);
        this.enableDelete();
        if (this.model.size() > 0) {
            this.list.setSelectedIndex(0);
        } else {
            this.empty();
        }
    }

    private void enableDelete() {
        this.delete.setEnabled(this.model.size() > 0);
    }

    private void setDetail(ICResultListElement element) {
        this.showDetail(new ICResultDetailPanel(this.scenario, element.getResult()));
    }

    private void empty() {
        this.showDetail(this.empty);
    }

    private void showDetail(JComponent component) {
        this.detail.removeAll();
        this.detail.add(component);
        this.detail.revalidate();
        this.detail.repaint();
    }

    public void add(ICResult result) {
        this.muted = true;
        this.results.add(result);
        ICResultListElement element = new ICResultListElement(this.scenario, result);
        this.model.addElement(element);
        this.list.setSelectedValue(element, true);
        this.setDetail(element);
        this.list.updateUI();
        this.enableDelete();
        this.muted = false;
    }
}

