/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.generic.ice;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.eventprocessing.LongTask;
import org.seamcat.model.plugin.eventprocessing.ModelPanel;
import org.seamcat.model.plugin.eventprocessing.PanelDefinition;
import org.seamcat.model.plugin.eventprocessing.Panels;
import org.seamcat.model.plugin.eventprocessing.PostProcessing;
import org.seamcat.model.plugin.eventprocessing.PostProcessingUI;
import org.seamcat.model.simulation.result.SimulationResult;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.types.result.FunctionResultType;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.types.result.VectorResultType;
import org.seamcat.presentation.DialogHelper;
import org.seamcat.presentation.components.BorderPanel;
import org.seamcat.simulation.generic.Intermodulation;
import org.seamcat.simulation.generic.ice.Compatibility;
import org.seamcat.simulation.generic.ice.ICCalculator;
import org.seamcat.simulation.generic.ice.ICInputPanel;
import org.seamcat.simulation.generic.ice.ICResult;
import org.seamcat.simulation.generic.ice.ICResultListElement;
import org.seamcat.simulation.generic.ice.ICResultPanel;
import org.seamcat.simulation.generic.ice.ICResults;
import org.seamcat.simulation.result.ResultsImpl;

public class InterferenceCalculationCustomUI
implements PostProcessingUI {
    private ICResultPanel panel;
    private ICInputPanel inputPanel;

    @Override
    public String getTitle() {
        return "Interference Calculations";
    }

    @Override
    public void buildUI(Scenario scenario, JPanel canvas, Panels panels) {
        canvas.setLayout(new BorderLayout());
        ModelPanel mp = panels.get("results");
        this.panel = new ICResultPanel(scenario, ((ICResults)mp.getModel()).results());
        canvas.add((Component)new BorderPanel(this.panel, "Results"), "Center");
        this.inputPanel = new ICInputPanel(scenario);
        canvas.add((Component)new BorderPanel(this.inputPanel, "Interference Calculation Inputs"), "South");
    }

    @Override
    public PanelDefinition[] panelDefinitions() {
        return new PanelDefinition[]{new PanelDefinition<ICResults>("results", ICResults.class)};
    }

    @PostProcessing(order=1, name="Calculate")
    public LongTask<ICResult> calculate(final SimulationResult result, final Scenario scenario, final ResultsImpl results) {
        Results victimGroup;
        VectorResultType vector;
        final ICResult inputs = this.inputPanel.getInputsAsResult();
        if (!(inputs.unwanted() || inputs.blocking() || inputs.overloading() || inputs.intermodulation())) {
            DialogHelper.noInputSelection();
            return null;
        }
        if (inputs.intermodulation() && (vector = (victimGroup = result.getVictimResults()).findVector(Intermodulation.INTERMOD_SUMMATION)) == null) {
            DialogHelper.noIntermodVectorFound();
            return null;
        }
        if (inputs.compatibility() == Compatibility.Translation && (inputs.min() >= inputs.max() || inputs.points() < 2 || inputs.points() > 1000)) {
            DialogHelper.noValidRange();
            return null;
        }
        return new LongTask<ICResult>(){

            @Override
            public ICResult process() throws Exception {
                return new ICCalculator(scenario, result, inputs, InterferenceCalculationCustomUI.this.inputPanel.filterSensitivity()).calculate();
            }

            @Override
            public void done(ICResult result2) {
                InterferenceCalculationCustomUI.this.panel.add(result2);
                if (result2.compatibility() == Compatibility.Translation) {
                    String unit = "dB";
                    if (result2.translation() > 1) {
                        unit = "dBm";
                    }
                    String name = new ICResultListElement(scenario, result2).toString();
                    UniqueValueDef def = Factory.results().function(name, unit, "Probability");
                    results.getFunctionResultTypes().add(new FunctionResultType(def, result2.translationResult()));
                }
            }
        };
    }
}

