/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.generic.ice;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.presentation.genericgui.GenericPanel;
import org.seamcat.presentation.genericgui.item.DoubleItem;
import org.seamcat.presentation.genericgui.item.IntegerItem;
import org.seamcat.presentation.genericgui.item.SelectionItem;
import org.seamcat.simulation.generic.GenericSystemPlugin;
import org.seamcat.simulation.generic.ice.ICTranslations;

public class TranslationPanel
extends GenericPanel {
    private SelectionItem<String> selectionItem;
    private List<String> selections;
    private DoubleItem min;
    private DoubleItem max;
    private IntegerItem points;

    public TranslationPanel(Scenario scenario) {
        this.selections = TranslationPanel.buildNames(scenario);
        this.selectionItem = ((SelectionItem)new SelectionItem().label("Translation Parameters")).values(this.selections);
        this.selectionItem.initialize();
        this.addItem(this.selectionItem);
        this.min = new DoubleItem().label("Min (dBm or dB)");
        this.min.initialize();
        this.min.setValue(0.0);
        this.addItem(this.min);
        this.max = new DoubleItem().label("Max (dBm or dB)");
        this.max.initialize();
        this.max.setValue(100.0);
        this.addItem(this.max);
        this.points = new IntegerItem().label("# points");
        this.points.initialize();
        this.points.setValue(100);
        this.addItem(this.points);
        this.initializeWidgets();
    }

    public ICTranslations getModel() {
        ICTranslations prototype = Factory.prototype(ICTranslations.class);
        Factory.when(prototype.translation()).thenReturn(this.selections.indexOf(this.selectionItem.getValue()));
        Factory.when(prototype.min()).thenReturn(this.min.getValue());
        Factory.when(prototype.max()).thenReturn(this.max.getValue());
        Factory.when(prototype.points()).thenReturn(this.points.getValue());
        return Factory.build(prototype);
    }

    public static List<String> buildNames(Scenario scenario) {
        ArrayList<String> selections = new ArrayList<String>();
        selections.add("Blocking response level / Victim");
        selections.add("Intermodulation response level / Victim");
        for (InterferenceLink link : scenario.getInterferenceLinks()) {
            SystemPlugin systemPlugin = link.getInterferer().getSystemPlugin();
            if (!(systemPlugin instanceof GenericSystemPlugin)) continue;
            selections.add("Interfering transmitted power / " + link.toString());
        }
        return selections;
    }

    public static String nameFromIndex(Scenario scenario, int index) {
        return TranslationPanel.buildNames(scenario).get(index);
    }
}

