/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.hybrid;

import org.apache.log4j.Logger;
import org.seamcat.cdma.CDMADownlinkSystem;
import org.seamcat.cdma.CDMALinkLevelData;
import org.seamcat.cdma.CDMASystem;
import org.seamcat.cdma.CDMAUplinkSystem;
import org.seamcat.dmasystems.AbstractDmaSystem;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.VectorSpace;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Context;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.plugin.system.SimulationInstance;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.plugin.system.SystemSpaces;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.systems.UIToModelConverter;
import org.seamcat.model.systems.cdma.CDMAMobile;
import org.seamcat.model.systems.cdma.CDMAUpLinkGeneralTab;
import org.seamcat.model.systems.cdma.SystemModelCDMAUpLink;
import org.seamcat.model.systems.cellulargrid.HexagonCells;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.model.types.Receiver;
import org.seamcat.model.types.Transmitter;
import org.seamcat.model.types.result.Results;
import org.seamcat.plugin.AntennaGainConfiguration;
import org.seamcat.simulation.cellular.CDMAUpLinkVictim;
import org.seamcat.simulation.cellular.MobileStation;
import org.seamcat.simulation.cellular.cdma.CDMASettings;
import org.seamcat.simulation.cellular.cdma.CDMAUpLink;
import org.seamcat.simulation.hybrid.HybridCellularSimulation;
import org.seamcat.simulation.hybrid.HybridConsistencyCheck;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class HybridCDMAUpLinkPlugin
extends HybridSystemPlugin<SystemModelCDMAUpLink>
implements SystemPlugin<SystemModelCDMAUpLink> {
    private static Logger LOG = Logger.getLogger(HybridCDMAUpLinkPlugin.class);
    private SystemModelCDMAUpLink ui;
    private Scenario scenario;
    private AbstractDmaSystem dmaSystem;
    private RadioSystem system;

    @Override
    public SimulationInstance simulationInstance(Context context, SystemSpaces sectorShapes) {
        if (context.isVictim() && LOG.isDebugEnabled()) {
            LOG.debug(String.format("Generating %d events", this.scenario.numberOfEvents()));
            LOG.debug("Position of Victim Receiver is dynamic");
        }
        this.simulation = new HybridCellularSimulation(context.isVictim(), this.scenario, this.dmaSystem);
        return this.simulation;
    }

    @Override
    public Point2D getVictimPosition(VictimResultCollector collector, String relativeTo) {
        for (Victim victim : collector.getVictims()) {
            if (!(victim instanceof CDMAUpLinkVictim) || !((CDMAUpLinkVictim)victim).isConnectedToReferenceCell()) continue;
            return victim.getLinkResult().rxAntenna().getPosition();
        }
        return Point2D.ORIGIN;
    }

    @Override
    public String title() {
        return "Total sum per BS in reference cell";
    }

    @Override
    public String information() {
        return "Sum of contributions of all external interferer(s) perceived by the BS.";
    }

    @Override
    public void setUI(SystemModelCDMAUpLink ui) {
        this.ui = ui;
        this.setLayout(ui.positioning().position());
    }

    @Override
    public SystemModelCDMAUpLink getUI() {
        return this.ui;
    }

    @Override
    public void prepareSimulation(Scenario scenario) {
        this.scenario = scenario;
        this.convertUI();
    }

    private void convertUI() {
        CDMADownlinkSystem sys = new CDMADownlinkSystem(this);
        sys.setPlugin(this);
        CDMAUplinkSystem cdmaUplinkSystem = new CDMAUplinkSystem(sys);
        CDMAUpLinkGeneralTab general = this.ui.generalSettings();
        this.setCDMASettings(HybridCDMAUpLinkPlugin.cdmaSettings(general));
        this.setReceiverNoiseFigure(general.generalSettings().receiverNoiseFigure());
        this.setBandwidth(general.generalSettings().bandwidth());
        this.setHandoverMargin(general.generalSettings().handoverMargin());
        this.setMinimumCouplingLoss(general.generalSettings().minimumCouplingLoss());
        this.setUsersPerCell(general.cdmaCapacity().initUsersPerCell());
        Receiver receiver = UIToModelConverter.getDmaReceiver(general.receiverSettings().standardDesensitisation(), general.receiverSettings().targetINR(), general.generalSettings().receiverNoiseFigure(), general.receiverSettings().blockingMask(), general.generalSettings().bandwidth(), Factory.results().convert(general.localEnvironments().receiverEnvironments()), this.ui.positioning().baseStation().antennaGain(), this.ui.positioning().baseStation().antennaHeight());
        double bandwidth = general.generalSettings().bandwidth();
        Transmitter transmitter = UIToModelConverter.getDmaTransmitter(this.ui.positioning().mobile().antennaHeight(), general.transmitterSettings().emissionMask(), general.transmitterSettings().emissionFloor().getValue(), general.transmitterSettings().emissionFloor().isRelevant(), bandwidth, new Bounds(bandwidth, bandwidth, true), Factory.results().convert(general.localEnvironments().transmitterEnvironments()), (AntennaGainConfiguration)Factory.antennaGainFactory().getPeakGainAntenna());
        UIToModelConverter.handlePosition(this, this.ui.positioning().position());
        CDMAMobile mobile = this.ui.positioning().mobile();
        this.setMs(new MobileStation(mobile.antennaHeight(), mobile.antennaGain(), mobile.mobility()));
        this.setBs(UIToModelConverter.convert(this.ui.positioning().baseStation()));
        PropagationModel pm = general.propagationModel();
        cdmaUplinkSystem.setRadioSystem(new RadioSystem(receiver, transmitter, pm));
        this.dmaSystem = cdmaUplinkSystem;
        this.dmaSystem.setPlugin(this);
        this.system = cdmaUplinkSystem.getRadioSystem();
    }

    @Override
    public RadioSystem getSystem(Context context) {
        return this.system;
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Scenario scenario, Validator validator) {
        if (context.getOrigin() == Origin.SYSTEM) {
            HybridConsistencyCheck.checkVictim(scenario, this.system, validator);
        } else if (context.getOrigin() == Origin.INTERFERENCE_LINK) {
            HybridConsistencyCheck.checkInterferer(context.getInterferenceLink(), this.system, validator);
        }
    }

    @Override
    public void preSimulation(Context context, Results results) {
        this.dmaSystem.initialize(results, null);
        double frequency = context.getFrequency().trial();
        this.dmaSystem.performPreSimulationTasks(frequency);
        CDMASystem cdma = (CDMASystem)this.dmaSystem;
        cdma.findNonInterferedCapacity(results, this.ui);
    }

    @Override
    public void postSimulation(Context context, Results results) {
        if (context.isVictim()) {
            int capacity = results.findIntValue(CDMASystem.NON_INTERFERED_CAPACITY);
            HybridSystemPlugin.calculateCDMALosses(capacity, results);
        }
    }

    @Override
    public VectorSpace getInterferenceLinkSystemCoverage(boolean victim, ConsistencyCheckContext context) {
        return this.getRange();
    }

    private static CDMASettings cdmaSettings(CDMAUpLinkGeneralTab ui) {
        CDMASettings result = new CDMASettings();
        result.setUpLinkSettings(HybridCDMAUpLinkPlugin.upLink(ui.cdmaUplink()));
        result.setCallDropThreshold(ui.generalSettings().callDropThreshold());
        result.setDeltaUsersPerCell(ui.cdmaCapacity().deltaUsersPerCell());
        result.setNumberOfTrials(ui.cdmaCapacity().numberOfTrials());
        result.setSimulateNonInterferedCapacity(ui.cdmaCapacity().simulateNonInterferedCapacity());
        result.setTargetNoiseRisePrecision(ui.cdmaCapacity().targetNoiseRisePrecision());
        result.setVoiceBitRate(ui.generalSettings().voiceBitRate());
        result.setVoiceActivityFactor(ui.generalSettings().voiceActivityFactor());
        result.setLld(new CDMALinkLevelData(ui.generalSettings().lld()));
        return result;
    }

    private static CDMAUpLink upLink(org.seamcat.model.systems.cdma.CDMAUpLink ui) {
        CDMAUpLink link = new CDMAUpLink();
        link.setMSConvergencePrecision(ui.pcConvergencePrecision());
        link.setMSMaximumTransmitPower(ui.msMaximumTransmitPower());
        link.setMSPowerControlRange(ui.msPowerControlRange());
        link.setTargetNetworkNoiseRise(ui.targetNetworkNoiseRise());
        link.setCellOptimization(ui.cellOptimization());
        return link;
    }

    @Override
    public SystemSpaces generateSystemSpaces(SystemSpaces enclosing) {
        return HexagonCells.generate(true, this.getCellRadius(), this.getTierSetup(), this.getSectorSetup(), this.getIndexOfReferenceCell());
    }
}

