/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.hybrid;

import org.seamcat.cdma.CDMALinkLevelData;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.generic.PathLossCorrelationUI;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.scenariocheck.InterferingLinkCheck;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.plugin.PropagationModelConfiguration;
import org.seamcat.presentation.WarningColors;
import org.seamcat.simulation.cellular.cdma.CDMASettings;
import org.seamcat.simulation.cellular.ofdma.OFDMASettings;
import org.seamcat.simulation.hybrid.HybridCDMADownLinkPlugin;
import org.seamcat.simulation.hybrid.HybridCDMAUpLinkPlugin;
import org.seamcat.simulation.hybrid.HybridOFDMADownLinkPlugin;
import org.seamcat.simulation.hybrid.HybridOFDMAUpLinkPlugin;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class HybridConsistencyCheck {
    public static void checkVictim(Scenario scenario, RadioSystem victim, Validator validator) {
        HybridSystemPlugin plugin = (HybridSystemPlugin)scenario.getVictim().getSystemPlugin();
        HybridConsistencyCheck.checkCouplingLossPercentile(plugin, victim, validator);
        Bounds bounds = scenario.getVictim().getFrequency().getBounds();
        double rFreqVrMin = bounds.getMin();
        double rFreqVrMax = bounds.getMax();
        Function function = victim.getReceiver().getBlockingMask().getFunction();
        if (!function.isConstant()) {
            DiscreteFunction func = (DiscreteFunction)function;
            double min = func.getBounds().getMin();
            double max = func.getBounds().getMax();
            for (InterferenceLink link : scenario.getInterferenceLinks()) {
                Distribution freq = link.getFrequency();
                Bounds itbounds = freq.getBounds();
                if (!itbounds.isBounded()) continue;
                String name = link.getInterferer().getName();
                if (rFreqVrMin == rFreqVrMax && itbounds.getMax() == itbounds.getMin()) {
                    if (rFreqVrMax - itbounds.getMax() == 0.0) {
                        if (max < itbounds.getMax() - rFreqVrMax) {
                            validator.error("Blocking response upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                        }
                        if (min > rFreqVrMax - itbounds.getMin()) {
                            validator.error("Blocking response lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                        }
                    }
                    if (rFreqVrMax - itbounds.getMax() < 0.0 && max < itbounds.getMax() - rFreqVrMax) {
                        validator.error("Blocking response upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                    if (!(rFreqVrMax - itbounds.getMax() > 0.0) || !(min > itbounds.getMin() - rFreqVrMax)) continue;
                    validator.error("Blocking response lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    continue;
                }
                if (rFreqVrMin - itbounds.getMin() < 0.0 && rFreqVrMax - itbounds.getMin() < 0.0 && max < itbounds.getMax() - rFreqVrMin) {
                    validator.error("Blocking response upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                }
                if (rFreqVrMin - itbounds.getMin() < 0.0 && rFreqVrMax - itbounds.getMin() >= 0.0 && rFreqVrMax - itbounds.getMax() < 0.0) {
                    if (max < itbounds.getMax() - rFreqVrMin) {
                        validator.error("Blocking response upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                    if (min > itbounds.getMin() - rFreqVrMax) {
                        validator.error("Blocking response lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMin()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMax) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                }
                if (rFreqVrMin - itbounds.getMin() >= 0.0 && rFreqVrMax - itbounds.getMax() <= 0.0) {
                    if (max < itbounds.getMax() - rFreqVrMin) {
                        validator.error("Blocking response upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                    if (min > itbounds.getMin() - rFreqVrMax) {
                        validator.error("Blocking response lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMin()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMax) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                }
                if (rFreqVrMin - itbounds.getMin() > 0.0 && rFreqVrMin - itbounds.getMax() <= 0.0 && rFreqVrMax - itbounds.getMax() > 0.0) {
                    if (max < itbounds.getMax() - rFreqVrMin) {
                        validator.error("Blocking response upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                    if (min > itbounds.getMin() - rFreqVrMax) {
                        validator.error("Blocking response lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMin()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMax) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                }
                if (!(rFreqVrMin - itbounds.getMax() > 0.0) || !(rFreqVrMax - itbounds.getMax() > 0.0) || !(min > itbounds.getMin() - rFreqVrMax)) continue;
                validator.error("Blocking response lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMin()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMax) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
            }
        }
        if (plugin instanceof HybridOFDMADownLinkPlugin || plugin instanceof HybridOFDMAUpLinkPlugin) {
            int usRB;
            int bsRB;
            PropagationModel pm;
            OFDMASettings ofdma = plugin.getOFDMASettings();
            if (ofdma.getPathLossCorrelation().isUsingPathLossCorrelation() && (pm = victim.getPropagationModel()) instanceof PropagationModelConfiguration && pm.isVariationSelected()) {
                validator.error("<br>The system has both pathloss correlation and variation of the internal propagation model selected. This conflicts with the path loss correlation concept.<p " + (Object)((Object)WarningColors.ACCURARY_WARNING) + ">It is recommended to de-select 'Variations' on the internal propagation model " + pm.toString() + "</p>");
            }
            if ((bsRB = ofdma.getMaxSubCarriersPerBaseStation()) % (usRB = ofdma.getNumberOfSubCarriersPerMobileStation()) != 0) {
                validator.error("<br/>You have selected a maximum of " + bsRB + " resourceblocks per basestation and " + usRB + " resourceblocks per user. This will result in a not fully loaded system.<br />With your current settings the system can not be loaded more than " + Mathematics.round(100.0 - (double)(bsRB / usRB) / ((double)bsRB * 1.0) * 100.0) + "%");
            }
            Function maskUsed = victim.getReceiver().getBlockingMask().getFunction();
            double referenceAtZero = maskUsed.evaluate(0.0);
            double bw = 0.0;
            if (!maskUsed.isConstant()) {
                for (double f = 0.0; f < maskUsed.getBounds().getMax(); f += 0.001) {
                    if (!(Math.abs(referenceAtZero - maskUsed.evaluate(f)) > 3.0)) continue;
                    bw = f;
                    break;
                }
                int rBandwidthToRB = (int)(2.0 * bw * 1000.0 / ofdma.getBandwidthOfResourceBlock());
                int tRBtolerance = (int)(0.2 * (double)usRB);
                if (Math.abs(usRB - rBandwidthToRB) > tRBtolerance) {
                    validator.error("<HtMl><br/>The bandwidth of the Blocking mask (" + Math.rint(2.0 * bw * 1000.0) / 1000.0 + " MHz) conflicts with the number of RBs (" + usRB + ") allocated to the UEs.<br/><em style='color: maroon; font-weight: bold';>It is highly recommended to use a mask which complies with the number of RBs of the UEs </em>");
                }
            }
        }
        if (plugin instanceof HybridCDMAUpLinkPlugin || plugin instanceof HybridCDMADownLinkPlugin) {
            CDMASettings cdma = plugin.getCDMASettings();
            boolean uplink = cdma.getUpLinkSettings() != null;
            Distribution freq = scenario.getVictim().getFrequency();
            if (!freq.getBounds().isBounded()) {
                validator.error("Frequency of CDMA System is unbounded");
            }
            if (cdma.getLld() == null) {
                validator.error("No Link Level Data selected for CDMA System");
            } else {
                double deltaFreq = Math.abs(freq.trial() - cdma.getLld().getFrequency());
                if (deltaFreq > 300.0) {
                    validator.error("Frequency difference between system and link level data for CDMA System is " + deltaFreq + " Mhz. Link level data may not be applicable at this frequency.");
                }
                if (cdma.getLld().getLinkType() == CDMALinkLevelData.LinkType.UPLINK != uplink) {
                    validator.error("Link direction mismatch between link level data and Victim CDMA System");
                }
            }
            if (cdma.isSimulateNonInterferedCapacity()) {
                if (uplink && cdma.getTargetNoiseRisePrecision() < 0.0) {
                    validator.error("Target Noise Rise precision is negative!");
                } else if (!uplink && cdma.getToleranceOfInitialOutage() < 0.0) {
                    validator.error("Initial allowable outage percentage is negative!");
                }
                if (uplink && cdma.getToleranceOfInitialOutage() >= 1.0) {
                    validator.error("Initial Allowed Outage is to high!");
                }
            }
            if (uplink) {
                if (cdma.getUpLinkSettings().getMSConvergencePrecision() < 0.0) {
                    validator.error("Power Control Convergence Precision is negative!");
                } else if (cdma.getUpLinkSettings().getMSConvergencePrecision() == 0.0) {
                    validator.error("Power Control Convergence Precision is 0 - this might cause EGE to enter never ending loop");
                } else if (cdma.getUpLinkSettings().getMSConvergencePrecision() > 0.1) {
                    validator.error("Power Control Convergence Precision is more than 0.1 - this is not recommended");
                }
            }
        }
    }

    public static void checkInterferer(InterferenceLink link, RadioSystem cs, Validator validator) {
        HybridSystemPlugin plugin = (HybridSystemPlugin)link.getInterferer().getSystemPlugin();
        HybridConsistencyCheck.checkCouplingLossPercentile(plugin, cs, validator);
        if (plugin instanceof HybridOFDMAUpLinkPlugin || plugin instanceof HybridOFDMADownLinkPlugin) {
            if (link.getCorrelationSettings().getCorrelationConfiguration(PathLossCorrelationUI.class).usePathLossCorrelation() && link.getPropagationModel().isVariationSelected()) {
                validator.error("On the interfering link both the path loss correlation and the variations of the propagation model are selected. <br>This conflicts with the path loss correlation concept.<p " + (Object)((Object)WarningColors.ACCURARY_WARNING) + ">It is recommended to de-select 'Variations' on the interfering link propagation model " + link.getPropagationModel().toString() + "</p>");
            }
            if (plugin.getOFDMASettings().getUpLinkSettings() != null) {
                int usRB = plugin.getOFDMASettings().getNumberOfSubCarriersPerMobileStation();
                int bsRB = plugin.getOFDMASettings().getMaxSubCarriersPerBaseStation();
                if (bsRB % usRB != 0) {
                    validator.error("<br/>You have selected a maximum of " + bsRB + " resourceblocks per basestation and " + usRB + " resourceblocks per user. This will result in a not fully loaded system.<br />With your current settings the system can not be loaded more than " + Mathematics.round(100.0 - (double)(bsRB / usRB) / ((double)bsRB * 1.0) * 100.0) + "%");
                }
                MaskFunction emissionMask = cs.getTransmitter().getEmissionsMask().getEmissionMask();
                double referencePower = emissionMask.evaluate(0.0);
                double bw = 0.0;
                for (double f = 0.0; f < emissionMask.getBounds().getMax(); f += 0.1) {
                    if (!(Math.abs(referencePower - emissionMask.evaluate(f)) > 23.0)) continue;
                    bw = f;
                    break;
                }
                int rBandwidthToRB = (int)(2.0 * bw * 1000.0 / plugin.getOFDMASettings().getBandwidthOfResourceBlock());
                int tRBtolerance = (int)(0.2 * (double)usRB);
                if (Math.abs(rBandwidthToRB - usRB) > tRBtolerance) {
                    validator.error("<HtMl>The bandwidth of the UE emission mask (" + Math.rint(2.0 * bw * 1000.0) / 1000.0 + " MHz) conflicts with the number of RBs (" + usRB + ") allocated to the UEs.<br/><em style='color: maroon; font-weight: bold';>It is highly recommended to use a mask which complies with the number of RBs of the UEs </em>");
                }
            } else {
                int bsRB = plugin.getOFDMASettings().getMaxSubCarriersPerBaseStation();
                MaskFunction emissionMask = cs.getTransmitter().getEmissionsMask().getEmissionMask();
                double referencePower = emissionMask.evaluate(0.0);
                double bw = 0.0;
                for (double f = 0.0; f < emissionMask.getBounds().getMax(); f += 0.1) {
                    if (!(Math.abs(referencePower - emissionMask.evaluate(f)) > 23.0)) continue;
                    bw = f;
                    break;
                }
                int rBandwidthToRB = (int)(2.0 * bw * 1000.0 / plugin.getOFDMASettings().getBandwidthOfResourceBlock());
                int tRBtolerance = (int)(0.2 * (double)bsRB);
                if (Math.abs(rBandwidthToRB - bsRB) > tRBtolerance) {
                    validator.error("<HtMl>The bandwidth of the BS emission mask (" + Math.rint(2.0 * bw * 1000.0) / 1000.0 + " MHz) conflicts with the number of RBs (" + bsRB + ") allocated to the BS.<br/><em style='color: maroon; font-weight: bold';>It is highly recommended to use a mask which complies with the number of RBs of the BS </em>");
                }
            }
        }
        if (plugin instanceof HybridCDMAUpLinkPlugin || plugin instanceof HybridCDMADownLinkPlugin) {
            double deltaFreq;
            CDMASettings cdma = plugin.getCDMASettings();
            Distribution freq = link.getFrequency();
            String name = link.getInterferer().getName();
            if (!freq.getBounds().isBounded()) {
                validator.error("Frequency of CDMA System is unbounded for: " + name);
            }
            if ((deltaFreq = Math.abs(freq.trial() - cdma.getLld().getFrequency())) > 300.0) {
                validator.error("Frequency difference between system and link level data for CDMA System:" + name + " is " + deltaFreq + " Mhz. Link level data may not be applicable at this frequency.<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
            }
            boolean upLink = plugin instanceof HybridCDMAUpLinkPlugin;
            if (cdma.getLld().getLinkType() == CDMALinkLevelData.LinkType.UPLINK != upLink) {
                validator.error("Link direction mismatch between link level data and CDMA System: " + name);
            }
        }
    }

    private static void checkCouplingLossPercentile(HybridSystemPlugin plugin, RadioSystem cellularSystem, Validator validator) {
        OptionalValue<Double> percentile;
        if (plugin.getOFDMASettings() != null && plugin.getOFDMASettings().getUpLinkSettings() != null && (percentile = ((HybridOFDMAUpLinkPlugin)plugin).getPercentile()).isRelevant()) {
            if (percentile.getValue() < plugin.getMinimumCouplingLoss()) {
                validator.error("Coupling loss percentile out of range: it cannot be lower than the specified value for the Minimum Coupling Loss' (" + plugin.getMinimumCouplingLoss() + " dB)");
            }
            double B = cellularSystem.getTransmitter().getBandwidth();
            double UE_max_tx_power = plugin.getOFDMASettings().getUpLinkSettings().getMaximumAllowedTransmitPowerOfMS();
            double k = 1.38E-23;
            double T2 = 293.0;
            double NF = plugin.getReceiverNoiseFigure();
            double Thermal_noise = 10.0 * Math.log10(k * T2) + 30.0 + 10.0 * Math.log10(B) + 60.0;
            double Noise_floor = Thermal_noise + NF;
            double SINR_minimum = -10.0;
            double CL_xile_upper_limit = UE_max_tx_power - (Noise_floor + SINR_minimum);
            if (percentile.getValue() > CL_xile_upper_limit) {
                validator.error("Coupling loss percentile out of range: it cannot be larger than: " + CL_xile_upper_limit + " dB.<br>This is: [Maximum power of the MS (dBm)  \u2013 (Noise Floor for the used bandwith by the MS (dBm) + minimum SINR value from the bitrate mapping table (dB)]");
            }
        }
    }

    public static void checkPathLossCorrelationInterferer(ConsistencyCheckContext context, Validator validator) {
        if (context.getInterferenceLink().getCorrelationSettings().getCorrelationConfiguration(PathLossCorrelationUI.class).usePathLossCorrelation() && context.getInterferenceLink().getPropagationModel().isVariationSelected()) {
            validator.error("On the interfering link both the path loss correlation and the variations of the propagation model are selected. <br>This conflicts with the path loss correlation concept.<p " + (Object)((Object)WarningColors.ACCURARY_WARNING) + ">It is recommended to de-select 'Variations' on the interfering link propagation model " + context.getInterferenceLink().getPropagationModel().toString() + "</p>");
        }
    }
}

