/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.hybrid;

import org.apache.log4j.Logger;
import org.seamcat.cdma.CDMADownlinkSystem;
import org.seamcat.dmasystems.AbstractDmaSystem;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.distributions.UniformDistribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.VectorSpace;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Context;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.plugin.system.SimulationInstance;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.plugin.system.SystemSpaces;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.systems.UIToModelConverter;
import org.seamcat.model.systems.cellulargrid.HexagonCells;
import org.seamcat.model.systems.ofdma.OFDMADownLinkGeneralTab;
import org.seamcat.model.systems.ofdma.SystemModelOFDMADownLink;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.model.types.Receiver;
import org.seamcat.model.types.Transmitter;
import org.seamcat.model.types.result.Results;
import org.seamcat.ofdma.DownlinkOfdmaSystem;
import org.seamcat.plugin.AntennaGainConfiguration;
import org.seamcat.simulation.cellular.OFDMADownLinkVictim;
import org.seamcat.simulation.hybrid.HybridCellularSimulation;
import org.seamcat.simulation.hybrid.HybridConsistencyCheck;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class HybridOFDMADownLinkPlugin
extends HybridSystemPlugin<SystemModelOFDMADownLink>
implements SystemPlugin<SystemModelOFDMADownLink> {
    private static Logger LOG = Logger.getLogger(HybridOFDMADownLinkPlugin.class);
    private SystemModelOFDMADownLink ui;
    private Scenario scenario;
    private AbstractDmaSystem dmaSystem;
    private RadioSystem system;

    @Override
    public SimulationInstance simulationInstance(Context context, SystemSpaces sectorShapes) {
        if (context.isVictim() && LOG.isDebugEnabled()) {
            LOG.debug(String.format("Generating %d events", this.scenario.numberOfEvents()));
            LOG.debug("Position of Victim Receiver is dynamic");
        }
        this.simulation = new HybridCellularSimulation(context.isVictim(), this.scenario, this.dmaSystem);
        return this.simulation;
    }

    @Override
    public Point2D getVictimPosition(VictimResultCollector collector, String relativeTo) {
        for (Victim victim : collector.getVictims()) {
            if (!(victim instanceof OFDMADownLinkVictim) || !((OFDMADownLinkVictim)victim).isConnectedToReferenceCell()) continue;
            return victim.getLinkResult().txAntenna().getPosition();
        }
        return Point2D.ORIGIN;
    }

    @Override
    public String title() {
        return "Average over the UEs in reference cell";
    }

    @Override
    public String information() {
        return "<html>Sum of contributions of all external interferer(s) perceived by each UE in the reference cell, <br>averaged over the number of UEs in the reference cell.</html>";
    }

    @Override
    public void setUI(SystemModelOFDMADownLink ui) {
        this.ui = ui;
        this.setLayout(ui.positioning().position());
    }

    @Override
    public SystemModelOFDMADownLink getUI() {
        return this.ui;
    }

    @Override
    public void prepareSimulation(Scenario scenario) {
        this.scenario = scenario;
        this.convertUI();
    }

    private void convertUI() {
        DownlinkOfdmaSystem downLinkOfdmaSystem = new DownlinkOfdmaSystem(new CDMADownlinkSystem(this));
        OFDMADownLinkGeneralTab general = this.ui.generalSettings();
        this.setOFDMASettings(UIToModelConverter.convert(general));
        this.setReceiverNoiseFigure(general.generalSettings().receiverNoiseFigure());
        this.setBandwidth(general.generalSettings().bandwidth());
        this.setHandoverMargin(general.generalSettings().handoverMargin());
        this.setMinimumCouplingLoss(general.generalSettings().minimumCouplingLoss());
        this.setUsersPerCell(20);
        double rxBandwidth = general.generalSettings().bandwidthResourceBlock() * (double)general.generalSettings().maxSubcarriersMs() / 1000.0;
        Receiver receiver = UIToModelConverter.getDmaReceiver(general.receiverSettings().standardDesensitisation(), general.receiverSettings().targetINR(), general.generalSettings().receiverNoiseFigure(), general.receiverSettings().blockingMask(), rxBandwidth, Factory.results().convert(general.localEnvironments().receiverEnvironments()), Factory.antennaGainFactory().getPeakGainAntenna(), this.ui.positioning().mobile().antennaHeight());
        double txBandwidth = general.generalSettings().bandwidthResourceBlock() * (double)general.generalSettings().maxSubcarriersBs() / 1000.0;
        Transmitter transmitter = UIToModelConverter.getDmaTransmitter(this.ui.positioning().baseStation().antennaHeight(), general.transmitterSettings().emissionMask(), general.transmitterSettings().emissionFloor().getValue(), general.transmitterSettings().emissionFloor().isRelevant(), txBandwidth, new Bounds(txBandwidth, txBandwidth, true), Factory.results().convert(general.localEnvironments().transmitterEnvironments()), (AntennaGainConfiguration)this.ui.positioning().baseStation().antennaGain());
        UIToModelConverter.handlePosition(this, this.ui.positioning().position());
        this.setMs(UIToModelConverter.convert(this.ui.positioning().mobile()));
        this.setBs(UIToModelConverter.convert(this.ui.positioning().baseStation()));
        PropagationModel pm = general.propagationModel();
        downLinkOfdmaSystem.setRadioSystem(new RadioSystem(receiver, transmitter, pm));
        this.dmaSystem = downLinkOfdmaSystem;
        this.dmaSystem.setPlugin(this);
        this.system = downLinkOfdmaSystem.getRadioSystem();
    }

    @Override
    public RadioSystem getSystem(Context context) {
        return this.system;
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Scenario scenario, Validator validator) {
        if (context.getOrigin() == Origin.SYSTEM) {
            HybridConsistencyCheck.checkVictim(scenario, this.system, validator);
        } else if (context.getOrigin() == Origin.INTERFERENCE_LINK) {
            HybridConsistencyCheck.checkInterferer(context.getInterferenceLink(), this.system, validator);
        }
    }

    @Override
    public void preSimulation(Context context, Results pre) {
        this.dmaSystem.initialize(pre, null);
        double frequency = context.getFrequency().trial();
        this.dmaSystem.performPreSimulationTasks(frequency);
        double bw = this.system.getTransmitter().getBandwidth();
        UniformDistribution freq = Factory.distributionFactory().getUniformDistribution(frequency - bw / 2.0, frequency + bw / 2.0);
        context.getSystemPlugin().setFrequency(freq);
    }

    @Override
    public void postSimulation(Context context, Results results) {
        if (context.isVictim()) {
            HybridSystemPlugin.calculateOFDMALosses(results);
        }
    }

    @Override
    public VectorSpace getInterferenceLinkSystemCoverage(boolean victim, ConsistencyCheckContext context) {
        return this.getRange();
    }

    @Override
    public SystemSpaces generateSystemSpaces(SystemSpaces enclosing) {
        return HexagonCells.generate(false, this.getCellRadius(), this.getTierSetup(), this.getSectorSetup(), this.getIndexOfReferenceCell());
    }
}

