/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.hybrid;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.seamcat.cdma.CDMADownlinkSystem;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.distributions.UniformDistribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.VectorSpace;
import org.seamcat.model.generic.PathLossCorrelationUI;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Context;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.plugin.system.SimulationInstance;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.plugin.system.SystemSpaces;
import org.seamcat.model.plugin.system.optional.AsVictimInterferingLink;
import org.seamcat.model.plugin.system.optional.AsVictimInterferingLinkDefinition;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.systems.UIToModelConverter;
import org.seamcat.model.systems.cellulargrid.HexagonCells;
import org.seamcat.model.systems.ofdma.OFDMAUpLinkGeneralTab;
import org.seamcat.model.systems.ofdma.SystemModelOFDMAUpLink;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.model.types.Receiver;
import org.seamcat.model.types.Transmitter;
import org.seamcat.model.types.result.DoubleResultType;
import org.seamcat.model.types.result.Results;
import org.seamcat.ofdma.UplinkOfdmaSystem;
import org.seamcat.plugin.AntennaGainConfiguration;
import org.seamcat.presentation.WarningColors;
import org.seamcat.simulation.cellular.ofdma.OFDMASettings;
import org.seamcat.simulation.cellular.ofdma.OFDMAUpLink;
import org.seamcat.simulation.hybrid.HybridCellularSimulation;
import org.seamcat.simulation.hybrid.HybridConsistencyCheck;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class HybridOFDMAUpLinkPlugin
extends HybridSystemPlugin<SystemModelOFDMAUpLink>
implements SystemPlugin<SystemModelOFDMAUpLink>,
AsVictimInterferingLink {
    private static Logger LOG = Logger.getLogger(HybridOFDMAUpLinkPlugin.class);
    private SystemModelOFDMAUpLink ui;
    private Scenario scenario;
    private RadioSystem victim;
    private RadioSystem interferer;
    private UplinkOfdmaSystem oldVictim;
    private UplinkOfdmaSystem oldInterferer;
    private OptionalValue<Double> percentile;

    @Override
    public SimulationInstance simulationInstance(Context context, SystemSpaces sectorShapes) {
        if (context.isVictim() && LOG.isDebugEnabled()) {
            LOG.debug(String.format("Generating %d events", this.scenario.numberOfEvents()));
            LOG.debug("Position of Victim Receiver is dynamic");
        }
        this.simulation = context.isVictim() ? new HybridCellularSimulation(context.isVictim(), this.scenario, this.oldVictim) : new HybridCellularSimulation(context.isVictim(), this.scenario, this.oldInterferer);
        return this.simulation;
    }

    @Override
    public Point2D getVictimPosition(VictimResultCollector collector, String relativeTo) {
        return this.oldVictim.getReferenceCell().getPosition();
    }

    @Override
    public String title() {
        return "Total sum per BS in reference cell";
    }

    @Override
    public String information() {
        return "Sum of contributions of all external interferer(s) perceived by the BS.";
    }

    @Override
    public void setUI(SystemModelOFDMAUpLink ui) {
        this.ui = ui;
        this.setLayout(ui.positioning().position());
    }

    @Override
    public SystemModelOFDMAUpLink getUI() {
        return this.ui;
    }

    @Override
    public void prepareSimulation(Scenario scenario) {
        this.scenario = scenario;
        this.convertUI();
    }

    private void convertUI() {
        OFDMAUpLinkGeneralTab general = this.ui.generalSettings();
        UplinkOfdmaSystem uplinkOfdmaSystem = new UplinkOfdmaSystem(new CDMADownlinkSystem(this));
        this.setPercentile(this.ui.generalSettings().ofdmaUpLink().percentile());
        this.setOFDMASettings(UIToModelConverter.convert(general));
        this.setReceiverNoiseFigure(general.generalSettings().receiverNoiseFigure());
        this.setBandwidth(general.generalSettings().bandwidth());
        this.setHandoverMargin(general.generalSettings().handoverMargin());
        this.setMinimumCouplingLoss(general.generalSettings().minimumCouplingLoss());
        this.setUsersPerCell(20);
        double rxBandwidth = general.generalSettings().bandwidthResourceBlock() * (double)general.generalSettings().maxSubcarriersMs() / 1000.0;
        Receiver receiver = UIToModelConverter.getDmaReceiver(general.receiverSettings().standardDesensitisation(), general.receiverSettings().targetINR(), general.generalSettings().receiverNoiseFigure(), general.receiverSettings().blockingMask(), rxBandwidth, Factory.results().convert(general.localEnvironments().receiverEnvironments()), this.ui.positioning().baseStation().antennaGain(), this.ui.positioning().baseStation().antennaHeight());
        double txBandwidth = general.generalSettings().bandwidthResourceBlock() * (double)general.generalSettings().maxSubcarriersMs() / 1000.0;
        Transmitter transmitter = UIToModelConverter.getDmaTransmitter(this.ui.positioning().mobile().antennaHeight(), general.transmitterSettings().emissionMask(), general.transmitterSettings().emissionFloor().getValue(), general.transmitterSettings().emissionFloor().isRelevant(), txBandwidth, new Bounds(txBandwidth, txBandwidth, true), Factory.results().convert(general.localEnvironments().transmitterEnvironments()), (AntennaGainConfiguration)Factory.antennaGainFactory().getPeakGainAntenna());
        UIToModelConverter.handlePosition(this, this.ui.positioning().position());
        this.setMs(UIToModelConverter.convert(this.ui.positioning().mobile()));
        this.setBs(UIToModelConverter.convert(this.ui.positioning().baseStation()));
        PropagationModel pm = general.propagationModel();
        uplinkOfdmaSystem.setRadioSystem(new RadioSystem(receiver, transmitter, pm));
        this.victim = uplinkOfdmaSystem.getRadioSystem();
        this.oldVictim = uplinkOfdmaSystem;
        this.oldVictim.setPlugin(this);
        uplinkOfdmaSystem = new UplinkOfdmaSystem(new CDMADownlinkSystem(this));
        this.setReceiverNoiseFigure(general.generalSettings().receiverNoiseFigure());
        this.setBandwidth(general.generalSettings().bandwidth());
        this.setHandoverMargin(general.generalSettings().handoverMargin());
        this.setMinimumCouplingLoss(general.generalSettings().minimumCouplingLoss());
        this.setUsersPerCell(20);
        rxBandwidth = general.generalSettings().bandwidthResourceBlock() * (double)general.generalSettings().maxSubcarriersBs() / 1000.0;
        receiver = UIToModelConverter.getDmaReceiver(general.receiverSettings().standardDesensitisation(), general.receiverSettings().targetINR(), general.generalSettings().receiverNoiseFigure(), general.receiverSettings().blockingMask(), rxBandwidth, Factory.results().convert(general.localEnvironments().receiverEnvironments()), this.ui.positioning().baseStation().antennaGain(), this.ui.positioning().baseStation().antennaHeight());
        txBandwidth = general.generalSettings().bandwidthResourceBlock() * (double)general.generalSettings().maxSubcarriersMs() / 1000.0;
        transmitter = UIToModelConverter.getDmaTransmitter(this.ui.positioning().mobile().antennaHeight(), general.transmitterSettings().emissionMask(), general.transmitterSettings().emissionFloor().getValue(), general.transmitterSettings().emissionFloor().isRelevant(), txBandwidth, new Bounds(txBandwidth, txBandwidth, true), Factory.results().convert(general.localEnvironments().transmitterEnvironments()), (AntennaGainConfiguration)Factory.antennaGainFactory().getPeakGainAntenna());
        UIToModelConverter.handlePosition(this, this.ui.positioning().position());
        this.setMs(UIToModelConverter.convert(this.ui.positioning().mobile()));
        this.setBs(UIToModelConverter.convert(this.ui.positioning().baseStation()));
        pm = general.propagationModel();
        uplinkOfdmaSystem.setRadioSystem(new RadioSystem(receiver, transmitter, pm));
        this.interferer = uplinkOfdmaSystem.getRadioSystem();
        this.oldInterferer = uplinkOfdmaSystem;
        this.oldInterferer.setPlugin(this);
    }

    @Override
    public RadioSystem getSystem(Context context) {
        if (context.isVictim()) {
            return this.victim;
        }
        return this.interferer;
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Scenario scenario, Validator validator) {
        if (context.getOrigin() == Origin.SYSTEM) {
            this.validateCapacity(this.getOFDMASettings(), validator);
            HybridConsistencyCheck.checkVictim(scenario, this.victim, validator);
        } else if (context.getOrigin() == Origin.INTERFERENCE_LINK) {
            this.validateCapacity(this.getOFDMASettings(), validator);
            HybridConsistencyCheck.checkInterferer(context.getInterferenceLink(), this.interferer, validator);
        }
    }

    private void checkPathLossCorrelationSystem(ConsistencyCheckContext context, OFDMASettings ofdmaSettings, Validator validator) {
        if (ofdmaSettings.getPathLossCorrelation().isUsingPathLossCorrelation() && context.getSystem().getPropagationModel().isVariationSelected()) {
            validator.error("<br>The system has both pathloss correlation and variation of the internal propagation model selected. This conflicts with the path loss correlation concept.<p " + (Object)((Object)WarningColors.ACCURARY_WARNING) + ">It is recommended to de-select 'Variations' on the propagation model " + context.getSystem().getPropagationModel().toString() + "</p>");
        }
    }

    private void validateCapacity(OFDMASettings settings, Validator validator) {
        OFDMAUpLink upLink = settings.getUpLinkSettings();
        if (upLink.isUseNumberOfActiveMsPerBs()) {
            int num = upLink.getNumberOfActiveMsPerBs();
            int max = (int)Math.floor((double)settings.getMaxSubCarriersPerBaseStation() / (double)settings.getNumberOfSubCarriersPerMobileStation());
            if (num < 1 || num > max) {
                validator.error("Number of active MS per BS must be in the range of [1;" + max + "]");
            }
            if (max != upLink.getFrequencyScheduling().size()) {
                validator.error("The frequency scheduling probabilites does not match the full capacity of the system (" + max + "). This means the frequency probabilities will be reset when simulation starts.");
            }
        }
    }

    public double getCouplingLossPercentile(Context context) {
        if (context.isVictim()) {
            return this.oldVictim.getPreSimulation().findDoubleValue(UplinkOfdmaSystem.COUPLING_LOSS_PERCENTILE);
        }
        return this.oldInterferer.getPreSimulation().findDoubleValue(UplinkOfdmaSystem.COUPLING_LOSS_PERCENTILE);
    }

    @Override
    public void preSimulation(Context context, Results pre) {
        UniformDistribution freq;
        double frequency = context.getFrequency().trial();
        pre.getSingleValueTypes().add(new DoubleResultType(Factory.results().single("Trial Frequency", "MHz"), frequency));
        if (context.isVictim()) {
            double bw = (double)this.getOFDMASettings().getMaxSubCarriersPerBaseStation() * this.getOFDMASettings().getBandwidthOfResourceBlock() / 1000.0;
            freq = Factory.distributionFactory().getUniformDistribution(frequency - bw / 2.0, frequency + bw / 2.0);
        } else {
            double bw = this.interferer.getReceiver().getBandwidth();
            freq = Factory.distributionFactory().getUniformDistribution(frequency - bw / 2.0, frequency + bw / 2.0);
        }
        context.getSystemPlugin().setFrequency(freq);
        if (context.isVictim()) {
            this.oldVictim.initialize(pre, null);
            this.oldVictim.performPreSimulationTasks(frequency);
        } else {
            this.oldInterferer.initialize(pre, null);
            this.oldInterferer.performPreSimulationTasks(frequency);
        }
    }

    public double[] getCalculatedCLValues(Context context) {
        if (context.isVictim()) {
            return this.oldVictim.getClValues();
        }
        return this.oldInterferer.getClValues();
    }

    @Override
    public void postSimulation(Context context, Results results) {
        if (context.isVictim()) {
            HybridSystemPlugin.calculateOFDMALosses(results);
        }
    }

    @Override
    public List<AsVictimInterferingLinkDefinition> definitions() {
        ArrayList<AsVictimInterferingLinkDefinition> list = new ArrayList<AsVictimInterferingLinkDefinition>();
        list.add(new AsVictimInterferingLinkDefinition(){

            @Override
            public String getName() {
                return "Path loss correlation";
            }

            @Override
            public String getInformation() {
                return "org.seamcat.model.generic.PathLossCorrelationUI.info";
            }

            @Override
            public Class getUIClass() {
                return PathLossCorrelationUI.class;
            }
        });
        return list;
    }

    @Override
    public VectorSpace getInterferenceLinkSystemCoverage(boolean victim, ConsistencyCheckContext context) {
        if (victim) {
            return this.getRange();
        }
        return this.getRange();
    }

    public OptionalValue<Double> getPercentile() {
        return this.percentile;
    }

    public void setPercentile(OptionalValue<Double> percentile) {
        this.percentile = percentile;
    }

    @Override
    public SystemSpaces generateSystemSpaces(SystemSpaces enclosing) {
        return HexagonCells.generate(true, this.getCellRadius(), this.getTierSetup(), this.getSectorSetup(), this.getIndexOfReferenceCell());
    }
}

