/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.hybrid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.seamcat.model.correlation.Correlated;
import org.seamcat.model.correlation.NoneMode;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.VectorSpace;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.CorrelationMode;
import org.seamcat.model.plugin.system.SystemModel;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.plugin.system.optional.CorrelationDefinitions;
import org.seamcat.model.plugin.system.optional.InterferenceNames;
import org.seamcat.model.types.Unit;
import org.seamcat.model.types.result.DoubleResultType;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.types.result.VectorResultType;
import org.seamcat.presentation.systems.CellularPosition;
import org.seamcat.simulation.cellular.BaseStation;
import org.seamcat.simulation.cellular.CellularVictimSystemSimulation;
import org.seamcat.simulation.cellular.MobileStation;
import org.seamcat.simulation.cellular.cdma.CDMASettings;
import org.seamcat.simulation.cellular.ofdma.OFDMASettings;
import org.seamcat.simulation.hybrid.HybridCellularSimulation;

public abstract class HybridSystemPlugin<T extends SystemModel>
implements CorrelationDefinitions,
InterferenceNames,
SystemPlugin<T> {
    protected HybridCellularSimulation simulation;
    private TierSetup tierSetup = TierSetup.TwoTiers;
    private SectorSetup sectorSetup = SectorSetup.TriSector3GPP2;
    private double cellRadius = 5.0;
    private SystemLayout systemLayout = SystemLayout.CenterOfInfiniteNetwork;
    private boolean measureInterferenceFromEntireCluster = false;
    private boolean generateWrapAround = true;
    private int indexOfReferenceCell = 0;
    private int referenceSector;
    private double receiverNoiseFigure = 4.0;
    private double minimumCouplingLoss = 70.0;
    private double handoverMargin = 4.0;
    private double systemBandwidth = 1.25;
    private int usersPerCell = 20;
    private MobileStation ms;
    private BaseStation bs;
    private CDMASettings cdmaSettings;
    private OFDMASettings ofdmaSettings;

    @Override
    public String unwantedName() {
        return "iRSS Unwanted (external Interference)";
    }

    @Override
    public String blockingName() {
        return "iRSS Blocking (external Interference)";
    }

    @Override
    public List<String> getVictimCorrelationPoints() {
        return Collections.singletonList("Victim BS ref.cell");
    }

    @Override
    public List<CorrelationMode> getCorrelationModes() {
        ArrayList<CorrelationMode> modes = new ArrayList<CorrelationMode>();
        modes.add(NoneMode.MODE);
        modes.add(Correlated.MODE);
        return modes;
    }

    @Override
    public boolean allowCoLocation() {
        return false;
    }

    @Override
    public List<String> getInterfererTargetPointNames() {
        return Collections.singletonList("Interfering BS ref.cell");
    }

    static void calculateCDMALosses(int simulatedUsersPerCell, Results results) {
        List<VectorResultType> vectors = results.getVectorResultTypes();
        double[] refCell = results.findVector(CellularVictimSystemSimulation.capacityLossCombinedRefCell).getValue().asArray();
        results.getSingleValueTypes().add(new DoubleResultType(Factory.results().single("Average capacity loss (ref. cell)", "%"), Mathematics.getAverage(refCell)));
        double[] system = results.findVector(CellularVictimSystemSimulation.capacityLossCombinedSystem).getValue().asArray();
        results.getSingleValueTypes().add(new DoubleResultType(Factory.results().single("Average capacity loss (system)", "%"), Mathematics.getAverage(system)));
        results.getSingleValueTypes().add(new DoubleResultType(Factory.results().single("Non interfered capacity per cell", ""), simulatedUsersPerCell));
        VectorResultType nonInterferedCapacity = HybridSystemPlugin.findVector(vectors, CellularVictimSystemSimulation.nonInterferedCapacity);
        VectorResultType initialCapacitySystem = HybridSystemPlugin.findVector(vectors, CellularVictimSystemSimulation.initialCapacitySystem);
        VectorResultType interferedCapacityVector = HybridSystemPlugin.findVector(vectors, CellularVictimSystemSimulation.interferedCapacity.name());
        double[] excessOutageRefCell = HybridSystemPlugin.diffVector(nonInterferedCapacity.getValue().asArray(), interferedCapacityVector.getValue().asArray());
        results.getVectorResultTypes().add(new VectorResultType(Factory.results().value("Excess outage (active served users in ref. cell)", Unit.users.name()), excessOutageRefCell));
        double[] excessOutageSystem = HybridSystemPlugin.diffVector(initialCapacitySystem.getValue().asArray(), HybridSystemPlugin.findVector(vectors, CellularVictimSystemSimulation.interferedCapacitySystem).getValue().asArray());
        results.getVectorResultTypes().add(new VectorResultType(Factory.results().value("Excess outage (active served users in system)", Unit.users.name()), excessOutageSystem));
    }

    private static double[] diffVector(double[] first, double[] second) {
        double[] diff = new double[first.length];
        for (int i = 0; i < first.length; ++i) {
            diff[i] = first[i] - second[i];
        }
        return diff;
    }

    public static void calculateOFDMALosses(Results results) {
        List<VectorResultType> vectors = results.getVectorResultTypes();
        double avgBitRateLossRefCell = HybridSystemPlugin.averagePercentage(HybridSystemPlugin.findVector(vectors, CellularVictimSystemSimulation.initialVictimOutage.name()).getValue().asArray(), HybridSystemPlugin.findVector(vectors, "Interfered Bitrate, ref. cell").getValue().asArray());
        results.getSingleValueTypes().add(new DoubleResultType(Factory.results().single("Average bitrate loss (ref. cell)", "%"), avgBitRateLossRefCell));
        double avgBitRateLossSystem = HybridSystemPlugin.averagePercentage(HybridSystemPlugin.findVector(vectors, CellularVictimSystemSimulation.avgAchievedBitRateSystem).getValue().asArray(), HybridSystemPlugin.findVector(vectors, CellularVictimSystemSimulation.avgInterferedBitRateSystem).getValue().asArray());
        results.getSingleValueTypes().add(new DoubleResultType(Factory.results().single("Average bitrate loss (system)", "%"), avgBitRateLossSystem));
    }

    private static double averagePercentage(double[] v1, double[] v2) {
        double temp = 0.0;
        int count = 0;
        for (int i = 0; i < v1.length; ++i) {
            double initialValue = v1[i];
            double interferedValue = v2[i];
            if (initialValue == 0.0) continue;
            temp += 1.0 - interferedValue / initialValue;
            ++count;
        }
        if (count > 0) {
            temp = 100.0 * (temp / (double)count);
            return Mathematics.round(temp);
        }
        return 0.0;
    }

    private static VectorResultType findVector(List<VectorResultType> vectors, String name) {
        for (VectorResultType vector : vectors) {
            if (!vector.getName().equals(name)) continue;
            return vector;
        }
        throw new RuntimeException("No such vector " + name);
    }

    private static double calculateLossAvgPercentage(int[] noInterferenceCapacity, int[] interferenceCapacity) {
        double avg = 0.0;
        int size = noInterferenceCapacity.length;
        for (int x = 0; x < size; ++x) {
            if (noInterferenceCapacity[x] == 0) continue;
            avg += 100.0 - (double)interferenceCapacity[x] / (double)noInterferenceCapacity[x] * 100.0;
        }
        return avg / (double)size;
    }

    private static double calculateLossAvgPercentage(double[] totalDroppedSystem, int totalCapacitySystem) {
        double avgLossSystem = 0.0;
        for (double d : totalDroppedSystem) {
            avgLossSystem += d;
        }
        if (totalDroppedSystem.length != 0) {
            avgLossSystem /= (double)totalDroppedSystem.length;
        }
        if (totalCapacitySystem != 0) {
            avgLossSystem /= (double)totalCapacitySystem;
        }
        return avgLossSystem *= 100.0;
    }

    public static double calculateLossAvgPercentageSystemPerEvent(double totalDroppedSystem, int totalCapacitySystem) {
        double avgLossSystem = 0.0;
        avgLossSystem = totalDroppedSystem;
        if (totalCapacitySystem != 0) {
            avgLossSystem /= (double)totalCapacitySystem;
        }
        return avgLossSystem *= 100.0;
    }

    public static double calculateLossAvgPercentagePerEvent(double noInterferenceCapacity, int interferenceCapacity) {
        double avg = 0.0;
        if (noInterferenceCapacity != 0.0) {
            avg = 100.0 - (double)interferenceCapacity / noInterferenceCapacity * 100.0;
        }
        return avg;
    }

    @Override
    public Bounds getSystemCoverage() {
        double min = 0.0;
        boolean isNot3GPP = this.getSectorSetup() == SectorSetup.TriSector3GPP2 || this.getSectorSetup().getSectors() == 1;
        double cellRadius = this.getCellRadius();
        if (isNot3GPP) {
            cellRadius /= Math.sqrt(3.0);
        }
        int numberOfTiers = this.getTierSetup().ordinal();
        double networkRadius = 3.0 * cellRadius * (double)numberOfTiers + 2.0 * cellRadius;
        if (this.generateWrapAround()) {
            networkRadius *= 2.0;
        }
        VectorSpace network = VectorSpace.ZERO.addCircle(new Bounds(0.0, networkRadius, true));
        double max = network.getCoverage().getMax();
        return new Bounds(min, max, true);
    }

    public VectorSpace getRange() {
        boolean isNot3GPP = this.getSectorSetup() == SectorSetup.TriSector3GPP2 || this.getSectorSetup().getSectors() == 1;
        double cellRadius = this.getCellRadius();
        if (isNot3GPP) {
            cellRadius /= Math.sqrt(3.0);
        }
        int numberOfTiers = this.getTierSetup().ordinal();
        double networkRadius = 3.0 * cellRadius * (double)numberOfTiers + 2.0 * cellRadius;
        VectorSpace range = VectorSpace.ZERO;
        return range.addCircle(new Bounds(0.0, networkRadius, true));
    }

    public int getUsersPerCell() {
        return this.usersPerCell;
    }

    public CDMASettings getCDMASettings() {
        return this.cdmaSettings;
    }

    public void setCDMASettings(CDMASettings cdmaSettings) {
        this.cdmaSettings = cdmaSettings;
    }

    public OFDMASettings getOFDMASettings() {
        return this.ofdmaSettings;
    }

    public void setOFDMASettings(OFDMASettings ofdmaSettings) {
        this.ofdmaSettings = ofdmaSettings;
    }

    public double getReceiverNoiseFigure() {
        return this.receiverNoiseFigure;
    }

    public void setReceiverNoiseFigure(double receiverNoiseFigure) {
        this.receiverNoiseFigure = receiverNoiseFigure;
    }

    public double getHandoverMargin() {
        return this.handoverMargin;
    }

    public void setHandoverMargin(double handoverMargin) {
        this.handoverMargin = handoverMargin;
    }

    public double getBandwidth() {
        return this.systemBandwidth;
    }

    public void setBandwidth(double bandwidth) {
        this.systemBandwidth = bandwidth;
    }

    public double getMinimumCouplingLoss() {
        return this.minimumCouplingLoss;
    }

    public void setMinimumCouplingLoss(double minimumCouplingLoss) {
        this.minimumCouplingLoss = minimumCouplingLoss;
    }

    public BaseStation getBs() {
        return this.bs;
    }

    public void setBs(BaseStation bs) {
        this.bs = bs;
    }

    public MobileStation getMs() {
        return this.ms;
    }

    public void setMs(MobileStation ms) {
        this.ms = ms;
    }

    public SectorSetup getSectorSetup() {
        return this.sectorSetup;
    }

    public void setSectorSetup(SectorSetup sectorSetup) {
        this.sectorSetup = sectorSetup;
    }

    public TierSetup getTierSetup() {
        return this.tierSetup;
    }

    public void setLayout(CellularPosition position) {
        this.setSectorSetup(position.sectorType());
        this.setTierSetup(position.tiers());
        this.setCellRadius(position.cellRadius());
        this.setSystemLayout(position.layout());
        this.indexOfReferenceCell = position.referenceCellId();
        this.referenceSector = position.referenceSector();
        this.generateWrapAround = position.generateWrapAround();
    }

    public void setTierSetup(int tiers) {
        this.tierSetup = tiers == 0 ? TierSetup.SingleCell : (tiers == 1 ? TierSetup.OneTier : TierSetup.TwoTiers);
    }

    public double getCellRadius() {
        return this.cellRadius;
    }

    public void setCellRadius(double cellRadius) {
        this.cellRadius = cellRadius;
    }

    public SystemLayout getSystemLayout() {
        return this.systemLayout;
    }

    public void setSystemLayout(SystemLayout systemLayout) {
        this.systemLayout = systemLayout;
    }

    public boolean measureInterferenceFromEntireCluster() {
        return this.measureInterferenceFromEntireCluster;
    }

    public void setMeasureInterferenceFromEntireCluster(boolean measureInterferenceFromEntireCluster) {
        this.measureInterferenceFromEntireCluster = measureInterferenceFromEntireCluster;
    }

    public boolean generateWrapAround() {
        return this.generateWrapAround;
    }

    public void setGenerateWrapAround(boolean generateWrapAround) {
        this.generateWrapAround = generateWrapAround;
    }

    public int getIndexOfReferenceCell() {
        return this.indexOfReferenceCell;
    }

    public void setIndexOfReferenceCell(int indexOfReferenceCell) {
        this.indexOfReferenceCell = indexOfReferenceCell;
    }

    public int getReferenceSector() {
        return this.referenceSector;
    }

    public void setReferenceSector(int referenceSector) {
        this.referenceSector = referenceSector;
    }

    public void setUsersPerCell(int usersPerCell) {
        this.usersPerCell = usersPerCell;
    }

    public static enum SystemLayout {
        CenterOfInfiniteNetwork("Center"),
        LeftHandSideOfNetworkEdge("Left"),
        RightHandSideOfNetworkEdge("Right");

        String name;

        private SystemLayout(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum SectorSetup {
        SingleSector("Single", 1),
        TriSector3GPP("Tri-sector 3GPP", 3),
        TriSector3GPP2("Tri-sector 3GPP2", 3);

        String name;
        private int sectors;

        private SectorSetup(String name, int sectors) {
            this.name = name;
            this.sectors = sectors;
        }

        public int getSectors() {
            return this.sectors;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum TierSetup {
        SingleCell(0, 1),
        OneTier(1, 7),
        TwoTiers(2, 19);

        private final int cellSites;
        private final int tiers;

        private TierSetup(int tiers, int cellSites) {
            this.tiers = tiers;
            this.cellSites = cellSites;
        }

        public int getCellSites() {
            return this.cellSites;
        }

        public int getTiers() {
            return this.tiers;
        }
    }
}

