/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.result;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.seamcat.model.functions.Function;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.simulation.result.Collector;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.MultiValueDef;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.types.result.BarChartValue;
import org.seamcat.model.types.result.DoubleResultType;
import org.seamcat.model.types.result.FunctionResultType;
import org.seamcat.model.types.result.IntegerResultType;
import org.seamcat.model.types.result.LongResultType;
import org.seamcat.model.types.result.SingleValueTypes;
import org.seamcat.model.types.result.StringResultType;

public class CollectorImpl
implements Collector {
    private static final Logger LOG = Logger.getLogger(CollectorImpl.class);
    private Map<VectorDef, Double> values = new LinkedHashMap<VectorDef, Double>();
    private Map<VectorDef, List<Double>> samples = new LinkedHashMap<VectorDef, List<Double>>();
    private Map<MultiValueDef, List<BarChartValue>> barValues = new LinkedHashMap<MultiValueDef, List<BarChartValue>>();
    private Map<MultiValueDef, List<Point2D>> scatterValues = new LinkedHashMap<MultiValueDef, List<Point2D>>();
    private Map<MultiValueDef, List<LinkResult>> linkResults = new LinkedHashMap<MultiValueDef, List<LinkResult>>();
    private Map<UniqueValueDef, SingleValueTypes<?>> singleValues = new LinkedHashMap();
    private Map<UniqueValueDef, FunctionResultType> functions = new LinkedHashMap<UniqueValueDef, FunctionResultType>();

    @Override
    public void add(VectorDef def, double value) {
        if (LOG.isDebugEnabled() && !def.intermediate()) {
            LOG.info("Collected value: " + def.name() + " = " + value + " " + def.unit());
        }
        this.values.put(def, value);
    }

    @Override
    public Set<VectorDef> getVectorDefinitions() {
        return this.values.keySet();
    }

    @Override
    public void add(MultiValueDef definition, Point2D plot) {
        List<Point2D> values = this.scatterValues.get(definition);
        if (values == null) {
            values = new ArrayList<Point2D>();
            this.scatterValues.put(definition, values);
        }
        values.add(plot);
    }

    @Override
    public List<Point2D> getScatterPoints(MultiValueDef definition) {
        return this.scatterValues.get(definition);
    }

    @Override
    public void add(MultiValueDef definition, BarChartValue value) {
        List<BarChartValue> values = this.barValues.get(definition);
        if (values == null) {
            values = new ArrayList<BarChartValue>();
            this.barValues.put(definition, values);
        }
        values.add(value);
    }

    @Override
    public Double get(VectorDef def) {
        for (Map.Entry<VectorDef, Double> entry : this.values.entrySet()) {
            if (!entry.getKey().equals(def)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public void add(VectorDef definition, List<Double> vector) {
        this.samples.put(definition, vector);
    }

    @Override
    public List<Double> getSamples(VectorDef definition) {
        return this.samples.get(definition);
    }

    public Map<VectorDef, Double> values() {
        return this.values;
    }

    public Map<VectorDef, List<Double>> samples() {
        return this.samples;
    }

    public Map<MultiValueDef, List<BarChartValue>> getBarValues() {
        return this.barValues;
    }

    public Map<MultiValueDef, List<Point2D>> getScatterValues() {
        return this.scatterValues;
    }

    public Map<UniqueValueDef, SingleValueTypes<?>> getSingleValues() {
        return this.singleValues;
    }

    public Map<UniqueValueDef, FunctionResultType> getFunctions() {
        return this.functions;
    }

    @Override
    public void add(MultiValueDef def, LinkResult linkResult) {
        List<LinkResult> linkResults = this.linkResults.get(def);
        if (linkResults == null) {
            linkResults = new ArrayList<LinkResult>();
            this.linkResults.put(def, linkResults);
        }
        linkResults.add(linkResult);
    }

    @Override
    public List<LinkResult> getLinkResults(MultiValueDef def) {
        List<LinkResult> list = this.linkResults.get(def);
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    @Override
    public void add(UniqueValueDef definition, double value) {
        this.singleValues.put(definition, new DoubleResultType(definition, value));
    }

    @Override
    public void add(UniqueValueDef definition, int value) {
        this.singleValues.put(definition, new IntegerResultType(definition, value));
    }

    @Override
    public void add(UniqueValueDef definition, long value) {
        this.singleValues.put(definition, new LongResultType(definition, value));
    }

    @Override
    public void add(UniqueValueDef definition, String value) {
        this.singleValues.put(definition, new StringResultType(definition, value));
    }

    @Override
    public String getString(UniqueValueDef def) {
        SingleValueTypes<?> types = this.singleValues.get(def);
        if (types != null && types instanceof StringResultType) {
            return ((StringResultType)types).value();
        }
        return null;
    }

    @Override
    public boolean hasUniqueValue(UniqueValueDef def) {
        return this.singleValues.containsKey(def) || this.functions.containsKey(def);
    }

    @Override
    public double getDouble(UniqueValueDef def) {
        SingleValueTypes<?> types = this.singleValues.get(def);
        if (types != null && types instanceof DoubleResultType) {
            return ((DoubleResultType)types).value();
        }
        return -1.0;
    }

    @Override
    public int getInt(UniqueValueDef def) {
        SingleValueTypes<?> types = this.singleValues.get(def);
        if (types != null && types instanceof IntegerResultType) {
            return ((IntegerResultType)types).value();
        }
        return -1;
    }

    @Override
    public long getLong(UniqueValueDef def) {
        SingleValueTypes<?> types = this.singleValues.get(def);
        if (types != null && types instanceof LongResultType) {
            return ((LongResultType)types).value();
        }
        return -1L;
    }

    @Override
    public void add(UniqueValueDef def, Function function) {
        this.functions.put(def, new FunctionResultType(def, function));
    }

    @Override
    public Function getFunction(UniqueValueDef def) {
        FunctionResultType type = this.functions.get(def);
        if (type != null) {
            return type.value();
        }
        return null;
    }

    @Override
    public List<BarChartValue> getBarChartValues(MultiValueDef def) {
        return this.barValues.get(def);
    }

    @Override
    public Set<MultiValueDef> getMultiValueDefinitions() {
        HashSet<MultiValueDef> definitions = new HashSet<MultiValueDef>();
        definitions.addAll(this.barValues.keySet());
        definitions.addAll(this.scatterValues.keySet());
        definitions.addAll(this.linkResults.keySet());
        return definitions;
    }

    @Override
    public Set<UniqueValueDef> getUniqueValueDefinitions() {
        HashSet<UniqueValueDef> definitions = new HashSet<UniqueValueDef>();
        definitions.addAll(this.singleValues.keySet());
        definitions.addAll(this.functions.keySet());
        return definitions;
    }
}

