/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.result;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seamcat.model.simulation.result.Collector;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.Interferer;
import org.seamcat.model.simulation.result.InterfererResultCollector;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.simulation.result.Lockable;

public class EventResultImpl
extends Lockable
implements EventResult {
    private final int eventNumber;
    private Map<InterferenceLink, List<InterferenceLinkResult>> result;
    private VictimResultCollector victimResult;
    private List<Collector> eppResults;
    private Map<InterferenceLink, InterfererResultCollector> collectorMap;
    private Map<Victim, Double> totalUnw;
    private Map<Victim, Double> totalBloc;
    private Map<Victim, List<Interferer>> victimInterferers;
    private Map<Victim, List<Double>> vicBloc;
    private Map<Victim, List<Double>> vicUnw;
    private Map<Victim, List<Double>> vicPathLoss;

    public EventResultImpl(int eventNumber, List<InterferenceLink> links, VictimResultCollector vCollector) {
        this.eventNumber = eventNumber;
        this.totalUnw = new LinkedHashMap<Victim, Double>();
        this.totalBloc = new LinkedHashMap<Victim, Double>();
        this.victimInterferers = new LinkedHashMap<Victim, List<Interferer>>();
        this.vicBloc = new LinkedHashMap<Victim, List<Double>>();
        this.vicUnw = new LinkedHashMap<Victim, List<Double>>();
        this.vicPathLoss = new LinkedHashMap<Victim, List<Double>>();
        this.result = new LinkedHashMap<InterferenceLink, List<InterferenceLinkResult>>();
        for (InterferenceLink link : links) {
            this.result.put(link, new ArrayList());
        }
        this.victimResult = vCollector;
        this.eppResults = new ArrayList<Collector>();
        this.collectorMap = new LinkedHashMap<InterferenceLink, InterfererResultCollector>();
    }

    @Override
    public void addInterferenceLinkResult(InterferenceLinkResult link) {
        this.mutate();
        this.result.get(link.getInterferenceLink()).add(link);
    }

    @Override
    public int getEventNumber() {
        return this.eventNumber;
    }

    @Override
    public List<InterferenceLinkResult> getInterferenceLinkResult(InterferenceLink link) {
        if (this.result.containsKey(link)) {
            return this.result.get(link);
        }
        throw new RuntimeException("Interference link not found");
    }

    @Override
    public List<Collector> getEventProcessingResults() {
        return this.eppResults;
    }

    @Override
    public Collection<InterferenceLinkResult> getAllInterferenceLinkResults() {
        ArrayList<InterferenceLinkResult> all = new ArrayList<InterferenceLinkResult>();
        for (List<InterferenceLinkResult> results : this.result.values()) {
            all.addAll(results);
        }
        return all;
    }

    @Override
    public VictimResultCollector getVictimResult() {
        return this.victimResult;
    }

    @Override
    public InterfererResultCollector getInterferingSystemResult(InterferenceLink link) {
        return this.collectorMap.get(link);
    }

    @Override
    public List<InterfererResultCollector> getAllInterferingSystemResults() {
        return new ArrayList<InterfererResultCollector>(this.collectorMap.values());
    }

    @Override
    public void addInterfererResultCollector(InterfererResultCollector iCollector) {
        this.collectorMap.put(iCollector.getLink(), iCollector);
    }

    @Override
    public double totalInterferenceUnwanted(Victim victim) {
        Double result = this.totalUnw.get(victim);
        if (result == null) {
            return 0.0;
        }
        return result;
    }

    @Override
    public double totalInterferenceBlocking(Victim victim) {
        Double result = this.totalBloc.get(victim);
        if (result == null) {
            return 0.0;
        }
        return result;
    }

    @Override
    public void setTotalInterference(Victim victim, double totalU, double totalB) {
        this.totalUnw.put(victim, totalU);
        this.totalBloc.put(victim, totalB);
    }

    @Override
    public List<Double> getExternalInterferersPathLoss(Victim victim) {
        return this.notNull(this.vicPathLoss.get(victim));
    }

    @Override
    public List<Double> getExternalInterferersBlocking(Victim victim) {
        return this.notNull(this.vicBloc.get(victim));
    }

    @Override
    public List<Double> getExternalInterferersUnwanted(Victim victim) {
        return this.notNull(this.vicUnw.get(victim));
    }

    private List<Double> notNull(List<Double> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public List<Interferer> getExternalInterferers(Victim victim) {
        List<Interferer> list = this.victimInterferers.get(victim);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public void addExternalInterferer(Victim victim, Interferer interferer, double unwanted, double blocking) {
        List<Interferer> interferers = this.victimInterferers.get(victim);
        if (interferers == null) {
            interferers = new ArrayList<Interferer>();
            this.victimInterferers.put(victim, interferers);
        }
        interferers.add(interferer);
        this.ensure(victim, this.vicPathLoss).add(interferer.getLinkResult().getTxRxPathLoss());
        this.ensure(victim, this.vicUnw).add(unwanted);
        this.ensure(victim, this.vicBloc).add(blocking);
    }

    private List<Double> ensure(Victim victim, Map<Victim, List<Double>> map) {
        List<Double> values = map.get(victim);
        if (values == null) {
            values = new ArrayList<Double>();
            map.put(victim, values);
        }
        return values;
    }
}

