/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.result;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seamcat.model.distributions.GaussianDistributionImpl;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.Direction;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.LocalEnvironmentResult;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.types.LocalEnvironment;
import org.seamcat.simulation.result.AntennaResultImpl;
import org.seamcat.simulation.result.LocalEnvironmentSelector;
import org.seamcat.simulation.result.Lockable;

public class LinkResultImpl
extends Lockable
implements LinkResult {
    private double trialFrequency;
    private double txRxAngle;
    private double txRxDistance;
    private double txPower;
    private boolean txRxInSameBuilding;
    private double txRxPathLoss;
    private double effectivePathLoss;
    private AntennaResultImpl tx = new AntennaResultImpl();
    private AntennaResultImpl rx = new AntennaResultImpl();
    private LinkedHashMap<UniqueValueDef, Double> doubles = new LinkedHashMap();
    private LinkedHashMap<UniqueValueDef, Integer> integers;
    private LinkedHashMap<UniqueValueDef, Long> longs;
    private LinkedHashMap<UniqueValueDef, String> strings;

    @Override
    public AntennaResult rxAntenna() {
        return this.rx;
    }

    @Override
    public AntennaResult txAntenna() {
        return this.tx;
    }

    @Override
    public void setRxAntennaValues(AntennaResult values) {
        this.setAntennaValues(this.rx, values);
    }

    @Override
    public void setTxAntennaValues(AntennaResult values) {
        this.setAntennaValues(this.tx, values);
    }

    private void setAntennaValues(AntennaResult a, AntennaResult values) {
        a.setAzimuth(values.getAzimuth());
        a.setAzimuthCompensation(values.getAzimuthCompensation());
        a.setHeight(values.getHeight());
        a.setLocalEnvironment(values.getLocalEnvironment());
        a.setPosition(values.getPosition());
        a.setElevation(values.getElevation());
        a.setElevationCompensation(values.getElevationCompensation());
        a.setTilt(values.getTilt());
        a.setGain(values.getGain());
        a.setRandomPanelOffsetAzimuth(values.getRandomPanelOffsetAzimuth());
        a.setRandomPanelOffsetElevation(values.getRandomPanelOffsetElevation());
    }

    @Override
    public double getTxRxAngle() {
        return this.txRxAngle;
    }

    @Override
    public void setTxRxAngle(double txRxAngle) {
        this.mutate();
        this.txRxAngle = txRxAngle;
    }

    @Override
    public double getTxRxDistance() {
        return this.txRxDistance;
    }

    @Override
    public void setTxRxDistance(double txRxDistance) {
        this.mutate();
        this.txRxDistance = txRxDistance;
    }

    @Override
    public double getTxRxPathLoss() {
        return this.txRxPathLoss;
    }

    @Override
    public void setTxRxPathLoss(double txRxPathLoss) {
        this.mutate();
        this.txRxPathLoss = txRxPathLoss;
    }

    @Override
    public double getEffectiveTxRxPathLoss() {
        return this.effectivePathLoss;
    }

    @Override
    public void setEffectiveTxRxPathLoss(double effectiveTxRxPathLoss) {
        this.mutate();
        this.effectivePathLoss = effectiveTxRxPathLoss;
    }

    @Override
    public double getTxPower() {
        return this.txPower;
    }

    @Override
    public void setTxPower(double txPower) {
        this.mutate();
        this.txPower = txPower;
    }

    @Override
    public double getFrequency() {
        return this.trialFrequency;
    }

    @Override
    public void setFrequency(double frequency) {
        this.mutate();
        this.trialFrequency = frequency;
    }

    @Override
    public boolean isTxRxInSameBuilding() {
        return this.txRxInSameBuilding;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void trialTxRxInSameBuilding() {
        block4: {
            block5: {
                block3: {
                    this.mutate();
                    if (this.tx.getLocalEnvironment().getEnvironment() != LocalEnvironment.Environment.Outdoor || this.rx.getLocalEnvironment().getEnvironment() != LocalEnvironment.Environment.Outdoor) break block3;
                    this.txRxInSameBuilding = false;
                    break block4;
                }
                if (this.tx.getLocalEnvironment().getEnvironment() != LocalEnvironment.Environment.Indoor || this.rx.getLocalEnvironment().getEnvironment() != LocalEnvironment.Environment.Indoor) break block5;
                if (this.txRxDistance < 0.02) ** GOTO lbl-1000
                if (this.txRxDistance < 0.05) {
                    v0 = new GaussianDistributionImpl(0.0, 1.0);
                    ** if (!(v0.trial() < (0.05 - this.txRxDistance) / 0.03)) goto lbl-1000
                }
                ** GOTO lbl-1000
lbl-1000:
                // 2 sources

                {
                    v1 = true;
                    ** GOTO lbl15
                }
lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
lbl15:
                // 2 sources

                this.txRxInSameBuilding = v1;
                break block4;
            }
            this.txRxInSameBuilding = false;
        }
    }

    @Override
    public Map<UniqueValueDef, Double> getDoubleValues() {
        return Collections.unmodifiableMap(this.doubles);
    }

    @Override
    public Map<UniqueValueDef, Integer> getIntValues() {
        if (this.integers == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.integers);
    }

    @Override
    public Map<UniqueValueDef, Long> getLongValues() {
        if (this.longs == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.longs);
    }

    @Override
    public Map<UniqueValueDef, String> getStringValues() {
        if (this.strings == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.strings);
    }

    @Override
    public <T> T getValue(UniqueValueDef def) {
        if (this.doubles.containsKey(def)) {
            return (T)this.doubles.get(def);
        }
        if (this.integers != null && this.integers.containsKey(def)) {
            return (T)this.integers.get(def);
        }
        if (this.longs != null && this.longs.containsKey(def)) {
            return (T)this.longs.get(def);
        }
        if (this.strings != null && this.strings.containsKey(def)) {
            return (T)this.strings.get(def);
        }
        return null;
    }

    @Override
    public void setValue(UniqueValueDef def, double value) {
        this.mutate();
        this.doubles.put(def, value);
    }

    @Override
    public void setValue(UniqueValueDef def, int value) {
        this.mutate();
        if (this.integers == null) {
            this.integers = new LinkedHashMap();
        }
        this.integers.put(def, value);
    }

    @Override
    public void setValue(UniqueValueDef def, long value) {
        this.mutate();
        if (this.longs == null) {
            this.longs = new LinkedHashMap();
        }
        this.longs.put(def, value);
    }

    @Override
    public void setValue(UniqueValueDef def, String value) {
        this.mutate();
        if (this.strings == null) {
            this.strings = new LinkedHashMap();
        }
        this.strings.put(def, value);
    }

    @Override
    public boolean hasValue(UniqueValueDef def) {
        return this.getValue(def) != null;
    }

    @Override
    public void lock(String key) {
        super.lock(key);
        this.tx.lock(key);
        this.rx.lock(key);
    }

    @Override
    public void unlock(String key) {
        super.unlock(key);
        this.rx.unlock(key);
        this.tx.unlock(key);
    }

    public String toString() {
        return this.txAntenna().getPosition() + " -> " + this.rxAntenna().getPosition();
    }

    @Override
    public LinkResult add(Point2D delta) {
        LinkResultImpl result = new LinkResultImpl();
        result.rxAntenna().setPosition(this.rx.getPosition().add(delta));
        result.txAntenna().setPosition(this.tx.getPosition().add(delta));
        result.setTxRxDistance(this.getTxRxDistance());
        result.setTxRxAngle(this.getTxRxAngle());
        return result;
    }

    @Override
    public void assignLocalEnvironment(List<LocalEnvironment> environments, Direction direction) {
        this.mutate();
        LocalEnvironmentResult result = LocalEnvironmentSelector.pickLocalEnvironment(environments, this.getFrequency(), this.txAntenna(), this.rxAntenna(), direction);
        if (direction == Direction.To_TX) {
            this.txAntenna().setLocalEnvironment(result);
        } else {
            this.rxAntenna().setLocalEnvironment(result);
        }
    }
}

