/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.result;

import java.util.List;
import org.seamcat.model.distributions.UniformDistribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.propagation.PBEL;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.Direction;
import org.seamcat.model.simulation.result.LocalEnvironmentResult;
import org.seamcat.model.types.LocalEnvironment;
import org.seamcat.simulation.result.AntennaResultImpl;
import org.seamcat.simulation.result.LocalEnvironmentResultImpl;

public class LocalEnvironmentSelector {
    static LocalEnvironmentResult pickLocalEnvironment(List<? extends LocalEnvironment> environments, double frequencyMHZ, AntennaResult tx, AntennaResult rx, Direction direction) {
        double angle = Mathematics.calculateElevation(rx, tx);
        if (direction == Direction.To_TX) {
            angle = -angle;
        }
        return LocalEnvironmentSelector.pickLocalEnvironment(environments, frequencyMHZ, angle);
    }

    private static LocalEnvironmentResult pickLocalEnvironment(List<? extends LocalEnvironment> environments, double frequencyMHZ, double facadeAngle) {
        if (environments == null || environments.size() == 0) {
            return new LocalEnvironmentResultImpl(0.0, 0.0);
        }
        UniformDistribution percentage = Factory.distributionFactory().getUniformDistribution(0.0, 1.0);
        LocalEnvironment picked = null;
        if (environments.size() == 1) {
            picked = environments.get(0);
        } else {
            double trial = percentage.trial();
            double cum = 0.0;
            for (LocalEnvironment localEnvironment : environments) {
                if (!(trial < (cum += localEnvironment.getProbability()))) continue;
                picked = localEnvironment;
                break;
            }
            if (picked == null) {
                picked = environments.get(environments.size() - 1);
            }
        }
        if (picked.getEnvironment() == LocalEnvironment.Environment.Indoor) {
            if (picked.isUsingBEL()) {
                double trial;
                AntennaResultImpl ar = new AntennaResultImpl();
                ar.setElevation(facadeAngle);
                PBEL pbel = new PBEL();
                double frequency = frequencyMHZ / 1000.0;
                double tradPct = picked.getBuildingTypePercentage();
                int buildingType = Mathematics.equals(100.0, tradPct, 0.001) ? 1 : (Mathematics.equals(0.0, tradPct, 0.001) ? 2 : ((trial = percentage.trial() * 100.0) < tradPct ? 1 : 2));
                double wallLoss = pbel.bel(frequency, picked.getProbabilityExceedingNBEL().trial(), buildingType, ar.getElevation());
                return new LocalEnvironmentResultImpl(wallLoss, 0.0);
            }
            return new LocalEnvironmentResultImpl(picked.getWallLoss(), picked.getWallLossStdDev());
        }
        return new LocalEnvironmentResultImpl(picked.isUsingClutter(), picked.getOutdoorModel(), picked.getPercentageOfLocations(), picked.getLocalClutter(), picked.isUserDefined(), picked.getHeight(), picked.getWidth());
    }
}

