/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.result;

import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.simulation.result.LinkResultImpl;
import org.seamcat.simulation.result.SimulationElement;

public abstract class MutableSimulationElement
implements SimulationElement {
    private Point2D position;
    private double antennaHeight;
    private double antennaTilt = 0.0;
    private double externalInterferenceBlocking = -1000.0;
    private double externalInterferenceUnwanted = -1000.0;
    private double interSystemInterference;
    private double totalInterference;
    private LinkResultImpl link;

    @Override
    public Point2D getPosition() {
        return this.position;
    }

    @Override
    public double getAntennaHeight() {
        return this.antennaHeight;
    }

    @Override
    public double getAntennaTilt() {
        return this.antennaTilt;
    }

    @Override
    public double getExternalInterferenceBlocking() {
        return this.externalInterferenceBlocking;
    }

    @Override
    public double getExternalInterferenceUnwanted() {
        return this.externalInterferenceUnwanted;
    }

    @Override
    public double getInterSystemInterference() {
        return this.interSystemInterference;
    }

    @Override
    public double getTotalInterference() {
        return this.totalInterference;
    }

    @Override
    public abstract double getFrequency();

    @Override
    public abstract double getReferenceBandwidth();

    public void setPosition(Point2D position) {
        this.position = position;
    }

    public void setAntennaHeight(double antennaHeight) {
        this.antennaHeight = antennaHeight;
    }

    public void setAntennaTilt(double antennaTilt) {
        this.antennaTilt = antennaTilt;
    }

    public void setExternalInterferenceBlocking(double externalInterferenceBlocking) {
        this.externalInterferenceBlocking = externalInterferenceBlocking;
    }

    public void setExternalInterferenceUnwanted(double externalInterferenceUnwanted) {
        this.externalInterferenceUnwanted = externalInterferenceUnwanted;
    }

    public void setInterSystemInterference(double interSystemInterference) {
        this.interSystemInterference = interSystemInterference;
    }

    public void setTotalInterference(double totalInterference) {
        this.totalInterference = totalInterference;
    }

    @Override
    public double getExternalInterference() {
        return Mathematics.linear2dB(Math.pow(10.0, this.externalInterferenceUnwanted / 10.0) + Math.pow(10.0, this.externalInterferenceBlocking / 10.0));
    }

    @Override
    public LinkResult getLinkResult() {
        return this.link;
    }

    public void setLinkResult(LinkResultImpl link) {
        this.link = link;
    }
}

