/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.result;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seamcat.model.engines.LinkResultSamplesImpl;
import org.seamcat.model.simulation.result.LinkResultSamples;
import org.seamcat.model.simulation.result.SimulationResult;
import org.seamcat.model.types.EventProcessing;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.Results;
import org.seamcat.simulation.result.ResultsImpl;

public class SimulationResultImpl
implements SimulationResult {
    private Results victimResult;
    private Results statistics;
    private Map<InterferenceLink, Results> iResluts = new LinkedHashMap<InterferenceLink, Results>();
    private Map<EventProcessing, Results> eventProcessingResults = new LinkedHashMap<EventProcessing, Results>();
    private LinkResultSamplesImpl samples;

    public void setVictimResult(Results victimResult) {
        this.victimResult = victimResult;
    }

    @Override
    public Results getVictimResults() {
        return this.victimResult;
    }

    public void setResult(InterferenceLink link, Results results) {
        this.iResluts.put(link, results);
    }

    @Override
    public Results getResult(InterferenceLink link) {
        return this.iResluts.get(link);
    }

    public void setResult(EventProcessing epp, Results results) {
        this.eventProcessingResults.put(epp, results);
    }

    @Override
    public Results getResult(EventProcessing epp) {
        return this.eventProcessingResults.get(epp);
    }

    public void setStatistics(Results statistics) {
        this.statistics = statistics;
    }

    @Override
    public Results getSimulationStatistics() {
        return this.statistics;
    }

    @Override
    public LinkResultSamples getSamples() {
        return this.samples;
    }

    public void setLinkResultSamples(LinkResultSamples samples) {
        this.samples = (LinkResultSamplesImpl)samples;
    }

    public List<Results> getSeamcatResults() {
        ArrayList<Results> all = new ArrayList<Results>();
        if (this.victimResult != null) {
            all.add(this.victimResult);
        }
        all.addAll(this.iResluts.values());
        if (this.statistics != null) {
            all.add(this.statistics);
        }
        return all;
    }

    public List<Results> getEventProcessingResults() {
        return new ArrayList<Results>(this.eventProcessingResults.values());
    }

    public SimulationResultImpl copy() {
        SimulationResultImpl clone = new SimulationResultImpl();
        clone.setVictimResult(this.copy(this.victimResult));
        for (Map.Entry<InterferenceLink, Results> entry : this.iResluts.entrySet()) {
            clone.setResult(entry.getKey(), (Results)((ResultsImpl)entry.getValue()).copy());
        }
        clone.setStatistics(this.copy(this.statistics));
        for (Map.Entry<Object, Results> entry : this.eventProcessingResults.entrySet()) {
            clone.setResult((EventProcessing)entry.getKey(), (Results)((ResultsImpl)entry.getValue()).copy());
        }
        if (this.samples != null) {
            clone.setLinkResultSamples(this.samples.copy());
        }
        return clone;
    }

    private Results copy(Results results) {
        if (results == null) {
            return null;
        }
        return ((ResultsImpl)results).copy();
    }
}

