/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.result;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.model.functions.Function;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.simulation.result.MultiValueDef;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.types.result.BarChartResultType;
import org.seamcat.model.types.result.BarChartValue;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.types.result.ScatterDiagramResultType;
import org.seamcat.simulation.result.CollectorImpl;

public class VictimResultCollectorImpl
extends CollectorImpl
implements VictimResultCollector {
    private List<Victim> victims = new ArrayList<Victim>();
    private Results pre;

    public VictimResultCollectorImpl(Results pre) {
        this.pre = pre;
    }

    @Override
    public void add(Victim victim) {
        this.victims.add(victim);
    }

    @Override
    public List<Victim> getVictims() {
        return this.victims;
    }

    @Override
    public Results getPreSimulationResults() {
        return this.pre;
    }

    @Override
    public double getDouble(UniqueValueDef def) {
        if (this.pre.hasSingleValue(def)) {
            return this.pre.findDoubleValue(def);
        }
        return super.getDouble(def);
    }

    @Override
    public int getInt(UniqueValueDef def) {
        if (this.pre.hasSingleValue(def)) {
            return this.pre.findIntValue(def);
        }
        return super.getInt(def);
    }

    @Override
    public long getLong(UniqueValueDef def) {
        if (this.pre.hasSingleValue(def)) {
            return this.pre.findLongValue(def);
        }
        return super.getLong(def);
    }

    @Override
    public Function getFunction(UniqueValueDef def) {
        Function function = this.pre.findFunction(def);
        if (function != null) {
            return function;
        }
        return super.getFunction(def);
    }

    @Override
    public List<BarChartValue> getBarChartValues(MultiValueDef def) {
        BarChartResultType barChart = this.pre.findBarChart(def);
        if (barChart != null) {
            return barChart.value();
        }
        return super.getBarChartValues(def);
    }

    @Override
    public List<Point2D> getScatterPoints(MultiValueDef def) {
        ScatterDiagramResultType diagram = this.pre.findScatterDiagram(def);
        if (diagram != null) {
            return diagram.value();
        }
        return super.getScatterPoints(def);
    }
}

