/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.simulation.settings;

import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.system.ContexedSystemPlugin;
import org.seamcat.model.plugin.system.DefaultCorrelationDefinitions;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.plugin.system.optional.CorrelationDefinitions;
import org.seamcat.model.types.CorrelationSetting;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.workspace.CorrelationSettingsUI;
import org.seamcat.plugin.PropagationModelConfiguration;
import org.seamcat.simulation.result.ContextImpl;
import org.seamcat.simulation.settings.CorrelationSettingImpl;

public class InterferenceLinkImpl
implements InterferenceLink {
    private int index;
    private ContexedSystemPlugin victim;
    private ContexedSystemPlugin interferer;
    private PropagationModelConfiguration propagationModel = (PropagationModelConfiguration)Factory.propagationModelFactory().getHataSE21();
    private CorrelationSettingImpl setting;
    private final CorrelationDefinitions iCorr;

    public InterferenceLinkImpl(int index, ContexedSystemPlugin victim, SystemPlugin interferer, SystemPlugin enclosing) {
        this.index = index;
        this.victim = victim;
        ContextImpl context = new ContextImpl(this);
        this.interferer = new ContexedSystemPlugin(interferer, context, enclosing);
        context.setSystemPlugin(this.interferer);
        this.iCorr = interferer instanceof CorrelationDefinitions ? (CorrelationDefinitions)((Object)interferer) : DefaultCorrelationDefinitions.instance;
    }

    public void setCorrelationSettings(CorrelationSettingsUI correlationSettings) {
        this.setting = new CorrelationSettingImpl(correlationSettings, null);
    }

    public void setCoLocation(InterferenceLink coLocation) {
        this.setting = new CorrelationSettingImpl(this.setting.ui, coLocation);
    }

    @Override
    public CorrelationSetting getCorrelationSettings() {
        return this.setting;
    }

    @Override
    public boolean isCoLocated() {
        return this.iCorr.allowCoLocation() && this.setting.isCoLocated();
    }

    @Override
    public PropagationModelConfiguration getPropagationModel() {
        return this.propagationModel;
    }

    public void setPropagationModel(PropagationModelConfiguration propagationModel) {
        this.propagationModel = propagationModel;
    }

    @Override
    public ContexedSystemPlugin getVictim() {
        return this.victim;
    }

    @Override
    public ContexedSystemPlugin getInterferer() {
        return this.interferer;
    }

    @Override
    public Distribution getFrequency() {
        return this.interferer.getFrequency();
    }

    @Override
    public void setFrequency(Distribution frequency) {
        this.interferer.setFrequency(frequency);
    }

    @Override
    public int linkIndex() {
        return this.index;
    }

    public String toString() {
        return "Link " + (this.index + 1) + " (" + this.interferer.getName() + ")";
    }
}

