//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.Rendering;
using SharpDX.DXGI;


namespace Framefield.Core.ID082a4fe5_7097_4375_aa3e_bcac3baf5bfc
{
    public class Class_RenderSkyMap : FXSourceCodeFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            SunPositionX = 1,
            SunPositionY = 2,
            SkyColorR = 3,
            SkyColorG = 4,
            SkyColorB = 5,
            SkyColorA = 6,
            SunColorR = 7,
            SunColorG = 8,
            SunColorB = 9,
            SunColorA = 10,
            Resolution = 11,
            GroundColorR = 12,
            GroundColorG = 13,
            GroundColorB = 14,
            GroundColorA = 15,
            HorizonBlur = 16,
            HorizonOffset = 17,
            HorizonColorR = 18,
            HorizonColorG = 19,
            HorizonColorB = 20,
            HorizonColorA = 21
        }
        //<<< _inputids

        public override void Dispose()
        {
            Utilities.DisposeObj(ref _prefilteredCubeMap);
            Utilities.DisposeObj(ref _cubeMapRTV);
            Utilities.DisposeObj(ref _rasterizerState);
            base.Dispose();
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var SunPositionX = inputs[(int)InputId.SunPositionX].Eval(context).Value;
            var SunPositionY = inputs[(int)InputId.SunPositionY].Eval(context).Value;
            var SunPosition = new Vector2(SunPositionX, SunPositionY);
            var SkyColorR = inputs[(int)InputId.SkyColorR].Eval(context).Value;
            var SkyColorG = inputs[(int)InputId.SkyColorG].Eval(context).Value;
            var SkyColorB = inputs[(int)InputId.SkyColorB].Eval(context).Value;
            var SkyColorA = inputs[(int)InputId.SkyColorA].Eval(context).Value;
            var SkyColor = new Color4(SkyColorR, SkyColorG, SkyColorB, SkyColorA);
            var SunColorR = inputs[(int)InputId.SunColorR].Eval(context).Value;
            var SunColorG = inputs[(int)InputId.SunColorG].Eval(context).Value;
            var SunColorB = inputs[(int)InputId.SunColorB].Eval(context).Value;
            var SunColorA = inputs[(int)InputId.SunColorA].Eval(context).Value;
            var SunColor = new Color4(SunColorR, SunColorG, SunColorB, SunColorA);
            var Resolution = inputs[(int)InputId.Resolution].Eval(context).Value;
            var GroundColorR = inputs[(int)InputId.GroundColorR].Eval(context).Value;
            var GroundColorG = inputs[(int)InputId.GroundColorG].Eval(context).Value;
            var GroundColorB = inputs[(int)InputId.GroundColorB].Eval(context).Value;
            var GroundColorA = inputs[(int)InputId.GroundColorA].Eval(context).Value;
            var GroundColor = new Color4(GroundColorR, GroundColorG, GroundColorB, GroundColorA);
            var HorizonBlur = inputs[(int)InputId.HorizonBlur].Eval(context).Value;
            var HorizonOffset = inputs[(int)InputId.HorizonOffset].Eval(context).Value;
            var HorizonColorR = inputs[(int)InputId.HorizonColorR].Eval(context).Value;
            var HorizonColorG = inputs[(int)InputId.HorizonColorG].Eval(context).Value;
            var HorizonColorB = inputs[(int)InputId.HorizonColorB].Eval(context).Value;
            var HorizonColorA = inputs[(int)InputId.HorizonColorA].Eval(context).Value;
            var HorizonColor = new Color4(HorizonColorR, HorizonColorG, HorizonColorB, HorizonColorA);
            //<<< _params


            if (_effect == null)
            {
                for (int i = 0; i < NumCodes(); ++i) {
                    Compile(i);
                }
                //Logger.Info(this, "compiled fx");
                Changed = true;
            }
            
            var cubeMapSize = new Vector2(512, 512);

            if (_prefilteredCubeMap == null)
            {
                //Logger.Info(this, "create cubemap");
                var cubeMapDesc = new Texture2DDescription
                {
                    BindFlags = BindFlags.ShaderResource | BindFlags.RenderTarget,
                    Format = SharpDX.DXGI.Format.R16G16B16A16_Float,
                    Width = (int)cubeMapSize.X,
                    Height = (int)cubeMapSize.Y,
                    MipLevels = 9,
                    SampleDescription = new SampleDescription(1,0),
                    Usage = ResourceUsage.Default,
                    OptionFlags = ResourceOptionFlags.TextureCube | ResourceOptionFlags.GenerateMipMaps,
                    CpuAccessFlags = CpuAccessFlags.None,
                    ArraySize = 6
                };

                _prefilteredCubeMap = new Texture2D(D3DDevice.Device, cubeMapDesc);
                _cubeMapRTV = new RenderTargetView(D3DDevice.Device, _prefilteredCubeMap);
                
                var rastDesc = new RasterizerStateDescription
                                   {
                                       FillMode = FillMode.Solid,
                                       CullMode = CullMode.None,
                                       IsDepthClipEnabled = false
                                   };
                _rasterizerState = new RasterizerState(D3DDevice.Device, rastDesc);    
            }

            if (Changed)
            {
                var prevEffect = context.Effect;
    
                var prevRTV = context.RenderTargetView;
                var prevDTV = context.DepthStencilView;
    
    
                context.D3DDevice.ImmediateContext.OutputMerger.SetTargets(_cubeMapRTV, null);
                context.D3DDevice.ImmediateContext.OutputMerger.BlendState = OperatorPartContext.DefaultRenderer.DisabledBlendState;
                context.D3DDevice.ImmediateContext.OutputMerger.DepthStencilState = OperatorPartContext.DefaultRenderer.DisabledDepthStencilState;
                
                _effect.GetVariableByName("SunPosition").AsVector().Set(SunPosition);
                _effect.GetVariableByName("SkyColor").AsVector().Set(SkyColor);
                _effect.GetVariableByName("SunColor").AsVector().Set(SunColor);
                _effect.GetVariableByName("GroundColor").AsVector().Set(GroundColor);
                _effect.GetVariableByName("HorizonBlur").AsScalar().Set(HorizonBlur);
                _effect.GetVariableByName("HorizonOffset").AsScalar().Set(HorizonOffset);           
                _effect.GetVariableByName("HorizonColor").AsVector().Set(HorizonColor);           
                
    
                var viewport = new ViewportF(0.0f, 0.0f, cubeMapSize.X, cubeMapSize.Y);
                context.D3DDevice.ImmediateContext.Rasterizer.SetViewports(new [] { viewport });
                context.D3DDevice.ImmediateContext.Rasterizer.State = _rasterizerState;
                context.D3DDevice.ImmediateContext.InputAssembler.InputLayout = context.InputLayout;
                context.D3DDevice.ImmediateContext.InputAssembler.PrimitiveTopology = SharpDX.Direct3D.PrimitiveTopology.TriangleList;
                context.D3DDevice.ImmediateContext.InputAssembler.SetVertexBuffers(0, new VertexBufferBinding(null, 0, 0));
    
                var technique = _effect.GetTechniqueByIndex(0);
                technique.GetPassByIndex(0).Apply(context.D3DDevice.ImmediateContext);
                context.D3DDevice.ImmediateContext.Draw(6, 0);
    
                context.D3DDevice.ImmediateContext.OutputMerger.SetTargets(context.DepthStencilView, context.RenderTargetView);
    
                using (var srv = new ShaderResourceView(context.D3DDevice, _prefilteredCubeMap))
                {
                    Logger.Info(this, "generate mips");
                    context.D3DDevice.ImmediateContext.GenerateMips(srv);
                }
                Changed = false;
            }
            
            context.Image = _prefilteredCubeMap;
            return context;
        }

        Texture2D _prefilteredCubeMap;
        RenderTargetView _cubeMapRTV;
        RasterizerState _rasterizerState;
    }
}


