//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.Threading;
using Stateless;
using System.Windows.Forms;
using Framefield.Core.Inputs;

namespace Framefield.Core.IDd5909c0c_4381_4437_8371_7740a30d384a
{

    public class Class_SMExample : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        public enum State
        {
            Off,
            BackgroundVideos,
            Game,
            Game_Intro,
            Game_CallOutPlayers,
            Game_CalibratePlayers,
            Game_CountDown,
            Game_Play,
            Game_Results,
            Game_LeaderBoard,
            Game_NextGame,
            Game_ExitGameMode,
        }

        public enum Trigger
        {
            Abort,
            Cancel,
            Complete,
            Continue,
            EndGame,
            Off,
            On,
            Skip,
            StartGame,
            StartGameIntro,
            Timeout
        }


        StateMachine<State,Trigger> _stateMachine = new StateMachine<State, Trigger>(State.Off); 


        public Class_SMExample()
        {
            _stateMachine.Configure(State.Off)
                         .OnEntry(() => Logger.Info(this,"entered OFF"))
                         .OnExit(() => Logger.Info(this,"exited OFF"))
                         .Permit(Trigger.On, State.BackgroundVideos);

            _stateMachine.Configure(State.BackgroundVideos)
                         .OnEntry(() => Logger.Info(this,"entered BACKGROUND_VIDEOS"))
                         .OnExit(() => Logger.Info(this,"exited BACKGROUND_VIDEOS"))
                         .Permit(Trigger.Off, State.Off)
                         .Permit(Trigger.StartGame, State.Game);

            _stateMachine.Configure(State.Game)
                         .OnEntry(() => { Logger.Info(this,"entered GAME"); _stateMachine.Fire(Trigger.StartGameIntro); })
                         .OnExit(() => Logger.Info(this,"exited GAME"))
                         .Permit(Trigger.EndGame, State.BackgroundVideos)
                         .Permit(Trigger.StartGameIntro, State.Game_Intro);

            {
                _stateMachine.Configure(State.Game_Intro)
                             .SubstateOf(State.Game)
                             .OnEntry(Game_Intro_OnEntry)
                             .OnUpdate(Game_Intro_OnUpdate)
                             .OnExit(() => Logger.Info(this,"exited GAME_INTRO"))
                             .Permit(Trigger.Skip, State.Game_CallOutPlayers)
                             .Permit(Trigger.Timeout, State.Game_CallOutPlayers);

                _stateMachine.Configure(State.Game_CallOutPlayers)
                             .SubstateOf(State.Game)
                             .OnEntry(() => Logger.Info(this,"entered CALL_OUT_PLAYERS"))
                             .OnExit(() => Logger.Info(this,"exited CALL_OUT_PLAYERS"))
                             .Permit(Trigger.Continue, State.Game_CalibratePlayers)
                             .Permit(Trigger.Cancel, State.Game_Intro);

                _stateMachine.Configure(State.Game_CalibratePlayers)
                             .SubstateOf(State.Game)
                             .OnEntry(() => Logger.Info(this,"entered CALIBRATE_PLAYERS"))
                             .OnExit(() => Logger.Info(this,"exited CALIBRATE_PLAYERS"))
                             .Permit(Trigger.Complete, State.Game_CountDown)
                             .Permit(Trigger.Cancel, State.Game_CallOutPlayers);

                _stateMachine.Configure(State.Game_CountDown)
                             .SubstateOf(State.Game)
                             .OnEntry(() => Logger.Info(this,"entered COUNT_DOWN"))
                             .OnExit(() => Logger.Info(this,"exited COUNT_DOWN"))
                             .Permit(Trigger.Timeout, State.Game_Play)
                             .Permit(Trigger.Cancel, State.Game_CalibratePlayers);

                _stateMachine.Configure(State.Game_Play)
                             .SubstateOf(State.Game)
                             .OnEntry(() => Logger.Info(this,"entered PLAY"))
                             .OnExit(() => Logger.Info(this,"exited PLAY"))
                             .Permit(Trigger.Complete, State.Game_Results)
                             .Permit(Trigger.Abort, State.Game_Results)
                             .Permit(Trigger.Cancel, State.Game_CountDown);

                _stateMachine.Configure(State.Game_Results)
                             .SubstateOf(State.Game)
                             .OnEntry(() => Logger.Info(this,"entered RESULTS"))
                             .OnExit(() => Logger.Info(this,"exited RESULTS"))
                             .Permit(Trigger.Skip, State.Game_LeaderBoard)
                             .Permit(Trigger.Timeout, State.Game_LeaderBoard)
                             .Permit(Trigger.Cancel, State.Game_Play);

                _stateMachine.Configure(State.Game_LeaderBoard)
                             .SubstateOf(State.Game)
                             .OnEntry(() => Logger.Info(this,"entered LEADER_BOARD"))
                             .OnExit(() => Logger.Info(this,"exited LEADER_BOARD"))
                             .Permit(Trigger.Continue, State.Game_NextGame)
                             .Permit(Trigger.Timeout, State.Game_NextGame);

                _stateMachine.Configure(State.Game_NextGame)
                             .SubstateOf(State.Game)
                             .OnEntry(() => Logger.Info(this,"entered NEXT_GAME"))
                             .OnExit(() => Logger.Info(this,"exited NEXT_GAME"))
                             .Permit(Trigger.Continue, State.Game_CallOutPlayers)
                             .Permit(Trigger.Cancel, State.Game_ExitGameMode);

                _stateMachine.Configure(State.Game_ExitGameMode)
                             .SubstateOf(State.Game)
                             .OnEntry(() => Logger.Info(this,"entered EXIT_GAME_MODE"))
                             .OnExit(() => Logger.Info(this,"exited EXIT_GAME_MODE"))
                             .Permit(Trigger.Timeout, State.BackgroundVideos)
                             .Permit(Trigger.Abort, State.BackgroundVideos);
            }
            Input.Keyboard.KeyReleasedEvent += HandleKeyReleasedEvent;
        }

        public override void Dispose()
        {
            Input.Keyboard.KeyReleasedEvent -= HandleKeyReleasedEvent;
        }

        private void Game_Intro_OnEntry()
        {
            Logger.Info(this,"entered GAME_INTRO with time {0}", _currentContext.Time);
            _timeoutStart = _currentContext.Time;
        }

        private void Game_Intro_OnUpdate()
        {
            Logger.Info(this,"update GAME_INTRO with time {0}", _currentContext.Time);
            if (_currentContext.Time - _timeoutStart > 10.0f)
            {
                _stateMachine.Fire(Trigger.Timeout);
            }
        }

        private OperatorPartContext _currentContext;
        private float _timeoutStart;

        private void HandleKeyReleasedEvent(object o, KeyboardInput.KeyEventArgs e)
        {
//            Logger.Info(this,"keystate: {0}  key: {1}", e.KeyState, e.Keys);
            try
            {
                switch (e.Keys)
                {
                    case Keys.Escape:
                        Logger.Info(this,"escape -> abort");
                        _stateMachine.Fire(Trigger.Abort);
                        break;
                    case Keys.Return:
                        Logger.Info(this,"return -> continue");
                        _stateMachine.Fire(Trigger.Continue);
                        break;
                    case Keys.Back:
                        Logger.Info(this,"backspace -> cancel");
                        _stateMachine.Fire(Trigger.Cancel);
                        break;
                    case Keys.E:
                        Logger.Info(this,"e -> endgame");
                        _stateMachine.Fire(Trigger.EndGame);
                        break;
                    case Keys.O:
                        Logger.Info(this,"o -> on");
                        _stateMachine.Fire(Trigger.On);
                        break;
                    case Keys.S:
                        Logger.Info(this,"s -> startgame");
                        _stateMachine.Fire(Trigger.StartGame);
                        break;
                }
            }
            catch (InvalidOperationException exception)
            {
                Logger.Warn(this,exception.Message);
            }
        }
        
        //>>> __inputids
        private enum InputId
        {
            Input = 0
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> __params
            var Input = inputs[(int)InputId.Input];
            //<<< _params        

            _currentContext = context;
            _stateMachine.Update();

            return context;
        }

    }


} 