//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.Rendering;

namespace Framefield.Core.IDec3b5fd5_0045_473c_bb02_d565f500b408
{
    public class Class_ShaderPosBuffer : FXSourceCodeFunction, IFXSceneSourceCode
    {
        public Class_ShaderPosBuffer() {
            _renderer = new DefaultRenderer();
        }

        public override void Dispose() {
            Utilities.DisposeObj(ref _renderer);
            base.Dispose();
        }

        bool _firstEval = true;
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Scene = 1,
            PositionBuffer = 2,
            PositionIdx = 3
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Scene = inputs[(int)InputId.Scene];
            var PositionBuffer = inputs[(int)InputId.PositionBuffer].Eval(context).Image; // Needs to be checked for null!
            var PositionIdx = inputs[(int)InputId.PositionIdx].Eval(context).Value;
            //<<< _params

            if (_firstEval) 
            {
                for (int i = 0; i < NumCodes(); ++i)
                    Compile(i);
                _firstEval = false;
                Changed = true;
            }

            using (var PositionBufferView = new ShaderResourceView(context.D3DDevice, PositionBuffer))
            {
                _effect.GetVariableByName("PositionBuffer").AsShaderResource().SetResource(PositionBufferView);
                _effect.GetVariableByName("PositionIdx").AsScalar().Set(PositionIdx);
                using (new PropertyStasher<OperatorPartContext>(context, "Effect", "Renderer")) 
                {
                    context.Effect = _effect;
                    context.Renderer = _renderer;
    
                    Scene.Eval(context);
                }
            }

            return context;
        }

        DefaultRenderer _renderer;
    }
}


