//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

using System.Runtime.InteropServices;
using Framefield.Core.Rendering;
using SharpDX.DXGI;
using SharpDX.D3DCompiler;
using Buffer = SharpDX.Direct3D11.Buffer;
using System.CodeDom.Compiler;


namespace Framefield.Core.IDabd549f1_3fa4_4f66_8514_290779054f73
{
    public class Class__BRDFLookupTexture : FXSourceCodeFunction
    {
        [StructLayout(LayoutKind.Explicit, Size = 144)]
        public struct ConstBufferLayout
        {
            [FieldOffset(0)] 
            public Color4 Color;
        }
        
        //>>> _inputids
        private enum InputId
        {
            Code = 0
        }
        //<<< _inputids

        public void Dispose()
        {
            Utilities.DisposeObj(ref _uaTexture);
            Utilities.DisposeObj(ref _uaTextureUAV);
            Utilities.DisposeObj(ref _cs);
            base.Dispose();
        }

        const int TEXTURE_SIZE = 128;
        
        protected bool BuildRenderTarget(OperatorPartContext context)
        {
            if (_uaTexture != null)
            {
                return false;
            }

            var uavDesc = new Texture2DDescription
                              {
                                  BindFlags = BindFlags.ShaderResource | BindFlags.UnorderedAccess,
                                  Format = Format.R16G16_UNorm,
                                  Width = TEXTURE_SIZE,
                                  Height = TEXTURE_SIZE,
                                  MipLevels = 1,
                                  SampleDescription = new SampleDescription(1, 0),
                                  Usage = ResourceUsage.Default,
                                  OptionFlags = ResourceOptionFlags.None,
                                  CpuAccessFlags = CpuAccessFlags.None,
                                  ArraySize = 1
                              };
            Utilities.DisposeObj(ref _uaTexture);
            Utilities.DisposeObj(ref _uaTextureUAV);
            _uaTexture = new Texture2D(context.D3DDevice, uavDesc);
            _uaTextureUAV = new UnorderedAccessView(context.D3DDevice, _uaTexture);
            //Logger.Info(this,"texture");

            return true;
        }


        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            //<<< _params

            if (Changed)
            {
                if (_cs == null)
                {
                    Utilities.DisposeObj(ref _cs);
                    var errors = new CompilerErrorCollection();
                    try
                    {
                        using (var bytecode = ShaderBytecode.Compile(GetCode(0), "CS", "cs_5_0", ShaderFlags.OptimizationLevel3))
                            _cs = new ComputeShader(D3DDevice.Device, bytecode);
                    }
                    catch (SharpDX.CompilationException ex)
                    {
                        errors = ErrorsFromString(ex.Message);
                        Logger.Error(this,"Fx compile error: {0}", ex.Message);
                    }
                }
    
                BuildRenderTarget(context);
    
                var mc = new ConstBufferLayout();
                mc.Color = new Color4(1, 0, 1, 1);
    
                BaseRenderer.SetupConstBufferForCS(context, mc, ref _constBuffer, 0);
    
                var deviceContext = context.D3DDevice.ImmediateContext;
                deviceContext.ComputeShader.Set(_cs);
                deviceContext.ComputeShader.SetUnorderedAccessView(0, _uaTextureUAV);
                deviceContext.Dispatch(TEXTURE_SIZE/16, TEXTURE_SIZE/16, 1);
                deviceContext.ComputeShader.SetUnorderedAccessView(0, null);
                Logger.Info(this,"dispatched");
                //Texture2D.ToFile(context.D3DDevice.ImmediateContext, _uaTexture, ImageFileFormat.Dds, "BRDFLookupTable.dds");
                Changed = false;
            }
            context.Image = _uaTexture;

            return context;
        }

        private Buffer _constBuffer;
        private Texture2D _uaTexture;
        private UnorderedAccessView _uaTextureUAV;
        private ComputeShader _cs;
    }
}

