//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.Dynamic;

namespace Framefield.Core.ID548adb53_ed26_43d8_a7f0_aa728677d352
{
    public class Class__PbrPointLightRaw : OperatorPart.Function, IPbrPointLight
    {
        //>>> _inputids
        private enum InputId
        {
            Scene = 0,
            PositionX = 1,
            PositionY = 2,
            PositionZ = 3,
            IntensityAmbient = 4,
            IntensityDiffuse = 5,
            IntensitySpecular = 6,
            Enabled = 7,
            ColorR = 8,
            ColorG = 9,
            ColorB = 10,
            ColorA = 11,
            LightRadius = 12
        }
        //<<< _inputids
        //>>> _outputids
        private enum OutputId
        {
            Scene = 0,
            This = 1
        }
        //<<< _outputids
    
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Scene = inputs[(int)InputId.Scene];
            var PositionX = inputs[(int)InputId.PositionX].Eval(context).Value;
            var PositionY = inputs[(int)InputId.PositionY].Eval(context).Value;
            var PositionZ = inputs[(int)InputId.PositionZ].Eval(context).Value;
            var Position = new Vector3(PositionX, PositionY, PositionZ);
            var IntensityAmbient = inputs[(int)InputId.IntensityAmbient].Eval(context).Value;
            var IntensityDiffuse = inputs[(int)InputId.IntensityDiffuse].Eval(context).Value;
            var IntensitySpecular = inputs[(int)InputId.IntensitySpecular].Eval(context).Value;
            var Intensity = new Vector3(IntensityAmbient, IntensityDiffuse, IntensitySpecular);
            var Enabled = (int) inputs[(int)InputId.Enabled].Eval(context).Value;
            var ColorR = inputs[(int)InputId.ColorR].Eval(context).Value;
            var ColorG = inputs[(int)InputId.ColorG].Eval(context).Value;
            var ColorB = inputs[(int)InputId.ColorB].Eval(context).Value;
            var ColorA = inputs[(int)InputId.ColorA].Eval(context).Value;
            var Color = new Color4(ColorR, ColorG, ColorB, ColorA);
            var LightRadius = inputs[(int)InputId.LightRadius].Eval(context).Value;
            //<<< _params

            // store values for later use of IPbrPointLight
            this.Position = Position;
            this.Color = new Color3(ColorR, ColorG, ColorB);
            this.Intensity = Intensity;
            this.LightRadius = LightRadius;
            
            var isLightEnabled = Enabled > 0.01f;
            var pointLightContainer = (List<IPbrPointLight>) context.Objects[OperatorPartContext.PBR_POINT_LIGHT_CONTAINER_ID];
            if (isLightEnabled && (pointLightContainer != null))
            {
                pointLightContainer.Add(this);
            }
            else
            {
                //Logger.Error(this,"No point light container found in context!");
            }

            switch (outputIdx)
            {
                case (int)OutputId.Scene:
                    Scene.Eval(context);
                    break;
                case (int)OutputId.This:
                    context.Dynamic = this;
                    break;
            }

            pointLightContainer.Remove(this);

            return context;
        }

        public Vector3 Position { get; private set; }
        public Color3 Color { get; private set; }
        public Vector3 Intensity { get; private set; }
        public float LightRadius { get; private set; }

    }
}

