//#define LOGGING

//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID116d807e_8e94_4c09_b7e4_e11075b5836f
{
    public class Class__setIBLBuffers : OperatorPart.Function, IPbrImageBasedLightingSetup
    {
        //>>> _inputids
        private enum InputId
        {
            Scene = 0,
            HDRProbe = 1,
            BRDFLookup = 2,
            PrefilteredSpec = 3
        }
        //<<< _inputids
    
        private bool _initialSetup = true;
        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            var Scene = inputs[(int)InputId.Scene];
            var HDRProbeInput = inputs[(int)InputId.HDRProbe];
            var BRDFLookupInput = inputs[(int)InputId.BRDFLookup];
            var PrefilteredSpecInput = inputs[(int)InputId.PrefilteredSpec];

            // store values for later use
            if (PrefilteredSpecularCubeMap == null || PrefilteredSpecInput.Func.Changed)
            {
                PrefilteredSpecularCubeMap = PrefilteredSpecInput.Eval(context).Image;
                Logger.Info(this, "prefilteredSpecularInput changed");
            }
            
            if (BrdfLookupTexture == null || BRDFLookupInput.Func.Changed)
            {
                BrdfLookupTexture = BRDFLookupInput.Eval(context).Image;
                Logger.Info(this, "brdf lookup changed");
            }

            if (HDRProbeInput.Func.Changed || _initialSetup)
            {
                Logger.Info(this, "hdr probe changed");
                var HDRProbe = HDRProbeInput.Eval(context).Image; // Needs to be checked for null!
                var colors = Texture2D.SHProjectCubeMap(context.D3DDevice.ImmediateContext, HDRProbe, 4);
                float[] r = new float[9];
                float[] g = new float[9];
                float[] b = new float[9];

                const float one_over_pi = 1.0f / MathUtil.Pi;
                for (int i = 0; i < 9; ++i)
                {
                    r[i] = colors[i].Red * one_over_pi;
                    g[i] = colors[i].Green * one_over_pi;
                    b[i] = colors[i].Blue * one_over_pi;
                }               

                this.DiffuseR = CreateLightMatrix(r);
                this.DiffuseG = CreateLightMatrix(g);
                this.DiffuseB = CreateLightMatrix(b);
                Changed = false;
                _initialSetup = false;

                #region logging
                #if LOGGING
                for (int i = 0; i < colors.Length; ++i)
                {
                    Logger.Info(this,"{0}    {1}     {2}", colors[i].Red, colors[i].Green, colors[i].Blue);
                }
                Logger.Info("");
                for (int i = 0; i < 9; ++i)
                {
                    Logger.Info(this,"{0}    {1}     {2}", r[i], g[i], b[i]);
                }
                Logger.Info(this,"{0}", DiffuseR);
                #endif
                #endregion
            }


            var prevLightingSetup = (IPbrImageBasedLightingSetup) context.Objects[OperatorPartContext.PBR_IMAGE_BASED_LIGHTING_ID];
            context.Objects[OperatorPartContext.PBR_IMAGE_BASED_LIGHTING_ID] = this;

            Scene.Eval(context);

            context.Objects[OperatorPartContext.PBR_IMAGE_BASED_LIGHTING_ID] = prevLightingSetup;

            return context;
        }

        private Matrix CreateLightMatrix(float[] lightCoefs)
        {
            if (lightCoefs.Length < 9)
                return Matrix.Identity;
            var c1 = 0.429043f; 
            var c2 = 0.511664f;
            var c3 = 0.743125f;
            var c4 = 0.886227f;
            var c5 = 0.247708f;

            var L00 = lightCoefs[0];
            var L1_1 = lightCoefs[1];
            var L10 = lightCoefs[2];
            var L11 = lightCoefs[3];
            var L2_2 = lightCoefs[4];
            var L2_1 = lightCoefs[5];
            var L20 = lightCoefs[6];
            var L21 = lightCoefs[7];
            var L22 = lightCoefs[8];

            Matrix m = new Matrix(c1*L22,  c1*L2_2, c1*L21,  c2*L11,
                                  c1*L2_2, -c1*L22, c1*L2_1, c2*L1_1,
                                  c1*L21,  c1*L2_1, c3*L20,  c2*L10,
                                  c2*L11,  c2*L1_1, c2*L10,  c4*L00-c5*L20);
            return m;            
        }


        public Texture2D PrefilteredSpecularCubeMap { get; private set; }
        public Texture2D BrdfLookupTexture { get; private set; }
        public Matrix DiffuseR { get; private set; }
        public Matrix DiffuseG { get; private set; }
        public Matrix DiffuseB { get; private set; }
    }
}

