import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    id: blurReflect
    name: "blurReflect"
    effectName: "BlurReflect"
    enabled: syncRoot(name+".ON")
    property string shader: "blur"

    property real posX: 0.0
    property real posY: 0.0
    Texture {
        textureUnit: 0
        textureRT: "screenBuffer"
        textureWrap: "clamp"
    }

//    Blit {
//        textureRT: "screenBuffer1"
//        blitRT: 0
//    }

//    Blit {
//        textureRT: "bgOrig"
//        blitRT: 0
//    }

    Repeater {
        model: sync(name+".blurLoops")
        delegate: Group {
            Blit {
                textureRT: "screenBuffer"
                blitRT: 0
            }
//            Blit {
//                textureRT: "screenBuffer"+index
//                blitRT: 0
//            }
            Shader {
                file: shader
                ShaderParam {
                    paramName: "g_blurStrength"
                    property real strengthAddPerLoop: sync(name+".strength.addPerLoop")
                    paramValue: sync(name+".strength")*(1.0+index*strengthAddPerLoop)
                }
            }
            DrawVB {
                type: "quad"
                depthTest: false
                depthWrite: false
                blendMode: "off"
                drawBuffers: 1
            }
        }
    }

    Blit {
        textureRT: "bgBlur"
        blitRT: 0
    }
    Blit {
        textureRT: "prevReflBlur"
        blitRT: 0
    }
    Shader {
        file: "fx/_SharedQML/reflectMix"
    }
    Texture {
        textureUnit: 0
        textureRT: "bg"
    }
    Texture {
        textureUnit: 1
        textureRT: "bgBlur"
    }
    DrawVB {
        ShaderParam {
            paramName: "flip"
            paramValue: 0.0
        }
        ShaderParam {
            paramName: "overlayAlpha"
            paramValue: 1.0
        }
        ShaderParam {
            paramName: "g_overlayScale"
            paramValue: 1.0
        }
        ShaderParam { paramName: "g_addBlend"; paramValue: sync("reflect.addBlend") }
        type: "quad"
        depthTest: false
        depthWrite: false
        blendMode: "off"
    }



//    Blit {
//        textureRT: "colorBuffer"
//    }
//    Texture {
//        textureUnit: 0
//        textureRT: "colorBuffer"
//    }
//    Texture {
//        textureUnit: 1
//        textureRT: "screenBuffer2"
//    }

//    Shader {
//        file: "fx/_SharedQML/overlayAdd"
//    }

//    DrawVB {
//        ShaderParam {
//            paramName: "flip"
//            paramValue: 0.0
//        }
//        ShaderParam {
//            paramName: "overlayAlpha"
//            paramValue: 0.25
//        }
//        ShaderParam {
//            paramName: "g_overlayScale"
//            paramValue: 1.0
//        }
//        ShaderParam {
//            paramName: "g_posX"
//            paramValue: 0.0
//        }
//        ShaderParam {
//            paramName: "g_posY"
//            paramValue: 0.0
//        }

//        type: "quad"
//        depthTest: false
//        depthWrite: false
//    }



}
