import QtQuick 2.4

import AdaptDemoSystem 1.0

GroupBase {
    id: groupBase


    property var valMap: []

    Component {
        id: sb
        SyncBlock {

        }
    }

    function syncWithBlock(track, defaultValue) {
        var sk = sceneName+"."+track;
        var sbu = valMap[sk];
        if (sbu === undefined) {
            valMap[sk] = sb.createObject(groupBase);
            sbu = valMap[sk];
            sbu.trackName = sk;
        }
        if (!root.bReleaseVer) {
            if (defaultValue !== undefined && defaultValue !== "" && sbu.value===0.0) {
                var trackKeys = getRootRocket().getTrackNumKeys(sk);
                if (trackKeys === 0) {
                    getRootRocket().setTrackFirstValue(sk, defaultValue);
                    return defaultValue;
                }
            }
        }
        return sbu.value;
    }

    function syncWithBlockTrigger(track, defaultValue) {
        var sk = sceneName+"."+track;
        var sbu = valMap[sk];
        if (sbu === undefined) {
            valMap[sk] = sb.createObject(groupBase);
            sbu = valMap[sk];
            sbu.trackName = sk;
        }
//        if (!root.bReleaseVer) {
//            if (defaultValue !== undefined && defaultValue !== "" && sbu.valueTrigger===0.0) {
//                var trackKeys = getRootRocket().getTrackNumKeys(track);
//                if (trackKeys === 0) {
//                    getRootRocket().setTrackFirstValue(track, defaultValue);
//                    return defaultValue;
//                }
//            }
//        }
        return sbu.valueTrigger;
    }


    function sync(track, defaultValue) {
        if (sceneName === "") return 1.0;
        return syncWithBlock(track, defaultValue);
    }

    function syncGroup(track, defaultValue) {
        if (sceneName == "") return 1.0;
        return syncWithBlock(track, defaultValue);
    }

    function syncTrigger(track) {
        if (sceneName == "") return 1.0;
        if (!demoLoadedAndInitReady) {
            return 1.0;
        }
        var a = getRootRocket().syncTrigger(sceneName+"."+track);
        var b = groupBase.effectSyncUpdate;
        return a;
        //return syncWithBlockTrigger(track, defaultValue);
    }

    function syncOsc(track, defaultValue) {
        return syncOscBase(track, "-osc", defaultValue, syncGroup);
    }
    function syncFFT(track, defaultValue) {
        return syncFFTBase(track, "-fft", defaultValue, syncGroup);
    }
    function syncOscFFT(track, defaultValue) {
        return syncOscBase(track, "-osc", defaultValue, syncGroup)+syncFFTBase(track, "-fft", defaultValue, syncGroup)-syncGroup(track, defaultValue);
    }


}
