import QtQuick 2.4
import AdaptDemoSystem 1.0

Group {
    id: box
    name: "mesh"
    enabled: syncRoot(box.name+".ON")


    TextureSel { name: box.name }
    TextureSel { name: box.name; textureUnit: 1 }
    TextureSel { name: box.name; textureUnit: 6 }
    Shader { file: "smLogo" }
    DrawMesh {
        property string name: box.name
        file: meshSel(box.name)
        depthTest: sync(box.name+".depthEnabled", 1.0) > 0.5
        depthWrite: depthTest
        blendMode: blendSel(box.name)

        smoothNormals: true; normalSmoothAngle: 90;

        Pos { x: syncOsc(box.name+".posX"); y: syncOsc(box.name+".posY"); z: syncOsc(box.name+".posZ")}
        Rot { d: sync(box.name+".rotX"); ax: 1.0; ay: 0.0; az: 0.0 }
        Rot { d: sync(box.name+".rotY"); ax: 0.0; ay: 1.0; az: 0.0 }
        Rot { d: sync(box.name+".rotZ"); ax: 0.0; ay: 0.0; az: 1.0 }
        Sca { s: sync(box.name+".scale"); x: sync(box.name+".scaX"); y: sync(box.name+".scaY"); z: sync(box.name+".scaZ") }

        ShaderParam { paramName: "g_texBrightness"; paramValue: sync(box.name+".bright", 1.0) }
        ShaderParam { paramName: "g_texAmbient"; paramValue: sync(box.name+".ambient", 0.1) }
        ShaderParam { paramName: "g_uvScale"; paramValue: sync(box.name+".uvScale", 1.0) }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync(box.name+".prevBlur", 0.5) }
        ShaderParam { paramName: "g_prevBlurType"; paramValue: sync(box.name+".prevBlurType") }
        ShaderParam { paramName: "g_bump"; paramValue: sync(box.name+".bump", 0.25) }
        ShaderParam { paramName: "g_genUV"; paramValue: sync(box.name+".genUV", 1.0) }
        ShaderParam { paramName: "g_alpha"; paramValue: sync(box.name+".alpha", 1.0) }

        ShaderParam { paramName: "g_mulTexAmp"; paramValue: sync(box.name+".mulTexAmp") }

        ShaderParam { paramName: "g_emitThr"; paramValue: sync(box.name+".palaEmitThr", 0.0) }
        ShaderParam { paramName: "g_emitAmp"; paramValue: syncFFT(box.name+".palaEmitAmp", 1.0) }

        ShaderParam { paramName: "g_uvOfsX"; paramValue: sync(box.name+".uvOfsX", 0.0)}
        ShaderParam { paramName: "g_uvOfsY"; paramValue: sync(box.name+".uvOfsY", 0.0)}

//        SavePoint {
//            target: meshInst.name+"_SP"
//            x: meshInst.posX+sync(meshInst.name+".spx")/meshInst.sca; y: meshInst.posY/meshInst.sca+sync(meshInst.name+".spy"); z: meshInst.posZ/(meshInst.sca*meshInst.scaZ)+sync(meshInst.name+".spz");
//        }

    }

}
