//Inits event listeners for loading
var Listeners = function(){

    var audioStatus = false;
    var videoStatus = true;
    var userStatus = false;
    var syncStatus = false;
    var textureStatus = false;
    var sceneStatus = false;

    var width = 1280;
    var height = 720;

    var videoCallbacks = {};
    var videos = {};

    var allLoaded = function(){
        console.log("Audio: ", audioStatus,
            " Videos: ", videoStatus, " Textures: ",
            textureStatus, " Scenes: ", sceneStatus,
            " Sync: ", syncStatus, " User: ", userStatus);

        if(audioStatus && videoStatus && textureStatus && userStatus && syncStatus && sceneStatus){
            initRocketListeners(document.getElementById("audio"));

            setTimeout(function(){
                document.getElementById("loader").style.display = "none";
                TDEMO.MAIN.mainloop();
            }, 3000);
        }
    };

    var onResize = function(){
        var demoEl = document.getElementById("demo");
        demoEl.style.position = "absolute";
        demoEl.style.top = ((window.innerHeight-height)/2).toString() + "px";
        demoEl.style.left = ((window.innerWidth-width)/2).toString() + "px";
    };

    var selectResolution = function(){
        var el = document.getElementById("resolution");
        var reso = el.options[el.selectedIndex].value;
        var demoEl = document.getElementById("demo");

        //Resoluutiot on tarkoituksella 10px pielessä, koska jostain
        //syystä joskus selain leikkaa pari pikseliä kuvasta, jos kuva on koko ruudun levyinen.
        switch(reso){
            case "fs":
                var succeeded = true;
                if(document.body.requestFullscreen){
                    document.body.requestFullscreen();
                }
                else if(document.body.mozRequestFullScreen){
                    document.body.mozRequestFullScreen();
                }
                else if (document.body.webkitRequestFullscreen){
                    document.body.webkitRequestFullscreen();
                }
                else{
                    succeeded = false;
                }

                if(succeeded){
                    width = screen.width;
                    height = screen.height;
                }
                else{
                    width = 1280;
                    height = 720;
                }
                break;

            case "p1080":
                width = 1920;
                height = 1080;
                break;

            case "p900":
                width = 1600;
                height = 900;
                break;

            case "p720":
                width = 1280;
                height = 720;
                break;

            case "pal":
                width = 1024;
                height = 576;
                break;

            case "test":
                width = 128;
                height = 128;
                break;

            default:
                width = 1270;
                height = 710;
                break;
        }

        demoEl.width = width;
        demoEl.height = height;

        demoEl.style.position = "absolute";
        demoEl.style.top = ((window.innerHeight-height)/2).toString() + "px";
        demoEl.style.left = ((window.innerWidth-width)/2).toString() + "px";
        demoEl.style.zIndex = 0;

        TDEMO.MAIN.setRendererSize(width, height);
    };

    var initScenes = function(){
        //textures need to be set as well as the renderer size before continuing
        if(textureStatus && userStatus){
            var p = Parts();
            TDEMO.MAIN.setParts(p);
            sceneStatus = true;
            allLoaded();
        }
    };

    var videoReady = function(){
        if(!videoStatus){
            var ready = true;
            for(var vid in videos){
                if( videos.hasOwnProperty(vid)){
                    if(videos[vid] === false){
                        ready = false;
                    }
                }
            }
            if(ready === true){
                videoStatus = true;
                allLoaded();
            }
        }
    };

    var createVideoLoadCallback = function(id){
        return function(){
            if(videos[id] === false){
                console.log(id, " loaded!");
                videos[id] = true;
                videoReady();
            }
        };
    };

    //creating the callback
    var videoFiles = TDEMO.SYNC.getConfig().getVideoFiles();
    videoFiles.forEach(function(file){
        //adding video loading status to object
        videos[file.id] = false;
        var cb = createVideoLoadCallback(file.id);
        videoCallbacks[file.id] = cb;
    });

    var listeners = {
        audioReady : function(){
            if(!audioStatus){
                audioStatus = true;
                allLoaded();
            }
        },

        userReady : function(){
            selectResolution();

            window.addEventListener("resize", onResize);

            document.getElementById("start").style.display = "none";
            document.getElementById("demo").style.display = "block";
            document.getElementById("demo").style.cursor="none";
            document.getElementById("loader").style.display = "block";

            userStatus = true;
            initScenes();
        },

        syncReady : function(){
            TDEMO.SYNC.bindTracks();
            syncStatus = true;
            allLoaded();
        },

        texturesReady : function(textures){
            textureStatus = true;
            initScenes();
        },

        videoLoaders : videoCallbacks
    };

    return listeners;
};
