
//This is where everything is done
function onLoad(){

    var listeners = Listeners();
    TDEMO.TEXTURES.loadAll(listeners.texturesReady);

    //Setting up sync device
    var syncDevice = TDEMO.SYNC.initSyncDevice();
    syncDevice.on('ready', listeners.syncReady);

    //Setting up audio
    var audio = document.createElement('audio');
    audio.id = "audio";
    audio.setAttribute('src', TDEMO.SYNC.getConfig().getAudioPath());
    audio.load();
    audio.addEventListener("canplaythrough", listeners.audioReady);
    document.body.appendChild(audio);

    var videoPath = TDEMO.SYNC.getConfig().getVideoPath();
    var videoFiles = TDEMO.SYNC.getConfig().getVideoFiles();

    videoFiles.forEach(function(file){
        //Create video element and callbacks for each video resources
        var video = document.createElement('video');
        video.id = file.id;
        video.style.display = "none";
        video.loop = true;
        video.muted = true;
        video.setAttribute('src', videoPath+file.name);
        video.load();
        video.addEventListener("canplaythrough", listeners.videoLoaders[video.id]);
        document.body.appendChild(video);

    });

    //Setting up start button
    var startbtn = document.createElement("button");
    var t = document.createTextNode("START");
    startbtn.appendChild(t);
    startbtn.addEventListener("click", listeners.userReady);
    document.getElementById("start").appendChild(startbtn);

};
