var Kalat = function(){
    PartBase.call(this);

    //POSTPROCESSING
    this.setEdgeDetection();
    this.setBloom(8);

    //VIDEO TEXTURE
    this.video = document.getElementById( 'kalat' );
    this.texture = new THREE.VideoTexture(this.video);
    this.texture.minFilter = THREE.LinearFilter;
    this.texture.magFilter = THREE.LinearFilter;
    this.texture.format = THREE.RGBFormat;

    //GEOMETRY
    var geometry = new THREE.SphereGeometry(640, 128, 128);
    var material = new THREE.MeshBasicMaterial({
        //color : 0xF07030,
        map : this.texture,
        side : THREE.DoubleSide
    });

    this.pallo = new THREE.Mesh(geometry, material);
    this.scene.add(this.pallo);
};

Kalat.prototype = PartBase.prototype.inheritance();

Kalat.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);

    var ballp = TDEMO.SYNC.getObjPosition();
    this.pallo.position.x = ballp.x;
    this.pallo.position.y = ballp.y;
    this.pallo.position.z = ballp.z;

    var ballr = TDEMO.SYNC.getObjRotation();
    this.pallo.rotation.x = ballr.x;
    this.pallo.rotation.y = ballr.y;
    this.pallo.rotation.z = ballr.z;
};

Kalat.prototype.prepare = function(){
    PartBase.prototype.prepare.call(this);
    this.video.currentTime = 0;
    this.video.play();
};

Kalat.prototype.finish = function(){
   PartBase.prototype.finish.call(this);
   this.video.pause();
};
