var Sakura = function(){
    PartBase.call(this);

    //POSTPROCESSING
    this.setEdgeDetection();
    this.setBloom(6);

    //VIDEO TEXTURE
    this.video = document.getElementById( 'sakura' );
    this.texture = new THREE.VideoTexture(this.video);
    this.texture.minFilter = THREE.LinearFilter;
    this.texture.magFilter = THREE.LinearFilter;
    this.texture.format = THREE.RGBFormat;

    //GEOMETRY
    var geometry = new THREE.PlaneGeometry(640, 360);
    var material = new THREE.MeshBasicMaterial({
        map : this.texture,
        //color: 0x8080FF
    });

    var display = new THREE.Mesh(geometry, material);
    this.scene.add(display);
    //console.log(display.position.x + " " + display.position.y + " "+ display.position.z);
};

Sakura.prototype = PartBase.prototype.inheritance();

Sakura.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);
};

Sakura.prototype.prepare = function(){
    PartBase.prototype.prepare.call(this);
    this.video.currentTime = 0;
    this.video.play();
};

Sakura.prototype.finish = function(){
   PartBase.prototype.finish.call(this);
   this.video.pause();
};
