// Generated by Haxe 3.3.0
(function ($hx_exports, $global) { "use strict";
$hx_exports["wl"] = $hx_exports["wl"] || {};
$hx_exports["wl"]["util"] = $hx_exports["wl"]["util"] || {};
$hx_exports["kvg"] = $hx_exports["kvg"] || {};
$hx_exports["kvg"]["core"] = $hx_exports["kvg"]["core"] || {};
var $hxClasses = {},$estr = function() { return js_Boot.__string_rec(this,''); };
function $extend(from, fields) {
	function Inherit() {} Inherit.prototype = from; var proto = new Inherit();
	for (var name in fields) proto[name] = fields[name];
	if( fields.toString !== Object.prototype.toString ) proto.toString = fields.toString;
	return proto;
}
var wl_core_Signal = function() {
	this.callbacks = [];
};
$hxClasses["wl.core.Signal"] = wl_core_Signal;
wl_core_Signal.__name__ = ["wl","core","Signal"];
wl_core_Signal.prototype = {
	connect: function(callback) {
		this.callbacks.push(callback);
	}
	,disconnect: function(callback) {
		HxOverrides.remove(this.callbacks,callback);
	}
	,emit: function(param) {
		var _g = 0;
		var _g1 = this.callbacks;
		while(_g < _g1.length) {
			var cb = _g1[_g];
			++_g;
			cb(param);
		}
	}
	,__class__: wl_core_Signal
};
var DemoMain = function() {
};
$hxClasses["DemoMain"] = DemoMain;
DemoMain.__name__ = ["DemoMain"];
DemoMain.setup = function() {
	new THREE.FontLoader().load("font/BlackOpsOne_Regular.json",function(font) {
		DemoMain.font2 = font;
	},function() {
	},function() {
	});
};
DemoMain.onSoundReady = function() {
	var fft = wl_sounds_SoundWL.getFFT().waveformLeft;
	DemoMain.SOUNDTEXTURE = new THREE.DataTexture(fft,fft.length,1,THREE.LuminanceFormat,THREE.UnsignedByteType,THREE.UVMapping,THREE.ClampToEdgeWrapping,THREE.ClampToEdgeWrapping,THREE.LinearFilter,THREE.LinearFilter);
	DemoMain.canvas = window.document.createElement("canvas");
	DemoMain.ctx2d = DemoMain.canvas.getContext("2d",null);
	DemoMain.canvas.width = fft.length;
	DemoMain.canvas.height = 128;
	DemoMain.ctx2d.fillStyle = "#000";
	DemoMain.ctx2d.fillRect(0,0,fft.length,128);
	DemoMain.canvas.style.position = "fixed";
	DemoMain.canvas.style.right = "0px";
	DemoMain.canvas.style.left = "0px";
	DemoMain.SOUNDTEXTURE_HISTORY = new THREE.Texture(DemoMain.canvas);
};
DemoMain.update = function(ts,partial,frameTime,delta) {
	var fft = wl_sounds_SoundWL.getFFT().frequencyLeft;
	var _g1 = 0;
	var _g = DemoMain.canvas.width;
	while(_g1 < _g) {
		var i = _g1++;
		var v = fft[i];
		DemoMain.ctx2d.fillStyle = "#" + StringTools.hex(v << 16 | v << 8 | v,6);
		DemoMain.ctx2d.fillRect(i,DemoMain.historyind % DemoMain.canvas.height,1,2);
	}
	DemoMain.historyind++;
	DemoMain.SOUNDTEXTURE_HISTORY.needsUpdate = true;
};
DemoMain.prototype = {
	__class__: DemoMain
};
var HxOverrides = function() { };
$hxClasses["HxOverrides"] = HxOverrides;
HxOverrides.__name__ = ["HxOverrides"];
HxOverrides.cca = function(s,index) {
	var x = s.charCodeAt(index);
	if(x != x) {
		return undefined;
	}
	return x;
};
HxOverrides.substr = function(s,pos,len) {
	if(len == null) {
		len = s.length;
	} else if(len < 0) {
		if(pos == 0) {
			len = s.length + len;
		} else {
			return "";
		}
	}
	return s.substr(pos,len);
};
HxOverrides.remove = function(a,obj) {
	var i = a.indexOf(obj);
	if(i == -1) {
		return false;
	}
	a.splice(i,1);
	return true;
};
HxOverrides.iter = function(a) {
	return { cur : 0, arr : a, hasNext : function() {
		return this.cur < this.arr.length;
	}, next : function() {
		return this.arr[this.cur++];
	}};
};
var Main = function() { };
$hxClasses["Main"] = Main;
Main.__name__ = ["Main"];
Main.main = function() {
	$(window).ready(Main.windowReady);
};
Main.windowReady = function(e) {
	wl_util_LoadManager.onComplete = Main.onAssetsLoaded;
	Main.jsonConfigurator = new wl_setup_JsonConfigurator();
	Main.jsonConfigurator.fromJson(haxe_Resource.getString("Demo.json"));
	DemoMain.setup();
	$("#setup").css("display","none");
	Main.demo = new wl_core_Demo();
	if(!wl_core_Config.DEBUG) {
		$(".debug").css("display","none");
		$("#debug").find("input").attr("checked",null);
		$(".checkbox").css("display","none");
	}
	if(wl_util_LoadManager.get_totalCount() == 0) {
		Main.assetsLoaded = true;
	}
	wl_sounds_SoundWL.onSoundLoaded.connect(Main.onSoundLoaded);
	wl_sounds_SoundWL.init();
};
Main.onAssetsLoaded = function() {
	Main.assetsLoaded = true;
	Main.loadReady();
};
Main.onSoundLoaded = function() {
	Main.soundLoaded = true;
	DemoMain.onSoundReady();
	Main.loadReady();
};
Main.loadReady = function() {
	if(Main.assetsLoaded && Main.soundLoaded) {
		$("#setup").css("display","");
		wl_setup_Setup.init(Main.demo);
	}
};
Math.__name__ = ["Math"];
var Reflect = function() { };
$hxClasses["Reflect"] = Reflect;
Reflect.__name__ = ["Reflect"];
Reflect.field = function(o,field) {
	try {
		return o[field];
	} catch( e ) {
		return null;
	}
};
Reflect.fields = function(o) {
	var a = [];
	if(o != null) {
		var hasOwnProperty = Object.prototype.hasOwnProperty;
		for( var f in o ) {
		if(f != "__id__" && f != "hx__closures__" && hasOwnProperty.call(o,f)) {
			a.push(f);
		}
		}
	}
	return a;
};
var Std = function() { };
$hxClasses["Std"] = Std;
Std.__name__ = ["Std"];
Std.string = function(s) {
	return js_Boot.__string_rec(s,"");
};
var StringTools = function() { };
$hxClasses["StringTools"] = StringTools;
StringTools.__name__ = ["StringTools"];
StringTools.replace = function(s,sub,by) {
	return s.split(sub).join(by);
};
StringTools.hex = function(n,digits) {
	var s = "";
	while(true) {
		s = "0123456789ABCDEF".charAt(n & 15) + s;
		n >>>= 4;
		if(!(n > 0)) {
			break;
		}
	}
	if(digits != null) {
		while(s.length < digits) s = "0" + s;
	}
	return s;
};
var Type = function() { };
$hxClasses["Type"] = Type;
Type.__name__ = ["Type"];
Type.getClassName = function(c) {
	var a = c.__name__;
	if(a == null) {
		return null;
	}
	return a.join(".");
};
Type.resolveClass = function(name) {
	var cl = $hxClasses[name];
	if(cl == null || !cl.__name__) {
		return null;
	}
	return cl;
};
Type.createInstance = function(cl,args) {
	var _g = args.length;
	switch(_g) {
	case 0:
		return new cl();
	case 1:
		return new cl(args[0]);
	case 2:
		return new cl(args[0],args[1]);
	case 3:
		return new cl(args[0],args[1],args[2]);
	case 4:
		return new cl(args[0],args[1],args[2],args[3]);
	case 5:
		return new cl(args[0],args[1],args[2],args[3],args[4]);
	case 6:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5]);
	case 7:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6]);
	case 8:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7]);
	case 9:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8]);
	case 10:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9]);
	case 11:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9],args[10]);
	case 12:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9],args[10],args[11]);
	case 13:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9],args[10],args[11],args[12]);
	case 14:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9],args[10],args[11],args[12],args[13]);
	default:
		throw new js__$Boot_HaxeError("Too many arguments");
	}
};
var wl_core_Part = function() {
	this.postProcessing = { };
	this.effects = [];
	this.autoClear = true;
	this.clearColor = 0;
	this.generateDepthMap = true;
	this.renderToScreen = false;
	this.inTransition = false;
	this.running = false;
	this.isActive = false;
};
$hxClasses["wl.core.Part"] = wl_core_Part;
wl_core_Part.__name__ = ["wl","core","Part"];
wl_core_Part.prototype = {
	init: function() {
		this.triggers = new haxe_ds_ObjectMap();
		if(this.generateDepthMap) {
			this.depthMap = wl_core_Graphics.instance.getRenderTarget();
		}
		this.renderTo = wl_core_Graphics.instance.getRenderTarget(this.renderFormat);
		this.effects = [];
	}
	,postInit: function() {
	}
	,setupDatGui: function(folder) {
		if(this.camera != null) {
			var cam = folder.addFolder("camera");
			cam.add(this.camera,"fov").onChange(($_=this.camera,$bind($_,$_.updateProjectionMatrix)));
			cam.add(this.camera,"near").onChange(($_=this.camera,$bind($_,$_.updateProjectionMatrix)));
			cam.add(this.camera,"far").onChange(($_=this.camera,$bind($_,$_.updateProjectionMatrix)));
		}
	}
	,start: function(ts) {
		this.running = true;
	}
	,stop: function() {
		this.running = false;
	}
	,setRenderToScreen: function(value) {
		this.renderToScreen = value;
	}
	,update: function(ts,partial,frameTime,delta) {
	}
	,render: function(ts,frameTime) {
		var r = wl_core_Graphics.instance.renderer;
		if(this.generateDepthMap) {
			r.autoClear = true;
			r.setClearColor(0,1.0);
			this.scene.overrideMaterial = wl_core_Graphics.instance.depthMaterial;
			wl_core_Graphics.instance.renderer.render(this.scene,this.camera,this.depthMap);
			this.scene.overrideMaterial = null;
		}
		r.autoClear = this.autoClear;
		r.setClearColor(this.clearColor,1.0);
		if(this.composer != null) {
			this.composer.render();
		} else {
			wl_core_Graphics.instance.renderer.render(this.scene,this.camera,this.renderTo);
		}
	}
	,addTrigger: function(timesig,handler) {
		if(this.triggers.h.__keys__[timesig.__id__] != null) {
			this.triggers.h[timesig.__id__].push(handler);
		} else {
			this.triggers.set(timesig,[handler]);
		}
	}
	,removeTrigger: function(handler,timesig) {
		if(timesig != null && this.triggers.h.__keys__[timesig.__id__] != null) {
			HxOverrides.remove(this.triggers.h[timesig.__id__],handler);
		} else {
			var tmp = this.triggers.iterator();
			while(tmp.hasNext()) {
				var t = tmp.next();
				while(t.indexOf(handler) >= 0) HxOverrides.remove(t,handler);
			}
		}
	}
	,addEffect: function(effect) {
		this.effects.push(effect);
	}
	,initStandardScene: function(cinematic) {
		this.scene = new THREE.Scene();
		this.camera = new THREE.PerspectiveCamera(30,wl_core_Config.RESOLUTION[0] / wl_core_Config.RESOLUTION[1],0.1,1000);
		this.camera.position.y = 0;
		this.camera.position.x = 0;
		this.camera.position.z = 500;
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		this.scene.autoUpdate = true;
		this.scene.add(this.camera);
		wl_debug_ManualControl.attachPart(this);
	}
	,getComposerList: function(post) {
		var list = [];
		if(post.cga) {
			list.push(this.postProcessing.cga = new wl_post_cga_CGA());
		}
		if(post.dof) {
			list.push(this.postProcessing.dof = new wl_post_dof_DoF(this.depthMap.texture,this.camera));
		}
		if(post.bloom) {
			list.push(this.postProcessing.bloom = new wl_post_bloom_Bloom());
		}
		if(post.gray) {
			list.push(this.postProcessing.gray = new wl_post_gray_Gray(0));
		}
		if(post.rgbShift) {
			list.push(this.postProcessing.rgbShift = new wl_post_rgbshift_RGBShift());
		}
		if(post.colorHilight) {
			list.push(this.postProcessing.colorHilight = new wl_post_colorhilight_ColorHilight());
		}
		if(post.pixelate) {
			list.push(this.postProcessing.pixelate = new wl_post_pixelate_Pixelate());
		}
		if(post.distortedTV) {
			list.push(this.postProcessing.distortedTV = new wl_post_distortedTv_DistortedTv());
		}
		if(post.vhs) {
			list.push(this.postProcessing.vhs = new wl_post_vhs_VHS());
		}
		if(post.standard) {
			list.push(this.postProcessing.standard = new wl_post_standard_StandardShader());
		}
		if(post.displacement) {
			list.push(this.postProcessing.displacement = new wl_post_displacement_Displacement(wl_core_Assets.getTexture("perlin-512.png")));
		}
		if(post.aspect) {
			list.push(this.postProcessing.aspect = new wl_post_aspect_Aspect());
		}
		return list;
	}
	,initComposer: function(postprocessingList,preventCopy,preventRender) {
		if(postprocessingList == null) {
			postprocessingList = this.getComposerList({ });
		}
		var g = wl_core_Graphics.instance;
		this.composer = new THREE.EffectComposer(g.renderer,this.renderTo);
		if(!preventRender) {
			this.renderPass = new THREE.RenderPass(this.scene,this.camera,null,new THREE.Color(this.clearColor),1);
			this.composer.addPass(this.renderPass);
		}
		var _g = 0;
		while(_g < postprocessingList.length) {
			var pass = postprocessingList[_g];
			++_g;
			this.composer.addPass(pass);
		}
		if(!preventCopy) {
			this.copyPass = new THREE.ShaderPass(THREE.CopyShader);
			this.copyPass.renderToScreen = false;
			this.composer.addPass(this.copyPass);
		}
	}
	,__class__: wl_core_Part
};
var blank_Blank = function() {
	wl_core_Part.call(this);
};
$hxClasses["blank.Blank"] = blank_Blank;
blank_Blank.__name__ = ["blank","Blank"];
blank_Blank.__super__ = wl_core_Part;
blank_Blank.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer();
		this.scene.add(new THREE.Mesh(this.CreateGeometry(),new THREE.MeshPhongMaterial({ color : DemoMain.COLOR1.getHex()})));
	}
	,CreateGeometry: function() {
		var geo = new THREE.CylinderGeometry(1,1,4,12,1,false);
		var endgeo = new THREE.Geometry();
		var _g = 0;
		while(_g < 400) {
			var d = _g++;
			var _g1 = 0;
			while(_g1 < 400) {
				var w = _g1++;
				var m = new THREE.Mesh(geo);
				m.rotateX(wl_util_Random.nextFloat() * Math.PI * 2);
				m.rotateY(wl_util_Random.nextFloat() * Math.PI * 2);
				m.rotateZ(wl_util_Random.nextFloat() * Math.PI * 2);
				m.position.z = d;
				m.position.x = w;
				m.position.y = Math.sin(d * Math.PI / 4) * Math.cos(d * Math.PI / 4);
				endgeo.mergeMesh(m);
			}
		}
		return endgeo;
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime) {
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: blank_Blank
});
var cylball_BandBall = function() {
	THREE.Object3D.call(this);
	if(cylball_BandBall.geometry == null) {
		cylball_BandBall.geometry = new THREE.SphereBufferGeometry(1,40,40);
		this.canvas = this.generateTexture();
		var texture = new THREE.CanvasTexture(this.canvas);
		texture.magFilter = THREE.NearestFilter;
		texture.wrapT = THREE.RepeatWrapping;
		texture.wrapS = THREE.RepeatWrapping;
		texture.repeat.set(1,8);
		cylball_BandBall.material = new THREE.MeshBasicMaterial({ color : DemoMain.COLOR5.getHex(), side : THREE.DoubleSide, opacity : 0.6, transparent : true, alphaMap : texture, alphaTest : 0.5});
	}
	this.initializeControls();
};
$hxClasses["cylball.BandBall"] = cylball_BandBall;
cylball_BandBall.__name__ = ["cylball","BandBall"];
cylball_BandBall.__super__ = THREE.Object3D;
cylball_BandBall.prototype = $extend(THREE.Object3D.prototype,{
	generateTexture: function() {
		var canvas = window.document.createElement("canvas");
		canvas.width = 1024;
		canvas.height = 1024;
		var context = canvas.getContext("2d");
		context.fillStyle = "white";
		context.fillRect(0,0,1024,40);
		return canvas;
	}
	,initializeControls: function() {
		this.mesh = new THREE.Mesh(cylball_BandBall.geometry,cylball_BandBall.material);
		this.add(this.mesh);
	}
	,__class__: cylball_BandBall
});
var cylball_CylinderBall = function(openEnded,mp,ignoreLights) {
	this.ignoreLights = false;
	this.mp = 1;
	this.intensity = 0;
	this.phaseOffset = 0;
	THREE.Object3D.call(this);
	this.ignoreLights = ignoreLights;
	if(openEnded == null) {
		openEnded = false;
	} else {
		openEnded = openEnded;
	}
	if(mp == null) {
		mp = 1;
	}
	this.mp = mp;
	this.init(openEnded);
};
$hxClasses["cylball.CylinderBall"] = cylball_CylinderBall;
cylball_CylinderBall.__name__ = ["cylball","CylinderBall"];
cylball_CylinderBall.__super__ = THREE.Object3D;
cylball_CylinderBall.prototype = $extend(THREE.Object3D.prototype,{
	init: function(openEnded) {
		this.cylinders = [];
		var sg = new THREE.IcosahedronGeometry(14,3);
		this.add(new THREE.Mesh(sg,new THREE.MeshBasicMaterial({ color : DemoMain.WHITE.getHex(), transparent : true, opacity : 0.25})));
		var _g = 0;
		var _g1 = sg.vertices;
		while(_g < _g1.length) {
			var v = _g1[_g];
			++_g;
			var c = new cylinders_Cylinder(openEnded);
			c.position.x = v.x * this.mp;
			c.position.y = v.y * this.mp;
			c.position.z = v.z * this.mp;
			c.scale.y = 0.2;
			c.x = v.x;
			c.z = v.y;
			c.lookAt(new THREE.Vector3());
			c.rotateX(Math.PI / 2);
			this.add(c);
			this.cylinders.push(c);
		}
		if(!this.ignoreLights) {
			var l = new THREE.PointLight(16777215,0.5,100,10);
			l.castShadow = true;
			l.position.y = 30;
			l.position.z = 17;
			l.position.x = -17;
			this.add(l);
			var l2 = new THREE.PointLight(16777215,0.5,100,10);
			l2.castShadow = true;
			l2.position.y = 30;
			l2.position.x = 10;
			l2.position.z = 5;
			this.add(l2);
			this.cl = new cyllights_CylinderLight(0,false);
			this.add(this.cl);
			this.cl.position.y = 20;
		}
	}
	,onBar: function(ts) {
		var tmp = ts.bar % 4 == 0;
		createjs.Tween.get(this).to({ phaseOffset : this.phaseOffset + 1},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.quadOut);
		createjs.Tween.get(this).to({ intensity : 8},wl_core_TimeSig.milliseconds(0,1,0,0),createjs.Ease.quadOut).to({ intensity : 1},wl_core_TimeSig.milliseconds(0,1,0,0),createjs.Ease.quadInOut);
	}
	,onHalfBar: function(ts) {
		createjs.Tween.get(this).to({ intensity : 4},wl_core_TimeSig.milliseconds(0,1,0,0),createjs.Ease.quadOut).to({ intensity : 1},wl_core_TimeSig.milliseconds(0,1,0,0),createjs.Ease.quadInOut);
	}
	,update: function(ts,partial,frameTime,delta) {
		var t = ts.toMilliseconds() / 3000;
		if(this.cl != null) {
			this.cl.rotation.y = Math.sin(t);
			this.cl.rotation.x = Math.sin(t) * 4;
			this.cl.rotation.z = t;
		}
		var t1 = ts.toMilliseconds() / 1000;
		var _g = 0;
		var _g1 = this.cylinders;
		while(_g < _g1.length) {
			var c = _g1[_g];
			++_g;
			c.scale.y = Math.abs(Math.sin(this.phaseOffset + c.x / 3 + c.z / 4 + t1) + Math.cos(c.x / 2 - c.z / 3 - t1 * 2) * 0.35) * this.intensity * 0.1 + 0.5;
		}
	}
	,enableShadows: function() {
		var _g = 0;
		var _g1 = this.cylinders;
		while(_g < _g1.length) {
			var c = _g1[_g];
			++_g;
			c.castShadow = true;
		}
	}
	,__class__: cylball_CylinderBall
});
var cylinders_Cylinder = function(openEnded,overrideMat) {
	THREE.Object3D.call(this);
	if(openEnded == null) {
		openEnded = false;
	} else {
		openEnded = openEnded;
	}
	if(cylinders_Cylinder.geometry == null) {
		cylinders_Cylinder.geometry = new THREE.CylinderBufferGeometry(1,1,10,25,2,openEnded);
		cylinders_Cylinder.materials = [new THREE.MeshPhongMaterial({ color : DemoMain.COLOR1.getHex(), side : THREE.DoubleSide}),new THREE.MeshPhongMaterial({ color : DemoMain.COLOR2.getHex(), side : THREE.DoubleSide}),new THREE.MeshPhongMaterial({ color : DemoMain.COLOR3.getHex(), side : THREE.DoubleSide}),new THREE.MeshPhongMaterial({ color : DemoMain.COLOR4.getHex(), side : THREE.DoubleSide}),new THREE.MeshPhongMaterial({ color : DemoMain.COLOR5.getHex(), side : THREE.DoubleSide})];
	}
	this.material = overrideMat;
	this.initializeControls();
};
$hxClasses["cylinders.Cylinder"] = cylinders_Cylinder;
cylinders_Cylinder.__name__ = ["cylinders","Cylinder"];
cylinders_Cylinder.__super__ = THREE.Object3D;
cylinders_Cylinder.prototype = $extend(THREE.Object3D.prototype,{
	initializeControls: function() {
		if(this.material == null) {
			this.material = cylinders_Cylinder.materials[wl_util_Random.next() % cylinders_Cylinder.materials.length];
		}
		this.mesh = new THREE.Mesh(cylinders_Cylinder.geometry,this.material);
		this.mesh.receiveShadow = true;
		this.add(this.mesh);
	}
	,__class__: cylinders_Cylinder
});
var cylinders_Cylinders = function() {
	this.launchPosition = 0;
	this.prevSwap = 0;
	this.ccind = -1;
	this.intensity = 0;
	this.phaseOffset = 0;
	wl_core_Part.call(this);
};
$hxClasses["cylinders.Cylinders"] = cylinders_Cylinders;
cylinders_Cylinders.__name__ = ["cylinders","Cylinders"];
cylinders_Cylinders.__super__ = wl_core_Part;
cylinders_Cylinders.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var ep = { };
		ep.bloom = true;
		ep.standard = true;
		ep.cga = false;
		ep.vhs = false;
		ep.dof = false;
		ep.distortedTV = true;
		ep.displacement = false;
		this.clearColor = 0;
		this.initComposer(this.getComposerList(ep));
		this.postProcessing.bloom.strength = 1;
		this.postProcessing.bloom.threshold = 0.0;
		this.postProcessing.bloom.radius = 0.05;
		this.cylinders = [];
		var _g1 = 0;
		var _g = cylinders_Cylinders.HEIGHT;
		while(_g1 < _g) {
			var i = _g1++;
			var _g3 = 0;
			var _g2 = cylinders_Cylinders.WIDTH;
			while(_g3 < _g2) {
				var j = _g3++;
				var c = new cylinders_Cylinder();
				c.position.x = j * 2 - cylinders_Cylinders.HEIGHT;
				c.position.z = i * 2 - cylinders_Cylinders.WIDTH;
				c.x = j;
				c.z = i;
				c.position.y = Math.sin(j / 3 + i / 4) + Math.cos(j / 2 - i / 3) * 0.3;
				this.scene.add(c);
				this.cylinders.push(c);
			}
		}
		this.ball = new cylball_CylinderBall(false,1,true);
		this.scene.add(this.ball);
		this.ball.scale.set(0.4,0.4,0.4);
		this.ball.position.y = 20;
		this.ball.position.x = 0;
		var l = new THREE.PointLight(16777215,0.5,200,10);
		l.castShadow = false;
		l.position.y = 40;
		l.position.z = 17;
		l.position.x = -27;
		this.ball.add(l);
		var l2 = new THREE.PointLight(16777215,0.5,200,10);
		l2.castShadow = false;
		l2.position.y = 30;
		l2.position.x = 10;
		l2.position.z = 15;
		this.ball.add(l2);
		this.bandball = new cylball_BandBall();
		this.scene.add(this.bandball);
		this.bandball.scale.set(100,100,100);
		this.bandball2 = new cylball_BandBall();
		this.scene.add(this.bandball2);
		this.bandball2.scale.set(90,90,90);
		this.cl = new cyllights_CylinderLight(0,false);
		this.ball.add(this.cl);
		this.cl.position.y = 50;
		this.launchorbs = [];
		var orbGeo = new THREE.SphereGeometry(2);
		var orbMat = new THREE.MeshBasicMaterial({ color : 16777215});
		var _g4 = 0;
		while(_g4 < 12) {
			var i1 = _g4++;
			var _g11 = 0;
			while(_g11 < 4) {
				++_g11;
				var m = new THREE.Mesh(orbGeo,orbMat);
				m.position.x = -80 + i1 * 5;
				m.position.z = wl_util_Random.range(-40,40);
				m.position.y = -5;
				this.launchorbs.push(m);
				this.scene.add(m);
			}
		}
		this.rndcc = new wl_demo_RandomCameraController(this.camera,5,[this.ball],2271,[wl_demo_CameraController.BEZIER],[4,15],new THREE.Box3(new THREE.Vector3(-40,30,-40),new THREE.Vector3(40,80,40)));
		this.ccs = [new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera)];
		var tmp = [new THREE.Vector3(0,35,-30),new THREE.Vector3(7,36,-39),new THREE.Vector3(12,37,-42)];
		var tmp1 = new THREE.Vector3(0,19,0);
		var tmp2 = new THREE.Vector3(0,19,0);
		this.ccs[0].initBezier(tmp,[tmp1,tmp2,new THREE.Vector3(0,19,0)]);
		var tmp3 = [new THREE.Vector3(0,30,0),new THREE.Vector3(0,29.5,0),new THREE.Vector3(0,29,0)];
		var tmp4 = new THREE.Vector3(0,0,0);
		var tmp5 = new THREE.Vector3(1,0,0);
		this.ccs[1].initBezier(tmp3,[tmp4,tmp5,new THREE.Vector3(2,0,0)]);
		var tmp6 = [new THREE.Vector3(39,14,-2),new THREE.Vector3(39,14,-2),new THREE.Vector3(39,28,-2)];
		var tmp7 = new THREE.Vector3(0,17,0);
		var tmp8 = new THREE.Vector3(0,17,0);
		this.ccs[2].initBezier(tmp6,[tmp7,tmp8,new THREE.Vector3(0,30,0)]);
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.onBar));
		this.addTrigger(new wl_core_TimeSig(-1,2,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.onHalfBar));
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),($_=this.ball,$bind($_,$_.onBar)));
		this.addTrigger(new wl_core_TimeSig(-1,2,0,0,wl_core_TimeSig.PATTERN),($_=this.ball,$bind($_,$_.onHalfBar)));
		this.addTrigger(new wl_core_TimeSig(8,0,0,0,wl_core_TimeSig.RELATIVE),function(ts) {
			_gthis.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),$bind(_gthis,_gthis.launchOrb));
			_gthis.addTrigger(new wl_core_TimeSig(-1,1,0,0,wl_core_TimeSig.PATTERN),$bind(_gthis,_gthis.launchOrb));
			_gthis.addTrigger(new wl_core_TimeSig(-1,2,0,0,wl_core_TimeSig.PATTERN),$bind(_gthis,_gthis.launchOrb));
			_gthis.addTrigger(new wl_core_TimeSig(-1,3,0,0,wl_core_TimeSig.PATTERN),$bind(_gthis,_gthis.launchOrb));
		});
		this.postProcessing.standard.set_brightness(-1);
		this.soundAnalyzer = new wl_sounds_SoundAnalyzer();
		this.soundAnalyzer.historySize = 5;
		this.soundAnalyzer.filters.push({ lowLimit : 100, highLimit : 200, isolate : true});
		this.addTrigger(new wl_core_TimeSig(19,0,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.fadeout));
	}
	,fadeout: function(ts) {
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : -1},wl_core_TimeSig.milliseconds(1,0,0,0),createjs.Ease.quadIn);
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		this.prevSwap = ts.toMilliseconds();
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : 0},wl_core_TimeSig.milliseconds(0,2,0,0));
	}
	,launchOrb: function(ts) {
		if(this.launchPosition > this.launchorbs.length - 1) {
			return;
		}
		createjs.Tween.get(this.launchorbs[this.launchPosition++].position).to({ y : 100},wl_core_TimeSig.milliseconds(2,0,0,0) * (wl_util_Random.nextFloat() + 0.5),createjs.Ease.quadIn);
		createjs.Tween.get(this.launchorbs[this.launchPosition++].position).wait(wl_util_Random.range(100,2000)).to({ y : 100},wl_core_TimeSig.milliseconds(2,0,0,0) * (wl_util_Random.nextFloat() + 0.5),createjs.Ease.quadIn);
		createjs.Tween.get(this.launchorbs[this.launchPosition++].position).wait(wl_util_Random.range(100,2000)).to({ y : 100},wl_core_TimeSig.milliseconds(2,0,0,0) * (wl_util_Random.nextFloat() + 0.5),createjs.Ease.quadIn);
		createjs.Tween.get(this.launchorbs[this.launchPosition++].position).wait(wl_util_Random.range(100,2000)).to({ y : 100},wl_core_TimeSig.milliseconds(2,0,0,0) * (wl_util_Random.nextFloat() + 0.5),createjs.Ease.quadIn);
	}
	,onBar: function(ts) {
		if(ts.bar % 4 == 0) {
			this.prevSwap = ts.toMilliseconds();
			this.ccind++;
			this.ccind = this.ccind % this.ccs.length;
			this.camera.fov = this.ccind == 1?76:30;
			this.camera.updateProjectionMatrix();
			this.ccs[this.ccind].update(0);
		}
		createjs.Tween.get(this).to({ phaseOffset : this.phaseOffset + 1},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.quadOut);
		createjs.Tween.get(this).to({ intensity : 8},wl_core_TimeSig.milliseconds(0,1,0,0),createjs.Ease.quadOut).to({ intensity : 1},wl_core_TimeSig.milliseconds(0,1,0,0),createjs.Ease.quadInOut);
	}
	,onHalfBar: function(ts) {
		createjs.Tween.get(this).to({ intensity : 4},wl_core_TimeSig.milliseconds(0,1,0,0),createjs.Ease.quadOut).to({ intensity : 1},wl_core_TimeSig.milliseconds(0,1,0,0),createjs.Ease.quadInOut);
	}
	,setupDatGui: function(folder) {
		wl_core_Part.prototype.setupDatGui.call(this,folder);
	}
	,update: function(ts,partial,frameTime,delta) {
		var t = ts.toMilliseconds() / 3000;
		this.cl.rotation.y = Math.sin(t);
		this.cl.rotation.x = Math.sin(t) * 4;
		this.cl.rotation.z = t;
		this.ccs[Math.max(0,this.ccind)].update((ts.toMilliseconds() - this.prevSwap) / wl_core_TimeSig.milliseconds(4,0,0,0));
		var t1 = ts.toMilliseconds() / 1000;
		var _g = 0;
		var _g1 = this.cylinders;
		while(_g < _g1.length) {
			var c = _g1[_g];
			++_g;
			c.position.y = (Math.sin(this.phaseOffset + c.x / 3 + c.z / 4 + t1) + Math.cos(c.x / 2 - c.z / 3 - t1 * 2) * 0.35) * this.intensity;
			c.position.x = (c.x + t1) % 40 * 2 - cylinders_Cylinders.HEIGHT;
			c.position.z = (c.z + t1 * 2.5) % 40 * 2 - cylinders_Cylinders.HEIGHT;
		}
		this.ball.update(ts,partial,frameTime,delta);
		this.bandball.rotation.y = ts.toMilliseconds() / 21500;
		this.bandball.rotation.z = ts.toMilliseconds() / 17500;
		this.bandball.rotation.x = ts.toMilliseconds() / 18000;
		this.bandball.rotation.y = ts.toMilliseconds() / 50000;
		this.bandball.rotation.z = ts.toMilliseconds() / 33500;
		this.bandball.rotation.x = ts.toMilliseconds() / 24000;
		this.soundAnalyzer.update();
		if(this.soundAnalyzer.filters[0].triggered && this.soundAnalyzer.filters[0].min > 0.8) {
			this.postProcessing.distortedTV.set_offsetAmount(this.soundAnalyzer.filters[0].max * 0.3);
		} else {
			this.postProcessing.distortedTV.set_offsetAmount(0);
		}
		this.postProcessing.distortedTV.set_vignAmount(-this.soundAnalyzer.filters[0].max);
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime) {
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: cylinders_Cylinders
});
var cyllight_CylLight = function() {
	THREE.Object3D.call(this);
	this.init();
};
$hxClasses["cyllight.CylLight"] = cyllight_CylLight;
cyllight_CylLight.__name__ = ["cyllight","CylLight"];
cyllight_CylLight.__super__ = THREE.Object3D;
cyllight_CylLight.prototype = $extend(THREE.Object3D.prototype,{
	init: function() {
		this.post = new cylinders_Cylinder();
		this.post.position.y = 5;
		this.core = this.createLayer(this.post);
		this.core.container.position.y = 12.6;
		this.add(this.post);
		this.add(this.core.container);
	}
	,createLayer: function(post) {
		var cl = { container : new THREE.Object3D(), c1 : new cylinders_Cylinder(null,post.material), c2 : new cylinders_Cylinder(null,post.material), c3 : new cylinders_Cylinder(null,post.material), c4 : new cylinders_Cylinder(null,post.material), c5 : new cylinders_Cylinder(null,post.material), c6 : new cylinders_Cylinder(null,post.material), c7 : new cylinders_Cylinder(null,post.material), core : new cylinders_Cylinder(null,cylinders_Cylinder.WHITEMAT), top : new cylinders_Cylinder(null,post.material), bottom : new cylinders_Cylinder(null,post.material), items : []};
		cl.items = [cl.c1,cl.c2,cl.c3,cl.c4,cl.c5,cl.c6,cl.c7,cl.core,cl.bottom,cl.top];
		var _g = 0;
		var _g1 = cl.items;
		while(_g < _g1.length) {
			var c = _g1[_g];
			++_g;
			cl.container.add(c);
			cl.core.receiveShadow = true;
		}
		var posts = [cl.c1,cl.c2,cl.c3,cl.c4,cl.c5,cl.c6,cl.c7];
		var c1 = 0;
		var _g2 = 0;
		while(_g2 < posts.length) {
			var p = posts[_g2];
			++_g2;
			p.scale.x = p.scale.z = 0.15;
			p.scale.y = 0.5;
			p.position.x = Math.cos(c1 / posts.length * Math.PI * 2) * 1.25;
			p.position.z = Math.sin(c1 / posts.length * Math.PI * 2) * 1.25;
			++c1;
		}
		cl.core.scale.x = cl.core.scale.z = 0.5;
		cl.core.scale.y = 0.5;
		cl.top.scale.y = 0.01;
		cl.bottom.scale.y = 0.01;
		cl.bottom.scale.x = cl.bottom.scale.z = 1.5;
		cl.top.scale.x = cl.top.scale.z = 1.5;
		cl.top.position.y = 2.55;
		cl.bottom.position.y = -2.55;
		return cl;
	}
	,__class__: cyllight_CylLight
});
var cyllight_CylLightTester = function() {
	wl_core_Part.call(this);
};
$hxClasses["cyllight.CylLightTester"] = cyllight_CylLightTester;
cyllight_CylLightTester.__name__ = ["cyllight","CylLightTester"];
cyllight_CylLightTester.__super__ = wl_core_Part;
cyllight_CylLightTester.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var ep = { };
		ep.bloom = true;
		ep.cga = false;
		ep.vhs = false;
		ep.dof = false;
		ep.distortedTV = true;
		ep.displacement = false;
		this.initComposer(this.getComposerList(ep));
		this.postProcessing.bloom.strength = 1;
		this.postProcessing.bloom.threshold = 0.0;
		this.postProcessing.bloom.radius = 0.05;
		this.scene.add(new THREE.AmbientLight(5263440));
		this.cl = new cyllights_CylinderLight(0,false);
		this.scene.add(this.cl);
		this.camera.position.set(0,0,-10);
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		var _g = 0;
		while(_g < 50) {
			++_g;
			this.pillar = new cyllight_CylLight();
			this.scene.add(this.pillar);
			this.pillar.position.x = Math.random() * 100;
			this.pillar.position.z = Math.random() * 100;
		}
	}
	,setupDatGui: function(folder) {
		wl_core_Part.prototype.setupDatGui.call(this,folder);
	}
	,update: function(ts,partial,frameTime,delta) {
		this.cl.rotation.x = ts.toMilliseconds() / 3000;
		this.cl.rotation.z = ts.toMilliseconds() / 4500;
		this.cl.rotation.y = ts.toMilliseconds() / 5000;
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime) {
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: cyllight_CylLightTester
});
var cyllights_CylinderLight = function(lc,ignoremd) {
	this.ignoremd = false;
	THREE.Object3D.call(this);
	this.lc = lc;
	if(cyllights_CylinderLight.geometry == null) {
		cyllights_CylinderLight.geometry = new THREE.CylinderBufferGeometry(1,1,4,25,2,true);
		this.canvas = this.generateTexture();
		var texture = new THREE.CanvasTexture(this.canvas);
		texture.magFilter = THREE.NearestFilter;
		texture.wrapT = THREE.RepeatWrapping;
		texture.wrapS = THREE.RepeatWrapping;
		texture.repeat.set(1,12);
		cyllights_CylinderLight.materials = [new THREE.MeshPhongMaterial({ color : DemoMain.COLOR5.getHex(), side : THREE.DoubleSide, opacity : 0, transparent : true, alphaMap : texture, alphaTest : 0.5})];
		var m = cyllights_CylinderLight.materials[0];
		m.alphaMap.repeat.set(1,2);
		cyllights_CylinderLight.md = new THREE.MeshDistanceMaterial( {alphaMap: m.alphaMap,alphaTest: 0.5} );
	}
	this.ignoremd = false;
	this.initializeControls();
};
$hxClasses["cyllights.CylinderLight"] = cyllights_CylinderLight;
cyllights_CylinderLight.__name__ = ["cyllights","CylinderLight"];
cyllights_CylinderLight.__super__ = THREE.Object3D;
cyllights_CylinderLight.prototype = $extend(THREE.Object3D.prototype,{
	generateTexture: function() {
		var canvas = window.document.createElement("canvas");
		canvas.width = 4;
		canvas.height = 4;
		var context = canvas.getContext("2d");
		context.fillStyle = "white";
		context.fillRect(0,2,4,1);
		return canvas;
	}
	,initializeControls: function() {
		this.mesh = new THREE.Mesh(cyllights_CylinderLight.geometry,cyllights_CylinderLight.materials[wl_util_Random.next() % cyllights_CylinderLight.materials.length]);
		this.mesh.castShadow = true;
		this.mesh.receiveShadow = true;
		if(!this.ignoremd) {
			this.mesh.customDistanceMaterial = cyllights_CylinderLight.md;
		}
		this.light = new THREE.PointLight(this.lc,4,50,5);
		this.light.shadow.camera.near = 0.1;
		this.light.shadow.camera.far = 60;
		this.light.shadow.bias = -0.005;
		this.light.castShadow = true;
		this.light.shadowMapWidth = 1024;
		this.light.shadowMapHeight = 1024;
		this.add(this.light);
		this.add(this.mesh);
	}
	,__class__: cyllights_CylinderLight
});
var cyllights_CylinderLight2 = function(lc,ignoremd) {
	this.ignoremd = false;
	THREE.Object3D.call(this);
	this.lc = lc;
	if(cyllights_CylinderLight2.geometry == null) {
		cyllights_CylinderLight2.geometry = new THREE.CylinderBufferGeometry(1,1,4,25,2,true);
		this.canvas = this.generateTexture();
		var texture = new THREE.CanvasTexture(this.canvas);
		texture.magFilter = THREE.NearestFilter;
		texture.wrapT = THREE.RepeatWrapping;
		texture.wrapS = THREE.RepeatWrapping;
		texture.repeat.set(1,12);
		cyllights_CylinderLight2.materials = [new THREE.MeshPhongMaterial({ color : DemoMain.COLOR5.getHex(), side : THREE.DoubleSide, opacity : 0, transparent : true, alphaMap : texture, alphaTest : 0.5})];
		var m = cyllights_CylinderLight2.materials[0];
		m.alphaMap.repeat.set(1,2);
		cyllights_CylinderLight2.md = new THREE.MeshDistanceMaterial( {alphaMap: m.alphaMap,alphaTest: 0.5} );
	}
	this.ignoremd = false;
	this.initializeControls();
};
$hxClasses["cyllights.CylinderLight2"] = cyllights_CylinderLight2;
cyllights_CylinderLight2.__name__ = ["cyllights","CylinderLight2"];
cyllights_CylinderLight2.__super__ = THREE.Object3D;
cyllights_CylinderLight2.prototype = $extend(THREE.Object3D.prototype,{
	generateTexture: function() {
		var canvas = window.document.createElement("canvas");
		canvas.width = 4;
		canvas.height = 4;
		var context = canvas.getContext("2d");
		context.fillStyle = "white";
		return canvas;
	}
	,initializeControls: function() {
		this.mesh = new THREE.Mesh(cyllights_CylinderLight2.geometry,cyllights_CylinderLight2.materials[wl_util_Random.next() % cyllights_CylinderLight2.materials.length]);
		this.mesh.castShadow = true;
		this.mesh.receiveShadow = true;
		if(!this.ignoremd) {
			this.mesh.customDistanceMaterial = cyllights_CylinderLight2.md;
		}
		this.light = new THREE.PointLight(this.lc,1,35,10);
		this.light.shadow.camera.near = 0.1;
		this.light.shadow.camera.far = 60;
		this.light.shadow.bias = -0.005;
		this.light.castShadow = true;
		this.light.shadowMapWidth = 1024;
		this.light.shadowMapHeight = 1024;
		this.add(this.light);
		this.add(this.mesh);
	}
	,__class__: cyllights_CylinderLight2
});
var cyllights_CylinderLights = function() {
	wl_core_Part.call(this);
};
$hxClasses["cyllights.CylinderLights"] = cyllights_CylinderLights;
cyllights_CylinderLights.__name__ = ["cyllights","CylinderLights"];
cyllights_CylinderLights.__super__ = wl_core_Part;
cyllights_CylinderLights.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var ep = { };
		ep.bloom = true;
		ep.cga = false;
		ep.vhs = false;
		ep.standard = true;
		this.camera.fov = 35;
		this.camera.updateProjectionMatrix();
		this.initComposer(this.getComposerList(ep));
		this.postProcessing.bloom.strength = 1;
		this.postProcessing.bloom.threshold = 0.0;
		this.postProcessing.bloom.radius = 0.05;
		this.cylinders = [];
		this.paths = [];
		var sp = new THREE.SphereBufferGeometry(0.08,20,20);
		var cols = [DemoMain.COLOR3.getHex(),DemoMain.COLOR4.getHex(),DemoMain.COLOR5.getHex()];
		var poss = null;
		var _g = 0;
		while(_g < 3) {
			var c = new cyllights_CylinderLight2(cols[_g++ % cols.length],true);
			c.position.x = (Math.random() - 0.5) * 20;
			c.position.z = (Math.random() - 0.5) * 20;
			c.position.y = (Math.random() - 0.5) * 20;
			this.scene.add(c);
			this.cylinders.push(c);
			c.add(new THREE.Mesh(sp,cylinders_Cylinder.WHITEMAT));
			var path = new wl_demo_CameraController(c);
			var pos = [new THREE.Vector3(20,4.5,20),new THREE.Vector3(25,5.7,28),new THREE.Vector3(26,5.7,29),new THREE.Vector3(20,6.8,25),new THREE.Vector3(21,5.8,20),new THREE.Vector3(25,5.9,25)];
			var _g1 = 0;
			while(_g1 < pos.length) {
				var p = pos[_g1];
				++_g1;
				p.x += (wl_util_Random.nextFloat() - 0.5) * 9;
				p.y += wl_util_Random.nextFloat();
				p.z += (wl_util_Random.nextFloat() - 0.5) * 9;
			}
			poss = pos;
			path.initBezier(pos,pos.slice(0));
			this.paths.push(path);
		}
		this.camera.position.z = -8;
		this.camera.position.y = 10;
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		console.log(this.scene.children.length);
		this.cc = new wl_demo_CameraController(this.camera);
		poss = poss.slice(0);
		var _g11 = 0;
		var _g2 = poss.length;
		while(_g11 < _g2) {
			var i = _g11++;
			poss[i] = new THREE.Vector3(poss[i].x + Math.random() - 0.5,poss[i].y + Math.random() - 0.5,poss[i].z + Math.random() - 0.5);
		}
		this.cc.initBezier([new THREE.Vector3(10,14.5,20),new THREE.Vector3(15,15.7,28),new THREE.Vector3(16,14.7,29),new THREE.Vector3(10,13.8,25),new THREE.Vector3(11,12.8,20),new THREE.Vector3(15,11.9,18)],poss);
		this.scene.add(new mountains_Mountains());
		this.postProcessing.standard.set_brightness(-1);
	}
	,setupDatGui: function(folder) {
		wl_core_Part.prototype.setupDatGui.call(this,folder);
	}
	,start: function(ts) {
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : 0},wl_core_TimeSig.milliseconds(1,0,0,0),createjs.Ease.quadIn);
		wl_core_Part.prototype.start.call(this,ts);
	}
	,update: function(ts,partial,frameTime,delta) {
		var t = ts.toMilliseconds() / 4000;
		var _g1 = 0;
		var _g = this.cylinders.length;
		while(_g1 < _g) {
			var i = _g1++;
			var c = this.cylinders[i];
			c.rotation.x = t + i;
			c.rotation.y = t * 1.3 + i * 3;
			c.rotation.z = t * 0.7 + i;
			c.position.x = Math.sin(t + i) * 15;
			c.position.y = Math.sin(t / 2 + i) * 15;
			c.position.z = Math.sin(t * 0.33 + i / 2) * 15;
			this.paths[i].update(partial);
		}
		this.cc.update(partial);
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime) {
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: cyllights_CylinderLights
});
var haxe_IMap = function() { };
$hxClasses["haxe.IMap"] = haxe_IMap;
haxe_IMap.__name__ = ["haxe","IMap"];
var haxe_Resource = function() { };
$hxClasses["haxe.Resource"] = haxe_Resource;
haxe_Resource.__name__ = ["haxe","Resource"];
haxe_Resource.getString = function(name) {
	var _g = 0;
	var _g1 = haxe_Resource.content;
	while(_g < _g1.length) {
		var x = _g1[_g];
		++_g;
		if(x.name == name) {
			if(x.str != null) {
				return x.str;
			}
			return haxe_crypto_Base64.decode(x.data).toString();
		}
	}
	return null;
};
var haxe_Timer = function(time_ms) {
	var me = this;
	this.id = setInterval(function() {
		me.run();
	},time_ms);
};
$hxClasses["haxe.Timer"] = haxe_Timer;
haxe_Timer.__name__ = ["haxe","Timer"];
haxe_Timer.delay = function(f,time_ms) {
	var t = new haxe_Timer(time_ms);
	t.run = function() {
		t.stop();
		f();
	};
	return t;
};
haxe_Timer.prototype = {
	stop: function() {
		if(this.id == null) {
			return;
		}
		clearInterval(this.id);
		this.id = null;
	}
	,run: function() {
	}
	,__class__: haxe_Timer
};
var haxe_io_Bytes = function(data) {
	this.length = data.byteLength;
	this.b = new Uint8Array(data);
	this.b.bufferValue = data;
	data.hxBytes = this;
	data.bytes = this.b;
};
$hxClasses["haxe.io.Bytes"] = haxe_io_Bytes;
haxe_io_Bytes.__name__ = ["haxe","io","Bytes"];
haxe_io_Bytes.ofString = function(s) {
	var a = [];
	var i = 0;
	while(i < s.length) {
		var c = s.charCodeAt(i++);
		if(55296 <= c && c <= 56319) {
			c = c - 55232 << 10 | s.charCodeAt(i++) & 1023;
		}
		if(c <= 127) {
			a.push(c);
		} else if(c <= 2047) {
			a.push(192 | c >> 6);
			a.push(128 | c & 63);
		} else if(c <= 65535) {
			a.push(224 | c >> 12);
			a.push(128 | c >> 6 & 63);
			a.push(128 | c & 63);
		} else {
			a.push(240 | c >> 18);
			a.push(128 | c >> 12 & 63);
			a.push(128 | c >> 6 & 63);
			a.push(128 | c & 63);
		}
	}
	return new haxe_io_Bytes(new Uint8Array(a).buffer);
};
haxe_io_Bytes.prototype = {
	getString: function(pos,len) {
		if(pos < 0 || len < 0 || pos + len > this.length) {
			throw new js__$Boot_HaxeError(haxe_io_Error.OutsideBounds);
		}
		var s = "";
		var b = this.b;
		var fcc = String.fromCharCode;
		var i = pos;
		var max = pos + len;
		while(i < max) {
			var c = b[i++];
			if(c < 128) {
				if(c == 0) {
					break;
				}
				s += fcc(c);
			} else if(c < 224) {
				s += fcc((c & 63) << 6 | b[i++] & 127);
			} else if(c < 240) {
				s += fcc((c & 31) << 12 | (b[i++] & 127) << 6 | b[i++] & 127);
			} else {
				var u = (c & 15) << 18 | (b[i++] & 127) << 12 | (b[i++] & 127) << 6 | b[i++] & 127;
				s += fcc((u >> 10) + 55232);
				s += fcc(u & 1023 | 56320);
			}
		}
		return s;
	}
	,toString: function() {
		return this.getString(0,this.length);
	}
	,__class__: haxe_io_Bytes
};
var haxe_crypto_Base64 = function() { };
$hxClasses["haxe.crypto.Base64"] = haxe_crypto_Base64;
haxe_crypto_Base64.__name__ = ["haxe","crypto","Base64"];
haxe_crypto_Base64.decode = function(str,complement) {
	if(complement == null) {
		complement = true;
	}
	if(complement) {
		while(HxOverrides.cca(str,str.length - 1) == 61) str = HxOverrides.substr(str,0,-1);
	}
	return new haxe_crypto_BaseCode(haxe_crypto_Base64.BYTES).decodeBytes(haxe_io_Bytes.ofString(str));
};
var haxe_crypto_BaseCode = function(base) {
	var len = base.length;
	var nbits = 1;
	while(len > 1 << nbits) ++nbits;
	if(nbits > 8 || len != 1 << nbits) {
		throw new js__$Boot_HaxeError("BaseCode : base length must be a power of two.");
	}
	this.base = base;
	this.nbits = nbits;
};
$hxClasses["haxe.crypto.BaseCode"] = haxe_crypto_BaseCode;
haxe_crypto_BaseCode.__name__ = ["haxe","crypto","BaseCode"];
haxe_crypto_BaseCode.prototype = {
	initTable: function() {
		var tbl = [];
		var _g = 0;
		while(_g < 256) tbl[_g++] = -1;
		var _g1 = 0;
		var _g2 = this.base.length;
		while(_g1 < _g2) {
			var i = _g1++;
			tbl[this.base.b[i]] = i;
		}
		this.tbl = tbl;
	}
	,decodeBytes: function(b) {
		var nbits = this.nbits;
		if(this.tbl == null) {
			this.initTable();
		}
		var tbl = this.tbl;
		var size = b.length * nbits >> 3;
		var out = new haxe_io_Bytes(new ArrayBuffer(size));
		var buf = 0;
		var curbits = 0;
		var pin = 0;
		var pout = 0;
		while(pout < size) {
			while(curbits < 8) {
				curbits += nbits;
				buf <<= nbits;
				var i = tbl[b.b[pin++]];
				if(i == -1) {
					throw new js__$Boot_HaxeError("BaseCode : invalid encoded char");
				}
				buf |= i;
			}
			curbits -= 8;
			out.b[pout++] = buf >> curbits & 255 & 255;
		}
		return out;
	}
	,__class__: haxe_crypto_BaseCode
};
var haxe_ds_ObjectMap = function() {
	this.h = { __keys__ : { }};
};
$hxClasses["haxe.ds.ObjectMap"] = haxe_ds_ObjectMap;
haxe_ds_ObjectMap.__name__ = ["haxe","ds","ObjectMap"];
haxe_ds_ObjectMap.__interfaces__ = [haxe_IMap];
haxe_ds_ObjectMap.prototype = {
	set: function(key,value) {
		var id = key.__id__ || (key.__id__ = ++haxe_ds_ObjectMap.count);
		this.h[id] = value;
		this.h.__keys__[id] = key;
	}
	,keys: function() {
		var a = [];
		for( var key in this.h.__keys__ ) {
		if(this.h.hasOwnProperty(key)) {
			a.push(this.h.__keys__[key]);
		}
		}
		return HxOverrides.iter(a);
	}
	,iterator: function() {
		return { ref : this.h, it : this.keys(), hasNext : function() {
			return this.it.hasNext();
		}, next : function() {
			var i = this.it.next();
			return this.ref[i.__id__];
		}};
	}
	,__class__: haxe_ds_ObjectMap
};
var haxe_ds_StringMap = function() {
	this.h = { };
};
$hxClasses["haxe.ds.StringMap"] = haxe_ds_StringMap;
haxe_ds_StringMap.__name__ = ["haxe","ds","StringMap"];
haxe_ds_StringMap.__interfaces__ = [haxe_IMap];
haxe_ds_StringMap.prototype = {
	setReserved: function(key,value) {
		if(this.rh == null) {
			this.rh = { };
		}
		this.rh["$" + key] = value;
	}
	,getReserved: function(key) {
		if(this.rh == null) {
			return null;
		} else {
			return this.rh["$" + key];
		}
	}
	,existsReserved: function(key) {
		if(this.rh == null) {
			return false;
		}
		return this.rh.hasOwnProperty("$" + key);
	}
	,__class__: haxe_ds_StringMap
};
var haxe_io_Error = { __ename__ : true, __constructs__ : ["Blocked","Overflow","OutsideBounds","Custom"] };
haxe_io_Error.Blocked = ["Blocked",0];
haxe_io_Error.Blocked.toString = $estr;
haxe_io_Error.Blocked.__enum__ = haxe_io_Error;
haxe_io_Error.Overflow = ["Overflow",1];
haxe_io_Error.Overflow.toString = $estr;
haxe_io_Error.Overflow.__enum__ = haxe_io_Error;
haxe_io_Error.OutsideBounds = ["OutsideBounds",2];
haxe_io_Error.OutsideBounds.toString = $estr;
haxe_io_Error.OutsideBounds.__enum__ = haxe_io_Error;
haxe_io_Error.Custom = function(e) { var $x = ["Custom",3,e]; $x.__enum__ = haxe_io_Error; $x.toString = $estr; return $x; };
var haxe_io_FPHelper = function() { };
$hxClasses["haxe.io.FPHelper"] = haxe_io_FPHelper;
haxe_io_FPHelper.__name__ = ["haxe","io","FPHelper"];
haxe_io_FPHelper.i32ToFloat = function(i) {
	var sign = 1 - (i >>> 31 << 1);
	var exp = i >>> 23 & 255;
	var sig = i & 8388607;
	if(sig == 0 && exp == 0) {
		return 0.0;
	}
	return sign * (1 + Math.pow(2,-23) * sig) * Math.pow(2,exp - 127);
};
haxe_io_FPHelper.floatToI32 = function(f) {
	if(f == 0) {
		return 0;
	}
	var af = f < 0?-f:f;
	var exp = Math.floor(Math.log(af) / 0.6931471805599453);
	if(exp < -127) {
		exp = -127;
	} else if(exp > 128) {
		exp = 128;
	}
	return (f < 0?-2147483648:0) | exp + 127 << 23 | Math.round((af / Math.pow(2,exp) - 1) * 8388608) & 8388607;
};
var intro_Intro = function() {
	this.coreCount = 0;
	wl_core_Part.call(this);
};
$hxClasses["intro.Intro"] = intro_Intro;
intro_Intro.__name__ = ["intro","Intro"];
intro_Intro.__super__ = wl_core_Part;
intro_Intro.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.clearColor = 0;
		var ep = { };
		ep.bloom = true;
		ep.cga = false;
		ep.vhs = false;
		ep.dof = false;
		ep.distortedTV = true;
		ep.displacement = false;
		ep.standard = true;
		this.initComposer(this.getComposerList(ep));
		this.postProcessing.bloom.strength = 1;
		this.postProcessing.bloom.threshold = 0.0;
		this.postProcessing.bloom.radius = 0.05;
		this.camera.position.set(0,0,-10);
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		this.scene.fog = new THREE.Fog(0,100,360);
		this.cubecam = new THREE.CubeCamera(1,100,512);
		this.scene.add(this.cubecam);
		var id = new THREE.IcosahedronGeometry(1,3);
		this.core = new THREE.Mesh(id,new THREE.MeshBasicMaterial({ color : 4210752, envMap : this.cubecam.renderTarget.texture}));
		this.core.scale.x = this.core.scale.y = this.core.scale.z = 0.00001;
		this.scene.add(this.core);
		var l = new THREE.PointLight(16777215,1,200,10);
		l.castShadow = false;
		l.position.y = 30;
		l.position.z = 17;
		l.position.x = -17;
		this.scene.add(l);
		var l2 = new THREE.PointLight(16777215,1,200,10);
		l2.castShadow = false;
		l2.position.y = 30;
		l2.position.x = 10;
		l2.position.z = 5;
		this.scene.add(l2);
		this.flyingCylinders = [];
		var _g1 = 0;
		var _g = id.vertices.length;
		while(_g1 < _g) {
			var i = _g1++;
			var c = new cylinders_Cylinder();
			this.scene.add(c);
			var v = id.vertices[i];
			c.mesh.receiveShadow = false;
			c.mesh.castShadow = false;
			c.scale.x = c.scale.z = c.scale.y = 0.7;
			c.position.x = v.x * 360;
			c.position.y = v.y * 360;
			c.position.z = v.z * 360;
			c.targetV = v.multiplyScalar(13);
			c.lookAt(new THREE.Vector3(0,0,0));
			c.rotateX(Math.PI / 2);
			this.flyingCylinders.push(c);
		}
		this.flyingCylinders = wl_util_ArrayUtil.shuffle(this.flyingCylinders);
		this.pl = new THREE.PointLight(DemoMain.WHITE.getHex(),1,130,1);
		this.scene.add(this.pl);
		this.rndcc = new wl_demo_RandomCameraController(this.camera,5,[this.core],235656787,[wl_demo_CameraController.BEZIER],[-15,15],new THREE.Box3(new THREE.Vector3(-40,40,-40),new THREE.Vector3(40,80,40)));
		this.addTrigger(new wl_core_TimeSig(-1,-1,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.onBeat));
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.switchCam));
		this.addTrigger(new wl_core_TimeSig(-1,-1,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.nextToBall));
		this.addTrigger(new wl_core_TimeSig(-1,-1,1,0,wl_core_TimeSig.PATTERN),$bind(this,this.nextToBall));
		this.addTrigger(new wl_core_TimeSig(-1,-1,2,0,wl_core_TimeSig.PATTERN),$bind(this,this.nextToBall));
		this.addTrigger(new wl_core_TimeSig(-1,-1,3,0,wl_core_TimeSig.PATTERN),$bind(this,this.nextToBall));
		this.addTrigger(new wl_core_TimeSig(-1,-1,4,0,wl_core_TimeSig.PATTERN),$bind(this,this.nextToBall));
		this.addTrigger(new wl_core_TimeSig(-1,-1,5,0,wl_core_TimeSig.PATTERN),$bind(this,this.nextToBall));
		this.addTrigger(new wl_core_TimeSig(-1,-1,6,0,wl_core_TimeSig.PATTERN),$bind(this,this.nextToBall));
		this.addTrigger(new wl_core_TimeSig(-1,-1,7,0,wl_core_TimeSig.PATTERN),$bind(this,this.nextToBall));
		this.addTrigger(new wl_core_TimeSig(-1,-1,8,0,wl_core_TimeSig.PATTERN),$bind(this,this.nextToBall));
		this.addTrigger(new wl_core_TimeSig(-1,-1,9,0,wl_core_TimeSig.PATTERN),$bind(this,this.nextToBall));
		this.addTrigger(new wl_core_TimeSig(-1,-1,10,0,wl_core_TimeSig.PATTERN),$bind(this,this.nextToBall));
		this.addTrigger(new wl_core_TimeSig(-1,-1,11,0,wl_core_TimeSig.PATTERN),$bind(this,this.nextToBall));
		this.addTrigger(new wl_core_TimeSig(7,3,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.fadeOut));
		this.soundAnalyzer = new wl_sounds_SoundAnalyzer();
		this.soundAnalyzer.historySize = 5;
		this.soundAnalyzer.filters.push({ lowLimit : 100, highLimit : 200, isolate : true});
		this.soundAnalyzer.filters.push({ lowLimit : 300, highLimit : 400, isolate : true});
		this.cc = new wl_demo_CameraController(this.camera);
		this.cc.initBezier([new THREE.Vector3(4.03,-0.43,-107.83),new THREE.Vector3(20.72,0.31,-50.1),new THREE.Vector3(29.4,20.35,-29.4),new THREE.Vector3(36.35,30.07,10.5),new THREE.Vector3(40.05,40.82,28.8),new THREE.Vector3(45.25,60.43,32.99),new THREE.Vector3(50.3,80.48,35.46)],[new THREE.Vector3(-0.08,0.32,-0.04),new THREE.Vector3(-0.52,0.19,0.93),new THREE.Vector3(-0.19,0.45,0.03),new THREE.Vector3(-0.96,0.82,0.72),new THREE.Vector3(-0.21,-0.63,0.41),new THREE.Vector3(-0.35,-0.58,0.94),new THREE.Vector3(0.19,-0.23,0.66)]);
	}
	,fadeOut: function(ts) {
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : -1},wl_core_TimeSig.milliseconds(0,1,0,0),createjs.Ease.quadIn);
	}
	,nextToBall: function(ts) {
		if(ts.bar >= 0) {
			var _g = 0;
			while(_g < 3) {
				++_g;
				var c = this.flyingCylinders.pop();
				if(c != null) {
					createjs.Tween.get(c.position).to({ x : c.targetV.x, y : c.targetV.y, z : c.targetV.z},wl_core_TimeSig.milliseconds(4,0,0,0),createjs.Ease.getBackOut(0.4));
				}
			}
		}
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		this.clearColor = 28927;
		createjs.Tween.get(this).to({ clearColor : 0},wl_core_TimeSig.milliseconds(7,0,0,0),createjs.Ease.quadIn);
	}
	,switchCam: function(ts) {
	}
	,onBeat: function(ts) {
		if(ts.beat % 2 == 0) {
			this.coreCount++;
			var ns = this.core.scale.x;
			if(ts.bar < 4) {
				ns = 0.9 * Math.min(1,this.coreCount / 8 + 0.2);
			} else {
				ns = 0.9;
			}
			var ts1 = ns - 0.05;
			createjs.Tween.get(this.core.scale).to({ x : ns, y : ns, z : ns},wl_core_TimeSig.milliseconds(0,0,6,0),createjs.Ease.quadOut).to({ x : ts1, y : ts1, z : ts1},wl_core_TimeSig.milliseconds(0,1,2,0),createjs.Ease.quadIn);
		}
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		this.cc.update(partial);
		this.soundAnalyzer.update();
		if(this.soundAnalyzer.filters[0].triggered && this.soundAnalyzer.filters[0].min > 0.8) {
			this.postProcessing.distortedTV.set_offsetAmount(this.soundAnalyzer.filters[0].max * 0.3);
		} else {
			this.postProcessing.distortedTV.set_offsetAmount(0);
		}
		this.postProcessing.distortedTV.set_vignAmount(-this.soundAnalyzer.filters[0].max);
		this.cubecam.updateCubeMap(wl_core_Graphics.instance.renderer,this.scene);
		if(this.soundAnalyzer.filters[1].max > 0.6) {
			this.postProcessing.bloom.strength = 1 + (this.soundAnalyzer.filters[1].max - 0.6) * 5;
		} else {
			this.postProcessing.bloom.strength = 1;
		}
	}
	,__class__: intro_Intro
});
var js__$Boot_HaxeError = function(val) {
	Error.call(this);
	this.val = val;
	this.message = String(val);
	if(Error.captureStackTrace) {
		Error.captureStackTrace(this,js__$Boot_HaxeError);
	}
};
$hxClasses["js._Boot.HaxeError"] = js__$Boot_HaxeError;
js__$Boot_HaxeError.__name__ = ["js","_Boot","HaxeError"];
js__$Boot_HaxeError.wrap = function(val) {
	if((val instanceof Error)) {
		return val;
	} else {
		return new js__$Boot_HaxeError(val);
	}
};
js__$Boot_HaxeError.__super__ = Error;
js__$Boot_HaxeError.prototype = $extend(Error.prototype,{
	__class__: js__$Boot_HaxeError
});
var js_Boot = function() { };
$hxClasses["js.Boot"] = js_Boot;
js_Boot.__name__ = ["js","Boot"];
js_Boot.getClass = function(o) {
	if((o instanceof Array) && o.__enum__ == null) {
		return Array;
	} else {
		var cl = o.__class__;
		if(cl != null) {
			return cl;
		}
		var name = js_Boot.__nativeClassName(o);
		if(name != null) {
			return js_Boot.__resolveNativeClass(name);
		}
		return null;
	}
};
js_Boot.__string_rec = function(o,s) {
	if(o == null) {
		return "null";
	}
	if(s.length >= 5) {
		return "<...>";
	}
	var t = typeof(o);
	if(t == "function" && (o.__name__ || o.__ename__)) {
		t = "object";
	}
	switch(t) {
	case "function":
		return "<function>";
	case "object":
		if(o instanceof Array) {
			if(o.__enum__) {
				if(o.length == 2) {
					return o[0];
				}
				var str = o[0] + "(";
				s += "\t";
				var _g1 = 2;
				var _g = o.length;
				while(_g1 < _g) {
					var i = _g1++;
					if(i != 2) {
						str += "," + js_Boot.__string_rec(o[i],s);
					} else {
						str += js_Boot.__string_rec(o[i],s);
					}
				}
				return str + ")";
			}
			var l = o.length;
			var i1;
			var str1 = "[";
			s += "\t";
			var _g11 = 0;
			var _g2 = l;
			while(_g11 < _g2) {
				var i2 = _g11++;
				str1 += (i2 > 0?",":"") + js_Boot.__string_rec(o[i2],s);
			}
			str1 += "]";
			return str1;
		}
		var tostr;
		try {
			tostr = o.toString;
		} catch( e ) {
			return "???";
		}
		if(tostr != null && tostr != Object.toString && typeof(tostr) == "function") {
			var s2 = o.toString();
			if(s2 != "[object Object]") {
				return s2;
			}
		}
		var k = null;
		var str2 = "{\n";
		s += "\t";
		var hasp = o.hasOwnProperty != null;
		for( var k in o ) {
		if(hasp && !o.hasOwnProperty(k)) {
			continue;
		}
		if(k == "prototype" || k == "__class__" || k == "__super__" || k == "__interfaces__" || k == "__properties__") {
			continue;
		}
		if(str2.length != 2) {
			str2 += ", \n";
		}
		str2 += s + k + " : " + js_Boot.__string_rec(o[k],s);
		}
		s = s.substring(1);
		str2 += "\n" + s + "}";
		return str2;
	case "string":
		return o;
	default:
		return String(o);
	}
};
js_Boot.__interfLoop = function(cc,cl) {
	if(cc == null) {
		return false;
	}
	if(cc == cl) {
		return true;
	}
	var intf = cc.__interfaces__;
	if(intf != null) {
		var _g1 = 0;
		var _g = intf.length;
		while(_g1 < _g) {
			var i = intf[_g1++];
			if(i == cl || js_Boot.__interfLoop(i,cl)) {
				return true;
			}
		}
	}
	return js_Boot.__interfLoop(cc.__super__,cl);
};
js_Boot.__instanceof = function(o,cl) {
	if(cl == null) {
		return false;
	}
	switch(cl) {
	case Array:
		if((o instanceof Array)) {
			return o.__enum__ == null;
		} else {
			return false;
		}
		break;
	case Bool:
		return typeof(o) == "boolean";
	case Dynamic:
		return true;
	case Float:
		return typeof(o) == "number";
	case Int:
		if(typeof(o) == "number") {
			return (o|0) === o;
		} else {
			return false;
		}
		break;
	case String:
		return typeof(o) == "string";
	default:
		if(o != null) {
			if(typeof(cl) == "function") {
				if(o instanceof cl) {
					return true;
				}
				if(js_Boot.__interfLoop(js_Boot.getClass(o),cl)) {
					return true;
				}
			} else if(typeof(cl) == "object" && js_Boot.__isNativeObj(cl)) {
				if(o instanceof cl) {
					return true;
				}
			}
		} else {
			return false;
		}
		if(cl == Class && o.__name__ != null) {
			return true;
		}
		if(cl == Enum && o.__ename__ != null) {
			return true;
		}
		return o.__enum__ == cl;
	}
};
js_Boot.__nativeClassName = function(o) {
	var name = js_Boot.__toStr.call(o).slice(8,-1);
	if(name == "Object" || name == "Function" || name == "Math" || name == "JSON") {
		return null;
	}
	return name;
};
js_Boot.__isNativeObj = function(o) {
	return js_Boot.__nativeClassName(o) != null;
};
js_Boot.__resolveNativeClass = function(name) {
	return $global[name];
};
var js_html_compat_ArrayBuffer = function(a) {
	if((a instanceof Array) && a.__enum__ == null) {
		this.a = a;
		this.byteLength = a.length;
	} else {
		var len = a;
		this.a = [];
		var _g1 = 0;
		var _g = len;
		while(_g1 < _g) this.a[_g1++] = 0;
		this.byteLength = len;
	}
};
$hxClasses["js.html.compat.ArrayBuffer"] = js_html_compat_ArrayBuffer;
js_html_compat_ArrayBuffer.__name__ = ["js","html","compat","ArrayBuffer"];
js_html_compat_ArrayBuffer.sliceImpl = function(begin,end) {
	var u = new Uint8Array(this,begin,end == null?null:end - begin);
	var result = new ArrayBuffer(u.byteLength);
	new Uint8Array(result).set(u);
	return result;
};
js_html_compat_ArrayBuffer.prototype = {
	slice: function(begin,end) {
		return new js_html_compat_ArrayBuffer(this.a.slice(begin,end));
	}
	,__class__: js_html_compat_ArrayBuffer
};
var js_html_compat_Float32Array = function() { };
$hxClasses["js.html.compat.Float32Array"] = js_html_compat_Float32Array;
js_html_compat_Float32Array.__name__ = ["js","html","compat","Float32Array"];
js_html_compat_Float32Array._new = function(arg1,offset,length) {
	var arr;
	if(typeof(arg1) == "number") {
		arr = [];
		var _g1 = 0;
		var _g = arg1;
		while(_g1 < _g) {
			var i = _g1++;
			arr[i] = 0;
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = 0;
		var _g2 = [];
		var _g21 = 0;
		var _g11 = arr.length << 2;
		while(_g21 < _g11) {
			var i1 = _g21++;
			_g2.push(0);
		}
		arr.buffer = new js_html_compat_ArrayBuffer(_g2);
	} else if(js_Boot.__instanceof(arg1,js_html_compat_ArrayBuffer)) {
		var buffer = arg1;
		if(offset == null) {
			offset = 0;
		}
		if(length == null) {
			length = buffer.byteLength - offset >> 2;
		}
		arr = [];
		var _g12 = 0;
		var _g3 = length;
		while(_g12 < _g3) {
			var i2 = _g12++;
			var val = buffer.a[offset++] | buffer.a[offset++] << 8 | buffer.a[offset++] << 16 | buffer.a[offset++] << 24;
			arr.push(haxe_io_FPHelper.i32ToFloat(val));
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = offset;
		arr.buffer = buffer;
	} else if((arg1 instanceof Array) && arg1.__enum__ == null) {
		arr = arg1.slice();
		var buffer1 = [];
		var _g4 = 0;
		while(_g4 < arr.length) {
			var f = arr[_g4];
			++_g4;
			var i3 = haxe_io_FPHelper.floatToI32(f);
			buffer1.push(i3 & 255);
			buffer1.push(i3 >> 8 & 255);
			buffer1.push(i3 >> 16 & 255);
			buffer1.push(i3 >>> 24);
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(buffer1);
	} else {
		throw new js__$Boot_HaxeError("TODO " + Std.string(arg1));
	}
	arr.subarray = js_html_compat_Float32Array._subarray;
	arr.set = js_html_compat_Float32Array._set;
	return arr;
};
js_html_compat_Float32Array._set = function(arg,offset) {
	if(js_Boot.__instanceof(arg.buffer,js_html_compat_ArrayBuffer)) {
		var a = arg;
		if(arg.byteLength + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g1 = 0;
		var _g = arg.byteLength;
		while(_g1 < _g) {
			var i = _g1++;
			this[i + offset] = a[i];
		}
	} else if((arg instanceof Array) && arg.__enum__ == null) {
		var a1 = arg;
		if(a1.length + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g11 = 0;
		var _g2 = a1.length;
		while(_g11 < _g2) {
			var i1 = _g11++;
			this[i1 + offset] = a1[i1];
		}
	} else {
		throw new js__$Boot_HaxeError("TODO");
	}
};
js_html_compat_Float32Array._subarray = function(start,end) {
	var a = js_html_compat_Float32Array._new(this.slice(start,end));
	a.byteOffset = start * 4;
	return a;
};
var js_html_compat_Uint8Array = function() { };
$hxClasses["js.html.compat.Uint8Array"] = js_html_compat_Uint8Array;
js_html_compat_Uint8Array.__name__ = ["js","html","compat","Uint8Array"];
js_html_compat_Uint8Array._new = function(arg1,offset,length) {
	var arr;
	if(typeof(arg1) == "number") {
		arr = [];
		var _g1 = 0;
		var _g = arg1;
		while(_g1 < _g) {
			var i = _g1++;
			arr[i] = 0;
		}
		arr.byteLength = arr.length;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(arr);
	} else if(js_Boot.__instanceof(arg1,js_html_compat_ArrayBuffer)) {
		var buffer = arg1;
		if(offset == null) {
			offset = 0;
		}
		if(length == null) {
			length = buffer.byteLength - offset;
		}
		if(offset == 0) {
			arr = buffer.a;
		} else {
			arr = buffer.a.slice(offset,offset + length);
		}
		arr.byteLength = arr.length;
		arr.byteOffset = offset;
		arr.buffer = buffer;
	} else if((arg1 instanceof Array) && arg1.__enum__ == null) {
		arr = arg1.slice();
		arr.byteLength = arr.length;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(arr);
	} else {
		throw new js__$Boot_HaxeError("TODO " + Std.string(arg1));
	}
	arr.subarray = js_html_compat_Uint8Array._subarray;
	arr.set = js_html_compat_Uint8Array._set;
	return arr;
};
js_html_compat_Uint8Array._set = function(arg,offset) {
	if(js_Boot.__instanceof(arg.buffer,js_html_compat_ArrayBuffer)) {
		var a = arg;
		if(arg.byteLength + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g1 = 0;
		var _g = arg.byteLength;
		while(_g1 < _g) {
			var i = _g1++;
			this[i + offset] = a[i];
		}
	} else if((arg instanceof Array) && arg.__enum__ == null) {
		var a1 = arg;
		if(a1.length + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g11 = 0;
		var _g2 = a1.length;
		while(_g11 < _g2) {
			var i1 = _g11++;
			this[i1 + offset] = a1[i1];
		}
	} else {
		throw new js__$Boot_HaxeError("TODO");
	}
};
js_html_compat_Uint8Array._subarray = function(start,end) {
	var a = js_html_compat_Uint8Array._new(this.slice(start,end));
	a.byteOffset = start;
	return a;
};
var lightrays_LightRays = function() {
	wl_core_Part.call(this);
};
$hxClasses["lightrays.LightRays"] = lightrays_LightRays;
lightrays_LightRays.__name__ = ["lightrays","LightRays"];
lightrays_LightRays.__super__ = wl_core_Part;
lightrays_LightRays.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer();
		this.camera.position.z = -2;
		this.camera.position.y = 2;
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		this.camera.add(new THREE.PointLight(16777215,1,1000));
		this.ball = new cylball_CylinderBall(true);
		this.scene.add(this.ball);
		var pl = new THREE.PointLight(16711680,1,190);
		pl.castShadow = true;
		this.ball.add(pl);
		this.ball.enableShadows();
		var box = new THREE.Mesh(new THREE.BoxGeometry(100,100,100),new THREE.MeshPhongMaterial({ color : 9803157, side : THREE.DoubleSide}));
		box.receiveShadow = true;
		this.scene.add(box);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime) {
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: lightrays_LightRays
});
var mountains_Mountains = function() {
	THREE.Object3D.call(this);
	var geos = this.CreateGeometries(30);
	var mats = [];
	mats.push(new THREE.MeshPhongMaterial({ color : DemoMain.COLOR1.getHex()}));
	mats.push(new THREE.MeshPhongMaterial({ color : DemoMain.COLOR2.getHex()}));
	mats.push(new THREE.MeshPhongMaterial({ color : DemoMain.COLOR3.getHex()}));
	mats.push(new THREE.MeshPhongMaterial({ color : DemoMain.COLOR4.getHex()}));
	mats.push(new THREE.MeshPhongMaterial({ color : DemoMain.COLOR5.getHex()}));
	var i = 0;
	var _g = 0;
	while(_g < geos.length) {
		var g = geos[_g];
		++_g;
		var mesh = new THREE.Mesh(g,mats[i % mats.length]);
		++i;
		mesh.receiveShadow = true;
		this.add(mesh);
	}
};
$hxClasses["mountains.Mountains"] = mountains_Mountains;
mountains_Mountains.__name__ = ["mountains","Mountains"];
mountains_Mountains.__super__ = THREE.Object3D;
mountains_Mountains.prototype = $extend(THREE.Object3D.prototype,{
	CreateGeometries: function(count) {
		var endgeos = [];
		var _g1 = 0;
		while(_g1 < count) {
			++_g1;
			endgeos.push(new THREE.Geometry());
		}
		var r = 0;
		var _g = 0;
		while(_g < 100) {
			var d = _g++;
			var _g11 = 0;
			while(_g11 < 100) {
				var w = _g11++;
				var geo = new THREE.CylinderGeometry(1,1,1,12,1,false);
				var sx = (wl_util_Random.nextFloat() + 0.5) * 0.25;
				geo.scale(sx,sx * 4.25,sx);
				geo.rotateX(wl_util_Random.nextFloat() * Math.PI * 2);
				geo.rotateY(wl_util_Random.nextFloat() * Math.PI * 2);
				geo.rotateZ(wl_util_Random.nextFloat() * Math.PI * 2);
				var tx = w * 2 / 5;
				var ty = 5 * Math.cos(w * Math.PI * 2 / 20) * Math.sin(Math.cos((d + w) * 0.2) + d * Math.PI * 2 / 20) * 0.5 + Math.sin(1 + (w + d) * 0.1) * 0.3 + Math.cos((0.6 + w * .5 + d * .3) * 0.1) * 0.3;
				var tz = d * 2 / 5;
				geo.translate(tx,ty,tz);
				endgeos[r % endgeos.length].merge(geo);
				geo.translate(-tx,-ty,-tz);
				r += wl_util_Random.range(1,8);
			}
		}
		var bufferGeometries = [];
		var _g2 = 0;
		while(_g2 < endgeos.length) {
			var endgeo = endgeos[_g2];
			++_g2;
			bufferGeometries.push(new THREE.BufferGeometry().fromGeometry(endgeo));
		}
		return bufferGeometries;
	}
	,__class__: mountains_Mountains
});
var mountains_MountainsTest = function() {
	wl_core_Part.call(this);
};
$hxClasses["mountains.MountainsTest"] = mountains_MountainsTest;
mountains_MountainsTest.__name__ = ["mountains","MountainsTest"];
mountains_MountainsTest.__super__ = wl_core_Part;
mountains_MountainsTest.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer();
		this.scene.add(new mountains_Mountains());
		this.camera.add(new THREE.PointLight(16777215,1.5,500));
		this.scene.add(new THREE.Mesh(new THREE.BoxGeometry(1,1,1),new THREE.MeshBasicMaterial({ color : 267386880})));
		this.camera.position.y = 10;
		this.camera.position.z = 10;
		this.camera.lookAt(new THREE.Vector3(0,0,0));
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,__class__: mountains_MountainsTest
});
var pilarlights_Pilar = function() {
	THREE.Object3D.call(this);
	if(pilarlights_Pilar.geometry == null) {
		pilarlights_Pilar.geometry = new THREE.CylinderBufferGeometry(5,5,10,25,10,false);
		pilarlights_Pilar.materials = [new THREE.MeshPhongMaterial({ color : DemoMain.COLOR1.getHex(), side : THREE.DoubleSide}),new THREE.MeshPhongMaterial({ color : DemoMain.COLOR2.getHex(), side : THREE.DoubleSide}),new THREE.MeshPhongMaterial({ color : DemoMain.COLOR3.getHex(), side : THREE.DoubleSide}),new THREE.MeshPhongMaterial({ color : DemoMain.COLOR4.getHex(), side : THREE.DoubleSide}),new THREE.MeshPhongMaterial({ color : DemoMain.COLOR5.getHex(), side : THREE.DoubleSide})];
	}
	var m = pilarlights_Pilar.materials[wl_util_Random.range(0,pilarlights_Pilar.materials.length - 1)];
	this.mesh = new THREE.Mesh(pilarlights_Pilar.geometry,m);
	this.mesh.castShadow = true;
	this.mesh.receiveShadow = true;
	this.add(this.mesh);
	this.light = new THREE.PointLight(m.color.getHex(),0.5,150);
	this.light.position.y = -4;
	this.light.castShadow = true;
	this.light.shadow.camera.near = 0.1;
	this.light.shadow.camera.far = 100;
	this.light.shadow.bias = -0.005;
	this.light.castShadow = true;
	this.light.shadowMapWidth = 1024;
	this.light.shadowMapHeight = 1024;
	this.add(this.light);
	createjs.Tween.get(this.light.position,{ loop : true}).wait(wl_util_Random.range(0,1500)).to({ y : 4},2000,createjs.Ease.quadInOut).to({ y : -4},2000,createjs.Ease.quadInOut);
};
$hxClasses["pilarlights.Pilar"] = pilarlights_Pilar;
pilarlights_Pilar.__name__ = ["pilarlights","Pilar"];
pilarlights_Pilar.__super__ = THREE.Object3D;
pilarlights_Pilar.prototype = $extend(THREE.Object3D.prototype,{
	update: function(t) {
		var bufferattribute = pilarlights_Pilar.geometry.attributes.position;
		var positions = bufferattribute.array;
		var startpo = wl_util_Random.range(0,positions.length / 3) * 3;
		positions[startpo] = null;
		positions[startpo + 1] = null;
		positions[startpo + 2] = null;
		bufferattribute.needsUpdate = true;
	}
	,__class__: pilarlights_Pilar
});
var pilarlights_PilarLights = function() {
	wl_core_Part.call(this);
};
$hxClasses["pilarlights.PilarLights"] = pilarlights_PilarLights;
pilarlights_PilarLights.__name__ = ["pilarlights","PilarLights"];
pilarlights_PilarLights.__super__ = wl_core_Part;
pilarlights_PilarLights.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer();
		this.pilars = [];
		var _g = 0;
		while(_g < 2) {
			var x = _g++;
			var _g1 = 0;
			while(_g1 < 2) {
				var z = _g1++;
				var p = new pilarlights_Pilar();
				p.position.x = 20 * x;
				p.position.z = 20 * z;
				this.pilars.push(p);
				this.scene.add(p);
			}
		}
		this.camera.position.z = -20;
		this.camera.position.y = 10;
		this.camera.lookAt(wl_util_VectorUtil.ZeroVector);
		this.scene.add(new THREE.AmbientLight(10000536));
		this.addTrigger(new wl_core_TimeSig(-1,-1,1,0,wl_core_TimeSig.PATTERN),function(ts) {
			var tmp = ts.toMilliseconds();
			_gthis.pilars[0].update(tmp);
		});
		this.addTrigger(new wl_core_TimeSig(-1,-1,2,0,wl_core_TimeSig.PATTERN),function(ts1) {
			var tmp1 = ts1.toMilliseconds();
			_gthis.pilars[0].update(tmp1);
		});
		this.addTrigger(new wl_core_TimeSig(-1,-1,3,0,wl_core_TimeSig.PATTERN),function(ts2) {
			var tmp2 = ts2.toMilliseconds();
			_gthis.pilars[0].update(tmp2);
		});
		var wb = new THREE.Mesh(new THREE.BoxGeometry(100,100,100),new THREE.MeshPhongMaterial({ color : 16777215, side : THREE.DoubleSide}));
		wb.receiveShadow = true;
		this.scene.add(wb);
		this.rndController = new wl_demo_RandomCameraController(this.camera,150,[new THREE.Object3D()],455,[wl_demo_CameraController.BEZIER,wl_demo_CameraController.LINEAR],[80],new THREE.Box3(new THREE.Vector3(-90,-90,-90),new THREE.Vector3(90,90,90)));
		this.rndController.start();
		this.addTrigger(new wl_core_TimeSig(1,0,0,0,wl_core_TimeSig.PATTERN),function(ts3) {
			_gthis.rndController.swap();
		});
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		this.rndController.updatePartial(partial);
	}
	,render: function(ts,frameTime) {
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: pilarlights_PilarLights
});
var reflectiveball_ReflectiveBall = function() {
	wl_core_Part.call(this);
};
$hxClasses["reflectiveball.ReflectiveBall"] = reflectiveball_ReflectiveBall;
reflectiveball_ReflectiveBall.__name__ = ["reflectiveball","ReflectiveBall"];
reflectiveball_ReflectiveBall.__super__ = wl_core_Part;
reflectiveball_ReflectiveBall.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var ep = { };
		ep.bloom = true;
		ep.cga = false;
		ep.vhs = false;
		ep.dof = false;
		ep.distortedTV = true;
		ep.displacement = false;
		this.initComposer(this.getComposerList(ep));
		this.postProcessing.bloom.strength = 2;
		this.postProcessing.bloom.threshold = 0.4;
		this.postProcessing.bloom.radius = 0.1;
		this.scene.add(new THREE.AmbientLight(5263440));
		this.ball = new cylball_CylinderBall(false,1.75);
		this.ball.scale.x = this.ball.scale.y = this.ball.scale.z = 5;
		this.scene.add(this.ball);
		this.camera.position.set(0,0,-10);
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		this.cubecam = new THREE.CubeCamera(1,100,512);
		this.scene.add(this.cubecam);
		this.outerBall = new THREE.Mesh(new THREE.IcosahedronGeometry(180,1),new THREE.MeshPhongMaterial({ side : THREE.BackSide, envMap : this.cubecam.renderTarget.texture, color : 16777215, emissive : 4210752}));
		this.rndcc = new wl_demo_RandomCameraController(this.camera,5,[new THREE.Object3D()],187824,[wl_demo_CameraController.BEZIER,wl_demo_CameraController.LINEAR],[4,10],new THREE.Box3(new THREE.Vector3(-2,2,-2),new THREE.Vector3(2,3,2)));
		this.addTrigger(new wl_core_TimeSig(1,0,0,0,wl_core_TimeSig.PATTERN),($_=this.ball,$bind($_,$_.onBar)));
		this.addTrigger(new wl_core_TimeSig(-1,2,0,0,wl_core_TimeSig.PATTERN),($_=this.ball,$bind($_,$_.onHalfBar)));
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.camswap));
	}
	,camswap: function(ts) {
		if(ts.bar % 2 == 0) {
			this.rndcc.swap();
		}
	}
	,update: function(ts,partial,frameTime,delta) {
		this.ball.update(ts,partial,frameTime,delta);
		this.rndcc.updateLength(wl_core_TimeSig.milliseconds(2,0,0,0));
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,__class__: reflectiveball_ReflectiveBall
});
var vortex_Vortex = function() {
	this.prevangle = 0;
	this.prevspawn = 0;
	this.lastpos = 0;
	this.DISTANCE = 20;
	this.RADIUS = 200;
	wl_core_Part.call(this);
	this.CYLINDERAMOUNT = Math.PI * this.RADIUS * this.RADIUS / this.DISTANCE;
	console.log(this.CYLINDERAMOUNT);
};
$hxClasses["vortex.Vortex"] = vortex_Vortex;
vortex_Vortex.__name__ = ["vortex","Vortex"];
vortex_Vortex.__super__ = wl_core_Part;
vortex_Vortex.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var ep = { };
		ep.bloom = true;
		ep.standard = true;
		this.initComposer(this.getComposerList(ep));
		this.postProcessing.bloom.strength = 0.25;
		this.postProcessing.bloom.radius = 2.02;
		this.postProcessing.bloom.threshold = 0.45;
		this.cylinders = [];
		this.spawns = [];
		this.spawnContainer = new THREE.Object3D();
		var _g1 = 0;
		var _g = this.CYLINDERAMOUNT;
		while(_g1 < _g) {
			++_g1;
			this.cylinders.push(new vortex_VortexCylinder());
		}
		this.scene.add(this.spawnContainer);
		this.camera.position.y = 50;
		this.camera.position.z = -40;
		this.camera.lookAt(wl_util_VectorUtil.ZeroVector);
		this.scene.add(new THREE.AmbientLight(10000536));
		this.scene.fog = new THREE.Fog(1052688,0,500);
		this.cylball = new cylball_CylinderBall();
		this.cylball.scale.set(1,1,1);
		this.scene.add(this.cylball);
		this.scene.add(new THREE.PointLight(16777215,0.5,300));
		this.cylball.add(new THREE.PointLight(16777215,0.9,280));
		this.cylball.position.y = 1000;
		this.fallCC = new wl_demo_CameraController(this.camera);
		this.fallCC.initLinear([new THREE.Vector3(50,120,50),new THREE.Vector3(50,5,50)],[new THREE.Vector3(0,120,0),new THREE.Vector3(0,0,0)]);
		this.eyeOfTheVortexCC = new wl_demo_CameraController(this.camera);
		this.eyeOfTheVortexCC.initLinear([new THREE.Vector3(100,40,120),new THREE.Vector3(165,55,150)],[new THREE.Vector3(0,0,0),new THREE.Vector3(0,0,0)]);
		this.topdownCC = new wl_demo_CameraController(this.camera);
		this.topdownCC.initLinear([new THREE.Vector3(0,100,0),new THREE.Vector3(0,10,0)],[new THREE.Vector3(0,0,0),new THREE.Vector3(0,0,0)]);
		this.outCC = new wl_demo_CameraController(this.camera);
		this.outCC.initLinear([new THREE.Vector3(5,-30,5),new THREE.Vector3(4,-230,4)],[new THREE.Vector3(0,10,0),new THREE.Vector3(0,-30,0)]);
		this.board = new wl_demo_SceneBoard();
		this.board.add(new wl_core_TimeSig(0,0,0,0,wl_core_TimeSig.RELATIVE),new wl_core_TimeSig(2,0,0,0,wl_core_TimeSig.RELATIVE),this.fallCC);
		this.board.add(new wl_core_TimeSig(2,1,0,0,wl_core_TimeSig.RELATIVE),new wl_core_TimeSig(8,0,0,0,wl_core_TimeSig.RELATIVE),this.eyeOfTheVortexCC);
		this.board.add(new wl_core_TimeSig(8,0,0,0,wl_core_TimeSig.RELATIVE),new wl_core_TimeSig(12,0,0,0,wl_core_TimeSig.RELATIVE),this.topdownCC);
		this.board.add(new wl_core_TimeSig(12,0,0,0,wl_core_TimeSig.RELATIVE),new wl_core_TimeSig(14,0,0,0,wl_core_TimeSig.RELATIVE),this.outCC);
		this.addTrigger(new wl_core_TimeSig(1,0,0,0,wl_core_TimeSig.PATTERN),($_=this.cylball,$bind($_,$_.onBar)));
		this.addTrigger(new wl_core_TimeSig(-1,2,0,0,wl_core_TimeSig.PATTERN),($_=this.cylball,$bind($_,$_.onHalfBar)));
		this.addTrigger(new wl_core_TimeSig(3,0,0,0,wl_core_TimeSig.RELATIVE),function(ts) {
			_gthis.cylball.position.y = 80;
			createjs.Tween.get(_gthis.cylball.position).to({ y : -50},wl_core_TimeSig.milliseconds(7,0,0,0));
		});
		var ball = new THREE.Mesh(new THREE.SphereGeometry(2,16,16),new THREE.MeshBasicMaterial({ color : 16777215}));
		ball.position.y = 150;
		this.scene.add(ball);
		var ball2 = new THREE.Mesh(new THREE.SphereGeometry(2,16,16),new THREE.MeshBasicMaterial({ color : 16777215}));
		ball2.position.y = 220;
		ball2.position.x = 10;
		ball2.position.z = 5;
		this.scene.add(ball2);
		var ball3 = new THREE.Mesh(new THREE.SphereGeometry(2,16,16),new THREE.MeshBasicMaterial({ color : 16777215}));
		ball3.position.y = 280;
		ball3.position.x = -10;
		ball3.position.z = -5;
		this.scene.add(ball3);
		this.addTrigger(new wl_core_TimeSig(0,0,0,0,wl_core_TimeSig.RELATIVE),function(ts1) {
			createjs.Tween.get(ball.position).to({ y : -10},wl_core_TimeSig.milliseconds(2,0,0,0),createjs.Ease.linear);
		});
		this.addTrigger(new wl_core_TimeSig(0,0,0,0,wl_core_TimeSig.RELATIVE),function(ts2) {
			createjs.Tween.get(ball2.position).to({ y : -10},wl_core_TimeSig.milliseconds(2,0,0,0),createjs.Ease.linear);
		});
		this.addTrigger(new wl_core_TimeSig(0,0,0,0,wl_core_TimeSig.RELATIVE),function(ts3) {
			createjs.Tween.get(ball3.position).to({ y : -10},wl_core_TimeSig.milliseconds(2,0,0,0),createjs.Ease.linear);
		});
		this.addTrigger(new wl_core_TimeSig(2,0,0,0,wl_core_TimeSig.RELATIVE),function(ts4) {
			_gthis.blowUpBalls(ts4,ball,ball2,ball3);
		});
		this.vortify = false;
	}
	,blowUpBalls: function(ts,ball,ball2,ball3) {
		this.vortify = true;
		ball.visible = false;
		ball2.visible = false;
		ball3.visible = false;
		this.postProcessing.standard.set_brightness(2);
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : 0},wl_core_TimeSig.milliseconds(0,2,0,0));
		this.cylball.position.y = 100;
	}
	,incCyl: function() {
		this.cylball.scale.multiplyScalar(1.2);
	}
	,setupDatGui: function(folder) {
		wl_core_Part.prototype.setupDatGui.call(this,folder);
	}
	,start: function(ts) {
		this.board.start(ts);
		wl_core_Part.prototype.start.call(this,ts);
		this.prevspawn = ts.toMilliseconds();
		var _g = 0;
		var _g1 = this.cylinders;
		while(_g < _g1.length) {
			++_g;
			this.spawn(true);
		}
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		ts.toMilliseconds();
		var _g = 0;
		var _g1 = this.spawns;
		while(_g < _g1.length) {
			var c = _g1[_g];
			++_g;
			c.position.x = Math.cos(c.angle) * c.distance;
			c.position.z = Math.sin(c.angle) * c.distance;
			c.angle += 1 / c.distance;
			c.distance -= delta * 0.1;
			if(this.vortify) {
				c.position.y = -150 / Math.max(0.01,c.distance * 0.25);
				c.scale.x = c.scale.z = Math.min(1,c.distance / 50);
			}
			this.despawn(c);
		}
		while(ts.toMilliseconds() - this.prevspawn > 15) {
			this.spawn();
			this.prevspawn += 15;
		}
		this.cylball.update(ts,partial,frameTime,delta);
		this.board.update(ts,partial,frameTime,delta);
	}
	,spawn: function(init) {
		var filtered = this.cylinders.filter(function(c) {
			return !c.spawned;
		});
		if(filtered.length == 0) {
			return null;
		}
		var cylinder = filtered[0];
		cylinder.spawn();
		var f = this.lastpos;
		this.lastpos += Math.PI / 16;
		cylinder.setPosition(Math.cos(f) * this.RADIUS,wl_util_Random.nextFloat(),Math.sin(f) * this.RADIUS,f);
		cylinder.distance = init?this.RADIUS * wl_util_Random.nextFloat():this.RADIUS;
		cylinder.angle = wl_util_Random.nextFloat() * Math.PI * 2;
		cylinder.position.x = Math.cos(cylinder.angle) * cylinder.distance;
		cylinder.position.z = Math.sin(cylinder.angle) * cylinder.distance;
		cylinder.position.y = -150 / Math.max(0.01,cylinder.distance * 0.25);
		cylinder.scale.x = cylinder.scale.z = Math.min(1,cylinder.distance / 40);
		this.prevangle += 0.06;
		this.spawnContainer.add(cylinder);
		this.spawns.push(cylinder);
		return cylinder;
	}
	,despawn: function(cylinder) {
		if(cylinder.distance < 0) {
			cylinder.spawned = false;
			var f = this.lastpos;
			this.lastpos += Math.PI / 16;
			cylinder.scale.set(1,1,1);
			cylinder.setPosition(Math.cos(f) * this.RADIUS,0,Math.sin(f) * this.RADIUS,f);
			this.spawnContainer.remove(cylinder);
			HxOverrides.remove(this.spawns,cylinder);
		}
	}
	,render: function(ts,frameTime) {
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: vortex_Vortex
});
var vortex_VortexCylinder = function() {
	this.angle = 0;
	this.distance = 0;
	this.radialPlace = 0;
	this.fallspeed = 1;
	THREE.Object3D.call(this);
	if(vortex_VortexCylinder.geometry == null) {
		vortex_VortexCylinder.geometry = new THREE.CylinderBufferGeometry(1,1,10,25,2,false);
		vortex_VortexCylinder.materials = [new THREE.MeshPhongMaterial({ color : DemoMain.COLOR1.getHex(), side : THREE.DoubleSide}),new THREE.MeshPhongMaterial({ color : DemoMain.COLOR2.getHex(), side : THREE.DoubleSide}),new THREE.MeshPhongMaterial({ color : DemoMain.COLOR3.getHex(), side : THREE.DoubleSide}),new THREE.MeshPhongMaterial({ color : DemoMain.COLOR4.getHex(), side : THREE.DoubleSide}),new THREE.MeshPhongMaterial({ color : DemoMain.COLOR5.getHex(), side : THREE.DoubleSide})];
	}
	this.initMesh();
};
$hxClasses["vortex.VortexCylinder"] = vortex_VortexCylinder;
vortex_VortexCylinder.__name__ = ["vortex","VortexCylinder"];
vortex_VortexCylinder.__super__ = THREE.Object3D;
vortex_VortexCylinder.prototype = $extend(THREE.Object3D.prototype,{
	setPosition: function(x,y,z,radial) {
		if(this.originalPosition == null) {
			this.originalPosition = new THREE.Vector3(x,y,z);
		}
		vortex_VortexCylinder.MAX.x = Math.max(vortex_VortexCylinder.MAX.x,x);
		vortex_VortexCylinder.MAX.z = Math.max(vortex_VortexCylinder.MAX.z,z);
		vortex_VortexCylinder.MIN.x = Math.min(vortex_VortexCylinder.MIN.x,x);
		vortex_VortexCylinder.MIN.z = Math.min(vortex_VortexCylinder.MIN.z,z);
		this.radialPlace = radial;
		this.position.set(x,y,z);
	}
	,initMesh: function() {
		this.mesh = new THREE.Mesh(vortex_VortexCylinder.geometry,vortex_VortexCylinder.materials[wl_util_Random.next() % vortex_VortexCylinder.materials.length]);
		this.mesh.receiveShadow = true;
		this.add(this.mesh);
	}
	,spawn: function() {
		this.fallspeed = 1;
		this.spawned = true;
	}
	,__class__: vortex_VortexCylinder
});
var wl_core_Assets = $hx_exports["kvg"]["core"]["assets"] = function() {
};
$hxClasses["wl.core.Assets"] = wl_core_Assets;
wl_core_Assets.__name__ = ["wl","core","Assets"];
wl_core_Assets.register = function(id,type,data,compressed) {
	if(compressed) {
		throw new js__$Boot_HaxeError("Compression not implemented.");
	}
	if(type == "png" || type == "jpg") {
		var img = new Image();
		img.src = "data:image/" + (type == "jpg"?"jpeg":type) + ";base64," + data;
		var _this = wl_core_Assets._assets;
		if(__map_reserved[id] != null) {
			_this.setReserved(id,img);
		} else {
			_this.h[id] = img;
		}
	} else if(type == "mp3" || type == "ogg") {
		var _this1 = wl_core_Assets._assets;
		if(__map_reserved[id] != null) {
			_this1.setReserved(id,data);
		} else {
			_this1.h[id] = data;
		}
	} else if(type == "json") {
		var _this2 = wl_core_Assets._assets;
		var value = JSON.parse(data);
		if(__map_reserved[id] != null) {
			_this2.setReserved(id,value);
		} else {
			_this2.h[id] = value;
		}
	} else if(type == "object") {
		var _this3 = wl_core_Assets._assets;
		if(__map_reserved[id] != null) {
			_this3.setReserved(id,data);
		} else {
			_this3.h[id] = data;
		}
	}
};
wl_core_Assets.get = function(id) {
	var _this = wl_core_Assets._assets;
	if(!(__map_reserved[id] != null?_this.existsReserved(id):_this.h.hasOwnProperty(id))) {
		console.log("Asset " + id + " not found");
	}
	var _this1 = wl_core_Assets._assets;
	if(__map_reserved[id] != null) {
		return _this1.getReserved(id);
	} else {
		return _this1.h[id];
	}
};
wl_core_Assets.getTexture = function(id) {
	var img = wl_core_Assets.get(id);
	if(img == null) {
		throw new js__$Boot_HaxeError("Texture " + id + " not found.");
	}
	var tex = new THREE.Texture(img);
	tex.needsUpdate = true;
	return tex;
};
wl_core_Assets.prototype = {
	__class__: wl_core_Assets
};
var wl_core_Config = $hx_exports["wl"]["Config"] = function() {
	throw new js__$Boot_HaxeError("Config is static only.");
};
$hxClasses["wl.core.Config"] = wl_core_Config;
wl_core_Config.__name__ = ["wl","core","Config"];
wl_core_Config.prototype = {
	__class__: wl_core_Config
};
var wl_core_Demo = $hx_exports["Demo"] = function() {
	this.waitingFirstFrame = true;
	this.allowUpdate = false;
	this.previousUpdate = 0;
	this.partMap = new haxe_ds_StringMap();
	wl_core_Demo.instance = this;
};
$hxClasses["wl.core.Demo"] = wl_core_Demo;
wl_core_Demo.__name__ = ["wl","core","Demo"];
wl_core_Demo.prototype = {
	getPart: function(name) {
		var _this = this.partMap;
		if(__map_reserved[name] != null) {
			return _this.getReserved(name);
		} else {
			return _this.h[name];
		}
	}
	,init: function(container,callback) {
		var _gthis = this;
		wl_util_Random.init(wl_core_Config.SEED);
		this.graphics = new wl_core_Graphics(container);
		wl_sounds_SoundWL.onSoundComplete.connect($bind(this,this.onSoundEnd));
		haxe_Timer.delay(function() {
			_gthis.previousTS = wl_core_TimeSig.create(0);
			_gthis.graphics.onRender.connect($bind(_gthis,_gthis.onRender));
			_gthis.initializeParts();
			if(wl_core_Config.DEBUG) {
				_gthis.initializeDebug();
			}
			createjs.Ticker.setPaused(true);
			_gthis.initDemoComposer();
			callback();
		},100);
	}
	,initDemoComposer: function() {
		this.overlay = new THREE.Scene();
		var aspect = wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[0];
		this.overlayCamera = new THREE.OrthographicCamera(0,1,0,aspect,1,1000);
		this.demoComposer = new THREE.EffectComposer(this.graphics.renderer,this.graphics.getRenderTarget());
		this.texturePass = new THREE.TexturePass(null,1);
		this.demoComposer.addPass(this.texturePass);
		var copyPass = new THREE.ShaderPass(THREE.CopyShader);
		copyPass.renderToScreen = true;
		this.demoComposer.addPass(copyPass);
		this.overlayCamera.position.z = 10;
		this.overlayCamera.lookAt(new THREE.Vector3());
	}
	,onSoundEnd: function() {
		this.end();
	}
	,initializeDebug: function() {
		wl_debug_Debug.init(this);
		wl_debug_ManualControl.init();
	}
	,initializeParts: function() {
		this.parts = [];
		var _g = 0;
		var _g1 = wl_core_Config.TIMELINE;
		while(_g < _g1.length) {
			var tl = _g1[_g];
			++_g;
			var id;
			if(tl.partId == null) {
				var o = tl.part;
				id = Type.getClassName(o == null?null:js_Boot.getClass(o));
			} else {
				id = tl.partId;
			}
			tl.part.name = id;
			var _this = this.partMap;
			var key = tl.partId;
			var value = tl.part;
			if(__map_reserved[key] != null) {
				_this.setReserved(key,value);
			} else {
				_this.h[key] = value;
			}
			this.parts.push(tl.part);
		}
		var _g2 = 0;
		var _g11 = this.parts;
		while(_g2 < _g11.length) {
			var part = _g11[_g2];
			++_g2;
			part.init();
		}
		var _g3 = 0;
		var _g12 = this.parts;
		while(_g3 < _g12.length) {
			var part1 = _g12[_g3];
			++_g3;
			part1.render(this.previousTS,0);
		}
		var _g4 = 0;
		var _g13 = this.parts;
		while(_g4 < _g13.length) {
			var part2 = _g13[_g4];
			++_g4;
			part2.postInit();
		}
	}
	,start: function() {
		var _gthis = this;
		this.previousRts = this.parts[0];
		this.graphics.start();
		haxe_Timer.delay(function() {
			wl_sounds_SoundWL.start();
			_gthis.allowUpdate = true;
			_gthis.waitingFirstFrame = false;
			console.log("allow upds.");
		},400);
		haxe_Timer.delay(function() {
			_gthis.parts[0].update(new wl_core_TimeSig(0),0,10,10);
			_gthis.parts[0].setRenderToScreen(true);
			_gthis.parts[0].render(new wl_core_TimeSig(0),10);
			_gthis.onRender(0);
		},40);
	}
	,end: function() {
		this.graphics.stop();
	}
	,onRender: function(time) {
		this.graphics.renderer.clear();
		createjs.Tween.tick(time,false);
		var rts = null;
		var _g = 0;
		var _g1 = this.parts;
		while(_g < _g1.length) {
			var p = _g1[_g];
			++_g;
			if(p.inTransition) {
				p.render(this.previousTS,time);
			} else if(p.running) {
				if(rts == null && p.renderToScreen) {
					rts = p;
				} else {
					p.render(this.previousTS,time);
				}
			}
		}
		if(rts == null) {
			rts = this.previousRts;
		}
		if(rts != null) {
			this.previousRts = rts;
			rts.render(this.previousTS,time);
		}
		this.texturePass.setTexture(rts.renderTo);
		this.demoComposer.render();
		this.graphics.renderer.autoClearColor = false;
		this.graphics.renderer.render(this.overlay,this.overlayCamera);
		this.graphics.renderer.autoClearColor = true;
		if(wl_core_Config.DEBUG) {
			wl_debug_Debug.onrender();
		}
		if(this.allowUpdate) {
			this.update();
		}
	}
	,update: function() {
		var ts = wl_sounds_SoundWL.getPosition();
		var ms = ts.toMilliseconds();
		var frameTime = ms - this.previousUpdate;
		var delta = frameTime / 16.666666666666668;
		this.previousUpdate = ms;
		var _g1 = 0;
		var _g = wl_core_Config.TIMELINE.length;
		while(_g1 < _g) {
			var tl = wl_core_Config.TIMELINE[_g1++];
			if(ts.isInside(tl.runOn,tl.runOff)) {
				var p = tl.part;
				p.timeline = tl;
				var inTransition = ts.isInside(tl.runOn,tl.rtsOn) || ts.isInside(tl.rtsOff,tl.runOff);
				p.setRenderToScreen(tl.renderToScreen && !inTransition);
				if(!p.running) {
					p.start(ts);
				}
				p.isActive = true;
			}
		}
		DemoMain.update(ts,0,wl_debug_Debug.paused?0:frameTime,delta);
		var _g2 = 0;
		var _g11 = this.parts;
		while(_g2 < _g11.length) {
			var p1 = _g11[_g2];
			++_g2;
			if(p1.isActive) {
				var timespan = p1.timeline.runOff.toMilliseconds() - p1.timeline.runOn.toMilliseconds();
				p1.update(ts,(ts.toMilliseconds() - p1.timeline.runOn.toMilliseconds()) / timespan,wl_debug_Debug.paused?0:frameTime,delta);
			} else if(p1.running) {
				p1.stop();
			}
			p1.isActive = false;
		}
		while(this.previousTS.isSmallerThan(ts)) {
			var _g3 = 0;
			var _g12 = this.parts;
			while(_g3 < _g12.length) {
				var p2 = _g12[_g3];
				++_g3;
				if(p2.running) {
					var tmp = p2.triggers.keys();
					while(tmp.hasNext()) {
						var key = tmp.next();
						var matches = key.matchesPattern(this.previousTS,p2.timeline.runOn);
						if(matches && !key.triggered) {
							var triggers = p2.triggers.h[key.__id__];
							key.triggered = true;
							var _g21 = 0;
							while(_g21 < triggers.length) {
								var toCall = triggers[_g21];
								++_g21;
								toCall(this.previousTS);
							}
						} else if(!matches) {
							key.triggered = false;
						}
					}
				}
			}
			this.previousTS.addTicks(1);
		}
		if(wl_core_Config.DEBUG) {
			wl_debug_Debug.onupdate();
		}
	}
	,__class__: wl_core_Demo
};
var wl_core_Graphics = function(container) {
	this.last = 0;
	this.stopped = true;
	this.container = container;
	if(wl_core_Graphics.instance == null) {
		wl_core_Graphics.instance = this;
	} else {
		console.log("Creating multiple Graphics instances. Are you sure?");
	}
	this.initGraphics();
};
$hxClasses["wl.core.Graphics"] = wl_core_Graphics;
wl_core_Graphics.__name__ = ["wl","core","Graphics"];
wl_core_Graphics.prototype = {
	initGraphics: function() {
		this.onRender = new wl_core_Signal();
		this.interval = 1000 / wl_core_Config.FPS;
		var params = { };
		params.antialias = wl_core_Config.ANTIALIAS;
		this.renderer = new THREE.WebGLRenderer(params);
		this.renderer.setClearColor(wl_core_Config.CLEAR_COLOR);
		this.renderer.autoClear = false;
		this.renderer.shadowMap.enabled = wl_core_Config.ENABLE_SHADOWS;
		this.renderer.shadowMap.type = THREE.PCFSoftShadowMap;
		this.renderer.shadowMapCascade = false;
		this.renderer.setSize(wl_core_Config.RESOLUTION[0],wl_core_Config.RESOLUTION[1],true);
		this.canvas = this.renderer.domElement;
		this.canvas.id = "demoCanvas";
		this.depthMaterial = new THREE.MeshDepthMaterial();
	}
	,start: function() {
		this.last = 0;
		this.stopped = false;
		this.renderLoop(0);
	}
	,stop: function() {
		this.renderer.clear();
		this.stopped = true;
	}
	,renderLoop: function(time) {
		this.delta = time - this.last;
		if(wl_core_Config.FPS < 0 || this.delta >= this.interval) {
			this.last = time;
			this.onRender.emit(this.delta);
		}
		if(!this.stopped) {
			window.requestAnimationFrame($bind(this,this.renderLoop));
		}
	}
	,getRenderTarget: function(format) {
		var options = { };
		options.stencilBuffer = true;
		options.minFilter = THREE.LinearFilter;
		options.magFilter = THREE.LinearFilter;
		options.format = format == null?THREE.RGBAFormat:format;
		return new THREE.WebGLRenderTarget(wl_core_Config.RESOLUTION[0],wl_core_Config.RESOLUTION[1],options);
	}
	,getRenderTargetCube: function() {
		return new THREE.WebGLRenderTargetCube(1024,1024,{ });
	}
	,__class__: wl_core_Graphics
};
var wl_core_TimeSig = $hx_exports["wl"]["TimeSig"] = function(bar,beat,tick,delay,pattern) {
	this.triggered = false;
	this.delay = 0;
	this.set_bar(bar == null?0:bar);
	this.set_beat(beat == null?0:beat);
	this.set_tick(tick == null?0:tick);
	this.delay = delay == null?0:delay;
	this.pattern = pattern == null?wl_core_TimeSig.ABSOLUTE:pattern;
};
$hxClasses["wl.core.TimeSig"] = wl_core_TimeSig;
wl_core_TimeSig.__name__ = ["wl","core","TimeSig"];
wl_core_TimeSig.create = function(time) {
	return new wl_core_TimeSig().fromTime(time);
};
wl_core_TimeSig.milliseconds = function(bar,beat,tick,delay) {
	return (bar * wl_core_Config.BEATS_PER_BAR / wl_core_Config.BEATS_PER_MINUTE + beat / wl_core_Config.BEATS_PER_MINUTE + tick / wl_core_Config.TICKS_PER_BEAT / wl_core_Config.BEATS_PER_MINUTE) * 60 * 1000 + Math.floor(delay / 255 * (60000 / wl_core_Config.BEATS_PER_MINUTE / wl_core_Config.TICKS_PER_BEAT));
};
wl_core_TimeSig.prototype = {
	set_beat: function(value) {
		this.beat = value;
		this.adjust();
		return this.beat;
	}
	,set_bar: function(value) {
		this.bar = value;
		this.adjust();
		return this.bar;
	}
	,set_tick: function(value) {
		this.tick = value;
		this.adjust();
		return this.tick;
	}
	,adjust: function() {
	}
	,matchesPattern: function(time,begin) {
		if(this.pattern == wl_core_TimeSig.ABSOLUTE) {
			return this.equals(time);
		} else if(this.pattern == wl_core_TimeSig.RELATIVE) {
			if(time.bar == begin.bar + this.bar && time.beat == begin.beat + this.beat) {
				return time.tick == begin.tick + this.tick;
			} else {
				return false;
			}
		} else if(this.pattern == wl_core_TimeSig.PATTERN) {
			if((this.bar == -1 || time.bar % this.bar == 0) && (this.beat == -1 || time.beat % wl_core_Config.BEATS_PER_BAR == this.beat)) {
				if(this.tick != -1) {
					return time.tick % wl_core_Config.TICKS_PER_BEAT == this.tick;
				} else {
					return true;
				}
			} else {
				return false;
			}
		}
		return false;
	}
	,add: function(ts) {
		this.addBars(ts.bar);
		this.addBeats(ts.beat);
		this.addTicks(ts.tick);
	}
	,addBars: function(bars) {
		var _g = this;
		_g.set_bar(_g.bar + bars);
	}
	,addBeats: function(beats) {
		var _g = this;
		_g.set_beat(_g.beat + beats);
		var _g1 = this;
		_g1.set_bar(_g1.bar + Math.floor(this.beat / wl_core_Config.BEATS_PER_BAR));
		var _g2 = this;
		_g2.set_beat(_g2.beat % wl_core_Config.BEATS_PER_BAR);
	}
	,addTicks: function(ticks) {
		var _g = this;
		_g.set_tick(_g.tick + ticks);
		while(this.tick >= wl_core_Config.TICKS_PER_BEAT) {
			var _g1 = this;
			_g1.set_tick(_g1.tick - wl_core_Config.TICKS_PER_BEAT);
			var _g2 = this;
			_g2.set_beat(_g2.beat + 1);
		}
		while(this.beat >= wl_core_Config.BEATS_PER_BAR) {
			var _g3 = this;
			_g3.set_beat(_g3.beat - wl_core_Config.BEATS_PER_BAR);
			var _g4 = this;
			_g4.set_bar(_g4.bar + 1);
		}
	}
	,subtract: function(ts) {
		this.subtractBars(ts.bar);
		this.subtractBeats(ts.beat);
		this.subtractTicks(ts.tick);
	}
	,subtractBars: function(bars) {
		var _g = this;
		_g.set_bar(_g.bar - bars);
	}
	,subtractBeats: function(beats) {
		var _g = this;
		_g.set_beat(_g.beat - beats);
		while(this.beat < 0) {
			var _g1 = this;
			_g1.set_bar(_g1.bar - 1);
			var _g2 = this;
			_g2.set_beat(_g2.beat + wl_core_Config.BEATS_PER_BAR);
		}
	}
	,subtractTicks: function(ticks) {
		var _g = this;
		_g.set_tick(_g.tick - ticks);
		while(this.tick < 0) {
			var _g1 = this;
			_g1.set_tick(_g1.tick + wl_core_Config.TICKS_PER_BEAT);
			var _g2 = this;
			_g2.set_beat(_g2.beat - 1);
		}
		while(this.beat < 0) {
			var _g3 = this;
			_g3.set_bar(_g3.bar - 1);
			var _g4 = this;
			_g4.set_beat(_g4.beat + wl_core_Config.BEATS_PER_BAR);
		}
	}
	,fromTime: function(time) {
		var totalBeats = wl_core_Config.BEATS_PER_MINUTE * time;
		var comp = time < 0?Math.ceil:Math.floor;
		this.set_bar(comp(totalBeats / wl_core_Config.BEATS_PER_BAR));
		this.set_beat(comp(totalBeats % wl_core_Config.BEATS_PER_BAR));
		this.set_tick(comp((totalBeats - comp(totalBeats)) * wl_core_Config.TICKS_PER_BEAT));
		this.delay = 0;
		this.delay = Math.floor(255 * (time * 60 * 1000 - this.toMilliseconds()) / (60000 / wl_core_Config.BEATS_PER_MINUTE / wl_core_Config.TICKS_PER_BEAT) % 255);
		return this;
	}
	,isInside: function(begin,end) {
		if(this.isSmallerThan(end)) {
			return this.isLargerThan(begin);
		} else {
			return false;
		}
	}
	,isSmallerThan: function(other) {
		var ticks = this.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + this.beat * wl_core_Config.TICKS_PER_BEAT + this.tick;
		var tickso = other.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + other.beat * wl_core_Config.TICKS_PER_BEAT + other.tick;
		if(ticks >= tickso) {
			if(ticks == tickso) {
				return this.delay < other.delay;
			} else {
				return false;
			}
		} else {
			return true;
		}
	}
	,isLargerThan: function(other) {
		var ticks = this.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + this.beat * wl_core_Config.TICKS_PER_BEAT + this.tick;
		var tickso = other.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + other.beat * wl_core_Config.TICKS_PER_BEAT + other.tick;
		if(ticks <= tickso) {
			if(ticks == tickso) {
				return this.delay >= other.delay;
			} else {
				return false;
			}
		} else {
			return true;
		}
	}
	,toMilliseconds: function() {
		return (this.bar * wl_core_Config.BEATS_PER_BAR / wl_core_Config.BEATS_PER_MINUTE + this.beat / wl_core_Config.BEATS_PER_MINUTE + this.tick / wl_core_Config.TICKS_PER_BEAT / wl_core_Config.BEATS_PER_MINUTE) * 60 * 1000 + Math.floor(this.delay / 255 * (60000 / wl_core_Config.BEATS_PER_MINUTE / wl_core_Config.TICKS_PER_BEAT));
	}
	,equals: function(other) {
		return this.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + this.beat * wl_core_Config.TICKS_PER_BEAT + this.tick == other.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + other.beat * wl_core_Config.TICKS_PER_BEAT + other.tick;
	}
	,clone: function() {
		return new wl_core_TimeSig(this.bar,this.beat,this.tick,this.delay,this.pattern);
	}
	,toString: function(full) {
		return this.bar + ":" + this.beat + ":" + this.tick + (full?" / " + this.delay + "\n[" + this.pattern + "]":"");
	}
	,__class__: wl_core_TimeSig
};
var wl_debug_Debug = function() {
};
$hxClasses["wl.debug.Debug"] = wl_debug_Debug;
wl_debug_Debug.__name__ = ["wl","debug","Debug"];
wl_debug_Debug.init = function(demo) {
	wl_debug_Debug.gui = new dat.gui.GUI();
	window.document.addEventListener("keydown",wl_debug_Debug.onKeyDown);
	wl_debug_Debug.debugDiv = $(".debug");
	wl_debug_Debug.debugTimeSig = wl_debug_Debug.debugDiv.find("#debug_timesig");
	var tldiv = wl_debug_Debug.debugDiv.find("#timeline_parts");
	var _g = 0;
	var _g1 = wl_core_Config.TIMELINE;
	while(_g < _g1.length) {
		var tl = _g1[_g];
		++_g;
		var tlel = $("<li>" + Std.string(tl) + "</li>");
		tldiv.append(tlel);
		tlel.click(wl_debug_Debug.tlClick(tl));
		wl_debug_Debug.datGuiPart(tl.part);
	}
	wl_debug_Debug.stats = new Stats();
	wl_debug_Debug.stats.showPanel(1);
	wl_debug_Debug.stats.dom.style.position = "absolute";
	wl_debug_Debug.stats.dom.style.bottom = "0px";
	wl_debug_Debug.stats.dom.style.top = null;
	wl_debug_Debug.debugDiv.eq(0).append(wl_debug_Debug.stats.dom);
	wl_debug_Debug.stats.begin();
};
wl_debug_Debug.datGuiPart = function(part) {
	var name = part.name;
	while(wl_debug_Debug.usedFolderNames.indexOf(name) >= 0) name += ">";
	var folder = wl_debug_Debug.gui.addFolder(name);
	wl_debug_Debug.usedFolderNames.push(name);
	var composer = Reflect.field(part,"composer");
	if(composer != null) {
		var _g = 0;
		var _g1 = composer.passes;
		while(_g < _g1.length) {
			var pass = _g1[_g];
			++_g;
			if(pass.setupDatGui != null) {
				pass.setupDatGui(folder);
			}
		}
	}
	var occlusioncomposer = Reflect.field(part,"occlusionComposer");
	if(occlusioncomposer != null) {
		var _g2 = 0;
		var _g11 = occlusioncomposer.passes;
		while(_g2 < _g11.length) {
			var pass1 = _g11[_g2];
			++_g2;
			if(pass1.setupDatGui != null) {
				pass1.setupDatGui(folder);
			}
		}
	}
	part.setupDatGui(folder);
};
wl_debug_Debug.tlClick = function(tl) {
	return function() {
		var curtime = wl_sounds_SoundWL.instance.getPosition();
		var tlpos = tl.rtsOn.toMilliseconds();
		wl_sounds_SoundWL.instance.setPosition(tlpos);
		createjs.Tween.tick(Math.floor(tlpos - curtime),false);
		wl_core_Demo.instance.previousTS.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
	};
};
wl_debug_Debug.onupdate = function() {
	var ts = wl_sounds_SoundWL.getPosition();
	wl_debug_Debug.debugTimeSig.html(StringTools.replace(ts.toString(),"\n","<br/>") + "<br/>" + Math.round(ts.toMilliseconds() / 100) / 10 + "s");
};
wl_debug_Debug.onrender = function() {
	wl_debug_Debug.stats.update();
	wl_debug_ManualControl.update();
};
wl_debug_Debug.onKeyDown = function(e) {
	if(e.keyCode == 90) {
		console.log("Time captured: " + Std.string(wl_core_Demo.instance.previousTS));
	}
	if(e.keyCode == 109 || e.keyCode == 188) {
		if(wl_sounds_SoundWL.instance != null) {
			wl_sounds_SoundWL.instance.setPosition(wl_sounds_SoundWL.instance.getPosition() - 5000);
			createjs.Tween.tick(-5000,false);
			wl_core_Demo.instance.previousTS.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
		}
	}
	if(e.keyCode == 107 || e.keyCode == 190) {
		if(wl_sounds_SoundWL.instance != null) {
			wl_sounds_SoundWL.instance.setPosition(wl_sounds_SoundWL.instance.getPosition() + 5000);
			createjs.Tween.tick(5000,false);
			wl_core_Demo.instance.previousTS.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
		}
	}
	if(e.keyCode == 32) {
		wl_debug_Debug.paused = !wl_debug_Debug.paused;
		wl_sounds_SoundWL.instance.paused = wl_debug_Debug.paused;
		createjs.Tween.removeAllTweens();
	}
};
wl_debug_Debug.prototype = {
	__class__: wl_debug_Debug
};
var wl_debug_ManualControl = function() {
	throw new js__$Boot_HaxeError("Manual control is static");
};
$hxClasses["wl.debug.ManualControl"] = wl_debug_ManualControl;
wl_debug_ManualControl.__name__ = ["wl","debug","ManualControl"];
wl_debug_ManualControl.init = function() {
	if(wl_debug_ManualControl.inited) {
		return;
	}
	wl_debug_ManualControl.inited = true;
	window.document.addEventListener("keydown",wl_debug_ManualControl.onKeyDown);
	window.document.getElementById("demo").addEventListener("mousedown",wl_debug_ManualControl.onMouseDown);
};
wl_debug_ManualControl.onMouseDown = function(event) {
	console.log("mouse down");
	window.document.getElementById("demo").childNodes[0].requestPointerLock();
	window.document.addEventListener("mouseup",wl_debug_ManualControl.onMouseUp);
	window.document.getElementById("demo").addEventListener("mouseup",wl_debug_ManualControl.onMouseUp);
	event.preventDefault();
	event.stopPropagation();
	var _g1 = 0;
	var _g = wl_debug_ManualControl.parts.length;
	while(_g1 < _g) {
		var i = _g1++;
		var p = wl_debug_ManualControl.parts[i];
		var control = wl_debug_ManualControl.fpsControls[i];
		var lookingTo = new THREE.Vector3(0,0,-1);
		lookingTo = p.camera.getWorldDirection();
		control.enabled = p.running;
		var x = lookingTo.x;
		var y = lookingTo.y;
		var z = lookingTo.z;
		var lat = 90 - Math.acos(y / 1) * 180 / Math.PI;
		var lon = (270 + Math.atan2(x,z) * 180 / Math.PI) % 360 - 180;
		control.lat = lat;
		control.lon = lon;
	}
};
wl_debug_ManualControl.onMouseUp = function(event) {
	console.log("Mouse up");
	window.document.exitPointerLock();
	var _g1 = 0;
	var _g = wl_debug_ManualControl.fpsControls.length;
	while(_g1 < _g) {
		var control = wl_debug_ManualControl.fpsControls[_g1++];
		control.enabled = false;
		control.movementSpeed = 1;
	}
	window.document.removeEventListener("mouseup",wl_debug_ManualControl.onMouseUp);
	window.document.getElementById("demo").removeEventListener("mouseup",wl_debug_ManualControl.onMouseUp);
};
wl_debug_ManualControl.onKeyDown = function(event) {
	wl_debug_ManualControl.ctrlDown = event.shiftKey;
	var _g1 = 0;
	var _g = wl_debug_ManualControl.parts.length;
	while(_g1 < _g) {
		var i = _g1++;
		var p = wl_debug_ManualControl.parts[i];
		if(!p.running) {
			continue;
		}
		var control = wl_debug_ManualControl.fpsControls[i];
		var camera = p.camera;
		var camdir = new THREE.Vector3(0,0,-100);
		camdir.applyQuaternion(camera.quaternion);
		control.movementSpeed = event.shiftKey?0.1:1;
		if(event.keyCode == 80) {
			wl_demo_CameraController.stopAllControl();
			console.log("--- " + camera.name + " ---");
			console.log("Pos: x: " + camera.position.x + " y: " + camera.position.y + " z: " + camera.position.z);
			console.log("Dir: " + camdir.x + ", " + camdir.y + ", " + camdir.z);
			console.log("Look at: ");
			var la = camera.position.clone().add(camdir);
			console.log(la.x + ", " + la.y + ", " + la.z);
			console.log("Camera rotations: x " + camera.rotation.x + " y " + camera.rotation.y + " z " + camera.rotation.z + " Array ( " + camera.rotation.x + "," + camera.rotation.y + "," + camera.rotation.z + " )");
		}
		if(event.keyCode == 81) {
			console.log("point stored");
			if(wl_debug_ManualControl.storedPoints[p.name] == null) {
				wl_debug_ManualControl.storedPoints[p.name] = { pos : [], rot : [], look : []};
			}
			var la1 = camera.position.clone().add(camdir);
			wl_debug_ManualControl.storedPoints[p.name].pos.push("new Vector3(" + Math.round(camera.position.x * 100) / 100 + "," + Math.round(camera.position.y * 100) / 100 + "," + Math.round(camera.position.z * 100) / 100 + ")");
			wl_debug_ManualControl.storedPoints[p.name].rot.push("new Vector3(" + Math.round(camera.rotation.x * 100) / 100 + "," + Math.round(camera.rotation.y * 100) / 100 + "," + Math.round(camera.rotation.z * 100) / 100 + ")\n");
			wl_debug_ManualControl.storedPoints[p.name].look.push("new Vector3(" + Math.round(la1.x * 100) / 100 + "," + Math.round(la1.y * 100) / 100 + "," + Math.round(la1.z * 100) / 100 + ")");
		}
		if(event.keyCode == 85) {
			console.log("------------------------");
			var _g2 = 0;
			var _g3 = Reflect.fields(wl_debug_ManualControl.storedPoints);
			while(_g2 < _g3.length) {
				var point = _g3[_g2];
				++_g2;
				console.log("--- " + point + " ---");
				console.log("[\r\n" + wl_debug_ManualControl.storedPoints[point].pos.join(",\r\n") + "],[\r\n" + wl_debug_ManualControl.storedPoints[point].look.join(",\r\n") + "]");
			}
			wl_debug_ManualControl.storedPoints = { };
		}
	}
};
wl_debug_ManualControl.update = function() {
	var _g = 0;
	var _g1 = wl_debug_ManualControl.fpsControls;
	while(_g < _g1.length) {
		var c = _g1[_g];
		++_g;
		if(c.enabled) {
			c.update(1);
		}
	}
};
wl_debug_ManualControl.attachPart = function(part) {
	if(!wl_core_Config.DEBUG) {
		return;
	}
	wl_debug_ManualControl.parts.push(part);
	var control = new THREE.FirstPersonControls(part.camera);
	control.enabled = false;
	wl_debug_ManualControl.fpsControls.push(control);
};
wl_debug_ManualControl.prototype = {
	__class__: wl_debug_ManualControl
};
var wl_demo_BoardItem = function(startTime,endTime,controller) {
	this.startTime = startTime;
	this.controller = controller;
	this.endTime = endTime;
};
$hxClasses["wl.demo.BoardItem"] = wl_demo_BoardItem;
wl_demo_BoardItem.__name__ = ["wl","demo","BoardItem"];
wl_demo_BoardItem.prototype = {
	Run: function(ts) {
		if(ts.isLargerThan(this.startTime) && ts.isSmallerThan(this.endTime)) {
			var timespan = this.endTime.toMilliseconds() - this.startTime.toMilliseconds();
			this.controller.update((ts.toMilliseconds() - this.startTime.toMilliseconds()) / timespan);
		}
	}
	,__class__: wl_demo_BoardItem
};
var wl_demo_IController = function() { };
$hxClasses["wl.demo.IController"] = wl_demo_IController;
wl_demo_IController.__name__ = ["wl","demo","IController"];
wl_demo_IController.prototype = {
	__class__: wl_demo_IController
};
var wl_demo_CameraController = function(camera) {
	this.ignoreStop = false;
	this.updateLook = true;
	this.updatePath = true;
	if(camera != null) {
		this.attachCamera(camera);
	}
};
$hxClasses["wl.demo.CameraController"] = wl_demo_CameraController;
wl_demo_CameraController.__name__ = ["wl","demo","CameraController"];
wl_demo_CameraController.__interfaces__ = [wl_demo_IController];
wl_demo_CameraController.stopAllControl = function() {
	wl_demo_CameraController.STOPPED = true;
};
wl_demo_CameraController.prototype = {
	attachCamera: function(camera) {
		this.camera = camera;
	}
	,set_mode: function(mode) {
		this.mode = mode;
		return mode;
	}
	,initStatic: function(position,lookAt) {
		this.position = position;
		this.lookAt = lookAt;
		this.set_mode(wl_demo_CameraController.STATIC);
	}
	,initFollow: function(target,followOffset,followLookOffset) {
		this.set_mode(wl_demo_CameraController.FOLLOW);
		this.follow = target;
		this.followOffset = followOffset == null?new THREE.Vector3(0,0,0):followOffset;
		this.followLookOffset = followLookOffset == null?new THREE.Vector3(0,0,0):followLookOffset;
	}
	,initLinear: function(points,lookAts) {
		this.set_mode(wl_demo_CameraController.LINEAR);
		this.points = points;
		this.lookAts = lookAts;
	}
	,initBezier: function(points,lookAts) {
		this.set_mode(wl_demo_CameraController.BEZIER);
		this.points = points;
		this.lookAts = lookAts;
		this.path = new THREE.SplineCurve3(points);
		this.lookPath = new THREE.SplineCurve3(lookAts);
	}
	,showbezierPaths: function(scene) {
		var _g = 0;
		var _g1 = this.points;
		while(_g < _g1.length) {
			var p = _g1[_g];
			++_g;
			var b = new THREE.Mesh(new THREE.BoxGeometry(2,2,2),new THREE.MeshBasicMaterial({ color : 16711680}));
			b.position.set(p.x,p.y,p.z);
			scene.add(b);
		}
		var _g2 = 0;
		var _g11 = this.lookAts;
		while(_g2 < _g11.length) {
			var p1 = _g11[_g2];
			++_g2;
			var b1 = new THREE.Mesh(new THREE.BoxGeometry(2,2,2),new THREE.MeshBasicMaterial({ color : 255}));
			b1.position.set(p1.x,p1.y,p1.z);
			scene.add(b1);
		}
		var geometry = new THREE.Geometry();
		var linematerial = new THREE.LineBasicMaterial({ color : 16711680, linewidth : 4});
		var lookAtGeometry = new THREE.Geometry();
		var lookAtLineMaterial = new THREE.LineBasicMaterial({ color : 255});
		var _g12 = 0;
		while(_g12 < 1200) {
			var k = _g12++;
			geometry.vertices.push(this.path.getPointAt(k / 1200).clone());
			lookAtGeometry.vertices.push(this.lookPath.getPointAt(k / 1200));
		}
		scene.add(new THREE.Line(geometry,linematerial));
		scene.add(new THREE.Line(lookAtGeometry,lookAtLineMaterial));
	}
	,update: function(phase) {
		if(wl_demo_CameraController.STOPPED && !this.ignoreStop) {
			return;
		}
		if(this.mode == wl_demo_CameraController.STATIC) {
			if(this.updatePath) {
				this.camera.position.x = this.position.x;
				this.camera.position.y = this.position.y;
				this.camera.position.z = this.position.z;
			}
			if(this.updateLook) {
				this.camera.lookAt(this.lookAt);
			}
		} else if(this.mode == wl_demo_CameraController.LINEAR) {
			if(this.updatePath) {
				var a = this.points[0];
				var b = this.points[1];
				var c = new THREE.Vector3();
				c.lerpVectors(a,b,phase);
				this.camera.position.x = c.x;
				this.camera.position.y = c.y;
				this.camera.position.z = c.z;
			}
			if(this.updateLook) {
				var a1 = this.lookAts[0];
				var b1 = this.lookAts[1];
				var c1 = new THREE.Vector3();
				c1.lerpVectors(a1,b1,phase);
				this.camera.lookAt(c1);
			}
		} else if(this.mode == wl_demo_CameraController.FOLLOW) {
			if(this.updatePath) {
				this.camera.position.x = this.follow.position.x + this.followOffset.x;
				this.camera.position.y = this.follow.position.y + this.followOffset.y;
				this.camera.position.z = this.follow.position.z + this.followOffset.z;
			}
			if(this.updateLook) {
				this.camera.lookAt(this.follow.position.add(this.followLookOffset));
			}
		} else if(this.mode == wl_demo_CameraController.BEZIER) {
			if(phase < 0) {
				phase = 0;
			} else if(phase > 1) {
				phase = 1;
			}
			if(this.updatePath) {
				var p = this.path.getPointAt(phase);
				this.camera.position.x = p.x;
				this.camera.position.y = p.y;
				this.camera.position.z = p.z;
			}
			if(this.updateLook) {
				var p1 = this.lookPath.getPointAt(phase);
				this.camera.lookAt(p1);
				this.lookAt = p1;
			}
			this.position = this.camera.position;
		}
	}
	,__class__: wl_demo_CameraController
};
var wl_demo_RandomCameraController = function(camera,cameraAmount,follow,seed,allowTypes,distanceRange,bounds) {
	this.distanceRange = [];
	this.cameraSwap = 0;
	this.current = 0;
	if(allowTypes.length == 0) {
		throw new js__$Boot_HaxeError("Random camera requires at least 1 type");
	}
	this.md = distanceRange[0];
	this.bounds = bounds;
	this.rnd = distanceRange[1] - distanceRange[0];
	this.distanceRange = distanceRange;
	this.random = new wl_util_Random(seed);
	this.follow = follow;
	this.camera = camera;
	this.ccs = [];
	var _g1 = 0;
	while(_g1 < cameraAmount) {
		++_g1;
		var cc = new wl_demo_CameraController(this.camera);
		var type = allowTypes[this.random.Next() % allowTypes.length];
		if(type == wl_demo_CameraController.FOLLOW) {
			this.initFollow(cc);
		} else if(type == wl_demo_CameraController.LINEAR) {
			this.initLinear(cc);
		} else if(type == wl_demo_CameraController.STATIC) {
			this.initStatic(cc);
		} else if(type == wl_demo_CameraController.BEZIER) {
			this.initBezier(cc);
		}
		this.ccs.push(cc);
	}
};
$hxClasses["wl.demo.RandomCameraController"] = wl_demo_RandomCameraController;
wl_demo_RandomCameraController.__name__ = ["wl","demo","RandomCameraController"];
wl_demo_RandomCameraController.prototype = {
	start: function() {
		this.cameraSwap = new Date().getTime();
	}
	,swap: function() {
		this.cameraSwap = new Date().getTime();
		this.current = (this.current + 1) % this.ccs.length;
	}
	,updatePartial: function(val) {
		this.ccs[this.current].update(val);
	}
	,updateLength: function(time) {
		var tmp = new Date().getTime() - this.cameraSwap;
		this.ccs[this.current].update(tmp / time);
	}
	,getRndPoint: function() {
		var v = this.bounds.min.clone();
		v = v.addScaledVector(this.bounds.max.clone().sub(this.bounds.min),this.random.NextFloat());
		return v;
	}
	,initFollow: function(cc) {
		var obj = this.follow.length > 0?this.follow[this.random.Next() % this.follow.length]:new THREE.Object3D();
		var dir = new THREE.Vector3(this.random.NextFloat() - 0.5,this.random.NextFloat() - 0.5,this.random.NextFloat() - 0.5);
		dir.normalize();
		dir.multiplyScalar(this.random.NextFloat() * this.rnd + this.md);
		cc.initFollow(obj,dir,new THREE.Vector3(this.random.NextFloat() * this.md / 10,this.random.NextFloat() * this.md / 10,this.random.NextFloat() * this.md / 10));
	}
	,initStatic: function(cc) {
		var obj = this.follow.length > 0?this.follow[this.random.Next() % this.follow.length]:new THREE.Object3D();
		cc.initStatic(this.getRndPoint(),obj.position);
	}
	,initLinear: function(cc) {
		var obj = this.follow.length > 0?this.follow[this.random.Next() % this.follow.length]:new THREE.Object3D();
		cc.initLinear([this.getRndPoint(),this.getRndPoint()],[obj.position.clone(),obj.position.clone().add(new THREE.Vector3(this.random.NextFloat() * 20 - 10,this.random.NextFloat() * 20 - 10,this.random.NextFloat() * 20 - 10))]);
	}
	,initBezier: function(cc) {
		var obj = this.follow.length > 0?this.follow[this.random.Next() % this.follow.length]:new THREE.Object3D();
		var start = this.getRndPoint();
		var end = this.getRndPoint();
		var pos = [start];
		var looks = [obj.position.clone(),obj.position.clone()];
		var dx = end.x - start.x;
		var dy = end.y - start.y;
		var dz = end.z - start.z;
		var _g = 1;
		while(_g < 6) {
			var i = _g++;
			looks.push(obj.position.clone());
			pos.push(new THREE.Vector3(this.random.NextFloat() * dx / 10 - dx / 20 + i / 6 * dx + start.x,this.random.NextFloat() * dy / 10 - dy / 20 + i / 6 * dy + start.y,this.random.NextFloat() * dz / 10 - dz / 20 + i / 6 * dz + start.z));
		}
		pos.push(end);
		cc.initBezier(pos,looks);
	}
	,__class__: wl_demo_RandomCameraController
};
var wl_demo_SceneBoard = function() {
	this.startTime = new wl_core_TimeSig();
	this.BoardItems = [];
};
$hxClasses["wl.demo.SceneBoard"] = wl_demo_SceneBoard;
wl_demo_SceneBoard.__name__ = ["wl","demo","SceneBoard"];
wl_demo_SceneBoard.prototype = {
	add: function(startTime,endTime,controller) {
		this.BoardItems.push(new wl_demo_BoardItem(startTime,endTime,controller));
	}
	,start: function(ts) {
		this.startTime = ts.clone();
	}
	,update: function(ts,partial,frameTime,delta) {
		var _g = 0;
		var _g1 = this.BoardItems;
		while(_g < _g1.length) {
			var b = _g1[_g];
			++_g;
			var ts2 = ts.clone();
			ts2.subtract(this.startTime);
			b.Run(ts2);
		}
	}
	,__class__: wl_demo_SceneBoard
};
var wl_demo_TimeLine = function(instance,runOn,runOff,partId,renderToScreen,rtsOn,rtsOff,forceNewPart,extra) {
	this.part = instance;
	this.partId = partId;
	this.runOn = runOn;
	this.runOff = runOff;
	this.rtsOn = rtsOn == null?runOn.clone():rtsOn;
	this.rtsOff = rtsOff == null?runOff.clone():rtsOff;
	this.renderToScreen = renderToScreen == null?true:renderToScreen;
	this.forceNewPart = forceNewPart == null?false:forceNewPart;
	this.extra = extra;
};
$hxClasses["wl.demo.TimeLine"] = wl_demo_TimeLine;
wl_demo_TimeLine.__name__ = ["wl","demo","TimeLine"];
wl_demo_TimeLine.prototype = {
	toString: function() {
		return this.part.name + ":" + this.rtsOn.toString() + " - " + this.rtsOff.toString();
	}
	,__class__: wl_demo_TimeLine
};
var wl_post_aspect_Aspect = function() {
	this.aspect = 1.7777777777777777;
	this.type = 0;
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { resolution : { type : "v2", value : new THREE.Vector2(1280,720)}, tDiffuse : { type : "t"}, type : { type : "i", value : 0}, aspect : { type : "f", value : 1.7777777777777777}};
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : haxe_Resource.getString("aspect.vert"), fragmentShader : haxe_Resource.getString("aspect.frag")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
$hxClasses["wl.post.aspect.Aspect"] = wl_post_aspect_Aspect;
wl_post_aspect_Aspect.__name__ = ["wl","post","aspect","Aspect"];
wl_post_aspect_Aspect.prototype = {
	set_type: function(value) {
		this.type = value;
		this.uniforms.type.value = value;
		return value;
	}
	,set_aspect: function(value) {
		this.aspect = value;
		this.uniforms.aspect.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("Aspect");
		f.add(this,"type").step(1).min(0).max(2).onChange(function(val) {
			_gthis.uniforms.type.value = _gthis.type;
		});
		f.add(this,"aspect").step(0.1).min(1).max(4).onChange(function(val1) {
			_gthis.uniforms.aspect.value = _gthis.aspect;
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_aspect_Aspect
};
var wl_post_bloom_Bloom = function(resolution,strength,radius,threshold) {
	if(threshold == null) {
		threshold = 0;
	}
	if(radius == null) {
		radius = 0;
	}
	if(strength == null) {
		strength = 0.5;
	}
	this.nMips = 5;
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { };
	if(resolution == null) {
		resolution = new THREE.Vector2(2048,2048);
	}
	this.resolution = resolution;
	this.strength = strength;
	this.radius = radius;
	this.threshold = threshold;
	this.enabled = true;
	var pars = { minFilter : THREE.LinearFilter, magFilter : THREE.LinearFilter, format : THREE.RGBAFormat};
	this.renderTargetsHorizontal = [];
	this.renderTargetsVertical = [];
	this.nMips = 5;
	var resx = Math.round(this.resolution.x / 2);
	var resy = Math.round(this.resolution.y / 2);
	this.renderTargetBright = new THREE.WebGLRenderTarget(resx,resy,pars);
	this.renderTargetBright.texture.generateMipmaps = false;
	var _g1 = 0;
	var _g = this.nMips;
	while(_g1 < _g) {
		var i = _g1++;
		var renderTarget = new THREE.WebGLRenderTarget(resx,resy,pars);
		renderTarget.texture.generateMipmaps = false;
		this.renderTargetsHorizontal.push(renderTarget);
		var renderTarget1 = new THREE.WebGLRenderTarget(resx,resy,pars);
		renderTarget1.texture.generateMipmaps = false;
		this.renderTargetsVertical.push(renderTarget1);
		resx = Math.round(resx / 2);
		resy = Math.round(resy / 2);
	}
	if(THREE.LuminosityHighPassShader == null) {
		console.log("THREE.UnrealBloomPass relies on THREE.LuminosityHighPassShader");
	}
	var highPassShader = THREE.LuminosityHighPassShader;
	this.highPassUniforms = THREE.UniformsUtils.clone(highPassShader.uniforms);
	this.highPassUniforms.luminosityThreshold.value = threshold;
	this.highPassUniforms.smoothWidth.value = 0.01;
	this.materialHighPassFilter = new THREE.ShaderMaterial({ uniforms : this.highPassUniforms, vertexShader : highPassShader.vertexShader, fragmentShader : highPassShader.fragmentShader, defines : { }});
	this.separableBlurMaterials = [];
	var kernelSizeArray = [3,5,7,9,11];
	var resx1 = Math.round(this.resolution.x / 2);
	var resy1 = Math.round(this.resolution.y / 2);
	var _g11 = 0;
	var _g2 = this.nMips;
	while(_g11 < _g2) {
		var i1 = _g11++;
		this.separableBlurMaterials.push(this.getSeperableBlurMaterial(kernelSizeArray[i1]));
		this.separableBlurMaterials[i1].uniforms.texSize.value = new THREE.Vector2(resx1,resy1);
		resx1 = Math.round(resx1 / 2);
		resy1 = Math.round(resy1 / 2);
	}
	this.compositeMaterial = this.getCompositeMaterial(this.nMips);
	this.compositeMaterial.uniforms.blurTexture1.value = this.renderTargetsVertical[0].texture;
	this.compositeMaterial.uniforms.blurTexture2.value = this.renderTargetsVertical[1].texture;
	this.compositeMaterial.uniforms.blurTexture3.value = this.renderTargetsVertical[2].texture;
	this.compositeMaterial.uniforms.blurTexture4.value = this.renderTargetsVertical[3].texture;
	this.compositeMaterial.uniforms.blurTexture5.value = this.renderTargetsVertical[4].texture;
	this.compositeMaterial.uniforms.bloomStrength.value = strength;
	this.compositeMaterial.uniforms.bloomRadius.value = 0.1;
	this.compositeMaterial.needsUpdate = true;
	var bloomFactors = [1.0,0.8,0.6,0.4,0.2];
	this.compositeMaterial.uniforms.bloomFactors.value = bloomFactors;
	this.bloomTintColors = [new THREE.Vector3(1,1,1),new THREE.Vector3(1,1,1),new THREE.Vector3(1,1,1),new THREE.Vector3(1,1,1),new THREE.Vector3(1,1,1)];
	this.compositeMaterial.uniforms.bloomTintColors.value = this.bloomTintColors;
	if(THREE.CopyShader == null) {
		console.log("THREE.BloomPass relies on THREE.CopyShader");
	}
	var copyShader = THREE.CopyShader;
	this.copyUniforms = THREE.UniformsUtils.clone(copyShader.uniforms);
	this.copyUniforms.opacity.value = 1.0;
	this.materialCopy = new THREE.ShaderMaterial({ uniforms : this.copyUniforms, vertexShader : copyShader.vertexShader, fragmentShader : copyShader.fragmentShader, blending : THREE.AdditiveBlending, depthTest : false, depthWrite : false, transparent : true});
	this.enabled = true;
	this.needsSwap = false;
	this.oldClearColor = new THREE.Color();
	this.oldClearAlpha = 1;
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.scene = new THREE.Scene();
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene.add(this.quad);
};
$hxClasses["wl.post.bloom.Bloom"] = wl_post_bloom_Bloom;
wl_post_bloom_Bloom.__name__ = ["wl","post","bloom","Bloom"];
wl_post_bloom_Bloom.prototype = {
	setupDatGui: function(folder) {
		var f = folder.addFolder("Bloom");
		f.add(this,"strength").step(0.01);
		f.add(this,"radius").step(0.01);
		f.add(this,"threshold").step(0.01);
	}
	,setSize: function(width,height) {
		var resx = Math.round(width / 2);
		var resy = Math.round(height / 2);
		this.renderTargetBright.setSize(resx,resy);
		var _g1 = 0;
		var _g = this.nMips;
		while(_g1 < _g) {
			var i = _g1++;
			this.renderTargetsHorizontal[i].setSize(resx,resy);
			this.renderTargetsVertical[i].setSize(resx,resy);
			this.separableBlurMaterials[i].uniforms.texSize.value = new THREE.Vector2(resx,resy);
			resx = Math.round(resx / 2);
			resy = Math.round(resy / 2);
		}
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.oldClearColor.copy(renderer.getClearColor());
		this.oldClearAlpha = renderer.getClearAlpha();
		var oldAutoClear = renderer.autoClear;
		renderer.autoClear = false;
		renderer.setClearColor(new THREE.Color(0,0,0),0);
		this.highPassUniforms.tDiffuse.value = readBuffer.texture;
		this.highPassUniforms.luminosityThreshold.value = this.threshold;
		this.quad.material = this.materialHighPassFilter;
		renderer.render(this.scene,this.camera,this.renderTargetBright,true);
		var inputRenderTarget = this.renderTargetBright;
		var _g1 = 0;
		var _g = this.nMips;
		while(_g1 < _g) {
			var i = _g1++;
			this.quad.material = this.separableBlurMaterials[i];
			this.separableBlurMaterials[i].uniforms.colorTexture.value = inputRenderTarget.texture;
			this.separableBlurMaterials[i].uniforms.direction.value = wl_post_bloom_Bloom.BlurDirectionX;
			renderer.render(this.scene,this.camera,this.renderTargetsHorizontal[i],true);
			this.separableBlurMaterials[i].uniforms.colorTexture.value = this.renderTargetsHorizontal[i].texture;
			this.separableBlurMaterials[i].uniforms.direction.value = wl_post_bloom_Bloom.BlurDirectionY;
			renderer.render(this.scene,this.camera,this.renderTargetsVertical[i],true);
			inputRenderTarget = this.renderTargetsVertical[i];
		}
		this.quad.material = this.compositeMaterial;
		this.compositeMaterial.uniforms.bloomStrength.value = this.strength;
		this.compositeMaterial.uniforms.bloomRadius.value = this.radius;
		this.compositeMaterial.uniforms.bloomTintColors.value = this.bloomTintColors;
		renderer.render(this.scene,this.camera,this.renderTargetsHorizontal[0],true);
		this.quad.material = this.materialCopy;
		this.copyUniforms.tDiffuse.value = this.renderTargetsHorizontal[0].texture;
		renderer.render(this.scene,this.camera,readBuffer,false);
		renderer.setClearColor(this.oldClearColor,this.oldClearAlpha);
		renderer.autoClear = oldAutoClear;
	}
	,getSeperableBlurMaterial: function(kernelRadius) {
		return new THREE.ShaderMaterial({ defines : { 'KERNEL_RADIUS' : kernelRadius, 'SIGMA' : kernelRadius}, uniforms : { 'colorTexture' : { value : null}, 'texSize' : { value : new THREE.Vector2(0.5,0.5)}, 'direction' : { value : new THREE.Vector2(0.5,0.5)}}, vertexShader : ["varying vec2 vUv;","void main() {","\tvUv = uv;","\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );","}"].join("\n"), fragmentShader : ["#include <common>","varying vec2 vUv;","uniform sampler2D colorTexture;","uniform vec2 texSize;","uniform vec2 direction;","float gaussianPdf(in float x, in float sigma) {","\treturn 0.39894 * exp( -0.5 * x * x/( sigma * sigma))/sigma;","}","void main() {","\tvec2 invSize = 1.0 / texSize;","\tfloat fSigma = float(SIGMA);","\tfloat weightSum = gaussianPdf(0.0, fSigma);","\tvec3 diffuseSum = texture2D( colorTexture, vUv).rgb * weightSum;","\tfor( int i = 1; i < KERNEL_RADIUS; i ++ ) {","\t\tfloat x = float(i);","\t\tfloat w = gaussianPdf(x, fSigma);","\t\tvec2 uvOffset = direction * invSize * x;","\t\tvec3 sample1 = texture2D( colorTexture, vUv + uvOffset).rgb;","\t\tvec3 sample2 = texture2D( colorTexture, vUv - uvOffset).rgb;","\t\tdiffuseSum += (sample1 + sample2) * w;","\t\tweightSum += 2.0 * w;","\t}","\tgl_FragColor = vec4(diffuseSum/weightSum, 1.0);","}"].join("\n")});
	}
	,getCompositeMaterial: function(nMips) {
		return new THREE.ShaderMaterial({ defines : { 'NUM_MIPS' : nMips}, uniforms : { 'blurTexture1' : { value : null}, 'blurTexture2' : { value : null}, 'blurTexture3' : { value : null}, 'blurTexture4' : { value : null}, 'blurTexture5' : { value : null}, 'dirtTexture' : { value : null}, 'bloomStrength' : { value : 1.0}, 'bloomFactors' : { value : null}, 'bloomTintColors' : { value : null}, 'bloomRadius' : { value : 0.0}}, vertexShader : ["varying vec2 vUv;","void main() {","\tvUv = uv;","\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );","}"].join("\n"), fragmentShader : ["varying vec2 vUv;","uniform sampler2D blurTexture1;","uniform sampler2D blurTexture2;","uniform sampler2D blurTexture3;","uniform sampler2D blurTexture4;","uniform sampler2D blurTexture5;","uniform sampler2D dirtTexture;","uniform float bloomStrength;","uniform float bloomRadius;","uniform float bloomFactors[NUM_MIPS];","uniform vec3 bloomTintColors[NUM_MIPS];","float lerpBloomFactor(const in float factor) { ","\tfloat mirrorFactor = 1.2 - factor;","\treturn mix(factor, mirrorFactor, bloomRadius);","}","void main() {","\tgl_FragColor = bloomStrength * ( lerpBloomFactor(bloomFactors[0]) * vec4(bloomTintColors[0], 1.0) * texture2D(blurTexture1, vUv) + ","\t \t\t\t\t\t\t\t lerpBloomFactor(bloomFactors[1]) * vec4(bloomTintColors[1], 1.0) * texture2D(blurTexture2, vUv) + ","\t\t\t\t\t\t\t\t lerpBloomFactor(bloomFactors[2]) * vec4(bloomTintColors[2], 1.0) * texture2D(blurTexture3, vUv) + ","\t\t\t\t\t\t\t\t lerpBloomFactor(bloomFactors[3]) * vec4(bloomTintColors[3], 1.0) * texture2D(blurTexture4, vUv) + ","\t\t\t\t\t\t\t\t lerpBloomFactor(bloomFactors[4]) * vec4(bloomTintColors[4], 1.0) * texture2D(blurTexture5, vUv) );","}"].join("\n")});
	}
	,__class__: wl_post_bloom_Bloom
};
var wl_post_cga_CGA = function() {
	this.amount = 0;
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { resolution : { type : "v2", value : new THREE.Vector2(1280,720)}, tDiffuse : { type : "t"}, amount : { type : "f", value : 0}, colors : { type : "v3v", value : [new THREE.Vector3(0,0,0),new THREE.Vector3(0.35,0.35,0.35),new THREE.Vector3(0.,0.,0.66),new THREE.Vector3(0.35,0.35,1.),new THREE.Vector3(0.,0.66,0.),new THREE.Vector3(0.35,0.66,0.35),new THREE.Vector3(0.,0.66,0.66),new THREE.Vector3(0.35,1.,1.),new THREE.Vector3(0.66,0.,0.),new THREE.Vector3(1.,0.35,0.35),new THREE.Vector3(0.66,0.,0.66),new THREE.Vector3(1.,0.35,1.),new THREE.Vector3(0.66,0.35,0.0),new THREE.Vector3(1.,1.,0.35),new THREE.Vector3(0.66,0.66,0.66),new THREE.Vector3(1.,1.,1.)]}};
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : haxe_Resource.getString("cga.vert"), fragmentShader : haxe_Resource.getString("cga.frag")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
$hxClasses["wl.post.cga.CGA"] = wl_post_cga_CGA;
wl_post_cga_CGA.__name__ = ["wl","post","cga","CGA"];
wl_post_cga_CGA.prototype = {
	set_amount: function(value) {
		this.amount = value;
		this.uniforms.amount.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		folder.addFolder("CGA").add(this,"amount").step(0.1).min(0).max(1).onChange(function(val) {
			_gthis.uniforms.amount.value = _gthis.amount;
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_cga_CGA
};
var wl_post_colorhilight_ColorHilight = function() {
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.sweep = 0;
	this.targetVal = 40;
	this.testSweep = false;
	this.color2 = 16777215;
	this.color1 = 16777215;
	this.original = 0.01;
	this.amount = 0.01;
	this.value2 = 0.01;
	this.value1 = 0.01;
	this.range = 0.01;
	this.uniforms = { range : { type : "f", value : 0.03}, value1 : { type : "f", value : 0.2}, value2 : { type : "f", value : 0.5}, amount : { type : "f", value : 0.0}, original : { type : "f", value : 1}, color1 : { type : "v4", value : [1.0,1.0,1.0,1]}, color2 : { type : "v4", value : [1.0,1.0,1.0,1]}, tile : { type : "v2", value : [1.0,1.0]}, tDiffuse : { type : "t"}};
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, fragmentShader : haxe_Resource.getString("colorhilight.frag"), vertexShader : haxe_Resource.getString("colorhilight.vert")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
$hxClasses["wl.post.colorhilight.ColorHilight"] = wl_post_colorhilight_ColorHilight;
wl_post_colorhilight_ColorHilight.__name__ = ["wl","post","colorhilight","ColorHilight"];
wl_post_colorhilight_ColorHilight.prototype = {
	set_range: function(value) {
		this.range = value;
		this.uniforms.range.value = value;
		return value;
	}
	,set_value1: function(value) {
		this.value1 = value;
		this.uniforms.value1.value = value;
		return value;
	}
	,set_value2: function(value) {
		this.value2 = value;
		this.uniforms.value2.value = value;
		return value;
	}
	,set_amount: function(value) {
		this.amount = value;
		this.uniforms.amount.value = value;
		return value;
	}
	,set_original: function(value) {
		this.original = value;
		this.uniforms.original.value = value;
		return value;
	}
	,set_color1: function(value) {
		this.color1 = value;
		this.uniforms.color1.value = [(value >> 16 & 255) / 255,(value >> 8 & 255) / 255,(value & 255) / 255,1];
		return value;
	}
	,set_color2: function(value) {
		this.color2 = value;
		this.uniforms.color2.value = [(value >> 16 & 255) / 255,(value >> 8 & 255) / 255,(value & 255) / 255,1];
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("Color hilight");
		f.add(this,"range").step(0.0001).min(0).max(1).onChange(function(value) {
			_gthis.set_range(value);
		});
		f.add(this,"value1").step(0.0001).min(0).max(1).onChange(function(value1) {
			_gthis.set_value1(value1);
		});
		f.add(this,"value2").step(0.0001).min(0).max(1).onChange(function(value2) {
			_gthis.set_value2(value2);
		});
		f.add(this,"amount").step(0.0001).min(0).max(1).onChange(function(value3) {
			_gthis.set_amount(value3);
		});
		f.addColor(this,"color1").onChange(function(value4) {
			_gthis.set_color1(value4);
		});
		f.addColor(this,"color2").onChange(function(value5) {
			_gthis.set_color2(value5);
		});
		f.add(this,"original").min(0).max(1).onChange(function(value6) {
			_gthis.set_original(value6);
		});
		f.add(this,"testSweep");
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		if(this.testSweep) {
			this.set_value1(wl_core_Demo.instance.previousTS.toMilliseconds() / 1000 % 1);
			this.set_value2((0.5 + wl_core_Demo.instance.previousTS.toMilliseconds() / 1000) % 1);
		}
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,doSweep: function(time) {
		this.sweep = 0;
		createjs.Tween.get(this,{ onChange : $bind(this,this.sweepUpdate)}).to({ sweep : 1},time,createjs.Ease.quadInOut);
	}
	,sweepUpdate: function() {
		this.uniforms.amount.value = this.targetVal;
		this.uniforms.value1.value = this.sweep;
		this.uniforms.value2.value = (this.sweep + 0.5) % 1;
		this.uniforms.original.value = 1;
	}
	,__class__: wl_post_colorhilight_ColorHilight
};
var wl_post_displacement_Displacement = function(dispmap) {
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.zoom = 0.01;
	this.scaleY = 0.01;
	this.scaleX = 0.01;
	this.uniforms = { scaleX : { type : "f", value : 0.03}, scaleY : { type : "f", value : 0.03}, zoom : { type : "f", value : 1}, tDiffuse : { type : "t"}, tDispMap : { type : "t"}, offset : { type : "f2", value : [0,0]}};
	dispmap.wrapS = THREE.RepeatWrapping;
	dispmap.wrapT = THREE.RepeatWrapping;
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, fragmentShader : haxe_Resource.getString("displacement.frag"), vertexShader : haxe_Resource.getString("displacement.vert")});
	this.uniforms.tDispMap.value = dispmap;
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
$hxClasses["wl.post.displacement.Displacement"] = wl_post_displacement_Displacement;
wl_post_displacement_Displacement.__name__ = ["wl","post","displacement","Displacement"];
wl_post_displacement_Displacement.prototype = {
	set_scaleX: function(value) {
		this.scaleX = value;
		this.uniforms.scaleX.value = value;
		return value;
	}
	,set_scaleY: function(value) {
		this.scaleY = value;
		this.uniforms.scaleY.value = value;
		return value;
	}
	,set_zoom: function(value) {
		this.zoom = value;
		this.uniforms.zoom.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("displacement (post)");
		f.add(this,"scaleX").step(0.0001).min(0).max(1).onChange(function(value) {
			_gthis.set_scaleX(value);
		});
		f.add(this,"scaleY").step(0.0001).min(0).max(1).onChange(function(value1) {
			_gthis.set_scaleY(value1);
		});
		f.add(this,"zoom").step(0.0001).min(0).max(100).onChange(function(value2) {
			_gthis.set_zoom(value2);
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_displacement_Displacement
};
var wl_post_distortedTv_DistortedTv = function() {
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.brightLimit = 1.00;
	this.brightMultiplier = 1.00;
	this.offsetAmount = 0.00;
	this.vignAmount = 1.00;
	this.blueamplify = 1.0;
	this.greenamplify = 1.0;
	this.distortAmount = 100;
	this.uniforms = { distortAmount : { type : "f", value : 100.1}, tDiffuse : { type : "t"}, greenamplify : { type : "f", value : 1}, blueamplify : { type : "f", value : 1}, vignAmount : { type : "f", value : 1.00}, time : { type : "f", value : 0.0}, offsetAmount : { type : "f", value : 0.0}, brightMultiplier : { type : "f", value : 1.0}, brightLimit : { type : "f", value : 1.0}};
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, fragmentShader : haxe_Resource.getString("distortedTv.frag"), vertexShader : haxe_Resource.getString("distortedTv.vert")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
$hxClasses["wl.post.distortedTv.DistortedTv"] = wl_post_distortedTv_DistortedTv;
wl_post_distortedTv_DistortedTv.__name__ = ["wl","post","distortedTv","DistortedTv"];
wl_post_distortedTv_DistortedTv.prototype = {
	set_distortAmount: function(value) {
		this.distortAmount = value;
		this.uniforms.distortAmount.value = value;
		return value;
	}
	,set_greenamplify: function(value) {
		this.greenamplify = value;
		this.uniforms.greenamplify.value = value;
		return value;
	}
	,set_blueamplify: function(value) {
		this.blueamplify = value;
		this.uniforms.blueamplify.value = value;
		return value;
	}
	,set_vignAmount: function(value) {
		this.vignAmount = value;
		this.uniforms.vignAmount.value = value;
		return value;
	}
	,set_offsetAmount: function(value) {
		this.offsetAmount = value;
		this.uniforms.offsetAmount.value = value;
		return value;
	}
	,set_brightMultiplier: function(value) {
		this.brightMultiplier = value;
		this.uniforms.brightMultiplier.value = value;
		return value;
	}
	,set_brightLimit: function(value) {
		this.brightLimit = value;
		this.uniforms.brightLimit.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("Distorted tv");
		f.add(this,"distortAmount").step(0.01).onChange(function(value) {
			_gthis.set_distortAmount(value);
		});
		f.add(this,"greenamplify").step(0.01).onChange(function(value1) {
			_gthis.set_greenamplify(value1);
			console.log("green change " + value1);
		});
		f.add(this,"blueamplify").step(0.01).onChange(function(value2) {
			_gthis.set_blueamplify(value2);
		});
		f.add(this,"vignAmount").step(0.01).onChange(function(value3) {
			_gthis.set_vignAmount(value3);
		});
		f.add(this,"offsetAmount").step(0.01).onChange(function(value4) {
			_gthis.set_offsetAmount(value4);
		});
		f.add(this,"brightMultiplier").step(0.01).onChange(function(value5) {
			_gthis.set_brightMultiplier(value5);
		});
		f.add(this,"brightLimit").step(0.01).onChange(function(value6) {
			_gthis.set_brightLimit(value6);
		});
	}
	,setTime: function(t) {
		this.uniforms.time.value = t;
	}
	,setDistortion: function(t) {
		this.uniforms.distortAmount.value = t;
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.setTime(wl_core_Demo.instance.previousTS.toMilliseconds() / 1000);
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_distortedTv_DistortedTv
};
var wl_post_dof_DoF = function(depth,camera) {
	this.focusCoords = new THREE.Vector2(0.5,0.5);
	this.shaderFocus = true;
	this.pentagon = false;
	this.dithering = 0.00001;
	this.noise = false;
	this.fringe = 0;
	this.bias = 0;
	this.gain = 0;
	this.threshold = 0;
	this.depthblur = false;
	this.maxblur = 1;
	this.fstop = 1;
	this.focalLength = 90;
	this.focalDepth = 0;
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { 'textureWidth' : { type : "f", value : 1.0}, 'textureHeight' : { type : "f", value : 1.0}, 'focalDepth' : { type : "f", value : 2.8}, 'focalLength' : { type : "f", value : 35.0}, 'fstop' : { type : "f", value : 2.2}, 'tColor' : { type : "t", value : null}, 'tDepth' : { type : "t", value : null}, 'maxblur' : { type : "f", value : 1.0}, 'depthblur' : { type : "b", value : 0}, 'threshold' : { type : "f", value : 0.5}, 'gain' : { type : "f", value : 2.0}, 'bias' : { type : "f", value : 0.5}, 'fringe' : { type : "f", value : 0.7}, 'znear' : { type : "f", value : 0.1}, 'zfar' : { type : "f", value : 100}, 'noise' : { type : "b", value : 1}, 'dithering' : { type : "f", value : 0.0001}, 'pentagon' : { type : "b", value : 0}, 'shaderFocus' : { type : "b", value : 1}, 'focusCoords' : { type : "v2", value : new THREE.Vector2(0.5,0.5)}};
	this.sceneCamera = camera;
	var vert = haxe_Resource.getString("dof.vert");
	var frag = haxe_Resource.getString("dof.frag");
	this.uniforms.tDepth.value = depth;
	this.uniforms.textureWidth.value = wl_core_Config.RESOLUTION[0];
	this.uniforms.textureHeight.value = wl_core_Config.RESOLUTION[1];
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : vert, fragmentShader : frag});
	this.enabled = true;
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
$hxClasses["wl.post.dof.DoF"] = wl_post_dof_DoF;
wl_post_dof_DoF.__name__ = ["wl","post","dof","DoF"];
wl_post_dof_DoF.prototype = {
	set_focalDepth: function(value) {
		this.focalDepth = value;
		this.uniforms.focalDepth.value = value;
		return value;
	}
	,set_focalLength: function(value) {
		this.focalLength = value;
		this.uniforms.focalLength.value = value;
		return value;
	}
	,set_fstop: function(value) {
		this.fstop = value;
		this.uniforms.fstop.value = value;
		return value;
	}
	,set_maxblur: function(value) {
		this.maxblur = value;
		this.uniforms.maxblur.value = value;
		return value;
	}
	,set_depthblur: function(value) {
		this.depthblur = value;
		this.uniforms.depthblur.value = value;
		return value;
	}
	,set_threshold: function(value) {
		this.threshold = value;
		this.uniforms.threshold.value = value;
		return value;
	}
	,set_gain: function(value) {
		this.gain = value;
		this.uniforms.gain.value = value;
		return value;
	}
	,set_bias: function(value) {
		this.bias = value;
		this.uniforms.bias.value = value;
		return value;
	}
	,set_fringe: function(value) {
		this.fringe = value;
		this.uniforms.fringe.value = value;
		return value;
	}
	,set_noise: function(value) {
		this.noise = value;
		this.uniforms.noise.value = value;
		return value;
	}
	,set_dithering: function(value) {
		this.dithering = value;
		this.uniforms.dithering.value = value;
		return value;
	}
	,set_pentagon: function(value) {
		this.pentagon = value;
		this.uniforms.pentagon.value = value;
		return value;
	}
	,set_shaderFocus: function(value) {
		this.shaderFocus = value;
		this.uniforms.shaderFocus.value = value;
		return value;
	}
	,set_focusCoords: function(value) {
		this.focusCoords = value;
		this.uniforms.focusCoords.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("DoF");
		f.add(this,"focalDepth").step(0.01).onChange(function(value) {
			_gthis.set_focalDepth(value);
		});
		f.add(this,"focalLength").step(0.01).onChange(function(value1) {
			_gthis.set_focalLength(value1);
		});
		f.add(this,"fstop").step(0.01).onChange(function(value2) {
			_gthis.set_fstop(value2);
		});
		f.add(this,"maxblur").step(0.01).onChange(function(value3) {
			_gthis.set_maxblur(value3);
		});
		f.add(this,"depthblur").onChange(function(value4) {
			_gthis.set_depthblur(value4);
		});
		f.add(this,"threshold").step(0.01).onChange(function(value5) {
			_gthis.set_threshold(value5);
		});
		f.add(this,"gain").step(0.01).onChange(function(value6) {
			_gthis.set_gain(value6);
		});
		f.add(this,"bias").step(0.01).onChange(function(value7) {
			_gthis.set_bias(value7);
		});
		f.add(this,"fringe").step(0.01).onChange(function(value8) {
			_gthis.set_fringe(value8);
		});
		f.add(this,"noise").onChange(function(value9) {
			_gthis.set_noise(value9);
		});
		f.add(this,"dithering").step(0.01).onChange(function(value10) {
			_gthis.set_dithering(value10);
		});
		f.add(this,"pentagon").onChange(function(value11) {
			_gthis.set_pentagon(value11);
		});
		f.add(this,"shaderFocus").onChange(function(value12) {
			_gthis.set_shaderFocus(value12);
		});
		f.add(this.focusCoords,"x").step(0.01).onChange(function(value13) {
			_gthis.uniforms.focusCoords.value[0] = value13;
		});
		f.add(this.focusCoords,"y").step(0.01).onChange(function(value14) {
			_gthis.uniforms.focusCoords.value[1] = value14;
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.zfar.value = this.sceneCamera.far;
		this.uniforms.znear.value = this.sceneCamera.near;
		this.uniforms.tColor.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_dof_DoF
};
var wl_post_gray_Gray = function(gray) {
	this.gray = 0;
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { tDiffuse : { type : "t"}, gray : { type : "f"}};
	if(gray != null) {
		this.set_gray(gray);
	}
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : haxe_Resource.getString("gray.vert"), fragmentShader : haxe_Resource.getString("gray.frag")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
$hxClasses["wl.post.gray.Gray"] = wl_post_gray_Gray;
wl_post_gray_Gray.__name__ = ["wl","post","gray","Gray"];
wl_post_gray_Gray.prototype = {
	set_gray: function(value) {
		this.gray = value;
		this.uniforms.gray.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		folder.addFolder("Gray").add(this,"gray").step(0.01).min(0).max(1).onChange(function(val) {
			_gthis.uniforms.gray.value = _gthis.gray;
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_gray_Gray
};
var wl_post_pixelate_Pixelate = function(pixelamount) {
	this.pixelamount = new THREE.Vector2(128,72);
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { resolution : { type : "v2", value : new THREE.Vector2(1280,720)}, tDiffuse : { type : "t"}, pixelamount : { type : "v2", value : new THREE.Vector2(128,72)}};
	if(pixelamount != null) {
		this.uniforms.pixelamount.value = pixelamount;
	}
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : haxe_Resource.getString("pixelate.vert"), fragmentShader : haxe_Resource.getString("pixelate.frag")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
$hxClasses["wl.post.pixelate.Pixelate"] = wl_post_pixelate_Pixelate;
wl_post_pixelate_Pixelate.__name__ = ["wl","post","pixelate","Pixelate"];
wl_post_pixelate_Pixelate.prototype = {
	set_pixelamount: function(value) {
		this.pixelamount = value;
		this.uniforms.pixelamount.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("Pixelate");
		f.add(this.pixelamount,"x").step(1).min(1).max(wl_core_Config.RESOLUTION[0]).onChange(function(val) {
			_gthis.uniforms.pixelamount.value = _gthis.pixelamount;
		});
		f.add(this.pixelamount,"y").step(1).min(1).max(wl_core_Config.RESOLUTION[1]).onChange(function(val1) {
			_gthis.uniforms.pixelamount.value = _gthis.pixelamount;
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_pixelate_Pixelate
};
var wl_post_rgbshift_RGBShift = function(rshift,gshift,bshift) {
	this.bshift = 0.0;
	this.rshift = 0.0;
	this.gshift = 0.0;
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { gshift : { type : "f", value : 0.04}, rshift : { type : "f", value : 0.04}, bshift : { type : "f", value : 0.0}, tDiffuse : { type : "t"}};
	if(rshift != null) {
		this.set_rshift(rshift);
	} else {
		this.set_rshift(this.rshift);
	}
	if(gshift != null) {
		this.set_gshift(gshift);
	} else {
		this.set_gshift(this.gshift);
	}
	if(bshift != null) {
		this.set_bshift(bshift);
	} else {
		this.set_bshift(this.bshift);
	}
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : haxe_Resource.getString("rgbshift.vert"), fragmentShader : haxe_Resource.getString("rgbshift.frag")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
$hxClasses["wl.post.rgbshift.RGBShift"] = wl_post_rgbshift_RGBShift;
wl_post_rgbshift_RGBShift.__name__ = ["wl","post","rgbshift","RGBShift"];
wl_post_rgbshift_RGBShift.prototype = {
	set_gshift: function(value) {
		this.gshift = value;
		this.uniforms.gshift.value = value;
		return value;
	}
	,set_rshift: function(value) {
		this.rshift = value;
		this.uniforms.rshift.value = value;
		return value;
	}
	,set_bshift: function(value) {
		this.bshift = value;
		this.uniforms.bshift.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("RGB");
		f.add(this,"rshift").step(0.0001).min(-1).max(1).onChange(function(value) {
			_gthis.set_rshift(value);
		});
		f.add(this,"gshift").step(0.0001).min(-1).max(1).onChange(function(value1) {
			_gthis.set_gshift(value1);
		});
		f.add(this,"bshift").step(0.0001).min(-1).max(1).onChange(function(value2) {
			_gthis.set_bshift(value2);
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_rgbshift_RGBShift
};
var wl_post_standard_StandardShader = function(gamma) {
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.gamma = 1;
	this.brightness = 0;
	this.uniforms = { brightness : { type : "f", value : 0.0}, gamma : { type : "f", value : 0.0}, tDiffuse : { type : "t"}};
	if(gamma == null) {
		gamma = 1;
	}
	this.set_gamma(gamma);
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : haxe_Resource.getString("standard.vert"), fragmentShader : haxe_Resource.getString("standard.frag")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
$hxClasses["wl.post.standard.StandardShader"] = wl_post_standard_StandardShader;
wl_post_standard_StandardShader.__name__ = ["wl","post","standard","StandardShader"];
wl_post_standard_StandardShader.prototype = {
	set_brightness: function(val) {
		return this.uniforms.brightness.value = val;
	}
	,set_gamma: function(val) {
		return this.uniforms.gamma.value = val;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("Standard");
		f.add(this,"brightness").onChange(function(val) {
			_gthis.uniforms.brightness.value = _gthis.gamma;
		});
		f.add(this,"gamma").onChange(function(val1) {
			_gthis.uniforms.gamma.value = _gthis.gamma;
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_standard_StandardShader
};
var wl_post_vhs_VHS = function() {
	this.colorNoise = 0.1;
	this.hold = false;
	this.size = 0.97;
	this.intensity = 1;
	this.jitter = 1;
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.holdTime = 0;
	this.uniforms = { resolution : { type : "v2", value : new THREE.Vector2(1280,720)}, tDiffuse : { type : "t"}, tNoise : { type : "t"}, intensity : { type : "f", value : 1}, jitter : { type : "f", value : 1}, time : { type : "f", value : 1}, size : { type : "f", value : 0.97}, holdTime : { type : "f", value : 0.0}, colorNoise : { type : "f", value : 0.0}};
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : haxe_Resource.getString("vhs.vert"), fragmentShader : haxe_Resource.getString("vhs.frag")});
	var t = wl_core_Assets.getTexture("noise.png");
	t.wrapS = THREE.RepeatWrapping;
	t.wrapT = THREE.RepeatWrapping;
	this.uniforms.tNoise.value = t;
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
$hxClasses["wl.post.vhs.VHS"] = wl_post_vhs_VHS;
wl_post_vhs_VHS.__name__ = ["wl","post","vhs","VHS"];
wl_post_vhs_VHS.prototype = {
	set_jitter: function(value) {
		this.jitter = value;
		this.uniforms.jitter.value = value;
		return value;
	}
	,set_intensity: function(value) {
		this.intensity = value;
		this.uniforms.intensity.value = value;
		return value;
	}
	,set_size: function(value) {
		this.size = value;
		this.uniforms.size.value = value;
		return value;
	}
	,set_hold: function(value) {
		this.hold = value;
		return value;
	}
	,set_colorNoise: function(value) {
		this.colorNoise = value;
		this.uniforms.colorNoise.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("VHS");
		f.add(this,"intensity").step(0.01).min(0).max(1).onChange(function(val) {
			_gthis.uniforms.intensity.value = _gthis.intensity;
		});
		f.add(this,"jitter").step(0.01).min(0).max(1).onChange(function(val1) {
			_gthis.uniforms.jitter.value = _gthis.jitter;
		});
		f.add(this,"size").step(0.01).min(0).max(1).onChange(function(val2) {
			_gthis.uniforms.size.value = _gthis.size;
		});
		f.add(this,"colorNoise").step(0.01).min(0).max(10).onChange(function(val3) {
			_gthis.uniforms.colorNoise.value = _gthis.colorNoise;
		});
		f.add(this,"hold").onChange(function(val4) {
			_gthis.set_hold(val4);
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		this.uniforms.time.value = wl_core_Demo.instance.previousTS.toMilliseconds() / 1000;
		if(this.hold) {
			this.uniforms.holdTime.value = this.holdTime / 1000;
		} else {
			this.holdTime += isNaN(wl_core_Graphics.instance.delta)?0:wl_core_Graphics.instance.delta;
			this.uniforms.holdTime.value = this.holdTime / 1000;
		}
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_vhs_VHS
};
var wl_setup_JsonConfigurator = function() {
};
$hxClasses["wl.setup.JsonConfigurator"] = wl_setup_JsonConfigurator;
wl_setup_JsonConfigurator.__name__ = ["wl","setup","JsonConfigurator"];
wl_setup_JsonConfigurator.prototype = {
	fromJson: function(json) {
		var config = JSON.parse(json);
		this.audioSettingsfromJson(config);
		this.visualSettingsfromJson(config);
		this.timelineFromJson(config);
	}
	,audioSettingsfromJson: function(config) {
		wl_core_Config.BEATS_PER_MINUTE = config.audio.beatsPerMinute;
		wl_core_Config.BEATS_PER_BAR = config.audio.beatsPerBar;
		wl_core_Config.TICKS_PER_BEAT = config.audio.ticksPerBeat;
		wl_core_Config.MUSIC_BEGIN = config.audio.musicBegin;
		wl_core_Config.SONG_PATH = config.audio.songPath;
		wl_core_Config.ENABLE_FFT = config.audio.enableFFT;
	}
	,visualSettingsfromJson: function(config) {
		wl_core_Config.FPS = config.visual.targetFps;
		wl_core_Config.RESOLUTION = config.visual.resolution;
		wl_core_Config.ANTIALIAS = config.visual.antiAlias;
		wl_core_Config.ENABLE_SHADOWS = config.visual.enableShadows;
		wl_core_Config.CLEAR_COLOR = config.visual.clearColor;
		wl_core_Config.SHADOW_MAP_SIZE = config.visual.shadowMapSize;
	}
	,timelineFromJson: function(config) {
		var tl = config.timeline;
		var convertedTl = [];
		var ignoreParts = window.location.hash.indexOf("Coverride=") >= 0;
		if(window.location.hash.indexOf("override=") >= 0) {
			convertedTl = [];
			var m = new RegExp("override=(.*)","").exec(window.location.hash);
			console.log("overriding timeline with " + m[1]);
			convertedTl.push(this.tlFromConfig({ 'partId' : "override", 'type' : m[1], 'renderToScreen' : true, 'runOn' : [0,0,0,0], 'runOff' : [128,0,0,0], 'extra' : "", 'forceNewPart' : false}));
		}
		if(!ignoreParts) {
			var _g = 0;
			while(_g < tl.length) {
				var c = tl[_g];
				++_g;
				convertedTl.push(this.tlFromConfig(c));
			}
		}
		wl_core_Config.TIMELINE = convertedTl;
	}
	,tlFromConfig: function(config) {
		return new wl_demo_TimeLine(Type.createInstance(Type.resolveClass(config.type),[]),this.mainTimesigFromArray(config.runOn),this.mainTimesigFromArray(config.runOff),config.partId,config.renderToScreen,this.mainTimesigFromArray(config.rtsOn),this.mainTimesigFromArray(config.rtsOff),config.forceNewPart,config.extra);
	}
	,mainTimesigFromArray: function(tsArray) {
		if(tsArray == null) {
			return null;
		}
		return new wl_core_TimeSig(tsArray.length > 0?tsArray[0]:null,tsArray.length > 1?tsArray[1]:null,tsArray.length > 2?tsArray[2]:null,tsArray.length > 3?tsArray[3]:null,wl_core_TimeSig.ABSOLUTE);
	}
	,__class__: wl_setup_JsonConfigurator
};
var wl_setup_Setup = function() {
	throw new js__$Boot_HaxeError("Setup is static only.");
};
$hxClasses["wl.setup.Setup"] = wl_setup_Setup;
wl_setup_Setup.__name__ = ["wl","setup","Setup"];
wl_setup_Setup.init = function(demo) {
	wl_setup_Setup.setupDiv = $("#setup");
	wl_setup_Setup.demoDiv = $("#demo");
	wl_setup_Setup.resolution = wl_setup_Setup.setupDiv.find("#resolution");
	var fullscreen = wl_setup_Setup.setupDiv.find("#fullscreen");
	var start = wl_setup_Setup.setupDiv.find("#start");
	fullscreen.click(wl_setup_Setup.fullScreenClickHandler);
	start.click(wl_setup_Setup.startClickHandler);
	wl_setup_Setup.demo = demo;
	if(window.location.protocol.indexOf("file") >= 0) {
		$("#localWarning").css("display","");
	}
};
wl_setup_Setup.hideSetup = function() {
	wl_setup_Setup.setupDiv.remove();
};
wl_setup_Setup.startRun = function() {
	if(wl_setup_Setup.setupDiv.find("#muted").find("input")["is"](":checked")) {
		wl_core_Config.MUTED = true;
	}
	var debug = wl_setup_Setup.setupDiv.find("#debug").find("input")["is"](":checked");
	wl_core_Config.DEBUG = debug;
	if(debug) {
		$(".debug").css("display","block");
	} else {
		$(".debug").css("display","none");
	}
	wl_setup_Setup.loadImg = wl_core_Assets.get("loadingImage.png");
	wl_setup_Setup.loadImg.style.position = "absolute";
	wl_setup_Setup.loadImg.style.left = "0px";
	wl_setup_Setup.loadImg.style.right = "0px";
	wl_setup_Setup.loadImg.style.top = "0px";
	wl_setup_Setup.loadImg.style.bottom = "0px";
	wl_setup_Setup.loadImg.style.width = "100%";
	wl_setup_Setup.loadImg.style.height = "100%";
	wl_setup_Setup.demoDiv.append(wl_setup_Setup.loadImg);
	wl_setup_Setup.demo.init(wl_setup_Setup.demoDiv[0],function() {
		wl_setup_Setup.loadImg.remove();
		wl_setup_Setup.demo.start();
	});
	wl_setup_Setup.demoDiv.append(wl_setup_Setup.demo.graphics.canvas);
	window.document.getElementById("demo").style.display = "block";
};
wl_setup_Setup.fullScreenClickHandler = function(e) {
	wl_setup_Setup.hideSetup();
	try {
		wl_setup_Setup.demoDiv[0].requestFullscreen();
	} catch( e1 ) {
		throw new js__$Boot_HaxeError("Full screen could not be initialized. Please reload and try again.");
	}
	var w = window.screen.width;
	var h = window.screen.height;
	var ratio = wl_core_Config.RATIO;
	var lockAspect = $("#aspectLock input").val() == "on";
	if(lockAspect && w / ratio < h) {
		h = w * 720 / 1280;
	} else if(lockAspect && h < w / ratio) {
		w = h * 1280 / 720;
	}
	wl_core_Config.RESOLUTION[0] = Math.floor(w);
	wl_core_Config.RESOLUTION[1] = Math.floor(h);
	wl_setup_Setup.demoDiv.css("background","black");
	haxe_Timer.delay(wl_setup_Setup.startRun,5000);
};
wl_setup_Setup.startClickHandler = function(e) {
	$("#demo").css("transform","").css("-webkit-transform","");
	var lockAspect = $("#aspectLock input").val() == "on";
	$("#muted input")["is"](":checked");
	var resolutionType = $("#resolution .active input[name='options']").val();
	wl_setup_Setup.hideSetup();
	var w = 1280;
	var h = 720;
	if(resolutionType == "b") {
		w = 1920;
		h = 1080;
	} else if(resolutionType == "c") {
		w = window.innerWidth;
		h = window.innerHeight;
		var ratio = wl_core_Config.RATIO;
		if(lockAspect && w / ratio < h) {
			h = w / ratio;
		} else if(lockAspect && h < w / ratio) {
			w = h * ratio;
		}
	}
	wl_core_Config.RESOLUTION[0] = w;
	wl_core_Config.RESOLUTION[1] = h;
	wl_setup_Setup.demoDiv.css("width",w + "px").css("height",h + "px");
	haxe_Timer.delay(wl_setup_Setup.startRun,50);
};
wl_setup_Setup.prototype = {
	__class__: wl_setup_Setup
};
var wl_sounds_SoundAnalyzer = function() {
	this.historySize = 6;
	this.filters = [];
	this.historyLeft = [];
	this.historyRight = [];
	var _g1 = 0;
	var _g = wl_sounds_SoundWL.FFT_PRECISION;
	while(_g1 < _g) {
		++_g1;
		this.historyLeft.push([]);
		this.historyRight.push([]);
	}
};
$hxClasses["wl.sounds.SoundAnalyzer"] = wl_sounds_SoundAnalyzer;
wl_sounds_SoundAnalyzer.__name__ = ["wl","sounds","SoundAnalyzer"];
wl_sounds_SoundAnalyzer.prototype = {
	update: function() {
		var _g = 0;
		var _g1 = this.filters;
		while(_g < _g1.length) {
			var filter = _g1[_g];
			++_g;
			filter.min = 1;
			filter.max = 0;
			filter.triggered = false;
			if(filter.channels == null) {
				filter.channels = wl_sounds_Channels.both;
			}
		}
		var fft = wl_sounds_SoundWL.getFFT();
		var band = wl_sounds_SoundWL.sampleRate / wl_sounds_SoundWL.FFT_PRECISION;
		if(fft.frequencyLeft == null) {
			return;
		}
		var _g11 = 0;
		var _g2 = fft.frequencyLeft.length;
		while(_g11 < _g2) {
			var i = _g11++;
			var hL = this.historyLeft[i];
			hL.push(fft.frequencyLeft[i] / 255);
			var hR = this.historyRight[i];
			hR.push(fft.frequencyRight[i] / 255);
			while(hL.length > this.historySize) {
				hL.shift();
				hR.shift();
			}
			var sumL = 0;
			var _g21 = 0;
			while(_g21 < hL.length) {
				var v = hL[_g21];
				++_g21;
				sumL += v;
			}
			sumL /= this.historySize;
			var sumR = 0;
			var _g22 = 0;
			while(_g22 < hR.length) {
				var v1 = hR[_g22];
				++_g22;
				sumR += v1;
			}
			sumR /= this.historySize;
			var hz = band * i;
			var _g23 = 0;
			var _g3 = this.filters;
			while(_g23 < _g3.length) {
				var filter1 = _g3[_g23];
				++_g23;
				if(filter1.isolate?hz >= filter1.lowLimit && hz <= filter1.highLimit:hz > filter1.highLimit || hz < filter1.lowLimit) {
					var sum = filter1.channels == wl_sounds_Channels.both?(sumL + sumR) / 2:filter1.channels == wl_sounds_Channels.right?sumR:sumL;
					filter1.min = filter1.min > sum?sum:filter1.min;
					filter1.max = filter1.max < sum?sum:filter1.max;
					filter1.triggered = true;
				}
			}
		}
		var _g4 = 0;
		var _g12 = this.filters;
		while(_g4 < _g12.length) {
			var f = _g12[_g4];
			++_g4;
		}
	}
	,__class__: wl_sounds_SoundAnalyzer
};
var wl_sounds_Channels = { __ename__ : true, __constructs__ : ["left","right","both"] };
wl_sounds_Channels.left = ["left",0];
wl_sounds_Channels.left.toString = $estr;
wl_sounds_Channels.left.__enum__ = wl_sounds_Channels;
wl_sounds_Channels.right = ["right",1];
wl_sounds_Channels.right.toString = $estr;
wl_sounds_Channels.right.__enum__ = wl_sounds_Channels;
wl_sounds_Channels.both = ["both",2];
wl_sounds_Channels.both.toString = $estr;
wl_sounds_Channels.both.__enum__ = wl_sounds_Channels;
var wl_sounds_SoundWL = function() {
	throw new js__$Boot_HaxeError("Sound is static");
};
$hxClasses["wl.sounds.SoundWL"] = wl_sounds_SoundWL;
wl_sounds_SoundWL.__name__ = ["wl","sounds","SoundWL"];
wl_sounds_SoundWL.init = function() {
	wl_sounds_SoundWL.loadMusicFile();
	wl_sounds_SoundWL.context = createjs.Sound.activePlugin.context;
	wl_sounds_SoundWL.sampleRate = createjs.Sound.activePlugin.context.sampleRate;
	wl_sounds_SoundWL.dynamicsCompressorNode = createjs.Sound.activePlugin.dynamicsCompressorNode;
	wl_sounds_SoundWL.gainNode = createjs.Sound.activePlugin.gainNode;
	if(wl_core_Config.ENABLE_FFT) {
		wl_sounds_SoundWL.initializeFFT();
	}
};
wl_sounds_SoundWL.setVolume = function(volume) {
	wl_sounds_SoundWL.volume = volume;
	if(wl_sounds_SoundWL.instance != null) {
		wl_sounds_SoundWL.instance.volume = volume;
	}
};
wl_sounds_SoundWL.getPosition = function() {
	if(wl_sounds_SoundWL.instance != null) {
		wl_sounds_SoundWL.time.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
	} else if(wl_sounds_SoundWL.context != null) {
		wl_sounds_SoundWL.time.fromTime((wl_sounds_SoundWL.context.currentTime - wl_sounds_SoundWL.startTime) / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
	}
	return wl_sounds_SoundWL.time;
};
wl_sounds_SoundWL.getFFT = function() {
	return wl_sounds_SoundWL.FFT;
};
wl_sounds_SoundWL.updateFFT = function() {
	if(!wl_debug_Debug.paused && (wl_sounds_SoundWL.instance != null || wl_sounds_SoundWL.context != null) && wl_core_Config.ENABLE_FFT && wl_sounds_SoundWL.analyserNodeLeft != null) {
		wl_sounds_SoundWL.analyserNodeLeft.getFloatFrequencyData(wl_sounds_SoundWL.freqFloatDataLeft);
		wl_sounds_SoundWL.analyserNodeLeft.getByteFrequencyData(wl_sounds_SoundWL.freqByteDataLeft);
		wl_sounds_SoundWL.analyserNodeLeft.getByteTimeDomainData(wl_sounds_SoundWL.timeByteDataLeft);
		wl_sounds_SoundWL.analyserNodeRight.getFloatFrequencyData(wl_sounds_SoundWL.freqFloatDataRight);
		wl_sounds_SoundWL.analyserNodeRight.getByteFrequencyData(wl_sounds_SoundWL.freqByteDataRight);
		wl_sounds_SoundWL.analyserNodeRight.getByteTimeDomainData(wl_sounds_SoundWL.timeByteDataRight);
	}
};
wl_sounds_SoundWL.start = function() {
	wl_sounds_SoundWL.instance = createjs.Sound.play("music");
	wl_sounds_SoundWL.instance.on("complete",wl_sounds_SoundWL.handleComplete);
	wl_sounds_SoundWL.instance.volume = wl_core_Config.MUTED?0:wl_sounds_SoundWL.volume;
	wl_sounds_SoundWL.onSoundReady.emit();
};
wl_sounds_SoundWL.handleComplete = function() {
	wl_sounds_SoundWL.onSoundComplete.emit();
};
wl_sounds_SoundWL.loadMusicFile = function() {
	var sounds = [{ id : "music", src : wl_core_Config.SONG_PATH}];
	createjs.Sound.alternateExtensions = ["mp3"];
	createjs.Sound.addEventListener("fileload",wl_sounds_SoundWL.handleLoad);
	createjs.Sound.registerSounds(sounds);
};
wl_sounds_SoundWL.initializeFFT = function() {
	var context = wl_sounds_SoundWL.context;
	var fftsize = wl_sounds_SoundWL.FFT_PRECISION;
	if(context != null && $bind(context,context.createAnalyser) != null) {
		var mergerNode = context.createChannelMerger(2);
		wl_sounds_SoundWL.analyserNodeLeft = context.createAnalyser();
		wl_sounds_SoundWL.analyserNodeLeft.fftSize = fftsize;
		wl_sounds_SoundWL.analyserNodeLeft.smoothingTimeConstant = 0.0;
		wl_sounds_SoundWL.analyserNodeRight = context.createAnalyser();
		wl_sounds_SoundWL.analyserNodeRight.fftSize = fftsize;
		wl_sounds_SoundWL.analyserNodeRight.smoothingTimeConstant = 0.0;
		wl_sounds_SoundWL.dynamicsCompressorNode.disconnect();
		var splitterNode = context.createChannelSplitter(2);
		wl_sounds_SoundWL.gainNode.disconnect();
		wl_sounds_SoundWL.gainNode.connect(splitterNode);
		wl_sounds_SoundWL.scriptProcessor = context.createScriptProcessor(wl_sounds_SoundWL.FFT_PRECISION * 2,2,2);
		wl_sounds_SoundWL.scriptProcessor.onaudioprocess = wl_sounds_SoundWL.updateFFT;
		wl_sounds_SoundWL.scriptProcessor.connect(context.destination);
		mergerNode.connect(wl_sounds_SoundWL.scriptProcessor);
		mergerNode.connect(context.destination);
		splitterNode.connect(wl_sounds_SoundWL.analyserNodeLeft,0,0);
		splitterNode.connect(wl_sounds_SoundWL.analyserNodeRight,1,0);
		wl_sounds_SoundWL.freqFloatDataLeft = new Float32Array(wl_sounds_SoundWL.analyserNodeLeft.frequencyBinCount);
		wl_sounds_SoundWL.freqByteDataLeft = new Uint8Array(wl_sounds_SoundWL.analyserNodeLeft.frequencyBinCount);
		wl_sounds_SoundWL.timeByteDataLeft = new Uint8Array(wl_sounds_SoundWL.analyserNodeLeft.frequencyBinCount);
		wl_sounds_SoundWL.freqFloatDataRight = new Float32Array(wl_sounds_SoundWL.analyserNodeRight.frequencyBinCount);
		wl_sounds_SoundWL.freqByteDataRight = new Uint8Array(wl_sounds_SoundWL.analyserNodeRight.frequencyBinCount);
		wl_sounds_SoundWL.timeByteDataRight = new Uint8Array(wl_sounds_SoundWL.analyserNodeRight.frequencyBinCount);
		wl_sounds_SoundWL.analyserNodeLeft.connect(mergerNode,0,0);
		wl_sounds_SoundWL.analyserNodeRight.connect(mergerNode,0,1);
	} else {
		console.log("FFT could not be initialized.");
	}
	wl_sounds_SoundWL.FFT.dbLeft = wl_sounds_SoundWL.freqFloatDataLeft;
	wl_sounds_SoundWL.FFT.frequencyLeft = wl_sounds_SoundWL.freqByteDataLeft;
	wl_sounds_SoundWL.FFT.waveformLeft = wl_sounds_SoundWL.timeByteDataLeft;
	wl_sounds_SoundWL.FFT.dbRight = wl_sounds_SoundWL.freqFloatDataRight;
	wl_sounds_SoundWL.FFT.frequencyRight = wl_sounds_SoundWL.freqByteDataRight;
	wl_sounds_SoundWL.FFT.waveformRight = wl_sounds_SoundWL.timeByteDataRight;
};
wl_sounds_SoundWL.handleLoad = function() {
	wl_sounds_SoundWL.loaded = true;
	wl_sounds_SoundWL.onSoundLoaded.emit();
};
wl_sounds_SoundWL.prototype = {
	__class__: wl_sounds_SoundWL
};
var wl_util_ArrayUtil = function() {
};
$hxClasses["wl.util.ArrayUtil"] = wl_util_ArrayUtil;
wl_util_ArrayUtil.__name__ = ["wl","util","ArrayUtil"];
wl_util_ArrayUtil.shuffle = function(array) {
	var currentIndex = array.length;
	var temporaryValue;
	var randomIndex;
	while(0 != currentIndex) {
		randomIndex = Math.floor(wl_util_Random.nextFloat() * currentIndex);
		--currentIndex;
		temporaryValue = array[currentIndex];
		array[currentIndex] = array[randomIndex];
		array[randomIndex] = temporaryValue;
	}
	return array;
};
wl_util_ArrayUtil.prototype = {
	__class__: wl_util_ArrayUtil
};
var wl_util_LoadManager = $hx_exports["wl"]["util"]["LoadManafer"] = function() {
};
$hxClasses["wl.util.LoadManager"] = wl_util_LoadManager;
wl_util_LoadManager.__name__ = ["wl","util","LoadManager"];
wl_util_LoadManager.get_totalCount = function() {
	return wl_util_LoadManager._totalCount + wl_util_LoadManager.loadersWaiting.length;
};
wl_util_LoadManager.onload = function() {
	wl_util_LoadManager.managerDone = true;
	wl_util_LoadManager.checkAllDone();
};
wl_util_LoadManager.checkAllDone = function() {
	if(wl_util_LoadManager.managerDone || wl_util_LoadManager._totalCount == 0 && wl_util_LoadManager.loadersWaiting.length == 0) {
		wl_util_LoadManager.onComplete();
	}
};
wl_util_LoadManager.onerror = function() {
};
wl_util_LoadManager.onprogress = function(s,p,t) {
	console.log(s + "," + p + "," + t);
};
wl_util_LoadManager.addLoader = function(loaderClass) {
	var ldr = Type.createInstance(loaderClass,[wl_util_LoadManager.loadingManager]);
	wl_util_LoadManager._totalCount++;
	return ldr;
};
wl_util_LoadManager.addManualLoader = function(loader) {
	wl_util_LoadManager.loadersWaiting.push(loader);
};
wl_util_LoadManager.manualLoaderComplete = function(loader) {
	HxOverrides.remove(wl_util_LoadManager.loadersWaiting,loader);
	wl_util_LoadManager.checkAllDone();
};
wl_util_LoadManager.prototype = {
	__class__: wl_util_LoadManager
};
var wl_util_MathUtil = function() {
};
$hxClasses["wl.util.MathUtil"] = wl_util_MathUtil;
wl_util_MathUtil.__name__ = ["wl","util","MathUtil"];
wl_util_MathUtil.clamp = function(low,high,val) {
	if(val < low) {
		return low;
	} else if(val > high) {
		return high;
	} else {
		return val;
	}
};
wl_util_MathUtil.FromVector3 = function(position,sphereRadius) {
	var lat = 90 - Math.acos(position.y / sphereRadius) * 180 / Math.PI;
	return [(270 + Math.atan2(position.x,position.z) * 180 / Math.PI) % 360 - 180,lat];
};
wl_util_MathUtil.componentLerp = function(v1,v2,phase,easex,easey,easez,setTo) {
	if(setTo == null) {
		setTo = new THREE.Vector3();
	} else {
		setTo = setTo;
	}
	setTo.set(easex(1 - phase) * v1.x + easex(phase) * v2.x,easey(1 - phase) * v1.y + easey(phase) * v2.y,easez(1 - phase) * v1.z + easez(phase) * v2.z);
	return setTo;
};
wl_util_MathUtil.prototype = {
	__class__: wl_util_MathUtil
};
var wl_util_Random = function(seed) {
	this.seed = 123;
	this.Init(seed);
};
$hxClasses["wl.util.Random"] = wl_util_Random;
wl_util_Random.__name__ = ["wl","util","Random"];
wl_util_Random.init = function(seed) {
	wl_util_Random.instance.Init(seed);
};
wl_util_Random.next = function() {
	return wl_util_Random.instance.Next();
};
wl_util_Random.nextFloat = function() {
	return wl_util_Random.instance.NextFloat();
};
wl_util_Random.range = function(low,high) {
	return wl_util_Random.instance.Range(low,high);
};
wl_util_Random.prototype = {
	Init: function(seed) {
		this.seed = seed;
	}
	,Next: function() {
		var hi = Math.floor(this.seed / 127773);
		var test = 16807 * Math.floor(this.seed % 127773) - 2836 * hi;
		if(test < 0) {
			test += 2147483647;
		}
		this.seed = test;
		return this.seed;
	}
	,NextFloat: function() {
		return this.Next() / 2147483647;
	}
	,Range: function(low,high) {
		return Math.floor(this.NextFloat() * (high - low) + low);
	}
	,__class__: wl_util_Random
};
var wl_util_VectorUtil = function() {
};
$hxClasses["wl.util.VectorUtil"] = wl_util_VectorUtil;
wl_util_VectorUtil.__name__ = ["wl","util","VectorUtil"];
wl_util_VectorUtil.prototype = {
	__class__: wl_util_VectorUtil
};
var $_, $fid = 0;
function $bind(o,m) { if( m == null ) return null; if( m.__id__ == null ) m.__id__ = $fid++; var f; if( o.hx__closures__ == null ) o.hx__closures__ = {}; else f = o.hx__closures__[m.__id__]; if( f == null ) { f = function(){ return f.method.apply(f.scope, arguments); }; f.scope = o; f.method = m; o.hx__closures__[m.__id__] = f; } return f; }
$hxClasses.Math = Math;
String.prototype.__class__ = $hxClasses.String = String;
String.__name__ = ["String"];
$hxClasses.Array = Array;
Array.__name__ = ["Array"];
Date.prototype.__class__ = $hxClasses.Date = Date;
Date.__name__ = ["Date"];
var Int = $hxClasses.Int = { __name__ : ["Int"]};
var Dynamic = $hxClasses.Dynamic = { __name__ : ["Dynamic"]};
var Float = $hxClasses.Float = Number;
Float.__name__ = ["Float"];
var Bool = Boolean;
Bool.__ename__ = ["Bool"];
var Class = $hxClasses.Class = { __name__ : ["Class"]};
var Enum = { };
haxe_Resource.content = [{ name : "colorhilight.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "pixelate.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gdmVjMiBwaXhlbGFtb3VudDsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KDQp2b2lkIG1haW4oKSB7DQoJdmVjMiB1diA9IHZVdjsNCgl1di54ID0gZmxvb3IodXYueCpwaXhlbGFtb3VudC54KS9waXhlbGFtb3VudC54Ow0KCXV2LnkgPSBmbG9vcih1di55KnBpeGVsYW1vdW50LnkpL3BpeGVsYW1vdW50Lnk7DQoJdmVjNCBjID0gdGV4dHVyZTJEKHREaWZmdXNlLHV2KTsNCglnbF9GcmFnQ29sb3IgPSBjOw0KfQ0K"},{ name : "aspect.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gaW50IHR5cGU7DQp1bmlmb3JtIGZsb2F0IGFzcGVjdDsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KdW5pZm9ybSB2ZWMyIHJlc29sdXRpb247DQp1bmlmb3JtIHZlYzQgY29sb3I7DQoNCnZvaWQgbWFpbigpIHsNCglmbG9hdCBtcCA9IDAuMDsNCglmbG9hdCByZXNBc3BlY3QgPSByZXNvbHV0aW9uLngvcmVzb2x1dGlvbi55Ow0KCXZlYzIgdXYgPSB2VXY7DQoJCQ0KCS8vQmxhY2sgbGluZXMgbGVmdCBhbmQgcmlnaHQNCglpZihyZXNBc3BlY3QgPiBhc3BlY3QpDQoJew0KCQlmbG9hdCBkaWYgPSByZXNBc3BlY3QtYXNwZWN0Ow0KCQltcCA9IHV2LnggPiBkaWYvMi4gJiYgdXYueCA8IDEuLWRpZi8yLiA/IDAuIDogMS47DQoJfQ0KCWVsc2UNCgl7DQoJCS8vQmxhY2sgaW5lcyB0b3AgJiBib3R0b20NCgkJZmxvYXQgZGlmID0gYXNwZWN0LXJlc0FzcGVjdDsNCgkJbXAgPSB1di55ID4gZGlmLzIuICYmIHV2LnkgPCAxLi1kaWYvMi4gPyAwLiA6IDEuOw0KCQkNCgl9DQoJDQoJLy9UT0RPIC0gaW4gZmlsbCBjaGFuZ2UgdXYgYWxzby4gDQoJdmVjNCBjID0gbWl4KHRleHR1cmUyRCh0RGlmZnVzZSx1diksIGNvbG9yLG1wKTsNCg0KCWdsX0ZyYWdDb2xvciA9IGM7DQp9DQo"},{ name : "aspect.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "colorhilight.frag", data : "dW5pZm9ybSBmbG9hdCByYW5nZTsNCnVuaWZvcm0gZmxvYXQgdmFsdWUxOw0KdW5pZm9ybSBmbG9hdCB2YWx1ZTI7DQp1bmlmb3JtIGZsb2F0IG9yaWdpbmFsOw0KdW5pZm9ybSBmbG9hdCBhbW91bnQ7DQp1bmlmb3JtIHZlYzQgY29sb3IxOw0KdW5pZm9ybSB2ZWM0IGNvbG9yMjsNCnVuaWZvcm0gdmVjMiB0aWxlOw0KdW5pZm9ybSBzYW1wbGVyMkQgdERpZmZ1c2U7DQp2YXJ5aW5nIHZlYzIgdlV2Ow0KDQp2b2lkIG1haW4oKSB7DQoJdmVjMiB1diA9IHZVdjsNCgl2ZWM0IGMgPSB0ZXh0dXJlMkQodERpZmZ1c2UsdXYqdGlsZSk7DQoJDQoJLy9NYWtlIGNvbnRpbnVvdXMgdHJpYW5nbGUgZnVuY3Rpb24NCglmbG9hdCB2YWwxID0gdmFsdWUxKjIuOw0KCXZhbDEgPSB2YWwxIDwgMS4gPyB2YWwxIDogMi4tdmFsMTsNCglmbG9hdCB2YWwyID0gdmFsdWUyKjIuOw0KCXZhbDEgPSB2YWwyIDwgMS4gPyB2YWwyIDogMi4tdmFsMjsNCgkNCglmbG9hdCB0aW1lb2ZmMSA9IG1vZCh2YWwxLCAxLiArIHJhbmdlKTsNCglmbG9hdCB0aW1lb2ZmMiA9IG1vZCh2YWwyLCAxLiArIHJhbmdlKTsNCgkNCglmbG9hdCBtcDEgPSAoYWJzKGMuciAtIHRpbWVvZmYxKSA+IHJhbmdlKSA/IDEuIDogMC47DQoJZmxvYXQgbXAyID0gKGFicyhjLmcgLSB0aW1lb2ZmMikgPiByYW5nZSkgPyAxLiA6IDAuOw0KCQ0KCWZsb2F0IGF2ZyA9IChjLnIrYy5nK2MuYikvMy47DQoJdmVjNCBhZHMxID0gY29sb3IxICogYWJzKGF2ZyAtIHRpbWVvZmYxKTsNCgl2ZWM0IGFkczIgPSBjb2xvcjIgKiBhYnMoYXZnIC0gdGltZW9mZjIpOw0KCQ0KCXZlYzQgY29sID0gKDEuLSBtcDEpICogYWRzMSArICgxLiAtIG1wMikqYWRzMjsNCgkNCglnbF9GcmFnQ29sb3IgPSBjKm9yaWdpbmFsICsgY29sKmFtb3VudDsNCn0NCg"},{ name : "rgbshift.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "pixelate.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "gray.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KdW5pZm9ybSBmbG9hdCBncmF5Ow0KDQp2b2lkIG1haW4oKSB7DQoJdmVjMiB1diA9IHZVdjsNCgl2ZWM0IGMgPSB0ZXh0dXJlMkQodERpZmZ1c2UsdXYpOw0KCWZsb2F0IGdyID0gZG90KGMucmdiLCB2ZWMzKDAuMjk5LCAwLjU4NywgMC4xMTQpKTsNCiAgICB2ZWMzIGZjID0gbWl4KGMucmdiLCB2ZWMzKGdyKSwgZ3JheSk7DQoJZ2xfRnJhZ0NvbG9yID12ZWM0KGZjLDEuKTsNCn0NCg"},{ name : "vhs.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gZmxvYXQgaW50ZW5zaXR5Ow0KdW5pZm9ybSBmbG9hdCBqaXR0ZXI7DQp1bmlmb3JtIGZsb2F0IHNpemU7DQp1bmlmb3JtIHNhbXBsZXIyRCB0RGlmZnVzZTsNCnVuaWZvcm0gc2FtcGxlcjJEIHROb2lzZTsNCnVuaWZvcm0gZmxvYXQgdGltZTsNCnVuaWZvcm0gZmxvYXQgaG9sZFRpbWU7DQp1bmlmb3JtIGZsb2F0IGNvbG9yTm9pc2U7DQoNCmZsb2F0IHJhbmQodmVjMiBjbyl7DQogICAgcmV0dXJuIGZyYWN0KHNpbihkb3QoY28ueHkgLHZlYzIoMTIuOTg5OCw3OC4yMzMpKSkgKiA0Mzc1OC41NDUzKTsNCn0NCg0Kdm9pZCBtYWluKCkgew0KCXZlYzIgdXYgPSB2VXY7DQoJDQoJdXYueCArPSAocmFuZCh2ZWMyKHRpbWUqMC4xLCB1di55KjE5MjAuKSktMC41KSowLjAwOCpqaXR0ZXI7DQoJdXYueSArPSAocmFuZCh2ZWMyKHRpbWUpKS0wLjUpKjAuMDEqaml0dGVyOw0KCQ0KCXZlYzQgYmFzZSA9ICh2ZWM0KC0wLjUpK3ZlYzQocmFuZCh2ZWMyKHV2LnkqMTA4MC4sdGltZSkpLHJhbmQodmVjMigxMDgwLix0aW1lKzEuMCkpLHJhbmQodmVjMigxMDgwLix0aW1lKzIuMCkpLDApKSowLjEqY29sb3JOb2lzZTsNCgliYXNlICs9IHRleHR1cmUyRCh0RGlmZnVzZSx1dik7DQoJZmxvYXQgbm9pc2UgPSB0ZXh0dXJlMkQodE5vaXNlLHV2K3ZlYzIodGltZSx0aW1lKjAuMSkpLnI7DQoJDQoJaWYoKG5vaXNlKm1vZCh1di55ICsgaG9sZFRpbWUqMC4yLCAxLikgPiBzaXplKSB8fCANCgkJKG5vaXNlKm1vZCh1di55ICsgKGhvbGRUaW1lKzEuNSkqMC4yLCAxLikgPiBzaXplKSB8fA0KCQkobm9pc2UqbW9kKHV2LnkgKyAoaG9sZFRpbWUrMy4pKjAuMiwgMS4pID4gc2l6ZSkpIGJhc2UrPXZlYzQoMS4pKmludGVuc2l0eTsNCgkNCgkNCglnbF9GcmFnQ29sb3IgPSBiYXNlOw0KfQ0K"},{ name : "standard.frag", data : "dW5pZm9ybSBmbG9hdCBicmlnaHRuZXNzOw0KdW5pZm9ybSBmbG9hdCBnYW1tYTsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KdmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzIgdXYgPSB2VXY7DQoJdmVjNCBjID0gdGV4dHVyZTJEKHREaWZmdXNlLHV2KTsNCgljID0gcG93KGMsIHZlYzQoMS4wL2dhbW1hKSk7DQoJYys9YnJpZ2h0bmVzczsNCglnbF9GcmFnQ29sb3IgPSBjOw0KfQ"},{ name : "cga.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gZmxvYXQgYW1vdW50Ow0KdW5pZm9ybSBzYW1wbGVyMkQgdERpZmZ1c2U7DQp1bmlmb3JtIHZlYzIgcmVzb2x1dGlvbjsNCg0KdW5pZm9ybSB2ZWMzIGNvbG9yc1sxNl07DQoNCnZvaWQgbWFpbigpIHsNCgl2ZWMyIHV2ID0gdlV2Ow0KCXZlYzQgYyA9IHRleHR1cmUyRCh0RGlmZnVzZSx1dik7DQoJZmxvYXQgY2xvc2VzdCA9IDk5OTk5LjsNCiAgICB2ZWMzIHNlbGVjdGVkPXZlYzMoMC4pOw0KICAgIGZvcihpbnQgaSA9IDA7IGkgPCAxNjsgaSsrKQ0KICAgIHsNCiAgICAgICAgZmxvYXQgZCA9IGRpc3RhbmNlKGNvbG9yc1tpXSwgYy5yZ2IpOw0KICAgICAgICBpZihjbG9zZXN0ID4gZCkNCiAgICAgICAgew0KICAgICAgICAgCWNsb3Nlc3QgPSBkOw0KICAgICAgICAgICAgc2VsZWN0ZWQgPSBjb2xvcnNbaV07DQogICAgICAgIH0NCiAgICB9DQoJZ2xfRnJhZ0NvbG9yID0gbWl4KGMsdmVjNChzZWxlY3RlZCwxLiksIGFtb3VudCk7DQp9DQo"},{ name : "rgbshift.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gZmxvYXQgcnNoaWZ0Ow0KdW5pZm9ybSBmbG9hdCBnc2hpZnQ7DQp1bmlmb3JtIGZsb2F0IGJzaGlmdDsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KDQp2b2lkIG1haW4oKSB7DQoJdmVjNCBjID0gdGV4dHVyZTJEKHREaWZmdXNlLHZVdik7DQoJZmxvYXQgcm8gPSB0ZXh0dXJlMkQodERpZmZ1c2UsdmVjMih2VXYueC1yc2hpZnQsIHZVdi55KSkucjsNCglmbG9hdCBnbyA9IHRleHR1cmUyRCh0RGlmZnVzZSx2ZWMyKHZVdi54LWdzaGlmdCwgdlV2LnkpKS5nOw0KCWZsb2F0IGJvID0gdGV4dHVyZTJEKHREaWZmdXNlLHZlYzIodlV2LngtYnNoaWZ0LCB2VXYueSkpLmI7DQoJZ2xfRnJhZ0NvbG9yID0gdmVjNChybywgZ28sIGJvLCBjLncpOw0KfQ"},{ name : "dof.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ0KICAgIA"},{ name : "gray.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "dof.frag", data : "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"},{ name : "Demo.json", data : "ew0KCSJuYW1lIjogIkN5bGluZGVycyIsDQoJInRpbWVsaW5lIiA6IFsNCgkJew0KCQkJInBhcnRJZCI6ICJJbnRybyIsDQoJCQkidHlwZSI6ICJpbnRyby5JbnRybyIsDQoJCQkicmVuZGVyVG9TY3JlZW4iOiB0cnVlLA0KCQkJInJ1bk9uIjogWzAsMCwwLDBdLA0KCQkJInJ1bk9mZiI6IFs4LDAsMCwwXSwNCgkJCSJleHRyYSI6IiIsDQoJCQkiZm9yY2VOZXdQYXJ0IjogZmFsc2UNCgkJfSwNCgkJew0KCQkJInBhcnRJZCI6ICJDeWxpbmRlcnMiLA0KCQkJInR5cGUiOiAiY3lsaW5kZXJzLkN5bGluZGVycyIsDQoJCQkicmVuZGVyVG9TY3JlZW4iOiB0cnVlLA0KCQkJInJ1bk9uIjogWzgsMCwwLDBdLA0KCQkJInJ1bk9mZiI6IFsyMCwwLDAsMF0sDQoJCQkiZXh0cmEiOiIiLA0KCQkJImZvcmNlTmV3UGFydCI6IGZhbHNlDQoJCX0sDQoJCXsNCgkJCSJwYXJ0SWQiOiAiQ3lsaW5kZXJzIGxpZ2h0cyIsDQoJCQkidHlwZSI6ICJjeWxsaWdodHMuQ3lsaW5kZXJMaWdodHMiLA0KCQkJInJlbmRlclRvU2NyZWVuIjogdHJ1ZSwNCgkJCSJydW5PbiI6IFsyMCwwLDAsMF0sDQoJCQkicnVuT2ZmIjogWzI4LDAsMCwwXSwNCgkJCSJleHRyYSI6IiIsDQoJCQkiZm9yY2VOZXdQYXJ0IjogZmFsc2UNCgkJfSwNCgkJew0KCQkJInBhcnRJZCI6ICJ2b3J0ZXgiLA0KCQkJInR5cGUiOiAidm9ydGV4LlZvcnRleCIsDQoJCQkicmVuZGVyVG9TY3JlZW4iOiB0cnVlLA0KCQkJInJ1bk9uIjogWzI4LDAsMCwwXSwNCgkJCSJydW5PZmYiOiBbNDgsMCwwLDBdLA0KCQkJImV4dHJhIjoiIiwNCgkJCSJmb3JjZU5ld1BhcnQiOiBmYWxzZQ0KCQl9DQoJCQ0KCV0sDQoJImF1ZGlvIjogew0KCQkiYmVhdHNQZXJNaW51dGUiOiA3NiwNCgkJImJlYXRzUGVyQmFyIiA6IDQsDQoJCSJ0aWNrc1BlckJlYXQiOiAxMiwNCgkJIm11c2ljQmVnaW4iOiA1MDAsDQoJCSJzb25nUGF0aCI6ICJtdXNpYy5tcDMiLA0KCQkiZW5hYmxlRkZUIjogdHJ1ZQ0KCX0sDQoJInZpc3VhbCI6IHsNCgkJInRhcmdldEZwcyI6IC0xLA0KCQkicmVzb2x1dGlvbiI6IFsxMjgwLDcyMF0sDQoJCSJhbnRpQWxpYXMiOiB0cnVlLA0KCQkiZW5hYmxlU2hhZG93cyI6IHRydWUsDQoJCSJjbGVhckNvbG9yIjogMCwNCgkJInNoYWRvd01hcFNpemUiOlsyMDQ4LDIwNDhdDQoJfQ0KfQ"},{ name : "cga.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "distortedTv.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "standard.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "displacement.frag", data : "dW5pZm9ybSBmbG9hdCBzY2FsZVg7DQp1bmlmb3JtIGZsb2F0IHNjYWxlWTsNCnVuaWZvcm0gZmxvYXQgem9vbTsNCnVuaWZvcm0gdmVjMiBvZmZzZXQ7DQp1bmlmb3JtIHNhbXBsZXIyRCB0RGlmZnVzZTsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaXNwTWFwOw0KdmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzIgdXYgPSB2VXY7DQoJdmVjNCBjZCA9IHRleHR1cmUyRCh0RGlzcE1hcCwodXYrb2Zmc2V0KSp6b29tKTsNCgkNCgkvL2NhbGN1bGF0ZSBvZmZzZXQNCgl2ZWMyIG9mZnNldCA9dmVjMiggY2QuciAqIHNjYWxlWCwgY2QuZypzY2FsZVkpIC0gdmVjMihzY2FsZVgqMC41LHNjYWxlWSowLjUpOw0KCQ0KCXZlYzQgYyA9IHRleHR1cmUyRCh0RGlmZnVzZSx1ditvZmZzZXQpOw0KCQ0KCWdsX0ZyYWdDb2xvciA9IGM7DQp9DQo"},{ name : "distortedTv.frag", data : "dW5pZm9ybSBmbG9hdCBkaXN0b3J0QW1vdW50Ow0KdW5pZm9ybSBzYW1wbGVyMkQgdERpZmZ1c2U7DQp1bmlmb3JtIGZsb2F0IHRpbWU7DQp1bmlmb3JtIGZsb2F0IGdyZWVuYW1wbGlmeTsNCnVuaWZvcm0gZmxvYXQgYmx1ZWFtcGxpZnk7DQp1bmlmb3JtIGZsb2F0IHZpZ25BbW91bnQ7DQp1bmlmb3JtIGZsb2F0IG9mZnNldEFtb3VudDsNCnVuaWZvcm0gZmxvYXQgYnJpZ2h0TXVsdGlwbGllcjsNCnVuaWZvcm0gZmxvYXQgYnJpZ2h0TGltaXQ7DQp2YXJ5aW5nIHZlYzIgdlV2Ow0KDQp2b2lkIG1haW4oKQ0Kew0KCXZlYzIgdXYgPSB2VXY7DQogICAgZmxvYXQgb2Zmc2V0ID0gbW9kKGNlaWwodXYueSpkaXN0b3J0QW1vdW50K3RpbWUpKnRpbWUsMC4wMTIpOw0KICAgIHZlYzQgdENvbG9yID0gdGV4dHVyZTJEKHREaWZmdXNlLHZlYzIodXYueCtvZmZzZXRBbW91bnQqb2Zmc2V0LHV2LnkpKTsNCiAgICB0Q29sb3IuZyAqPSBncmVlbmFtcGxpZnk7DQogICAgdENvbG9yLmIgKj0gYmx1ZWFtcGxpZnk7DQogICAgZmxvYXQgdmlnbiA9IDEuMC1sZW5ndGgodmVjMigwLjUsMC41KS11dikqdmlnbkFtb3VudDsNCiAgICANCgl2ZWMzIGJyaWdodG5lc3MgPSB0Q29sb3IucmdiOw0KCXZlYzMgbXAgPSB2ZWMzKDEuKS1zbW9vdGhzdGVwKHZlYzMoYnJpZ2h0TGltaXQpLCB2ZWMzKDEuKSwgYnJpZ2h0bmVzcykqYnJpZ2h0TXVsdGlwbGllcjsNCgl0Q29sb3IqPXZlYzQobXAsMS4pOw0KCQ0KICAgIHRDb2xvciAqPSB2aWduOw0KCWdsX0ZyYWdDb2xvciA9IHRDb2xvcjsNCn0"},{ name : "displacement.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "vhs.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"}];
var __map_reserved = {}
var ArrayBuffer = $global.ArrayBuffer || js_html_compat_ArrayBuffer;
if(ArrayBuffer.prototype.slice == null) {
	ArrayBuffer.prototype.slice = js_html_compat_ArrayBuffer.sliceImpl;
}
var Float32Array = $global.Float32Array || js_html_compat_Float32Array._new;
var Uint8Array = $global.Uint8Array || js_html_compat_Uint8Array._new;
DemoMain.DEMO_READY = new wl_core_Signal();
DemoMain.COLOR1 = new THREE.Color(83315);
DemoMain.COLOR2 = new THREE.Color(3508389);
DemoMain.COLOR3 = new THREE.Color(12310960);
DemoMain.COLOR4 = new THREE.Color(16108554);
DemoMain.COLOR5 = new THREE.Color(15747853);
DemoMain.HILIGHT = new THREE.Color(15219237);
DemoMain.LIGHT = new THREE.Color(16771491);
DemoMain.GREEN = new THREE.Color(2503240);
DemoMain.BLUE = new THREE.Color(17763);
DemoMain.BLUE_DARK = new THREE.Color(1645352);
DemoMain.WHITE = new THREE.Color(16777215);
DemoMain.BLACK = new THREE.Color(0);
DemoMain.historyind = 0;
cylball_CylinderBall.WIDTH = 40;
cylball_CylinderBall.HEIGHT = 40;
cylinders_Cylinder.WHITEMAT = new THREE.MeshBasicMaterial({ color : DemoMain.WHITE.getHex()});
cylinders_Cylinders.WIDTH = 40;
cylinders_Cylinders.HEIGHT = 40;
cyllight_CylLight.HEIGHT = 6;
cyllight_CylLightTester.HEIGHT = 6;
haxe_crypto_Base64.CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
haxe_crypto_Base64.BYTES = haxe_io_Bytes.ofString(haxe_crypto_Base64.CHARS);
haxe_ds_ObjectMap.count = 0;
js_Boot.__toStr = { }.toString;
js_html_compat_Float32Array.BYTES_PER_ELEMENT = 4;
js_html_compat_Uint8Array.BYTES_PER_ELEMENT = 1;
vortex_VortexCylinder.MOVEMENTSPEED = 1;
vortex_VortexCylinder.MAX = new THREE.Vector3();
vortex_VortexCylinder.MIN = new THREE.Vector3();
wl_core_Assets._assets = new haxe_ds_StringMap();
wl_core_Config.BEATS_PER_MINUTE = 104;
wl_core_Config.BEATS_PER_BAR = 4;
wl_core_Config.TICKS_PER_BEAT = 12;
wl_core_Config.MUSIC_BEGIN = 500;
wl_core_Config.SONG_PATH = "bg.ogg";
wl_core_Config.ENABLE_FFT = false;
wl_core_Config.MUTED = false;
wl_core_Config.FPS = 24;
wl_core_Config.RESOLUTION = [1280,720];
wl_core_Config.RATIO = 1.7777777777777777;
wl_core_Config.ANTIALIAS = true;
wl_core_Config.ENABLE_SHADOWS = false;
wl_core_Config.CLEAR_COLOR = 0;
wl_core_Config.SHADOW_MAP_SIZE = [512,512];
wl_core_Config.SEED = 123;
wl_core_Config.DEBUG = false;
wl_core_Config.TIMELINE = [];
wl_core_TimeSig.ABSOLUTE = "absolute";
wl_core_TimeSig.RELATIVE = "relative";
wl_core_TimeSig.PATTERN = "pattern";
wl_debug_Debug.paused = false;
wl_debug_Debug.usedFolderNames = [];
wl_debug_ManualControl.parts = [];
wl_debug_ManualControl.storedPoints = [];
wl_debug_ManualControl.fpsControls = [];
wl_demo_CameraController.STOPPED = false;
wl_demo_CameraController.STATIC = "static";
wl_demo_CameraController.LINEAR = "linear";
wl_demo_CameraController.BEZIER = "bezier";
wl_demo_CameraController.FOLLOW = "follow";
wl_post_aspect_Aspect.CROP = 0;
wl_post_aspect_Aspect.FILL = 1;
wl_post_bloom_Bloom.BlurDirectionX = new THREE.Vector2(1.0,0.0);
wl_post_bloom_Bloom.BlurDirectionY = new THREE.Vector2(0.0,1.0);
wl_sounds_SoundWL.FFT_PRECISION = 1024;
wl_sounds_SoundWL.onSoundLoaded = new wl_core_Signal();
wl_sounds_SoundWL.onSoundComplete = new wl_core_Signal();
wl_sounds_SoundWL.onSoundReady = new wl_core_Signal();
wl_sounds_SoundWL.time = new wl_core_TimeSig();
wl_sounds_SoundWL.volume = 1;
wl_sounds_SoundWL.startTime = 0;
wl_sounds_SoundWL.loaded = false;
wl_sounds_SoundWL.lastFFT = 0;
wl_sounds_SoundWL.FFT = { dbLeft : null, frequencyLeft : null, waveformLeft : null, dbRight : null, frequencyRight : null, waveformRight : null, fftsize : 1024, sampleRate : 44100};
wl_util_LoadManager._totalCount = 0;
wl_util_LoadManager.loadingManager = new THREE.LoadingManager(wl_util_LoadManager.onload,wl_util_LoadManager.onprogress,wl_util_LoadManager.onerror);
wl_util_LoadManager.loadersWaiting = [];
wl_util_LoadManager.managerDone = false;
wl_util_Random.instance = new wl_util_Random(123);
wl_util_VectorUtil.ZeroVector = new THREE.Vector3();
Main.main();
})(typeof exports != "undefined" ? exports : typeof window != "undefined" ? window : typeof self != "undefined" ? self : this, typeof window != "undefined" ? window : typeof global != "undefined" ? global : typeof self != "undefined" ? self : this);
