import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import ddf.minim.*; 
import ddf.minim.analysis.*; 
import ddf.minim.effects.*; 
import ddf.minim.signals.*; 
import ddf.minim.spi.*; 
import ddf.minim.ugens.*; 
import moonlander.library.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class cloud extends PApplet {

//
// Happy clouds over the sea.
//

// A demo for Skrolli Party 2018
// By Muffintrap
// Created with Processing 3.4

// Palette by  StarlitSunset
// http://pixeljoint.com/pixels/profile.asp?fid=160561

// Font by Devin Cook
// https://www.dafont.com/commodore-64.font










class Greeting {
    PVector position;
    PVector velocity;
    ArrayList<Letter> letters;

    public void draw(float time, float time_spacing, PVector gravity) {
        float time_left = time;
        // check if need to draw at all
        float last_time = time_left - (letters.size() -1) * time_spacing;
        if (last_time > 0.0f && get_pos_at(last_time, gravity).y > greeting_start.y + letter_cube_scale) {
            return;
        }
        for(int letter_index = 0; letter_index < letters.size() && time_left > 0.0f; letter_index++) {
            letters.get(letter_index).draw(get_pos_at(time_left, gravity));
            time_left -= time_spacing;
        }
    }

    public PVector get_pos_at(float time, PVector gravity) {
        // p1 = p0 +  v0 * t + a0 * t^2
        PVector grav_now = PVector.mult(gravity, time * time);
        PVector velo_now = PVector.mult(velocity, time);
        PVector pos_now = PVector.add(position, PVector.add(velo_now, grav_now));
        return pos_now;
    }
}

class Letter {
    PShape model;

    Letter(PShape model_param) {
        model = model_param;
    }

    public void draw(PVector position) {
        pushMatrix();
        translate(position.x,  position.y, position.z);
        rotateX(greeting_rot_x);
        rotateY(greeting_rot_y);
        rotateZ(greeting_rot_z);
        scale(letter_cube_scale);
        noStroke();
        shape(model);
        popMatrix();
    }
}

class Sea {
    int wave_amount = 120;
    PVector position;
    Wave[] waves;

    Sea() {
        position = new PVector(width/2, height/2 + height / 14, 100);
        waves = new Wave[wave_amount];
        for (int i = 0; i < wave_amount; i++) {
            waves[i] = new Wave(position, width, sea_scale);
            }

    }
    // Sea and waves
    public void draw() {
        pushMatrix();
        translate(position.x, position.y, position.z);

        scale(sea_scale);
        specular(sun_color.x, sun_color.y, sun_color.z);
        shininess(15.0f);
        shape(sea_quad);
        popMatrix();

        for (int i = 0; i < wave_amount; i++) {
            waves[i].draw(sea_color);
            }
    }

    public void update(PVector wind_dir) {
        PVector wind_flat = wind_dir.copy();
        wind_flat.y = 0.0f;
        for (int i = 0; i < wave_amount; i++) {
            waves[i].update(wind_flat);
        }
    }
}

class Wave {
    // Wave is triangle that travels over sea
    PVector position;
    float max_height = 8.0f;
    float max_width = 40.0f;
    float change_counter = 0.0f;
    float change_time = 1.0f;
    float change_speed = 0.1f;
    float change_ratio = 0.0f;

    PVector sea_pos;
    float screen_width;
    float sea_depth;
    Wave(PVector sea_pos_P, float screen_width_P, float sea_depth_P) {
        sea_pos = sea_pos_P;
        screen_width = screen_width_P;
        sea_depth = sea_depth_P;
        reset();
    }
    public void reset()
    {
        position = new PVector(sea_pos.x + random(-screen_width, screen_width), sea_pos.y + 0, sea_pos.z + random(-sea_depth, sea_depth));
        change_time = random(8, 16);
        change_counter = 0.0f;
        change_speed = random(0.1f, 0.3f);
    }
    public void draw(int sea_color) {
        if (change_ratio >= 0.0f) {
            float width = change_ratio * max_width;
            beginShape(TRIANGLES);
            fill(lerpColor(sea_color, color(255, 255, 255), change_ratio));
            normal(0, 0.5f, 0.5f);
            vertex(position.x, position.y, position.z);
            vertex(position.x + (width * 0.5f) - change_ratio * (width * 0.45f), position.y - change_ratio * max_height, position.z );
            vertex(position.x + width, position.y, position.z);
            endShape();
        }
    }

    public void update(PVector wind_dir) {
        position.add(wind_dir);
        change_counter += change_speed;
        change_ratio = (change_counter / change_time);
        if (change_counter > change_time) {
            change_speed *= -1.0f;
            change_counter = change_time;
            }
        else if (change_counter < 0) {
                reset();
            }
    }
}

class Cloud {
    int ball_amount;
    Cloud_ball[] balls;
    PVector position;
    Cloud(int ball_amount_param, PVector position_param) {
        ball_amount = ball_amount_param;
        balls = new Cloud_ball[ball_amount];

        position = position_param.copy();

        PVector prev_pos = position.copy();
        float prev_radius = 1;
        for(int i = 0; i < ball_amount; i++) {
            if (i > 0) {
                prev_pos = balls[i-1].position.copy();
                prev_radius = balls[i-1].get_radius();
            }
            balls[i] = new Cloud_ball(prev_pos, prev_radius);
        }
    }

    public void draw()
    {
        stroke(air_color.x, air_color.y, air_color.z, cloud_stroke_alpha );
        strokeWeight(1);
        fill(255);
        for(int i = 0; i < ball_amount; i++) {
            balls[i].draw(position);
        }

    }
    public void draw_face()
    {
        // Happy face!
        hint(DISABLE_DEPTH_MASK);
        noFill();
        stroke(0);
        float sixth_pi = PI / 6.0f;
        arc(position.x + 10, position.y, to_size(0.04f), to_size(0.04f), sixth_pi, PI - sixth_pi);
        fill(0);
        strokeWeight(2);
        ellipse(position.x, position.y - to_size(0.04f), to_size(0.01f), to_size(0.02f));
        ellipse(position.x + to_size(0.04f), position.y - to_size(0.04f), to_size(0.01f), to_size(0.02f));
        hint(ENABLE_DEPTH_MASK);
    }

    public void update(PVector wind_direction) {
        PVector movement = PVector.mult(wind_direction, cloud_speed);
        position.add(movement);
        for(int i = 0; i < ball_amount; i++) {
            PVector ball_move = movement.copy();
            ball_move.mult(1.0f - balls[i].size / cloud_radius_max);
            balls[i].position.add(ball_move);
        }
    }
}

class Cloud_ball {
  PVector position;
  float size;

    Cloud_ball(PVector prev_ball_pos, float prev_radius) {
        PVector direction = PVector.random3D();
        position = direction.mult(prev_radius);
        size = random(cloud_radius_min, cloud_radius_max);
  }

    // When getting further from parent ball, make size smaller

  public void draw(PVector cloud_position) {
      pushMatrix();
      translate(cloud_position.x + position.x, cloud_position.y + position.y, cloud_position.z + position.z);
      sphere(size);
      popMatrix();
  }

    public float get_radius() {
        return sqrt(size * size) / 2.0f;
    }
}

// Creators /////////////////////////////////////////////////////////////////

public Greeting create_greeting(String text, PFont font_object) {
    Greeting greeting = new Greeting();
    greeting.position = greeting_start.copy();
    greeting.position.x += random(greeting_x_min, greeting_x_max);
    greeting.position.z += random(greeting_z_min, greeting_z_max);
    greeting.velocity = greeting_velocity;
    greeting.letters = new ArrayList<Letter>();
    int cube_color = palette[PApplet.parseInt(random(palette_size))];
    for (int character = 0; character < text.length(); character++) {
        greeting.letters.add(new Letter(create_text_cube(text.charAt(character), cube_color, greeting_font)));
    }
    return greeting;
}

public PShape create_text_cube(char text, int cube_color, PFont font_object){
    int uv_w  = greeting_texture_width;
    int uv_h  = greeting_texture_height;
    PGraphics font_buffer = createGraphics(greeting_texture_width, greeting_texture_height);

    font_buffer.beginDraw();
    font_buffer.background(cube_color);
    font_buffer.fill(greeting_letter_color);
    font_buffer.textFont(font_object);
    font_buffer.textAlign(CENTER, CENTER);
    font_buffer.text(text, greeting_texture_width / 2, greeting_texture_height / 2);
    font_buffer.endDraw();

    greeting_cube = createShape();
    greeting_cube.beginShape(QUAD);
    greeting_cube.texture(font_buffer);

    float p = 1;
    float m = -1;
    // -z
    greeting_cube.normal(0, 0, -1);
    greeting_cube.vertex( p, p, -1, uv_w, uv_h);
    greeting_cube.vertex( p, m, -1, uv_w, 0);
    greeting_cube.vertex( m, m, -1, 0, 0);
    greeting_cube.vertex( m, p, -1, 0, uv_h);
    // +z
    greeting_cube.normal(0, 0, 1);
    greeting_cube.vertex(p, p, 1, uv_w, uv_h);
    greeting_cube.vertex(p, m, 1, uv_w, 0);
    greeting_cube.vertex(m, m, 1, 0, 0);
    greeting_cube.vertex(m, p, 1, 0, uv_h);
    // -y
    greeting_cube.normal(0, -1, 0);
    greeting_cube.vertex( p, -1, p, uv_w, uv_h);
    greeting_cube.vertex( p, -1, m, uv_w, 0);
    greeting_cube.vertex( m, -1, m, 0, 0);
    greeting_cube.vertex( m, -1, p, 0, uv_h);
    // +y
    greeting_cube.normal(0, 1, 0);
    greeting_cube.vertex(p, 1, p, uv_w, uv_h);
    greeting_cube.vertex(p, 1, m, uv_w, 0);
    greeting_cube.vertex(m, 1, m, 0, 0);
    greeting_cube.vertex(m, 1, p, 0, uv_h);
    // -x
    greeting_cube.normal(-1, 0, 0);
    greeting_cube.vertex(-1, p, p, uv_w, uv_h);
    greeting_cube.vertex(-1, p, m, uv_w, 0);
    greeting_cube.vertex(-1, m, m, 0, 0);
    greeting_cube.vertex(-1, m, p, 0, uv_h);

    // +x
    greeting_cube.normal(1, 0, 0);
    greeting_cube.vertex(1 ,p, p, uv_w, uv_h);
    greeting_cube.vertex(1, p, m, uv_w, 0);
    greeting_cube.vertex(1, m, m, 0, 0);
    greeting_cube.vertex(1, m, p, 0, uv_h);

    greeting_cube.endShape();

    return greeting_cube;
}

// Processing functions /////////////////////////////////////////////////////

// Timing
Moonlander moonlander;
float time_now = 0.0f;
float demo_duration = 69;
float demo_progress = 0.0f;
int frame_rate = 60;

int palette_size = 15;
int[] palette;

Cloud[] clouds;
int cloud_amount = 8;
float cloud_stroke_alpha = 0.8f;
float cloud_radius_max = 0.0f;
float cloud_radius_min =  0.0f;
float cloud_speed = 0.45f;

int blue_sky = 0;
int sea_color = 0;
PVector wind = new PVector(-1, -0.3f, 0);

Sea blue_sea;
PShape sea_quad;
float sea_angle = 0.0f;
int sea_scale = width;

PVector sun_color = new PVector(200, 200, 180);
PVector sun_dir = new PVector(0.3f, 1, 0);
PVector air_color = new PVector(200, 200, 200);

float gravity_y = 0;
PVector gravity;

PGraphics font_buffer;
boolean font_buffer_written = false;
PFont greeting_font;
PShape greeting_cube;
int greeting_back_color = color(100, 240, 140);
int greeting_letter_color = color(10, 10, 10);
int greeting_texture_width = 200;
int greeting_texture_height = 200;
int letter_cube_scale = 0;
float letter_velo_x = 0;
float letter_velo_y = 0;
float letter_velo_z = 0;
PVector greeting_velocity;
PVector greeting_start;

float greeting_z_min;
float greeting_z_max;
float greeting_x_max;
float greeting_x_min;
float greeting_rot_x;
float greeting_rot_y;
float greeting_rot_z;

ArrayList<Greeting> greetings;

public int to_size(float ratio)
{
    return PApplet.parseInt(ratio * height);
}
public void setup() {
    //size(960, 540, P3D);
    
    //int width = 960;
    //int height = 540;

    randomSeed(665);

    frameRate(60);
    sun_dir.normalize();
    wind.normalize();

    gravity_y = to_size(0.068f);
    gravity = new PVector(0, gravity_y, 0);

    cloud_radius_max = to_size(0.18f); 
    cloud_radius_min = to_size(0.12f); 

    letter_cube_scale = to_size(0.02f);
    letter_velo_x = -to_size(0.16f);
    letter_velo_y = -to_size(0.26f);
    letter_velo_z = to_size(0.00f);
    greeting_velocity = new PVector(letter_velo_x, letter_velo_y, letter_velo_z);
    greeting_start = new PVector(width * 0.7f, height * 0.6f , 40);
    greeting_z_min = 30;
    greeting_z_max = 60;
    greeting_x_max = to_size(0.1f);
    greeting_x_min = -to_size(0.4f);
    letter_cube_scale = to_size(0.03f);

    greeting_rot_x = 0.0f;
    greeting_rot_y = 0.0f;
    greeting_rot_z = 0.0f;

    sea_scale = PApplet.parseInt(width * 1.7f);

    palette = new int[palette_size];
    palette[0] = 0xfffc9977;
    palette[1] = 0xfffcbd90;
    palette[2] = 0xfffae6aa;
    palette[3] = 0xffa3d96a;
    palette[4] = 0xff80d99b;
    palette[5] = 0xff57cfc9;
    palette[6] = 0xff51c0db;
    palette[7] = 0xff70a5d4;
    palette[8] = 0xff6d74cf;
    palette[9] = 0xff584478;
    palette[10] = 0xff8459c9;
    palette[11] = 0xffbe57c2;
    palette[12] = 0xffde76a5;
    palette[13] = 0xfffff7d5;
    palette[14] = 0xfff7f6a6;

    blue_sky = palette[6];
    sea_color = palette[7];

    clouds = new Cloud[cloud_amount];
    for (int i = 0; i < cloud_amount; i++) {
        float cloud_x = random(width * 1.5f);
        PVector cloud_position = new PVector( cloud_x
                                             , random(-height * 0.01f, height * 0.45f)
                                             , -250);
        clouds[i] = new Cloud(10, cloud_position);
    }
    sphereDetail(16);

    blue_sea = new Sea();

    sea_quad = createShape();
    sea_quad.beginShape(TRIANGLES);
    sea_quad.fill(sea_color);
    sea_quad.noStroke();
    sea_quad.normal(0.0f, 1.0f, 0.0f);
    sea_quad.vertex(-1.0f, 0.0f, -1.0f);
    sea_quad.vertex(1.0f, 0.0f, -1.0f);
    sea_quad.vertex(1.0f, 0.0f, 1.0f);

    sea_quad.vertex(-1.0f, 0.0f, 1.0f);
    sea_quad.vertex(-1.0f, 0.0f, -1.0f);
    sea_quad.vertex(1.0f, 0.0f, 1.0f);

    sea_quad.endShape();

    // Greetings cubes
    greeting_font = createFont("Commodore 64", 120);

    // Array of greetings
    // Each greeting modifies the greeting_buffer before drawing itself
    // if that greeting is active, aka on the screen.
    greetings = new ArrayList<Greeting>();
    greetings.add(create_greeting("HELLO", greeting_font));
    greetings.add(create_greeting("SKROLLI", greeting_font));
    greetings.add(create_greeting("PARTY", greeting_font));
    greetings.add(create_greeting("GREETINGS", greeting_font));
    greetings.add(create_greeting("TO", greeting_font));
    greetings.add(create_greeting("WINDYTAN", greeting_font));
    greetings.add(create_greeting("BASSCADET", greeting_font));
    greetings.add(create_greeting("TJO", greeting_font));
    greetings.add(create_greeting("FROST", greeting_font));
    greetings.add(create_greeting("QMA", greeting_font));
    greetings.add(create_greeting("NINNNU", greeting_font));
    greetings.add(create_greeting("NAME", greeting_font));
    greetings.add(create_greeting("VALHE", greeting_font));

    moonlander = Moonlander.initWithSoundtrack(this, "cloud_song.mp3", 163, 1);
    moonlander.start();
}

public float sync(String name)
{
    return (float)moonlander.getValue(name);
}

public void draw() {
    moonlander.update();
    demo_progress = sync("progress");
    time_now = demo_progress * demo_duration;
    // time_now = millis() / 1000.0f;
    
    perspective();


    float sun_x = sync("sun_x");
    float sun_y = sync("sun_y");
    float sun_z = sync("sun_z");

    sun_dir = new PVector(sun_x, sun_y, sun_z);
    sun_dir.normalize();
    
    float sun_r = sync("sun_r");
    float sun_g = sync("sun_g");
    float sun_b = sync("sun_b");

    float air_r = sync("air_r");
    float air_g = sync("air_g");
    float air_b = sync("air_b");
    

    sun_color = new PVector(255 * sun_r, 255 * sun_g, 255 * sun_b);
    air_color = new PVector(255 * air_r, 255 * air_g, 255 * air_b);

    float sky_r = sync("sky_r");
    float sky_g = sync("sky_g");
    float sky_b = sync("sky_b");

    int back_color = color(255 * sky_r, 255 * sky_g, 255 * sky_b);
    background(back_color);
    directionalLight(sun_color.x, sun_color.y, sun_color.z, sun_dir.x, sun_dir.y, sun_dir.z);
    lightSpecular(sun_color.x, sun_color.y, sun_color.z);
    ambientLight(air_color.x, air_color.y, air_color.z);

    cloud_speed = sync("cloud_speed");

    // happy little clouds
    for (int i = 0; i < cloud_amount; i++) {
        clouds[i].update(wind);
        clouds[i].draw();

        if (clouds[i].position.x + cloud_radius_max * 2.0f < 0) {
            clouds[i] = new Cloud(10, new PVector(width + cloud_radius_max
            , random(height * 0.1f, height * 0.45f), -250));
        }
    }

    // Sparkling sea
    // sea_angle += 0.01f;
    blue_sea.update(wind);
    blue_sea.draw();

    // Greetings
    letter_cube_scale = to_size(sync("letter_scale"));
    greeting_rot_x = sync("rot_x");
    greeting_rot_y = sync("rot_y");
    greeting_rot_z = sync("rot_z");
    if (greeting_rot_x > TWO_PI) {
        greeting_rot_x -= TWO_PI;
    }
    if (greeting_rot_y > TWO_PI) {
        greeting_rot_y -= TWO_PI;
    }
    if (greeting_rot_z > TWO_PI) {
        greeting_rot_z -= TWO_PI;
    }
    float greet_delay = sync("greet_delay");
    float greet_timer = time_now - greet_delay;
    float time_between_greets = sync("greet_gap");
    float time_between_letters = sync("letter_gap");
    for (int g= 0; g < greetings.size() && greet_timer > 0.0f; g++) {
        greetings.get(g).draw(greet_timer, time_between_letters, gravity);
        int letters_went = greetings.get(g).letters.size();
        greet_timer -= time_between_greets + (time_between_letters * letters_went);
    }

    // Faces of clouds
    for (int i = 0; i < cloud_amount; i++) {
        clouds[i].draw_face();
    }
   
    if (demo_progress >= 1.0f) {
      exit();
    }
}
  public void settings() {  fullScreen(P3D); }
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "cloud" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
