/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitVariablePort;
import com.jsyn.unitgen.UnitFilter;

public class LinearRamp
extends UnitFilter {
    public UnitInputPort time = new UnitInputPort("Time");
    public UnitVariablePort current;
    private double source;
    private double phase;
    private double target;
    private double timeHeld = 0.0;
    private double rate = 1.0;

    public LinearRamp() {
        this.addPort(this.time);
        this.current = new UnitVariablePort("Current");
        this.addPort(this.current);
    }

    @Override
    public void generate(int n, int n2) {
        double[] dArray = this.output.getValues();
        double d = this.input.getValues()[0];
        double d2 = this.current.getValue();
        if (d != this.target) {
            this.source = d2;
            this.phase = 0.0;
            this.target = d;
        }
        if (d2 == this.target) {
            for (int i = n; i < n2; ++i) {
                dArray[i] = d2;
            }
        } else {
            double d3 = this.time.getValues()[0];
            if (d3 != this.timeHeld) {
                this.rate = this.convertTimeToRate(d3);
                this.timeHeld = d3;
            }
            for (int i = n; i < n2; ++i) {
                if (this.phase < 1.0) {
                    d2 = this.source + this.phase * (this.target - this.source);
                    this.phase += this.rate;
                } else {
                    d2 = this.target;
                }
                dArray[i] = d2;
            }
        }
        this.current.setValue(d2);
    }
}

