/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.math;

public class AudioMath {
    private static final double a2dScalar = 20.0 / Math.log(10.0);
    public static final int CONCERT_A_PITCH = 69;
    public static final double CONCERT_A_FREQUENCY = 440.0;
    private static double mConcertAFrequency = 440.0;

    public static double amplitudeToDecibels(double d) {
        double d2 = Math.log(d) * a2dScalar;
        return d2;
    }

    public static double decibelsToAmplitude(double d) {
        double d2 = Math.pow(10.0, d / 20.0);
        return d2;
    }

    public static double frequencyToPitch(double d) {
        return 69.0 + 12.0 * Math.log(d / mConcertAFrequency) / Math.log(2.0);
    }

    public static double pitchToFrequency(double d) {
        return mConcertAFrequency * Math.pow(2.0, (d - 69.0) * 0.08333333333333333);
    }

    public static void setConcertAFrequency(double d) {
        mConcertAFrequency = d;
    }

    public static double getConcertAFrequency() {
        return mConcertAFrequency;
    }

    public static double semitonesToFrequencyScaler(double d) {
        return Math.pow(2.0, d / 12.0);
    }
}

