org 0x100

;%define ESCEXIT
;%define SPEAKER

;[counter] (20 KHz)
start:
;[counter+1] (78 Hz) - used for graphics and synth sequencer
	;setting PIT
		;ax=0
	add al, 52 ;word [si]=xxxxxx00 0000xxxx, all bits used in sequencer are zero
		;al=00110100 - channel 0, rate generator, low/high byte access mode
	out 0x43, al
	mov al, 60
	out 0x40, al ;lo=60
		;CF=0
	salc
	out 0x40, al ;hi=0, frequency=1193182/60~20KHz
	mov fs, [si] ;fs = 0x3404 - delay buffer segment
r0 equ $-2 ;dword [r0]=0x13xxxxxx
	mov al, 0x13
	int 0x10
	
%ifdef ESCEXIT
	;save old handler
	mov ax, 0x3508
	int 0x21 ;old IRQ0 handler -> es:bx
	mov [si-6], bx ;can't use stack without changing main code
	mov [si-4], es
%endif
%ifdef SPEAKER
	in al, 0x61
	or al, 3
	out 0x61, al ;enable speaker and link it to PIT channel 2
	mov al, 144 ;10010000 - channel 2, counter, low byte access mode
	out 0x43, al
%endif

	mov dx, pcm_out
	mov ax, 0x2508 ;pcm_out is set as IRQ0 handler
	int 0x21 ;and is called 20k times per second
	push 0xA000-160/16 ;x-=160
	pop es
	fninit
	
pix:
	mov ax, 0xCCCD
	mul di ;x=dl,y=dh
	sub dh, 100 ;y-=100
	mov bp, sp
	pusha
	;bp=-2
_load:
	fild word [bp-7] ;load x<<8 as dl:bh and y<<8 as dh:dl
	fld st0
	fmul st0
	inc bp
	jnz _load
	;>x x*x y y*y
	faddp st2 ;>x r*r y
	fxch st1 ;>x y r*r
	fsqrt ;>y x r
	fidivr dword [si+(r0-start)] ;>y x r0/r
	;stack top is [bp-2]
	fistp dword [bp-2-9] ;bx=(r0/r)>>8
	;r0/r can be > 32767, and we save it as dword
	;overwriting old sp value (discarded after popa), bx and dl
	fpatan ;>angle
	fimul word [si+(c_rad-start)] ;angle=[0..~65536]
	fistp word [bp-2-4] ;ch=angle>>8=[0..255]
	popa
	
	test bh, bh
	jnz _clear ;to prevent pixel mess in the center
	mov cl, bl ;save r0/r for background
	_rings:
	mov ax, [si]
	add bl, al
	shr bx, 5
	jc _back ;odd rings are invisible
	imul word [si+bx+4] ;using code as LUT for rotation speed
	imul ax, bx, 2
	add al, 4*16 ;color = n_ring*2+64 - part of standard vga palette
	add dl, ch
c_rad equ $+1 ;word [c_rad]=0x28C2, close to 65536/(2*pi)=0x28BE
	test dl, 32+8 ;simple way to make segmented ring
	jnz _color
_back:
	add cl, cl ;background is the second tunnel with doubled radius
	add cl, [si]
	and cl, ch ;'and' texture, x&y
	add ch, [si]
	shr cx, 3
	sub bl, ch
	mov al, bl ;can't xchg ax,bx - bh must me constant to avoid glitches!
	and al, 15
	or al, 16 ;[16..31] grayscale part of vga palette
	shr cl, 1 ;(x&y)&8?color:0
	jc _color
_clear:
	salc ;CF=0
_color:
	stosb

%ifdef ESCEXIT
	test di, di
	jnz pix
	in al, 0x60
	dec al
	jnz pix
	;restore PIT channel 0 divider
%ifdef SPEAKER
	mov al, 52
	out 0x43, al
%endif
	xor ax, ax
	out 0x40, al
	out 0x40, al ;frequency=1193182/65536~18.2Hz
	;restore old IRQ0 handler
	mov dx, [si-6]
	mov ds, [si-4]
	mov ax, 0x2508
	int 0x21
	;back to text mode
	mov ax, 3
	int 0x10
	ret
%else
	jmp pix
%endif
	
v0notesdp:
	db 151, 98, 81, 0, 176, 151, 98, 11, 221, 176, 151, 20, 255, 176, 98, 59
v1notesdp:
	db 176, 151, 81, 98, 81, 98, 151, 117
v2notesdp:
	db 11, 20, 0, 0

pcm_out:
	pusha
	dec si
	mov bx, [si] ;bx=counter
	inc dword [si] ;counter++
	
	;simple loop to calculate phases for three instruments
	;di - note address mask
	;pow(2,cl) - counter divider
	;di=15,cl=4 - voice0
	;di=7,cl=7 - voice1
	;di=3,cl=7 - voice2
	;di=1;cl=7 - to waste
	mov di, 15
	mov cl, 4
computeNoteDeltaPhase:
	mov bp, [256] ;counter/256, can't use si here
	shr bp, cl
		;si - first note offset from v0
	and bp, di ;bp - note address offset from v0+si
	mov al, 62
	mul byte [si+1+(v0notesdp-start)+bp]
	shr ax, 4
	add ax, 228 ;note frequency unpacking, note*62/16+228
	mul bx ;frequency*counter=phase
	push ax
	add si, di ;note address mask is (n_notes-1)
	inc si ;si+=16,8,4,2
	mov cl, 7
	shr di, 1 ;7,3,1,0
	jnz computeNoteDeltaPhase
	
	pop ax ;discard 4th push

	; voice2: bass is p * (1 - p) which gives a nice upside-down parabola
	pop ax ;phase2
	imul ax
	mov cl, dh
	
	; voice1: multiply phase by amplitude
	imul bp, bx, -32 ;env1d, (~counter)*32
	pop ax ;phase1
	add ax, ax ;v1 notes are divided by 2
		;and this shift by one bit can't be integrated in previous or next muls
	mul bp
	mov al, 14
	mul dh ;fine amplitude control
	add cl, ah

	; voice0: multiply phase by amplitude
	imul bp, bx, -16 ;env0d, (~counter)*16
	pop ax ;phase0
	mul bp
	shr dx, 11
	add cl, dl
	
	xchg ax, cx
	; 0.3s delay
	add al, [fs:bx-4096*3/2]
	
%ifndef SPEAKER
	;out to LPT port
	mov dx, 0x378
	out dx, al
%endif
	shr al, 1 ; delay buffer sample amplitude *= 0.5
%ifdef SPEAKER
	inc ax ;to avoid zero value, it will set counter to 65536 instead of 0
	out 0x42, al
%endif
	mov [fs:bx], al
	
	;EOI
	mov al, 0x20
	out 0x20, al
	popa
	iret

