//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDd61f37f7_d7c9_4ec3_a35b_631e205a6551
{
    public class Class_Grid : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            ColorAR = 1,
            ColorAG = 2,
            ColorAB = 3,
            ColorAA = 4,
            ColorBR = 5,
            ColorBG = 6,
            ColorBB = 7,
            ColorBA = 8,
            WidthX = 9,
            WidthY = 10,
            LineWidth = 11,
            OffsetX = 12,
            OffsetY = 13
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var ColorAR = inputs[(int)InputId.ColorAR].Eval(context).Value;
            var ColorAG = inputs[(int)InputId.ColorAG].Eval(context).Value;
            var ColorAB = inputs[(int)InputId.ColorAB].Eval(context).Value;
            var ColorAA = inputs[(int)InputId.ColorAA].Eval(context).Value;
            var ColorA = new Color4(ColorAR, ColorAG, ColorAB, ColorAA);
            var ColorBR = inputs[(int)InputId.ColorBR].Eval(context).Value;
            var ColorBG = inputs[(int)InputId.ColorBG].Eval(context).Value;
            var ColorBB = inputs[(int)InputId.ColorBB].Eval(context).Value;
            var ColorBA = inputs[(int)InputId.ColorBA].Eval(context).Value;
            var ColorB = new Color4(ColorBR, ColorBG, ColorBB, ColorBA);
            var WidthX = inputs[(int)InputId.WidthX].Eval(context).Value;
            var WidthY = inputs[(int)InputId.WidthY].Eval(context).Value;
            var Width = new Vector2(WidthX, WidthY);
            var LineWidth = inputs[(int)InputId.LineWidth].Eval(context).Value;
            var OffsetX = inputs[(int)InputId.OffsetX].Eval(context).Value;
            var OffsetY = inputs[(int)InputId.OffsetY].Eval(context).Value;
            var Offset = new Vector2(OffsetX, OffsetY);
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("ColorA").AsVector().Set(new Vector4(ColorAR, ColorAG, ColorAB, ColorAA));
                    _effect.GetVariableByName("ColorB").AsVector().Set(new Vector4(ColorBR, ColorBG, ColorBB, ColorBA));
                    _effect.GetVariableByName("Width").AsVector().Set(new Vector2(WidthX, WidthY));
                    _effect.GetVariableByName("LineWidth").AsScalar().Set(LineWidth);
                    _effect.GetVariableByName("Offset").AsVector().Set(new Vector2(OffsetX, OffsetY));
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}



