using System.Collections.Generic;
using SharpDX;
using Framefield.Core.OperatorPartTraits;

namespace Framefield.Core.IDaf210a7d_df6a_4187_a9b9_efcb79863a6b
{
    public class Class__TransformMatrix : OperatorPart.Function, ISceneTransform
    {
        // ISceneTransform
        public Matrix Transform
        {
            get
            {
                UpdateTransform(new OperatorPartContext(), OperatorPart.Connections);
                return _transform;
            }
        }
        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            var SceneInput = inputs[0];
            
            UpdateTransform(context, inputs);
            var prevTransform = context.ObjectTWorld;

            context.ObjectTWorld = _transform * prevTransform;
            SceneInput.Eval(context);
            context.ObjectTWorld = prevTransform;

            return context;
        }
        
        // >>> _inputids
        private enum InputId
        {
            SceneInput = 0,
            R0X = 1,
            R0Y = 2,
            R0Z = 3,
            R0W = 4,
            R1X = 5,
            R1Y = 6,
            R1Z = 7,
            R1W = 8,
            R2X = 9,
            R2Y = 10,
            R2Z = 11,
            R2W = 12,
            R3X = 13,
            R3Y = 14,
            R3Z = 15,
            R3W = 16
        }
        // <<< _inputids

        private void UpdateTransform(OperatorPartContext context, List<OperatorPart> inputs)
        {
            if (!Changed)
                return;
                
            // >>> _params
            var SceneInput = inputs[(int)InputId.SceneInput];
            var R0X = inputs[(int)InputId.R0X].Eval(context).Value;
            var R0Y = inputs[(int)InputId.R0Y].Eval(context).Value;
            var R0Z = inputs[(int)InputId.R0Z].Eval(context).Value;
            var R0W = inputs[(int)InputId.R0W].Eval(context).Value;
            var R0 = new Vector4(R0X, R0Y, R0Z, R0W);
            var R1X = inputs[(int)InputId.R1X].Eval(context).Value;
            var R1Y = inputs[(int)InputId.R1Y].Eval(context).Value;
            var R1Z = inputs[(int)InputId.R1Z].Eval(context).Value;
            var R1W = inputs[(int)InputId.R1W].Eval(context).Value;
            var R1 = new Vector4(R1X, R1Y, R1Z, R1W);
            var R2X = inputs[(int)InputId.R2X].Eval(context).Value;
            var R2Y = inputs[(int)InputId.R2Y].Eval(context).Value;
            var R2Z = inputs[(int)InputId.R2Z].Eval(context).Value;
            var R2W = inputs[(int)InputId.R2W].Eval(context).Value;
            var R2 = new Vector4(R2X, R2Y, R2Z, R2W);
            var R3X = inputs[(int)InputId.R3X].Eval(context).Value;
            var R3Y = inputs[(int)InputId.R3Y].Eval(context).Value;
            var R3Z = inputs[(int)InputId.R3Z].Eval(context).Value;
            var R3W = inputs[(int)InputId.R3W].Eval(context).Value;
            var R3 = new Vector4(R3X, R3Y, R3Z, R3W);
            // <<< _params
            
            _transform = new Matrix(R0X, R0Y, R0Z, R0W,
            R1X, R1Y, R1Z, R1W,
            R2X, R2Y, R2Z, R2W,
            R3X, R3Y, R3Z, R3W);


            //_transform = Matrix.Transformation(Pivot, Quaternion.Zero, scale, Pivot, rotation, translation);
        }

        private Matrix _transform;
    }
}
