import QtQuick 2.0
import AdaptDemoSystem 1.0

Group {
    id: mesh
    name: "aalto"
    enabled: syncRoot(mesh.name+".ON")
    property int gWidth: 500


    property int meshTexUpdateCounter: 0
    property int meshTransUpdateCounter: 0

    property int frameIndex: 0

    function shouldResetWave() {
        if (meshTexUpdateCounter <= 2) {
            return true;
        }
        return false;
    }

    function isMeshTexUpdating() {
        if (meshTexUpdateCounter <= 2 || meshTransUpdateCounter <= 2) {
            return true;
        }
        return false;
    }

    Connections {
        target: demo; onFrameRendered: {
            frameIndex++;

            meshTexUpdateCounter++;
            meshTransUpdateCounter++;
            if (meshTexUpdateCounter > 2 && meshTransUpdateCounter > 2) {
                genTexSpaceDir.enabled = false;
                transMesh.enabled = false;
                genTexSpace.enabled = false;
                genTriangleTex.enabled = false;
            }
        }
    }


    //    property int texSpaceSize: 4096
    //    property int texSpaceHeight: 4096
    property int texSpaceSize: 2048
    property int texSpaceHeight: 1800

    property int triangleTexDim: 512

    ShaderAtomicCounter { name: mesh.name+".sac"; clear: true }
    // ShaderAtomicCounter { name: mesh.name+".sac"; clear: true; bind: 1 }


    property int quadsPerRow: texSpaceSize/Math.pow(2.0, Math.round(sync(mesh.name+".texSpace.triSizeExp")));
    onQuadsPerRowChanged: {
        triggerMeshTexUpdate()
    }

    function triggerMeshTexUpdate() {
         genTexSpaceDir.enabled = true;
         transMesh.enabled = true;
         genTexSpace.enabled = true;
         genTriangleTex.enabled = true;
         meshTexUpdateCounter = 0;
    }

    function triggerMeshTransUpdate() {
        genTexSpaceDir.enabled = true;
        transMesh.enabled = true;
        genTexSpace.enabled = true;
        genTriangleTex.enabled = true;
        meshTransUpdateCounter = 0;
    }

    RenderTarget {
        RenderTargetLayer {
            id: triangleInfo
            textureRT: "triangleInfo"
            format: "RGBA32F"
            property int dim: triangleTexDim
            width: dim*3
            height: dim
            Clear {
                enabled: isMeshTexUpdating()
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }
    RenderTarget {
        RenderTargetLayer {
            id: triangleIds
            textureRT: "triangleIds"
            format: "RGBA32F"
            property int dim: triangleTexDim
            width: 3*dim
            height: dim
            Clear {
                enabled: isMeshTexUpdating()
                cR: -1.0; cG: -1.0; cB: -1.0; cA: 1.0;
            }
        }
    }

    RenderTarget {
        RenderTargetLayer {
            id: edgeGridHeadPointers
            textureRT: "edgeGridHeadPointers"
            format: "R32F"
            property int baseDim: 12
            property int dim: baseDim*baseDim*baseDim
            width: dim
            height: dim
            Clear {
                enabled: isMeshTexUpdating()
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }

    RenderTarget {
        RenderTargetLayer {
            id: edgeDataCenter
            textureRT: "edgeDataCenter"
            format: "RGBA32F"
            property int dim: triangleTexDim
            width: 2*dim
            height: dim
        }
    }

    RenderTarget {
        RenderTargetLayer {
            id: edgeDataIds
            textureRT: "edgeDataIds"
            format: "RGBA32F"
            property int dim: triangleTexDim
            width: 2*dim
            height: dim
        }
    }


    RenderTarget {
        RenderTargetLayer {
            id: texSpaceDirX
            textureRT: "texSpaceDirX"
            // "RGBA32F"
            format: "RGBA32F"
            width: texSpaceSize
            height: texSpaceHeight
//                Clear {
//                    enabled: genTexSpaceDir.enabled
//                    cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
//                }
        }
    }
    RenderTarget {
        RenderTargetLayer {
            id: texSpaceDirY
            textureRT: "texSpaceDirY"
            // "RGBA32F"
            format: "RGBA32F"
            width: texSpaceSize
            height: texSpaceHeight
//                Clear {
//                    enabled: genTexSpaceDir.enabled
//                    cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
//                }
        }
    }

    RenderTarget {
        RenderTargetLayer {
            id: texSpaceWave
            textureRT: "texSpaceWave"
            format: "R32F"
            width: texSpaceSize
            height: texSpaceHeight
//                Clear { cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
        }
    }

    RenderTarget {
        RenderTargetLayer {
            id: texSpaceWave2
            textureRT: "texSpaceWave2"
            format: "R32F"
            width: texSpaceSize
            height: texSpaceHeight
//                Clear { cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
        }
    }
    RenderTarget {
        RenderTargetLayer {
            id: texSpaceWaveFeed
            textureRT: "texSpaceWaveFeed"
            format: "R32F"
            width: texSpaceSize; height: texSpaceHeight
//                Clear { cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
        }
    }

    RenderTarget {
        RenderTargetLayer {
            id: texSpaceNormal
            textureRT: "texSpaceNormal"
            format: "RGBA16F"
            width: texSpaceSize
            height: texSpaceHeight
//                Clear { cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
        }
    }

    RenderTarget {
        RenderTargetLayer {
            id: texSpaceTids // tids = triangle ids
            textureRT: "texTriangleIds"
            format: "R32F"
            width: texSpaceSize
            height: texSpaceHeight
//                Clear { cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
        }
    }

    property string shaderVaryings: "
        vec3 posG;
        vec3 normalG;
        vec2 uvG;
        vec3 tangentG;"

    Group {
        id: transMesh

        Shader {
            file: "smTexSpaceTrans"; tfVaryings: mesh.shaderVaryings;
            ShaderParam { paramName: "g_emit"; paramValue: 0.0}
            //            ShaderParam { paramName: "g_zoomAmount"; paramValue: 1.0+zoomPercent}
        }

        // start drawing (with transform feedback) triangles to sceneName+"trans" named vertex buffer object (vbo)
        // all Draw* after this and before "drawStop" has the render to the screen disabled (goes only to the vertex buffer)
        DrawVB {
            type: "drawStart"; primType: "triangles"; vboId: sceneName+mesh.name; tfVaryings: mesh.shaderVaryings;
            enabled: true
            // halfFloats: transPack
            //intPack: transPack
            // reset: sync(drawTrans.syncBaseName+".reset")
            //  reset: true
            //onResetChanged: {if (reset > 0.5) resetParticles();}
            gridWidth: gWidth; gridHeight: 1000; drawNumPoints: gridWidth*gridHeight
            depthTest: false; depthWrite: false
            ShaderParam { paramName: "g_emit"; paramValue: 0.0}
            // Repeater { id: tsp; model: 1 }
        }

        DrawMesh {
            property string meshFile: meshSel(mesh.name)
            file: meshFile
            onMeshFileChanged: {
                mesh.triggerMeshTexUpdate();
            }
            enabled: true; smoothNormals: true; normalSmoothAngle: 80;
            depthTest: true; depthWrite: true;

            property real meshScale: sync(mesh.name+".scale")
            onMeshScaleChanged: mesh.triggerMeshTransUpdate();

            property real meshX: sync(mesh.name+".x")
            property real meshY: sync(mesh.name+".y")
            property real meshZ: sync(mesh.name+".z")

            onMeshXChanged: mesh.triggerMeshTransUpdate();
            onMeshYChanged: mesh.triggerMeshTransUpdate();
            onMeshZChanged: mesh.triggerMeshTransUpdate();

            property real recLimit: sync(mesh.name+".subdiv")

            onRecLimitChanged: mesh.triggerMeshTexUpdate()

            cull: false; cullBack: false
            Sca { s: parent.meshScale; x: 1.0; y: 1.0; z: 1.0 }
            Pos { x: parent.meshX; y: parent.meshY; z: parent.meshZ}
            Rot { d: sync(mesh.name+".rotZ"); ax: 0.0; ay: 0.0; az: 1.0 }

            ShaderParam { paramName: "g_emit"; paramValue: 1.0}
            ShaderParam { paramName: "g_uvScale"; paramValue: 1.0}
            ShaderParam { paramName: "g_uvScaleY"; paramValue: 1.0}
            ShaderParam { paramName: "g_uvOfsY"; paramValue: sync(mesh.name+".uvOfsY") }
            ShaderParam { paramName: "g_bump"; paramValue: 0.650}
            ShaderParam { paramName: "g_texBrightness"; paramValue: 1.0 }
            ShaderParam { paramName: "g_texAmbient"; paramValue: 0.0 }
            ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.0, 1.0"}

            ShaderParam { paramName: "recLimit"; paramValue: parent.recLimit}
        }

        // stop drawing to the vertex buffer (with transform feedback)
        DrawVB {
            enabled: true
            // halfFloats: transPack
            // intPack: transPack
            type: "drawStop";  primType: "triangles"; vboId: sceneName+mesh.name; tfVaryings: mesh.shaderVaryings
            gridWidth: gWidth; gridHeight: 1000; drawNumPoints: gridWidth*gridHeight
        }
    }

    Texture { textureUnit: 0; imageUnit: 0; textureRT: "triangleInfo"; }
    Texture { textureUnit: 1; imageUnit: 1; textureRT: "triangleIds"; }
    Texture { textureUnit: 2; imageUnit: 2; textureRT: "edgeGridHeadPointers"; }
    Texture { textureUnit: 3; imageUnit: 3; textureRT: "edgeDataCenter"; }
    Texture { textureUnit: 4; imageUnit: 4; textureRT: "edgeDataIds"; }
    //  ShaderAtomicCounter { name: mesh.name+".sac"; clear: true; bind: 0 }
    Shader { file: "smGenTriangleTex" }
    DrawVB {
        id: genTriangleTex
        enabled: true
        type: "pointGridDraw"
        primType: "triangles"
        vboId: sceneName+mesh.name
        tfVaryings: mesh.shaderVaryings
        gridWidth: gWidth; gridHeight: 1000
        drawNumPoints: gridWidth*gridHeight
        depthTest: false; depthWrite: false

        ShaderParam { paramName: "g_texW"; paramValue: triangleInfo.width }
        ShaderParam { paramName: "g_texH"; paramValue: triangleInfo.height }
        ShaderParam { paramName: "g_triangleTexDim"; paramValue: triangleTexDim }
        ShaderParam { paramName: "g_hpTexBaseDim"; paramValue: edgeGridHeadPointers.baseDim }


        Sca { s: 1.0; x: 1.0; y: 1.0; z: 1.0 }
        Pos { x: 0.0; y: 0.0; z: 0.0}
        Rot { d: -90; ax: 1.0; ay: 0.0; az: 0.0 }
        blendMode: "off"
        onParticleCountChanged: {
            root.setCustomText("mesh tf", "triangle count", "triangle count:"+particleCount);
        }
    }

    Texture { textureUnit: 0; imageUnit: 0; textureRT: "triangleInfo"; }
    Texture { textureUnit: 1; imageUnit: 1; textureRT: "triangleIds"; }
    Texture { textureUnit: 2; imageUnit: 2; textureRT: "edgeGridHeadPointers"; }
    Texture { textureUnit: 3; imageUnit: 3; textureRT: "edgeDataCenter"; }
    Texture { textureUnit: 4; imageUnit: 4; textureRT: "edgeDataIds"; }
    Shader { file: "smGenTriangleIds" }
    DrawVB {
        id: genTriangleIds
        enabled: true
        type: "pointGridDraw"
        primType: "triangles"
        vboId: sceneName+mesh.name
        tfVaryings: mesh.shaderVaryings
        gridWidth: gWidth; gridHeight: 1000
        drawNumPoints: gridWidth*gridHeight
        depthTest: false; depthWrite: false

        ShaderParam { paramName: "g_texW"; paramValue: triangleInfo.width }
        ShaderParam { paramName: "g_texH"; paramValue: triangleInfo.height }
        ShaderParam { paramName: "g_triangleTexDim"; paramValue: triangleTexDim }
        ShaderParam { paramName: "g_hpTexBaseDim"; paramValue: edgeGridHeadPointers.baseDim }

        Sca { s: 1.0; x: 1.0; y: 1.0; z: 1.0 }
        Pos { x: 0.0; y: 0.0; z: 0.0}
        Rot { d: -90; ax: 1.0; ay: 0.0; az: 0.0 }
        blendMode: "off"
        onParticleCountChanged: {
            root.setCustomText("mesh tf", "triangle count", "triangle count:"+particleCount);
        }
    }

    Texture { textureUnit: 0; imageUnit: 0; textureRT: "triangleInfo"; }
    Texture { textureUnit: 1; imageUnit: 1; textureRT: "triangleIds"; }
    Texture { textureUnit: 2; imageUnit: 2; textureRT: "edgeGridHeadPointers"; }
    Texture { textureUnit: 3; imageUnit: 3; textureRT: "edgeDataCenter"; }
    Texture { textureUnit: 4; imageUnit: 4; textureRT: "edgeDataIds"; }
    Texture { textureUnit: 5; imageUnit: 5; textureRT: "texSpaceDirX"; }
    Texture { textureUnit: 6; imageUnit: 6; textureRT: "texSpaceDirY"; }
    RenderTarget {
        id: genTexSpace
        RenderTargetLayer {
            id: texSpace
            textureRT: "texSpace"
            format: "RGBA32F"
            width: texSpaceSize
            height: texSpaceHeight
            Clear {
                cR: 1.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
        Shader { file: "smGenTexSpace" }
        DrawVB {
            enabled: true
            type: "pointGridDraw"
            primType: "triangles"
            vboId: sceneName+mesh.name
            tfVaryings: mesh.shaderVaryings
            gridWidth: gWidth; gridHeight: 1000
            drawNumPoints: gridWidth*gridHeight
            depthTest: false; depthWrite: false

            ShaderParam { paramName: "g_quadsPerRow"; paramValue: mesh.quadsPerRow}
            ShaderParam { paramName: "g_texW"; paramValue: texSpace.width }
            ShaderParam { paramName: "g_texH"; paramValue: texSpace.height }
            ShaderParam { paramName: "g_triangleTexDim"; paramValue: triangleTexDim }
            ShaderParam { paramName: "g_hpTexBaseDim"; paramValue: edgeGridHeadPointers.baseDim }

            Sca { s: 1.0; x: 1.0; y: 1.0; z: 1.0 }
            Pos { x: 0.0; y: 0.0; z: 0.0}
            Rot { d: -90; ax: 1.0; ay: 0.0; az: 0.0 }
            blendMode: "off"
        }
    }

    //   Texture { textureUnit: 0; textureRT: "texSpace" }
    Texture { textureUnit: 0; imageUnit: 0; textureRT: "triangleInfo"; }
    Texture { textureUnit: 1; imageUnit: 1; textureRT: "triangleIds"; }
    Texture { textureUnit: 2; imageUnit: 2; textureRT: "edgeGridHeadPointers"; }
    Texture { textureUnit: 3; imageUnit: 3; textureRT: "edgeDataCenter"; }
    Texture { textureUnit: 4; imageUnit: 4; textureRT: "edgeDataIds"; }
    Texture { textureUnit: 5; imageUnit: 5; textureRT: "texSpaceDirX"; }
    Texture { textureUnit: 6; imageUnit: 6; textureRT: "texSpaceDirY"; }
    Texture { textureUnit: 7; imageUnit: 7; textureRT: "texSpace"; }

    // generate texSpaceDirX & texSpaceDirY
    RenderTarget {
        id: genTexSpaceDir
    //    enabled: true
        RenderTargetLayer { textureRT: "texSpaceNormal"; format: "RGBA16F"; width: texSpaceSize; height: texSpaceHeight }
        Shader { file: "smGenTexDir" }
        DrawVB {
            enabled: true
            type: "pointGridDraw"
            primType: "triangles"
            vboId: sceneName+mesh.name
            tfVaryings: mesh.shaderVaryings
            gridWidth: gWidth; gridHeight: 1000
            drawNumPoints: gridWidth*gridHeight
            depthTest: false; depthWrite: false

            ShaderParam { paramName: "g_quadsPerRow"; paramValue: mesh.quadsPerRow}
            ShaderParam { paramName: "g_texW"; paramValue: texSpace.width }
            ShaderParam { paramName: "g_texH"; paramValue: texSpace.height }
            ShaderParam { paramName: "g_triangleTexDim"; paramValue: triangleTexDim }
            ShaderParam { paramName: "g_hpTexBaseDim"; paramValue: edgeGridHeadPointers.baseDim }

            Sca { s: 1.0; x: 1.0; y: 1.0; z: 1.0 }
            Pos { x: 0.0; y: 0.0; z: 0.0}
            Rot { d: -90; ax: 1.0; ay: 0.0; az: 0.0 }
            blendMode: "off"
            onParticleCountChanged: {
                root.setCustomText("mesh tf", "triangle count", "triangle count:"+particleCount);
            }
        }
    }

    // tex space wave ping pong
    Texture { textureUnit: 1; imageUnit: 1; textureRT: ((frameIndex&1)===0 ? "texSpaceWave" : "texSpaceWave2") }
    Texture { textureUnit: 2; imageUnit: 2; textureRT: ((frameIndex&1)===0 ? "texSpaceWave2" : "texSpaceWave") }
    Texture { textureUnit: 3; imageUnit: 3; textureRT: "texSpaceWaveFeed"; }
    Texture { textureUnit: 5; imageUnit: 5; textureRT: "texSpaceDirX"; }
    Texture { textureUnit: 6; imageUnit: 6; textureRT: "texSpaceDirY"; }
    Texture { textureUnit: 7; imageUnit: 7; textureRT: "texSpace"; }
    RenderTarget {
        // RenderTargetLayer { textureRT: "texSpaceXXX"; format: "R32F"; width: texSpaceSize; height: texSpaceHeight }
        RenderTargetLayer { textureRT: "texSpaceNormal"; format: "RGBA16F"; width: texSpaceSize; height: texSpaceHeight }
        Shader { file: "smTexSpaceWave" }
        DrawVB {
            enabled: true
            type: "pointGridDraw"
            primType: "triangles"
            vboId: sceneName+mesh.name
            tfVaryings: mesh.shaderVaryings
            gridWidth: gWidth; gridHeight: 1000
            drawNumPoints: gridWidth*gridHeight
            depthTest: false; depthWrite: false

            ShaderParam { paramName: "g_quadsPerRow"; paramValue: mesh.quadsPerRow}
            ShaderParam { paramName: "g_texW"; paramValue: texSpace.width }
            ShaderParam { paramName: "g_texH"; paramValue: texSpace.height }
            ShaderParam { paramName: "g_triangleTexDim"; paramValue: triangleTexDim }
            ShaderParam { paramName: "g_hpTexBaseDim"; paramValue: edgeGridHeadPointers.baseDim }

            property int reset: shouldResetWave() ? 1.0 : (sync(mesh.name+".texSpaceReset") > 0.5 ? 1.0 : 0.0)
            ShaderParam { paramName: "g_reset"; paramValue: parent.reset }

            ShaderParam { paramName: "g_waveBlur"; paramValue: sync(mesh.name+".waveBlur")}
            ShaderParam { paramName: "g_hitHeight"; paramValue: sync(mesh.name+".waveHitHeight")}
            ShaderParam { paramName: "g_waveDamp"; paramValue: sync(mesh.name+".waveDamp")}
            ShaderParam { paramName: "g_waveSpeed"; paramValue: sync(mesh.name+".waveSpeed")}

            Sca { s: 1.0; x: 1.0; y: 1.0; z: 1.0 }
            Pos { x: 0.0; y: 0.0; z: 0.0}
            Rot { d: -90; ax: 1.0; ay: 0.0; az: 0.0 }
            blendMode: "off"
        }
    }


    // blit current depth values from mainDepth to curDepth
    RenderTarget {
        RenderTargetLayer {
            textureRT: "curDepth"
            format: "RGBA32F"
            width: demo.windowWidth
            height: demo.windowHeight
        }
        Texture { textureUnit: 0; textureRT: "mainDepth" }
        Shader { file: "fx/_SharedQML/drawRtTexel" }
        DrawVB {
            type: "quad"
            depthTest: false; depthWrite: false
            ShaderParam { paramName: "flip"; paramValue: 1.0 }
            blendMode: "off"
        }
    }

    // calculate the texture space normals
    Texture { textureUnit: 0; imageUnit: 0; textureRT: "texSpaceNormal" }

    Texture { textureUnit: 0; textureRT: ((frameIndex&1)===0 ? "texSpaceWave2" : "texSpaceWave"); }
    Texture { textureUnit: 1; textureRT: "texSpaceDirX"; }
    Texture { textureUnit: 2; textureRT: "texSpaceDirY"; }

    RenderTarget {
        RenderTargetLayer { textureRT: "texSpaceNormal"; format: "RGBA16F"; width: texSpaceSize; height: texSpaceHeight }
        Shader { file: "smTexSpaceNormal" }
        DrawVB {
            enabled: true
            type: "pointGridDraw"
            primType: "triangles"
            vboId: sceneName+mesh.name
            tfVaryings: mesh.shaderVaryings
            gridWidth: gWidth; gridHeight: 1000
            drawNumPoints: gridWidth*gridHeight
            depthTest: false; depthWrite: false

            ShaderParam { paramName: "g_quadsPerRow"; paramValue: mesh.quadsPerRow}
            ShaderParam { paramName: "g_texW"; paramValue: texSpace.width }
            ShaderParam { paramName: "g_texH"; paramValue: texSpace.height }
            ShaderParam { paramName: "g_triangleTexDim"; paramValue: triangleTexDim }
            ShaderParam { paramName: "g_hpTexBaseDim"; paramValue: edgeGridHeadPointers.baseDim }

            Sca { s: 1.0; x: 1.0; y: 1.0; z: 1.0 }
            Pos { x: 0.0; y: 0.0; z: 0.0}
            Rot { d: -90; ax: 1.0; ay: 0.0; az: 0.0 }
            blendMode: "off"
        }
    }

    // draw the actual mesh
    Shader { file: "smTexSpace" }
    Texture { textureUnit: 0; imageUnit: 0; textureRT: "triangleInfo"; }
    Texture { textureUnit: 1; imageUnit: 1; textureRT: "triangleIds"; }
    Texture { textureUnit: 2; imageUnit: 2; textureRT: "edgeGridHeadPointers"; }
    Texture { textureUnit: 3; imageUnit: 3; textureRT: "edgeDataCenter"; }
    Texture { textureUnit: 4; imageUnit: 4; textureRT: "edgeDataIds"; }
    Texture { textureUnit: 5; imageUnit: 5; textureRT: "texSpace"; }
    Texture { textureUnit: 6; imageUnit: 6; textureRT: "texSpaceWaveFeed"; }

    Texture { textureUnit: 0; textureRT: "texSpace" }
    Texture { textureUnit: 1; textureRT: ((frameIndex&1)===0 ? "texSpaceWave" : "texSpaceWave2"); }
    Texture { textureUnit: 2; textureRT: "bgBlurMesh" }
    Texture { textureUnit: 3; textureRT: "texSpaceDirX" }
    Texture { textureUnit: 4; textureRT: "texSpaceDirY" }
    Texture { textureUnit: 5; textureRT: "curDepth" }
    Texture { textureUnit: 6; textureRT: "texSpaceNormal" }
    Texture { textureUnit: 9; textureRT: "bgBlurGlass" }

    DrawVB {
        enabled: true
        type: "pointGridDraw"
        primType: "triangles"
        vboId: sceneName+mesh.name
        tfVaryings: mesh.shaderVaryings
        gridWidth: gWidth; gridHeight: 1000
        drawNumPoints: gridWidth*gridHeight
        //depthTest: false; depthWrite: false
        depthTest: true; depthWrite: (sync(mesh.name+".blendMode") < 1.5) ? true : false
        //   cull: true

        ShaderParam { paramName: "g_quadsPerRow"; paramValue: mesh.quadsPerRow}
        ShaderParam { paramName: "g_texW"; paramValue: texSpace.width }
        ShaderParam { paramName: "g_texH"; paramValue: texSpace.height }
        ShaderParam { paramName: "g_triangleTexDim"; paramValue: triangleTexDim }
        ShaderParam { paramName: "g_hpTexBaseDim"; paramValue: edgeGridHeadPointers.baseDim }
        ShaderParam { paramName: "g_bright"; paramValue: sync(mesh.name+".bright")}
        ShaderParam { paramName: "g_underWaterMeshBright"; paramValue: sync(mesh.name+".underWater.meshBright", 1.0)}
        ShaderParam { paramName: "g_waveDispHeight"; paramValue: sync(mesh.name+".waveHeight")}

        Pos { x: 0.0; y: 0.0; z: 0.0}
//        Rot { d: sync(mesh.name+".rotX"); ax: 1.0; ay: 0.0; az: 0.0 }
//        Rot { d: sync(mesh.name+".rotY"); ax: 0.0; ay: 1.0; az: 0.0 }
//        Rot { d: sync(mesh.name+".rotZ"); ax: 0.0; ay: 0.0; az: 1.0 }
        Sca { s: 1.0; x: 1.0; y: 1.0; z: 1.0 }

        blendMode: blendSel(mesh.name)
        onParticleCountChanged: {
            root.setCustomText("mesh tf", "triangle count", "triangle count:"+particleCount);
        }

        drawBuffers: 3
    }

}
