import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    // Screen Space Reflection as done in Reflexion/Adapt 2013...
    // assumes to have depth R and normal GB textureRT named "depth"

    id: reflect
    name: "reflect"
    effectName: "Reflect"
    enabled: syncRoot(name+".ON")

    Blit {
        textureRT: "bg"
        blitRT: 0
    }
    Shader {
        file: "fx/_SharedQML/reflect"
    }
    Texture {
        textureUnit: 0
        textureRT: "bg"
      //  textureRT: "prevNormal"
      //  textureRT: "prevBlur"
    }
    Texture {
        textureUnit: 1
        textureRT: "depth"
    }
    Texture {
        textureUnit: 2
        textureRT: "mainDepth"
     //   textureRT: "prevNormal"
    }
    Texture {
        textureUnit: 3
        textureRT: "prev"
    }
    DrawVB {
        ShaderParam { paramName: "flip"; paramValue: 0.0 }
        ShaderParam { paramName: "g_reflectAmount"; paramValue: sync("reflect.amount") }
        ShaderParam { paramName: "g_addBlend"; paramValue: sync("reflect.addBlend") }
        ShaderParam { paramName: "g_distFade"; paramValue: sync("reflect.distFade") }
        ShaderParam { paramName: "g_distBase"; paramValue: sync("reflect.distBase") }
        ShaderParam { paramName: "g_fakeAO"; paramValue: sync("reflect.fakeAO") }
        ShaderParam { paramName: "g_prevRefl"; paramValue: sync("reflect.prevRefl") }
        ShaderParam { paramName: "g_noise"; paramValue: sync("reflect.noise") }
        ShaderParam { paramName: "g_maxDist"; paramValue: sync("reflect.maxDist") }
        ShaderParam { paramName: "g_bgBaseAmount"; paramValue: 1.0-sync("blurReflect.ON") }

        type: "quad"
        depthTest: false
        depthWrite: false
        blendMode: "off"
        drawBuffers: 1
    }

    BlurReflect {

    }

}
