#version 430

layout(binding=1) uniform sampler2D texNoise;
layout(binding=3) uniform sampler2D texDepth; // world space normal in rgb
layout(binding=4) uniform sampler2D texMainDepth; // depth in r


// no texture2D in geometry shaders, so use this instead!!
vec4 tex2D(sampler2D s, vec2 c) {
    ivec2 ts = textureSize(s, 0);
    return texelFetch(s, ivec2(c.x*ts.x, c.y*ts.y), 0);
  //return texture2D(s, c);
}

// in int gl_PrimitiveIDIn;


vec4 rotateXZ(vec4 p, float a) {
vec4 r = p;
r.x = cos(a)*p.x - sin(a)*p.z;
r.z = sin(a)*p.x + cos(a)*p.z;
return r;
}

vec3 rotateXteXZ3(vec3 p, float a) {
return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
vec4 r = p;
r.x = cos(a)*p.x - sin(a)*p.y;
r.y = sin(a)*p.x + cos(a)*p.y;
return r;
}


vec3 rotateXY(vec3 p, float a) {
vec3 r = p;
r.x = cos(a)*p.x - sin(a)*p.y;
r.y = sin(a)*p.x + cos(a)*p.y;
return r;
}


vec4 rotateYZ(vec4 p, float a) {
vec4 r = p;
r.y = cos(a)*p.y - sin(a)*p.z;
r.z = sin(a)*p.y + cos(a)*p.z;
return r;
}

// interpolated perlin noise, from http://glslsandbox.com/e#34573.4
float hash(in vec2 p) {
  float h = dot(p,vec2(127.1,311.7));
  return fract(sin(h)*43758.5453123);
}
// computed non-texture based interpolated noise
float noiseC(in vec2 p) {
  vec2 i = floor( p );
  vec2 f = fract( p );
  vec2 u = f*f*(3.0-2.0*f);
  return -1.0+2.0*mix( mix( hash( i + vec2(0.0,0.0) ),
                   hash( i + vec2(1.0,0.0) ), u.x),
              mix( hash( i + vec2(0.0,1.0) ),
                   hash( i + vec2(1.0,1.0) ), u.x), u.y);
}

float nois(in vec3 x) //3d noise from iq
{
    vec3 p = floor(x);
    vec3 f = fract(x);
      //  f = f*f*(3.0-2.0*f);
        vec2 uv = (p.xy+vec2(37.0,17.0)*p.z) + f.xy;
        vec2 rg = tex2D(texNoise, fract((uv)/256.0)+vec2(0.0)).yx;
        rg -= vec2(0.435);
    //    rg = pow(rg, vec2(2.0));
        return mix( rg.x, rg.y, f.z );
}

uniform float g_noiseOctFreq = 4.0;

float fbm(in vec3 x)
{
    float rz = 0.0;
    float a = 0.50;
    int no = 4; // int(g_noiseOctaves);
    for (int i = 0; i<no; i++)
    {
        rz += nois(x)*a;
        a*=.5;
        x*=g_noiseOctFreq;
    }
    return rz;
}

float fbmm(in vec3 x)
{
    float rz = 1.0;
    float a = 2.0;
    for (int i = 0; i<4; i++)
    {
        rz *= nois(x)*a;
        a*=.95;
        x*= 2.;
    }
    return rz;
}


// google glsl rand gave this, thanks and credit flies to
// http://stackoverflow.com/questions/4200224/random-noise-functions-for-glsl
float rand(vec2 co){
return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}


layout(points) in;
layout(points) out;
layout(max_vertices = 2) out;

//layout(line_strip, max_vertices = 15) out;

in vec3 posV[];
in vec2 uvV[];
in vec3 velV[];
in vec3 colV[];
in float ageV[];
in float recV[];
in float ageSplitV[];
in vec4 paramsV[];
in vec4 targetPosV[];


out vec3 posG;
out vec2 uvG;
out vec3 velG;
out vec3 colG;
out float ageG;
out float recG;
out float ageSplitG;
out vec4 paramsG;
out vec4 targetPosG;

uniform float g_force = 1.0;
uniform float g_noiseFreq = 1.0;
uniform float g_speed = 1.0;
uniform float g_initShapeX = 1.0;
uniform float g_initShapeY = 1.0;
uniform float g_maxAge = 10.0;

uniform float g_initPosX = 0.0;
uniform float g_initPosY = 0.0;
uniform float g_initPosZ = 0.0;

uniform vec4 g_noiseScale = vec4(1.0, 1.0, 1.0, 0.0);

uniform float g_velDamping = 1.0;
uniform float g_emitShape = 0.0;


uniform float g_radForceStatic = 0.0;
uniform float g_radForceDist = 0.0;
uniform float g_radForceDamp = 0.0;
uniform vec4 g_radForcePos = vec4(0.0, 0.0, 0.0, 0.0);


uniform float g_radForce2Static = 0.0;
uniform float g_radForce2Dist = 0.0;
uniform float g_radForce2Damp = 0.0;
uniform vec4 g_radForce2Pos = vec4(0.0, 0.0, 0.0, 0.0);


uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform mat4 projectionInvMatrix;
uniform mat4 modelViewInvMatrix;

uniform float g_time;
uniform float g_timeStep;

uniform float g_splitThr = 0.0;
uniform float g_splitAmpRand = 1.0;
uniform float g_splitAmpNorm = 1.0;
uniform float g_noiseSpeed = 0.1;


uniform float windowWidth = 1280.0;
uniform float windowHeight = 720.0;


uniform float g_maxSimParticles = 1000000.0;

uniform float g_pikselos = 0.0;
// in int gl_PrimitiveID;

uniform float g_windowWidth = 1280.0;
uniform float g_windowHeight = 720.0;

uniform float g_elasticity = 0.5;

layout(binding=0, offset=0) uniform atomic_uint ac;

//Texture { textureUnit: 0; imageUnit: 0; textureRT: "particleGridCounts"; }
//Texture { textureUnit: 1; imageUnit: 1; textureRT: "particleGridOfs"; }
//Texture { textureUnit: 3; imageUnit: 3; textureRT: "particleArrPos"; }
//Texture { textureUnit: 4; imageUnit: 4; textureRT: "particleArrVel"; }

//layout(binding=3, r32i) uniform iimage2D particleGridCounts;
//layout(binding=4, r32i) uniform iimage2D particleGridOfs;
//layout(binding=5, rgba32f) uniform image2D particleArrPos;
//layout(binding=6, rgba32f) uniform image2D particleArrVel;

layout(binding=0, rgba16f) uniform image2D emittedPartPos;
layout(binding=1, rgba16f) uniform image2D emittedPartVel;
layout(binding=2, rgba16f) uniform image2D emittedPartCol;
layout(binding=3, r32i) uniform iimage2D edgeGridHeadPointers;
layout(binding=4, rgba32f) uniform image2D edgeDataCenter;
layout(binding=5, rgba32f) uniform image2D voxelVel;
layout(binding=6, rgba32f) uniform image2D edgeDataIds;

// layout(binding=2, offset=0) uniform atomic_uint acPartGrid;
// layout(binding=3, r32i) uniform iimage2D partGridIds;

uniform float g_hpTexBaseDim;
uniform float g_triangleTexDim;


//// from Iq: http://www.iquilezles.org/www/articles/texture/texture.htm
//vec4 getTexel( sampler2D s, vec2 p ) {
//    //return tex2D(s, p);

//    highp vec2 texRes = vec2(g_windowWidth, g_windowHeight);
//    p = p*texRes+0.5;

//    highp vec2 i = floor(p);
//    highp vec2 f = p - i;
//    f = f*f*f*(f*(f*6.0-15.0)+10.0);
//    p = i + f;

//    p = (p - 0.5)/texRes;
//    return tex2D(s, p);
//}

uniform float zNear = 0.1;
uniform float zFar = 1000.0;
// convert from 0.0 to 1.0 depth sample ds to linear depth
float linearDepth(float ds) {
    ds = 2.0*ds-1.0;
    float zLinear = 2.0*zNear*zFar/(zFar+zNear-ds*(zFar-zNear));
    return zLinear;
}
// result suitable for assigning to gl_FragDepth
float depthSample(float linearDepth) {
    float nonLinearDepth = (zFar+zNear-2.0*zNear*zFar/linearDepth)/(zFar-zNear);
    nonLinearDepth = (nonLinearDepth+1.0)/2.0;
    return nonLinearDepth;
}

float zn = 0.0;
float zf = 1.0;

uniform int g_numOld;

vec4 CalcEyeFromWindow(in vec3 windowSpace) {
    vec3 ndcPos;
    vec4 viewport = vec4(0.0, 0.0, windowWidth, windowHeight);
    ndcPos.xy = ((2.0 * windowSpace.xy) - (2.0 * viewport.xy)) / (viewport.zw) - 1;
//    ndcPos.z = (2.0 * windowSpace.z - zNear - zFar) / (zFar - zNear);
    ndcPos.z = (2.0 * windowSpace.z - zn - zf) / (zf - zn);
    vec4 clipPos;
    clipPos.w = projectionMatrix[3][2]/(ndcPos.z-(projectionMatrix[2][2]/projectionMatrix[2][3]));
    clipPos.xyz = ndcPos * clipPos.w;
    return projectionInvMatrix * clipPos;
}

uniform float g_gridDim = 100.0;
uniform float g_rotOrigin = 0.0;

uniform vec4 g_noiseOfs = vec4(0.0, 0.0, 0.0, 0.0);

uniform vec4 g_noiseMove = vec4(0.0, 0.0, 0.0, 0.0);

uniform float g_partDiscardBright = 0.5;

uniform float g_voxelDim;
uniform float g_voxelAreaSize;

uniform float g_stirHitVelScale = 1.0;


uniform float g_noiseRec = 0.0;


uniform float g_forceDelay = 0.0;
uniform float g_forceAttack = 0.0;

uniform float g_forceAttackExp = 1.0;


uniform float g_partToMeshForce = 0.75;
uniform float g_partToMeshVelDamp = 0.04;


void main(void) {

    vec3 pos = posV[0];
    vec2 uv = uvV[0];

    vec3 vel = velV[0];
    vec3 col = colV[0];
    float age = ageV[0];
    float rec = recV[0];

    float ageSplit = ageSplitV[0];


    targetPosG = targetPosV[0];

   // vec4 pI = posInitV[0];



    vec3 posInit = vec3(0.0);


    mat4 mvp = projectionMatrix * modelViewMatrix;

   // mat4 mvp = projectionMatrix * modelViewMatrix;
    vec3 posNois = vec3(0.0);

    float distFromOrig = dot(pos,pos);

    float simSpeed = 1.0;

    float myTime = g_time*0.10*simSpeed;
    float myTimeStep = g_timeStep*simSpeed;
    float k = 1.0;

    bool bInited = age>0.0001;

    int prim = gl_PrimitiveIDIn;
    if (prim > int(g_maxSimParticles)) {
        return;
    }
	
//	age = 0.10;
//	bInited = true;

    float maxDist = 800.0;

    if (!bInited || distFromOrig>maxDist*maxDist || age>g_maxAge) { // init particle

        int gridDim = int(g_gridDim);

        int primZ = 0;
        int primY = int(prim/gridDim);
        int primX = prim-primY*gridDim;

        float pullaU = float(primX)/float(gridDim);
        float pullaV = float(primY)/float(gridDim);

        if (rec > 0.5 && age>0.001) { // do not re-init recursed particle
          return;
        }

        bool bEmittedFromScreen = false;
        if (rec > 0.5 && age<0.001) {
          bEmittedFromScreen = true;
        }

        rec = 0.0;

        if (bEmittedFromScreen) {
          rec = 1.0;
        }

        targetPosG = vec4(99999.0);


        if (age < 0.0001 && prim!=0) {
        // first time age is zero when we come to init
            posInit.x = (pullaU-0.5);
            posInit.z = (pullaV-0.5);
            posInit.y = 0.0;

            if (!bEmittedFromScreen) {
                pos.y = (pullaU-0.5)*2.0*g_initShapeX+g_initPosX+99999.0;
                pos.z = (pullaV-0.5)*2.0*g_initShapeY+g_initPosZ+99999.0;
                pos.x = 0.0*2.0+g_initPosY;
             }
            uv.x = pullaU*1.0+0.0;
            uv.y = pullaV*1.0+0.0;

            ageSplit = g_maxAge-rand(pos.xy)*g_maxAge;

            age = rand(pos.yz)*2.0*g_maxAge;

            if (g_emitShape == 1) {
                pos.x = 1.0*sin(prim*0.01+myTime);
                pos.y = 1.0*cos(pos.x*1.4*sin(prim*0.01)+myTime)+99999.0;
                pos.z = 1.0*cos(pos.y*1.2*cos(pos.x*2.4)+myTime)+99999.0;
            }

        } else {
            if (!bEmittedFromScreen) {
                if (g_emitShape == 0) {

                    posInit.x = (pullaU-0.5);
                    posInit.z = (pullaV-0.5);
                    posInit.y = 0.0;

                    pos.x = posInit.x*2.0*g_initShapeX+g_initPosX;
                    pos.y = posInit.y*2.0+g_initPosY+99999.0;;
                    pos.z = posInit.z*2.0*g_initShapeY+g_initPosZ+99999.0;;
                } else {
                    pos.x = 1.0*sin(prim*0.01+myTime);
                    pos.y = 1.0*cos(pos.x*1.4*sin(prim*0.01)+myTime)+99999.0;;
                    pos.z = 1.0*cos(pos.y*1.2*cos(pos.x*2.4)+myTime)+99999.0;;
                }
            }
            age = 0.01; //+(rand(pos.xy))*g_maxAge;
        }

        vel = vec3(0.0);


    }


   // pos.xyz = rotateXY(pos.xyz, -g_timeStep*distFromOrig*g_rotOrigin);

    vec4 pos4 = vec4(pos, 1.0);
    pos4.w = 1.0;
    vec4 posScreen = mvp*pos4;
    vec2 scrTexPos = posScreen.xy/posScreen.w*0.5+vec2(0.5, 0.5);
    float da = posScreen.z/posScreen.w;

    vec4 posEye = modelViewMatrix*pos4;
   //  posEye.xyz /= posEye.w;


//  the particle screen space collision checks code
    vec4 dd = texelFetch(texMainDepth, ivec2(scrTexPos.x*windowWidth, scrTexPos.y*windowHeight), 0);
    vec4 eye = CalcEyeFromWindow(vec3(vec2(scrTexPos.x*windowWidth, scrTexPos.y*windowHeight), dd.r));
  //  eye.xyz /= eye.w;
    dd.r = eye.z;

    vec4 norms = tex2D(texDepth, scrTexPos);

    int split = 0;
    vec3 rNormal;
    float velRefl = 0.0;
  //  float difo = dd.r-da;

    vec3 pek = posEye.xyz-eye.xyz;
    float difo = dot(pek, pek);
    //difo = 100.0;
    float pertti = dot(pek, norms.xyz); // pertti negative means that position of the particle is behind the surface
  //  if (((difo < -1.0 && difo > -30.0) || (difo >= 0.0 && difo < 30.0)) && (scrTexPos.x>=0 && scrTexPos.y>=0 && scrTexPos.x<1.0 && scrTexPos.y<1.0)) {
    if (((pertti>=0.0 && abs(difo)<32.0) || (pertti<0.0 && abs(difo)<0.1)) && (scrTexPos.x>=0 && scrTexPos.y>=0 && scrTexPos.x<1.0 && scrTexPos.y<1.0)) {
       vec3 nextPos = pos+vel*myTimeStep*g_speed*1.0;
       vec4 np4 = vec4(nextPos, 1.0);
       np4.w = 1.0;
       vec4 nps = mvp*np4;

       vec4 npsEye = modelViewMatrix*np4;
       npsEye.xyz /= npsEye.w;

       vec2 nscrTexPos = nps.xy/nps.w*0.5+vec2(0.5, 0.5);

        //vec4 ndd = tex2D(texMainDepth, nscrTexPos);
        vec4 ndd = texelFetch(texMainDepth, ivec2(nscrTexPos.x*windowWidth, nscrTexPos.y*windowHeight), 0);
        //vec4 dd = tex2D(texMainDepth, scrTexPos);
        vec4 neye = CalcEyeFromWindow(vec3(vec2(nscrTexPos.x*windowWidth, nscrTexPos.y*windowHeight), ndd.r));
        neye.xyz /= neye.w;


       float nda = nps.z/nps.w;

        //nda = linearDepth(nda);
        //ndd.r = linearDepth(ndd.r);

        // da = nda;
        ndd.r = neye.z;



     //  float ndifo = ndd.r-nda;

        vec3 npek = neye.xyz-npsEye.xyz;
        float ndifo = dot(npek, npek);




       // vel = vec3(0.0);
      // if (true) {
       if (abs(ndifo) < abs(difo)+0.10) { // collide only if not already separating

        // vec3 ssNormal = vec3(dd.gb, 0.0);
        // ssNormal.z = sqrt(1.0-dot(ssNormal.xy, ssNormal.xy));
        vec3 ssNormal = norms.rgb;

        // uniform mat4 projectionInvMatrix;
        // uniform mat4 modelViewInvMatrix;

        ssNormal = normalize(ssNormal);
        vec4 wsNormal = vec4(ssNormal, 1.0);

        //wsNormal.xyz = vec3(0.0, -1.0, 0.0);

       // wsNormal = wsNormal*modelViewInvMatrix;
       // wsNormal = modelViewInvMatrix*wsNormal;

        float elasticity = g_elasticity;

        float colvel = sqrt(dot(vel,vel));

        if (g_splitThr > 0.01 && colvel > g_splitThr && rec < 6.0) {
       //   if (rec < 0.5 || rec > 1.5) {
       //           rec += 1.0;
       //   }
          split = 1;
        }

         //k = 0.0;
        // vel = -vel*(1.0+1.0);
        vec3 vr = reflect(vel, -wsNormal.xyz);

        rNormal = wsNormal.xyz;
        // vec3 vr = reflect(vel*1.0, vec3(0.0, 1.0, 0.0));

        float nea = 0.0; // clamp(0.10/ndifo, 0.0, 10.0)*0.30+clamp(-difo, 0.0, 10.0)*0.0;

        vel = (vr+vel)*0.5+(vr-(vr+vel)*0.5)*(elasticity+nea);

        velRefl = sqrt(dot(vel,vel));
       // vel += vr*0.05;
       // vel = vr*elasticity;
        pos += vr*myTimeStep*g_speed*0.0;
        //k = 0;
       }
    }

   // vel = vec3(0.0, -1.0, 0.0);


    age += myTimeStep*(1.0+rand(vec2(gl_PrimitiveIDIn*0.2, gl_PrimitiveIDIn*2.13)));
    pos += vel*myTimeStep*g_speed;
    float bScale = 2.4;

    vec2 myUv = uv;
    myUv.y = -myUv.y;
    myUv.x = myUv.x;

  //  vec4 emitShape = tex2D(texEmitShape, myUv);

//    if (emitShape.r < 0.1 ) {
//        return;
//    }

   // rec = emitShape.r*3.0;

    myTime = g_time*1.0*simSpeed*g_noiseSpeed;
    float timeStepScale = 2.2;

// float tkk = 1.1;
//    posNois.x += cos(myTime*tkk+bScale*pos.y*(2.2+2.0*sin(myTime))*sin(g_time*tkk*1.2+pos.y*10.3));
//    posNois.y += sin(myTime*tkk*1.23-bScale*pos.x*(2.2+2.0*cos(0.3+myTime*0.7))*cos(myTime*tkk*0.912+pos.x*10.3));
//    posNois.z += 2.5*sin(myTime*tkk*1.63-bScale*pos.y*(1.2+1.0*sin(0.45+myTime*0.32))*cos(myTime*tkk*1.312+pos.y*12.3-pos.z*10.3));

    vec3 posN = pos+g_noiseMove.xyz;

    float noiseFreq = g_noiseFreq;

    posNois.x = fbm(posN.xyz*0.230*noiseFreq+noiseFreq*0.1*vec3(myTime, 0.3, myTime*1.2));
    posNois.y = fbm(posN.yzx*0.30*noiseFreq+noiseFreq*0.1*vec3(myTime*0.3, myTime*0.62, 0.3));
    posNois.z = fbm(posN.zyx*0.20*noiseFreq+noiseFreq*0.1*vec3(0.4+myTime*0.01, myTime*0.1, myTime*0.12));

    if (abs(g_noiseRec) > 0.001) {
        posNois.x = fbm(posN.xyz*0.230*noiseFreq+g_noiseRec*posNois.xyz*0.230*noiseFreq+noiseFreq*0.1*vec3(myTime, 0.3, myTime*1.2));
        posNois.y = fbm(posN.xyz*0.230*noiseFreq+g_noiseRec*posNois.yzx*0.30*noiseFreq+noiseFreq*0.1*vec3(myTime*0.3, myTime*0.62, 0.3));
        posNois.z = fbm(posN.xyz*0.230*noiseFreq+g_noiseRec*posNois.zyx*0.20*noiseFreq+noiseFreq*0.1*vec3(0.4+myTime*0.01, myTime*0.1, myTime*0.12));
    }
    posNois.xyz *= g_noiseScale.xyz;

    posNois += g_noiseOfs.xyz;


    float forceMul = 1.0; //

    //smoothstep(0.0, g_forceAttack, clamp(age-g_forceDelay, 0.0, age));

    if (age < g_forceDelay) forceMul = 0.0;
    else {
        float jor = age-g_forceDelay;
        forceMul = pow(smoothstep(0.0, g_forceDelay, jor), g_forceAttackExp);
    }


    float vd2 = g_voxelDim*g_voxelDim;
    int vd3 = int(vd2*g_voxelDim);
    vec3 cell = pos/g_voxelAreaSize*0.5+vec3(0.5, 0.5, 0.5)-vec3(0.0/vd2);
    cell = floor(cell*vd2);
    float cellzy = floor(cell.z/g_voxelDim);
    float cellzx = cell.z-cellzy*g_voxelDim;
    ivec2 cellUV = ivec2(cell.x+cellzx*vd2, cell.y+cellzy*vd2);
    vec3 voxVel = imageLoad(voxelVel, cellUV).xyz;

    posNois.xyz += voxVel*g_stirHitVelScale;


    float per = myTimeStep/0.033;


    // particles to mesh

    if (abs(g_partToMeshForce) > 0.001) {
        cell = (fract(pos.xyz*100.0+vec3(0.0)));
        if (cell.x < 0.0) cell.x = 1.0-cell.x;
        if (cell.y < 0.0) cell.y = 1.0-cell.y;
        if (cell.z < 0.0) cell.z = 1.0-cell.z;
        float hpTexBaseDim2 = g_hpTexBaseDim*g_hpTexBaseDim;
        cell = floor(cell*hpTexBaseDim2);
        cellzy = floor(cell.z/g_hpTexBaseDim);
        cellzx = cell.z-cellzy*g_hpTexBaseDim;
        cellUV = ivec2(cell.x+cellzx*hpTexBaseDim2, cell.y+cellzy*hpTexBaseDim2);
        //     imageStore(edgeGridHeadPointers, cellUV, vec4(edgeCen, 0.0));
        vec4 hp;
        uvec4 hpa = imageLoad(edgeGridHeadPointers, cellUV);
        hp.x = hpa.x;

        vec4 hpOrig = hp;
        bool matchFound = false;

        float minDelta = 1000000.0;
        while (hp.x > 0.50 && targetPosG.x > 99990.0) { // value exists
            uint counterHp = uint(round(hp.x+0.0));
            uint hpy = counterHp/(2*int(g_triangleTexDim));
            uint hpx = counterHp-uint(hpy*(2*int(g_triangleTexDim)));
            vec4 hpCen = imageLoad(edgeDataCenter, ivec2(hpx, hpy));
            vec4 hpIds = imageLoad(edgeDataIds, ivec2(hpx, hpy));

            float eps = 0.0001;
            vec3 delta = hpCen.xyz-pos.xyz;
            float kobe = dot(delta,delta);


    //        float tidi = round(hpIds.x);
    //       if (dot(delta,delta)<eps && uint(round(hpIds.x)) != triangleId) {
    //            uint tid = triangleId*3;
    //            uint tidy = tid/(3*int(g_triangleTexDim));
    //            ivec2 tidUV = ivec2(tid-uint(tidy*3*int(g_triangleTexDim))+i, tidy);
    //            imageStore(triangleIds, tidUV, vec4(hpIds.x, 0.0, 0.0, 0.0));
    //        }

          //  posNois = vec3(0.0);
          //  vel.xyz = vec3(0.0);
         //   pos.xyz = hpCen.xyz;

          //  pos += delta*0.98;

            if (kobe < minDelta) {
                targetPosG.xyz = vec3(hpCen.xyz);
                minDelta = kobe;
            }

         //   break;

            hp.x = hpIds.z;
        }


        if (targetPosG.x < 99990.0) {
           vec3 delta = targetPosG.xyz-pos.xyz;
           posNois = delta*g_partToMeshForce;
           vel.xyz *= 1.0-per*g_partToMeshVelDamp;
        }
    }


    vec3 posr = pos.xyz-g_radForcePos.xyz;
    float posLen = sqrt(dot(posr.xyz,posr.xyz));
    vec3 rad = posr.xyz/posLen;
    posNois.xyz += rad*g_radForceStatic;
    posNois.xyz += rad/(posLen*g_radForceDamp+1.0)*g_radForceDist;

    posr = pos.xyz-g_radForce2Pos.xyz;
    posLen = sqrt(dot(posr.xyz,posr.xyz));
    rad = posr.xyz/posLen;
    posNois.xyz += rad*g_radForce2Static;
    posNois.xyz += rad/(posLen*g_radForce2Damp+1.0)*g_radForce2Dist;


    vel.xyz += forceMul*forceMul*g_force*myTimeStep*posNois.xyz*timeStepScale*k; // (0.2+0.15*sin(g_time*1.0));




    vel.xyz *= (1.0-myTimeStep*g_velDamping);

//    if (per > 0.0) {
//        vel.xyz *= pow(1.0-0.0333*g_velDamping, per);
//    } else {
//        vel.xyz *= -pow(1.0-0.0333*g_velDamping, -per);
//    }

    pos4 = vec4(pos, 1.0);
   // pos4.w = 1.0;
    posScreen = mvp*pos4;

  //  pI = posScreen;

    posG = pos;
    uvG = uv;
    velG = vel;
    colG = col;

    paramsG = paramsV[0];


    float br = dot(vec3(1.0), abs(colG.rgb));
    if (br < g_partDiscardBright && age>0.25) {
        return;
    }

    ageG = age;
    recG = rec;
    ageSplitG = ageSplit;
  //  posInitG = pI;

//    if (gl_PrimitiveIDIn > (g_numOld/3)/3-1) {
//      return;
//    }


    EmitVertex();
    EndPrimitive();


    if (split == 1 && rec < 1.5) {
        for (int i=0; i<4; i++) {
            posG = pos;
            uvG = uv;
            velG += g_splitAmpRand*vec3(fbm(pos*(i+0.2)*23.0), 0.0+fbm(pos*(i*0.2+0.2)*10.80+vec3(g_time, 0.0, g_time*0.01)), nois(pos*(i*0.4+0.1)*32.12+vec3(g_time*0.34, 0.0, g_time*0.71)));
            velG += rNormal*g_splitAmpNorm;
            //velG = normalize(velG)*velRefl;
            ageG = age;
            recG = 2.0;
            ageSplitG = ageSplit;
        //    posInitG = pI;
            EmitVertex();
		    EndPrimitive();
        }
    }
	


   // gl_PrimitiveID = gl_PrimitiveIDIn;

      int counter = int(atomicCounter(ac));
      // if (counter > 0 && (gl_PrimitiveIDIn-500) < counter && (gl_PrimitiveIDIn-500) >= 0) {
      if (counter > 0 && gl_PrimitiveIDIn < counter && g_timeStep > 0.0) {
          counter = gl_PrimitiveIDIn;
          uint cy = counter/(1280);
          uint cx = counter-uint(cy*1280);
          ivec2 listCoord = ivec2(cx,cy);
          vec4 pW = imageLoad(emittedPartPos, listCoord);
          vec4 pVel = imageLoad(emittedPartVel, listCoord);
          vec4 pCol = imageLoad(emittedPartCol, listCoord);

            posG = pW.xyz;
            uvG = vec2(0.0);
            velG = pVel.xyz;
            ageG = 0.01+age*rand(pVel.xz);
            paramsG[0] = rand(pW.xy+pW.yz);
            colG = pCol.rgb;
            recG = 1.0;
            ageSplitG = 0.0;
            targetPosG = vec4(99999.0);
        //    posInitG = vec4(0.0);
            EmitVertex();
            EndPrimitive();
        }
//    posG = pos;
//    uvG = uv;
//    velG = vel;
//    ageG = age;
//    recG = rec;
//    ageSplitG = ageSplit;
//    posInitG = posInit;
//    EmitVertex();

}
