import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene {
    FlyCamera { id: flyCam }
    Defaults {}

    ShaderAtomicCounter { name: "part"+"sacVortex1"; clear: true }

    Mesh { name: "mesh1" }
    Mesh { name: "mesh2" }
    Mesh { name: "mesh3" }

    Blit { textureRT: "depth"; blitRT: 1}

    EmitPart {
        id: emitPart
        name: "part"
        // do not modify this dynamically on fly during the demo
        maxParticles: 1000000
        clearParticleEmits: false
    }

    Overlay { name: "ovl1" }
    Overlay { name: "ovl2" }
    Overlay { name: "ovl3" }
    Overlay { name: "ovl4" }

    Blit { textureRT: "emitBuf"; blitRT: 2 }

    MotionBlur { }
    Reflect { }

    PrevBlur { }

    Coords {}
    Tonemap {}

    Overlay { name: "ovlFin1" }

    SMAA {}
}
