// Generated by Haxe 3.4.7
(function ($hx_exports, $global) { "use strict";
$hx_exports["kvg"] = $hx_exports["kvg"] || {};
$hx_exports["kvg"]["core"] = $hx_exports["kvg"]["core"] || {};
$hx_exports["wl"] = $hx_exports["wl"] || {};
$hx_exports["wl"]["util"] = $hx_exports["wl"]["util"] || {};
var $hxClasses = {},$estr = function() { return js_Boot.__string_rec(this,''); };
function $extend(from, fields) {
	function Inherit() {} Inherit.prototype = from; var proto = new Inherit();
	for (var name in fields) proto[name] = fields[name];
	if( fields.toString !== Object.prototype.toString ) proto.toString = fields.toString;
	return proto;
}
var wl_core_Signal = function() {
	this.callbacks = [];
};
$hxClasses["wl.core.Signal"] = wl_core_Signal;
wl_core_Signal.__name__ = ["wl","core","Signal"];
wl_core_Signal.prototype = {
	connect: function(callback) {
		this.callbacks.push(callback);
	}
	,disconnect: function(callback) {
		HxOverrides.remove(this.callbacks,callback);
	}
	,emit: function(param) {
		var _g = 0;
		var _g1 = this.callbacks;
		while(_g < _g1.length) {
			var cb = _g1[_g];
			++_g;
			cb(param);
		}
	}
	,__class__: wl_core_Signal
};
var DemoMain = $hx_exports["wl"]["DemoMain"] = function() {
	var rnd = new wl_util_Random(123);
	var m = Math;
	m.random = $bind(rnd,rnd.NextFloat);
};
$hxClasses["DemoMain"] = DemoMain;
DemoMain.__name__ = ["DemoMain"];
DemoMain.setup = function() {
};
DemoMain.onSoundReady = function() {
	var fft = wl_sounds_SoundWL.getFFT().waveformLeft;
	DemoMain.canvas = window.document.createElement("canvas");
	DemoMain.ctx2d = DemoMain.canvas.getContext("2d",null);
	DemoMain.canvas.width = fft.length;
	DemoMain.canvas.height = 128;
	DemoMain.ctx2d.fillStyle = "#000";
	DemoMain.ctx2d.fillRect(0,0,fft.length,128);
	DemoMain.canvas.style.position = "fixed";
	DemoMain.canvas.style.right = "0px";
	DemoMain.canvas.style.left = "0px";
};
DemoMain.update = function(ts,partial,frameTime,delta) {
};
DemoMain.prototype = {
	__class__: DemoMain
};
var HxOverrides = function() { };
$hxClasses["HxOverrides"] = HxOverrides;
HxOverrides.__name__ = ["HxOverrides"];
HxOverrides.cca = function(s,index) {
	var x = s.charCodeAt(index);
	if(x != x) {
		return undefined;
	}
	return x;
};
HxOverrides.substr = function(s,pos,len) {
	if(len == null) {
		len = s.length;
	} else if(len < 0) {
		if(pos == 0) {
			len = s.length + len;
		} else {
			return "";
		}
	}
	return s.substr(pos,len);
};
HxOverrides.remove = function(a,obj) {
	var i = a.indexOf(obj);
	if(i == -1) {
		return false;
	}
	a.splice(i,1);
	return true;
};
HxOverrides.iter = function(a) {
	return { cur : 0, arr : a, hasNext : function() {
		return this.cur < this.arr.length;
	}, next : function() {
		return this.arr[this.cur++];
	}};
};
var Main = function() { };
$hxClasses["Main"] = Main;
Main.__name__ = ["Main"];
Main.main = function() {
	$(window).ready(Main.windowReady);
};
Main.windowReady = function(e) {
	wl_util_LoadManager.onComplete = Main.onAssetsLoaded;
	Main.jsonConfigurator = new wl_setup_JsonConfigurator();
	Main.jsonConfigurator.fromJson(haxe_Resource.getString("Demo.json"));
	DemoMain.setup();
	$("#setup").css("display","none");
	Main.demo = new wl_core_Demo();
	if(!wl_core_Config.DEBUG) {
		$(".debug").css("display","none");
		$("#debug").find("input").attr("checked",null);
		$(".checkbox").css("display","none");
	}
	if(wl_util_LoadManager.get_totalCount() == 0) {
		Main.assetsLoaded = true;
	}
	wl_sounds_SoundWL.onSoundLoaded.connect(Main.onSoundLoaded);
	wl_sounds_SoundWL.init();
};
Main.onAssetsLoaded = function() {
	Main.assetsLoaded = true;
	Main.loadReady();
};
Main.onSoundLoaded = function() {
	Main.soundLoaded = true;
	DemoMain.onSoundReady();
	Main.loadReady();
};
Main.loadReady = function() {
	if(Main.assetsLoaded && Main.soundLoaded) {
		$("#setup").css("display","");
		wl_setup_Setup.init(Main.demo);
	}
};
Math.__name__ = ["Math"];
var Reflect = function() { };
$hxClasses["Reflect"] = Reflect;
Reflect.__name__ = ["Reflect"];
Reflect.field = function(o,field) {
	try {
		return o[field];
	} catch( e ) {
		return null;
	}
};
Reflect.compare = function(a,b) {
	if(a == b) {
		return 0;
	} else if(a > b) {
		return 1;
	} else {
		return -1;
	}
};
Reflect.isEnumValue = function(v) {
	if(v != null) {
		return v.__enum__ != null;
	} else {
		return false;
	}
};
var Std = function() { };
$hxClasses["Std"] = Std;
Std.__name__ = ["Std"];
Std.string = function(s) {
	return js_Boot.__string_rec(s,"");
};
var StringTools = function() { };
$hxClasses["StringTools"] = StringTools;
StringTools.__name__ = ["StringTools"];
StringTools.replace = function(s,sub,by) {
	return s.split(sub).join(by);
};
var Type = function() { };
$hxClasses["Type"] = Type;
Type.__name__ = ["Type"];
Type.getClassName = function(c) {
	var a = c.__name__;
	if(a == null) {
		return null;
	}
	return a.join(".");
};
Type.resolveClass = function(name) {
	var cl = $hxClasses[name];
	if(cl == null || !cl.__name__) {
		return null;
	}
	return cl;
};
Type.createInstance = function(cl,args) {
	var _g = args.length;
	switch(_g) {
	case 0:
		return new cl();
	case 1:
		return new cl(args[0]);
	case 2:
		return new cl(args[0],args[1]);
	case 3:
		return new cl(args[0],args[1],args[2]);
	case 4:
		return new cl(args[0],args[1],args[2],args[3]);
	case 5:
		return new cl(args[0],args[1],args[2],args[3],args[4]);
	case 6:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5]);
	case 7:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6]);
	case 8:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7]);
	case 9:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8]);
	case 10:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9]);
	case 11:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9],args[10]);
	case 12:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9],args[10],args[11]);
	case 13:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9],args[10],args[11],args[12]);
	case 14:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9],args[10],args[11],args[12],args[13]);
	default:
		throw new js__$Boot_HaxeError("Too many arguments");
	}
};
var BABYLON_IBehaviorAware = function() { };
$hxClasses["BABYLON.IBehaviorAware"] = BABYLON_IBehaviorAware;
BABYLON_IBehaviorAware.__name__ = ["BABYLON","IBehaviorAware"];
BABYLON_IBehaviorAware.prototype = {
	__class__: BABYLON_IBehaviorAware
};
var ballcluster_Ball = function(ball,scene) {
	this.rings = [];
	BABYLON.TransformNode.call(this,"",scene);
	this.createRing(5,0,1,ball,scene);
	this.createRing(8,2,2.0,ball,scene);
	this.createRing(9,4,2.4,ball,scene);
	this.createRing(8,6,2.0,ball,scene);
	this.createRing(5,8,1.0,ball,scene);
};
$hxClasses["ballcluster.Ball"] = ballcluster_Ball;
ballcluster_Ball.__name__ = ["ballcluster","Ball"];
ballcluster_Ball.__super__ = BABYLON.TransformNode;
ballcluster_Ball.prototype = $extend(BABYLON.TransformNode.prototype,{
	createRing: function(balls,y,radius,ball,scene) {
		var node = new BABYLON.TransformNode("",scene);
		node.position.y = y;
		var _g1 = 0;
		var _g = balls;
		while(_g1 < _g) {
			var v = _g1++;
			var b = ball.createInstance("");
			b.radius = radius;
			b.angle = Math.PI * 2 * v / balls;
			b.position.x = Math.cos(Math.PI * 2 * v / balls) * radius * 2;
			b.position.z = Math.sin(Math.PI * 2 * v / balls) * radius * 2;
			b.originalPosition = b.position.clone();
			b.parent = node;
		}
		this.rings.push(node);
		node.parent = this;
	}
	,update: function(delta) {
		var i = 0;
		var _g = 0;
		var _g1 = this.rings;
		while(_g < _g1.length) {
			var r = _g1[_g];
			++_g;
			i += 0.0028;
			var _g2 = 0;
			var _g3 = r.getChildren();
			while(_g2 < _g3.length) {
				var b = _g3[_g2];
				++_g2;
				b.position.x += (b.originalPosition.x - b.position.x) / 5;
				b.position.z += (b.originalPosition.z - b.position.z) / 5;
				b.position.y += (b.originalPosition.y - b.position.y) / 5;
			}
		}
	}
	,pulse: function() {
		var _g = 0;
		var _g1 = this.rings;
		while(_g < _g1.length) {
			var r = _g1[_g];
			++_g;
			var _g2 = 0;
			var _g3 = r.getChildren();
			while(_g2 < _g3.length) {
				var b = _g3[_g2];
				++_g2;
				var box = b;
				var nextpos = box.position.multiply(new BABYLON.Vector3(4,4,4));
				nextpos.y = r.position.y * 4;
				createjs.Tween.get(box.position).to({ x : nextpos.x, y : nextpos.y, z : nextpos.z},1000);
			}
		}
	}
	,__class__: ballcluster_Ball
});
var wl_core_Part = function() {
	this.customPosts = [];
	this.autoClear = true;
	this.multiPart = false;
	this.clearColor = wl_core_Config.CLEAR_COLOR;
	this.generateDepthMap = true;
	this.renderToScreen = false;
	this.inTransition = false;
	this.running = false;
	this.isActive = false;
};
$hxClasses["wl.core.Part"] = wl_core_Part;
wl_core_Part.__name__ = ["wl","core","Part"];
wl_core_Part.prototype = {
	get_engine: function() {
		return wl_core_Graphics.instance.renderer;
	}
	,init: function() {
		this.triggers = new haxe_ds_ObjectMap();
		this.scene = new BABYLON.Scene(wl_core_Graphics.instance.renderer);
		this.renderTo = new BABYLON.RenderTargetTexture("part rt",{ width : wl_core_Config.RESOLUTION[0], height : wl_core_Config.RESOLUTION[1]},this.scene,false);
		this.scene.customRenderTargets.push(this.renderTo);
		this.scene.renderTargetsEnabled = true;
	}
	,initPipeline: function(post) {
		post.bloom = post.bloom == null ? false : post.bloom;
		post.chromaticAberration = post.chromaticAberration == null ? false : post.chromaticAberration;
		post.dof = post.dof == null ? false : post.dof;
		post.fxaa = post.fxaa == null ? false : post.fxaa;
		post.grain = post.grain == null ? false : post.grain;
		post.imageProcessing = post.imageProcessing == null ? false : post.imageProcessing;
		post.sharpen = post.sharpen == null ? false : post.sharpen;
		this.pipeline = new BABYLON.DefaultRenderingPipeline(this.name + ":pipeline",true,this.scene,[this.camera]);
		this.pipeline.bloomEnabled = post.bloom;
		this.pipeline.chromaticAberrationEnabled = post.chromaticAberration;
		this.pipeline.depthOfFieldEnabled = post.dof;
		this.pipeline.fxaaEnabled = post.fxaa;
		this.pipeline.grainEnabled = post.grain;
		this.pipeline.imageProcessingEnabled = post.imageProcessing;
		this.pipeline.sharpenEnabled = post.sharpen;
		this.post = { };
		this.post.bloom = this.pipeline;
		this.post.chromaticAberration = this.pipeline.chromaticAberration;
		this.post.dof = this.pipeline.depthOfField;
		this.post.fxaa = this.pipeline.fxaa;
		this.post.grain = this.pipeline.grain;
		this.post.imageProcessing = this.pipeline.imageProcessing;
		this.post.sharpen = this.pipeline.sharpen;
		if(post.distort) {
			var tmp = this.camera;
			var tmp1 = this.scene.getEngine();
			this.post.distort = new wl_post_distort_DistortPostProcess(tmp,tmp1);
			this.camera.attachPostProcess(this.post.distort);
			this.customPosts.push(this.post.distort);
		}
		if(post.displacement) {
			var tmp2 = this.camera;
			var tmp3 = this.scene.getEngine();
			this.post.displacement = new wl_post_displacement_Displacement(tmp2,tmp3);
			this.camera.attachPostProcess(this.post.displacement);
			this.customPosts.push(this.post.displacement);
		}
	}
	,postInit: function() {
	}
	,setupDatGui: function(folder) {
		if(this.camera != null) {
			var cam = folder.addFolder("camera");
			cam.add(this.camera,"fov");
		}
		var _g = 0;
		var _g1 = this.customPosts;
		while(_g < _g1.length) {
			var pp = _g1[_g];
			++_g;
			if(pp.setupDatGui != null) {
				pp.setupDatGui(folder.addFolder(Type.getClassName(pp == null ? null : js_Boot.getClass(pp))));
			}
		}
		if(this.pipeline != null) {
			wl_debug_PostProcessSliders.applySliders(folder,this.pipeline);
		}
	}
	,start: function(ts) {
		this.running = true;
	}
	,stop: function() {
		this.running = false;
	}
	,setRenderToScreen: function(value) {
		this.renderToScreen = value;
	}
	,update: function(ts,partial,frameTime,delta) {
	}
	,render: function(ts,frameTime,toScreen) {
		if(toScreen) {
			this.scene.render();
		} else if(this.renderTo != null) {
			this.renderTo.render(false);
		}
	}
	,addTrigger: function(timesig,handler) {
		if(this.triggers.h.__keys__[timesig.__id__] != null) {
			this.triggers.h[timesig.__id__].push(handler);
		} else {
			this.triggers.set(timesig,[handler]);
		}
	}
	,removeTrigger: function(handler,timesig) {
		if(timesig != null && this.triggers.h.__keys__[timesig.__id__] != null) {
			HxOverrides.remove(this.triggers.h[timesig.__id__],handler);
		} else {
			var t = this.triggers.iterator();
			while(t.hasNext()) {
				var t1 = t.next();
				while(t1.indexOf(handler) >= 0) HxOverrides.remove(t1,handler);
			}
		}
	}
	,initStandardScene: function() {
		this.scene.clearColor = this.clearColor;
		this.scene.autoClear = true;
		this.camera = new BABYLON.UniversalCamera("mainCamera",new BABYLON.Vector3(0,5,-10),this.scene);
		this.camera.setTarget(BABYLON.Vector3.Zero());
		if(this.generateDepthMap) {
			this.depthRenderer = this.scene.enableDepthRenderer();
			this.depthMap = this.depthRenderer.getDepthMap();
		}
		wl_debug_ManualControl.attachPart(this);
	}
	,__class__: wl_core_Part
};
var ballcluster_BallCluster = function() {
	this.balls = [];
	wl_core_Part.call(this);
};
$hxClasses["ballcluster.BallCluster"] = ballcluster_BallCluster;
ballcluster_BallCluster.__name__ = ["ballcluster","BallCluster"];
ballcluster_BallCluster.__super__ = wl_core_Part;
ballcluster_BallCluster.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var skybox = BABYLON.MeshBuilder.CreateBox("skyBox",{ width : 100, depth : 100, height : 100},this.scene);
		var light = new BABYLON.HemisphericLight("",BABYLON.Vector3.Up(),this.scene);
		this.smallBallMaterial = new BABYLON.StandardMaterial("smallballmat",this.scene);
		this.smallBallMaterial.diffuseColor = new BABYLON.Color3(1,0,0);
		var ball = BABYLON.MeshBuilder.CreateSphere("",{ diameter : 2.5},this.scene);
		ball.material = this.smallBallMaterial;
		ball.isVisible = false;
		this.smallBallMaterial.diffuseColor = BABYLON.Color3.FromHexString("#5d0089");
		this.smallBallMaterial.specularColor = BABYLON.Color3.FromHexString("#ffffff");
		this.smallBallMaterial.emissiveColor = BABYLON.Color3.FromHexString("#0a0007");
		var _g = 0;
		while(_g < 3) {
			var i = _g++;
			var ball1 = new ballcluster_Ball(ball,this.scene);
			ball1.position.x = Math.cos(Math.PI * 2 * i / 3) * 20;
			ball1.position.z = Math.sin(Math.PI * 2 * i / 3) * 20;
			this.balls.push(ball1);
		}
		this.camera.position.x = 0;
		this.camera.position.y = -30;
		this.camera.position.z = 0;
		this.camera.setTarget(BABYLON.Vector3.Zero());
		this.addTrigger(new wl_core_TimeSig(1,0,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.pulse));
	}
	,pulse: function(ts) {
		var _g = 0;
		var _g1 = this.balls;
		while(_g < _g1.length) {
			var b = _g1[_g];
			++_g;
			b.pulse();
		}
	}
	,update: function(ts,partial,frameTime,delta) {
		var _g = 0;
		var _g1 = this.balls;
		while(_g < _g1.length) {
			var b = _g1[_g];
			++_g;
			b.update(delta);
		}
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,setupDatGui: function(folder) {
		wl_core_Part.prototype.setupDatGui.call(this,folder);
		var f = folder.addFolder("smallball");
		wl_util_DatGuiHelper.addColor(f,this.smallBallMaterial,"emissiveColor");
		wl_util_DatGuiHelper.addColor(f,this.smallBallMaterial,"specularColor");
		wl_util_DatGuiHelper.addColor(f,this.smallBallMaterial,"diffuseColor");
	}
	,__class__: ballcluster_BallCluster
});
var blank_Blank = function() {
	wl_core_Part.call(this);
};
$hxClasses["blank.Blank"] = blank_Blank;
blank_Blank.__name__ = ["blank","Blank"];
blank_Blank.__super__ = wl_core_Part;
blank_Blank.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var sphere = BABYLON.MeshBuilder.CreateSphere("sphere1",{ segments : 16, diameter : 2},this.scene);
		var ground = BABYLON.MeshBuilder.CreateGround("ground1",{ height : 6, width : 6, subdivisions : 2},this.scene);
		var light = new BABYLON.HemisphericLight("light1",new BABYLON.Vector3(0,1,0),this.scene);
		sphere.position.y = 1;
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: blank_Blank
});
var blank_Blank2 = function() {
	wl_core_Part.call(this);
};
$hxClasses["blank.Blank2"] = blank_Blank2;
blank_Blank2.__name__ = ["blank","Blank2"];
blank_Blank2.__super__ = wl_core_Part;
blank_Blank2.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var box = BABYLON.MeshBuilder.CreateBox("box1",{ width : 2, height : 2, depth : 2},this.scene);
		var ground = BABYLON.MeshBuilder.CreateGround("ground1",{ height : 6, width : 6, subdivisions : 2},this.scene);
		var light = new BABYLON.HemisphericLight("light1",new BABYLON.Vector3(0,1,0),this.scene);
		box.position.y = 1;
		this.scene.clearColor = new BABYLON.Color4(0,1,0);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: blank_Blank2
});
var blank_SpsBlank = function() {
	wl_core_Part.call(this);
};
$hxClasses["blank.SpsBlank"] = blank_SpsBlank;
blank_SpsBlank.__name__ = ["blank","SpsBlank"];
blank_SpsBlank.__super__ = wl_core_Part;
blank_SpsBlank.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var nb = 160000;
		var fact = 100;
		var myPositionFunction = function(particle,i,s) {
			var myPositionFunction1 = Math.random() - 0.5;
			particle.position.x = myPositionFunction1 * fact;
			var myPositionFunction2 = Math.random() - 0.5;
			particle.position.y = myPositionFunction2 * fact;
			var myPositionFunction3 = Math.random() - 0.5;
			particle.position.z = myPositionFunction3 * fact;
			var myPositionFunction4 = Math.random();
			particle.rotation.x = myPositionFunction4 * 3.15;
			var myPositionFunction5 = Math.random();
			particle.rotation.y = myPositionFunction5 * 3.15;
			var myPositionFunction6 = Math.random();
			particle.rotation.z = myPositionFunction6 * 1.5;
			particle.color = new BABYLON.Color4(particle.position.x / fact + 0.5,particle.position.y / fact + 0.5,particle.position.z / fact + 0.5,1.0);
		};
		var triangle = BABYLON.MeshBuilder.CreateDisc("t",{ tessellation : 3, sideOrientation : BABYLON.Mesh.DOUBLESIDE},this.scene);
		var SPS = new BABYLON.SolidParticleSystem("SPS",this.scene,{ updatable : false});
		SPS.addShape(triangle,nb,{ positionFunction : myPositionFunction});
		var mesh = SPS.buildMesh();
		triangle.dispose();
		this.camera.position.z = -150;
		this.camera.position.y = 50;
		this.camera.setTarget(new BABYLON.Vector3(0,0,0));
		var light = new BABYLON.HemisphericLight("light1",new BABYLON.Vector3(0,1,0),this.scene);
		this.scene.clearColor = new BABYLON.Color4(1,1,1);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: blank_SpsBlank
});
var chainedball_Chain = function(p1,pc,p2,scale,scene) {
	this.links = [];
	this.start = p1;
	this.control = pc;
	this.target = p2;
	var anchor1 = BABYLON.MeshBuilder.CreateSphere("anchor",{ diameter : 0.5},scene);
	anchor1.position.copyFrom(p1);
	anchor1.visibility = 0.0;
	anchor1.dispose();
	var linkMesh = this.buildLink(scene);
	linkMesh.scaling.copyFrom(scale);
	linkMesh.bakeCurrentTransformIntoVertices();
	var bb = linkMesh.getBoundingInfo().boundingBox;
	var count = Math.ceil(BABYLON.Vector3.Distance(p1,p2) / (bb.maximum.y - bb.minimum.y) * 1.4);
	var mass = 1 / count;
	var directionCurve = BABYLON.Curve3.CreateQuadraticBezier(p1,pc,p2,count);
	var count1 = Math.ceil(directionCurve.length() / (bb.maximum.y - bb.minimum.y) * 1.4);
	var directionCurve1 = BABYLON.Curve3.CreateQuadraticBezier(p1,pc,p2,count1);
	var _g1 = 0;
	var _g = count1;
	while(_g1 < _g) {
		var i = _g1++;
		var il = linkMesh.createInstance("");
		var node = new BABYLON.TransformNode("",scene);
		il.parent = node;
		il.position.copyFrom(BABYLON.Vector3.Zero());
		var points = directionCurve1.getPoints();
		var vec = points[i];
		node.position.copyFrom(vec);
		var vNext = i < points.length - 1 ? points[i + 1] : p2;
		node.lookAt(vNext);
		if(i % 2 == 1) {
			il.rotate(BABYLON.Vector3.Up(),Math.PI * 0.5);
			il.rotate(BABYLON.Vector3.Forward(),Math.PI / 2);
		} else {
			il.rotate(BABYLON.Vector3.Right(),Math.PI / 2);
		}
		this.links.push(node);
	}
};
$hxClasses["chainedball.Chain"] = chainedball_Chain;
chainedball_Chain.__name__ = ["chainedball","Chain"];
chainedball_Chain.prototype = {
	updateChain: function() {
		var directionCurve = BABYLON.Curve3.CreateQuadraticBezier(this.start,this.control,this.target,this.links.length);
		var i = 0;
		var _g = 0;
		var _g1 = this.links;
		while(_g < _g1.length) {
			var node = _g1[_g];
			++_g;
			var points = directionCurve.getPoints();
			var vec = points[i];
			node.position.copyFrom(vec);
			var vNext = i < points.length - 1 ? points[i + 1] : this.target;
			node.lookAt(vNext);
			++i;
		}
	}
	,buildLink: function(scene) {
		var points = [new BABYLON.Vector3(0.1,0.07,0)];
		var curve = BABYLON.Curve3.CreateCubicBezier(new BABYLON.Vector3(0.1,0.18,0),new BABYLON.Vector3(0.1,0.28,0),new BABYLON.Vector3(-0.1,0.28,0),new BABYLON.Vector3(-0.1,0.18,0),6);
		points = points.concat(curve.getPoints());
		curve = BABYLON.Curve3.CreateCubicBezier(new BABYLON.Vector3(-0.1,-0.18,0),new BABYLON.Vector3(-0.1,-0.28,0),new BABYLON.Vector3(0.1,-0.28,0),new BABYLON.Vector3(0.1,-0.18,0),6);
		points = points.concat(curve.getPoints());
		points.push(points[0].subtract(new BABYLON.Vector3(0,0.015,0)));
		var linkMesh = BABYLON.MeshBuilder.CreateTube("Chain-Link",{ radius : 0.05, path : points, cap : 3, tessellation : 6},scene);
		chainedball_Chain.linkmaterial = wl_library_Library.get_instance().getMaterial(wl_library_Materials.ghost,true);
		chainedball_Chain.linkmaterial.fresnelopacity = chainedball_Chain.linkmaterial.opacityFresnelParameters;
		chainedball_Chain.linkmaterial.alpha = 1.0;
		linkMesh.material = chainedball_Chain.linkmaterial;
		linkMesh.setEnabled(false);
		return linkMesh;
	}
	,ghost: function() {
		chainedball_Chain.linkmaterial.alpha = 0.1;
		chainedball_Chain.linkmaterial.emissiveColor = new BABYLON.Color3(1,1,1);
		chainedball_Chain.linkmaterial.opacityFresnelParameters = chainedball_Chain.linkmaterial.fresnelopacity;
	}
	,normalize: function() {
		chainedball_Chain.linkmaterial.alpha = 1.0;
		chainedball_Chain.linkmaterial.emissiveColor = new BABYLON.Color3(0,0,0);
		chainedball_Chain.linkmaterial.opacityFresnelParameters = null;
	}
	,__class__: chainedball_Chain
};
var chainedball_ChainedBall = function() {
	this.greetNames = ["greet_adapt.png","greet_alumni.png","greet_ananasmurska.png","greet_artline_designs.png","greet_byterapers.png","greet_damones.png","greet_darklite.png","greet_dekadence.png","greet_ekspert.png","greet_epoch.png","greet_hedelmae.png","greet_jumalauta.png","greet_kewlers.png","greet_matt_current.png","greet_paraguay.png","greet_primitive.png","greet_npli.png","greet_pyrotech.png","greet_quadtrip.png","greet_scenesat.png","greet_tahtituho.png","greet_traction.png"];
	this.greetChains = [];
	this.exposureMP = 0;
	this.bgColor = DemoMain.BASE_1.clone().scale(0.15);
	this.chains = [];
	wl_core_Part.call(this);
};
$hxClasses["chainedball.ChainedBall"] = chainedball_ChainedBall;
chainedball_ChainedBall.__name__ = ["chainedball","ChainedBall"];
chainedball_ChainedBall.__super__ = wl_core_Part;
chainedball_ChainedBall.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.lowFilter = { isolate : true, lowLimit : 0, highLimit : 200};
		this.mediumFilter = { isolate : true, lowLimit : 700, highLimit : 1200};
		this.highFilter = { isolate : true, lowLimit : 1000, highLimit : 16000};
		this.analyzer = new wl_sounds_SoundAnalyzer();
		this.analyzer.historySize = 10;
		this.analyzer.filters.push(this.lowFilter);
		this.analyzer.filters.push(this.mediumFilter);
		this.analyzer.filters.push(this.highFilter);
		var rpProp = { };
		rpProp.bloom = true;
		rpProp.chromaticAberration = true;
		rpProp.distort = true;
		rpProp.dof = true;
		rpProp.grain = true;
		rpProp.imageProcessing = true;
		rpProp.sharpen = false;
		rpProp.fxaa = false;
		rpProp.displacement = true;
		this.initPipeline(rpProp);
		this.post.grain.animated = true;
		this.post.displacement.scaleX = 0.04;
		this.post.displacement.scaleY = 0.02;
		this.post.displacement.zoom = 0.5;
		this.post.distort.lineHeight = wl_core_Config.RESOLUTION[1] / 60;
		this.post.imageProcessing.vignetteEnabled = true;
		var sphere = BABYLON.MeshBuilder.CreateSphere("sphere1",{ segments : 16, diameter : 8},this.scene);
		var light = new BABYLON.HemisphericLight("light1",new BABYLON.Vector3(0,1,0),this.scene);
		sphere.position.y = 5;
		sphere.position.y = 8;
		var glowCube = BABYLON.MeshBuilder.CreateSphere("box",{ diameter : 500, sideOrientation : BABYLON.Mesh.DOUBLESIDE},null);
		var glowMat = new BABYLON.StandardMaterial("",null);
		glowMat.diffuseColor = DemoMain.BLACK.clone();
		glowMat.ambientColor = DemoMain.BLACK.clone();
		glowMat.emissiveColor = DemoMain.WHITE.clone().scale(0.005);
		glowCube.material = glowMat;
		this.scene.addMesh(glowCube);
		var utscale = new BABYLON.Vector3(8,8,8);
		this.chains.push(new chainedball_Chain(new BABYLON.Vector3(-60,5,-40),new BABYLON.Vector3(-30,0,-20),sphere.position,utscale,this.scene));
		this.chains.push(new chainedball_Chain(new BABYLON.Vector3(-60,5,40),new BABYLON.Vector3(-30,0,20),sphere.position,utscale,this.scene));
		this.chains.push(new chainedball_Chain(new BABYLON.Vector3(60,5,-40),new BABYLON.Vector3(30,0,-20),sphere.position,utscale,this.scene));
		this.chains.push(new chainedball_Chain(new BABYLON.Vector3(60,5,40),new BABYLON.Vector3(30,0,20),sphere.position,utscale,this.scene));
		this.chains.push(new chainedball_Chain(new BABYLON.Vector3(-30,-55,-20),new BABYLON.Vector3(-15,-22,-10),sphere.position,utscale,this.scene));
		this.chains.push(new chainedball_Chain(new BABYLON.Vector3(-30,-55,20),new BABYLON.Vector3(-15,-22,10),sphere.position,utscale,this.scene));
		this.chains.push(new chainedball_Chain(new BABYLON.Vector3(30,-55,-20),new BABYLON.Vector3(15,-22,-10),sphere.position,utscale,this.scene));
		this.chains.push(new chainedball_Chain(new BABYLON.Vector3(30,-55,20),new BABYLON.Vector3(15,-22,10),sphere.position,utscale,this.scene));
		var meshes = [];
		var _g = 0;
		while(_g < 500) {
			var i = _g++;
			var b = BABYLON.MeshBuilder.CreateBox("",{ width : 5, height : 5, depth : 5},this.scene);
			var tmp = wl_util_Random.nextFloat() * 5 * 30;
			b.position.x = -50 + tmp;
			var tmp1 = wl_util_Random.nextFloat() * 5 * 30;
			b.position.z = -250 + tmp1;
			b.position.y = -25;
			b.rotate(new BABYLON.Vector3(Math.PI * 2 * wl_util_Random.nextFloat(),Math.PI * 2 * wl_util_Random.nextFloat(),Math.PI * 2 * wl_util_Random.nextFloat()),Math.PI * wl_util_Random.nextFloat());
			meshes.push(b);
		}
		var g = BABYLON.Mesh.MergeMeshes(meshes,true,true);
		var _g1 = 0;
		while(_g1 < meshes.length) {
			var m = meshes[_g1];
			++_g1;
			m.dispose();
		}
		var gmaterial = new BABYLON.StandardMaterial("",this.scene);
		gmaterial.diffuseColor = new BABYLON.Color3(0.2,0.2,0.2);
		g.material = gmaterial;
		var scale = new BABYLON.Vector3(4,4,4);
		var _g2 = -20;
		while(_g2 < -8) {
			var z = _g2++;
			var _g11 = -2;
			while(_g11 < 5) {
				var x = _g11++;
				var xchange = wl_util_Random.nextFloat() * 4;
				var time = Math.floor(wl_util_Random.nextFloat() * 2000 + 1500);
				var ysize = wl_util_Random.nextFloat() * 15 + 40;
				var ystart = 20;
				var xpos = x * 10 - wl_util_Random.nextFloat() * 9;
				var zpos = z * 10 - wl_util_Random.nextFloat() * 9;
				var p2x = xpos + xchange;
				var p2xe = xpos - xchange;
				var phase = 5 - wl_util_Random.nextFloat() * 10;
				var p1 = new BABYLON.Vector3(xpos,ystart,zpos);
				var pc = new BABYLON.Vector3(xpos - phase,ystart - ysize / 2,zpos);
				var p2 = new BABYLON.Vector3(p2x,ystart - ysize,zpos + (0.5 - wl_util_Random.nextFloat()));
				var c = new chainedball_Chain(p1,pc,p2,scale,this.scene);
				createjs.Tween.get(pc,{ loop : true}).to({ x : xpos + phase},time,createjs.Ease.sineInOut).to({ x : xpos - phase},time,createjs.Ease.sineInOut);
				createjs.Tween.get(p2,{ loop : true}).to({ x : p2xe},time,createjs.Ease.sineInOut).to({ x : p2x},time,createjs.Ease.sineInOut);
				this.chains.push(c);
				if(z > -15 && x > 0 && x < 5) {
					if(this.greetNames.length != 0) {
						var width = 5;
						c.riseSpeed = wl_core_TimeSig.milliseconds(3,0,0,0) - wl_util_Random.range(0,wl_core_TimeSig.milliseconds(1,0,0,0));
						c.batch = 0;
						if(z > -12) {
							width = 8;
							c.batch = 1;
							c.riseSpeed = wl_core_TimeSig.milliseconds(4,2,0,0) - wl_util_Random.range(0,wl_core_TimeSig.milliseconds(1,0,0,0));
						}
						if(z > -14) {
							width = 10;
							c.batch = 2;
							c.riseSpeed = wl_core_TimeSig.milliseconds(8,0,0,0) - wl_util_Random.range(0,wl_core_TimeSig.milliseconds(1,0,0,0));
						}
						var greetbox = BABYLON.MeshBuilder.CreateBox("",{ width : width, height : width - 0.5 * width, depth : 2},this.scene);
						var greetmat = new BABYLON.StandardMaterial("",this.scene);
						var greetname = this.greetNames[0];
						greetmat.diffuseTexture = wl_core_Assets.getTexture(greetname);
						HxOverrides.remove(this.greetNames,greetname);
						greetbox.material = greetmat;
						var greetnode = new BABYLON.TransformNode("",this.scene);
						greetbox.parent = greetnode;
						greetbox.position.z = 0;
						greetnode.position = c.target;
						console.log("added greetchain");
						this.greetChains.push(c);
					}
				}
			}
		}
		this.scene.fogMode = BABYLON.Scene.FOGMODE_EXP;
		this.scene.fogDensity = 0.024;
		this.scene.fogColor = this.bgColor;
		this.clearColor = this.bgColor;
		this.light1 = new BABYLON.SpotLight("",new BABYLON.Vector3(-1,0,0),new BABYLON.Vector3(2.5,0,8),Math.PI / 5,90,this.scene);
		this.light2 = new BABYLON.SpotLight("",new BABYLON.Vector3(1,0,0),new BABYLON.Vector3(-2.5,0,8),Math.PI / 5,90,this.scene);
		this.light1.parent = this.camera;
		this.light2.parent = this.camera;
		this.camera.position = new BABYLON.Vector3(7.8,14.4,-20);
		this.camera.setTarget(new BABYLON.Vector3(0,5,0));
		this.post.imageProcessing.exposure = 0;
		this.startCC = new wl_demo_CameraController(this.camera);
		this.startCC.initLinear([this.camera.position.clone(),new BABYLON.Vector3(35,8,-42)],[new BABYLON.Vector3(0,5,0),new BABYLON.Vector3(0,3,0)]);
		this.chainCC = new wl_demo_CameraController(this.camera);
		this.chainCC.initBezier([new BABYLON.Vector3(0,-12,-209),new BABYLON.Vector3(13,-4,-187),new BABYLON.Vector3(20,-7,-174),new BABYLON.Vector3(20,-7,-170)],[new BABYLON.Vector3(9,-4,0),new BABYLON.Vector3(13,0,0),new BABYLON.Vector3(19,2,0),new BABYLON.Vector3(19,2,0)]);
		this.storyboard = new wl_demo_SceneBoard();
		this.storyboard.add(wl_core_TimeSig.Zero(),new wl_core_TimeSig(5,0,0,0),this.startCC);
		this.storyboard.add(new wl_core_TimeSig(5,0,0,0),new wl_core_TimeSig(15,0,0,0),this.chainCC);
		this.addTrigger(new wl_core_TimeSig(0,0,0,0,wl_core_TimeSig.RELATIVE),function(ts) {
			var tmp2 = createjs.Tween.get(sphere.position,{ loop : true});
			var tmp3 = wl_core_TimeSig.milliseconds(3,0,0,0);
			var tmp4 = tmp2.to({ y : 0},tmp3,createjs.Ease.sineInOut);
			var tmp5 = wl_core_TimeSig.milliseconds(3,0,0,0);
			tmp4.to({ y : 8},tmp5,createjs.Ease.sineInOut);
			var tmp6 = createjs.Tween.get(_gthis);
			var tmp7 = wl_core_TimeSig.milliseconds(1,0,0,0);
			tmp6.to({ exposureMP : 1},tmp7);
		});
		this.addTrigger(new wl_core_TimeSig(4,0,0,0,wl_core_TimeSig.RELATIVE),function(ts1) {
			var tmp8 = createjs.Tween.get(_gthis);
			var tmp9 = wl_core_TimeSig.milliseconds(1,0,0,0);
			tmp8.to({ exposureMP : 0},tmp9).wait(wl_core_TimeSig.milliseconds(0,2,0,0)).call(function() {
				var tmp10 = createjs.Tween.get(_gthis);
				var tmp11 = wl_core_TimeSig.milliseconds(0,2,0,0);
				tmp10.to({ exposureMP : 1},tmp11);
			});
		});
		this.greetChains.sort(function(c1,c2) {
			if(c1.batch == c2.batch) {
				return 0;
			}
			if(c1.batch < c2.batch) {
				return -1;
			}
			return 1;
		});
		this.addTrigger(new wl_core_TimeSig(9,0,0,0,wl_core_TimeSig.RELATIVE),function(ts2) {
			_gthis.addTrigger(new wl_core_TimeSig(-1,1,0,0,wl_core_TimeSig.PATTERN),function(ts3) {
				console.log("greetchain update");
				var i1 = 0;
				var _g3 = 0;
				var _g12 = _gthis.greetChains.filter(function(gc) {
					return !gc.rising;
				});
				while(_g3 < _g12.length) {
					var gc1 = _g12[_g3];
					++_g3;
					++i1;
					if(i1 == 10) {
						break;
					}
					gc1.rising = true;
					createjs.Tween.get(gc1.start).to({ y : 50},gc1.riseSpeed);
					createjs.Tween.get(gc1.control).to({ y : 30},gc1.riseSpeed);
					createjs.Tween.get(gc1.target).to({ y : 20},gc1.riseSpeed);
				}
			});
		});
		this.addTrigger(new wl_core_TimeSig(6,0,0,0,wl_core_TimeSig.RELATIVE),function(ts4) {
			_gthis.addTrigger(new wl_core_TimeSig(1,0,0,0,wl_core_TimeSig.PATTERN),function(ts5) {
				var _g4 = 0;
				var _g13 = _gthis.chains;
				while(_g4 < _g13.length) {
					var c3 = _g13[_g4];
					++_g4;
					c3.ghost();
				}
			});
			_gthis.addTrigger(new wl_core_TimeSig(1,1,0,0,wl_core_TimeSig.PATTERN),function(ts6) {
				var _g5 = 0;
				var _g14 = _gthis.chains;
				while(_g5 < _g14.length) {
					var c4 = _g14[_g5];
					++_g5;
					c4.normalize();
				}
			});
		});
		this.addTrigger(new wl_core_TimeSig(14,0,0,0,wl_core_TimeSig.RELATIVE),function(ts7) {
			var tmp12 = createjs.Tween.get(_gthis);
			var tmp13 = wl_core_TimeSig.milliseconds(1,0,0,0);
			tmp12.to({ exposureMP : 0},tmp13);
		});
	}
	,start: function(ts) {
		this.storyboard.start(ts);
		wl_core_Part.prototype.start.call(this,ts);
		var _g = 0;
		var _g1 = this.chains;
		while(_g < _g1.length) {
			var c = _g1[_g];
			++_g;
			c.ghost();
		}
		var _g2 = 0;
		var _g11 = this.chains;
		while(_g2 < _g11.length) {
			var c1 = _g11[_g2];
			++_g2;
			c1.normalize();
		}
	}
	,update: function(ts,partial,frameTime,delta) {
		var _g = 0;
		var _g1 = this.chains;
		while(_g < _g1.length) {
			var c = _g1[_g];
			++_g;
			c.updateChain();
		}
		var time = ts.toMilliseconds() / 1000;
		this.light1.direction.x = 2.5 + 0.2 * Math.cos(time);
		this.light1.direction.y = 0.2 * Math.sin(time);
		this.light1.direction.z = 8 + 0.2 * Math.sin(time);
		this.light2.direction.x = -2.5 + 0.2 * Math.cos(time);
		this.light2.direction.y = 0.2 * Math.cos(time);
		this.light2.direction.z = 8 + 0.2 * Math.sin(time);
		this.storyboard.update(ts,partial,frameTime,delta);
		this.analyzer.update();
		this.post.grain.intensity = this.lowFilter.max * 30 + 5;
		this.post.chromaticAberration.aberrationAmount = this.mediumFilter.max < 0.8 ? 0 : (this.mediumFilter.max - 0.8) * 120;
		this.post.distort.intensity = this.mediumFilter.max < 0.8 ? 0 : (this.mediumFilter.max - 0.9) * 0.06;
		this.post.distort.intensityY = this.mediumFilter.max < 0.8 ? 0 : (this.mediumFilter.max - 0.9) * 0.06;
		this.post.bloom.bloomWeight = this.lowFilter.max * 20;
		this.post.imageProcessing.vignetteWeight = this.lowFilter.max;
		this.post.imageProcessing.exposure = this.exposureMP * Math.min(1.100,0.7 + Math.max(0,this.lowFilter.min - 0.8) * 2.5);
		this.post.displacement.zoom = 0.5 + this.lowFilter.max * 0.25;
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: chainedball_ChainedBall
});
var credits_Credits = function() {
	this.exposureMP = 0;
	this.greetNames = ["exca.png","poro.png","featuring.png","t101.png"];
	this.chains = [];
	wl_core_Part.call(this);
};
$hxClasses["credits.Credits"] = credits_Credits;
credits_Credits.__name__ = ["credits","Credits"];
credits_Credits.__super__ = wl_core_Part;
credits_Credits.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.lowFilter = { isolate : true, lowLimit : 0, highLimit : 200};
		this.mediumFilter = { isolate : true, lowLimit : 400, highLimit : 1000};
		this.highFilter = { isolate : true, lowLimit : 1000, highLimit : 16000};
		this.analyzer = new wl_sounds_SoundAnalyzer();
		this.analyzer.historySize = 10;
		this.analyzer.filters.push(this.lowFilter);
		this.analyzer.filters.push(this.mediumFilter);
		this.analyzer.filters.push(this.highFilter);
		this.initStandardScene();
		var rpProp = { };
		rpProp.bloom = true;
		rpProp.chromaticAberration = true;
		rpProp.distort = true;
		rpProp.dof = true;
		rpProp.grain = true;
		rpProp.imageProcessing = true;
		rpProp.sharpen = false;
		rpProp.fxaa = false;
		rpProp.displacement = false;
		this.initPipeline(rpProp);
		this.post.grain.animated = true;
		this.post.dof.focalLength = 80;
		this.post.dof.focusDistance = 8000;
		this.post.imageProcessing.vignetteEnabled = true;
		var glowCube = BABYLON.MeshBuilder.CreateSphere("box",{ diameter : 545, sideOrientation : BABYLON.Mesh.DOUBLESIDE},null);
		var glowMat = new BABYLON.StandardMaterial("",null);
		glowMat.diffuseColor = DemoMain.BLACK.clone();
		glowMat.ambientColor = DemoMain.BLACK.clone();
		glowMat.specularColor = DemoMain.BLACK.clone();
		glowMat.emissiveColor = DemoMain.BLACK.clone().scale(0.05);
		glowCube.material = glowMat;
		this.scene.addMesh(glowCube);
		this.camera.fov = 0.1;
		this.camera.maxZ = 200;
		this.pl = new BABYLON.HemisphericLight("pl",new BABYLON.Vector3(0,5,8),this.scene);
		this.pl.diffuse = DemoMain.WHITE.clone();
		this.pl.intensity = 0.9;
		this.pl.range = 50;
		this.camera.position = new BABYLON.Vector3(1,0,16);
		this.camera.setTarget(new BABYLON.Vector3());
		var cps = [new BABYLON.Vector3(-8.9,5.1,0),new BABYLON.Vector3(-1.1,5.1,0),new BABYLON.Vector3(2.,5.3,-1),new BABYLON.Vector3(8.,5.3,-1),new BABYLON.Vector3(-7.6,0.7,-2),new BABYLON.Vector3(7.6,0.7,-2),new BABYLON.Vector3(-2.5,-2.45,-3),new BABYLON.Vector3(2.5,-2.45,-3)];
		var cpe = [new BABYLON.Vector3(-9.,11,0),new BABYLON.Vector3(-1.,11,0),new BABYLON.Vector3(1.,11,-1),new BABYLON.Vector3(9.,11,-1),new BABYLON.Vector3(-12.5,11.0,-2),new BABYLON.Vector3(16.5,11,-2),new BABYLON.Vector3(-2.7,11,-3),new BABYLON.Vector3(2.7,11,-3)];
		this.greets = [];
		var c = 0;
		var _g = 0;
		var _g1 = this.greetNames;
		while(_g < _g1.length) {
			var g = _g1[_g];
			++_g;
			var gsps = new greets_GreetSPS(g,this.scene);
			gsps.scaling.set(0.2,0.125,0.2);
			this.greets.push(gsps);
			gsps.position.z = -c;
			gsps.position.x = [-5,5,0,0][c];
			gsps.position.y = [4,4,-0.5,-3.8][c];
			gsps.lookAt(gsps.position.clone().subtract(new BABYLON.Vector3(0,0,-10)));
			var cps1 = cps[c * 2];
			var cc = cpe[c * 2].subtract(cps[c * 2]).scale(0.5);
			var cc1 = new whiteroom_ChainWR(cps1,cps[c * 2].add(cc),cpe[c * 2],new BABYLON.Vector3(1,1,1),this.scene);
			var cps2 = cps[c * 2 + 1];
			var cc2 = cpe[c * 2 + 1].subtract(cps[c * 2 + 1]).scale(0.5);
			var cc21 = new whiteroom_ChainWR(cps2,cps[c * 2 + 1].add(cc2),cpe[c * 2 + 1],new BABYLON.Vector3(1,1,1),this.scene);
			++c;
			this.chains.push(cc1);
			this.chains.push(cc21);
			cc1.normalize();
			cc21.normalize();
		}
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		var tmp = createjs.Tween.get(this);
		var tmp1 = wl_core_TimeSig.milliseconds(1,0,0,0);
		var tmp2 = tmp.to({ exposureMP : 1},tmp1).wait(wl_core_TimeSig.milliseconds(2,0,0,0));
		var tmp3 = wl_core_TimeSig.milliseconds(1,0,0,0);
		tmp2.to({ exposureMP : 0},tmp3);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		var t = ts.toMilliseconds() / 1000;
		var t1 = ts.toMilliseconds() / 3000;
		this.camera.position = new BABYLON.Vector3(-1 + Math.sin(t1) * 2,Math.cos(t1 * 0.3) * 0.5,128 + Math.sin(t1 * 0.2));
		this.camera.setTarget(new BABYLON.Vector3(this.camera.position.x * 0.5,this.camera.position.y,0));
		this.analyzer.update();
		this.post.grain.intensity = this.lowFilter.max * 10 + 5;
		this.post.chromaticAberration.aberrationAmount = this.mediumFilter.max < 0.8 ? 0 : (this.mediumFilter.max - 0.8) * 120;
		var tmp = this.mediumFilter.max < 0.9 ? 0 : createjs.Ease.quadIn(2 * (this.mediumFilter.max - 0.9)) * 0.035;
		this.post.distort.intensity = tmp;
		this.post.bloom.bloomWeight = this.lowFilter.max * 5;
		this.post.imageProcessing.vignetteWeight = this.lowFilter.max;
		this.post.imageProcessing.exposure = this.exposureMP * Math.min(1.100,0.7 + Math.max(0,this.lowFilter.min - 0.8) * 2.5);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: credits_Credits
});
var BABYLON_IGetSetVerticesData = function() { };
$hxClasses["BABYLON.IGetSetVerticesData"] = BABYLON_IGetSetVerticesData;
BABYLON_IGetSetVerticesData.__name__ = ["BABYLON","IGetSetVerticesData"];
BABYLON_IGetSetVerticesData.prototype = {
	__class__: BABYLON_IGetSetVerticesData
};
var BABYLON_ICullable = function() { };
$hxClasses["BABYLON.ICullable"] = BABYLON_ICullable;
BABYLON_ICullable.__name__ = ["BABYLON","ICullable"];
BABYLON_ICullable.prototype = {
	__class__: BABYLON_ICullable
};
var cubecity_CubeBuilding = function(width,depth,scene,baseMesh) {
	BABYLON.Mesh.call(this,"",scene);
	this.width = width;
	this.depth = depth;
	var grid = this.GenerateBuildingHeight();
	var _g1 = 0;
	var _g = grid.length;
	while(_g1 < _g) {
		var w = _g1++;
		var _g3 = 0;
		var _g2 = grid[w].length;
		while(_g3 < _g2) {
			var d = _g3++;
			var _g5 = 0;
			var _g4 = grid[w][d];
			while(_g5 < _g4) {
				var h = _g5++;
				var bo = baseMesh.createInstance("");
				bo.parent = this;
				bo.position.x = w * 5;
				bo.position.z = d * 5;
				bo.position.y = h * 5;
			}
		}
	}
};
$hxClasses["cubecity.CubeBuilding"] = cubecity_CubeBuilding;
cubecity_CubeBuilding.__name__ = ["cubecity","CubeBuilding"];
cubecity_CubeBuilding.__super__ = BABYLON.Mesh;
cubecity_CubeBuilding.prototype = $extend(BABYLON.Mesh.prototype,{
	GenerateBuildingHeight: function() {
		var array = [];
		var _g1 = 0;
		var _g = this.width;
		while(_g1 < _g) {
			var w = _g1++;
			var innerArray = [];
			var _g3 = 0;
			var _g2 = this.depth;
			while(_g3 < _g2) {
				var d = _g3++;
				innerArray.push(Math.random() * 12 + 1);
			}
			array.push(innerArray);
		}
		return array;
	}
	,__class__: cubecity_CubeBuilding
});
var cubecity_CubeCity = function() {
	this.cubes = [];
	wl_core_Part.call(this);
};
$hxClasses["cubecity.CubeCity"] = cubecity_CubeCity;
cubecity_CubeCity.__name__ = ["cubecity","CubeCity"];
cubecity_CubeCity.__super__ = wl_core_Part;
cubecity_CubeCity.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var room = BABYLON.MeshBuilder.CreateBox("",{ width : 500, height : 500, depth : 500, sideOrientation : BABYLON.Mesh.BACKSIDE},this.scene);
		room.receiveShadows = true;
		this.light = new BABYLON.PointLight("",BABYLON.Vector3.Zero(),this.scene);
		this.light.intensity = 0.5;
		this.light.shadowEnabled = true;
		this.light.position.y = 5;
		this.light.shadowMinZ = 0.1;
		this.light.shadowMaxZ = 50;
		this.shadowGenerator = new BABYLON.ShadowGenerator(1024,this.light);
		var baseMesh = wl_util_ExtendedMeshBuilder.CreateHollowCube("",{ width : 5, height : 5, depth : 5, edge : 0.1},null);
		this.shadowGenerator.getShadowMap().renderList.push(baseMesh);
		var _g = 0;
		while(_g < 5) {
			var i = _g++;
			var cubebuilding = new cubecity_CubeBuilding(5,5,this.scene,baseMesh);
			var tmp = Math.random() * 100;
			cubebuilding.position.x = 50 - tmp;
			var tmp1 = Math.random() * 100;
			cubebuilding.position.z = 50 - tmp1;
			this.shadowGenerator.addShadowCaster(cubebuilding,true);
		}
		this.camera.setTarget(this.light.position);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,setupDatGui: function(folder) {
		wl_core_Part.prototype.setupDatGui.call(this,folder);
		var shadowfolder = folder.addFolder("shadows");
		shadowfolder.add(this.shadowGenerator,"useVarianceShadowMap");
		shadowfolder.add(this.shadowGenerator,"usePoissonSampling");
		shadowfolder.add(this.shadowGenerator,"usePercentageCloserFiltering");
		shadowfolder.add(this.shadowGenerator,"useKernelBlur");
		shadowfolder.add(this.shadowGenerator,"useExponentialShadowMap");
		shadowfolder.add(this.shadowGenerator,"useContactHardeningShadow");
		shadowfolder.add(this.shadowGenerator,"useCloseExponentialShadowMap");
		shadowfolder.add(this.shadowGenerator,"useBlurVarianceShadowMap");
		shadowfolder.add(this.shadowGenerator,"useBlurExponentialShadowMap");
		shadowfolder.add(this.shadowGenerator,"useBlurCloseExponentialShadowMap");
		shadowfolder.add(this.shadowGenerator,"bias");
		var lightfolder = folder.addFolder("light");
		wl_util_DatGuiHelper.addColor(lightfolder,this.light,"diffuse");
		lightfolder.add(this.light,"intensity");
	}
	,__class__: cubecity_CubeCity
});
var cubecity_HollowCube = function(m,scene) {
	BABYLON.TransformNode.call(this,"",scene);
	m.parent = this;
};
$hxClasses["cubecity.HollowCube"] = cubecity_HollowCube;
cubecity_HollowCube.__name__ = ["cubecity","HollowCube"];
cubecity_HollowCube.__super__ = BABYLON.TransformNode;
cubecity_HollowCube.prototype = $extend(BABYLON.TransformNode.prototype,{
	__class__: cubecity_HollowCube
});
var fallingwall_Chain = function(p1,pc,p2,scale,scene) {
	this.links = [];
	this.start = p1;
	this.control = pc;
	this.target = p2;
	var anchor1 = BABYLON.MeshBuilder.CreateSphere("anchor",{ diameter : 0.5},scene);
	anchor1.position.copyFrom(p1);
	anchor1.visibility = 0.0;
	anchor1.dispose();
	var linkMesh = this.buildLink(scene);
	linkMesh.scaling.copyFrom(scale);
	linkMesh.bakeCurrentTransformIntoVertices();
	var bb = linkMesh.getBoundingInfo().boundingBox;
	var count = Math.ceil(BABYLON.Vector3.Distance(p1,p2) / (bb.maximum.y - bb.minimum.y) * 1.4);
	var mass = 1 / count;
	var directionCurve = BABYLON.Curve3.CreateQuadraticBezier(p1,pc,p2,count);
	var count1 = Math.ceil(directionCurve.length() / (bb.maximum.y - bb.minimum.y) * 1.4);
	var directionCurve1 = BABYLON.Curve3.CreateQuadraticBezier(p1,pc,p2,count1);
	var _g1 = 0;
	var _g = count1;
	while(_g1 < _g) {
		var i = _g1++;
		var il = linkMesh.createInstance("");
		var node = new BABYLON.TransformNode("",scene);
		il.parent = node;
		il.position.copyFrom(BABYLON.Vector3.Zero());
		var points = directionCurve1.getPoints();
		var vec = points[i];
		node.position.copyFrom(vec);
		var vNext = i < points.length - 1 ? points[i + 1] : p2;
		node.lookAt(vNext);
		if(i % 2 == 1) {
			il.rotate(BABYLON.Vector3.Up(),Math.PI * 0.5);
			il.rotate(BABYLON.Vector3.Forward(),Math.PI / 2);
		} else {
			il.rotate(BABYLON.Vector3.Right(),Math.PI / 2);
		}
		this.links.push(node);
	}
};
$hxClasses["fallingwall.Chain"] = fallingwall_Chain;
fallingwall_Chain.__name__ = ["fallingwall","Chain"];
fallingwall_Chain.prototype = {
	updateChain: function() {
		var directionCurve = BABYLON.Curve3.CreateQuadraticBezier(this.start,this.control,this.target,this.links.length);
		var i = 0;
		var _g = 0;
		var _g1 = this.links;
		while(_g < _g1.length) {
			var node = _g1[_g];
			++_g;
			var points = directionCurve.getPoints();
			var vec = points[i];
			node.position.copyFrom(vec);
			var vNext = i < points.length - 1 ? points[i + 1] : this.target;
			node.lookAt(vNext);
			++i;
		}
	}
	,buildLink: function(scene) {
		var points = [new BABYLON.Vector3(0.1,0.07,0)];
		var curve = BABYLON.Curve3.CreateCubicBezier(new BABYLON.Vector3(0.1,0.18,0),new BABYLON.Vector3(0.1,0.28,0),new BABYLON.Vector3(-0.1,0.28,0),new BABYLON.Vector3(-0.1,0.18,0),6);
		points = points.concat(curve.getPoints());
		curve = BABYLON.Curve3.CreateCubicBezier(new BABYLON.Vector3(-0.1,-0.18,0),new BABYLON.Vector3(-0.1,-0.28,0),new BABYLON.Vector3(0.1,-0.28,0),new BABYLON.Vector3(0.1,-0.18,0),6);
		points = points.concat(curve.getPoints());
		points.push(points[0].subtract(new BABYLON.Vector3(0,0.015,0)));
		var linkMesh = BABYLON.MeshBuilder.CreateTube("Chain-Link",{ radius : 0.05, path : points, cap : 3, tessellation : 6},scene);
		fallingwall_Chain.linkmaterial = new BABYLON.StandardMaterial("",scene);
		return linkMesh;
	}
	,__class__: fallingwall_Chain
};
var fallingwall_FallingWall = function() {
	this.startedBar = 0;
	this.exposureMP = 0;
	this.glowPieces = [];
	this.chains = [];
	this.maxboxes = 300;
	this.gen_height = 100;
	this.gen_side = 10;
	this.room_height = 100;
	this.room_side = 15;
	this.boxes = [];
	wl_core_Part.call(this);
};
$hxClasses["fallingwall.FallingWall"] = fallingwall_FallingWall;
fallingwall_FallingWall.__name__ = ["fallingwall","FallingWall"];
fallingwall_FallingWall.__super__ = wl_core_Part;
fallingwall_FallingWall.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var physicsPlugin = new BABYLON.CannonJSPlugin();
		var gravityVector = new BABYLON.Vector3(0,-9.81,0);
		this.scene.enablePhysics(gravityVector,physicsPlugin);
		this.lowFilter = { isolate : true, lowLimit : 0, highLimit : 200};
		this.mediumFilter = { isolate : true, lowLimit : 700, highLimit : 1200};
		this.highFilter = { isolate : true, lowLimit : 1000, highLimit : 16000};
		this.analyzer = new wl_sounds_SoundAnalyzer();
		this.analyzer.historySize = 10;
		this.analyzer.filters.push(this.lowFilter);
		this.analyzer.filters.push(this.mediumFilter);
		this.analyzer.filters.push(this.highFilter);
		var rpProp = { };
		rpProp.bloom = true;
		rpProp.chromaticAberration = true;
		rpProp.distort = true;
		rpProp.dof = false;
		rpProp.grain = true;
		rpProp.imageProcessing = true;
		rpProp.sharpen = false;
		rpProp.fxaa = false;
		rpProp.displacement = true;
		this.initPipeline(rpProp);
		this.post.grain.animated = true;
		this.post.displacement.scaleX = 0.04;
		this.post.displacement.scaleY = 0.02;
		this.post.displacement.zoom = 0.5;
		this.post.distort.lineHeight = wl_core_Config.RESOLUTION[1] / 60;
		this.post.imageProcessing.vignetteEnabled = true;
		this.boxMesh = BABYLON.MeshBuilder.CreateBox("",{ width : 2, height : 2, depth : 2},this.scene);
		this.boxMesh.receiveShadows = true;
		var boxmat = new BABYLON.StandardMaterial("",this.scene);
		this.boxMesh.material = boxmat;
		this.ground = BABYLON.MeshBuilder.CreateGround("ground1",{ width : this.room_side * 2, height : this.room_side * 2},this.scene);
		this.ground.material = boxmat;
		this.ground.physicsImpostor = new BABYLON.PhysicsImpostor(this.ground,BABYLON.PhysicsImpostor.BoxImpostor,{ mass : 0, restitution : 0.9},this.scene);
		this.ground.receiveShadows = true;
		this.buildRoom();
		this.glowmat = new BABYLON.StandardMaterial("",this.scene);
		this.glowmat.diffuseColor = new BABYLON.Color3(0.5,0.5,0.5);
		this.glowmat.emissiveColor = new BABYLON.Color3(0.6,0.6,0.6);
		var singlepieceheight = this.room_height / 40;
		var glowPiece = BABYLON.MeshBuilder.CreateBox("",{ width : this.room_side, height : singlepieceheight, depth : 0.2});
		glowPiece.material = this.glowmat;
		var startplaces = [new BABYLON.Vector3(this.room_side / 2,0,-1),new BABYLON.Vector3(this.room_side / 2,0,this.room_side + 1),new BABYLON.Vector3(this.room_side + 1,0,this.room_side / 2),new BABYLON.Vector3(-1,0,this.room_side / 2)];
		var rotations = [0,0,Math.PI / 2,Math.PI / 2];
		var spacer = 2.5;
		var _g = 0;
		while(_g < 4) {
			var p = _g++;
			var _g2 = 0;
			var _g1 = Math.ceil(this.room_height / (singlepieceheight * spacer) + 1);
			while(_g2 < _g1) {
				var i = _g2++;
				var gb = glowPiece.createInstance("");
				gb.position.x = startplaces[p].x;
				gb.position.z = startplaces[p].z;
				gb.position.y = this.room_height + i * (singlepieceheight * spacer);
				gb.rotate(BABYLON.Vector3.Up(),rotations[p]);
				this.glowPieces.push(gb);
			}
		}
		glowPiece.setEnabled(false);
		var gl = new BABYLON.GlowLayer("glow",this.scene);
		var shippos = new BABYLON.Vector3(this.room_side / 2,3,this.room_side / 2);
		this.ship = new fallingwall_RisingShip(this.scene,shippos);
		var utscale = new BABYLON.Vector3(1,1,1);
		this.chains.push(new fallingwall_Chain(new BABYLON.Vector3(0,5,0),new BABYLON.Vector3(this.room_side / 4,3,this.room_side / 4),this.ship.position,utscale,this.scene));
		this.chains.push(new fallingwall_Chain(new BABYLON.Vector3(0,5,this.room_side),new BABYLON.Vector3(this.room_side / 4,3,this.room_side * 3 / 4),this.ship.position,utscale,this.scene));
		this.chains.push(new fallingwall_Chain(new BABYLON.Vector3(this.room_side,5,0),new BABYLON.Vector3(this.room_side * 3 / 4,3,this.room_side / 4),this.ship.position,utscale,this.scene));
		this.chains.push(new fallingwall_Chain(new BABYLON.Vector3(this.room_side,5,this.room_side),new BABYLON.Vector3(this.room_side * 3 / 4,3,this.room_side * 3 / 4),this.ship.position,utscale,this.scene));
		this.chains.push(new fallingwall_Chain(new BABYLON.Vector3(this.room_side / 2,2,0),new BABYLON.Vector3(this.room_side / 2,.1,this.room_side / 4),this.ship.position,utscale,this.scene));
		this.chains.push(new fallingwall_Chain(new BABYLON.Vector3(this.room_side / 2,2,this.room_side),new BABYLON.Vector3(this.room_side / 2,.1,this.room_side * 3 / 4),this.ship.position,utscale,this.scene));
		this.chains.push(new fallingwall_Chain(new BABYLON.Vector3(0,2,this.room_side / 2),new BABYLON.Vector3(this.room_side / 4,.1,this.room_side / 2),this.ship.position,utscale,this.scene));
		this.chains.push(new fallingwall_Chain(new BABYLON.Vector3(this.room_side,2,this.room_side / 2),new BABYLON.Vector3(this.room_side * 3 / 4,.1,this.room_side / 2),this.ship.position,utscale,this.scene));
		this.camera.position.x = 10;
		this.camera.position.y = 6;
		this.camera.position.z = -0.5;
		var cameratarget = this.ship.position.clone();
		this.camera.setTarget(cameratarget);
		this.shadowgenerator = new BABYLON.ShadowGenerator(512,this.ship.light);
		var _g3 = 0;
		var _g11 = this.ship.shadowcasters;
		while(_g3 < _g11.length) {
			var sc = _g11[_g3];
			++_g3;
			this.shadowgenerator.addShadowCaster(sc);
		}
		this.addTrigger(new wl_core_TimeSig(0,0,0,0,wl_core_TimeSig.RELATIVE),function(ts) {
			var tmp = createjs.Tween.get(_gthis.ship.position,{ loop : true});
			var tmp1 = wl_core_TimeSig.milliseconds(3,0,0,0);
			var tmp2 = tmp.to({ y : 6},tmp1,createjs.Ease.sineInOut);
			var tmp3 = wl_core_TimeSig.milliseconds(3,0,0,0);
			tmp2.to({ y : 3},tmp3,createjs.Ease.sineInOut);
			var tmp4 = createjs.Tween.get(_gthis.ship.light);
			var tmp5 = wl_core_TimeSig.milliseconds(2,0,0,0);
			tmp4.to({ intensity : 1.0, range : 15},tmp5);
		});
		this.addTrigger(new wl_core_TimeSig(1,0,0,0,wl_core_TimeSig.RELATIVE),function(ts1) {
			createjs.Tween.get(_gthis.ship.innermat.emissiveColor).to({ r : _gthis.ship.light.diffuse.r, g : _gthis.ship.light.diffuse.g, b : _gthis.ship.light.diffuse.b},wl_core_TimeSig.milliseconds(4,0,0,0));
		});
		this.rndcc = new wl_demo_RandomCameraController(this.camera,8,[],97678,[wl_demo_CameraController.LINEAR],[0,5],new BABYLON.BoundingBox(new BABYLON.Vector3(6.5,3.5,8.01),new BABYLON.Vector3(12.3,10.3,14.3)));
		this.rndcc2 = new wl_demo_RandomCameraController(this.camera,8,[],4627,[wl_demo_CameraController.BEZIER],[7,30],new BABYLON.BoundingBox(new BABYLON.Vector3(6,6,10.0),new BABYLON.Vector3(7,7,10)));
		this.rndcc3 = new wl_demo_RandomCameraController(this.camera,8,[],246,[wl_demo_CameraController.BEZIER],[7,30],new BABYLON.BoundingBox(new BABYLON.Vector3(7,7,11.0),new BABYLON.Vector3(8,8,14)));
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),function(ts2) {
			_gthis.rndcc.swap();
			_gthis.rndcc2.swap();
			_gthis.rndcc3.swap();
		});
		this.addTrigger(new wl_core_TimeSig(1,0,0,0,wl_core_TimeSig.PATTERN),function(ts3) {
			_gthis.ship.enableNewBall();
		});
		this.addTrigger(new wl_core_TimeSig(8,0,0,0,wl_core_TimeSig.RELATIVE),function(ts4) {
			var newpos = _gthis.ship.position.clone();
			var _g4 = 0;
			var _g12 = _gthis.chains;
			while(_g4 < _g12.length) {
				var c = _g12[_g4];
				++_g4;
				c.target = newpos;
				var tmp6 = c.control.y - 2;
				createjs.Tween.get(c.control).to({ y : tmp6},null,createjs.Ease.bounceOut);
			}
			var tmp7 = createjs.Tween.get(newpos);
			var tmp8 = wl_core_TimeSig.milliseconds(1,0,0,0);
			tmp7.to({ y : 0},tmp8,createjs.Ease.bounceOut);
			var _g5 = 0;
			while(_g5 < 10) {
				var i1 = _g5++;
				_gthis.ship.enableNewBall();
			}
		});
		this.addTrigger(new wl_core_TimeSig(10,0,0,0,wl_core_TimeSig.RELATIVE),function(ts5) {
			createjs.Tween.removeTweens(_gthis.ship.position);
			_gthis.ship.rising = true;
		});
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		this.startedBar = ts.bar;
		var tmp = createjs.Tween.get(this);
		var tmp1 = wl_core_TimeSig.milliseconds(1,0,0,0);
		tmp.to({ exposureMP : 1},tmp1);
	}
	,buildRoom: function() {
		this.wallmat = new BABYLON.StandardMaterial("",this.scene);
		this.wallmat.specularPower = 0;
		this.wallmat.diffuseColor = DemoMain.BASE_1.clone().scale(0.15);
		var room = new BABYLON.TransformNode("",this.scene);
		var wall = this.generateWall(this.gen_side,this.gen_height,this.room_side,this.room_height);
		wall.receiveShadows = true;
		wall.material = this.wallmat;
		wall.physicsImpostor = new BABYLON.PhysicsImpostor(wall,BABYLON.PhysicsImpostor.BoxImpostor,{ mass : 0, restitution : 0.9},this.scene);
		var wall2 = wall.clone("",room);
		wall2.physicsImpostor = new BABYLON.PhysicsImpostor(wall2,BABYLON.PhysicsImpostor.BoxImpostor,{ mass : 0, restitution : 0.9},this.scene);
		wall2.position.z = this.room_side;
		var wall3 = wall.clone("",room);
		wall3.physicsImpostor = new BABYLON.PhysicsImpostor(wall3,BABYLON.PhysicsImpostor.BoxImpostor,{ mass : 0, restitution : 0.9},this.scene);
		wall3.rotate(BABYLON.Vector3.Up(),Math.PI / 2);
		wall3.position.z = this.room_side;
		wall3.parent = room;
		var wall4 = wall.clone("",room);
		wall4.physicsImpostor = new BABYLON.PhysicsImpostor(wall4,BABYLON.PhysicsImpostor.BoxImpostor,{ mass : 0, restitution : 0.9},this.scene);
		wall4.rotate(BABYLON.Vector3.Up(),Math.PI / 2);
		wall4.position.x = this.room_side;
		wall4.position.z = this.room_side;
		wall4.parent = room;
		return room;
	}
	,generateWall: function(gen_side,gen_height,room_side,room_height) {
		var wallmeshes = [];
		var _g1 = 0;
		var _g = gen_side;
		while(_g1 < _g) {
			var x = _g1++;
			var _g3 = 0;
			var _g2 = gen_height;
			while(_g3 < _g2) {
				var y = _g3++;
				if(wl_util_Random.nextFloat() < 0.05 && y > 10 && x > 1 && x < gen_side - 1) {
					continue;
				}
				var box = BABYLON.MeshBuilder.CreateBox("",{ width : 1, height : 1, depth : 0.1},this.scene);
				wallmeshes.push(box);
				box.position.x = x;
				box.position.y = y + 0.5;
				if(wl_util_Random.nextFloat() < 0.5) {
					var tmp = wl_util_Random.nextFloat();
					box.position.z = tmp / 4;
				}
			}
		}
		var wall = new BABYLON.TransformNode("",this.scene);
		var m = BABYLON.Mesh.MergeMeshes(wallmeshes,true,true);
		var _g4 = 0;
		while(_g4 < wallmeshes.length) {
			var b = wallmeshes[_g4];
			++_g4;
			b.dispose();
		}
		wallmeshes = [];
		var _g11 = 0;
		var _g5 = Math.ceil(room_side / gen_side);
		while(_g11 < _g5) {
			var x1 = _g11++;
			var yoffset = wl_util_Random.nextFloat() * room_height * 0.1;
			var _g31 = 0;
			var _g21 = Math.ceil(room_height / gen_height);
			while(_g31 < _g21) {
				var y1 = _g31++;
				var m2 = m.clone("",wall);
				m2.position.x = x1 * gen_side;
				m2.position.y = y1 * gen_height - yoffset;
				wallmeshes.push(m2);
			}
		}
		m.dispose();
		m = BABYLON.Mesh.MergeMeshes(wallmeshes,true,true);
		var _g6 = 0;
		while(_g6 < wallmeshes.length) {
			var b1 = wallmeshes[_g6];
			++_g6;
			b1.dispose();
		}
		return m;
	}
	,dropBox: function() {
		var box = this.boxMesh.createInstance("");
		var tmp = wl_util_Random.nextFloat();
		box.position.z = tmp * this.room_side;
		var tmp1 = wl_util_Random.nextFloat();
		box.position.x = tmp1 * this.room_side;
		var tmp2 = this.room_height * 0.8;
		var tmp3 = wl_util_Random.nextFloat() * this.room_height * 0.2;
		box.position.y = tmp2 + tmp3;
		box.physicsImpostor = new BABYLON.PhysicsImpostor(box,BABYLON.PhysicsImpostor.BoxImpostor,{ mass : 2.1, restitution : 0.4},this.scene);
		box.physicsImpostor.applyForce(new BABYLON.Vector3(0.1 * wl_util_Random.nextFloat(),0.1 * wl_util_Random.nextFloat(),0.1 * wl_util_Random.nextFloat()),BABYLON.Vector3.Zero());
		box.physicsImpostor.registerOnPhysicsCollide(this.ground.physicsImpostor,function(main,collided) {
		});
		this.boxes.push(box);
		this.shadowgenerator.addShadowCaster(box);
	}
	,update: function(ts,partial,frameTime,delta) {
		this.ship.update(ts,delta);
		var _g = 0;
		var _g1 = this.chains;
		while(_g < _g1.length) {
			var c = _g1[_g];
			++_g;
			c.updateChain();
		}
		var _g2 = 0;
		var _g11 = this.glowPieces;
		while(_g2 < _g11.length) {
			var g = _g11[_g2];
			++_g2;
			g.position.y -= 0.3;
			if(g.position.y < 0) {
				g.position.y = this.room_height + this.room_height / 20;
			}
		}
		this.analyzer.update();
		this.post.grain.intensity = this.lowFilter.max * 30 + 5;
		this.post.chromaticAberration.aberrationAmount = this.mediumFilter.max < 0.8 ? 0 : (this.mediumFilter.max - 0.8) * 120;
		this.post.distort.intensity = this.mediumFilter.max < 0.8 ? 0 : (this.mediumFilter.max - 0.9) * 0.06;
		this.post.distort.intensityY = this.mediumFilter.max < 0.8 ? 0 : (this.mediumFilter.max - 0.9) * 0.06;
		this.post.bloom.bloomWeight = this.lowFilter.max * 5;
		this.post.imageProcessing.vignetteWeight = this.lowFilter.max;
		this.post.imageProcessing.exposure = this.exposureMP * Math.min(1.100,0.7 + Math.max(0,this.lowFilter.min - 0.8) * 2.5);
		this.post.displacement.zoom = 0.5 + this.lowFilter.max * 0.25;
		if(ts.bar - this.startedBar < 8) {
			if(ts.bar % 2 == 0) {
				this.rndcc.updateLength(wl_core_TimeSig.milliseconds(2,0,0,0));
			} else {
				this.rndcc2.updateLength(wl_core_TimeSig.milliseconds(2,0,0,0));
			}
		} else {
			this.rndcc3.updateLength(wl_core_TimeSig.milliseconds(2,0,0,0));
		}
		this.camera.setTarget(this.ship.position);
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,setupDatGui: function(folder) {
		wl_core_Part.prototype.setupDatGui.call(this,folder);
	}
	,__class__: fallingwall_FallingWall
});
var fallingwall_RisingShip = function(scene,pos) {
	this.shadowcasters = [];
	this.zeroOneVector = new BABYLON.Vector3(0.3,0.3,0.3);
	this.balls = [];
	BABYLON.TransformNode.call(this,"",scene);
	this.light = new BABYLON.PointLight("",BABYLON.Vector3.Zero(),scene);
	this.light.parent = this;
	this.light.intensity = 0.1;
	this.light.range = 3;
	this.light.shadowMinZ = 0.05;
	this.light.shadowMaxZ = 20;
	this.light.diffuse = DemoMain.BASE_1.clone();
	this.light.shadowEnabled = true;
	this.position.copyFrom(pos);
	var ballmat = new BABYLON.StandardMaterial("",scene);
	ballmat.diffuseColor = new BABYLON.Color3(0.6,0.6,0.6);
	var _g = 0;
	while(_g < 32) {
		var i = _g++;
		var b = BABYLON.MeshBuilder.CreateSphere("",{ diameter : .8},scene);
		b.position.copyFrom(this.position);
		var tmp = b.position.x * wl_util_Random.nextFloat();
		var tmp1 = b.position.x / 2 * wl_util_Random.nextFloat();
		b.position.x = tmp + tmp1;
		var tmp2 = b.position.z * wl_util_Random.nextFloat();
		var tmp3 = b.position.z / 2 * wl_util_Random.nextFloat();
		b.position.z = tmp2 + tmp3;
		b.physicsImpostor = new BABYLON.PhysicsImpostor(b,BABYLON.PhysicsImpostor.SphereImpostor,{ mass : 2, restitution : 0.1},scene);
		this.balls.push(b);
		b.isVisible = false;
		this.shadowcasters.push(b);
	}
	this.centerball = BABYLON.MeshBuilder.CreateSphere("",{ diameter : 2},scene);
	this.centerball.position.copyFrom(this.position);
	this.centerball.physicsImpostor = new BABYLON.PhysicsImpostor(this.centerball,BABYLON.PhysicsImpostor.SphereImpostor,{ mass : 0, restitution : 0.0},scene);
	this.shadowcasters.push(this.centerball);
	BABYLON.Effect.ShadersStore["shipPixelShader"] = haxe_Resource.getString("shipshader.frag");
	this.customProc = new BABYLON.CustomProceduralTexture("ship","ship",1024,scene);
	this.customProc.setFloat("t",0);
	this.customProc.refreshRate = 1;
	this.customProc.hasAlpha = true;
	var centermat = new BABYLON.StandardMaterial("",scene);
	centermat.diffuseTexture = this.customProc;
	centermat.backFaceCulling = false;
	centermat.diffuseColor = new BABYLON.Color3(0.5,0.5,0.5);
	centermat.emissiveColor = new BABYLON.Color3(0.0,0,0);
	this.centerball.material = centermat;
	this.innermat = new BABYLON.StandardMaterial("",scene);
	this.innermat.diffuseColor = centermat.diffuseColor;
	var innerball = BABYLON.MeshBuilder.CreateSphere("",{ diameter : 1.9},scene);
	innerball.material = this.innermat;
	innerball.parent = this;
};
$hxClasses["fallingwall.RisingShip"] = fallingwall_RisingShip;
fallingwall_RisingShip.__name__ = ["fallingwall","RisingShip"];
fallingwall_RisingShip.__super__ = BABYLON.TransformNode;
fallingwall_RisingShip.prototype = $extend(BABYLON.TransformNode.prototype,{
	enableNewBall: function() {
		var hiddenballs = this.balls.filter(function(f) {
			return !f.isVisible;
		});
		if(hiddenballs.length > 0) {
			hiddenballs[0].isVisible = true;
		}
	}
	,update: function(ts,d) {
		if(this.rising) {
			this.position.y += 0.05 * d;
		}
		this.centerball.position.copyFrom(this.position);
		console.log(this.customProc);
		this.customProc.setFloat("t",ts.toMilliseconds() / 1000);
		var _g = 0;
		var _g1 = this.balls;
		while(_g < _g1.length) {
			var b = _g1[_g];
			++_g;
			var target = b.position.add(BABYLON.Vector3.Down());
			var distance = this.position.subtract(target);
			var impulseStr = distance.normalize().scale(2);
			b.physicsImpostor.applyImpulse(impulseStr,BABYLON.Vector3.Zero());
		}
	}
	,__class__: fallingwall_RisingShip
});
var floatingBalls_FloatingBall = function() {
	BABYLON.TransformNode.call(this,"");
	if(floatingBalls_FloatingBall.innerMesh == null) {
		floatingBalls_FloatingBall.innerMesh = BABYLON.MeshBuilder.CreateSphere("sphere1",{ segments : 16, diameter : 1.8, sideOrientation : BABYLON.Mesh.DOUBLESIDE},null);
		var innermat = new BABYLON.StandardMaterial("",null);
		innermat.diffuseColor = new BABYLON.Color3(0.5,0.0,0.5);
		innermat.emissiveColor = new BABYLON.Color3(0.5,0,0.5);
		floatingBalls_FloatingBall.innerMesh.material = innermat;
		floatingBalls_FloatingBall.innerMesh.isVisible = false;
	}
	if(floatingBalls_FloatingBall.quarterMeshes == null) {
		floatingBalls_FloatingBall.quarterMeshes = [];
		var _g = 0;
		while(_g < 4) {
			var i = _g++;
			var m = BABYLON.MeshBuilder.CreateSphere("sphere1",{ segments : 16, diameter : 2, slice : 0.5, arc : 0.5, sideOrientation : BABYLON.Mesh.DOUBLESIDE},null);
			var rot = Math.PI / 2 * i;
			m.rotate(BABYLON.Vector3.Left(),rot);
			m.bakeCurrentTransformIntoVertices();
			floatingBalls_FloatingBall.quarterMeshes.push(m);
			m.isVisible = false;
		}
	}
	var innersphere = floatingBalls_FloatingBall.innerMesh.createInstance("");
	innersphere.setParent(this);
	var _g1 = 0;
	while(_g1 < 4) {
		var i1 = _g1++;
		var sphere = floatingBalls_FloatingBall.quarterMeshes[i1].createInstance("");
		sphere.setParent(this);
		var bbmax = sphere.getBoundingInfo().boundingBox.center.multiplyByFloats(0.5,0.5,0.5);
		createjs.Tween.get(sphere.position,{ loop : true}).to({ y : bbmax.y, z : bbmax.z},2000,createjs.Ease.quadOut).to({ y : 0, z : 0},2000,createjs.Ease.quadOut);
	}
};
$hxClasses["floatingBalls.FloatingBall"] = floatingBalls_FloatingBall;
floatingBalls_FloatingBall.__name__ = ["floatingBalls","FloatingBall"];
floatingBalls_FloatingBall.__super__ = BABYLON.TransformNode;
floatingBalls_FloatingBall.prototype = $extend(BABYLON.TransformNode.prototype,{
	__class__: floatingBalls_FloatingBall
});
var floatingBalls_FloatingBalls = function() {
	this.balls = [];
	wl_core_Part.call(this);
};
$hxClasses["floatingBalls.FloatingBalls"] = floatingBalls_FloatingBalls;
floatingBalls_FloatingBalls.__name__ = ["floatingBalls","FloatingBalls"];
floatingBalls_FloatingBalls.__super__ = wl_core_Part;
floatingBalls_FloatingBalls.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var _g = 0;
		while(_g < 5) {
			var y = _g++;
			var _g1 = 0;
			while(_g1 < 5) {
				var x = _g1++;
				var _g2 = 0;
				while(_g2 < 5) {
					var z = _g2++;
					var b = new floatingBalls_FloatingBall();
					b.position.set(x * 3,y * 3,z * 3);
					this.scene.addTransformNode(b);
					this.balls.push(b);
				}
			}
		}
		var light = new BABYLON.HemisphericLight("light1",new BABYLON.Vector3(0,1,0),this.scene);
		var gl = new BABYLON.GlowLayer("glow",this.scene,{ mainTextureSamples : 2});
		gl.isEnabled = true;
		gl.intensity = 1;
		var pipeline = new BABYLON.DefaultRenderingPipeline("default",true,this.scene,[this.scene.activeCamera]);
		pipeline.depthOfFieldBlurLevel = 1;
		pipeline.depthOfFieldEnabled = true;
		pipeline.depthOfField.focalLength = 180;
		pipeline.depthOfField.fStop = 3;
		pipeline.depthOfField.focusDistance = 2250;
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: floatingBalls_FloatingBalls
});
var greets_GreetSPS = function(name,scene) {
	this.conf = [];
	this.phase = 0;
	this.intro = 0;
	var _gthis = this;
	BABYLON.TransformNode.call(this,name,scene);
	var img = wl_core_Assets.get(name);
	var id = wl_util_ExtractPixels.extract(img);
	this.sps = new BABYLON.SolidParticleSystem("sps",scene,{ updatable : true, isPickable : false, enableDepthSort : false, particleIntersection : false, boundingSphereOnly : true});
	var b = BABYLON.MeshBuilder.CreateBox("box",{ width : 1, height : 1, depth : 1});
	var amount = id.width * id.height + 250;
	var size = 500;
	var r = new wl_util_Random(123);
	var cols_0 = DemoMain.BASE_1;
	var cols_1 = DemoMain.LIGHT;
	var _g1 = 0;
	var _g = amount;
	while(_g1 < _g) {
		var i = _g1++;
		if(i < id.width * id.height) {
			var gpc = { startX : i % id.width - img.width / 2, startY : id.height - Math.floor(i / id.width) - img.height / 2, startZ : 0, targetX : i % id.width - (id.width / 2 - i % id.width) * (wl_util_Random.nextFloat() + 0.5) - img.width / 2, targetY : id.height - (Math.floor(i / id.width) - id.height / 2) * 3 * (wl_util_Random.nextFloat() + 0.5) - img.height / 2, targetZ : (wl_util_Random.nextFloat() - 0.5) * 3, rotX : 0, rotY : 0, rotZ : 0, delay : wl_util_Random.nextFloat() * 0.5 + 1.5, targetScale : 1};
			if(id.data[i * 4] > 0) {
				this.conf.push(gpc);
			}
		}
	}
	var posfunc = function(p,i1,s) {
		if(i1 == null) {
			i1 = p.idx;
		} else {
			i1 = i1;
		}
		var conf = _gthis.conf[i1];
		p.color = DemoMain.WHITE.clone().scale(0.7).toColor4(1);
		var phase = _gthis.phase - conf.delay;
		var introPhase = _gthis.intro - conf.delay * 0.25;
		if(_gthis.intro < 1) {
			if(introPhase > 0) {
				introPhase = 0;
			} else {
				introPhase = introPhase;
			}
			p.position.x = conf.startX;
			p.position.y = conf.startY;
			p.position.z = conf.startZ;
			p.rotation.x = conf.rotX;
			p.rotation.y = conf.rotY;
			p.rotation.z = conf.rotZ;
			p.scaling.x = p.scaling.y = p.scaling.z = 1 + introPhase;
		} else {
			if(phase < 0) {
				phase = 0;
			} else {
				phase = phase;
			}
			p.position.x = conf.startX + (conf.targetX - conf.startX) * phase;
			p.position.y = conf.startY + (conf.targetY - conf.startY) * phase;
			p.position.z = conf.startZ + (conf.targetZ - conf.startZ) * phase;
			p.rotation.x = conf.rotX;
			p.rotation.y = conf.rotY;
			p.rotation.z = conf.rotZ;
			p.scaling.x = p.scaling.y = p.scaling.z = 1 - phase / (4 - conf.delay);
		}
	};
	this.sps.updateParticle = posfunc;
	this.sps.addShape(b,this.conf.length,{ positionFunction : posfunc});
	this.mesh = this.sps.buildMesh();
	this.mesh.parent = this;
	b.dispose();
	this.mesh.visibility = 1;
	this.intro = 1;
	this.sps.setParticles();
};
$hxClasses["greets.GreetSPS"] = greets_GreetSPS;
greets_GreetSPS.__name__ = ["greets","GreetSPS"];
greets_GreetSPS.__super__ = BABYLON.TransformNode;
greets_GreetSPS.prototype = $extend(BABYLON.TransformNode.prototype,{
	animateIn: function(ts) {
		var _gthis = this;
		this.mesh.visibility = 1;
		console.log("ANIMATE IN");
		var tmp = createjs.Tween.get(this,{ onChange : function() {
			if(_gthis.sps != null) {
				_gthis.sps.setParticles();
			}
		}});
		var tmp1 = wl_core_TimeSig.milliseconds(0,2,0,0);
		var tmp2 = tmp.to({ intro : 1},tmp1);
		var tmp3 = wl_core_TimeSig.milliseconds(1,2,0,0);
		tmp2.to({ phase : 4},tmp3).call(function() {
			createjs.Tween.removeTweens(_gthis);
			_gthis.sps.dispose();
			_gthis.sps = null;
		});
	}
	,__class__: greets_GreetSPS
});
var greets_HairyBall = function(name,scene) {
	this.offset = wl_util_Random.nextFloat() * 0.5;
	BABYLON.TransformNode.call(this,name);
	this.scene = scene;
	if(greets_HairyBall.texture == null) {
		greets_HairyBall.texture = this.generateTexture();
	}
	this.initializeControls();
};
$hxClasses["greets.HairyBall"] = greets_HairyBall;
greets_HairyBall.__name__ = ["greets","HairyBall"];
greets_HairyBall.__super__ = BABYLON.TransformNode;
greets_HairyBall.prototype = $extend(BABYLON.TransformNode.prototype,{
	initializeControls: function() {
		var furi = false;
		if(greets_HairyBall.baseMesh == null) {
			furi = true;
			greets_HairyBall.baseMesh = BABYLON.MeshBuilder.CreateBox("box",{ });
			this.mesh = greets_HairyBall.baseMesh;
			greets_HairyBall.fur = new BABYLON.StandardMaterial("mat",this.scene);
			greets_HairyBall.fur.wireframe = false;
			greets_HairyBall.fur.diffuseColor = DemoMain.HILIGHT;
			this.mesh.material = greets_HairyBall.fur;
		} else {
			this.mesh = greets_HairyBall.baseMesh.createInstance("inst");
		}
		this.mesh.parent = this;
	}
	,generateTexture: function() {
		var r = new wl_util_Random(10);
		var texture = new BABYLON.DynamicTexture("FurTexture " + this.name,256,null,true);
		var context = texture.getContext();
		var _g = 0;
		while(_g < 20000) {
			var i = _g++;
			context.fillStyle = "rgba(255, " + Math.floor(r.NextFloat() * 255) + ", " + Math.floor(r.NextFloat() * 255) + ", 1)";
			context.fillRect(r.NextFloat() * texture.getSize().width,r.NextFloat() * texture.getSize().height,2,2);
		}
		texture.update(false);
		texture.wrapU = BABYLON.Texture.WRAP_ADDRESSMODE;
		texture.wrapV = BABYLON.Texture.WRAP_ADDRESSMODE;
		return texture;
	}
	,__class__: greets_HairyBall
});
var greets_PostTest = function() {
	this.greetNames = ["greet_adapt.png","greet_api.png","greet_alumni.png","greet_asd.png","greet_ananasmurska.png","greet_cncd.png","greet_artline_designs.png","greet_fgj.png","greet_byterapers.png","greet_hbc.png","greet_damones.png","greet_darklite.png","greet_dekadence.png","greet_ekspert.png","greet_epoch.png","greet_fairlight.png","greet_hedelmae.png","greet_jumalauta.png","greet_kewlers.png","greet_matt_current.png","greet_mercury.png","greet_mfx.png","greet_paraguay.png","greet_primitive.png","greet_npli.png","greet_pyrotech.png","greet_quadtrip.png","greet_scenesat.png","greet_tahtituho.png","greet_traction.png"];
	this.camdist = -1300;
	wl_core_Part.call(this);
};
$hxClasses["greets.PostTest"] = greets_PostTest;
greets_PostTest.__name__ = ["greets","PostTest"];
greets_PostTest.__super__ = wl_core_Part;
greets_PostTest.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var glowCube = BABYLON.MeshBuilder.CreateSphere("box",{ diameter : 245, sideOrientation : BABYLON.Mesh.DOUBLESIDE},null);
		var glowMat = new BABYLON.StandardMaterial("",null);
		glowMat.diffuseColor = DemoMain.BLACK.clone();
		glowMat.ambientColor = DemoMain.BLACK.clone();
		glowMat.emissiveColor = DemoMain.WHITE.clone().scale(0.5);
		glowCube.material = glowMat;
		this.scene.addMesh(glowCube);
		this.targetNode = new BABYLON.TransformNode("target",this.scene);
		this.pl = new BABYLON.PointLight("pl",new BABYLON.Vector3(0,0,0),this.scene);
		this.pl.diffuse = DemoMain.WHITE;
		this.pl.intensity = 1;
		this.pl.range = 1550;
		this.camera.position = new BABYLON.Vector3(0,0,this.camdist);
		this.greets = [];
		var c = 0;
		var _g = 0;
		var _g1 = this.greetNames;
		while(_g < _g1.length) {
			var g = _g1[_g];
			++_g;
			var gsps = new greets_GreetSPS(g,this.scene);
			this.greets.push(gsps);
			gsps.position.z = -700 + c * 20;
			gsps.position.x = Math.floor(c / 2) % 2 == 0 ? -80 : 80;
			gsps.position.y = Math.cos(c / 3) * 10 - (c % 2 == 0 ? 0 : 35) + 40;
			gsps.position.y -= Math.floor(c / 4) % 2 == 0 ? 80 : 0;
			++c;
			gsps.lookAt(this.camera.position);
		}
		this.targetNode.position.copyFrom(this.greets[0].position);
		this.setupPostprocessing();
		this.addTrigger(new wl_core_TimeSig(4,0,0,0,wl_core_TimeSig.RELATIVE),function(ts) {
			_gthis.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),function(ts1) {
				if(_gthis.greets.length > 0) {
					_gthis.greets.shift().animateIn(ts1);
					_gthis.greets.shift().animateIn(ts1);
				}
			});
		});
	}
	,setupPostprocessing: function() {
		var plConf = { };
		plConf.dof = false;
		plConf.bloom = true;
		plConf.chromaticAberration = true;
		plConf.imageProcessing = true;
		plConf.grain = true;
		plConf.fxaa = true;
		plConf.sharpen = true;
		plConf.distort = true;
		this.initPipeline(plConf);
		this.post.chromaticAberration.aberrationAmount = 5;
		this.post.imageProcessing.exposure = 1;
		this.post.imageProcessing.toneMappingEnabled = true;
		this.post.imageProcessing.vignetteEnabled = true;
		this.post.imageProcessing.vignetteBlendMode = 1;
		this.post.grain.animated = true;
		this.post.grain.intensity = 15;
		this.post.bloom.bloomWeight = 0.8;
		this.post.bloom.bloomThreshold = 0.01;
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		var tmp = createjs.Tween.get(this);
		var tmp1 = wl_core_TimeSig.milliseconds(32,0,0,0);
		tmp.to({ camdist : -120},tmp1,createjs.Ease.quadOut);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		var t = ts.toMilliseconds() / 1000;
		this.camera.position = new BABYLON.Vector3(0,0,this.camdist);
		this.camera.setTarget(this.targetNode.position);
		this.targetNode.position.x += (this.greets.length > 0 ? this.greets[0].position.x - this.targetNode.position.x : 0 - this.targetNode.position.x) / 140;
		this.targetNode.position.y += (this.greets.length > 0 ? this.greets[0].position.y - this.targetNode.position.y : 0 - this.targetNode.position.y) / 140;
		this.targetNode.position.z += (this.greets.length > 0 ? this.greets[0].position.z - this.targetNode.position.z : 0 - this.targetNode.position.z) / 140;
		var _g = 0;
		var _g1 = this.greets;
		while(_g < _g1.length) {
			var g = _g1[_g];
			++_g;
			g.lookAt(this.camera.position);
		}
		this.pl.position = this.camera.position;
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: greets_PostTest
});
var greetwall_GreetWall = function() {
	wl_core_Part.call(this);
};
$hxClasses["greetwall.GreetWall"] = greetwall_GreetWall;
greetwall_GreetWall.__name__ = ["greetwall","GreetWall"];
greetwall_GreetWall.__super__ = wl_core_Part;
greetwall_GreetWall.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var physicsPlugin = new BABYLON.CannonJSPlugin();
		var gravityVector = new BABYLON.Vector3(0,-9.81,0);
		this.scene.enablePhysics(gravityVector,physicsPlugin);
		var light = new BABYLON.HemisphericLight("light1",new BABYLON.Vector3(0,1,0),this.scene);
		light.diffuse = new BABYLON.Color3(0.9,0.1,0.1);
		light.intensity = 0.7;
		var ground = BABYLON.MeshBuilder.CreateGround("ground1",{ width : 500, height : 500},this.scene);
		ground.physicsImpostor = new BABYLON.PhysicsImpostor(ground,BABYLON.PhysicsImpostor.BoxImpostor,{ mass : 0, restitution : 0.9},this.scene);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,setupDatGui: function(folder) {
		wl_core_Part.prototype.setupDatGui.call(this,folder);
	}
	,__class__: greetwall_GreetWall
});
var haxe_IMap = function() { };
$hxClasses["haxe.IMap"] = haxe_IMap;
haxe_IMap.__name__ = ["haxe","IMap"];
var haxe_Resource = function() { };
$hxClasses["haxe.Resource"] = haxe_Resource;
haxe_Resource.__name__ = ["haxe","Resource"];
haxe_Resource.getString = function(name) {
	var _g = 0;
	var _g1 = haxe_Resource.content;
	while(_g < _g1.length) {
		var x = _g1[_g];
		++_g;
		if(x.name == name) {
			if(x.str != null) {
				return x.str;
			}
			var b = haxe_crypto_Base64.decode(x.data);
			return b.toString();
		}
	}
	return null;
};
var haxe_Timer = function(time_ms) {
	var me = this;
	this.id = setInterval(function() {
		me.run();
	},time_ms);
};
$hxClasses["haxe.Timer"] = haxe_Timer;
haxe_Timer.__name__ = ["haxe","Timer"];
haxe_Timer.delay = function(f,time_ms) {
	var t = new haxe_Timer(time_ms);
	t.run = function() {
		t.stop();
		f();
	};
	return t;
};
haxe_Timer.prototype = {
	stop: function() {
		if(this.id == null) {
			return;
		}
		clearInterval(this.id);
		this.id = null;
	}
	,run: function() {
	}
	,__class__: haxe_Timer
};
var haxe_io_Bytes = function(data) {
	this.length = data.byteLength;
	this.b = new Uint8Array(data);
	this.b.bufferValue = data;
	data.hxBytes = this;
	data.bytes = this.b;
};
$hxClasses["haxe.io.Bytes"] = haxe_io_Bytes;
haxe_io_Bytes.__name__ = ["haxe","io","Bytes"];
haxe_io_Bytes.ofString = function(s) {
	var a = [];
	var i = 0;
	while(i < s.length) {
		var c = s.charCodeAt(i++);
		if(55296 <= c && c <= 56319) {
			c = c - 55232 << 10 | s.charCodeAt(i++) & 1023;
		}
		if(c <= 127) {
			a.push(c);
		} else if(c <= 2047) {
			a.push(192 | c >> 6);
			a.push(128 | c & 63);
		} else if(c <= 65535) {
			a.push(224 | c >> 12);
			a.push(128 | c >> 6 & 63);
			a.push(128 | c & 63);
		} else {
			a.push(240 | c >> 18);
			a.push(128 | c >> 12 & 63);
			a.push(128 | c >> 6 & 63);
			a.push(128 | c & 63);
		}
	}
	return new haxe_io_Bytes(new Uint8Array(a).buffer);
};
haxe_io_Bytes.prototype = {
	getString: function(pos,len) {
		if(pos < 0 || len < 0 || pos + len > this.length) {
			throw new js__$Boot_HaxeError(haxe_io_Error.OutsideBounds);
		}
		var s = "";
		var b = this.b;
		var fcc = String.fromCharCode;
		var i = pos;
		var max = pos + len;
		while(i < max) {
			var c = b[i++];
			if(c < 128) {
				if(c == 0) {
					break;
				}
				s += fcc(c);
			} else if(c < 224) {
				s += fcc((c & 63) << 6 | b[i++] & 127);
			} else if(c < 240) {
				var c2 = b[i++];
				s += fcc((c & 31) << 12 | (c2 & 127) << 6 | b[i++] & 127);
			} else {
				var c21 = b[i++];
				var c3 = b[i++];
				var u = (c & 15) << 18 | (c21 & 127) << 12 | (c3 & 127) << 6 | b[i++] & 127;
				s += fcc((u >> 10) + 55232);
				s += fcc(u & 1023 | 56320);
			}
		}
		return s;
	}
	,toString: function() {
		return this.getString(0,this.length);
	}
	,__class__: haxe_io_Bytes
};
var haxe_crypto_Base64 = function() { };
$hxClasses["haxe.crypto.Base64"] = haxe_crypto_Base64;
haxe_crypto_Base64.__name__ = ["haxe","crypto","Base64"];
haxe_crypto_Base64.decode = function(str,complement) {
	if(complement == null) {
		complement = true;
	}
	if(complement) {
		while(HxOverrides.cca(str,str.length - 1) == 61) str = HxOverrides.substr(str,0,-1);
	}
	return new haxe_crypto_BaseCode(haxe_crypto_Base64.BYTES).decodeBytes(haxe_io_Bytes.ofString(str));
};
var haxe_crypto_BaseCode = function(base) {
	var len = base.length;
	var nbits = 1;
	while(len > 1 << nbits) ++nbits;
	if(nbits > 8 || len != 1 << nbits) {
		throw new js__$Boot_HaxeError("BaseCode : base length must be a power of two.");
	}
	this.base = base;
	this.nbits = nbits;
};
$hxClasses["haxe.crypto.BaseCode"] = haxe_crypto_BaseCode;
haxe_crypto_BaseCode.__name__ = ["haxe","crypto","BaseCode"];
haxe_crypto_BaseCode.prototype = {
	initTable: function() {
		var tbl = [];
		var _g = 0;
		while(_g < 256) {
			var i = _g++;
			tbl[i] = -1;
		}
		var _g1 = 0;
		var _g2 = this.base.length;
		while(_g1 < _g2) {
			var i1 = _g1++;
			tbl[this.base.b[i1]] = i1;
		}
		this.tbl = tbl;
	}
	,decodeBytes: function(b) {
		var nbits = this.nbits;
		var base = this.base;
		if(this.tbl == null) {
			this.initTable();
		}
		var tbl = this.tbl;
		var size = b.length * nbits >> 3;
		var out = new haxe_io_Bytes(new ArrayBuffer(size));
		var buf = 0;
		var curbits = 0;
		var pin = 0;
		var pout = 0;
		while(pout < size) {
			while(curbits < 8) {
				curbits += nbits;
				buf <<= nbits;
				var i = tbl[b.b[pin++]];
				if(i == -1) {
					throw new js__$Boot_HaxeError("BaseCode : invalid encoded char");
				}
				buf |= i;
			}
			curbits -= 8;
			out.b[pout++] = buf >> curbits & 255 & 255;
		}
		return out;
	}
	,__class__: haxe_crypto_BaseCode
};
var haxe_ds_BalancedTree = function() {
};
$hxClasses["haxe.ds.BalancedTree"] = haxe_ds_BalancedTree;
haxe_ds_BalancedTree.__name__ = ["haxe","ds","BalancedTree"];
haxe_ds_BalancedTree.prototype = {
	set: function(key,value) {
		this.root = this.setLoop(key,value,this.root);
	}
	,get: function(key) {
		var node = this.root;
		while(node != null) {
			var c = this.compare(key,node.key);
			if(c == 0) {
				return node.value;
			}
			if(c < 0) {
				node = node.left;
			} else {
				node = node.right;
			}
		}
		return null;
	}
	,setLoop: function(k,v,node) {
		if(node == null) {
			return new haxe_ds_TreeNode(null,k,v,null);
		}
		var c = this.compare(k,node.key);
		if(c == 0) {
			return new haxe_ds_TreeNode(node.left,k,v,node.right,node == null ? 0 : node._height);
		} else if(c < 0) {
			var nl = this.setLoop(k,v,node.left);
			return this.balance(nl,node.key,node.value,node.right);
		} else {
			var nr = this.setLoop(k,v,node.right);
			return this.balance(node.left,node.key,node.value,nr);
		}
	}
	,balance: function(l,k,v,r) {
		var hl = l == null ? 0 : l._height;
		var hr = r == null ? 0 : r._height;
		if(hl > hr + 2) {
			var _this = l.left;
			var _this1 = l.right;
			if((_this == null ? 0 : _this._height) >= (_this1 == null ? 0 : _this1._height)) {
				return new haxe_ds_TreeNode(l.left,l.key,l.value,new haxe_ds_TreeNode(l.right,k,v,r));
			} else {
				return new haxe_ds_TreeNode(new haxe_ds_TreeNode(l.left,l.key,l.value,l.right.left),l.right.key,l.right.value,new haxe_ds_TreeNode(l.right.right,k,v,r));
			}
		} else if(hr > hl + 2) {
			var _this2 = r.right;
			var _this3 = r.left;
			if((_this2 == null ? 0 : _this2._height) > (_this3 == null ? 0 : _this3._height)) {
				return new haxe_ds_TreeNode(new haxe_ds_TreeNode(l,k,v,r.left),r.key,r.value,r.right);
			} else {
				return new haxe_ds_TreeNode(new haxe_ds_TreeNode(l,k,v,r.left.left),r.left.key,r.left.value,new haxe_ds_TreeNode(r.left.right,r.key,r.value,r.right));
			}
		} else {
			return new haxe_ds_TreeNode(l,k,v,r,(hl > hr ? hl : hr) + 1);
		}
	}
	,compare: function(k1,k2) {
		return Reflect.compare(k1,k2);
	}
	,__class__: haxe_ds_BalancedTree
};
var haxe_ds_TreeNode = function(l,k,v,r,h) {
	if(h == null) {
		h = -1;
	}
	this.left = l;
	this.key = k;
	this.value = v;
	this.right = r;
	if(h == -1) {
		var tmp;
		var _this = this.left;
		var _this1 = this.right;
		if((_this == null ? 0 : _this._height) > (_this1 == null ? 0 : _this1._height)) {
			var _this2 = this.left;
			if(_this2 == null) {
				tmp = 0;
			} else {
				tmp = _this2._height;
			}
		} else {
			var _this3 = this.right;
			if(_this3 == null) {
				tmp = 0;
			} else {
				tmp = _this3._height;
			}
		}
		this._height = tmp + 1;
	} else {
		this._height = h;
	}
};
$hxClasses["haxe.ds.TreeNode"] = haxe_ds_TreeNode;
haxe_ds_TreeNode.__name__ = ["haxe","ds","TreeNode"];
haxe_ds_TreeNode.prototype = {
	__class__: haxe_ds_TreeNode
};
var haxe_ds_Either = { __ename__ : true, __constructs__ : ["Left","Right"] };
haxe_ds_Either.Left = function(v) { var $x = ["Left",0,v]; $x.__enum__ = haxe_ds_Either; $x.toString = $estr; return $x; };
haxe_ds_Either.Right = function(v) { var $x = ["Right",1,v]; $x.__enum__ = haxe_ds_Either; $x.toString = $estr; return $x; };
var haxe_ds_EnumValueMap = function() {
	haxe_ds_BalancedTree.call(this);
};
$hxClasses["haxe.ds.EnumValueMap"] = haxe_ds_EnumValueMap;
haxe_ds_EnumValueMap.__name__ = ["haxe","ds","EnumValueMap"];
haxe_ds_EnumValueMap.__interfaces__ = [haxe_IMap];
haxe_ds_EnumValueMap.__super__ = haxe_ds_BalancedTree;
haxe_ds_EnumValueMap.prototype = $extend(haxe_ds_BalancedTree.prototype,{
	compare: function(k1,k2) {
		var d = k1[1] - k2[1];
		if(d != 0) {
			return d;
		}
		var p1 = k1.slice(2);
		var p2 = k2.slice(2);
		if(p1.length == 0 && p2.length == 0) {
			return 0;
		}
		return this.compareArgs(p1,p2);
	}
	,compareArgs: function(a1,a2) {
		var ld = a1.length - a2.length;
		if(ld != 0) {
			return ld;
		}
		var _g1 = 0;
		var _g = a1.length;
		while(_g1 < _g) {
			var i = _g1++;
			var d = this.compareArg(a1[i],a2[i]);
			if(d != 0) {
				return d;
			}
		}
		return 0;
	}
	,compareArg: function(v1,v2) {
		if(Reflect.isEnumValue(v1) && Reflect.isEnumValue(v2)) {
			return this.compare(v1,v2);
		} else if((v1 instanceof Array) && v1.__enum__ == null && ((v2 instanceof Array) && v2.__enum__ == null)) {
			return this.compareArgs(v1,v2);
		} else {
			return Reflect.compare(v1,v2);
		}
	}
	,__class__: haxe_ds_EnumValueMap
});
var haxe_ds_ObjectMap = function() {
	this.h = { __keys__ : { }};
};
$hxClasses["haxe.ds.ObjectMap"] = haxe_ds_ObjectMap;
haxe_ds_ObjectMap.__name__ = ["haxe","ds","ObjectMap"];
haxe_ds_ObjectMap.__interfaces__ = [haxe_IMap];
haxe_ds_ObjectMap.prototype = {
	set: function(key,value) {
		var id = key.__id__ || (key.__id__ = ++haxe_ds_ObjectMap.count);
		this.h[id] = value;
		this.h.__keys__[id] = key;
	}
	,keys: function() {
		var a = [];
		for( var key in this.h.__keys__ ) {
		if(this.h.hasOwnProperty(key)) {
			a.push(this.h.__keys__[key]);
		}
		}
		return HxOverrides.iter(a);
	}
	,iterator: function() {
		return { ref : this.h, it : this.keys(), hasNext : function() {
			return this.it.hasNext();
		}, next : function() {
			var i = this.it.next();
			return this.ref[i.__id__];
		}};
	}
	,__class__: haxe_ds_ObjectMap
};
var haxe_ds_StringMap = function() {
	this.h = { };
};
$hxClasses["haxe.ds.StringMap"] = haxe_ds_StringMap;
haxe_ds_StringMap.__name__ = ["haxe","ds","StringMap"];
haxe_ds_StringMap.__interfaces__ = [haxe_IMap];
haxe_ds_StringMap.prototype = {
	setReserved: function(key,value) {
		if(this.rh == null) {
			this.rh = { };
		}
		this.rh["$" + key] = value;
	}
	,getReserved: function(key) {
		if(this.rh == null) {
			return null;
		} else {
			return this.rh["$" + key];
		}
	}
	,existsReserved: function(key) {
		if(this.rh == null) {
			return false;
		}
		return this.rh.hasOwnProperty("$" + key);
	}
	,__class__: haxe_ds_StringMap
};
var haxe_io_Error = { __ename__ : true, __constructs__ : ["Blocked","Overflow","OutsideBounds","Custom"] };
haxe_io_Error.Blocked = ["Blocked",0];
haxe_io_Error.Blocked.toString = $estr;
haxe_io_Error.Blocked.__enum__ = haxe_io_Error;
haxe_io_Error.Overflow = ["Overflow",1];
haxe_io_Error.Overflow.toString = $estr;
haxe_io_Error.Overflow.__enum__ = haxe_io_Error;
haxe_io_Error.OutsideBounds = ["OutsideBounds",2];
haxe_io_Error.OutsideBounds.toString = $estr;
haxe_io_Error.OutsideBounds.__enum__ = haxe_io_Error;
haxe_io_Error.Custom = function(e) { var $x = ["Custom",3,e]; $x.__enum__ = haxe_io_Error; $x.toString = $estr; return $x; };
var haxe_io_FPHelper = function() { };
$hxClasses["haxe.io.FPHelper"] = haxe_io_FPHelper;
haxe_io_FPHelper.__name__ = ["haxe","io","FPHelper"];
haxe_io_FPHelper.i32ToFloat = function(i) {
	var sign = 1 - (i >>> 31 << 1);
	var exp = i >>> 23 & 255;
	var sig = i & 8388607;
	if(sig == 0 && exp == 0) {
		return 0.0;
	}
	return sign * (1 + Math.pow(2,-23) * sig) * Math.pow(2,exp - 127);
};
haxe_io_FPHelper.floatToI32 = function(f) {
	if(f == 0) {
		return 0;
	}
	var af = f < 0 ? -f : f;
	var exp = Math.floor(Math.log(af) / 0.6931471805599453);
	if(exp < -127) {
		exp = -127;
	} else if(exp > 128) {
		exp = 128;
	}
	var sig = Math.round((af / Math.pow(2,exp) - 1) * 8388608);
	if(sig == 8388608 && exp < 128) {
		sig = 0;
		++exp;
	}
	return (f < 0 ? -2147483648 : 0) | exp + 127 << 23 | sig;
};
var wl_core_ShaderBase = function() {
	this.staticDone = false;
	this._defaultAttributes = ["position","normal","uv","world0","world1","world2","world3"];
	this._defaultUniforms = ["world","viewProjection"];
	console.log("init simple shader: " + Std.string(this.staticDone));
	if(!this.staticDone) {
		console.log("init simple shader");
		BABYLON.Effect.ShadersStore["simpleVertexShader"] = haxe_Resource.getString("simple.vert");
		this.staticDone = true;
	}
};
$hxClasses["wl.core.ShaderBase"] = wl_core_ShaderBase;
wl_core_ShaderBase.__name__ = ["wl","core","ShaderBase"];
wl_core_ShaderBase.prototype = {
	UseDefaultAttributes: function(customAttributes) {
		if(customAttributes != null) {
			return this._defaultAttributes.concat(customAttributes);
		} else {
			return this._defaultAttributes;
		}
	}
	,UseDefaultUniforms: function(customUniforms) {
		if(customUniforms != null) {
			return this._defaultUniforms.concat(customUniforms);
		} else {
			return this._defaultUniforms;
		}
	}
	,__class__: wl_core_ShaderBase
};
var henritesti_HenriShader = function() {
	this.uniforms = ["time"];
	this.color = new BABYLON.Color4(1,1,1,1);
	wl_core_ShaderBase.call(this);
	BABYLON.Effect.ShadersStore["henriPixelShader"] = haxe_Resource.getString("henrishader.frag");
};
$hxClasses["henritesti.HenriShader"] = henritesti_HenriShader;
henritesti_HenriShader.__name__ = ["henritesti","HenriShader"];
henritesti_HenriShader.__super__ = wl_core_ShaderBase;
henritesti_HenriShader.prototype = $extend(wl_core_ShaderBase.prototype,{
	update: function(ts) {
	}
	,__class__: henritesti_HenriShader
});
var henritesti_HenriTesti = function() {
	wl_core_Part.call(this);
};
$hxClasses["henritesti.HenriTesti"] = henritesti_HenriTesti;
henritesti_HenriTesti.__name__ = ["henritesti","HenriTesti"];
henritesti_HenriTesti.__super__ = wl_core_Part;
henritesti_HenriTesti.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var sphere = BABYLON.MeshBuilder.CreateSphere("sphere1",{ segments : 16, diameter : 1},this.scene);
		var light = new BABYLON.PointLight("light1",new BABYLON.Vector3(0,1,0),this.scene);
		light.position.y = 1;
		light.shadowEnabled = true;
		light.intensity = 0.5;
		light.shadowMinZ = 0.05;
		light.shadowMaxZ = 200;
		light.diffuse = DemoMain.HILIGHT.clone();
		var room = BABYLON.MeshBuilder.CreateBox("",{ width : 100, height : 100, depth : 100, sideOrientation : BABYLON.Mesh.BACKSIDE},this.scene);
		room.receiveShadows = true;
		var roomMat = new BABYLON.StandardMaterial("",this.scene);
		roomMat.diffuseColor = DemoMain.LIGHT.clone();
		roomMat.ambientColor = DemoMain.LIGHT.clone();
		room.material = roomMat;
		sphere.position.y = 1;
		this.scene.ambientColor = new BABYLON.Color3(0.1,0.1,0.1);
		var shadowGen = new BABYLON.ShadowGenerator(512,light);
		shadowGen.addShadowCaster(sphere);
		this.testshader = new henritesti_HenriShader();
		this.customProc = new BABYLON.CustomProceduralTexture("henri","henri",2048,this.scene);
		this.customProc.setFloat("t",0);
		this.customProc.refreshRate = 10;
		this.customProc.hasAlpha = true;
		var mat = new BABYLON.StandardMaterial("",this.scene);
		mat.diffuseTexture = this.customProc;
		mat.diffuseTexture.hasAlpha = true;
		mat.backFaceCulling = false;
		sphere.material = mat;
		var rpProp = { };
		rpProp.bloom = true;
		rpProp.chromaticAberration = true;
		rpProp.distort = false;
		rpProp.dof = true;
		rpProp.grain = true;
		rpProp.imageProcessing = true;
		rpProp.sharpen = false;
		rpProp.fxaa = true;
		this.initPipeline(rpProp);
		this.post.grain.intensity = 10;
		this.post.grain.animated = true;
		this.post.bloom.bloomThreshold = 0.9;
		this.post.bloom.bloomScale = 1;
		this.post.chromaticAberration.aberrationAmount = 1;
		this.post.dof.focalLength = 80;
		this.post.dof.focusDistance = 4000;
	}
	,update: function(ts,partial,frameTime,delta) {
		this.customProc.setFloat("t",ts.toMilliseconds() / 5200);
		this.customProc.render();
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: henritesti_HenriTesti
});
var js__$Boot_HaxeError = function(val) {
	Error.call(this);
	this.val = val;
	this.message = String(val);
	if(Error.captureStackTrace) {
		Error.captureStackTrace(this,js__$Boot_HaxeError);
	}
};
$hxClasses["js._Boot.HaxeError"] = js__$Boot_HaxeError;
js__$Boot_HaxeError.__name__ = ["js","_Boot","HaxeError"];
js__$Boot_HaxeError.wrap = function(val) {
	if((val instanceof Error)) {
		return val;
	} else {
		return new js__$Boot_HaxeError(val);
	}
};
js__$Boot_HaxeError.__super__ = Error;
js__$Boot_HaxeError.prototype = $extend(Error.prototype,{
	__class__: js__$Boot_HaxeError
});
var js_Boot = function() { };
$hxClasses["js.Boot"] = js_Boot;
js_Boot.__name__ = ["js","Boot"];
js_Boot.getClass = function(o) {
	if((o instanceof Array) && o.__enum__ == null) {
		return Array;
	} else {
		var cl = o.__class__;
		if(cl != null) {
			return cl;
		}
		var name = js_Boot.__nativeClassName(o);
		if(name != null) {
			return js_Boot.__resolveNativeClass(name);
		}
		return null;
	}
};
js_Boot.__string_rec = function(o,s) {
	if(o == null) {
		return "null";
	}
	if(s.length >= 5) {
		return "<...>";
	}
	var t = typeof(o);
	if(t == "function" && (o.__name__ || o.__ename__)) {
		t = "object";
	}
	switch(t) {
	case "function":
		return "<function>";
	case "object":
		if(o instanceof Array) {
			if(o.__enum__) {
				if(o.length == 2) {
					return o[0];
				}
				var str = o[0] + "(";
				s += "\t";
				var _g1 = 2;
				var _g = o.length;
				while(_g1 < _g) {
					var i = _g1++;
					if(i != 2) {
						str += "," + js_Boot.__string_rec(o[i],s);
					} else {
						str += js_Boot.__string_rec(o[i],s);
					}
				}
				return str + ")";
			}
			var l = o.length;
			var i1;
			var str1 = "[";
			s += "\t";
			var _g11 = 0;
			var _g2 = l;
			while(_g11 < _g2) {
				var i2 = _g11++;
				str1 += (i2 > 0 ? "," : "") + js_Boot.__string_rec(o[i2],s);
			}
			str1 += "]";
			return str1;
		}
		var tostr;
		try {
			tostr = o.toString;
		} catch( e ) {
			return "???";
		}
		if(tostr != null && tostr != Object.toString && typeof(tostr) == "function") {
			var s2 = o.toString();
			if(s2 != "[object Object]") {
				return s2;
			}
		}
		var k = null;
		var str2 = "{\n";
		s += "\t";
		var hasp = o.hasOwnProperty != null;
		for( var k in o ) {
		if(hasp && !o.hasOwnProperty(k)) {
			continue;
		}
		if(k == "prototype" || k == "__class__" || k == "__super__" || k == "__interfaces__" || k == "__properties__") {
			continue;
		}
		if(str2.length != 2) {
			str2 += ", \n";
		}
		str2 += s + k + " : " + js_Boot.__string_rec(o[k],s);
		}
		s = s.substring(1);
		str2 += "\n" + s + "}";
		return str2;
	case "string":
		return o;
	default:
		return String(o);
	}
};
js_Boot.__interfLoop = function(cc,cl) {
	if(cc == null) {
		return false;
	}
	if(cc == cl) {
		return true;
	}
	var intf = cc.__interfaces__;
	if(intf != null) {
		var _g1 = 0;
		var _g = intf.length;
		while(_g1 < _g) {
			var i = _g1++;
			var i1 = intf[i];
			if(i1 == cl || js_Boot.__interfLoop(i1,cl)) {
				return true;
			}
		}
	}
	return js_Boot.__interfLoop(cc.__super__,cl);
};
js_Boot.__instanceof = function(o,cl) {
	if(cl == null) {
		return false;
	}
	switch(cl) {
	case Array:
		if((o instanceof Array)) {
			return o.__enum__ == null;
		} else {
			return false;
		}
		break;
	case Bool:
		return typeof(o) == "boolean";
	case Dynamic:
		return true;
	case Float:
		return typeof(o) == "number";
	case Int:
		if(typeof(o) == "number") {
			return (o|0) === o;
		} else {
			return false;
		}
		break;
	case String:
		return typeof(o) == "string";
	default:
		if(o != null) {
			if(typeof(cl) == "function") {
				if(o instanceof cl) {
					return true;
				}
				if(js_Boot.__interfLoop(js_Boot.getClass(o),cl)) {
					return true;
				}
			} else if(typeof(cl) == "object" && js_Boot.__isNativeObj(cl)) {
				if(o instanceof cl) {
					return true;
				}
			}
		} else {
			return false;
		}
		if(cl == Class ? o.__name__ != null : false) {
			return true;
		}
		if(cl == Enum ? o.__ename__ != null : false) {
			return true;
		}
		return o.__enum__ == cl;
	}
};
js_Boot.__nativeClassName = function(o) {
	var name = js_Boot.__toStr.call(o).slice(8,-1);
	if(name == "Object" || name == "Function" || name == "Math" || name == "JSON") {
		return null;
	}
	return name;
};
js_Boot.__isNativeObj = function(o) {
	return js_Boot.__nativeClassName(o) != null;
};
js_Boot.__resolveNativeClass = function(name) {
	return $global[name];
};
var js_babylon_Promise = function() { };
$hxClasses["js.babylon.Promise"] = js_babylon_Promise;
js_babylon_Promise.__name__ = ["js","babylon","Promise"];
var js_babylon_ReadonlyArray = function() { };
$hxClasses["js.babylon.ReadonlyArray"] = js_babylon_ReadonlyArray;
js_babylon_ReadonlyArray.__name__ = ["js","babylon","ReadonlyArray"];
var js_babylon_Partial = function() { };
$hxClasses["js.babylon.Partial"] = js_babylon_Partial;
js_babylon_Partial.__name__ = ["js","babylon","Partial"];
var js_babylon_PromiseLike = function() { };
$hxClasses["js.babylon.PromiseLike"] = js_babylon_PromiseLike;
js_babylon_PromiseLike.__name__ = ["js","babylon","PromiseLike"];
var js_babylon_ArrayLike = function() { };
$hxClasses["js.babylon.ArrayLike"] = js_babylon_ArrayLike;
js_babylon_ArrayLike.__name__ = ["js","babylon","ArrayLike"];
var js_babylon_GamepadButton = function() { };
$hxClasses["js.babylon.GamepadButton"] = js_babylon_GamepadButton;
js_babylon_GamepadButton.__name__ = ["js","babylon","GamepadButton"];
var BABYLON_Window = function() { };
$hxClasses["BABYLON.Window"] = BABYLON_Window;
BABYLON_Window.__name__ = ["BABYLON","Window"];
BABYLON_Window.prototype = {
	__class__: BABYLON_Window
};
var BABYLON_WebGLRenderingContext = function() { };
$hxClasses["BABYLON.WebGLRenderingContext"] = BABYLON_WebGLRenderingContext;
BABYLON_WebGLRenderingContext.__name__ = ["BABYLON","WebGLRenderingContext"];
BABYLON_WebGLRenderingContext.prototype = {
	__class__: BABYLON_WebGLRenderingContext
};
var BABYLON_Document = function() { };
$hxClasses["BABYLON.Document"] = BABYLON_Document;
BABYLON_Document.__name__ = ["BABYLON","Document"];
BABYLON_Document.prototype = {
	__class__: BABYLON_Document
};
var BABYLON_HTMLCanvasElement = function() { };
$hxClasses["BABYLON.HTMLCanvasElement"] = BABYLON_HTMLCanvasElement;
BABYLON_HTMLCanvasElement.__name__ = ["BABYLON","HTMLCanvasElement"];
BABYLON_HTMLCanvasElement.prototype = {
	__class__: BABYLON_HTMLCanvasElement
};
var BABYLON_CanvasRenderingContext2D = function() { };
$hxClasses["BABYLON.CanvasRenderingContext2D"] = BABYLON_CanvasRenderingContext2D;
BABYLON_CanvasRenderingContext2D.__name__ = ["BABYLON","CanvasRenderingContext2D"];
BABYLON_CanvasRenderingContext2D.prototype = {
	__class__: BABYLON_CanvasRenderingContext2D
};
var BABYLON_WebGLBuffer = function() { };
$hxClasses["BABYLON.WebGLBuffer"] = BABYLON_WebGLBuffer;
BABYLON_WebGLBuffer.__name__ = ["BABYLON","WebGLBuffer"];
BABYLON_WebGLBuffer.prototype = {
	__class__: BABYLON_WebGLBuffer
};
var BABYLON_WebGLProgram = function() { };
$hxClasses["BABYLON.WebGLProgram"] = BABYLON_WebGLProgram;
BABYLON_WebGLProgram.__name__ = ["BABYLON","WebGLProgram"];
BABYLON_WebGLProgram.prototype = {
	__class__: BABYLON_WebGLProgram
};
var BABYLON_MouseEvent = function() { };
$hxClasses["BABYLON.MouseEvent"] = BABYLON_MouseEvent;
BABYLON_MouseEvent.__name__ = ["BABYLON","MouseEvent"];
BABYLON_MouseEvent.prototype = {
	__class__: BABYLON_MouseEvent
};
var BABYLON_Navigator = function() { };
$hxClasses["BABYLON.Navigator"] = BABYLON_Navigator;
BABYLON_Navigator.__name__ = ["BABYLON","Navigator"];
BABYLON_Navigator.prototype = {
	__class__: BABYLON_Navigator
};
var BABYLON_HTMLVideoElement = function() { };
$hxClasses["BABYLON.HTMLVideoElement"] = BABYLON_HTMLVideoElement;
BABYLON_HTMLVideoElement.__name__ = ["BABYLON","HTMLVideoElement"];
BABYLON_HTMLVideoElement.prototype = {
	__class__: BABYLON_HTMLVideoElement
};
var BABYLON_Screen = function() { };
$hxClasses["BABYLON.Screen"] = BABYLON_Screen;
BABYLON_Screen.__name__ = ["BABYLON","Screen"];
BABYLON_Screen.prototype = {
	__class__: BABYLON_Screen
};
var BABYLON_EXT_$disjoint_$timer_$query = function() { };
$hxClasses["BABYLON.EXT_disjoint_timer_query"] = BABYLON_EXT_$disjoint_$timer_$query;
BABYLON_EXT_$disjoint_$timer_$query.__name__ = ["BABYLON","EXT_disjoint_timer_query"];
BABYLON_EXT_$disjoint_$timer_$query.prototype = {
	__class__: BABYLON_EXT_$disjoint_$timer_$query
};
var BABYLON_WebGLUniformLocation = function() { };
$hxClasses["BABYLON.WebGLUniformLocation"] = BABYLON_WebGLUniformLocation;
BABYLON_WebGLUniformLocation.__name__ = ["BABYLON","WebGLUniformLocation"];
BABYLON_WebGLUniformLocation.prototype = {
	__class__: BABYLON_WebGLUniformLocation
};
var BABYLON_IDisposable = function() { };
$hxClasses["BABYLON.IDisposable"] = BABYLON_IDisposable;
BABYLON_IDisposable.__name__ = ["BABYLON","IDisposable"];
BABYLON_IDisposable.prototype = {
	__class__: BABYLON_IDisposable
};
var BABYLON_IActiveMeshCandidateProvider = function() { };
$hxClasses["BABYLON.IActiveMeshCandidateProvider"] = BABYLON_IActiveMeshCandidateProvider;
BABYLON_IActiveMeshCandidateProvider.__name__ = ["BABYLON","IActiveMeshCandidateProvider"];
BABYLON_IActiveMeshCandidateProvider.prototype = {
	__class__: BABYLON_IActiveMeshCandidateProvider
};
var BABYLON_IAnimatable = function() { };
$hxClasses["BABYLON.IAnimatable"] = BABYLON_IAnimatable;
BABYLON_IAnimatable.__name__ = ["BABYLON","IAnimatable"];
BABYLON_IAnimatable.prototype = {
	__class__: BABYLON_IAnimatable
};
var BABYLON_ISceneComponent = function() { };
$hxClasses["BABYLON.ISceneComponent"] = BABYLON_ISceneComponent;
BABYLON_ISceneComponent.__name__ = ["BABYLON","ISceneComponent"];
BABYLON_ISceneComponent.prototype = {
	__class__: BABYLON_ISceneComponent
};
var BABYLON_ISceneSerializableComponent = function() { };
$hxClasses["BABYLON.ISceneSerializableComponent"] = BABYLON_ISceneSerializableComponent;
BABYLON_ISceneSerializableComponent.__name__ = ["BABYLON","ISceneSerializableComponent"];
BABYLON_ISceneSerializableComponent.__interfaces__ = [BABYLON_ISceneComponent];
BABYLON_ISceneSerializableComponent.prototype = {
	__class__: BABYLON_ISceneSerializableComponent
};
var BABYLON_IAnimationKey = function() { };
$hxClasses["BABYLON.IAnimationKey"] = BABYLON_IAnimationKey;
BABYLON_IAnimationKey.__name__ = ["BABYLON","IAnimationKey"];
BABYLON_IAnimationKey.prototype = {
	__class__: BABYLON_IAnimationKey
};
var BABYLON_IEasingFunction = function() { };
$hxClasses["BABYLON.IEasingFunction"] = BABYLON_IEasingFunction;
BABYLON_IEasingFunction.__name__ = ["BABYLON","IEasingFunction"];
BABYLON_IEasingFunction.prototype = {
	__class__: BABYLON_IEasingFunction
};
var BABYLON_Behavior = function() { };
$hxClasses["BABYLON.Behavior"] = BABYLON_Behavior;
BABYLON_Behavior.__name__ = ["BABYLON","Behavior"];
BABYLON_Behavior.prototype = {
	__class__: BABYLON_Behavior
};
var BABYLON_ICollisionCoordinator = function() { };
$hxClasses["BABYLON.ICollisionCoordinator"] = BABYLON_ICollisionCoordinator;
BABYLON_ICollisionCoordinator.__name__ = ["BABYLON","ICollisionCoordinator"];
BABYLON_ICollisionCoordinator.prototype = {
	__class__: BABYLON_ICollisionCoordinator
};
var BABYLON_SerializedMesh = function() { };
$hxClasses["BABYLON.SerializedMesh"] = BABYLON_SerializedMesh;
BABYLON_SerializedMesh.__name__ = ["BABYLON","SerializedMesh"];
BABYLON_SerializedMesh.prototype = {
	__class__: BABYLON_SerializedMesh
};
var BABYLON_SerializedSubMesh = function() { };
$hxClasses["BABYLON.SerializedSubMesh"] = BABYLON_SerializedSubMesh;
BABYLON_SerializedSubMesh.__name__ = ["BABYLON","SerializedSubMesh"];
BABYLON_SerializedSubMesh.prototype = {
	__class__: BABYLON_SerializedSubMesh
};
var BABYLON_SerializedGeometry = function() { };
$hxClasses["BABYLON.SerializedGeometry"] = BABYLON_SerializedGeometry;
BABYLON_SerializedGeometry.__name__ = ["BABYLON","SerializedGeometry"];
BABYLON_SerializedGeometry.prototype = {
	__class__: BABYLON_SerializedGeometry
};
var BABYLON_BabylonMessage = function() { };
$hxClasses["BABYLON.BabylonMessage"] = BABYLON_BabylonMessage;
BABYLON_BabylonMessage.__name__ = ["BABYLON","BabylonMessage"];
BABYLON_BabylonMessage.prototype = {
	__class__: BABYLON_BabylonMessage
};
var BABYLON_SerializedColliderToWorker = function() { };
$hxClasses["BABYLON.SerializedColliderToWorker"] = BABYLON_SerializedColliderToWorker;
BABYLON_SerializedColliderToWorker.__name__ = ["BABYLON","SerializedColliderToWorker"];
BABYLON_SerializedColliderToWorker.prototype = {
	__class__: BABYLON_SerializedColliderToWorker
};
var BABYLON_WorkerReply = function() { };
$hxClasses["BABYLON.WorkerReply"] = BABYLON_WorkerReply;
BABYLON_WorkerReply.__name__ = ["BABYLON","WorkerReply"];
BABYLON_WorkerReply.prototype = {
	__class__: BABYLON_WorkerReply
};
var BABYLON_CollisionReplyPayload = function() { };
$hxClasses["BABYLON.CollisionReplyPayload"] = BABYLON_CollisionReplyPayload;
BABYLON_CollisionReplyPayload.__name__ = ["BABYLON","CollisionReplyPayload"];
BABYLON_CollisionReplyPayload.prototype = {
	__class__: BABYLON_CollisionReplyPayload
};
var BABYLON_InitPayload = function() { };
$hxClasses["BABYLON.InitPayload"] = BABYLON_InitPayload;
BABYLON_InitPayload.__name__ = ["BABYLON","InitPayload"];
var BABYLON_CollidePayload = function() { };
$hxClasses["BABYLON.CollidePayload"] = BABYLON_CollidePayload;
BABYLON_CollidePayload.__name__ = ["BABYLON","CollidePayload"];
BABYLON_CollidePayload.prototype = {
	__class__: BABYLON_CollidePayload
};
var BABYLON_UpdatePayload = function() { };
$hxClasses["BABYLON.UpdatePayload"] = BABYLON_UpdatePayload;
BABYLON_UpdatePayload.__name__ = ["BABYLON","UpdatePayload"];
BABYLON_UpdatePayload.prototype = {
	__class__: BABYLON_UpdatePayload
};
var BABYLON_ICollisionDetector = function() { };
$hxClasses["BABYLON.ICollisionDetector"] = BABYLON_ICollisionDetector;
BABYLON_ICollisionDetector.__name__ = ["BABYLON","ICollisionDetector"];
BABYLON_ICollisionDetector.prototype = {
	__class__: BABYLON_ICollisionDetector
};
var BABYLON_ICameraInput = function() { };
$hxClasses["BABYLON.ICameraInput"] = BABYLON_ICameraInput;
BABYLON_ICameraInput.__name__ = ["BABYLON","ICameraInput"];
BABYLON_ICameraInput.prototype = {
	__class__: BABYLON_ICameraInput
};
var BABYLON_CameraInputsMap = function() { };
$hxClasses["BABYLON.CameraInputsMap"] = BABYLON_CameraInputsMap;
BABYLON_CameraInputsMap.__name__ = ["BABYLON","CameraInputsMap"];
var BABYLON_VRDisplay = function() { };
$hxClasses["BABYLON.VRDisplay"] = BABYLON_VRDisplay;
BABYLON_VRDisplay.__name__ = ["BABYLON","VRDisplay"];
BABYLON_VRDisplay.prototype = {
	__class__: BABYLON_VRDisplay
};
var BABYLON_VRLayer = function() { };
$hxClasses["BABYLON.VRLayer"] = BABYLON_VRLayer;
BABYLON_VRLayer.__name__ = ["BABYLON","VRLayer"];
BABYLON_VRLayer.prototype = {
	__class__: BABYLON_VRLayer
};
var BABYLON_VRDisplayCapabilities = function() { };
$hxClasses["BABYLON.VRDisplayCapabilities"] = BABYLON_VRDisplayCapabilities;
BABYLON_VRDisplayCapabilities.__name__ = ["BABYLON","VRDisplayCapabilities"];
BABYLON_VRDisplayCapabilities.prototype = {
	__class__: BABYLON_VRDisplayCapabilities
};
var BABYLON_VREyeParameters = function() { };
$hxClasses["BABYLON.VREyeParameters"] = BABYLON_VREyeParameters;
BABYLON_VREyeParameters.__name__ = ["BABYLON","VREyeParameters"];
BABYLON_VREyeParameters.prototype = {
	__class__: BABYLON_VREyeParameters
};
var BABYLON_VRFieldOfView = function() { };
$hxClasses["BABYLON.VRFieldOfView"] = BABYLON_VRFieldOfView;
BABYLON_VRFieldOfView.__name__ = ["BABYLON","VRFieldOfView"];
BABYLON_VRFieldOfView.prototype = {
	__class__: BABYLON_VRFieldOfView
};
var BABYLON_VRFrameData = function() { };
$hxClasses["BABYLON.VRFrameData"] = BABYLON_VRFrameData;
BABYLON_VRFrameData.__name__ = ["BABYLON","VRFrameData"];
BABYLON_VRFrameData.prototype = {
	__class__: BABYLON_VRFrameData
};
var BABYLON_VRPose = function() { };
$hxClasses["BABYLON.VRPose"] = BABYLON_VRPose;
BABYLON_VRPose.__name__ = ["BABYLON","VRPose"];
BABYLON_VRPose.prototype = {
	__class__: BABYLON_VRPose
};
var BABYLON_VRStageParameters = function() { };
$hxClasses["BABYLON.VRStageParameters"] = BABYLON_VRStageParameters;
BABYLON_VRStageParameters.__name__ = ["BABYLON","VRStageParameters"];
BABYLON_VRStageParameters.prototype = {
	__class__: BABYLON_VRStageParameters
};
var BABYLON_EngineOptions = function() { };
$hxClasses["BABYLON.EngineOptions"] = BABYLON_EngineOptions;
BABYLON_EngineOptions.__name__ = ["BABYLON","EngineOptions"];
BABYLON_EngineOptions.prototype = {
	__class__: BABYLON_EngineOptions
};
var BABYLON_IDisplayChangedEventArgs = function() { };
$hxClasses["BABYLON.IDisplayChangedEventArgs"] = BABYLON_IDisplayChangedEventArgs;
BABYLON_IDisplayChangedEventArgs.__name__ = ["BABYLON","IDisplayChangedEventArgs"];
BABYLON_IDisplayChangedEventArgs.prototype = {
	__class__: BABYLON_IDisplayChangedEventArgs
};
var BABYLON_ImageBitmap = function() { };
$hxClasses["BABYLON.ImageBitmap"] = BABYLON_ImageBitmap;
BABYLON_ImageBitmap.__name__ = ["BABYLON","ImageBitmap"];
BABYLON_ImageBitmap.prototype = {
	__class__: BABYLON_ImageBitmap
};
var BABYLON_WebGLQuery = function() { };
$hxClasses["BABYLON.WebGLQuery"] = BABYLON_WebGLQuery;
BABYLON_WebGLQuery.__name__ = ["BABYLON","WebGLQuery"];
var BABYLON_WebGLSampler = function() { };
$hxClasses["BABYLON.WebGLSampler"] = BABYLON_WebGLSampler;
BABYLON_WebGLSampler.__name__ = ["BABYLON","WebGLSampler"];
var BABYLON_WebGLSync = function() { };
$hxClasses["BABYLON.WebGLSync"] = BABYLON_WebGLSync;
BABYLON_WebGLSync.__name__ = ["BABYLON","WebGLSync"];
var BABYLON_WebGLTransformFeedback = function() { };
$hxClasses["BABYLON.WebGLTransformFeedback"] = BABYLON_WebGLTransformFeedback;
BABYLON_WebGLTransformFeedback.__name__ = ["BABYLON","WebGLTransformFeedback"];
var BABYLON_WebGLVertexArrayObject = function() { };
$hxClasses["BABYLON.WebGLVertexArrayObject"] = BABYLON_WebGLVertexArrayObject;
BABYLON_WebGLVertexArrayObject.__name__ = ["BABYLON","WebGLVertexArrayObject"];
var BABYLON_GamepadButtonChanges = function() { };
$hxClasses["BABYLON.GamepadButtonChanges"] = BABYLON_GamepadButtonChanges;
BABYLON_GamepadButtonChanges.__name__ = ["BABYLON","GamepadButtonChanges"];
BABYLON_GamepadButtonChanges.prototype = {
	__class__: BABYLON_GamepadButtonChanges
};
var BABYLON_IEnvironmentHelperOptions = function() { };
$hxClasses["BABYLON.IEnvironmentHelperOptions"] = BABYLON_IEnvironmentHelperOptions;
BABYLON_IEnvironmentHelperOptions.__name__ = ["BABYLON","IEnvironmentHelperOptions"];
BABYLON_IEnvironmentHelperOptions.prototype = {
	__class__: BABYLON_IEnvironmentHelperOptions
};
var BABYLON_IEffectLayerOptions = function() { };
$hxClasses["BABYLON.IEffectLayerOptions"] = BABYLON_IEffectLayerOptions;
BABYLON_IEffectLayerOptions.__name__ = ["BABYLON","IEffectLayerOptions"];
BABYLON_IEffectLayerOptions.prototype = {
	__class__: BABYLON_IEffectLayerOptions
};
var BABYLON_IGlowLayerOptions = function() { };
$hxClasses["BABYLON.IGlowLayerOptions"] = BABYLON_IGlowLayerOptions;
BABYLON_IGlowLayerOptions.__name__ = ["BABYLON","IGlowLayerOptions"];
BABYLON_IGlowLayerOptions.prototype = {
	__class__: BABYLON_IGlowLayerOptions
};
var BABYLON_IHighlightLayerOptions = function() { };
$hxClasses["BABYLON.IHighlightLayerOptions"] = BABYLON_IHighlightLayerOptions;
BABYLON_IHighlightLayerOptions.__name__ = ["BABYLON","IHighlightLayerOptions"];
BABYLON_IHighlightLayerOptions.prototype = {
	__class__: BABYLON_IHighlightLayerOptions
};
var BABYLON_IShadowLight = function() { };
$hxClasses["BABYLON.IShadowLight"] = BABYLON_IShadowLight;
BABYLON_IShadowLight.__name__ = ["BABYLON","IShadowLight"];
BABYLON_IShadowLight.prototype = {
	__class__: BABYLON_IShadowLight
};
var BABYLON_ILoadingScreen = function() { };
$hxClasses["BABYLON.ILoadingScreen"] = BABYLON_ILoadingScreen;
BABYLON_ILoadingScreen.__name__ = ["BABYLON","ILoadingScreen"];
BABYLON_ILoadingScreen.prototype = {
	__class__: BABYLON_ILoadingScreen
};
var BABYLON_ISceneLoaderPluginExtensions = function() { };
$hxClasses["BABYLON.ISceneLoaderPluginExtensions"] = BABYLON_ISceneLoaderPluginExtensions;
BABYLON_ISceneLoaderPluginExtensions.__name__ = ["BABYLON","ISceneLoaderPluginExtensions"];
var BABYLON_ISceneLoaderPluginFactory = function() { };
$hxClasses["BABYLON.ISceneLoaderPluginFactory"] = BABYLON_ISceneLoaderPluginFactory;
BABYLON_ISceneLoaderPluginFactory.__name__ = ["BABYLON","ISceneLoaderPluginFactory"];
BABYLON_ISceneLoaderPluginFactory.prototype = {
	__class__: BABYLON_ISceneLoaderPluginFactory
};
var BABYLON_ISceneLoaderPlugin = function() { };
$hxClasses["BABYLON.ISceneLoaderPlugin"] = BABYLON_ISceneLoaderPlugin;
BABYLON_ISceneLoaderPlugin.__name__ = ["BABYLON","ISceneLoaderPlugin"];
BABYLON_ISceneLoaderPlugin.prototype = {
	__class__: BABYLON_ISceneLoaderPlugin
};
var BABYLON_ISceneLoaderPluginAsync = function() { };
$hxClasses["BABYLON.ISceneLoaderPluginAsync"] = BABYLON_ISceneLoaderPluginAsync;
BABYLON_ISceneLoaderPluginAsync.__name__ = ["BABYLON","ISceneLoaderPluginAsync"];
BABYLON_ISceneLoaderPluginAsync.prototype = {
	__class__: BABYLON_ISceneLoaderPluginAsync
};
var BABYLON_IImageProcessingConfigurationDefines = function() { };
$hxClasses["BABYLON.IImageProcessingConfigurationDefines"] = BABYLON_IImageProcessingConfigurationDefines;
BABYLON_IImageProcessingConfigurationDefines.__name__ = ["BABYLON","IImageProcessingConfigurationDefines"];
BABYLON_IImageProcessingConfigurationDefines.prototype = {
	__class__: BABYLON_IImageProcessingConfigurationDefines
};
var BABYLON_ISize = function() { };
$hxClasses["BABYLON.ISize"] = BABYLON_ISize;
BABYLON_ISize.__name__ = ["BABYLON","ISize"];
BABYLON_ISize.prototype = {
	__class__: BABYLON_ISize
};
var BABYLON_ISimplifier = function() { };
$hxClasses["BABYLON.ISimplifier"] = BABYLON_ISimplifier;
BABYLON_ISimplifier.__name__ = ["BABYLON","ISimplifier"];
BABYLON_ISimplifier.prototype = {
	__class__: BABYLON_ISimplifier
};
var BABYLON_ISimplificationSettings = function() { };
$hxClasses["BABYLON.ISimplificationSettings"] = BABYLON_ISimplificationSettings;
BABYLON_ISimplificationSettings.__name__ = ["BABYLON","ISimplificationSettings"];
BABYLON_ISimplificationSettings.prototype = {
	__class__: BABYLON_ISimplificationSettings
};
var BABYLON_ISimplificationTask = function() { };
$hxClasses["BABYLON.ISimplificationTask"] = BABYLON_ISimplificationTask;
BABYLON_ISimplificationTask.__name__ = ["BABYLON","ISimplificationTask"];
BABYLON_ISimplificationTask.prototype = {
	__class__: BABYLON_ISimplificationTask
};
var BABYLON_IParticleSystem = function() { };
$hxClasses["BABYLON.IParticleSystem"] = BABYLON_IParticleSystem;
BABYLON_IParticleSystem.__name__ = ["BABYLON","IParticleSystem"];
BABYLON_IParticleSystem.prototype = {
	__class__: BABYLON_IParticleSystem
};
var BABYLON_PhysicsImpostorJoint = function() { };
$hxClasses["BABYLON.PhysicsImpostorJoint"] = BABYLON_PhysicsImpostorJoint;
BABYLON_PhysicsImpostorJoint.__name__ = ["BABYLON","PhysicsImpostorJoint"];
BABYLON_PhysicsImpostorJoint.prototype = {
	__class__: BABYLON_PhysicsImpostorJoint
};
var BABYLON_IPhysicsEnginePlugin = function() { };
$hxClasses["BABYLON.IPhysicsEnginePlugin"] = BABYLON_IPhysicsEnginePlugin;
BABYLON_IPhysicsEnginePlugin.__name__ = ["BABYLON","IPhysicsEnginePlugin"];
BABYLON_IPhysicsEnginePlugin.prototype = {
	__class__: BABYLON_IPhysicsEnginePlugin
};
var BABYLON_PhysicsForceAndContactPoint = function() { };
$hxClasses["BABYLON.PhysicsForceAndContactPoint"] = BABYLON_PhysicsForceAndContactPoint;
BABYLON_PhysicsForceAndContactPoint.__name__ = ["BABYLON","PhysicsForceAndContactPoint"];
BABYLON_PhysicsForceAndContactPoint.prototype = {
	__class__: BABYLON_PhysicsForceAndContactPoint
};
var BABYLON_PhysicsRadialExplosionEventData = function() { };
$hxClasses["BABYLON.PhysicsRadialExplosionEventData"] = BABYLON_PhysicsRadialExplosionEventData;
BABYLON_PhysicsRadialExplosionEventData.__name__ = ["BABYLON","PhysicsRadialExplosionEventData"];
BABYLON_PhysicsRadialExplosionEventData.prototype = {
	__class__: BABYLON_PhysicsRadialExplosionEventData
};
var BABYLON_PhysicsGravitationalFieldEventData = function() { };
$hxClasses["BABYLON.PhysicsGravitationalFieldEventData"] = BABYLON_PhysicsGravitationalFieldEventData;
BABYLON_PhysicsGravitationalFieldEventData.__name__ = ["BABYLON","PhysicsGravitationalFieldEventData"];
BABYLON_PhysicsGravitationalFieldEventData.prototype = {
	__class__: BABYLON_PhysicsGravitationalFieldEventData
};
var BABYLON_PhysicsUpdraftEventData = function() { };
$hxClasses["BABYLON.PhysicsUpdraftEventData"] = BABYLON_PhysicsUpdraftEventData;
BABYLON_PhysicsUpdraftEventData.__name__ = ["BABYLON","PhysicsUpdraftEventData"];
BABYLON_PhysicsUpdraftEventData.prototype = {
	__class__: BABYLON_PhysicsUpdraftEventData
};
var BABYLON_PhysicsVortexEventData = function() { };
$hxClasses["BABYLON.PhysicsVortexEventData"] = BABYLON_PhysicsVortexEventData;
BABYLON_PhysicsVortexEventData.__name__ = ["BABYLON","PhysicsVortexEventData"];
BABYLON_PhysicsVortexEventData.prototype = {
	__class__: BABYLON_PhysicsVortexEventData
};
var BABYLON_PhysicsImpostorParameters = function() { };
$hxClasses["BABYLON.PhysicsImpostorParameters"] = BABYLON_PhysicsImpostorParameters;
BABYLON_PhysicsImpostorParameters.__name__ = ["BABYLON","PhysicsImpostorParameters"];
BABYLON_PhysicsImpostorParameters.prototype = {
	__class__: BABYLON_PhysicsImpostorParameters
};
var BABYLON_IPhysicsEnabledObject = function() { };
$hxClasses["BABYLON.IPhysicsEnabledObject"] = BABYLON_IPhysicsEnabledObject;
BABYLON_IPhysicsEnabledObject.__name__ = ["BABYLON","IPhysicsEnabledObject"];
BABYLON_IPhysicsEnabledObject.prototype = {
	__class__: BABYLON_IPhysicsEnabledObject
};
var BABYLON_PhysicsJointData = function() { };
$hxClasses["BABYLON.PhysicsJointData"] = BABYLON_PhysicsJointData;
BABYLON_PhysicsJointData.__name__ = ["BABYLON","PhysicsJointData"];
BABYLON_PhysicsJointData.prototype = {
	__class__: BABYLON_PhysicsJointData
};
var BABYLON_IMotorEnabledJoint = function() { };
$hxClasses["BABYLON.IMotorEnabledJoint"] = BABYLON_IMotorEnabledJoint;
BABYLON_IMotorEnabledJoint.__name__ = ["BABYLON","IMotorEnabledJoint"];
BABYLON_IMotorEnabledJoint.prototype = {
	__class__: BABYLON_IMotorEnabledJoint
};
var BABYLON_DistanceJointData = function() { };
$hxClasses["BABYLON.DistanceJointData"] = BABYLON_DistanceJointData;
BABYLON_DistanceJointData.__name__ = ["BABYLON","DistanceJointData"];
BABYLON_DistanceJointData.__interfaces__ = [BABYLON_PhysicsJointData];
BABYLON_DistanceJointData.prototype = {
	__class__: BABYLON_DistanceJointData
};
var BABYLON_SpringJointData = function() { };
$hxClasses["BABYLON.SpringJointData"] = BABYLON_SpringJointData;
BABYLON_SpringJointData.__name__ = ["BABYLON","SpringJointData"];
BABYLON_SpringJointData.__interfaces__ = [BABYLON_PhysicsJointData];
BABYLON_SpringJointData.prototype = {
	__class__: BABYLON_SpringJointData
};
var BABYLON_IRenderingManagerAutoClearSetup = function() { };
$hxClasses["BABYLON.IRenderingManagerAutoClearSetup"] = BABYLON_IRenderingManagerAutoClearSetup;
BABYLON_IRenderingManagerAutoClearSetup.__name__ = ["BABYLON","IRenderingManagerAutoClearSetup"];
BABYLON_IRenderingManagerAutoClearSetup.prototype = {
	__class__: BABYLON_IRenderingManagerAutoClearSetup
};
var BABYLON_IAssetsProgressEvent = function() { };
$hxClasses["BABYLON.IAssetsProgressEvent"] = BABYLON_IAssetsProgressEvent;
BABYLON_IAssetsProgressEvent.__name__ = ["BABYLON","IAssetsProgressEvent"];
BABYLON_IAssetsProgressEvent.prototype = {
	__class__: BABYLON_IAssetsProgressEvent
};
var BABYLON_ITextureAssetTask = function() { };
$hxClasses["BABYLON.ITextureAssetTask"] = BABYLON_ITextureAssetTask;
BABYLON_ITextureAssetTask.__name__ = ["BABYLON","ITextureAssetTask"];
BABYLON_ITextureAssetTask.prototype = {
	__class__: BABYLON_ITextureAssetTask
};
var BABYLON_DDSInfo = function() { };
$hxClasses["BABYLON.DDSInfo"] = BABYLON_DDSInfo;
BABYLON_DDSInfo.__name__ = ["BABYLON","DDSInfo"];
BABYLON_DDSInfo.prototype = {
	__class__: BABYLON_DDSInfo
};
var BABYLON_EnvironmentTextureInfo = function() { };
$hxClasses["BABYLON.EnvironmentTextureInfo"] = BABYLON_EnvironmentTextureInfo;
BABYLON_EnvironmentTextureInfo.__name__ = ["BABYLON","EnvironmentTextureInfo"];
BABYLON_EnvironmentTextureInfo.prototype = {
	__class__: BABYLON_EnvironmentTextureInfo
};
var BABYLON_IValueGradient = function() { };
$hxClasses["BABYLON.IValueGradient"] = BABYLON_IValueGradient;
BABYLON_IValueGradient.__name__ = ["BABYLON","IValueGradient"];
BABYLON_IValueGradient.prototype = {
	__class__: BABYLON_IValueGradient
};
var BABYLON_IFileRequest = function() { };
$hxClasses["BABYLON.IFileRequest"] = BABYLON_IFileRequest;
BABYLON_IFileRequest.__name__ = ["BABYLON","IFileRequest"];
BABYLON_IFileRequest.prototype = {
	__class__: BABYLON_IFileRequest
};
var BABYLON_MediaRecorder = function() { };
$hxClasses["BABYLON.MediaRecorder"] = BABYLON_MediaRecorder;
BABYLON_MediaRecorder.__name__ = ["BABYLON","MediaRecorder"];
BABYLON_MediaRecorder.prototype = {
	__class__: BABYLON_MediaRecorder
};
var BABYLON_MediaRecorderOptions = function() { };
$hxClasses["BABYLON.MediaRecorderOptions"] = BABYLON_MediaRecorderOptions;
BABYLON_MediaRecorderOptions.__name__ = ["BABYLON","MediaRecorderOptions"];
BABYLON_MediaRecorderOptions.prototype = {
	__class__: BABYLON_MediaRecorderOptions
};
var BABYLON_MediaRecorderConstructor = function() { };
$hxClasses["BABYLON.MediaRecorderConstructor"] = BABYLON_MediaRecorderConstructor;
BABYLON_MediaRecorderConstructor.__name__ = ["BABYLON","MediaRecorderConstructor"];
BABYLON_MediaRecorderConstructor.prototype = {
	__class__: BABYLON_MediaRecorderConstructor
};
var BABYLON_VideoRecorderOptions = function() { };
$hxClasses["BABYLON.VideoRecorderOptions"] = BABYLON_VideoRecorderOptions;
BABYLON_VideoRecorderOptions.__name__ = ["BABYLON","VideoRecorderOptions"];
BABYLON_VideoRecorderOptions.prototype = {
	__class__: BABYLON_VideoRecorderOptions
};
var BABYLON_VRTeleportationOptions = function() { };
$hxClasses["BABYLON.VRTeleportationOptions"] = BABYLON_VRTeleportationOptions;
BABYLON_VRTeleportationOptions.__name__ = ["BABYLON","VRTeleportationOptions"];
BABYLON_VRTeleportationOptions.prototype = {
	__class__: BABYLON_VRTeleportationOptions
};
var BABYLON_WebVROptions = function() { };
$hxClasses["BABYLON.WebVROptions"] = BABYLON_WebVROptions;
BABYLON_WebVROptions.__name__ = ["BABYLON","WebVROptions"];
BABYLON_WebVROptions.prototype = {
	__class__: BABYLON_WebVROptions
};
var BABYLON_VRExperienceHelperOptions = function() { };
$hxClasses["BABYLON.VRExperienceHelperOptions"] = BABYLON_VRExperienceHelperOptions;
BABYLON_VRExperienceHelperOptions.__name__ = ["BABYLON","VRExperienceHelperOptions"];
BABYLON_VRExperienceHelperOptions.__interfaces__ = [BABYLON_WebVROptions];
BABYLON_VRExperienceHelperOptions.prototype = {
	__class__: BABYLON_VRExperienceHelperOptions
};
var BABYLON_DevicePose = function() { };
$hxClasses["BABYLON.DevicePose"] = BABYLON_DevicePose;
BABYLON_DevicePose.__name__ = ["BABYLON","DevicePose"];
BABYLON_DevicePose.prototype = {
	__class__: BABYLON_DevicePose
};
var BABYLON_PoseControlled = function() { };
$hxClasses["BABYLON.PoseControlled"] = BABYLON_PoseControlled;
BABYLON_PoseControlled.__name__ = ["BABYLON","PoseControlled"];
BABYLON_PoseControlled.prototype = {
	__class__: BABYLON_PoseControlled
};
var BABYLON_IOctreeContainer = function() { };
$hxClasses["BABYLON.IOctreeContainer"] = BABYLON_IOctreeContainer;
BABYLON_IOctreeContainer.__name__ = ["BABYLON","IOctreeContainer"];
BABYLON_IOctreeContainer.prototype = {
	__class__: BABYLON_IOctreeContainer
};
var BABYLON_MutableGamepadButton = function() { };
$hxClasses["BABYLON.MutableGamepadButton"] = BABYLON_MutableGamepadButton;
BABYLON_MutableGamepadButton.__name__ = ["BABYLON","MutableGamepadButton"];
BABYLON_MutableGamepadButton.prototype = {
	__class__: BABYLON_MutableGamepadButton
};
var BABYLON_ExtendedGamepadButton = function() { };
$hxClasses["BABYLON.ExtendedGamepadButton"] = BABYLON_ExtendedGamepadButton;
BABYLON_ExtendedGamepadButton.__name__ = ["BABYLON","ExtendedGamepadButton"];
BABYLON_ExtendedGamepadButton.prototype = {
	__class__: BABYLON_ExtendedGamepadButton
};
var BABYLON_IShadowGenerator = function() { };
$hxClasses["BABYLON.IShadowGenerator"] = BABYLON_IShadowGenerator;
BABYLON_IShadowGenerator.__name__ = ["BABYLON","IShadowGenerator"];
BABYLON_IShadowGenerator.prototype = {
	__class__: BABYLON_IShadowGenerator
};
var BABYLON_IInternalTextureTracker = function() { };
$hxClasses["BABYLON.IInternalTextureTracker"] = BABYLON_IInternalTextureTracker;
BABYLON_IInternalTextureTracker.__name__ = ["BABYLON","IInternalTextureTracker"];
BABYLON_IInternalTextureTracker.prototype = {
	__class__: BABYLON_IInternalTextureTracker
};
var BABYLON_IInternalTextureLoader = function() { };
$hxClasses["BABYLON.IInternalTextureLoader"] = BABYLON_IInternalTextureLoader;
BABYLON_IInternalTextureLoader.__name__ = ["BABYLON","IInternalTextureLoader"];
BABYLON_IInternalTextureLoader.prototype = {
	__class__: BABYLON_IInternalTextureLoader
};
var BABYLON_IMultiRenderTargetOptions = function() { };
$hxClasses["BABYLON.IMultiRenderTargetOptions"] = BABYLON_IMultiRenderTargetOptions;
BABYLON_IMultiRenderTargetOptions.__name__ = ["BABYLON","IMultiRenderTargetOptions"];
BABYLON_IMultiRenderTargetOptions.prototype = {
	__class__: BABYLON_IMultiRenderTargetOptions
};
var BABYLON_VideoTextureSettings = function() { };
$hxClasses["BABYLON.VideoTextureSettings"] = BABYLON_VideoTextureSettings;
BABYLON_VideoTextureSettings.__name__ = ["BABYLON","VideoTextureSettings"];
BABYLON_VideoTextureSettings.prototype = {
	__class__: BABYLON_VideoTextureSettings
};
var BABYLON_IDracoCompressionConfiguration = function() { };
$hxClasses["BABYLON.IDracoCompressionConfiguration"] = BABYLON_IDracoCompressionConfiguration;
BABYLON_IDracoCompressionConfiguration.__name__ = ["BABYLON","IDracoCompressionConfiguration"];
BABYLON_IDracoCompressionConfiguration.prototype = {
	__class__: BABYLON_IDracoCompressionConfiguration
};
var BABYLON_IParticleEmitterType = function() { };
$hxClasses["BABYLON.IParticleEmitterType"] = BABYLON_IParticleEmitterType;
BABYLON_IParticleEmitterType.__name__ = ["BABYLON","IParticleEmitterType"];
BABYLON_IParticleEmitterType.prototype = {
	__class__: BABYLON_IParticleEmitterType
};
var BABYLON_HDRInfo = function() { };
$hxClasses["BABYLON.HDRInfo"] = BABYLON_HDRInfo;
BABYLON_HDRInfo.__name__ = ["BABYLON","HDRInfo"];
BABYLON_HDRInfo.prototype = {
	__class__: BABYLON_HDRInfo
};
var BABYLON_CubeMapInfo = function() { };
$hxClasses["BABYLON.CubeMapInfo"] = BABYLON_CubeMapInfo;
BABYLON_CubeMapInfo.__name__ = ["BABYLON","CubeMapInfo"];
BABYLON_CubeMapInfo.prototype = {
	__class__: BABYLON_CubeMapInfo
};
var js_html_compat_ArrayBuffer = function(a) {
	if((a instanceof Array) && a.__enum__ == null) {
		this.a = a;
		this.byteLength = a.length;
	} else {
		var len = a;
		this.a = [];
		var _g1 = 0;
		var _g = len;
		while(_g1 < _g) {
			var i = _g1++;
			this.a[i] = 0;
		}
		this.byteLength = len;
	}
};
$hxClasses["js.html.compat.ArrayBuffer"] = js_html_compat_ArrayBuffer;
js_html_compat_ArrayBuffer.__name__ = ["js","html","compat","ArrayBuffer"];
js_html_compat_ArrayBuffer.sliceImpl = function(begin,end) {
	var u = new Uint8Array(this,begin,end == null ? null : end - begin);
	var result = new ArrayBuffer(u.byteLength);
	var resultArray = new Uint8Array(result);
	resultArray.set(u);
	return result;
};
js_html_compat_ArrayBuffer.prototype = {
	slice: function(begin,end) {
		return new js_html_compat_ArrayBuffer(this.a.slice(begin,end));
	}
	,__class__: js_html_compat_ArrayBuffer
};
var js_html_compat_Float32Array = function() { };
$hxClasses["js.html.compat.Float32Array"] = js_html_compat_Float32Array;
js_html_compat_Float32Array.__name__ = ["js","html","compat","Float32Array"];
js_html_compat_Float32Array._new = function(arg1,offset,length) {
	var arr;
	if(typeof(arg1) == "number") {
		arr = [];
		var _g1 = 0;
		var _g = arg1;
		while(_g1 < _g) {
			var i = _g1++;
			arr[i] = 0;
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = 0;
		var _g2 = [];
		var _g21 = 0;
		var _g11 = arr.length << 2;
		while(_g21 < _g11) {
			var i1 = _g21++;
			_g2.push(0);
		}
		arr.buffer = new js_html_compat_ArrayBuffer(_g2);
	} else if(js_Boot.__instanceof(arg1,js_html_compat_ArrayBuffer)) {
		var buffer = arg1;
		if(offset == null) {
			offset = 0;
		}
		if(length == null) {
			length = buffer.byteLength - offset >> 2;
		}
		arr = [];
		var _g12 = 0;
		var _g3 = length;
		while(_g12 < _g3) {
			var i2 = _g12++;
			var val = buffer.a[offset++] | buffer.a[offset++] << 8 | buffer.a[offset++] << 16 | buffer.a[offset++] << 24;
			arr.push(haxe_io_FPHelper.i32ToFloat(val));
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = offset;
		arr.buffer = buffer;
	} else if((arg1 instanceof Array) && arg1.__enum__ == null) {
		arr = arg1.slice();
		var buffer1 = [];
		var _g4 = 0;
		while(_g4 < arr.length) {
			var f = arr[_g4];
			++_g4;
			var i3 = haxe_io_FPHelper.floatToI32(f);
			buffer1.push(i3 & 255);
			buffer1.push(i3 >> 8 & 255);
			buffer1.push(i3 >> 16 & 255);
			buffer1.push(i3 >>> 24);
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(buffer1);
	} else {
		throw new js__$Boot_HaxeError("TODO " + Std.string(arg1));
	}
	arr.subarray = js_html_compat_Float32Array._subarray;
	arr.set = js_html_compat_Float32Array._set;
	return arr;
};
js_html_compat_Float32Array._set = function(arg,offset) {
	if(js_Boot.__instanceof(arg.buffer,js_html_compat_ArrayBuffer)) {
		var a = arg;
		if(arg.byteLength + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g1 = 0;
		var _g = arg.byteLength;
		while(_g1 < _g) {
			var i = _g1++;
			this[i + offset] = a[i];
		}
	} else if((arg instanceof Array) && arg.__enum__ == null) {
		var a1 = arg;
		if(a1.length + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g11 = 0;
		var _g2 = a1.length;
		while(_g11 < _g2) {
			var i1 = _g11++;
			this[i1 + offset] = a1[i1];
		}
	} else {
		throw new js__$Boot_HaxeError("TODO");
	}
};
js_html_compat_Float32Array._subarray = function(start,end) {
	var a = js_html_compat_Float32Array._new(this.slice(start,end));
	a.byteOffset = start * 4;
	return a;
};
var js_html_compat_Uint8Array = function() { };
$hxClasses["js.html.compat.Uint8Array"] = js_html_compat_Uint8Array;
js_html_compat_Uint8Array.__name__ = ["js","html","compat","Uint8Array"];
js_html_compat_Uint8Array._new = function(arg1,offset,length) {
	var arr;
	if(typeof(arg1) == "number") {
		arr = [];
		var _g1 = 0;
		var _g = arg1;
		while(_g1 < _g) {
			var i = _g1++;
			arr[i] = 0;
		}
		arr.byteLength = arr.length;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(arr);
	} else if(js_Boot.__instanceof(arg1,js_html_compat_ArrayBuffer)) {
		var buffer = arg1;
		if(offset == null) {
			offset = 0;
		}
		if(length == null) {
			length = buffer.byteLength - offset;
		}
		if(offset == 0) {
			arr = buffer.a;
		} else {
			arr = buffer.a.slice(offset,offset + length);
		}
		arr.byteLength = arr.length;
		arr.byteOffset = offset;
		arr.buffer = buffer;
	} else if((arg1 instanceof Array) && arg1.__enum__ == null) {
		arr = arg1.slice();
		arr.byteLength = arr.length;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(arr);
	} else {
		throw new js__$Boot_HaxeError("TODO " + Std.string(arg1));
	}
	arr.subarray = js_html_compat_Uint8Array._subarray;
	arr.set = js_html_compat_Uint8Array._set;
	return arr;
};
js_html_compat_Uint8Array._set = function(arg,offset) {
	if(js_Boot.__instanceof(arg.buffer,js_html_compat_ArrayBuffer)) {
		var a = arg;
		if(arg.byteLength + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g1 = 0;
		var _g = arg.byteLength;
		while(_g1 < _g) {
			var i = _g1++;
			this[i + offset] = a[i];
		}
	} else if((arg instanceof Array) && arg.__enum__ == null) {
		var a1 = arg;
		if(a1.length + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g11 = 0;
		var _g2 = a1.length;
		while(_g11 < _g2) {
			var i1 = _g11++;
			this[i1 + offset] = a1[i1];
		}
	} else {
		throw new js__$Boot_HaxeError("TODO");
	}
};
js_html_compat_Uint8Array._subarray = function(start,end) {
	var a = js_html_compat_Uint8Array._new(this.slice(start,end));
	a.byteOffset = start;
	return a;
};
var multicube_HollowCube = function(m,scene) {
	BABYLON.TransformNode.call(this,"",scene);
	m.parent = this;
};
$hxClasses["multicube.HollowCube"] = multicube_HollowCube;
multicube_HollowCube.__name__ = ["multicube","HollowCube"];
multicube_HollowCube.__super__ = BABYLON.TransformNode;
multicube_HollowCube.prototype = $extend(BABYLON.TransformNode.prototype,{
	__class__: multicube_HollowCube
});
var multicube_MultiCube = function() {
	this.exposureMP = 0;
	this.cubes = [];
	wl_core_Part.call(this);
};
$hxClasses["multicube.MultiCube"] = multicube_MultiCube;
multicube_MultiCube.__name__ = ["multicube","MultiCube"];
multicube_MultiCube.__super__ = wl_core_Part;
multicube_MultiCube.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.lowFilter = { isolate : true, lowLimit : 0, highLimit : 200};
		this.mediumFilter = { isolate : true, lowLimit : 700, highLimit : 1200};
		this.highFilter = { isolate : true, lowLimit : 1000, highLimit : 16000};
		this.analyzer = new wl_sounds_SoundAnalyzer();
		this.analyzer.historySize = 10;
		this.analyzer.filters.push(this.lowFilter);
		this.analyzer.filters.push(this.mediumFilter);
		this.analyzer.filters.push(this.highFilter);
		var rpProp = { };
		rpProp.bloom = true;
		rpProp.chromaticAberration = true;
		rpProp.distort = true;
		rpProp.dof = false;
		rpProp.grain = true;
		rpProp.imageProcessing = true;
		rpProp.sharpen = false;
		rpProp.fxaa = false;
		rpProp.displacement = false;
		this.initPipeline(rpProp);
		this.post.distort.lineHeight = wl_core_Config.RESOLUTION[1] / 60;
		var room = BABYLON.MeshBuilder.CreateBox("",{ width : 300, height : 300, depth : 300, sideOrientation : BABYLON.Mesh.BACKSIDE},this.scene);
		room.receiveShadows = true;
		this.light = new BABYLON.PointLight("",BABYLON.Vector3.Zero(),this.scene);
		this.light.diffuse = DemoMain.BASE_1;
		this.light.intensity = 0.6;
		this.light.shadowEnabled = true;
		this.light.position.y = 0;
		this.shadowGenerator = new BABYLON.ShadowGenerator(1024,this.light);
		var redbox = BABYLON.MeshBuilder.CreateBox("",{ width : 5, height : 5, depth : 5});
		redbox.isVisible = false;
		var redmat = new BABYLON.StandardMaterial("",this.scene);
		redmat.diffuseColor = new BABYLON.Color3(1,0,0);
		redbox.material = redmat;
		this.light.parent = redbox;
		var meshes = [];
		var bo = wl_util_ExtendedMeshBuilder.CreateHollowCube("",{ width : 5, height : 5, depth : 5, edge : 0.05},this.scene);
		meshes.push(bo);
		var _g = -3;
		while(_g < 3) {
			var x = _g++;
			var _g1 = -3;
			while(_g1 < 3) {
				var y = _g1++;
				var _g2 = -3;
				while(_g2 < 3) {
					var z = _g2++;
					var nbox = wl_util_ExtendedMeshBuilder.CreateHollowCube("",{ width : 5, height : 5, depth : 5, edge : 0.05},this.scene);
					meshes.push(nbox);
					nbox.position = new BABYLON.Vector3(x * 6,y * 6,z * 6);
				}
			}
		}
		var m = BABYLON.Mesh.MergeMeshes(meshes,true,true);
		var _g3 = 0;
		while(_g3 < meshes.length) {
			var m1 = meshes[_g3];
			++_g3;
			m1.dispose();
		}
		this.shadowGenerator.getShadowMap().renderList.push(m);
		redbox.position.x = -10;
		this.camera.fov = 2.83;
		this.camera.position.z = -20;
		this.camera.position = new BABYLON.Vector3(-89,120,-96);
		createjs.Tween.get(redbox.position,{ loop : true}).to({ x : 10},5000,createjs.Ease.circOut).to({ x : -10},5000,createjs.Ease.sineInOut);
		this.camera.setTarget(this.light.position);
		this.rndcc = new wl_demo_RandomCameraController(this.camera,8,[],97678,[wl_demo_CameraController.LINEAR],[5,15],new BABYLON.BoundingBox(new BABYLON.Vector3(22.01,22.01,22.01),new BABYLON.Vector3(50.3,50.3,50.3)));
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),function(ts) {
			_gthis.rndcc.swap();
			var tmp = wl_util_Random.nextFloat() * 0.8;
			_gthis.camera.fov = tmp + 1.8;
		});
		this.camera.setTarget(this.light.position);
	}
	,start: function(ts) {
		var tmp = createjs.Tween.get(this);
		var tmp1 = wl_core_TimeSig.milliseconds(1,0,0,0);
		tmp.to({ exposureMP : 1},tmp1);
		wl_core_Part.prototype.start.call(this,ts);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		this.analyzer.update();
		this.post.grain.intensity = this.lowFilter.max * 30 + 5;
		this.post.chromaticAberration.aberrationAmount = this.mediumFilter.max < 0.6 ? 0 : (this.mediumFilter.max - 0.6) * 120;
		this.post.distort.intensity = this.mediumFilter.max < 0.8 ? 0 : (this.mediumFilter.max - 0.9) * 0.015;
		this.post.distort.intensityY = this.highFilter.max < 0.5 ? 0 : (this.highFilter.max - 0.7) * 0.015;
		this.post.bloom.bloomWeight = this.lowFilter.max * 20;
		this.post.imageProcessing.vignetteWeight = this.lowFilter.max * 2;
		this.post.imageProcessing.exposure = this.exposureMP * Math.min(1.100,0.7 + Math.max(0,this.lowFilter.min - 0.8) * 2.5) * 2;
	}
	,render: function(ts,frameTime,toScreen) {
		this.rndcc.updateLength(wl_core_TimeSig.milliseconds(1,0,0,0));
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,setupDatGui: function(folder) {
		wl_core_Part.prototype.setupDatGui.call(this,folder);
		var shadowfolder = folder.addFolder("shadows");
		shadowfolder.add(this.shadowGenerator,"useVarianceShadowMap");
		shadowfolder.add(this.shadowGenerator,"usePoissonSampling");
		shadowfolder.add(this.shadowGenerator,"usePercentageCloserFiltering");
		shadowfolder.add(this.shadowGenerator,"useKernelBlur");
		shadowfolder.add(this.shadowGenerator,"useExponentialShadowMap");
		shadowfolder.add(this.shadowGenerator,"useContactHardeningShadow");
		shadowfolder.add(this.shadowGenerator,"useCloseExponentialShadowMap");
		shadowfolder.add(this.shadowGenerator,"useBlurVarianceShadowMap");
		shadowfolder.add(this.shadowGenerator,"useBlurExponentialShadowMap");
		shadowfolder.add(this.shadowGenerator,"useBlurCloseExponentialShadowMap");
		shadowfolder.add(this.shadowGenerator,"bias");
		var lightfolder = folder.addFolder("light");
		wl_util_DatGuiHelper.addColor(lightfolder,this.light,"diffuse");
		lightfolder.add(this.light,"intensity");
	}
	,__class__: multicube_MultiCube
});
var petetesti_PeteTesti = function() {
	wl_core_Part.call(this);
};
$hxClasses["petetesti.PeteTesti"] = petetesti_PeteTesti;
petetesti_PeteTesti.__name__ = ["petetesti","PeteTesti"];
petetesti_PeteTesti.__super__ = wl_core_Part;
petetesti_PeteTesti.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var sphere = BABYLON.MeshBuilder.CreateSphere("sphere1",{ segments : 16, diameter : 1},this.scene);
		var light = new BABYLON.PointLight("light1",new BABYLON.Vector3(0,1,0),this.scene);
		light.position.y = 1;
		light.shadowEnabled = true;
		light.intensity = 0.5;
		light.shadowMinZ = 0.05;
		light.shadowMaxZ = 200;
		light.diffuse = new BABYLON.Color3(1,0,0);
		var room = BABYLON.MeshBuilder.CreateBox("",{ width : 100, height : 100, depth : 100, sideOrientation : BABYLON.Mesh.BACKSIDE},this.scene);
		room.receiveShadows = true;
		sphere.position.y = 1;
		var shadowGen = new BABYLON.ShadowGenerator(512,light);
		shadowGen.addShadowCaster(sphere);
		this.testshader = new petetesti_Testshader();
		this.customProc = new BABYLON.CustomProceduralTexture("test","test",1024,this.scene);
		this.customProc.setFloat("t",0);
		this.customProc.refreshRate = 10;
		this.customProc.hasAlpha = true;
		var mat = new BABYLON.StandardMaterial("",this.scene);
		mat.diffuseTexture = this.customProc;
		mat.diffuseTexture.hasAlpha = true;
		mat.backFaceCulling = false;
		sphere.material = mat;
	}
	,update: function(ts,partial,frameTime,delta) {
		this.customProc.setFloat("t",ts.toMilliseconds() / 200);
		this.customProc.render();
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: petetesti_PeteTesti
});
var petetesti_Testshader = function() {
	this.uniforms = ["time"];
	this.color = new BABYLON.Color4(1,1,1,1);
	wl_core_ShaderBase.call(this);
	BABYLON.Effect.ShadersStore["testPixelShader"] = haxe_Resource.getString("testshader.frag");
};
$hxClasses["petetesti.Testshader"] = petetesti_Testshader;
petetesti_Testshader.__name__ = ["petetesti","Testshader"];
petetesti_Testshader.__super__ = wl_core_ShaderBase;
petetesti_Testshader.prototype = $extend(wl_core_ShaderBase.prototype,{
	update: function(ts) {
	}
	,__class__: petetesti_Testshader
});
var physicalballcluster_PhysicalBallCluster = function() {
	wl_core_Part.call(this);
};
$hxClasses["physicalballcluster.PhysicalBallCluster"] = physicalballcluster_PhysicalBallCluster;
physicalballcluster_PhysicalBallCluster.__name__ = ["physicalballcluster","PhysicalBallCluster"];
physicalballcluster_PhysicalBallCluster.__super__ = wl_core_Part;
physicalballcluster_PhysicalBallCluster.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var physicsPlugin = new BABYLON.CannonJSPlugin();
		var gravityVector = new BABYLON.Vector3(0,-9.81,0);
		this.scene.enablePhysics(gravityVector,physicsPlugin);
		var light = new BABYLON.HemisphericLight("light1",new BABYLON.Vector3(0,1,0),this.scene);
		light.intensity = 0.7;
		this.baseSphere = BABYLON.MeshBuilder.CreateSphere("sphere1",{ diameter : 0.5},this.scene);
		this.baseSphere.position.y = 2;
		var ground = BABYLON.MeshBuilder.CreateGround("ground1",{ width : 12, height : 12},this.scene);
		ground.position.y = -2;
		this.baseSphere.physicsImpostor = new BABYLON.PhysicsImpostor(this.baseSphere,BABYLON.PhysicsImpostor.SphereImpostor,{ mass : 1, restitution : 0.9},this.scene);
		ground.physicsImpostor = new BABYLON.PhysicsImpostor(ground,BABYLON.PhysicsImpostor.BoxImpostor,{ mass : 0, restitution : 0.9},this.scene);
		var boxBase = BABYLON.MeshBuilder.CreateBox("ground1",{ width : 1, height : 1, depth : 1},this.scene);
		var _g = -10;
		while(_g < 10) {
			var x = _g++;
			var _g1 = -10;
			while(_g1 < 10) {
				var z = _g1++;
				var box = boxBase.createInstance("");
				var tmp = wl_util_Random.nextFloat();
				box.position.x = x + tmp;
				var tmp1 = wl_util_Random.nextFloat();
				box.position.z = z + tmp1;
				box.position.y = wl_util_Random.nextFloat();
				box.scaling.y = 1 + box.position.y;
				box.physicsImpostor = new BABYLON.PhysicsImpostor(box,BABYLON.PhysicsImpostor.BoxImpostor,{ mass : 0, restitution : 0.9},this.scene);
			}
		}
		window.document.addEventListener("keydown",$bind(this,this.onKeyDown));
	}
	,onKeyDown: function() {
		var sphere = this.baseSphere.createInstance("");
		var tmp = wl_util_Random.nextFloat() * 20;
		sphere.position.y = 10 + tmp;
		var tmp1 = wl_util_Random.nextFloat() * 12;
		sphere.position.x = 6 - tmp1;
		var tmp2 = wl_util_Random.nextFloat() * 12;
		sphere.position.z = 6 - tmp2;
		sphere.physicsImpostor = new BABYLON.PhysicsImpostor(sphere,BABYLON.PhysicsImpostor.SphereImpostor,{ mass : 1, restitution : 0.9},this.scene);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,setupDatGui: function(folder) {
		wl_core_Part.prototype.setupDatGui.call(this,folder);
	}
	,__class__: physicalballcluster_PhysicalBallCluster
});
var rotocube_HollowCube = function(m,scene) {
	BABYLON.TransformNode.call(this,"",scene);
	m.parent = this;
	this.speed = 0.005 - (0.005 * wl_util_Random.nextFloat() + .002);
};
$hxClasses["rotocube.HollowCube"] = rotocube_HollowCube;
rotocube_HollowCube.__name__ = ["rotocube","HollowCube"];
rotocube_HollowCube.__super__ = BABYLON.TransformNode;
rotocube_HollowCube.prototype = $extend(BABYLON.TransformNode.prototype,{
	__class__: rotocube_HollowCube
});
var rotocube_RotoCube = function() {
	this.exposureMP = 0;
	this.cubes = [];
	wl_core_Part.call(this);
};
$hxClasses["rotocube.RotoCube"] = rotocube_RotoCube;
rotocube_RotoCube.__name__ = ["rotocube","RotoCube"];
rotocube_RotoCube.__super__ = wl_core_Part;
rotocube_RotoCube.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.lowFilter = { isolate : true, lowLimit : 0, highLimit : 200};
		this.mediumFilter = { isolate : true, lowLimit : 700, highLimit : 1200};
		this.highFilter = { isolate : true, lowLimit : 1000, highLimit : 16000};
		this.analyzer = new wl_sounds_SoundAnalyzer();
		this.analyzer.historySize = 10;
		this.analyzer.filters.push(this.lowFilter);
		this.analyzer.filters.push(this.mediumFilter);
		this.analyzer.filters.push(this.highFilter);
		var rpProp = { };
		rpProp.bloom = true;
		rpProp.chromaticAberration = true;
		rpProp.distort = true;
		rpProp.dof = true;
		rpProp.grain = true;
		rpProp.imageProcessing = true;
		rpProp.sharpen = false;
		rpProp.fxaa = false;
		rpProp.displacement = false;
		this.initPipeline(rpProp);
		this.post.grain.animated = true;
		this.post.distort.lineHeight = wl_core_Config.RESOLUTION[1] / 60;
		this.post.imageProcessing.vignetteEnabled = true;
		var room = BABYLON.MeshBuilder.CreateBox("",{ width : 20, height : 20, depth : 20, sideOrientation : BABYLON.Mesh.BACKSIDE},this.scene);
		room.receiveShadows = true;
		var roomMat = new BABYLON.StandardMaterial("",this.scene);
		room.material = roomMat;
		roomMat.diffuseColor = DemoMain.WHITE.scale(0.15);
		this.light = new BABYLON.PointLight("",BABYLON.Vector3.Zero(),this.scene);
		this.light.diffuse = DemoMain.WHITE;
		this.light.intensity = 1.5;
		this.light.shadowEnabled = true;
		this.light.position.y = 5;
		this.light.shadowMinZ = 0.1;
		this.light.shadowMaxZ = 50;
		this.shadowGenerator = new BABYLON.ShadowGenerator(1024,this.light);
		var _g = 1;
		while(_g < 4) {
			var i = _g++;
			var bo = wl_util_ExtendedMeshBuilder.CreateHollowCube("",{ width : 1, height : 1, depth : 1, edge : 0.1},this.scene);
			bo.receiveShadows = false;
			this.shadowGenerator.getShadowMap().renderList.push(bo);
			var hollowcube = new rotocube_HollowCube(bo,this.scene);
			hollowcube.scaling.multiplyInPlace(new BABYLON.Vector3(i,i,i));
			hollowcube.position.copyFrom(this.light.position);
			this.cubes.push(hollowcube);
		}
		this.rndcc = new wl_demo_RandomCameraController(this.camera,8,[],97678,[wl_demo_CameraController.LINEAR],[5,15],new BABYLON.BoundingBox(new BABYLON.Vector3(2.01,2.01,2.01),new BABYLON.Vector3(6.3,6.3,6.3)));
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),function(ts) {
			_gthis.rndcc.swap();
			var tmp = wl_util_Random.nextFloat() * 0.9;
			_gthis.camera.fov = tmp + 0.7;
		});
		this.camera.setTarget(this.light.position);
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		this.rndcc.swap();
		var tmp = createjs.Tween.get(this);
		var tmp1 = wl_core_TimeSig.milliseconds(1,0,0,0);
		tmp.to({ exposureMP : 1},tmp1);
	}
	,update: function(ts,partial,frameTime,delta) {
		var _g = 0;
		var _g1 = this.cubes;
		while(_g < _g1.length) {
			var c = _g1[_g];
			++_g;
			c.rotate(BABYLON.Vector3.Up(),delta * c.speed);
			c.rotate(BABYLON.Vector3.Right(),delta * c.speed);
			c.rotate(BABYLON.Vector3.Forward(),delta * c.speed);
		}
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		this.analyzer.update();
		this.post.grain.intensity = this.lowFilter.max * 30 + 5;
		this.post.chromaticAberration.aberrationAmount = this.mediumFilter.max < 0.6 ? 0 : (this.mediumFilter.max - 0.6) * 120;
		this.post.distort.intensity = this.mediumFilter.max < 0.8 ? 0 : (this.mediumFilter.max - 0.9) * 0.02;
		this.post.distort.intensityY = this.highFilter.max < 0.5 ? 0 : (this.highFilter.max - 0.7) * 0.02;
		this.post.bloom.bloomWeight = this.lowFilter.max * 10;
		this.post.imageProcessing.vignetteWeight = this.lowFilter.max * 2;
		this.post.imageProcessing.exposure = this.exposureMP * Math.min(1.100,0.7 + Math.max(0,this.lowFilter.min - 0.8) * 2.5);
	}
	,render: function(ts,frameTime,toScreen) {
		this.rndcc.updateLength(wl_core_TimeSig.milliseconds(1,0,0,0));
		this.camera.setTarget(new BABYLON.Vector3(0,6,0));
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,setupDatGui: function(folder) {
		wl_core_Part.prototype.setupDatGui.call(this,folder);
		var shadowfolder = folder.addFolder("shadows");
		shadowfolder.add(this.shadowGenerator,"useVarianceShadowMap");
		shadowfolder.add(this.shadowGenerator,"usePoissonSampling");
		shadowfolder.add(this.shadowGenerator,"usePercentageCloserFiltering");
		shadowfolder.add(this.shadowGenerator,"useKernelBlur");
		shadowfolder.add(this.shadowGenerator,"useExponentialShadowMap");
		shadowfolder.add(this.shadowGenerator,"useContactHardeningShadow");
		shadowfolder.add(this.shadowGenerator,"useCloseExponentialShadowMap");
		shadowfolder.add(this.shadowGenerator,"useBlurVarianceShadowMap");
		shadowfolder.add(this.shadowGenerator,"useBlurExponentialShadowMap");
		shadowfolder.add(this.shadowGenerator,"useBlurCloseExponentialShadowMap");
		shadowfolder.add(this.shadowGenerator,"bias");
		var lightfolder = folder.addFolder("light");
		wl_util_DatGuiHelper.addColor(lightfolder,this.light,"diffuse");
		lightfolder.add(this.light,"intensity");
	}
	,__class__: rotocube_RotoCube
});
var shatterball_ShatterBallPart = function() {
	wl_core_Part.call(this);
};
$hxClasses["shatterball.ShatterBallPart"] = shatterball_ShatterBallPart;
shatterball_ShatterBallPart.__name__ = ["shatterball","ShatterBallPart"];
shatterball_ShatterBallPart.__super__ = wl_core_Part;
shatterball_ShatterBallPart.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var light = new BABYLON.HemisphericLight("",BABYLON.Vector3.Down(),this.scene);
		this.emitter = BABYLON.MeshBuilder.CreateSphere("",{ diameter : 4, segments : 20, updatable : true},this.scene);
		this.particleSystem = new BABYLON.ParticleSystem("",50000,this.scene);
		this.particleSystem.particleTexture = wl_core_Assets.getTexture("flare.png");
		this.particleSystem.emitRate = 1500;
		this.particleSystem.emitter = this.emitter;
		this.particleSystem.blendMode = 0;
		this.particleSystem.minAngularSpeed = 0;
		this.particleSystem.maxAngularSpeed = Math.PI;
		this.particleSystem.minEmitPower = 0.5;
		this.particleSystem.maxEmitPower = 1.5;
		this.particleSystem.updateSpeed = 0.005;
		var sphereEmitter = this.particleSystem.createSphereEmitter(2,0.1);
		this.addTrigger(new wl_core_TimeSig(0,0,0,0,wl_core_TimeSig.RELATIVE),function(ts) {
			_gthis.particleSystem.start();
		});
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: shatterball_ShatterBallPart
});
var whiteroom_ChainWR = function(p1,pc,p2,scale,scene) {
	this.links = [];
	this.start = p1;
	this.control = pc;
	this.target = p2;
	var anchor1 = BABYLON.MeshBuilder.CreateSphere("anchor",{ diameter : 0.5},scene);
	anchor1.position.copyFrom(p1);
	anchor1.visibility = 0.0;
	anchor1.dispose();
	var linkMesh = this.buildLink(scene);
	linkMesh.scaling.copyFrom(scale);
	linkMesh.bakeCurrentTransformIntoVertices();
	var bb = linkMesh.getBoundingInfo().boundingBox;
	var count = Math.ceil(BABYLON.Vector3.Distance(p1,p2) / (bb.maximum.y - bb.minimum.y) * 1.4);
	var mass = 1 / count;
	var directionCurve = BABYLON.Curve3.CreateQuadraticBezier(p1,pc,p2,count);
	var count1 = Math.ceil(directionCurve.length() / (bb.maximum.y - bb.minimum.y) * 1.4);
	var directionCurve1 = BABYLON.Curve3.CreateQuadraticBezier(p1,pc,p2,count1);
	var _g1 = 0;
	var _g = count1;
	while(_g1 < _g) {
		var i = _g1++;
		var il = linkMesh.createInstance("");
		var node = new BABYLON.TransformNode("",scene);
		il.parent = node;
		il.position.copyFrom(BABYLON.Vector3.Zero());
		var points = directionCurve1.getPoints();
		var vec = points[i];
		node.position.copyFrom(vec);
		var vNext = i < points.length - 1 ? points[i + 1] : p2;
		node.lookAt(vNext);
		if(i % 2 == 1) {
			il.rotate(BABYLON.Vector3.Up(),Math.PI * 0.5);
			il.rotate(BABYLON.Vector3.Forward(),Math.PI / 2);
		} else {
			il.rotate(BABYLON.Vector3.Right(),Math.PI / 2);
		}
		this.links.push(node);
	}
};
$hxClasses["whiteroom.ChainWR"] = whiteroom_ChainWR;
whiteroom_ChainWR.__name__ = ["whiteroom","ChainWR"];
whiteroom_ChainWR.prototype = {
	updateChain: function() {
		var directionCurve = BABYLON.Curve3.CreateQuadraticBezier(this.start,this.control,this.target,this.links.length);
		var i = 0;
		var _g = 0;
		var _g1 = this.links;
		while(_g < _g1.length) {
			var node = _g1[_g];
			++_g;
			var points = directionCurve.getPoints();
			var vec = points[i];
			node.position.copyFrom(vec);
			var vNext = i < points.length - 1 ? points[i + 1] : this.target;
			node.lookAt(vNext);
			++i;
		}
	}
	,buildLink: function(scene) {
		var points = [new BABYLON.Vector3(0.1,0.07,0)];
		var curve = BABYLON.Curve3.CreateCubicBezier(new BABYLON.Vector3(0.1,0.18,0),new BABYLON.Vector3(0.1,0.28,0),new BABYLON.Vector3(-0.1,0.28,0),new BABYLON.Vector3(-0.1,0.18,0),6);
		points = points.concat(curve.getPoints());
		curve = BABYLON.Curve3.CreateCubicBezier(new BABYLON.Vector3(-0.1,-0.18,0),new BABYLON.Vector3(-0.1,-0.28,0),new BABYLON.Vector3(0.1,-0.28,0),new BABYLON.Vector3(0.1,-0.18,0),6);
		points = points.concat(curve.getPoints());
		points.push(points[0].subtract(new BABYLON.Vector3(0,0.015,0)));
		var linkMesh = BABYLON.MeshBuilder.CreateTube("Chain-Link",{ radius : 0.04, path : points, cap : 3, tessellation : 6},scene);
		whiteroom_ChainWR.linkmaterial = wl_library_Library.get_instance().getMaterial(wl_library_Materials.ghost2,true);
		whiteroom_ChainWR.linkmaterial.fresnelopacity = whiteroom_ChainWR.linkmaterial.opacityFresnelParameters;
		whiteroom_ChainWR.linkmaterial.alpha = 1.0;
		linkMesh.material = whiteroom_ChainWR.linkmaterial;
		linkMesh.setEnabled(false);
		return linkMesh;
	}
	,ghost: function() {
		whiteroom_ChainWR.linkmaterial.alpha = 0.1;
		whiteroom_ChainWR.linkmaterial.emissiveColor = new BABYLON.Color3(1,1,1);
		whiteroom_ChainWR.linkmaterial.opacityFresnelParameters = whiteroom_ChainWR.linkmaterial.fresnelopacity;
	}
	,normalize: function() {
		whiteroom_ChainWR.linkmaterial.alpha = 1.0;
		whiteroom_ChainWR.linkmaterial.emissiveColor = new BABYLON.Color3(0,0,0);
		whiteroom_ChainWR.linkmaterial.opacityFresnelParameters = null;
	}
	,__class__: whiteroom_ChainWR
};
var whiteroom_ReflectiveBall = function(name,scene,isPure) {
	BABYLON.TransformNode.call(this,name,scene,isPure);
	this.material = new BABYLON.StandardMaterial("rballmat",scene);
	this.mesh = BABYLON.MeshBuilder.CreateIcoSphere("rball",{ radius : 1, subdivisions : 4},scene);
	this.mesh.material = this.material;
	this.material.diffuseColor = DemoMain.BASE_3.clone();
	this.material.emissiveColor = DemoMain.BASE_1.clone().scale(0.1);
	this.material.ambientColor = DemoMain.BASE_2.clone();
	this.mesh.parent = this;
};
$hxClasses["whiteroom.ReflectiveBall"] = whiteroom_ReflectiveBall;
whiteroom_ReflectiveBall.__name__ = ["whiteroom","ReflectiveBall"];
whiteroom_ReflectiveBall.__super__ = BABYLON.TransformNode;
whiteroom_ReflectiveBall.prototype = $extend(BABYLON.TransformNode.prototype,{
	__class__: whiteroom_ReflectiveBall
});
var whiteroom_WallCube = function() {
	this.level = 0;
	this.levels = [];
	BABYLON.TransformNode.call(this,"");
	if(whiteroom_WallCube.innerMeshes == null) {
		whiteroom_WallCube.innerMeshes = [];
		var cols = [DemoMain.WHITE.clone().scale(1)];
		var _g = 0;
		while(_g < 1) {
			var i = _g++;
			var innerMesh = BABYLON.MeshBuilder.CreateBox("box",{ width : 1, height : 1, depth : 1},null);
			var innermat = new BABYLON.StandardMaterial("",null);
			innermat.diffuseColor = cols[i % cols.length];
			innermat.ambientColor = BABYLON.Color3.White();
			innerMesh.material = innermat;
			innerMesh.isVisible = false;
			innerMesh.receiveShadows = false;
			whiteroom_WallCube.innerMeshes.push(innerMesh);
		}
	}
	var s = 1;
	var _g1 = 0;
	while(_g1 < 40) {
		var i1 = _g1++;
		this.levels.push(s);
		s += wl_util_Random.nextFloat() > 0.2 ? 0 : 0.5;
		if(s < 0) {
			s = 0;
		}
	}
	var innersphere = whiteroom_WallCube.innerMeshes[wl_util_Random.next() % 1].createInstance("");
	innersphere.setParent(this);
	this.mesh = innersphere;
};
$hxClasses["whiteroom.WallCube"] = whiteroom_WallCube;
whiteroom_WallCube.__name__ = ["whiteroom","WallCube"];
whiteroom_WallCube.__super__ = BABYLON.TransformNode;
whiteroom_WallCube.prototype = $extend(BABYLON.TransformNode.prototype,{
	__class__: whiteroom_WallCube
});
var whiteroom_WhiteRoom = function() {
	this.startedBar = 0;
	this.cubesZ = [];
	this.cubesY = [];
	this.cubesX = [];
	this.ambientAmount = 0;
	this.balls = [];
	wl_core_Part.call(this);
};
$hxClasses["whiteroom.WhiteRoom"] = whiteroom_WhiteRoom;
whiteroom_WhiteRoom.__name__ = ["whiteroom","WhiteRoom"];
whiteroom_WhiteRoom.__super__ = wl_core_Part;
whiteroom_WhiteRoom.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.lowFilter = { isolate : true, lowLimit : 0, highLimit : 200};
		this.mediumFilter = { isolate : true, lowLimit : 400, highLimit : 1000};
		this.highFilter = { isolate : true, lowLimit : 1000, highLimit : 16000};
		this.analyzer = new wl_sounds_SoundAnalyzer();
		this.analyzer.historySize = 10;
		this.analyzer.filters.push(this.lowFilter);
		this.analyzer.filters.push(this.mediumFilter);
		this.analyzer.filters.push(this.highFilter);
		var xvals = [0.7,0,0.2,0.8,0.3,0.0,0.5,0.6,0.7];
		var zvals = [0.0,0.2,0.7,0.5,0.1,0.8,0.0,0.1,0.3];
		var _g1 = 0;
		var _g = zvals.length;
		while(_g1 < _g) {
			var i = _g1++;
			var xp = (xvals[i] - 0.5) * 30;
			var zp = (zvals[i] - 0.5) * 30;
			var c = new whiteroom_ChainWR(new BABYLON.Vector3(xp,-20,zp),new BABYLON.Vector3(xp + 1,0,zp),new BABYLON.Vector3(xp,20,zp),new BABYLON.Vector3(2,2,2),this.scene);
		}
		var w = 9;
		var h = 9;
		var d = 9;
		var _g11 = 0;
		var _g2 = h;
		while(_g11 < _g2) {
			var y = _g11++;
			var _g3 = 0;
			var _g21 = w;
			while(_g3 < _g21) {
				var x = _g3++;
				var _g5 = 0;
				var _g4 = d;
				while(_g5 < _g4) {
					var z = _g5++;
					if((z == 0 || z == d - 1) && (x > 0 && x < w - 1) && (y > 0 && y < h - 1) || (y == 0 || y == h - 1) && (z > 0 && z < d - 1) && (x > 0 && x < w - 1) || (x == 0 || x == w - 1) && (z > 0 && z < d - 1) && (y > 0 && y < h - 1)) {
						var b = new whiteroom_WallCube();
						b.scaling.set(wl_util_Random.nextFloat(),wl_util_Random.nextFloat(),wl_util_Random.nextFloat());
						b.position.set(x - w / 2,y - h / 2,z - d / 2);
						this.scene.addTransformNode(b);
						this.balls.push(b);
						if(x == 0 || x == w - 1) {
							this.cubesX.push(b);
						}
						if(y == 0 || y == h - 1) {
							this.cubesY.push(b);
						}
						if(z == 0 || z == d - 1) {
							this.cubesZ.push(b);
						}
					}
				}
			}
		}
		this.light = new BABYLON.DirectionalLight("pl",new BABYLON.Vector3(),this.scene);
		this.light.intensity = 0.2;
		this.light.diffuse = DemoMain.WHITE.clone();
		this.light.specular = DemoMain.BASE_1.clone();
		this.light2 = new BABYLON.DirectionalLight("pl",new BABYLON.Vector3(),this.scene);
		this.light2.intensity = 0.2;
		this.light2.diffuse = DemoMain.WHITE.clone();
		this.light2.specular = DemoMain.BASE_1.clone();
		this.scene.fogMode = BABYLON.Scene.FOGMODE_EXP;
		this.scene.fogDensity = 0.025;
		this.scene.fogColor = DemoMain.BLACK.clone();
		this.scene.clearColor = DemoMain.WHITE.clone();
		this.camera.minZ = 0.01;
		var _g6 = 0;
		var _g12 = this.balls;
		while(_g6 < _g12.length) {
			var b1 = _g12[_g6];
			++_g6;
		}
		this.glowCube = BABYLON.MeshBuilder.CreateSphere("box",{ diameter : 145, sideOrientation : BABYLON.Mesh.DOUBLESIDE},null);
		var glowMat = new BABYLON.StandardMaterial("",null);
		glowMat.diffuseColor = DemoMain.BLACK.clone();
		glowMat.ambientColor = DemoMain.BLACK.clone();
		glowMat.emissiveColor = DemoMain.BLACK.clone().scale(0.000);
		this.glowCube.material = glowMat;
		this.scene.addMesh(this.glowCube);
		this.scene.ambientColor = DemoMain.WHITE.clone();
		var rpProp = { };
		rpProp.bloom = true;
		rpProp.chromaticAberration = true;
		rpProp.distort = true;
		rpProp.dof = true;
		rpProp.grain = true;
		rpProp.imageProcessing = true;
		rpProp.sharpen = false;
		rpProp.fxaa = false;
		rpProp.displacement = false;
		this.initPipeline(rpProp);
		this.post.distort.lineHeight = wl_core_Config.RESOLUTION[1] / 50;
		this.post.grain.intensity = 10;
		this.post.grain.animated = true;
		this.post.bloom.bloomThreshold = 0.9;
		this.post.chromaticAberration.aberrationAmount = 1;
		this.post.dof.focalLength = 80;
		this.post.dof.focusDistance = 4000;
		this.post.imageProcessing.vignetteEnabled = true;
		this.camera.fov = 1.4;
		this.camera.position.x = -w / 4.2;
		this.camera.position.y = -h / 4.2;
		this.camera.position.z = -d / 4.2;
		this.camera.setTarget(new BABYLON.Vector3());
		this.addTrigger(new wl_core_TimeSig(-1,-1,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.onBar));
		var tmp = wl_util_Random.nextFloat() - 0.5;
		this.light.direction.x = tmp * 3;
		var tmp1 = wl_util_Random.nextFloat() - 0.5;
		this.light.direction.y = tmp1 * 3;
		var tmp2 = wl_util_Random.nextFloat() - 0.5;
		this.light.direction.z = tmp2 * 3;
		var tmp3 = wl_util_Random.nextFloat() - 0.5;
		this.light2.direction.x = tmp3 * 3;
		var tmp4 = wl_util_Random.nextFloat() - 0.5;
		this.light2.direction.y = tmp4 * 3;
		var tmp5 = wl_util_Random.nextFloat() - 0.5;
		this.light2.direction.z = tmp5 * 3;
		this.rndcc = new wl_demo_RandomCameraController(this.camera,8,[],97678,[wl_demo_CameraController.LINEAR],[0,5],new BABYLON.BoundingBox(new BABYLON.Vector3(0.01,0.01,0.01),new BABYLON.Vector3(2.3,2.3,2.3)));
		this.rndcc2 = new wl_demo_RandomCameraController(this.camera,8,[],4627,[wl_demo_CameraController.BEZIER],[7,30],new BABYLON.BoundingBox(new BABYLON.Vector3(-10,-10,5.0),new BABYLON.Vector3(10,10,8)));
		this.rndcc3 = new wl_demo_RandomCameraController(this.camera,8,[],246,[wl_demo_CameraController.BEZIER],[7,30],new BABYLON.BoundingBox(new BABYLON.Vector3(-10,-10,7.0),new BABYLON.Vector3(10,10,12)));
		var _g7 = 0;
		var _g13 = this.rndcc.ccs;
		while(_g7 < _g13.length) {
			var cc = _g13[_g7];
			++_g7;
			cc.updateLook = false;
		}
		this.ccs = [new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera)];
		this.ccs[0].initBezier([new BABYLON.Vector3(7,0,-2),new BABYLON.Vector3(5,0,2.5)],[new BABYLON.Vector3(0,0,0),new BABYLON.Vector3(0,0,2)]);
		this.ccs[1].initBezier([new BABYLON.Vector3(15,0,0),new BABYLON.Vector3(10,0,0)],[new BABYLON.Vector3(0,0,0),new BABYLON.Vector3(0,0,0)]);
		this.ccs[2].initBezier([new BABYLON.Vector3(15,0,0),new BABYLON.Vector3(10,0,0)],[new BABYLON.Vector3(0,0,0),new BABYLON.Vector3(0,0,0)]);
		this.ccs[3].initBezier([new BABYLON.Vector3(15,0,0),new BABYLON.Vector3(10,0,0)],[new BABYLON.Vector3(0,0,0),new BABYLON.Vector3(0,0,0)]);
	}
	,onBar: function(ts) {
		if(ts.beat % 2 == 0) {
			if(ts.beat == 0) {
				this.rndcc.swap();
				this.rndcc2.swap();
				this.rndcc3.swap();
				this.camera.setTarget(new BABYLON.Vector3(wl_util_Random.nextFloat(),wl_util_Random.nextFloat(),wl_util_Random.nextFloat()));
			}
			var tmp = wl_util_Random.nextFloat() - 0.5;
			this.light.direction.x = tmp * 3;
			var tmp1 = wl_util_Random.nextFloat() - 0.5;
			this.light.direction.y = tmp1 * 3;
			var tmp2 = wl_util_Random.nextFloat() - 0.5;
			this.light.direction.z = tmp2 * 3;
			var tmp3 = wl_util_Random.nextFloat() - 0.5;
			this.light2.direction.x = tmp3 * 3;
			var tmp4 = wl_util_Random.nextFloat() - 0.5;
			this.light2.direction.y = tmp4 * 3;
			var tmp5 = wl_util_Random.nextFloat() - 0.5;
			this.light2.direction.z = tmp5 * 3;
			var nc1 = new BABYLON.Vector3(this.light.direction.x + (wl_util_Random.nextFloat() - 0.5) * 0.25,this.light.direction.y + (wl_util_Random.nextFloat() - 0.5) * 0.25,this.light.direction.z + (wl_util_Random.nextFloat() - 0.5) * 0.25);
			var nc2 = new BABYLON.Vector3(this.light2.direction.x + (wl_util_Random.nextFloat() - 0.5) * 0.25,this.light2.direction.y + (wl_util_Random.nextFloat() - 0.5) * 0.25,this.light2.direction.z + (wl_util_Random.nextFloat() - 0.5) * 0.25);
			createjs.Tween.get(this.light.direction).to({ x : nc1.x, y : nc1.y, z : nc1.z},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.quadInOut);
			createjs.Tween.get(this.light2.direction).to({ x : nc2.x, y : nc2.y, z : nc2.z},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.quadInOut);
			var _g = 0;
			var _g1 = this.cubesX;
			while(_g < _g1.length) {
				var b = _g1[_g];
				++_g;
				createjs.Tween.get(b.scaling).to({ x : b.levels[Math.min(b.levels.length,b.level++)]},wl_core_TimeSig.milliseconds(0,1,0,0));
			}
			var _g2 = 0;
			var _g11 = this.cubesY;
			while(_g2 < _g11.length) {
				var b1 = _g11[_g2];
				++_g2;
				createjs.Tween.get(b1.scaling).to({ y : b1.levels[Math.min(b1.levels.length,b1.level++)]},wl_core_TimeSig.milliseconds(0,1,0,0));
			}
			var _g3 = 0;
			var _g12 = this.cubesZ;
			while(_g3 < _g12.length) {
				var b2 = _g12[_g3];
				++_g3;
				createjs.Tween.get(b2.scaling).to({ z : b2.levels[Math.min(b2.levels.length,b2.level++)]},wl_core_TimeSig.milliseconds(0,1,0,0));
			}
			this.ambientAmount = 1;
			this.updateAmbient();
			var tmp6 = createjs.Tween.get(this,{ onChange : $bind(this,this.updateAmbient)}).wait(wl_core_TimeSig.milliseconds(0,1,0,0));
			var tmp7 = wl_core_TimeSig.milliseconds(0,1,0,0);
			tmp6.to({ ambientAmount : 0.5},tmp7,createjs.Ease.quadOut);
		}
	}
	,updateAmbient: function() {
		var intensity = createjs.Ease.quadOut(this.ambientAmount);
		var tmp = DemoMain.WHITE.clone();
		this.glowCube.material.emissiveColor = tmp.scale(intensity * 0.05);
		var tmp1 = createjs.Ease.quadOut(this.ambientAmount);
		this.scene.ambientColor.r = tmp1 * 0.0;
		var tmp2 = createjs.Ease.quadOut(this.ambientAmount);
		this.scene.ambientColor.g = tmp2 * 0.0;
		var tmp3 = createjs.Ease.quadOut(this.ambientAmount);
		this.scene.ambientColor.b = tmp3 * 0.0;
		this.light.intensity = intensity;
		this.light2.intensity = intensity;
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		this.startedBar = ts.bar;
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		if(ts.bar - this.startedBar < 8) {
			if(ts.bar % 2 == 0) {
				this.rndcc.updateLength(wl_core_TimeSig.milliseconds(2,0,0,0));
			} else {
				this.rndcc2.updateLength(wl_core_TimeSig.milliseconds(2,0,0,0));
			}
		} else {
			this.rndcc3.updateLength(wl_core_TimeSig.milliseconds(2,0,0,0));
		}
		this.analyzer.update();
		this.post.grain.intensity = this.lowFilter.max * 30 + 5;
		this.post.chromaticAberration.aberrationAmount = this.mediumFilter.max < 0.8 ? 0 : (this.mediumFilter.max - 0.8) * 120;
		this.post.bloom.bloomWeight = this.lowFilter.max * 2;
		this.post.imageProcessing.vignetteWeight = this.lowFilter.max;
		this.post.distort.intensity = this.mediumFilter.max < 0.8 ? 0 : (this.mediumFilter.max - 0.9) * 0.04;
		this.post.distort.intensityY = this.highFilter.max < 0.5 ? 0 : (this.highFilter.max - 0.5) * 0.03;
		this.post.imageProcessing.exposure = Math.min(1.100,0.7 + Math.max(0,this.lowFilter.min - 0.8) * 2.5);
		this.post.imageProcessing.exposure = 0.9;
		this.post.imageProcessing.contrast = 1.9 + this.lowFilter.max;
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: whiteroom_WhiteRoom
});
var wl_core_Assets = $hx_exports["kvg"]["core"]["assets"] = function() {
};
$hxClasses["wl.core.Assets"] = wl_core_Assets;
wl_core_Assets.__name__ = ["wl","core","Assets"];
wl_core_Assets.register = function(id,type,data,compressed) {
	if(compressed) {
		throw new js__$Boot_HaxeError("Compression not implemented.");
	}
	if(type == "png" || type == "jpg") {
		var img = new Image();
		img.src = "data:image/" + (type == "jpg" ? "jpeg" : type) + ";base64," + data;
		var _this = wl_core_Assets._assets;
		if(__map_reserved[id] != null) {
			_this.setReserved(id,img);
		} else {
			_this.h[id] = img;
		}
	} else if(type == "mp3" || type == "ogg") {
		var _this1 = wl_core_Assets._assets;
		if(__map_reserved[id] != null) {
			_this1.setReserved(id,data);
		} else {
			_this1.h[id] = data;
		}
	} else if(type == "json") {
		var _this2 = wl_core_Assets._assets;
		var value = JSON.parse(data);
		if(__map_reserved[id] != null) {
			_this2.setReserved(id,value);
		} else {
			_this2.h[id] = value;
		}
	} else if(type == "object") {
		var _this3 = wl_core_Assets._assets;
		if(__map_reserved[id] != null) {
			_this3.setReserved(id,data);
		} else {
			_this3.h[id] = data;
		}
	}
};
wl_core_Assets.get = function(id) {
	var _this = wl_core_Assets._assets;
	if(!(__map_reserved[id] != null ? _this.existsReserved(id) : _this.h.hasOwnProperty(id))) {
		console.log("Asset " + id + " not found");
	}
	var _this1 = wl_core_Assets._assets;
	if(__map_reserved[id] != null) {
		return _this1.getReserved(id);
	} else {
		return _this1.h[id];
	}
};
wl_core_Assets.getTexture = function(id) {
	var img = wl_core_Assets.get(id);
	if(img == null) {
		throw new js__$Boot_HaxeError("Texture " + id + " not found.");
	}
	var tex = new BABYLON.Texture(img.src,null);
	return tex;
};
wl_core_Assets.prototype = {
	__class__: wl_core_Assets
};
var wl_core_Config = $hx_exports["wl"]["Config"] = function() {
	throw new js__$Boot_HaxeError("Config is static only.");
};
$hxClasses["wl.core.Config"] = wl_core_Config;
wl_core_Config.__name__ = ["wl","core","Config"];
wl_core_Config.prototype = {
	__class__: wl_core_Config
};
var wl_core_Demo = $hx_exports["Demo"] = function() {
	this.waitingFirstFrame = true;
	this.allowUpdate = false;
	this.previousUpdate = 0;
	this.partMap = new haxe_ds_StringMap();
	wl_core_Demo.instance = this;
};
$hxClasses["wl.core.Demo"] = wl_core_Demo;
wl_core_Demo.__name__ = ["wl","core","Demo"];
wl_core_Demo.prototype = {
	getPart: function(name) {
		var _this = this.partMap;
		if(__map_reserved[name] != null) {
			return _this.getReserved(name);
		} else {
			return _this.h[name];
		}
	}
	,getParts: function() {
		return this.parts;
	}
	,init: function(container,callback) {
		var _gthis = this;
		this.onUpdate = new wl_core_Signal();
		wl_util_Random.init(wl_core_Config.SEED);
		this.graphics = new wl_core_Graphics(container);
		wl_sounds_SoundWL.onSoundComplete.connect($bind(this,this.onSoundEnd));
		container.appendChild(this.graphics.canvas);
		haxe_Timer.delay(function() {
			_gthis.previousTS = wl_core_TimeSig.create(0);
			_gthis.graphics.onRender.connect($bind(_gthis,_gthis.onRender));
			_gthis.initializeParts();
			if(wl_core_Config.DEBUG) {
				_gthis.initializeDebug();
			}
			createjs.Ticker.setPaused(true);
			_gthis.initDemoComposer();
			callback();
		},100);
	}
	,initDemoComposer: function() {
	}
	,onSoundEnd: function() {
		this.end();
	}
	,initializeDebug: function() {
		wl_debug_Debug.init(this);
		wl_debug_ManualControl.init();
		this.graphics.canvas.classList.add("debugCanvas");
	}
	,initializeParts: function() {
		this.parts = [];
		var _g = 0;
		var _g1 = wl_core_Config.TIMELINE;
		while(_g < _g1.length) {
			var tl = _g1[_g];
			++_g;
			var id;
			if(tl.partId == null) {
				var o = tl.part;
				id = Type.getClassName(o == null ? null : js_Boot.getClass(o));
			} else {
				id = tl.partId;
			}
			tl.part.name = id;
			var _this = this.partMap;
			var key = tl.partId;
			console.log(tl.partId + " exists in partmap? " + Std.string(__map_reserved[key] != null ? _this.existsReserved(key) : _this.h.hasOwnProperty(key)) + " force new part is false? " + (tl.forceNewPart == null ? "null" : "" + tl.forceNewPart));
			var tmp;
			var _this1 = this.partMap;
			var key1 = tl.partId;
			if(__map_reserved[key1] != null ? _this1.existsReserved(key1) : _this1.h.hasOwnProperty(key1)) {
				tmp = !tl.forceNewPart;
			} else {
				tmp = false;
			}
			if(tmp) {
				var _this2 = this.partMap;
				var key2 = tl.partId;
				tl.part = __map_reserved[key2] != null ? _this2.getReserved(key2) : _this2.h[key2];
				tl.part.multiPart = true;
			} else {
				var _this3 = this.partMap;
				var key3 = tl.partId;
				var value = tl.part;
				if(__map_reserved[key3] != null) {
					_this3.setReserved(key3,value);
				} else {
					_this3.h[key3] = value;
				}
				this.parts.push(tl.part);
			}
		}
		var _g2 = 0;
		var _g11 = this.parts;
		while(_g2 < _g11.length) {
			var part = _g11[_g2];
			++_g2;
			part.init();
		}
		console.log(this.parts);
		var _g3 = 0;
		var _g12 = this.parts;
		while(_g3 < _g12.length) {
			var part1 = _g12[_g3];
			++_g3;
			part1.render(this.previousTS,0);
		}
		var _g4 = 0;
		var _g13 = this.parts;
		while(_g4 < _g13.length) {
			var part2 = _g13[_g4];
			++_g4;
			part2.postInit();
		}
	}
	,start: function() {
		var _gthis = this;
		this.previousRts = this.parts[0];
		this.graphics.start();
		haxe_Timer.delay(function() {
			wl_sounds_SoundWL.start();
			_gthis.allowUpdate = true;
			_gthis.waitingFirstFrame = false;
			console.log("allow upds.");
		},400);
		haxe_Timer.delay(function() {
			_gthis.parts[0].update(new wl_core_TimeSig(0),0,10,10);
			_gthis.parts[0].setRenderToScreen(true);
			_gthis.parts[0].render(new wl_core_TimeSig(0),10);
			_gthis.onRender(0);
		},40);
	}
	,end: function() {
		this.graphics.stop();
	}
	,onRender: function(time) {
		createjs.Tween.tick(time,false);
		var rts = null;
		var _g = 0;
		var _g1 = this.parts;
		while(_g < _g1.length) {
			var p = _g1[_g];
			++_g;
			if(p.inTransition) {
				p.render(this.previousTS,time,false);
			} else if(p.running) {
				if(rts == null && p.renderToScreen) {
					rts = p;
				} else {
					p.render(this.previousTS,time,false);
				}
			}
		}
		if(rts == null) {
			rts = this.previousRts;
		}
		if(rts != null) {
			this.previousRts = rts;
			rts.render(this.previousTS,time,true);
		}
		if(wl_core_Config.DEBUG) {
			wl_debug_Debug.onrender();
		}
		if(this.allowUpdate) {
			this.update();
		}
	}
	,update: function() {
		var ts = wl_sounds_SoundWL.getPosition();
		var ms = ts.toMilliseconds();
		var frameTime = ms - this.previousUpdate;
		var delta = frameTime / 16.666666666666668;
		this.previousUpdate = ms;
		if(delta == 0) {
			return;
		}
		var _g1 = 0;
		var _g = wl_core_Config.TIMELINE.length;
		while(_g1 < _g) {
			var i = _g1++;
			var tl = wl_core_Config.TIMELINE[i];
			if(ts.isInside(tl.runOn,tl.runOff)) {
				var p = tl.part;
				p.timeline = tl;
				var inTransition = ts.isInside(tl.runOn,tl.rtsOn) || ts.isInside(tl.rtsOff,tl.runOff);
				p.setRenderToScreen(tl.renderToScreen && !inTransition);
				if(!p.running) {
					p.start(ts);
				}
				p.isActive = true;
			}
		}
		DemoMain.update(ts,0,wl_debug_Debug.paused ? 0 : frameTime,delta);
		var _g2 = 0;
		var _g11 = this.parts;
		while(_g2 < _g11.length) {
			var p1 = _g11[_g2];
			++_g2;
			if(p1.isActive) {
				var timespan = p1.timeline.runOff.toMilliseconds() - p1.timeline.runOn.toMilliseconds();
				var partial = (ts.toMilliseconds() - p1.timeline.runOn.toMilliseconds()) / timespan;
				p1.update(ts,partial,wl_debug_Debug.paused ? 0 : frameTime,delta);
			} else if(p1.running) {
				p1.stop();
			}
			p1.isActive = false;
		}
		while(this.previousTS.isSmallerThan(ts)) {
			var _g3 = 0;
			var _g12 = this.parts;
			while(_g3 < _g12.length) {
				var p2 = _g12[_g3];
				++_g3;
				if(p2.running) {
					var key = p2.triggers.keys();
					while(key.hasNext()) {
						var key1 = key.next();
						var matches = key1.matchesPattern(this.previousTS,p2.timeline.runOn);
						if(matches && !key1.triggered) {
							var triggers = p2.triggers.h[key1.__id__];
							key1.triggered = true;
							var _g21 = 0;
							while(_g21 < triggers.length) {
								var toCall = triggers[_g21];
								++_g21;
								toCall(this.previousTS);
							}
						} else if(!matches) {
							key1.triggered = false;
						}
					}
				}
			}
			this.previousTS.addTicks(1);
		}
		this.onUpdate.emit(ts);
		if(wl_core_Config.DEBUG) {
			wl_debug_Debug.onupdate();
		}
	}
	,__class__: wl_core_Demo
};
var wl_core_Graphics = function(container) {
	this.last = 0;
	this.stopped = true;
	this.container = container;
	if(wl_core_Graphics.instance == null) {
		wl_core_Graphics.instance = this;
	} else {
		console.log("Creating multiple Graphics instances. Are you sure?");
	}
	this.initGraphics();
};
$hxClasses["wl.core.Graphics"] = wl_core_Graphics;
wl_core_Graphics.__name__ = ["wl","core","Graphics"];
wl_core_Graphics.prototype = {
	initGraphics: function() {
		this.onRender = new wl_core_Signal();
		this.interval = 1000 / wl_core_Config.FPS;
		this.canvas = window.document.createElement("canvas");
		this.canvas.id = "demoCanvas";
		var eo = { };
		this.renderer = new BABYLON.Engine(this.canvas,true,eo);
		this.canvas.width = wl_core_Config.RESOLUTION[0];
		this.canvas.height = wl_core_Config.RESOLUTION[1];
		console.log("Using webgl version: " + this.renderer.webGLVersion);
	}
	,start: function() {
		this.last = 0;
		this.stopped = false;
		this.renderLoop(0);
	}
	,stop: function() {
		this.stopped = true;
	}
	,renderLoop: function(time) {
		var now = time;
		this.delta = now - this.last;
		if(wl_core_Config.FPS < 0 || this.delta >= this.interval) {
			this.last = now;
			this.renderer.beginFrame();
			this.onRender.emit(this.delta);
			this.renderer.endFrame();
		}
		if(!this.stopped) {
			window.requestAnimationFrame($bind(this,this.renderLoop));
		}
	}
	,__class__: wl_core_Graphics
};
var wl_core_TimeSig = $hx_exports["wl"]["TimeSig"] = function(bar,beat,tick,delay,pattern) {
	this.triggered = false;
	this.delay = 0;
	this.set_bar(bar == null ? 0 : bar);
	this.set_beat(beat == null ? 0 : beat);
	this.set_tick(tick == null ? 0 : tick);
	this.delay = delay == null ? 0 : delay;
	this.pattern = pattern == null ? wl_core_TimeSig.ABSOLUTE : pattern;
};
$hxClasses["wl.core.TimeSig"] = wl_core_TimeSig;
wl_core_TimeSig.__name__ = ["wl","core","TimeSig"];
wl_core_TimeSig.create = function(time) {
	return new wl_core_TimeSig().fromTime(time);
};
wl_core_TimeSig.milliseconds = function(bar,beat,tick,delay) {
	var tickTime = 60000 / wl_core_Config.BEATS_PER_MINUTE / wl_core_Config.TICKS_PER_BEAT;
	return (bar * wl_core_Config.BEATS_PER_BAR / wl_core_Config.BEATS_PER_MINUTE + beat / wl_core_Config.BEATS_PER_MINUTE + tick / wl_core_Config.TICKS_PER_BEAT / wl_core_Config.BEATS_PER_MINUTE) * 60 * 1000 + Math.floor(delay / 255 * tickTime);
};
wl_core_TimeSig.Zero = function() {
	return new wl_core_TimeSig(0,0,0,0,wl_core_TimeSig.RELATIVE);
};
wl_core_TimeSig.prototype = {
	set_beat: function(value) {
		this.beat = value;
		this.adjust();
		return this.beat;
	}
	,set_bar: function(value) {
		this.bar = value;
		this.adjust();
		return this.bar;
	}
	,set_tick: function(value) {
		this.tick = value;
		this.adjust();
		return this.tick;
	}
	,adjust: function() {
	}
	,matchesPattern: function(time,begin) {
		if(this.pattern == wl_core_TimeSig.ABSOLUTE) {
			return this.equals(time);
		} else if(this.pattern == wl_core_TimeSig.RELATIVE) {
			if(time.bar == begin.bar + this.bar && time.beat == begin.beat + this.beat) {
				return time.tick == begin.tick + this.tick;
			} else {
				return false;
			}
		} else if(this.pattern == wl_core_TimeSig.PATTERN) {
			if((this.bar == -1 || time.bar % this.bar == 0) && (this.beat == -1 || time.beat % wl_core_Config.BEATS_PER_BAR == this.beat)) {
				if(this.tick != -1) {
					return time.tick % wl_core_Config.TICKS_PER_BEAT == this.tick;
				} else {
					return true;
				}
			} else {
				return false;
			}
		}
		return false;
	}
	,add: function(ts) {
		this.addBars(ts.bar);
		this.addBeats(ts.beat);
		this.addTicks(ts.tick);
	}
	,addBars: function(bars) {
		var _g = this;
		_g.set_bar(_g.bar + bars);
	}
	,addBeats: function(beats) {
		var _g = this;
		_g.set_beat(_g.beat + beats);
		var _g1 = this;
		_g1.set_bar(_g1.bar + Math.floor(this.beat / wl_core_Config.BEATS_PER_BAR));
		var _g2 = this;
		_g2.set_beat(_g2.beat % wl_core_Config.BEATS_PER_BAR);
	}
	,addTicks: function(ticks) {
		var _g = this;
		_g.set_tick(_g.tick + ticks);
		while(this.tick >= wl_core_Config.TICKS_PER_BEAT) {
			var _g1 = this;
			_g1.set_tick(_g1.tick - wl_core_Config.TICKS_PER_BEAT);
			var _g2 = this;
			var _g11 = _g2.beat;
			_g2.set_beat(_g11 + 1);
		}
		while(this.beat >= wl_core_Config.BEATS_PER_BAR) {
			var _g3 = this;
			_g3.set_beat(_g3.beat - wl_core_Config.BEATS_PER_BAR);
			var _g4 = this;
			var _g12 = _g4.bar;
			_g4.set_bar(_g12 + 1);
		}
	}
	,subtract: function(ts) {
		this.subtractBars(ts.bar);
		this.subtractBeats(ts.beat);
		this.subtractTicks(ts.tick);
	}
	,subtractBars: function(bars) {
		var _g = this;
		_g.set_bar(_g.bar - bars);
	}
	,subtractBeats: function(beats) {
		var _g = this;
		_g.set_beat(_g.beat - beats);
		while(this.beat < 0) {
			var _g1 = this;
			var _g11 = _g1.bar;
			_g1.set_bar(_g11 - 1);
			var _g2 = this;
			_g2.set_beat(_g2.beat + wl_core_Config.BEATS_PER_BAR);
		}
	}
	,subtractTicks: function(ticks) {
		var _g = this;
		_g.set_tick(_g.tick - ticks);
		while(this.tick < 0) {
			var _g1 = this;
			_g1.set_tick(_g1.tick + wl_core_Config.TICKS_PER_BEAT);
			var _g2 = this;
			var _g11 = _g2.beat;
			_g2.set_beat(_g11 - 1);
		}
		while(this.beat < 0) {
			var _g3 = this;
			var _g12 = _g3.bar;
			_g3.set_bar(_g12 - 1);
			var _g4 = this;
			_g4.set_beat(_g4.beat + wl_core_Config.BEATS_PER_BAR);
		}
	}
	,fromTime: function(time) {
		var totalBeats = wl_core_Config.BEATS_PER_MINUTE * time;
		var comp = time < 0 ? Math.ceil : Math.floor;
		this.set_bar(comp(totalBeats / wl_core_Config.BEATS_PER_BAR));
		this.set_beat(comp(totalBeats % wl_core_Config.BEATS_PER_BAR));
		this.set_tick(comp((totalBeats - comp(totalBeats)) * wl_core_Config.TICKS_PER_BEAT));
		this.delay = 0;
		var offset = time * 60 * 1000 - this.toMilliseconds();
		var tickTime = 60000 / wl_core_Config.BEATS_PER_MINUTE / wl_core_Config.TICKS_PER_BEAT;
		this.delay = Math.floor(255 * offset / tickTime % 255);
		return this;
	}
	,isInside: function(begin,end) {
		if(this.isSmallerThan(end)) {
			return this.isLargerThan(begin);
		} else {
			return false;
		}
	}
	,isInsideFloat: function(begin,end) {
		if(this.toMilliseconds() >= begin) {
			return this.toMilliseconds() <= end;
		} else {
			return false;
		}
	}
	,isSmallerThan: function(other) {
		var ticks = this.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + this.beat * wl_core_Config.TICKS_PER_BEAT + this.tick;
		var tickso = other.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + other.beat * wl_core_Config.TICKS_PER_BEAT + other.tick;
		if(ticks >= tickso) {
			if(ticks == tickso) {
				return this.delay < other.delay;
			} else {
				return false;
			}
		} else {
			return true;
		}
	}
	,isLargerThan: function(other) {
		var ticks = this.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + this.beat * wl_core_Config.TICKS_PER_BEAT + this.tick;
		var tickso = other.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + other.beat * wl_core_Config.TICKS_PER_BEAT + other.tick;
		if(ticks <= tickso) {
			if(ticks == tickso) {
				return this.delay >= other.delay;
			} else {
				return false;
			}
		} else {
			return true;
		}
	}
	,toMilliseconds: function() {
		var tickTime = 60000 / wl_core_Config.BEATS_PER_MINUTE / wl_core_Config.TICKS_PER_BEAT;
		return (this.bar * wl_core_Config.BEATS_PER_BAR / wl_core_Config.BEATS_PER_MINUTE + this.beat / wl_core_Config.BEATS_PER_MINUTE + this.tick / wl_core_Config.TICKS_PER_BEAT / wl_core_Config.BEATS_PER_MINUTE) * 60 * 1000 + Math.floor(this.delay / 255 * tickTime);
	}
	,equals: function(other) {
		var ticks = this.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + this.beat * wl_core_Config.TICKS_PER_BEAT + this.tick;
		var tickso = other.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + other.beat * wl_core_Config.TICKS_PER_BEAT + other.tick;
		return ticks == tickso;
	}
	,clone: function() {
		return new wl_core_TimeSig(this.bar,this.beat,this.tick,this.delay,this.pattern);
	}
	,toString: function(full) {
		return this.bar + ":" + this.beat + ":" + this.tick + (full ? " / " + this.delay + "\n[" + this.pattern + "]" : "");
	}
	,__class__: wl_core_TimeSig
};
var wl_debug_CustomCameraControl = function() {
	this.availableKeys = [];
	this.keysDown = [];
	this.shift = 16;
	this.down = 70;
	this.up = 82;
	this.right = 68;
	this.left = 65;
	this.backward = 83;
	this.forward = 87;
	this.availableKeys = [this.forward,this.backward,this.left,this.right,this.up,this.down,this.shift];
};
$hxClasses["wl.debug.CustomCameraControl"] = wl_debug_CustomCameraControl;
wl_debug_CustomCameraControl.__name__ = ["wl","debug","CustomCameraControl"];
wl_debug_CustomCameraControl.__interfaces__ = [BABYLON_ICameraInput];
wl_debug_CustomCameraControl.prototype = {
	getClassName: function() {
		return "CustomCameraController";
	}
	,getSimpleName: function() {
		return "CustomCameraController";
	}
	,attachControl: function(element,noPreventDefault) {
		var _gthis = this;
		if(this.onCanvasBlurObserver != null) {
			return;
		}
		console.log(noPreventDefault);
		this.scene = this.camera.getScene();
		this.engine = this.scene.getEngine();
		this.onCanvasBlurObserver = this.engine.onCanvasBlurObservable.add(function(engine,eventState) {
			_gthis.keysDown = [];
		});
		this.onKeyboardObserver = this.scene.onKeyboardObservable.add(function(info,eventState1) {
			var evt = info.event;
			if(info.type == BABYLON.KeyboardEventTypes.KEYDOWN) {
				if(_gthis.availableKeys.indexOf(evt.keyCode) == -1) {
					return;
				}
				if(_gthis.shift == evt.keyCode) {
					_gthis.shiftDown = true;
				} else if(_gthis.keysDown.indexOf(evt.keyCode) == -1) {
					_gthis.keysDown.push(evt.keyCode);
				}
			} else {
				if(_gthis.shift == evt.keyCode) {
					_gthis.shiftDown = false;
				}
				var index = _gthis.keysDown.indexOf(evt.keyCode);
				if(index >= 0) {
					_gthis.keysDown.splice(index,1);
				}
			}
		});
	}
	,detachControl: function(element) {
		console.log("detach");
		if(this.scene != null) {
			if(this.onKeyboardObserver != null) {
				this.scene.onKeyboardObservable.remove(this.onKeyboardObserver);
			}
		}
		if(this.engine != null) {
			if(this.onCanvasBlurObserver != null) {
				this.engine.onCanvasBlurObservable.remove(this.onCanvasBlurObserver);
			}
		}
		this.keysDown = [];
		this.onCanvasBlurObserver = null;
		this.onKeyboardObserver = null;
	}
	,checkInputs: function() {
		if(this.onKeyboardObserver != null) {
			var _g1 = 0;
			var _g = this.keysDown.length;
			while(_g1 < _g) {
				var index = _g1++;
				var keyCode = this.keysDown[index];
				var speed = this.camera._computeLocalCameraSpeed();
				if(this.shiftDown) {
					speed /= 10.0;
				}
				if(this.left == keyCode) {
					this.camera._localDirection.copyFromFloats(-speed,0,0);
				} else if(this.forward == keyCode) {
					this.camera._localDirection.copyFromFloats(0,0,speed);
				} else if(this.right == keyCode) {
					this.camera._localDirection.copyFromFloats(speed,0,0);
				} else if(this.backward == keyCode) {
					this.camera._localDirection.copyFromFloats(0,0,-speed);
				} else if(this.up == keyCode) {
					this.camera._localDirection.copyFromFloats(0,speed,0);
				} else if(this.down == keyCode) {
					this.camera._localDirection.copyFromFloats(0,-speed,0);
				}
				if(this.camera.getScene().useRightHandedSystem) {
					this.camera._localDirection.z *= -1;
				}
				this.camera.getViewMatrix().invertToRef(this.camera._cameraTransformMatrix);
				BABYLON.Vector3.TransformNormalToRef(this.camera._localDirection,this.camera._cameraTransformMatrix,this.camera._transformedDirection);
				this.camera.cameraDirection.addInPlace(this.camera._transformedDirection);
			}
		}
	}
	,_onLostFocus: function(e) {
		this.keysDown = [];
	}
	,__class__: wl_debug_CustomCameraControl
};
var wl_debug_Debug = function() {
};
$hxClasses["wl.debug.Debug"] = wl_debug_Debug;
wl_debug_Debug.__name__ = ["wl","debug","Debug"];
wl_debug_Debug.init = function(demo) {
	wl_debug_Debug.gui = new dat.gui.GUI();
	window.document.addEventListener("keydown",wl_debug_Debug.onKeyDown);
	wl_debug_Debug.debugDiv = $(".debug");
	wl_debug_Debug.debugTimeSig = wl_debug_Debug.debugDiv.find("#debug_timesig");
	var tldiv = wl_debug_Debug.debugDiv.find("#timeline_parts");
	var _g = 0;
	var _g1 = wl_core_Config.TIMELINE;
	while(_g < _g1.length) {
		var tl = _g1[_g];
		++_g;
		var tlel = $("<li>" + Std.string(tl) + "</li>");
		tldiv.append(tlel);
		tlel.click(wl_debug_Debug.tlClick(tl));
		wl_debug_Debug.datGuiPart(tl.part);
	}
	wl_debug_Debug.stats = new Stats();
	wl_debug_Debug.stats.showPanel(1);
	wl_debug_Debug.stats.dom.style.position = "absolute";
	wl_debug_Debug.stats.dom.style.bottom = "0px";
	wl_debug_Debug.stats.dom.style.top = null;
	wl_debug_Debug.debugDiv.eq(0).append(wl_debug_Debug.stats.dom);
	wl_debug_Debug.stats.begin();
	wl_debug_Debug.attachObjectSelectorToParts(demo.getParts());
	wl_debug_Debug.editModeCb = wl_debug_Debug.debugDiv.find("#editMode");
	console.log(wl_debug_Debug.editModeCb);
	wl_debug_Debug.editModeCb.removeAttr("checked");
	wl_debug_Debug.editModeCb.change(function(eventData) {
		console.log("on change: " + JSON.stringify(eventData));
		wl_debug_Debug.editMode = eventData.target.checked;
		var _g2 = 0;
		var _g11 = wl_debug_Debug.objectModifiers;
		while(_g2 < _g11.length) {
			var ob = _g11[_g2];
			++_g2;
			if(wl_debug_Debug.editMode) {
				ob.activate();
			} else {
				ob.disable();
			}
			if(!wl_debug_Debug.editMode) {
				wl_debug_ManualControl.attachPart(ob.part);
			}
		}
	});
};
wl_debug_Debug.datGuiPart = function(part) {
	var name = part.name;
	while(wl_debug_Debug.usedFolderNames.indexOf(name) >= 0) name += ">";
	var folder = wl_debug_Debug.gui.addFolder(name);
	wl_debug_Debug.usedFolderNames.push(name);
	var composer = Reflect.field(part,"composer");
	if(composer != null) {
		var _g = 0;
		var _g1 = composer.passes;
		while(_g < _g1.length) {
			var pass = _g1[_g];
			++_g;
			if(pass.setupDatGui != null) {
				pass.setupDatGui(folder);
			}
		}
	}
	var occlusioncomposer = Reflect.field(part,"occlusionComposer");
	if(occlusioncomposer != null) {
		var _g2 = 0;
		var _g11 = occlusioncomposer.passes;
		while(_g2 < _g11.length) {
			var pass1 = _g11[_g2];
			++_g2;
			if(pass1.setupDatGui != null) {
				pass1.setupDatGui(folder);
			}
		}
	}
	part.setupDatGui(folder);
};
wl_debug_Debug.tlClick = function(tl) {
	return function() {
		var curtime = wl_sounds_SoundWL.instance.getPosition();
		var tlpos = tl.rtsOn.toMilliseconds();
		wl_sounds_SoundWL.instance.setPosition(tlpos);
		createjs.Tween.tick(Math.floor(tlpos - curtime),false);
		wl_core_Demo.instance.previousTS.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
	};
};
wl_debug_Debug.onupdate = function() {
	var ts = wl_sounds_SoundWL.getPosition();
	wl_debug_Debug.debugTimeSig.html(StringTools.replace(ts.toString(),"\n","<br/>") + "<br/>" + Math.round(ts.toMilliseconds() / 100) / 10 + "s");
};
wl_debug_Debug.onrender = function() {
	wl_debug_Debug.stats.update();
	wl_debug_ManualControl.update();
};
wl_debug_Debug.onKeyDown = function(e) {
	if(e.keyCode == 9) {
		if(wl_debug_Debug.editMode) {
			wl_debug_Debug.editModeCb.prop("checked",false).trigger("change");
		} else {
			wl_debug_Debug.editModeCb.prop("checked",true).trigger("change");
		}
		console.log(wl_debug_Debug.editModeCb);
		console.log(wl_debug_Debug.editMode);
		e.preventDefault();
	}
	if(e.keyCode == 90) {
		console.log("Time captured: " + Std.string(wl_core_Demo.instance.previousTS));
	}
	if(e.keyCode == 109 || e.keyCode == 188) {
		if(wl_sounds_SoundWL.instance != null) {
			wl_sounds_SoundWL.instance.setPosition(wl_sounds_SoundWL.instance.getPosition() - 5000);
			createjs.Tween.tick(-5000,false);
			wl_core_Demo.instance.previousTS.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
		}
	}
	if(e.keyCode == 107 || e.keyCode == 190) {
		if(wl_sounds_SoundWL.instance != null) {
			wl_sounds_SoundWL.instance.setPosition(wl_sounds_SoundWL.instance.getPosition() + 5000);
			createjs.Tween.tick(5000,false);
			wl_core_Demo.instance.previousTS.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
		}
	}
	if(e.keyCode == 32) {
		wl_debug_Debug.paused = !wl_debug_Debug.paused;
		wl_sounds_SoundWL.instance.paused = wl_debug_Debug.paused;
		createjs.Tween.removeAllTweens();
	}
};
wl_debug_Debug.attachObjectSelectorToParts = function(parts) {
	var _g = 0;
	while(_g < parts.length) {
		var part = parts[_g];
		++_g;
		wl_debug_Debug.objectModifiers.push(new wl_debug_ObjectModifier(part));
	}
};
wl_debug_Debug.prototype = {
	__class__: wl_debug_Debug
};
var wl_debug_ManualControl = function() {
	throw new js__$Boot_HaxeError("Manual control is static");
};
$hxClasses["wl.debug.ManualControl"] = wl_debug_ManualControl;
wl_debug_ManualControl.__name__ = ["wl","debug","ManualControl"];
wl_debug_ManualControl.init = function() {
	if(wl_debug_ManualControl.inited) {
		return;
	}
	wl_debug_ManualControl.inited = true;
};
wl_debug_ManualControl.onMouseDown = function(event) {
	console.log("mouse down");
};
wl_debug_ManualControl.onMouseUp = function(event) {
	console.log("Mouse up");
};
wl_debug_ManualControl.onKeyDown = function(event) {
};
wl_debug_ManualControl.update = function() {
};
wl_debug_ManualControl.attachPart = function(part) {
	if(!wl_core_Config.DEBUG) {
		return;
	}
	part.camera.attachControl(wl_core_Graphics.instance.canvas,true);
	part.camera.inputs.add(new wl_debug_CustomCameraControl());
};
wl_debug_ManualControl.prototype = {
	__class__: wl_debug_ManualControl
};
var wl_debug_ObjectModifier = function(part) {
	this.isActive = false;
	this.locked = false;
	console.log("register");
	this.part = part;
	this.scene = part.scene;
	this.gizmoManager = new BABYLON.GizmoManager(this.scene);
	this.scene.getEngine().getRenderingCanvas().addEventListener("pointerup",$bind(this,this.onPointerUp),false);
	this.scene.getEngine().getRenderingCanvas().addEventListener("keydown",$bind(this,this.onKeyDown),false);
	this.gizmoManager.boundingBoxGizmoEnabled = true;
	this.gizmoManager.usePointerToAttachGizmos = false;
	this.nullmesh = BABYLON.MeshBuilder.CreateBox("",{ },this.scene);
	this.nullmesh.isVisible = false;
	this.nullmesh.position.z = -500000;
};
$hxClasses["wl.debug.ObjectModifier"] = wl_debug_ObjectModifier;
wl_debug_ObjectModifier.__name__ = ["wl","debug","ObjectModifier"];
wl_debug_ObjectModifier.prototype = {
	activate: function() {
		this.isActive = true;
	}
	,disable: function() {
		this.isActive = false;
		this.gizmoManager.attachToMesh(this.nullmesh);
	}
	,onPointerUp: function(e) {
		if(!this.isActive) {
			return;
		}
		var pickInfo = this.scene.pick(this.scene.pointerX,this.scene.pointerY);
		if(pickInfo.hit && !this.locked) {
			console.log(pickInfo.pickedMesh);
			this.gizmoManager.attachToMesh(pickInfo.pickedMesh);
		}
	}
	,onKeyDown: function(e) {
		if(!this.isActive) {
			return;
		}
		if(e.key == "l") {
			this.locked = !this.locked;
		}
		if(e.key == "p") {
			this.resetGizmos();
			this.gizmoManager.positionGizmoEnabled = true;
		}
		if(e.key == "o") {
			this.resetGizmos();
			this.gizmoManager.rotationGizmoEnabled = true;
		}
		if(e.key == "i") {
			this.resetGizmos();
			this.gizmoManager.scaleGizmoEnabled = true;
		}
	}
	,resetGizmos: function() {
		this.gizmoManager.positionGizmoEnabled = false;
		this.gizmoManager.scaleGizmoEnabled = false;
		this.gizmoManager.rotationGizmoEnabled = false;
	}
	,__class__: wl_debug_ObjectModifier
};
var wl_debug_PostProcessSliders = function() {
};
$hxClasses["wl.debug.PostProcessSliders"] = wl_debug_PostProcessSliders;
wl_debug_PostProcessSliders.__name__ = ["wl","debug","PostProcessSliders"];
wl_debug_PostProcessSliders.applySliders = function(folder,pipeline) {
	wl_debug_PostProcessSliders.applyFXAA(folder.addFolder("FXAA"),pipeline);
	wl_debug_PostProcessSliders.applySharpen(folder.addFolder("Sharpen"),pipeline);
	wl_debug_PostProcessSliders.applyDoF(folder.addFolder("DoF"),pipeline);
	wl_debug_PostProcessSliders.applyBloom(folder.addFolder("Bloom"),pipeline);
	if(pipeline.imageProcessing != null) {
		wl_debug_PostProcessSliders.applyImageProcessing(folder.addFolder("ImageProcessing"),pipeline);
	}
	wl_debug_PostProcessSliders.applyChromaticAberration(folder.addFolder("ChromaticAberration"),pipeline);
	wl_debug_PostProcessSliders.applyGrain(folder.addFolder("Grain"),pipeline);
};
wl_debug_PostProcessSliders.applyFXAA = function(folder,pipeline) {
	folder.add(pipeline,"fxaaEnabled");
};
wl_debug_PostProcessSliders.applySharpen = function(folder,pipeline) {
	folder.add(pipeline,"sharpenEnabled");
	folder.add(pipeline.sharpen,"colorAmount");
	folder.add(pipeline.sharpen,"edgeAmount");
};
wl_debug_PostProcessSliders.applyDoF = function(folder,pipeline) {
	folder.add(pipeline,"depthOfFieldEnabled");
	folder.add(pipeline.depthOfField,"focalLength").min(0).max(200).step(1);
	folder.add(pipeline.depthOfField,"focusDistance").min(0).max(5000).step(0.1);
	folder.add(pipeline.depthOfField,"fStop").min(0).max(20).step(0.01);
	folder.add(pipeline.depthOfField,"lensSize").min(0).max(500).step(0.01);
	folder.add(pipeline,"depthOfFieldBlurLevel").min(0).max(2).step(1);
};
wl_debug_PostProcessSliders.applyBloom = function(folder,pipeline) {
	folder.add(pipeline,"bloomEnabled");
	folder.add(pipeline.bloom,"kernel");
	folder.add(pipeline.bloom,"bloomScale");
	folder.add(pipeline.bloom,"threshold");
	folder.add(pipeline.bloom,"weight");
};
wl_debug_PostProcessSliders.applyImageProcessing = function(folder,pipeline) {
	folder.add(pipeline,"imageProcessingEnabled");
	folder.add(pipeline.imageProcessing,"toneMappingEnabled");
	folder.add(pipeline.imageProcessing,"exposure").min(-5).max(5000).step(0.01);
	folder.add(pipeline.imageProcessing,"contrast").min(-5).max(5).step(0.01);
	folder.add(pipeline.imageProcessing,"vignetteEnabled");
	folder.add(pipeline.imageProcessing,"vignetteCentreX").min(-1).max(1).step(0.01);
	folder.add(pipeline.imageProcessing,"vignetteCentreY").min(-1).max(1).step(0.01);
	folder.addColor(pipeline.imageProcessing,"vignetteColor");
	folder.add(pipeline.imageProcessing,"vignetteStretch").min(0).max(1).step(0.01);
	folder.add(pipeline.imageProcessing,"vignetteWeight").min(0).max(20).step(0.01);
};
wl_debug_PostProcessSliders.applyChromaticAberration = function(folder,pipeline) {
	folder.add(pipeline,"chromaticAberrationEnabled");
	folder.add(pipeline.chromaticAberration,"aberrationAmount").min(0).max(100).step(0.01);
	folder.add(pipeline.chromaticAberration,"radialIntensity").min(-5).max(5).step(0.01);
	var dir = folder.addFolder("direction");
	dir.add(pipeline.chromaticAberration.direction,"x").min(-1).max(1).step(0.01);
	dir.add(pipeline.chromaticAberration.direction,"y").min(-1).max(1).step(0.01);
	var center = folder.addFolder("center position");
	center.add(pipeline.chromaticAberration.centerPosition,"x").min(-1).max(1).step(0.01);
	center.add(pipeline.chromaticAberration.centerPosition,"y").min(-1).max(1).step(0.01);
};
wl_debug_PostProcessSliders.applyGrain = function(folder,pipeline) {
	folder.add(pipeline,"grainEnabled");
	folder.add(pipeline.grain,"intensity").min(0).max(500).step(0.1);
	folder.add(pipeline.grain,"animated");
};
wl_debug_PostProcessSliders.prototype = {
	__class__: wl_debug_PostProcessSliders
};
var wl_demo_BoardItem = function(startTime,endTime,controller) {
	this.startTime = startTime;
	this.controller = controller;
	this.endTime = endTime;
};
$hxClasses["wl.demo.BoardItem"] = wl_demo_BoardItem;
wl_demo_BoardItem.__name__ = ["wl","demo","BoardItem"];
wl_demo_BoardItem.prototype = {
	Run: function(ts) {
		if(ts.isLargerThan(this.startTime) && ts.isSmallerThan(this.endTime)) {
			var timespan = this.endTime.toMilliseconds() - this.startTime.toMilliseconds();
			var phase = (ts.toMilliseconds() - this.startTime.toMilliseconds()) / timespan;
			this.controller.update(phase);
		}
	}
	,__class__: wl_demo_BoardItem
};
var wl_demo_IController = function() { };
$hxClasses["wl.demo.IController"] = wl_demo_IController;
wl_demo_IController.__name__ = ["wl","demo","IController"];
wl_demo_IController.prototype = {
	__class__: wl_demo_IController
};
var wl_demo_CameraController = function(camera) {
	this.ignoreStop = false;
	this.updateLook = true;
	this.updatePath = true;
	if(camera != null) {
		this.attachCamera(camera);
	}
};
$hxClasses["wl.demo.CameraController"] = wl_demo_CameraController;
wl_demo_CameraController.__name__ = ["wl","demo","CameraController"];
wl_demo_CameraController.__interfaces__ = [wl_demo_IController];
wl_demo_CameraController.stopAllControl = function() {
	wl_demo_CameraController.STOPPED = true;
};
wl_demo_CameraController.prototype = {
	attachCamera: function(camera) {
		this.camera = camera;
	}
	,set_mode: function(mode) {
		this.mode = mode;
		return mode;
	}
	,initStatic: function(position,lookAt) {
		this.position = position;
		this.lookAt = lookAt;
		this.set_mode(wl_demo_CameraController.STATIC);
	}
	,initFollow: function(target,followOffset,followLookOffset) {
		this.set_mode(wl_demo_CameraController.FOLLOW);
		this.follow = target;
		this.followOffset = followOffset == null ? new BABYLON.Vector3(0,0,0) : followOffset;
		this.followLookOffset = followLookOffset == null ? new BABYLON.Vector3(0,0,0) : followLookOffset;
	}
	,initLinear: function(points,lookAts) {
		this.set_mode(wl_demo_CameraController.LINEAR);
		this.points = points;
		this.lookAts = lookAts;
	}
	,initBezier: function(points,lookAts) {
		this.set_mode(wl_demo_CameraController.BEZIER);
		this.points = points;
		this.lookAts = lookAts;
		this.path = BABYLON.Curve3.CreateCatmullRomSpline(points,2000);
		this.lookPath = BABYLON.Curve3.CreateCatmullRomSpline(lookAts,2000);
	}
	,showbezierPaths: function(scene) {
	}
	,update: function(phase) {
		if(wl_demo_CameraController.STOPPED && !this.ignoreStop) {
			return;
		}
		if(this.mode == wl_demo_CameraController.STATIC) {
			if(this.updatePath) {
				this.camera.position.x = this.position.x;
				this.camera.position.y = this.position.y;
				this.camera.position.z = this.position.z;
			}
			if(this.updateLook) {
				this.camera.setTarget(this.lookAt);
			}
		} else if(this.mode == wl_demo_CameraController.LINEAR) {
			if(this.updatePath) {
				var a = this.points[0];
				var b = this.points[1];
				var c = new BABYLON.Vector3(0,0,0);
				BABYLON.Vector3.LerpToRef(a,b,phase,c);
				this.camera.position.x = c.x;
				this.camera.position.y = c.y;
				this.camera.position.z = c.z;
			}
			if(this.updateLook) {
				var a1 = this.lookAts[0];
				var b1 = this.lookAts[1];
				var c1 = new BABYLON.Vector3(0,0,0);
				BABYLON.Vector3.LerpToRef(a1,b1,phase,c1);
				this.camera.setTarget(c1);
			}
		} else if(this.mode == wl_demo_CameraController.FOLLOW) {
			if(this.updatePath) {
				this.camera.position.x = this.follow.position.x + this.followOffset.x;
				this.camera.position.y = this.follow.position.y + this.followOffset.y;
				this.camera.position.z = this.follow.position.z + this.followOffset.z;
			}
			if(this.updateLook) {
				this.camera.setTarget(this.follow.position.add(this.followLookOffset));
			}
		} else if(this.mode == wl_demo_CameraController.BEZIER) {
			if(phase < 0) {
				phase = 0;
			} else if(phase > 1) {
				phase = 1;
			}
			if(this.updatePath) {
				var p = this.path.getPoints()[Math.floor(Math.min(phase * this.path.getPoints().length,this.path.getPoints().length - 1))];
				this.camera.position.x = p.x;
				this.camera.position.y = p.y;
				this.camera.position.z = p.z;
			}
			if(this.updateLook) {
				var p1 = this.lookPath.getPoints()[Math.floor(Math.min(phase * this.path.getPoints().length,this.path.getPoints().length - 1))];
				this.camera.setTarget(p1);
				this.lookAt = p1;
			}
			this.position = this.camera.position;
		}
	}
	,__class__: wl_demo_CameraController
};
var wl_demo_RandomCameraController = function(camera,cameraAmount,follow,seed,allowTypes,distanceRange,bounds) {
	this.distanceRange = [];
	this.cameraSwap = 0;
	this.current = 0;
	if(allowTypes.length == 0) {
		throw new js__$Boot_HaxeError("Random camera requires at least 1 type");
	}
	this.md = distanceRange[0];
	this.bounds = bounds;
	this.rnd = distanceRange[1] - distanceRange[0];
	this.distanceRange = distanceRange;
	this.random = new wl_util_Random(seed);
	this.follow = follow;
	this.camera = camera;
	this.ccs = [];
	var _g1 = 0;
	var _g = cameraAmount;
	while(_g1 < _g) {
		var i = _g1++;
		var cc = new wl_demo_CameraController(this.camera);
		var type = allowTypes[this.random.Next() % allowTypes.length];
		if(type == wl_demo_CameraController.FOLLOW) {
			this.initFollow(cc);
		} else if(type == wl_demo_CameraController.LINEAR) {
			this.initLinear(cc);
		} else if(type == wl_demo_CameraController.STATIC) {
			this.initStatic(cc);
		} else if(type == wl_demo_CameraController.BEZIER) {
			this.initBezier(cc);
		}
		this.ccs.push(cc);
	}
};
$hxClasses["wl.demo.RandomCameraController"] = wl_demo_RandomCameraController;
wl_demo_RandomCameraController.__name__ = ["wl","demo","RandomCameraController"];
wl_demo_RandomCameraController.prototype = {
	start: function() {
		this.cameraSwap = new Date().getTime();
	}
	,swap: function() {
		this.cameraSwap = new Date().getTime();
		this.current = (this.current + 1) % this.ccs.length;
	}
	,updatePartial: function(val) {
		this.ccs[this.current].update(val);
	}
	,updateLength: function(time) {
		var partial = (new Date().getTime() - this.cameraSwap) / time;
		this.ccs[this.current].update(partial);
	}
	,getRndPoint: function() {
		var v = this.bounds.minimum.clone();
		var add = this.bounds.maximum.subtract(this.bounds.minimum);
		add = add.multiply(new BABYLON.Vector3(this.random.NextFloat(),this.random.NextFloat(),this.random.NextFloat()));
		v = v.addInPlace(add);
		return v;
	}
	,initFollow: function(cc) {
		var obj = this.follow.length > 0 ? this.follow[this.random.Next() % this.follow.length] : new BABYLON.TransformNode("");
		var dir = new BABYLON.Vector3(this.random.NextFloat() - 0.5,this.random.NextFloat() - 0.5,this.random.NextFloat() - 0.5);
		dir.normalize();
		dir.scale(this.random.NextFloat() * this.rnd + this.md);
		cc.initFollow(obj,dir,new BABYLON.Vector3(this.random.NextFloat() * this.md / 10,this.random.NextFloat() * this.md / 10,this.random.NextFloat() * this.md / 10));
	}
	,initStatic: function(cc) {
		var obj = this.follow.length > 0 ? this.follow[this.random.Next() % this.follow.length] : new BABYLON.TransformNode("");
		var startp = this.getRndPoint();
		cc.initStatic(startp,obj.position);
	}
	,initLinear: function(cc) {
		var obj = this.follow.length > 0 ? this.follow[this.random.Next() % this.follow.length] : new BABYLON.TransformNode("");
		var startp = this.getRndPoint();
		var endp = this.getRndPoint();
		cc.initLinear([startp,endp],[obj.position.clone(),obj.position.clone().add(new BABYLON.Vector3(this.random.NextFloat() * 20 - 10,this.random.NextFloat() * 20 - 10,this.random.NextFloat() * 20 - 10))]);
	}
	,initBezier: function(cc) {
		var obj = this.follow.length > 0 ? this.follow[this.random.Next() % this.follow.length] : new BABYLON.TransformNode("");
		var start = this.getRndPoint();
		var end = this.getRndPoint();
		var pos = [start];
		var looks = [obj.position.clone(),obj.position.clone()];
		var dx = end.x - start.x;
		var dy = end.y - start.y;
		var dz = end.z - start.z;
		var _g = 1;
		while(_g < 6) {
			var i = _g++;
			looks.push(obj.position.clone());
			pos.push(new BABYLON.Vector3(this.random.NextFloat() * dx / 10 - dx / 20 + i / 6 * dx + start.x,this.random.NextFloat() * dy / 10 - dy / 20 + i / 6 * dy + start.y,this.random.NextFloat() * dz / 10 - dz / 20 + i / 6 * dz + start.z));
		}
		pos.push(end);
		cc.initBezier(pos,looks);
	}
	,__class__: wl_demo_RandomCameraController
};
var wl_demo_SceneBoard = function() {
	this.startTime = new wl_core_TimeSig();
	this.BoardItems = [];
};
$hxClasses["wl.demo.SceneBoard"] = wl_demo_SceneBoard;
wl_demo_SceneBoard.__name__ = ["wl","demo","SceneBoard"];
wl_demo_SceneBoard.prototype = {
	add: function(startTime,endTime,controller) {
		var item = new wl_demo_BoardItem(startTime,endTime,controller);
		this.BoardItems.push(item);
	}
	,start: function(ts) {
		this.startTime = ts.clone();
	}
	,update: function(ts,partial,frameTime,delta) {
		var _g = 0;
		var _g1 = this.BoardItems;
		while(_g < _g1.length) {
			var b = _g1[_g];
			++_g;
			var ts2 = ts.clone();
			ts2.subtract(this.startTime);
			b.Run(ts2);
		}
	}
	,__class__: wl_demo_SceneBoard
};
var wl_demo_TimeLine = function(instance,runOn,runOff,partId,renderToScreen,rtsOn,rtsOff,forceNewPart,extra) {
	console.log("Timeline init:" + (forceNewPart == null ? "null" : "" + forceNewPart));
	this.part = instance;
	this.partId = partId;
	this.runOn = runOn;
	this.runOff = runOff;
	this.rtsOn = rtsOn == null ? runOn.clone() : rtsOn;
	this.rtsOff = rtsOff == null ? runOff.clone() : rtsOff;
	this.renderToScreen = renderToScreen == null ? true : renderToScreen;
	this.forceNewPart = forceNewPart == null ? false : forceNewPart;
	this.extra = extra;
};
$hxClasses["wl.demo.TimeLine"] = wl_demo_TimeLine;
wl_demo_TimeLine.__name__ = ["wl","demo","TimeLine"];
wl_demo_TimeLine.prototype = {
	toString: function() {
		return this.part.name + ":" + this.rtsOn.toString() + " - " + this.rtsOff.toString();
	}
	,__class__: wl_demo_TimeLine
};
var wl_library_Library = function() {
	if(wl_library_Library.inst == null) {
		wl_library_Library.inst = this;
	} else {
		console.log("Creating multiple Library instances. Are you sure?");
	}
	this.materials = new wl_library_MaterialBuilders();
	this.staticMaterials = new haxe_ds_EnumValueMap();
};
$hxClasses["wl.library.Library"] = wl_library_Library;
wl_library_Library.__name__ = ["wl","library","Library"];
wl_library_Library.get_instance = function() {
	if(wl_library_Library.inst == null) {
		wl_library_Library.instance = new wl_library_Library();
	}
	return wl_library_Library.inst;
};
wl_library_Library.prototype = {
	getMaterial: function(type,asStatic) {
		if(asStatic) {
			var m = this.staticMaterials.get(type);
			if(m == null) {
				var o = this.materials;
				m = Reflect.field(this.materials,type[0]).apply(o,[]);
				this.staticMaterials.set(type,m);
			}
			return m;
		}
		var o1 = this.materials;
		return Reflect.field(this.materials,type[0]).apply(o1,[]);
	}
	,__class__: wl_library_Library
};
var wl_library_MaterialBuilders = function() {
};
$hxClasses["wl.library.MaterialBuilders"] = wl_library_MaterialBuilders;
wl_library_MaterialBuilders.__name__ = ["wl","library","MaterialBuilders"];
wl_library_MaterialBuilders.prototype = {
	chrome: function() {
		return new BABYLON.StandardMaterial("",null);
	}
	,whiteChrome: function() {
		return new BABYLON.StandardMaterial("",null);
	}
	,ghost: function() {
		var xray_mat = new BABYLON.StandardMaterial("xray",null);
		xray_mat.emissiveColor = new BABYLON.Color3(1,1,1);
		xray_mat.alpha = 0.2;
		var fresnel_params = { };
		fresnel_params.isEnabled = true;
		fresnel_params.leftColor = new BABYLON.Color3(0.5,0.6,1);
		fresnel_params.rightColor = new BABYLON.Color3(0,0,0);
		fresnel_params.power = 2;
		fresnel_params.bias = 0.1;
		var fresnel_params2 = { };
		fresnel_params2.isEnabled = true;
		fresnel_params2.leftColor = new BABYLON.Color3(1,1,1);
		fresnel_params2.rightColor = new BABYLON.Color3(0.2,0.2,0.2);
		fresnel_params2.power = 2;
		fresnel_params2.bias = 0.5;
		xray_mat.emissiveFresnelParameters = fresnel_params;
		xray_mat.opacityFresnelParameters = fresnel_params2;
		return xray_mat;
	}
	,ghost2: function() {
		var xray_mat = new BABYLON.StandardMaterial("xray",null);
		xray_mat.emissiveColor = new BABYLON.Color3(1,1,1);
		xray_mat.alpha = 0.2;
		var fresnel_params = { };
		fresnel_params.isEnabled = true;
		fresnel_params.leftColor = new BABYLON.Color3(0.5,0.6,1);
		fresnel_params.rightColor = new BABYLON.Color3(0,0,0);
		fresnel_params.power = 2;
		fresnel_params.bias = 0.1;
		var fresnel_params2 = { };
		fresnel_params2.isEnabled = true;
		fresnel_params2.leftColor = new BABYLON.Color3(1,1,1);
		fresnel_params2.rightColor = new BABYLON.Color3(0.2,0.2,0.2);
		fresnel_params2.power = 2;
		fresnel_params2.bias = 0.5;
		xray_mat.emissiveFresnelParameters = fresnel_params;
		xray_mat.opacityFresnelParameters = fresnel_params2;
		return xray_mat;
	}
	,__class__: wl_library_MaterialBuilders
};
var wl_library_Materials = { __ename__ : true, __constructs__ : ["chrome","whiteChrome","ghost","ghost2"] };
wl_library_Materials.chrome = ["chrome",0];
wl_library_Materials.chrome.toString = $estr;
wl_library_Materials.chrome.__enum__ = wl_library_Materials;
wl_library_Materials.whiteChrome = ["whiteChrome",1];
wl_library_Materials.whiteChrome.toString = $estr;
wl_library_Materials.whiteChrome.__enum__ = wl_library_Materials;
wl_library_Materials.ghost = ["ghost",2];
wl_library_Materials.ghost.toString = $estr;
wl_library_Materials.ghost.__enum__ = wl_library_Materials;
wl_library_Materials.ghost2 = ["ghost2",3];
wl_library_Materials.ghost2.toString = $estr;
wl_library_Materials.ghost2.__enum__ = wl_library_Materials;
var wl_post_displacement_Displacement = function(camera,engine) {
	this.zoom = 0.01;
	this.scaleY = 0.01;
	this.scaleX = 0.01;
	var _gthis = this;
	BABYLON.Effect.ShadersStore["displacementFragmentShader"] = haxe_Resource.getString("displacement.frag");
	var t = wl_core_Assets.getTexture("perlin-512.png");
	BABYLON.PostProcess.call(this,"displacementPostProcesz","displacement",["scaleX","scaleY","zoom","offset"],["tDispMap"],1.0,null,BABYLON.Texture.NEAREST_SAMPLINGMODE,engine,false);
	this.onApplyObservable.add(function(e,es) {
		e.setFloat("scaleX",_gthis.scaleX);
		e.setFloat("scaleY",_gthis.scaleY);
		e.setFloat("zoom",_gthis.zoom);
		e.setTexture("tDispMap",t);
	});
	this.getEffect().setTexture("tDispMap",t);
	wl_core_Demo.instance.onUpdate.connect(function(ts) {
		_gthis.getEffect().setArray2("offset",[ts.toMilliseconds() / 15000,ts.toMilliseconds() / 18000]);
	});
};
$hxClasses["wl.post.displacement.Displacement"] = wl_post_displacement_Displacement;
wl_post_displacement_Displacement.__name__ = ["wl","post","displacement","Displacement"];
wl_post_displacement_Displacement.__super__ = BABYLON.PostProcess;
wl_post_displacement_Displacement.prototype = $extend(BABYLON.PostProcess.prototype,{
	setupDatGui: function(folder) {
		var _gthis = this;
		folder.add(this,"scaleX").step(0.0001).min(0).max(1).onChange(function(value) {
			_gthis.scaleX = value;
		});
		folder.add(this,"scaleY").step(0.0001).min(0).max(1).onChange(function(value1) {
			_gthis.scaleY = value1;
		});
		folder.add(this,"zoom").step(0.0001).min(0).max(100).onChange(function(value2) {
			_gthis.zoom = value2;
		});
	}
	,__class__: wl_post_displacement_Displacement
});
var wl_post_distort_DistortPostProcess = function(camera,engine) {
	this.brightness = 0;
	this.autoOffset = false;
	this.offsetSpeed = 0.001;
	this.offset = 0;
	this.lineHeight = wl_core_Config.RESOLUTION[1] / 4;
	this.intensityY = 0;
	this.intensity = 0;
	var _gthis = this;
	BABYLON.Effect.ShadersStore["distortFragmentShader"] = haxe_Resource.getString("distort.frag");
	BABYLON.PostProcess.call(this,"distortPostProcess","distort",["intensity","intensityY","height","offsetY","brightness"],null,1.0,null,BABYLON.Texture.NEAREST_SAMPLINGMODE,engine,false);
	this.onApplyObservable.add(function(e,es) {
		e.setFloat("intensity",_gthis.intensity);
		e.setFloat("intensityY",_gthis.intensityY);
		e.setFloat("height",_gthis.lineHeight);
		e.setFloat("offsetY",_gthis.offset);
		e.setFloat("brightness",_gthis.brightness);
	});
	wl_core_Demo.instance.onUpdate.connect(function(ts) {
		var _gthis1 = _gthis.offsetSpeed;
		var tmp = ts.toMilliseconds();
		_gthis.offset = _gthis1 * tmp;
	});
};
$hxClasses["wl.post.distort.DistortPostProcess"] = wl_post_distort_DistortPostProcess;
wl_post_distort_DistortPostProcess.__name__ = ["wl","post","distort","DistortPostProcess"];
wl_post_distort_DistortPostProcess.__super__ = BABYLON.PostProcess;
wl_post_distort_DistortPostProcess.prototype = $extend(BABYLON.PostProcess.prototype,{
	setupDatGui: function(folder) {
		folder.add(this,"intensityY").min(0).max(1).step(0.001);
		folder.add(this,"intensity").min(0).max(1).step(0.001);
		folder.add(this,"height").min(0).max(1080).step(0.1);
		folder.add(this,"offsetSpeed").min(0).max(1).step(0.0001);
		folder.add(this,"autoOffset");
	}
	,__class__: wl_post_distort_DistortPostProcess
});
var wl_setup_JsonConfigurator = function() {
};
$hxClasses["wl.setup.JsonConfigurator"] = wl_setup_JsonConfigurator;
wl_setup_JsonConfigurator.__name__ = ["wl","setup","JsonConfigurator"];
wl_setup_JsonConfigurator.prototype = {
	fromJson: function(json) {
		var config = JSON.parse(json);
		this.audioSettingsfromJson(config);
		this.visualSettingsfromJson(config);
		this.timelineFromJson(config);
	}
	,audioSettingsfromJson: function(config) {
		wl_core_Config.BEATS_PER_MINUTE = config.audio.beatsPerMinute;
		wl_core_Config.BEATS_PER_BAR = config.audio.beatsPerBar;
		wl_core_Config.TICKS_PER_BEAT = config.audio.ticksPerBeat;
		wl_core_Config.MUSIC_BEGIN = config.audio.musicBegin;
		wl_core_Config.SONG_PATH = config.audio.songPath;
		wl_core_Config.ENABLE_FFT = config.audio.enableFFT;
	}
	,visualSettingsfromJson: function(config) {
		wl_core_Config.FPS = config.visual.targetFps;
		wl_core_Config.RESOLUTION = config.visual.resolution;
		wl_core_Config.ANTIALIAS = config.visual.antiAlias;
		wl_core_Config.ENABLE_SHADOWS = config.visual.enableShadows;
		wl_core_Config.CLEAR_COLOR = BABYLON.Color4.FromHexString(config.visual.clearColor);
		console.log(wl_core_Config.CLEAR_COLOR);
		wl_core_Config.SHADOW_MAP_SIZE = config.visual.shadowMapSize;
	}
	,timelineFromJson: function(config) {
		var tl = config.timeline;
		var convertedTl = [];
		var ignoreParts = window.location.hash.indexOf("Coverride=") >= 0;
		if(window.location.hash.indexOf("override=") >= 0) {
			convertedTl = [];
			var r = new RegExp("override=(.*)","");
			var m = r.exec(window.location.hash);
			console.log("overriding timeline with " + m[1]);
			convertedTl.push(this.tlFromConfig({ "partId" : "override", "type" : m[1], "renderToScreen" : true, "runOn" : [0,0,0,0], "runOff" : [128,0,0,0], "extra" : "", "forceNewPart" : false}));
		}
		if(!ignoreParts) {
			var _g = 0;
			while(_g < tl.length) {
				var c = tl[_g];
				++_g;
				convertedTl.push(this.tlFromConfig(c));
			}
		}
		wl_core_Config.TIMELINE = convertedTl;
	}
	,tlFromConfig: function(config) {
		var instance = Type.createInstance(Type.resolveClass(config.type),[]);
		return new wl_demo_TimeLine(instance,this.mainTimesigFromArray(config.runOn),this.mainTimesigFromArray(config.runOff),config.partId,config.renderToScreen,this.mainTimesigFromArray(config.rtsOn),this.mainTimesigFromArray(config.rtsOff),config.forceNewPart,config.extra);
	}
	,mainTimesigFromArray: function(tsArray) {
		if(tsArray == null) {
			return null;
		}
		var bar = tsArray.length > 0 ? tsArray[0] : null;
		var beat = tsArray.length > 1 ? tsArray[1] : null;
		var tick = tsArray.length > 2 ? tsArray[2] : null;
		var delay = tsArray.length > 3 ? tsArray[3] : null;
		return new wl_core_TimeSig(bar,beat,tick,delay,wl_core_TimeSig.ABSOLUTE);
	}
	,__class__: wl_setup_JsonConfigurator
};
var wl_setup_Setup = function() {
	throw new js__$Boot_HaxeError("Setup is static only.");
};
$hxClasses["wl.setup.Setup"] = wl_setup_Setup;
wl_setup_Setup.__name__ = ["wl","setup","Setup"];
wl_setup_Setup.init = function(demo) {
	wl_setup_Setup.setupDiv = $("#setup");
	wl_setup_Setup.demoDiv = $("#demo");
	wl_setup_Setup.resolution = wl_setup_Setup.setupDiv.find("#resolution");
	var fullscreen = wl_setup_Setup.setupDiv.find("#fullscreen");
	var start = wl_setup_Setup.setupDiv.find("#start");
	fullscreen.click(wl_setup_Setup.fullScreenClickHandler);
	start.click(wl_setup_Setup.startClickHandler);
	wl_setup_Setup.demo = demo;
	if(window.location.protocol.indexOf("file") >= 0) {
		$("#localWarning").css("display","");
	}
};
wl_setup_Setup.hideSetup = function() {
	wl_setup_Setup.setupDiv.remove();
};
wl_setup_Setup.startRun = function() {
	var mute = wl_setup_Setup.setupDiv.find("#muted").find("input")["is"](":checked");
	if(mute) {
		wl_core_Config.MUTED = true;
	}
	var debug = wl_setup_Setup.setupDiv.find("#debug").find("input")["is"](":checked");
	wl_core_Config.DEBUG = debug;
	if(debug) {
		$(".debug").css("display","block");
	} else {
		$(".debug").css("display","none");
	}
	wl_setup_Setup.loadImg = wl_core_Assets.get("loadingImage.png");
	wl_setup_Setup.loadImg.style.position = "absolute";
	wl_setup_Setup.loadImg.style.left = "0px";
	wl_setup_Setup.loadImg.style.right = "0px";
	wl_setup_Setup.loadImg.style.top = "0px";
	wl_setup_Setup.loadImg.style.bottom = "0px";
	wl_setup_Setup.loadImg.style.width = "100%";
	wl_setup_Setup.loadImg.style.height = "100%";
	wl_setup_Setup.demoDiv.append(wl_setup_Setup.loadImg);
	wl_setup_Setup.demo.init(wl_setup_Setup.demoDiv[0],function() {
		wl_setup_Setup.loadImg.remove();
		wl_setup_Setup.demo.start();
	});
	window.document.getElementById("demo").style.display = "block";
};
wl_setup_Setup.fullScreenClickHandler = function(e) {
	wl_setup_Setup.hideSetup();
	try {
		wl_setup_Setup.demoDiv[0].requestFullscreen();
	} catch( e1 ) {
		throw new js__$Boot_HaxeError("Full screen could not be initialized. Please reload and try again.");
	}
	var w = window.screen.width;
	var h = window.screen.height;
	var ratio = wl_core_Config.RATIO;
	var lockAspect = $("#aspectLock input").val() == "on";
	if(lockAspect && w / ratio < h) {
		h = w * 720 / 1280;
	} else if(lockAspect && h < w / ratio) {
		w = h * 1280 / 720;
	}
	wl_core_Config.RESOLUTION[0] = Math.floor(w);
	wl_core_Config.RESOLUTION[1] = Math.floor(h);
	wl_setup_Setup.demoDiv.css("background","black");
	haxe_Timer.delay(wl_setup_Setup.startRun,5000);
};
wl_setup_Setup.startClickHandler = function(e) {
	$("#zoomWarning").css("display","none");
	$("#demo").css("transform","").css("-webkit-transform","");
	var lockAspect = $("#aspectLock input").val() == "on";
	var mute = $("#muted input")["is"](":checked");
	var resolutionType = $("#resolution .active input[name='options']").val();
	wl_setup_Setup.hideSetup();
	var w = 1280;
	var h = 720;
	if(resolutionType == "b") {
		w = 1920;
		h = 1080;
	} else if(resolutionType == "c") {
		w = window.innerWidth;
		h = window.innerHeight;
		var ratio = wl_core_Config.RATIO;
		if(lockAspect && w / ratio < h) {
			h = w / ratio;
		} else if(lockAspect && h < w / ratio) {
			w = h * ratio;
		}
	}
	wl_core_Config.RESOLUTION[0] = w;
	wl_core_Config.RESOLUTION[1] = h;
	wl_setup_Setup.demoDiv.css("width",w + "px").css("height",h + "px");
	haxe_Timer.delay(wl_setup_Setup.startRun,50);
};
wl_setup_Setup.prototype = {
	__class__: wl_setup_Setup
};
var wl_sounds_SoundAnalyzer = function() {
	this.historySize = 6;
	this.filters = [];
	this.historyLeft = [];
	this.historyRight = [];
	var _g1 = 0;
	var _g = wl_sounds_SoundWL.FFT_PRECISION;
	while(_g1 < _g) {
		var i = _g1++;
		this.historyLeft.push([]);
		this.historyRight.push([]);
	}
};
$hxClasses["wl.sounds.SoundAnalyzer"] = wl_sounds_SoundAnalyzer;
wl_sounds_SoundAnalyzer.__name__ = ["wl","sounds","SoundAnalyzer"];
wl_sounds_SoundAnalyzer.prototype = {
	update: function() {
		var _g = 0;
		var _g1 = this.filters;
		while(_g < _g1.length) {
			var filter = _g1[_g];
			++_g;
			filter.min = 1;
			filter.max = 0;
			filter.triggered = false;
			if(filter.channels == null) {
				filter.channels = wl_sounds_Channels.both;
			}
		}
		var fft = wl_sounds_SoundWL.getFFT();
		var sample = wl_sounds_SoundWL.sampleRate;
		var band = sample / wl_sounds_SoundWL.FFT_PRECISION;
		if(fft.frequencyLeft == null) {
			return;
		}
		var _g11 = 0;
		var _g2 = fft.frequencyLeft.length;
		while(_g11 < _g2) {
			var i = _g11++;
			var hL = this.historyLeft[i];
			hL.push(fft.frequencyLeft[i] / 255);
			var hR = this.historyRight[i];
			hR.push(fft.frequencyRight[i] / 255);
			while(hL.length > this.historySize) {
				hL.shift();
				hR.shift();
			}
			var sumL = 0;
			var _g21 = 0;
			while(_g21 < hL.length) {
				var v = hL[_g21];
				++_g21;
				sumL += v;
			}
			sumL /= this.historySize;
			var sumR = 0;
			var _g22 = 0;
			while(_g22 < hR.length) {
				var v1 = hR[_g22];
				++_g22;
				sumR += v1;
			}
			sumR /= this.historySize;
			var hz = band * i;
			var hzN = band * (i + 1);
			var _g23 = 0;
			var _g3 = this.filters;
			while(_g23 < _g3.length) {
				var filter1 = _g3[_g23];
				++_g23;
				var active = filter1.isolate ? hz >= filter1.lowLimit && hz <= filter1.highLimit : hz > filter1.highLimit || hz < filter1.lowLimit;
				if(active) {
					var sum = filter1.channels == wl_sounds_Channels.both ? (sumL + sumR) / 2 : filter1.channels == wl_sounds_Channels.right ? sumR : sumL;
					filter1.min = filter1.min > sum ? sum : filter1.min;
					filter1.max = filter1.max < sum ? sum : filter1.max;
					filter1.triggered = true;
				}
			}
		}
		var _g4 = 0;
		var _g12 = this.filters;
		while(_g4 < _g12.length) {
			var f = _g12[_g4];
			++_g4;
			var tmp = !f.triggered;
		}
	}
	,__class__: wl_sounds_SoundAnalyzer
};
var wl_sounds_Channels = { __ename__ : true, __constructs__ : ["left","right","both"] };
wl_sounds_Channels.left = ["left",0];
wl_sounds_Channels.left.toString = $estr;
wl_sounds_Channels.left.__enum__ = wl_sounds_Channels;
wl_sounds_Channels.right = ["right",1];
wl_sounds_Channels.right.toString = $estr;
wl_sounds_Channels.right.__enum__ = wl_sounds_Channels;
wl_sounds_Channels.both = ["both",2];
wl_sounds_Channels.both.toString = $estr;
wl_sounds_Channels.both.__enum__ = wl_sounds_Channels;
var wl_sounds_SoundWL = function() {
	throw new js__$Boot_HaxeError("Sound is static");
};
$hxClasses["wl.sounds.SoundWL"] = wl_sounds_SoundWL;
wl_sounds_SoundWL.__name__ = ["wl","sounds","SoundWL"];
wl_sounds_SoundWL.init = function() {
	wl_sounds_SoundWL.loadMusicFile();
	wl_sounds_SoundWL.context = createjs.Sound.activePlugin.context;
	wl_sounds_SoundWL.sampleRate = createjs.Sound.activePlugin.context.sampleRate;
	wl_sounds_SoundWL.dynamicsCompressorNode = createjs.Sound.activePlugin.dynamicsCompressorNode;
	wl_sounds_SoundWL.gainNode = createjs.Sound.activePlugin.gainNode;
	if(wl_core_Config.ENABLE_FFT) {
		wl_sounds_SoundWL.initializeFFT();
	}
};
wl_sounds_SoundWL.setVolume = function(volume) {
	wl_sounds_SoundWL.volume = volume;
	if(wl_sounds_SoundWL.instance != null) {
		wl_sounds_SoundWL.instance.volume = volume;
	}
};
wl_sounds_SoundWL.getPosition = function() {
	if(wl_sounds_SoundWL.instance != null) {
		wl_sounds_SoundWL.time.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
	} else if(wl_sounds_SoundWL.context != null) {
		wl_sounds_SoundWL.time.fromTime((wl_sounds_SoundWL.context.currentTime - wl_sounds_SoundWL.startTime) / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
	}
	return wl_sounds_SoundWL.time;
};
wl_sounds_SoundWL.getFFT = function() {
	return wl_sounds_SoundWL.FFT;
};
wl_sounds_SoundWL.updateFFT = function() {
	if(!wl_debug_Debug.paused && (wl_sounds_SoundWL.instance != null || wl_sounds_SoundWL.context != null) && wl_core_Config.ENABLE_FFT && wl_sounds_SoundWL.analyserNodeLeft != null) {
		wl_sounds_SoundWL.analyserNodeLeft.getFloatFrequencyData(wl_sounds_SoundWL.freqFloatDataLeft);
		wl_sounds_SoundWL.analyserNodeLeft.getByteFrequencyData(wl_sounds_SoundWL.freqByteDataLeft);
		wl_sounds_SoundWL.analyserNodeLeft.getByteTimeDomainData(wl_sounds_SoundWL.timeByteDataLeft);
		wl_sounds_SoundWL.analyserNodeRight.getFloatFrequencyData(wl_sounds_SoundWL.freqFloatDataRight);
		wl_sounds_SoundWL.analyserNodeRight.getByteFrequencyData(wl_sounds_SoundWL.freqByteDataRight);
		wl_sounds_SoundWL.analyserNodeRight.getByteTimeDomainData(wl_sounds_SoundWL.timeByteDataRight);
	}
};
wl_sounds_SoundWL.start = function() {
	wl_sounds_SoundWL.instance = createjs.Sound.play("music");
	wl_sounds_SoundWL.instance.on("complete",wl_sounds_SoundWL.handleComplete);
	wl_sounds_SoundWL.instance.volume = wl_core_Config.MUTED ? 0 : wl_sounds_SoundWL.volume;
	if(wl_core_Config.ENABLE_FFT) {
		wl_core_Graphics.instance.onRender.disconnect(wl_sounds_SoundWL.updateFFT);
		wl_core_Graphics.instance.onRender.connect(wl_sounds_SoundWL.updateFFT);
	}
	wl_sounds_SoundWL.onSoundReady.emit();
};
wl_sounds_SoundWL.handleComplete = function() {
	wl_sounds_SoundWL.onSoundComplete.emit();
};
wl_sounds_SoundWL.loadMusicFile = function() {
	var sounds = [{ id : "music", src : wl_core_Config.SONG_PATH}];
	createjs.Sound.alternateExtensions = ["mp3"];
	createjs.Sound.addEventListener("fileload",wl_sounds_SoundWL.handleLoad);
	createjs.Sound.registerSounds(sounds);
};
wl_sounds_SoundWL.initializeFFT = function() {
	var context = wl_sounds_SoundWL.context;
	var fftsize = wl_sounds_SoundWL.FFT_PRECISION;
	if(context != null && $bind(context,context.createAnalyser) != null) {
		var mergerNode = context.createChannelMerger(2);
		wl_sounds_SoundWL.analyserNodeLeft = context.createAnalyser();
		wl_sounds_SoundWL.analyserNodeLeft.fftSize = fftsize;
		wl_sounds_SoundWL.analyserNodeLeft.smoothingTimeConstant = 0.0;
		wl_sounds_SoundWL.analyserNodeRight = context.createAnalyser();
		wl_sounds_SoundWL.analyserNodeRight.fftSize = fftsize;
		wl_sounds_SoundWL.analyserNodeRight.smoothingTimeConstant = 0.0;
		var dynamicsNode = wl_sounds_SoundWL.dynamicsCompressorNode;
		dynamicsNode.disconnect();
		var splitterNode = context.createChannelSplitter(2);
		wl_sounds_SoundWL.gainNode.disconnect();
		wl_sounds_SoundWL.gainNode.connect(splitterNode);
		splitterNode.connect(wl_sounds_SoundWL.analyserNodeLeft,0,0);
		splitterNode.connect(wl_sounds_SoundWL.analyserNodeRight,1,0);
		wl_sounds_SoundWL.freqFloatDataLeft = new Float32Array(wl_sounds_SoundWL.analyserNodeLeft.frequencyBinCount);
		wl_sounds_SoundWL.freqByteDataLeft = new Uint8Array(wl_sounds_SoundWL.analyserNodeLeft.frequencyBinCount);
		wl_sounds_SoundWL.timeByteDataLeft = new Uint8Array(wl_sounds_SoundWL.analyserNodeLeft.frequencyBinCount);
		wl_sounds_SoundWL.freqFloatDataRight = new Float32Array(wl_sounds_SoundWL.analyserNodeRight.frequencyBinCount);
		wl_sounds_SoundWL.freqByteDataRight = new Uint8Array(wl_sounds_SoundWL.analyserNodeRight.frequencyBinCount);
		wl_sounds_SoundWL.timeByteDataRight = new Uint8Array(wl_sounds_SoundWL.analyserNodeRight.frequencyBinCount);
		wl_sounds_SoundWL.analyserNodeLeft.connect(mergerNode,0,0);
		wl_sounds_SoundWL.analyserNodeRight.connect(mergerNode,0,1);
		mergerNode.connect(context.destination);
	} else {
		console.log("FFT could not be initialized.");
	}
	wl_sounds_SoundWL.FFT.dbLeft = wl_sounds_SoundWL.freqFloatDataLeft;
	wl_sounds_SoundWL.FFT.frequencyLeft = wl_sounds_SoundWL.freqByteDataLeft;
	wl_sounds_SoundWL.FFT.waveformLeft = wl_sounds_SoundWL.timeByteDataLeft;
	wl_sounds_SoundWL.FFT.dbRight = wl_sounds_SoundWL.freqFloatDataRight;
	wl_sounds_SoundWL.FFT.frequencyRight = wl_sounds_SoundWL.freqByteDataRight;
	wl_sounds_SoundWL.FFT.waveformRight = wl_sounds_SoundWL.timeByteDataRight;
};
wl_sounds_SoundWL.handleLoad = function() {
	wl_sounds_SoundWL.loaded = true;
	wl_sounds_SoundWL.onSoundLoaded.emit();
};
wl_sounds_SoundWL.prototype = {
	__class__: wl_sounds_SoundWL
};
var wl_util_DatGuiHelper = function() {
};
$hxClasses["wl.util.DatGuiHelper"] = wl_util_DatGuiHelper;
wl_util_DatGuiHelper.__name__ = ["wl","util","DatGuiHelper"];
wl_util_DatGuiHelper.addVector = function(folder,vector,step,callback) {
	if(step == null) {
		step = 0.1;
	}
	folder.add(vector,"x").step(step).onChange(callback);
	folder.add(vector,"y").step(step).onChange(callback);
	folder.add(vector,"z").step(step).onChange(callback);
};
wl_util_DatGuiHelper.addColor = function(folder,obu,property) {
	obu[property + "_x"] = "#000000";
	folder.addColor(obu,property + "_x").onChange(function(data) {
		console.log(data);
		var color = BABYLON.Color3.FromHexString(data);
		console.log(color);
		obu[property].r = color.r;
		obu[property].g = color.g;
		obu[property].b = color.b;
	});
};
wl_util_DatGuiHelper.prototype = {
	__class__: wl_util_DatGuiHelper
};
var wl_util_ExtendedMeshBuilder = function() {
};
$hxClasses["wl.util.ExtendedMeshBuilder"] = wl_util_ExtendedMeshBuilder;
wl_util_ExtendedMeshBuilder.__name__ = ["wl","util","ExtendedMeshBuilder"];
wl_util_ExtendedMeshBuilder.BuildRingDisc = function(diameter,innerDiameter,height,scene,tessellation) {
	if(tessellation == null) {
		tessellation = 40;
	}
	var outerdisc = BABYLON.MeshBuilder.CreateCylinder("",{ diameter : diameter, tessellation : tessellation, height : height},null);
	var innerDisc = BABYLON.MeshBuilder.CreateCylinder("",{ diameter : innerDiameter, tessellation : tessellation, height : height * 2},null);
	var csg = BABYLON.CSG.FromMesh(outerdisc);
	csg.subtractInPlace(BABYLON.CSG.FromMesh(innerDisc));
	var mesh = csg.toMesh("name",null,scene,false);
	outerdisc.dispose();
	innerDisc.dispose();
	return mesh;
};
wl_util_ExtendedMeshBuilder.CreateRoom = function(name,options,scene) {
	var outerBox = BABYLON.MeshBuilder.CreateBox(name + "outer",options,null);
	options.size -= options.wallThickness;
	options.width -= options.wallThickness;
	options.height -= options.wallThickness;
	options.depth -= options.wallThickness;
	var innerBox = BABYLON.MeshBuilder.CreateBox(name + "inner",options,null);
	var csg = BABYLON.CSG.FromMesh(outerBox);
	csg.subtractInPlace(BABYLON.CSG.FromMesh(innerBox));
	outerBox.dispose();
	innerBox.dispose();
	return csg.toMesh(name,null,scene,false);
};
wl_util_ExtendedMeshBuilder.CreateTube = function(name,options,scene) {
	var outertube = BABYLON.MeshBuilder.CreateCylinder(name + "outer",options,null);
	options.diameter -= options.wallThickness;
	options.diameterBottom -= options.wallThickness;
	options.diameterTop -= options.wallThickness;
	options.height *= 1.1;
	var innertube = BABYLON.MeshBuilder.CreateCylinder(name + "inner",options,null);
	var csg = BABYLON.CSG.FromMesh(outertube);
	csg.subtractInPlace(BABYLON.CSG.FromMesh(innertube));
	var mesh = csg.toMesh(name,null,scene,false);
	outertube.dispose();
	innertube.dispose();
	return mesh;
};
wl_util_ExtendedMeshBuilder.CreateTrashTube = function(name,options,scene) {
	var targetHeight = options.height;
	var targetDiameter = options.diameter;
	var outertube = BABYLON.MeshBuilder.CreateCylinder(name + "outer",options,null);
	options.diameter -= options.wallThickness;
	options.diameterBottom -= options.wallThickness;
	options.diameterTop -= options.wallThickness;
	options.height *= 1.1;
	var innertube = BABYLON.MeshBuilder.CreateCylinder(name + "inner",options,null);
	var csg = BABYLON.CSG.FromMesh(outertube);
	csg.subtractInPlace(BABYLON.CSG.FromMesh(innertube));
	var mesh = csg.toMesh(name,null,scene,false);
	outertube.dispose();
	innertube.dispose();
	mesh.translate(new BABYLON.Vector3(0,1,0),targetHeight / 2);
	var meshes = [];
	meshes.push(mesh);
	var _g1 = 0;
	var _g = targetHeight;
	while(_g1 < _g) {
		var i = _g1++;
		if(wl_util_Random.nextFloat() < 0.5 || i > 250) {
			continue;
		}
		var b = BABYLON.MeshBuilder.CreateBox("",{ width : 40 * wl_util_Random.nextFloat(), size : wl_util_Random.nextFloat() + .25},null);
		meshes.push(b);
		var tmp = options.diameter * wl_util_Random.nextFloat();
		b.position.x = tmp - options.diameter / 2;
		var tmp1 = options.diameter * wl_util_Random.nextFloat() * 0.5;
		var tmp2 = options.diameter * 0.2 * wl_util_Random.nextFloat();
		b.position.z = tmp1 + tmp2;
		b.rotate(new BABYLON.Vector3(0,1,0),wl_util_Random.nextFloat() * Math.PI * 2);
		b.position.y = i;
	}
	var ringplaces = [55,98,151,213,276,320,350,370];
	var ringRadiuses = [targetDiameter - 10,targetDiameter - 11,targetDiameter - 11,targetDiameter - 12,targetDiameter - 11,targetDiameter - 12,targetDiameter - 12,targetDiameter - 12,targetDiameter - 12,targetDiameter - 12];
	var _g2 = 0;
	while(_g2 < 8) {
		var i1 = _g2++;
		var cyl = wl_util_ExtendedMeshBuilder.BuildRingDisc(targetDiameter,ringRadiuses[i1],5,null);
		cyl.position.y = ringplaces[i1];
		meshes.push(cyl);
	}
	return BABYLON.Mesh.MergeMeshes(meshes,true);
};
wl_util_ExtendedMeshBuilder.CreateGrate = function(name,options,scene) {
	var box = BABYLON.MeshBuilder.CreateBox("",options);
	box.translate(new BABYLON.Vector3(0,0,1),options.depth / 2);
	box.translate(BABYLON.Vector3.Right(),options.width / 2.0);
	box.bakeCurrentTransformIntoVertices();
	var csg = BABYLON.CSG.FromMesh(box);
	var _g1 = 0;
	var _g = Math.floor(options.width / options.gridSize);
	while(_g1 < _g) {
		var x = _g1++;
		var _g3 = 0;
		var _g2 = options.depth / options.gridSize;
		while(_g3 < _g2) {
			var z = _g3++;
			var holeb = BABYLON.MeshBuilder.CreateBox("",{ width : options.gridSize - options.gridSpacing, depth : options.gridSize - options.gridSpacing, height : options.height * 4});
			holeb.position.x = x * options.gridSize + options.gridSize / 2;
			holeb.position.z = z * options.gridSize + options.gridSize / 2;
			csg.subtractInPlace(BABYLON.CSG.FromMesh(holeb));
			holeb.dispose();
		}
	}
	var mesh = csg.toMesh("",null,null,false);
	mesh.translate(BABYLON.Vector3.Right(),-options.width / 2);
	mesh.bakeCurrentTransformIntoVertices();
	box.dispose();
	return mesh;
};
wl_util_ExtendedMeshBuilder.CreateWindowedTube = function(radius,length,height,tubeMaterial,glowMaterial) {
	var path = [new BABYLON.Vector3(0,0,0),new BABYLON.Vector3(0,height,length * 0.05),new BABYLON.Vector3(0,height,length * 0.8),new BABYLON.Vector3(0,height,length * 0.95),new BABYLON.Vector3(0,0,length)];
	var tube = BABYLON.MeshBuilder.CreateTube("",{ path : path, radius : radius},null);
	var cylinder = BABYLON.MeshBuilder.CreateCylinder("",{ diameter : radius, height : length * 0.75},null);
	cylinder.rotate(BABYLON.Vector3.Right(),Math.PI / 2);
	cylinder.position.y = height + radius;
	cylinder.position.z = length / 2;
	var csg = BABYLON.CSG.FromMesh(tube);
	csg.subtractInPlace(BABYLON.CSG.FromMesh(cylinder));
	var mesh = csg.toMesh("",null,null,false);
	tube.dispose();
	cylinder.dispose();
	var glowstick = BABYLON.MeshBuilder.CreateCylinder("",{ diameter : radius * 1.65, height : length * 0.8},null);
	glowstick.rotate(BABYLON.Vector3.Right(),Math.PI / 2);
	glowstick.position.z = length / 2;
	glowstick.position.y = height;
	glowstick.material = glowMaterial;
	glowstick.parent = mesh;
	mesh.material = tubeMaterial;
	mesh.bakeCurrentTransformIntoVertices();
	glowstick.bakeCurrentTransformIntoVertices();
	mesh.setPivotPoint(new BABYLON.Vector3(0,0,length / 2));
	return mesh;
};
wl_util_ExtendedMeshBuilder.CreateHollowCube = function(name,options,scene) {
	var outerBox = BABYLON.MeshBuilder.CreateBox(name + "outer",options,null);
	options.edge = options.edge != null ? options.edge : 0.1;
	options.edge = 1 - options.edge;
	console.log(options.edge);
	var heightOptions = JSON.parse(JSON.stringify(options));
	heightOptions.height *= 1.5;
	heightOptions.width *= options.edge;
	heightOptions.depth *= options.edge;
	var heightBox = BABYLON.MeshBuilder.CreateBox("",heightOptions,null);
	var widthOptions = JSON.parse(JSON.stringify(options));
	widthOptions.width *= 1.5;
	widthOptions.height *= options.edge;
	widthOptions.depth *= options.edge;
	var widthBox = BABYLON.MeshBuilder.CreateBox("",widthOptions,null);
	var depthOptions = JSON.parse(JSON.stringify(options));
	depthOptions.depth *= 1.5;
	depthOptions.height *= options.edge;
	depthOptions.width *= options.edge;
	var depthBox = BABYLON.MeshBuilder.CreateBox("",depthOptions,null);
	var csg = BABYLON.CSG.FromMesh(outerBox);
	csg.subtractInPlace(BABYLON.CSG.FromMesh(heightBox));
	csg.subtractInPlace(BABYLON.CSG.FromMesh(depthBox));
	csg.subtractInPlace(BABYLON.CSG.FromMesh(widthBox));
	heightBox.dispose();
	depthBox.dispose();
	widthBox.dispose();
	outerBox.dispose();
	return csg.toMesh(name,null,scene,false);
};
wl_util_ExtendedMeshBuilder.createGratedSphere = function(diameter,scene) {
	var sphere = BABYLON.MeshBuilder.CreateSphere("",{ diameter : diameter},scene);
	var csg = BABYLON.CSG.FromMesh(sphere);
	var _g = 0;
	while(_g < 2) {
		var x = _g++;
		var box = BABYLON.MeshBuilder.CreateBox("",{ depth : diameter, width : diameter * 0.1, height : diameter * 0.1});
		box.rotate(new BABYLON.Vector3(wl_util_Random.nextFloat(),wl_util_Random.nextFloat(),wl_util_Random.nextFloat()),wl_util_Random.nextFloat() * Math.PI * 2);
		csg.subtractInPlace(BABYLON.CSG.FromMesh(box));
		box.dispose();
	}
	sphere.dispose();
	return csg.toMesh("",null,scene,false);
};
wl_util_ExtendedMeshBuilder.createBrokenSphere = function(depth,width,scene) {
	var meshes = [];
	var _g1 = Math.ceil(-depth / 2);
	var _g = Math.ceil(depth / 2);
	while(_g1 < _g) {
		var d = _g1++;
		var _g3 = Math.ceil(-width / 2);
		var _g2 = Math.ceil(width / 2);
		while(_g3 < _g2) {
			var d1 = _g3++;
			var box = BABYLON.MeshBuilder.CreateBox("",{ width : 2, height : 2, depth : 2});
			box.rotate(new BABYLON.Vector3(Math.random() * Math.PI * 2,Math.random() * Math.PI * 2,Math.random() * Math.PI * 2),Math.random() * Math.PI * 2);
			meshes.push(box);
		}
	}
	var mesh = BABYLON.Mesh.MergeMeshes(meshes,true,true);
	var _g4 = 0;
	while(_g4 < meshes.length) {
		var m = meshes[_g4];
		++_g4;
		m.dispose();
	}
	scene.addMesh(mesh);
	return mesh;
};
wl_util_ExtendedMeshBuilder.createGround = function(depth,width,scene) {
	var meshes = [];
	var size = Math.ceil(depth * width);
	var sideSize = size / 10;
	var _g1 = 0;
	var _g = depth;
	while(_g1 < _g) {
		var z = _g1++;
		var _g3 = 0;
		var _g2 = width;
		while(_g3 < _g2) {
			var x = _g3++;
			var mesh = BABYLON.MeshBuilder.CreateBox("",{ width : sideSize + wl_util_Random.nextFloat(), height : sideSize + wl_util_Random.nextFloat(), depth : sideSize + wl_util_Random.nextFloat()},null);
			var tmp = width * wl_util_Random.nextFloat();
			mesh.position.x = x * sideSize + tmp;
			var tmp1 = depth * wl_util_Random.nextFloat();
			mesh.position.z = z * sideSize + tmp1;
			mesh.rotate(new BABYLON.Vector3(Math.random() * Math.PI * 2,Math.random() * Math.PI * 2,Math.random() * Math.PI * 2),Math.random() * Math.PI * 2);
			meshes.push(mesh);
		}
	}
	var m = BABYLON.Mesh.MergeMeshes(meshes,true,true);
	var _g4 = 0;
	while(_g4 < meshes.length) {
		var mi = meshes[_g4];
		++_g4;
		mi.dispose();
	}
	return m;
};
wl_util_ExtendedMeshBuilder.prototype = {
	__class__: wl_util_ExtendedMeshBuilder
};
var wl_util_ExtractPixels = function() {
	throw new js__$Boot_HaxeError("Extract pixels is a static class");
};
$hxClasses["wl.util.ExtractPixels"] = wl_util_ExtractPixels;
wl_util_ExtractPixels.__name__ = ["wl","util","ExtractPixels"];
wl_util_ExtractPixels.extract = function(img,sx,sy,w,h) {
	if(sx == null) {
		sx = 0;
	} else {
		sx = sx;
	}
	if(sy == null) {
		sy = 0;
	} else {
		sy = sy;
	}
	if(w == null) {
		w = img.width;
	} else {
		w = w;
	}
	if(h == null) {
		h = img.height;
	} else {
		h = h;
	}
	var canvas = window.document.createElement("canvas");
	var ctx = canvas.getContext("2d",null);
	canvas.width = w;
	canvas.height = h;
	ctx.drawImage(img,-sx,-sy,w,h);
	var id = ctx.getImageData(0,0,w,h);
	return id;
};
wl_util_ExtractPixels.prototype = {
	__class__: wl_util_ExtractPixels
};
var wl_util_LoadManager = $hx_exports["wl"]["util"]["LoadManafer"] = function() {
};
$hxClasses["wl.util.LoadManager"] = wl_util_LoadManager;
wl_util_LoadManager.__name__ = ["wl","util","LoadManager"];
wl_util_LoadManager.get_totalCount = function() {
	return wl_util_LoadManager._totalCount + wl_util_LoadManager.loadersWaiting.length;
};
wl_util_LoadManager.onload = function() {
	wl_util_LoadManager.managerDone = true;
	wl_util_LoadManager.checkAllDone();
};
wl_util_LoadManager.checkAllDone = function() {
	if(wl_util_LoadManager.managerDone || wl_util_LoadManager._totalCount == 0 && wl_util_LoadManager.loadersWaiting.length == 0) {
		wl_util_LoadManager.onComplete();
	}
};
wl_util_LoadManager.onerror = function() {
};
wl_util_LoadManager.onprogress = function(s,p,t) {
	console.log(s + "," + p + "," + t);
};
wl_util_LoadManager.addLoader = function(loaderClass) {
	var ldr = Type.createInstance(loaderClass,[wl_util_LoadManager.loadingManager]);
	wl_util_LoadManager._totalCount++;
	return ldr;
};
wl_util_LoadManager.addManualLoader = function(loader) {
	wl_util_LoadManager.loadersWaiting.push(loader);
};
wl_util_LoadManager.manualLoaderComplete = function(loader) {
	HxOverrides.remove(wl_util_LoadManager.loadersWaiting,loader);
	wl_util_LoadManager.checkAllDone();
};
wl_util_LoadManager.prototype = {
	__class__: wl_util_LoadManager
};
var wl_util_MathUtil = function() {
};
$hxClasses["wl.util.MathUtil"] = wl_util_MathUtil;
wl_util_MathUtil.__name__ = ["wl","util","MathUtil"];
wl_util_MathUtil.clamp = function(low,high,val) {
	if(val < low) {
		return low;
	} else if(val > high) {
		return high;
	} else {
		return val;
	}
};
wl_util_MathUtil.FromVector3 = function(position,sphereRadius) {
	var lat = 90 - Math.acos(position.y / sphereRadius) * 180 / Math.PI;
	var lon = (270 + Math.atan2(position.x,position.z) * 180 / Math.PI) % 360 - 180;
	return [lon,lat];
};
wl_util_MathUtil.componentLerp = function(v1,v2,phase,easex,easey,easez,setTo) {
	if(setTo == null) {
		setTo = new THREE.Vector3();
	} else {
		setTo = setTo;
	}
	setTo.set(easex(1 - phase) * v1.x + easex(phase) * v2.x,easey(1 - phase) * v1.y + easey(phase) * v2.y,easez(1 - phase) * v1.z + easez(phase) * v2.z);
	return setTo;
};
wl_util_MathUtil.getShortestAngle = function(a1,a2) {
	var d = a1 - a2;
	var max = Math.PI * 2;
	var mp = Math.floor((d - -Math.PI) / max);
	return d - mp * max;
};
wl_util_MathUtil.prototype = {
	__class__: wl_util_MathUtil
};
var wl_util_Random = function(seed) {
	this.seed = 123;
	this.Init(seed);
};
$hxClasses["wl.util.Random"] = wl_util_Random;
wl_util_Random.__name__ = ["wl","util","Random"];
wl_util_Random.init = function(seed) {
	wl_util_Random.instance.Init(seed);
};
wl_util_Random.next = function() {
	return wl_util_Random.instance.Next();
};
wl_util_Random.nextFloat = function() {
	return wl_util_Random.instance.NextFloat();
};
wl_util_Random.range = function(low,high) {
	return wl_util_Random.instance.Range(low,high);
};
wl_util_Random.prototype = {
	Init: function(seed) {
		this.seed = seed;
	}
	,Next: function() {
		var a = 16807;
		var m = 2147483647;
		var q = 127773;
		var r = 2836;
		var hi = Math.floor(this.seed / q);
		var lo = Math.floor(this.seed % q);
		var test = a * lo - r * hi;
		if(test < 0) {
			test += m;
		}
		this.seed = test;
		return this.seed;
	}
	,NextFloat: function() {
		return this.Next() / 2147483647;
	}
	,Range: function(low,high) {
		var rnd = this.NextFloat();
		return Math.floor(rnd * (high - low) + low);
	}
	,__class__: wl_util_Random
};
var $_, $fid = 0;
function $bind(o,m) { if( m == null ) return null; if( m.__id__ == null ) m.__id__ = $fid++; var f; if( o.hx__closures__ == null ) o.hx__closures__ = {}; else f = o.hx__closures__[m.__id__]; if( f == null ) { f = function(){ return f.method.apply(f.scope, arguments); }; f.scope = o; f.method = m; o.hx__closures__[m.__id__] = f; } return f; }
$hxClasses["Math"] = Math;
String.prototype.__class__ = $hxClasses["String"] = String;
String.__name__ = ["String"];
$hxClasses["Array"] = Array;
Array.__name__ = ["Array"];
Date.prototype.__class__ = $hxClasses["Date"] = Date;
Date.__name__ = ["Date"];
var Int = $hxClasses["Int"] = { __name__ : ["Int"]};
var Dynamic = $hxClasses["Dynamic"] = { __name__ : ["Dynamic"]};
var Float = $hxClasses["Float"] = Number;
Float.__name__ = ["Float"];
var Bool = Boolean;
Bool.__ename__ = ["Bool"];
var Class = $hxClasses["Class"] = { __name__ : ["Class"]};
var Enum = { };
haxe_Resource.content = [{ name : "colorhilight.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "pixelate.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gdmVjMiBwaXhlbGFtb3VudDsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KDQp2b2lkIG1haW4oKSB7DQoJdmVjMiB1diA9IHZVdjsNCgl1di54ID0gZmxvb3IodXYueCpwaXhlbGFtb3VudC54KS9waXhlbGFtb3VudC54Ow0KCXV2LnkgPSBmbG9vcih1di55KnBpeGVsYW1vdW50LnkpL3BpeGVsYW1vdW50Lnk7DQoJdmVjNCBjID0gdGV4dHVyZTJEKHREaWZmdXNlLHV2KTsNCglnbF9GcmFnQ29sb3IgPSBjOw0KfQ0K"},{ name : "aspect.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gaW50IHR5cGU7DQp1bmlmb3JtIGZsb2F0IGFzcGVjdDsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KdW5pZm9ybSB2ZWMyIHJlc29sdXRpb247DQp1bmlmb3JtIHZlYzQgY29sb3I7DQoNCnZvaWQgbWFpbigpIHsNCglmbG9hdCBtcCA9IDAuMDsNCglmbG9hdCByZXNBc3BlY3QgPSByZXNvbHV0aW9uLngvcmVzb2x1dGlvbi55Ow0KCXZlYzIgdXYgPSB2VXY7DQoJCQ0KCS8vQmxhY2sgbGluZXMgbGVmdCBhbmQgcmlnaHQNCglpZihyZXNBc3BlY3QgPiBhc3BlY3QpDQoJew0KCQlmbG9hdCBkaWYgPSByZXNBc3BlY3QtYXNwZWN0Ow0KCQltcCA9IHV2LnggPiBkaWYvMi4gJiYgdXYueCA8IDEuLWRpZi8yLiA/IDAuIDogMS47DQoJfQ0KCWVsc2UNCgl7DQoJCS8vQmxhY2sgaW5lcyB0b3AgJiBib3R0b20NCgkJZmxvYXQgZGlmID0gYXNwZWN0LXJlc0FzcGVjdDsNCgkJbXAgPSB1di55ID4gZGlmLzIuICYmIHV2LnkgPCAxLi1kaWYvMi4gPyAwLiA6IDEuOw0KCQkNCgl9DQoJDQoJLy9UT0RPIC0gaW4gZmlsbCBjaGFuZ2UgdXYgYWxzby4gDQoJdmVjNCBjID0gbWl4KHRleHR1cmUyRCh0RGlmZnVzZSx1diksIGNvbG9yLG1wKTsNCg0KCWdsX0ZyYWdDb2xvciA9IGM7DQp9DQo"},{ name : "aspect.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "colorhilight.frag", data : "dW5pZm9ybSBmbG9hdCByYW5nZTsNCnVuaWZvcm0gZmxvYXQgdmFsdWUxOw0KdW5pZm9ybSBmbG9hdCB2YWx1ZTI7DQp1bmlmb3JtIGZsb2F0IG9yaWdpbmFsOw0KdW5pZm9ybSBmbG9hdCBhbW91bnQ7DQp1bmlmb3JtIHZlYzQgY29sb3IxOw0KdW5pZm9ybSB2ZWM0IGNvbG9yMjsNCnVuaWZvcm0gdmVjMiB0aWxlOw0KdW5pZm9ybSBzYW1wbGVyMkQgdERpZmZ1c2U7DQp2YXJ5aW5nIHZlYzIgdlV2Ow0KDQp2b2lkIG1haW4oKSB7DQoJdmVjMiB1diA9IHZVdjsNCgl2ZWM0IGMgPSB0ZXh0dXJlMkQodERpZmZ1c2UsdXYqdGlsZSk7DQoJDQoJLy9NYWtlIGNvbnRpbnVvdXMgdHJpYW5nbGUgZnVuY3Rpb24NCglmbG9hdCB2YWwxID0gdmFsdWUxKjIuOw0KCXZhbDEgPSB2YWwxIDwgMS4gPyB2YWwxIDogMi4tdmFsMTsNCglmbG9hdCB2YWwyID0gdmFsdWUyKjIuOw0KCXZhbDEgPSB2YWwyIDwgMS4gPyB2YWwyIDogMi4tdmFsMjsNCgkNCglmbG9hdCB0aW1lb2ZmMSA9IG1vZCh2YWwxLCAxLiArIHJhbmdlKTsNCglmbG9hdCB0aW1lb2ZmMiA9IG1vZCh2YWwyLCAxLiArIHJhbmdlKTsNCgkNCglmbG9hdCBtcDEgPSAoYWJzKGMuciAtIHRpbWVvZmYxKSA+IHJhbmdlKSA/IDEuIDogMC47DQoJZmxvYXQgbXAyID0gKGFicyhjLmcgLSB0aW1lb2ZmMikgPiByYW5nZSkgPyAxLiA6IDAuOw0KCQ0KCWZsb2F0IGF2ZyA9IChjLnIrYy5nK2MuYikvMy47DQoJdmVjNCBhZHMxID0gY29sb3IxICogYWJzKGF2ZyAtIHRpbWVvZmYxKTsNCgl2ZWM0IGFkczIgPSBjb2xvcjIgKiBhYnMoYXZnIC0gdGltZW9mZjIpOw0KCQ0KCXZlYzQgY29sID0gKDEuLSBtcDEpICogYWRzMSArICgxLiAtIG1wMikqYWRzMjsNCgkNCglnbF9GcmFnQ29sb3IgPSBjKm9yaWdpbmFsICsgY29sKmFtb3VudDsNCn0NCg"},{ name : "testshader.frag", data : "I2RlZmluZSBQSSAzLjE0MTU5Mg0KDQp1bmlmb3JtIGZsb2F0IHQ7DQppbiB2ZWMyIHZVVjsNCg0Kdm9pZCBtYWluKCl7DQoJdmVjMiB1diA9IHZVVjsNCgkNCgl2ZWMyIHV2TyA9IHV2Ow0KICAgIHV2LngrPXQqMC4wMTsNCiAgICB1di55Kz10KjAuMDAyNTsNCiAgICBmbG9hdCBpbnRlbnNpdHkgPSANCiAgICAgICAgY29zKHV2LnkqMTUuKyB1di54KjE0LisgdCArIGNvcyh1di55KjAuICt1di54KjE1LikqNS4wICkqNS4gKw0KICAgICAgICBzaW4odXYueSozNS4tIHV2LngqMjQuKyB0KjIuNjcgKyBjb3ModXYueSowLiArdXYueCoxNS4pKjQuNyApKjMuICsNCiAgICAgICAgc2luKHV2LngqMjAuK3V2LnkqMTAuLXQqMi41KSozLjArDQogICAgICAgIHNpbih1di54KiB1di55ICsxLjUrIHQqMC41KSoxLjA7DQogICAgaW50ZW5zaXR5Lz0gMTQuOyANCiAgICAgICAgLy9zaW4odXYueCozMC4wK3QrMTcuMCp1di55KmNvcyh0K3V2LngqNS4wKSkNCiAgICAgICAvLyArc2luKHV2LnkqMTkuKzUwLjA1KmNvcyh1di54KjMuK3QqMC4wMikpKjEuMDsNCiAgICANCiAgICBpbnRlbnNpdHkgPSAxLi1zbW9vdGhzdGVwKDAuMiwgMC4yNSwgaW50ZW5zaXR5KTsNCiAgICANCiAgICBmbG9hdCBkID0gbGVuZ3RoKHV2Ty55LTAuNSk7DQogICAgaW50ZW5zaXR5ICo9IHNtb290aHN0ZXAoMC4wLCAwLjUsIDAuNS1kKTsNCiAgICAvLyBUaW1lIHZhcnlpbmcgcGl4ZWwgY29sb3INCiAgICB2ZWM0IGNvbCA9IHZlYzQoMS4wLCAxLjAsIDEuMCwgMS4wKSppbnRlbnNpdHk7DQoNCgkNCgkNCglnbF9GcmFnQ29sb3IgPSBjb2w7DQp9DQo"},{ name : "rgbshift.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "pixelate.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "gray.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KdW5pZm9ybSBmbG9hdCBncmF5Ow0KDQp2b2lkIG1haW4oKSB7DQoJdmVjMiB1diA9IHZVdjsNCgl2ZWM0IGMgPSB0ZXh0dXJlMkQodERpZmZ1c2UsdXYpOw0KCWZsb2F0IGdyID0gZG90KGMucmdiLCB2ZWMzKDAuMjk5LCAwLjU4NywgMC4xMTQpKTsNCiAgICB2ZWMzIGZjID0gbWl4KGMucmdiLCB2ZWMzKGdyKSwgZ3JheSk7DQoJZ2xfRnJhZ0NvbG9yID12ZWM0KGZjLDEuKTsNCn0NCg"},{ name : "vhs.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gZmxvYXQgaW50ZW5zaXR5Ow0KdW5pZm9ybSBmbG9hdCBqaXR0ZXI7DQp1bmlmb3JtIGZsb2F0IHNpemU7DQp1bmlmb3JtIHNhbXBsZXIyRCB0RGlmZnVzZTsNCnVuaWZvcm0gc2FtcGxlcjJEIHROb2lzZTsNCnVuaWZvcm0gZmxvYXQgdGltZTsNCnVuaWZvcm0gZmxvYXQgaG9sZFRpbWU7DQp1bmlmb3JtIGZsb2F0IGNvbG9yTm9pc2U7DQoNCmZsb2F0IHJhbmQodmVjMiBjbyl7DQogICAgcmV0dXJuIGZyYWN0KHNpbihkb3QoY28ueHkgLHZlYzIoMTIuOTg5OCw3OC4yMzMpKSkgKiA0Mzc1OC41NDUzKTsNCn0NCg0Kdm9pZCBtYWluKCkgew0KCXZlYzIgdXYgPSB2VXY7DQoJDQoJdXYueCArPSAocmFuZCh2ZWMyKHRpbWUqMC4xLCB1di55KjE5MjAuKSktMC41KSowLjAwOCpqaXR0ZXI7DQoJdXYueSArPSAocmFuZCh2ZWMyKHRpbWUpKS0wLjUpKjAuMDEqaml0dGVyOw0KCQ0KCXZlYzQgYmFzZSA9ICh2ZWM0KC0wLjUpK3ZlYzQocmFuZCh2ZWMyKHV2LnkqMTA4MC4sdGltZSkpLHJhbmQodmVjMigxMDgwLix0aW1lKzEuMCkpLHJhbmQodmVjMigxMDgwLix0aW1lKzIuMCkpLDApKSowLjEqY29sb3JOb2lzZTsNCgliYXNlICs9IHRleHR1cmUyRCh0RGlmZnVzZSx1dik7DQoJZmxvYXQgbm9pc2UgPSB0ZXh0dXJlMkQodE5vaXNlLHV2K3ZlYzIodGltZSx0aW1lKjAuMSkpLnI7DQoJDQoJaWYoKG5vaXNlKm1vZCh1di55ICsgaG9sZFRpbWUqMC4yLCAxLikgPiBzaXplKSB8fCANCgkJKG5vaXNlKm1vZCh1di55ICsgKGhvbGRUaW1lKzEuNSkqMC4yLCAxLikgPiBzaXplKSB8fA0KCQkobm9pc2UqbW9kKHV2LnkgKyAoaG9sZFRpbWUrMy4pKjAuMiwgMS4pID4gc2l6ZSkpIGJhc2UrPXZlYzQoMS4pKmludGVuc2l0eTsNCgkNCgkNCglnbF9GcmFnQ29sb3IgPSBiYXNlOw0KfQ0K"},{ name : "standard.frag", data : "dW5pZm9ybSBmbG9hdCBicmlnaHRuZXNzOw0KdW5pZm9ybSBmbG9hdCBnYW1tYTsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KdmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzIgdXYgPSB2VXY7DQoJdmVjNCBjID0gdGV4dHVyZTJEKHREaWZmdXNlLHV2KTsNCgljID0gcG93KGMsIHZlYzQoMS4wL2dhbW1hKSk7DQoJYys9YnJpZ2h0bmVzczsNCglnbF9GcmFnQ29sb3IgPSBjOw0KfQ"},{ name : "cga.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gZmxvYXQgYW1vdW50Ow0KdW5pZm9ybSBzYW1wbGVyMkQgdERpZmZ1c2U7DQp1bmlmb3JtIHZlYzIgcmVzb2x1dGlvbjsNCg0KdW5pZm9ybSB2ZWMzIGNvbG9yc1sxNl07DQoNCnZvaWQgbWFpbigpIHsNCgl2ZWMyIHV2ID0gdlV2Ow0KCXZlYzQgYyA9IHRleHR1cmUyRCh0RGlmZnVzZSx1dik7DQoJZmxvYXQgY2xvc2VzdCA9IDk5OTk5LjsNCiAgICB2ZWMzIHNlbGVjdGVkPXZlYzMoMC4pOw0KICAgIGZvcihpbnQgaSA9IDA7IGkgPCAxNjsgaSsrKQ0KICAgIHsNCiAgICAgICAgZmxvYXQgZCA9IGRpc3RhbmNlKGNvbG9yc1tpXSwgYy5yZ2IpOw0KICAgICAgICBpZihjbG9zZXN0ID4gZCkNCiAgICAgICAgew0KICAgICAgICAgCWNsb3Nlc3QgPSBkOw0KICAgICAgICAgICAgc2VsZWN0ZWQgPSBjb2xvcnNbaV07DQogICAgICAgIH0NCiAgICB9DQoJZ2xfRnJhZ0NvbG9yID0gbWl4KGMsdmVjNChzZWxlY3RlZCwxLiksIGFtb3VudCk7DQp9DQo"},{ name : "shipshader.frag", data : "I2RlZmluZSBQSSAzLjE0MTU5Mg0KDQp1bmlmb3JtIGZsb2F0IHQ7DQppbiB2ZWMyIHZVVjsNCg0Kdm9pZCBtYWluKCl7DQoJdmVjMiB1diA9IHZVVjsNCgkNCgl2ZWMyIHV2TyA9IHV2Ow0KICAgIHV2LngrPXQqMC4wMTsNCiAgICB1di55Kz10KjAuMDAyNTsNCiAgICBmbG9hdCBpbnRlbnNpdHkgPSANCiAgICAgICAgY29zKHV2LnkqMTUuKyB1di54KjE0LisgdCArIGNvcyh1di55KjAuICt1di54KjE1LikqNS4wICkqNS4gKw0KICAgICAgICBzaW4odXYueSozNS4tIHV2LngqMjQuKyB0KjIuNjcgKyBjb3ModXYueSowLiArdXYueCoxNS4pKjQuNyApKjMuICsNCiAgICAgICAgc2luKHV2LngqMjAuK3V2LnkqMTAuLXQqMi41KSozLjArDQogICAgICAgIHNpbih1di54KiB1di55ICsxLjUrIHQqMC41KSoxLjA7DQogICAgaW50ZW5zaXR5Lz0gMTQuOyANCiAgICAgICAgLy9zaW4odXYueCozMC4wK3QrMTcuMCp1di55KmNvcyh0K3V2LngqNS4wKSkNCiAgICAgICAvLyArc2luKHV2LnkqMTkuKzUwLjA1KmNvcyh1di54KjMuK3QqMC4wMikpKjEuMDsNCiAgICANCiAgICBpbnRlbnNpdHkgPSAxLi1zbW9vdGhzdGVwKDAuMSwgMC4yLCBpbnRlbnNpdHkpOw0KICAgIA0KIC8vICAgZmxvYXQgZCA9IGxlbmd0aCh1dk8ueS0wLjUpOw0KICAvLyAgaW50ZW5zaXR5ICo9IHNtb290aHN0ZXAoMC4wLCAwLjUsIDAuNS1kKTsNCiAgICAvLyBUaW1lIHZhcnlpbmcgcGl4ZWwgY29sb3INCiAgICB2ZWM0IGNvbCA9IHZlYzQoMS4wLCAxLjAsIDEuMCwgMS4wKSppbnRlbnNpdHk7DQoNCgkNCgkNCglnbF9GcmFnQ29sb3IgPSBjb2w7DQp9DQo"},{ name : "rgbshift.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gZmxvYXQgcnNoaWZ0Ow0KdW5pZm9ybSBmbG9hdCBnc2hpZnQ7DQp1bmlmb3JtIGZsb2F0IGJzaGlmdDsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KDQp2b2lkIG1haW4oKSB7DQoJdmVjNCBjID0gdGV4dHVyZTJEKHREaWZmdXNlLHZVdik7DQoJZmxvYXQgcm8gPSB0ZXh0dXJlMkQodERpZmZ1c2UsdmVjMih2VXYueC1yc2hpZnQsIHZVdi55KSkucjsNCglmbG9hdCBnbyA9IHRleHR1cmUyRCh0RGlmZnVzZSx2ZWMyKHZVdi54LWdzaGlmdCwgdlV2LnkpKS5nOw0KCWZsb2F0IGJvID0gdGV4dHVyZTJEKHREaWZmdXNlLHZlYzIodlV2LngtYnNoaWZ0LCB2VXYueSkpLmI7DQoJZ2xfRnJhZ0NvbG9yID0gdmVjNChybywgZ28sIGJvLCBjLncpOw0KfQ"},{ name : "henrishader.frag", data : "I2RlZmluZSBQSSAzLjE0MTU5Mg0KDQp1bmlmb3JtIGZsb2F0IHQ7DQppbiB2ZWMyIHZVVjsNCg0Kdm9pZCBtYWluKCl7DQoJdmVjMiB1diA9IHZVVjsNCgkNCgl2ZWMyIHV2TyA9IHV2Ow0KICAgIHV2LngrPXQqMC4wMTsNCiAgICB1di55Kz10KjAuMDAyNTsNCiAgICBmbG9hdCBpbnRlbnNpdHkgPSANCiAgICAgICAgY29zKHV2LnkqMTUuKyB1di54KjE0LisgdCArIGNvcyh1di55KjAuICt1di54KjE1LikqNS4wICkqNS4gKw0KICAgICAgICBzaW4odXYueSozNS4tIHV2LngqMjQuKyB0KjIuNjcgKyBjb3ModXYueSowLiArdXYueCoxNS4pKjQuNyApKjMuICsNCiAgICAgICAgc2luKHV2LngqMjAuK3V2LnkqMTAuLXQqMi41KSozLjArDQogICAgICAgIHNpbih1di54KiB1di55ICsxLjUrIHQqMC41KSoxLjA7DQogICAgaW50ZW5zaXR5Lz0gMTQuOyANCiAgICAgICAgLy9zaW4odXYueCozMC4wK3QrMTcuMCp1di55KmNvcyh0K3V2LngqNS4wKSkNCiAgICAgICAvLyArc2luKHV2LnkqMTkuKzUwLjA1KmNvcyh1di54KjMuK3QqMC4wMikpKjEuMDsNCiAgICANCiAgICBpbnRlbnNpdHkgPSAxLi1zbW9vdGhzdGVwKDAuMSwgMC4yLCBpbnRlbnNpdHkpOw0KICAgIA0KIC8vICAgZmxvYXQgZCA9IGxlbmd0aCh1dk8ueS0wLjUpOw0KICAvLyAgaW50ZW5zaXR5ICo9IHNtb290aHN0ZXAoMC4wLCAwLjUsIDAuNS1kKTsNCiAgICAvLyBUaW1lIHZhcnlpbmcgcGl4ZWwgY29sb3INCiAgICB2ZWM0IGNvbCA9IHZlYzQoMS4wLCAxLjAsIDEuMCwgMS4wKSppbnRlbnNpdHk7DQoNCgkNCgkNCglnbF9GcmFnQ29sb3IgPSBjb2w7DQp9DQo"},{ name : "dof.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ0KICAgIA"},{ name : "gray.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "dof.frag", data : "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"},{ name : "Demo.json", data : "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"},{ name : "cga.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "simple.vert", data : "DQphdHRyaWJ1dGUgdmVjMyBwb3NpdGlvbjsNCmF0dHJpYnV0ZSB2ZWMyIHV2Ow0KDQojaW5jbHVkZTxpbnN0YW5jZXNEZWNsYXJhdGlvbj4NCnVuaWZvcm0gbWF0NCB2aWV3UHJvamVjdGlvbjsNCg0Kb3V0IHZlYzIgdlV2Ow0KDQp2b2lkIG1haW4oKSB7DQoJI2luY2x1ZGU8aW5zdGFuY2VzVmVydGV4Pg0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gdmlld1Byb2plY3Rpb24gKiBmaW5hbFdvcmxkICogdmVjNChwb3NpdGlvbiwgMS4wKTsNCn0"},{ name : "distortedTv.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "standard.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "displacement.frag", data : "I2luY2x1ZGU8aGVscGVyRnVuY3Rpb25zPg0KDQp1bmlmb3JtIGZsb2F0IHNjYWxlWDsNCnVuaWZvcm0gZmxvYXQgc2NhbGVZOw0KdW5pZm9ybSBmbG9hdCB6b29tOw0KdW5pZm9ybSB2ZWMyIG9mZnNldDsNCnVuaWZvcm0gc2FtcGxlcjJEIHRleHR1cmVTYW1wbGVyOwkvLyBvcmlnaW5hbCBjb2xvcg0KdW5pZm9ybSBzYW1wbGVyMkQgdERpc3BNYXA7DQoNCnZhcnlpbmcgdmVjMiB2VVY7DQoNCnZvaWQgbWFpbigpIHsNCgl2ZWMyIHV2ID0gdlVWOw0KCXZlYzQgY2QgPSB0ZXh0dXJlMkQodERpc3BNYXAsKHV2K29mZnNldCkqem9vbSk7DQoJDQoJLy9jYWxjdWxhdGUgb2Zmc2V0DQoJdmVjMiBvZmZzZXQgPXZlYzIoIGNkLnIgKiBzY2FsZVgsIGNkLmcqc2NhbGVZKSAtIHZlYzIoc2NhbGVYKjAuNSxzY2FsZVkqMC41KTsNCgkNCgl2ZWM0IGMgPSB0ZXh0dXJlMkQodGV4dHVyZVNhbXBsZXIsdXYrb2Zmc2V0KTsNCgkNCglnbF9GcmFnQ29sb3IgPSBjOw0KfQ0K"},{ name : "distort.frag", data : "I2luY2x1ZGU8aGVscGVyRnVuY3Rpb25zPg0KDQovLyBzYW1wbGVycw0KdW5pZm9ybSBzYW1wbGVyMkQgdGV4dHVyZVNhbXBsZXI7CS8vIG9yaWdpbmFsIGNvbG9yDQoNCi8vIHVuaWZvcm1zDQp1bmlmb3JtIGZsb2F0IGludGVuc2l0eTsNCnVuaWZvcm0gZmxvYXQgaW50ZW5zaXR5WTsNCnVuaWZvcm0gZmxvYXQgaGVpZ2h0Ow0KdW5pZm9ybSBmbG9hdCBvZmZzZXRZOw0KdW5pZm9ybSBmbG9hdCBicmlnaHRuZXNzOw0KDQovLyB2YXJ5aW5ncw0KdmFyeWluZyB2ZWMyIHZVVjsNCg0Kdm9pZCBtYWluKHZvaWQpDQp7DQoJdmVjMiB1diA9IHZVVjsNCglmbG9hdCBhZGRWYWwgPSAoc3RlcCgwLjUsbW9kKCh1di55KmhlaWdodCtvZmZzZXRZKSwgMS4wKSktMC41KTsNCgl1di54ICs9IGFkZFZhbCppbnRlbnNpdHk7DQogICAgZmxvYXQgYWRkVmFsWSA9IChzdGVwKDAuNSxtb2QoKHV2LngqaGVpZ2h0K29mZnNldFkpLCAxLjApKS0wLjUpOw0KCXV2LnkgKz0gYWRkVmFsWSppbnRlbnNpdHlZOw0KICAgIGdsX0ZyYWdDb2xvciA9IHRleHR1cmUyRCh0ZXh0dXJlU2FtcGxlciwgdXYpK2JyaWdodG5lc3M7DQp9"},{ name : "distortedTv.frag", data : "dW5pZm9ybSBmbG9hdCBkaXN0b3J0QW1vdW50Ow0KdW5pZm9ybSBzYW1wbGVyMkQgdERpZmZ1c2U7DQp1bmlmb3JtIGZsb2F0IHRpbWU7DQp1bmlmb3JtIGZsb2F0IGdyZWVuYW1wbGlmeTsNCnVuaWZvcm0gZmxvYXQgYmx1ZWFtcGxpZnk7DQp1bmlmb3JtIGZsb2F0IHZpZ25BbW91bnQ7DQp1bmlmb3JtIGZsb2F0IG9mZnNldEFtb3VudDsNCnVuaWZvcm0gZmxvYXQgYnJpZ2h0TXVsdGlwbGllcjsNCnVuaWZvcm0gZmxvYXQgYnJpZ2h0TGltaXQ7DQp2YXJ5aW5nIHZlYzIgdlV2Ow0KDQp2b2lkIG1haW4oKQ0Kew0KCXZlYzIgdXYgPSB2VXY7DQogICAgZmxvYXQgb2Zmc2V0ID0gbW9kKGNlaWwodXYueSpkaXN0b3J0QW1vdW50K3RpbWUpKnRpbWUsMC4wMTIpOw0KICAgIHZlYzQgdENvbG9yID0gdGV4dHVyZTJEKHREaWZmdXNlLHZlYzIodXYueCtvZmZzZXRBbW91bnQqb2Zmc2V0LHV2LnkpKTsNCiAgICB0Q29sb3IuZyAqPSBncmVlbmFtcGxpZnk7DQogICAgdENvbG9yLmIgKj0gYmx1ZWFtcGxpZnk7DQogICAgZmxvYXQgdmlnbiA9IDEuMC1sZW5ndGgodmVjMigwLjUsMC41KS11dikqdmlnbkFtb3VudDsNCiAgICANCgl2ZWMzIGJyaWdodG5lc3MgPSB0Q29sb3IucmdiOw0KCXZlYzMgbXAgPSB2ZWMzKDEuKS1zbW9vdGhzdGVwKHZlYzMoYnJpZ2h0TGltaXQpLCB2ZWMzKDEuKSwgYnJpZ2h0bmVzcykqYnJpZ2h0TXVsdGlwbGllcjsNCgl0Q29sb3IqPXZlYzQobXAsMS4pOw0KCQ0KICAgIHRDb2xvciAqPSB2aWduOw0KCWdsX0ZyYWdDb2xvciA9IHRDb2xvcjsNCn0"},{ name : "displacement.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "vhs.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"}];
var __map_reserved = {};
var ArrayBuffer = $global.ArrayBuffer || js_html_compat_ArrayBuffer;
if(ArrayBuffer.prototype.slice == null) {
	ArrayBuffer.prototype.slice = js_html_compat_ArrayBuffer.sliceImpl;
}
var Float32Array = $global.Float32Array || js_html_compat_Float32Array._new;
var Uint8Array = $global.Uint8Array || js_html_compat_Uint8Array._new;
DemoMain.DEMO_READY = new wl_core_Signal();
DemoMain.HILIGHT = BABYLON.Color3.FromHexString("#F12522");
DemoMain.LIGHT = BABYLON.Color3.FromHexString("#F3B129");
DemoMain.BASE_1 = BABYLON.Color3.FromHexString("#03A1DA");
DemoMain.BASE_2 = BABYLON.Color3.FromHexString("#86BF28");
DemoMain.BASE_3 = BABYLON.Color3.FromHexString("#CEDA07");
DemoMain.WHITE = new BABYLON.Color3(1,1,1);
DemoMain.BLACK = BABYLON.Color3.FromHexString("#000000");
DemoMain.historyind = 0;
haxe_crypto_Base64.CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
haxe_crypto_Base64.BYTES = haxe_io_Bytes.ofString(haxe_crypto_Base64.CHARS);
haxe_ds_ObjectMap.count = 0;
js_Boot.__toStr = ({ }).toString;
js_html_compat_Float32Array.BYTES_PER_ELEMENT = 4;
js_html_compat_Uint8Array.BYTES_PER_ELEMENT = 1;
wl_core_Assets._assets = new haxe_ds_StringMap();
wl_core_Config.BEATS_PER_MINUTE = 104;
wl_core_Config.BEATS_PER_BAR = 4;
wl_core_Config.TICKS_PER_BEAT = 12;
wl_core_Config.MUSIC_BEGIN = 500;
wl_core_Config.SONG_PATH = "bg.ogg";
wl_core_Config.ENABLE_FFT = false;
wl_core_Config.MUTED = false;
wl_core_Config.FPS = 24;
wl_core_Config.RESOLUTION = [1280,720];
wl_core_Config.RATIO = 1.7777777777777777;
wl_core_Config.ANTIALIAS = true;
wl_core_Config.ENABLE_SHADOWS = false;
wl_core_Config.CLEAR_COLOR = new BABYLON.Color4(0.0,0.0,0.0);
wl_core_Config.SHADOW_MAP_SIZE = [512,512];
wl_core_Config.SEED = 123;
wl_core_Config.DEBUG = false;
wl_core_Config.TIMELINE = [];
wl_core_TimeSig.ABSOLUTE = "absolute";
wl_core_TimeSig.RELATIVE = "relative";
wl_core_TimeSig.PATTERN = "pattern";
wl_debug_Debug.paused = false;
wl_debug_Debug.objectModifiers = [];
wl_debug_Debug.editMode = false;
wl_debug_Debug.usedFolderNames = [];
wl_debug_ManualControl.parts = [];
wl_debug_ManualControl.storedPoints = [];
wl_demo_CameraController.STOPPED = false;
wl_demo_CameraController.STATIC = "static";
wl_demo_CameraController.LINEAR = "linear";
wl_demo_CameraController.BEZIER = "bezier";
wl_demo_CameraController.FOLLOW = "follow";
wl_sounds_SoundWL.FFT_PRECISION = 1024;
wl_sounds_SoundWL.onSoundLoaded = new wl_core_Signal();
wl_sounds_SoundWL.onSoundComplete = new wl_core_Signal();
wl_sounds_SoundWL.onSoundReady = new wl_core_Signal();
wl_sounds_SoundWL.time = new wl_core_TimeSig();
wl_sounds_SoundWL.volume = 1;
wl_sounds_SoundWL.startTime = 0;
wl_sounds_SoundWL.loaded = false;
wl_sounds_SoundWL.lastFFT = 0;
wl_sounds_SoundWL.FFT = { dbLeft : null, frequencyLeft : null, waveformLeft : null, dbRight : null, frequencyRight : null, waveformRight : null, fftsize : 1024, sampleRate : 44100};
wl_util_LoadManager._totalCount = 0;
wl_util_LoadManager.loadersWaiting = [];
wl_util_LoadManager.managerDone = false;
wl_util_Random.instance = new wl_util_Random(123);
Main.main();
})(typeof exports != "undefined" ? exports : typeof window != "undefined" ? window : typeof self != "undefined" ? self : this, typeof window != "undefined" ? window : typeof global != "undefined" ? global : typeof self != "undefined" ? self : this);
